/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.StockBlankTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDocument;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDocumentIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

public class StockBlankTemplateReportDocumentHandler
implements ReportDocumentHandler<StockBlankReportDocument, StockBlankReportDocumentIndex> {
    StockBlankTemplateReportDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new StockBlankTemplateReportParametersControllerInterceptor());
    }

    @Override
    public Class<StockBlankReportDocument> getEntityType() {
        return StockBlankReportDocument.class;
    }

    @Override
    public Class<StockBlankReportDocumentIndex> getIndexType() {
        return StockBlankReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(StockBlankReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(StockBlankReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(StockBlankReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(StockBlankReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<StockBlankReportDocument> buildDocumentInfo(StockBlankReportDocumentIndex idx) {
        ReportDocumentInfo<StockBlankReportDocument> result = new ReportDocumentInfo<StockBlankReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(StockBlankReportDocument document) {
        return document.getParameters();
    }

    @Override
    public String getReportLaunchHandlerUid(StockBlankReportDocument document) {
        return document.getParameters().getDescription().getUid();
    }
}

