/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersPaneController;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersSupplierVM;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentReportParametersPane;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentReportParametersPaneController;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;

class AgentReportParametersPaneControllerInterceptor
extends ControllerInterceptor<AgentReportParametersPaneVM, AgentReportParametersPaneController> {
    AgentReportParametersPaneControllerInterceptor() {
    }

    protected Class<AgentReportParametersPaneController> getControllerClass() {
        return AgentReportParametersPaneController.class;
    }

    protected void onCreate(AgentReportParametersPaneController controller) {
        EntityBoxWidgetColumn supplierColumn = (EntityBoxWidgetColumn)((TableWidget)controller.getView().getVendorsCard().getContent()).getColumn("supplier");
        supplierColumn.setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
    }

    protected void afterReadData(AgentReportParametersPaneController controller, AgentReportParametersPaneVM model) {
        Notifications.get().submitTask(() -> {
            try {
                ArrayList<AgentReportParametersSupplierVM> resultList = new ArrayList<AgentReportParametersSupplierVM>();
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
                EntityService ec = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                for (OrganizationIndex vendorIndex : ec.search(ServiceInvocationContext.get(), OrganizationIndex.class, query)) {
                    AgentReportParametersSupplierVM reportParameters = new AgentReportParametersSupplierVM();
                    reportParameters.setSupplier(vendorIndex.getSource());
                    resultList.add(reportParameters);
                }
                FxUtil.submitToFxThread(() -> {
                    model.getVendors().clear();
                    model.getVendors().addAll(resultList);
                    MainAgentReportParametersPaneController.forView((MainAgentReportParametersPane)((MainAgentReportParametersPane)controller.getView().getMainCard().getContent())).readData(model.getMain());
                });
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }, Messages.Filling_providers);
    }
}

