/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.api.ReportCategories;
import com.gridnine.xtrip.client.fx.reports.api.TemplateReportLaunchHandler;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportCategory;
import com.gridnine.xtrip.common.reports.model.TemplateReportDescriptionIndex;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Date;
import java.util.function.Consumer;
import javafx.scene.Node;

public abstract class BaseTemplateReportLaunchHandler<D extends BaseTemplateReportDescription>
implements TemplateReportLaunchHandler {
    private final TemplateReportDescriptionIndex index;
    private D descr;
    private final Consumer<EntityModificationEvent> entityModificationHandler;

    protected BaseTemplateReportLaunchHandler(TemplateReportDescriptionIndex idx) {
        this.index = idx;
        this.entityModificationHandler = evt -> {
            for (EntityModification mod : evt.getModifications()) {
                if (!idx.getSource().equals((Object)mod.getReference())) continue;
                this.descr = null;
                break;
            }
        };
        EventBus.get().subscribe(EntityModificationEvent.TYPE, this.entityModificationHandler);
    }

    protected TemplateReportDescriptionIndex getIndex() {
        return this.index;
    }

    @Override
    public final String getUid() {
        return this.index.getSource().getUid();
    }

    @Override
    public final FactoryToolCategory getCategory() {
        if (this.index.getName() != null && (this.index.getName().toLowerCase().contains("\u043e\u0442\u0447\u0435\u0442 \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f") || this.index.getName().toLowerCase().contains("\u043e\u0442\u0447\u0435\u0442 \u0441\u0432\u0435\u0440\u043a\u0438"))) {
            return ReportCategories.DIVERGENCE;
        }
        if (this.index.getReportCategory() == ReportCategory.INTERNAL) {
            return ReportCategories.INTERNAL;
        }
        return ReportCategories.SUPPLIER;
    }

    @Override
    public final String getName() {
        return this.index.getName();
    }

    @Override
    public boolean isDisabled() {
        return this.index.isDisabled();
    }

    @Override
    public void setDisabled(boolean value) throws Exception {
        if (this.index.isDisabled() == value) {
            return;
        }
        EntityService service = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        EntityContainer ctr = service.load(ServiceInvocationContext.get(), this.index.getSource());
        ((BaseTemplateReportDescription)ctr.getEntity()).setDisabled(value);
        ctr.getVersionInfo().setDataSource("fx-reports-settings");
        ctr = service.save(ServiceInvocationContext.get(), ctr, null, true);
        this.index.setDisabled(value);
        this.descr = (BaseTemplateReportDescription)ctr.getEntity();
        this.loadSuDescriptions(this.descr);
    }

    @Override
    public final void launch(Node parent, Runnable callback) {
        if (this.descr == null) {
            Notifications.get().submitTask(() -> {
                EntityContainer ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), this.index.getSource());
                if (ctr == null) {
                    Notifications.get().showMessages(new Message[]{MessageHelper.createErrorMessage((String)com.gridnine.xtrip.client.fx.reports.l10n.Messages.Template_Description_Not_Found, (Object[])new Object[0])});
                    return;
                }
                this.descr = (BaseTemplateReportDescription)ctr.getEntity();
                this.loadSuDescriptions(this.descr);
                this.prepare();
                FxUtil.submitToFxThread(() -> this.launch(this.descr, parent, callback));
            }, com.gridnine.xtrip.client.fx.reports.l10n.Messages.Loading_Template_Description);
        } else {
            Notifications.get().submitTask(() -> {
                this.prepare();
                FxUtil.submitToFxThread(() -> this.launch(this.descr, parent, callback));
            }, com.gridnine.xtrip.client.fx.reports.l10n.Messages.Loading_Template_Description);
        }
    }

    @Override
    public final void relaunch(Node parent, EntityContainer<? extends BaseReportDocument> document, Runnable callback) {
        if (this.descr == null) {
            Notifications.get().submitTask(() -> {
                EntityContainer ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), this.index.getSource());
                if (ctr == null) {
                    Notifications.get().showMessages(new Message[]{MessageHelper.createErrorMessage((String)com.gridnine.xtrip.client.fx.reports.l10n.Messages.Template_Description_Not_Found, (Object[])new Object[0])});
                    return;
                }
                this.descr = (BaseTemplateReportDescription)ctr.getEntity();
                this.loadSuDescriptions(this.descr);
                FxUtil.submitToFxThread(() -> this.relaunch(this.descr, parent, (EntityContainer<BaseReportDocument>)document, callback));
            }, com.gridnine.xtrip.client.fx.reports.l10n.Messages.Loading_Template_Description);
        } else {
            this.relaunch(this.descr, parent, document, callback);
        }
    }

    protected void loadSuDescriptions(D description) throws Exception {
    }

    protected abstract void launch(D var1, Node var2, Runnable var3);

    protected abstract void relaunch(D var1, Node var2, EntityContainer<? extends BaseReportDocument> var3, Runnable var4);

    protected abstract void prepare() throws Exception;

    protected void validatePeriod(BaseTemplateReportParameters params, D description, Consumer<String> errors) {
        TemplateReportPeriodUse periodUse = description.getPeriodUse();
        if (periodUse == TemplateReportPeriodUse.IGNORE) {
            return;
        }
        if (params.getPeriodBegin() == null) {
            errors.accept(L10nResourcesManager.getStr((String)Messages.AllProductsTemplateReportPrepareHandler_reportPramsNoPeriodStart, (Object[])new Object[0]));
        }
        if (params.getPeriodEnd() == null) {
            errors.accept(L10nResourcesManager.getStr((String)Messages.AllProductsTemplateReportPrepareHandler_reportPramsNoPeriodEnd, (Object[])new Object[0]));
        }
        if (description.getMaxPeriodInDays() == null) {
            return;
        }
        if (params.getPeriodBegin() != null) {
            Date periodEndValue = MiscUtil.setDayEndTime((Date)params.getPeriodEnd());
            if (periodEndValue == null) {
                periodEndValue = MiscUtil.setDayEndTime((Date)new Date());
            }
            Date periodBeginValue = MiscUtil.clearTime((Date)params.getPeriodBegin());
            if ((long)(description.getMaxPeriodInDays() * 1000) * 3600L * 24L >= periodEndValue.getTime() - periodBeginValue.getTime()) {
                return;
            }
        }
        errors.accept(L10nResourcesManager.getStr((String)Messages.TemplateReportHelper_maxPeriodExceeded, (Object[])new Object[]{description.getMaxPeriodInDays()}));
    }
}

