/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.TripartiteReportParameters;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

public class ReportParametersLauncherValidator {
    private static String SUPPLIER_ABSENT = Messages.Not_setted_provider;
    private static String BLANK_OWNER_ABSENT = Messages.Not_setted_blank_owner;
    private static String AGENCY_ABSENT = Messages.Not_setted_agency;
    private static String AGENT_ABSENT = Messages.Not_setted_agent;
    private static String CLIENT_ABSENT = Messages.Not_setted_client;
    private static String WRONG_TCH_REPORT_DAY = Messages.Report_period_start_date_must_be_decade_start_date;
    private static String PERIOD_BEGIN_ABSENT = Messages.Necessary_set_start_report_date;
    private static String PERIOD_END_ABSENT = Messages.Necessary_set_end_report_date;
    private static String WRONG_PERIOD_INTERVAL = Messages.Start_report_date_cant_be_later_end_date;
    private static String VENDORS_ABSENT = Messages.No_selected_providers;
    private static int[] TCH_DAYS = new int[]{1, 11, 21};
    private static int MAX_PERIOD_DAYS = 31;
    private static List<String> errorList;
    private static BaseReportParameters params;

    private ReportParametersLauncherValidator() {
    }

    protected static ReportParametersLauncherValidator init(List<String> list, BaseReportParameters params) {
        errorList = list;
        ReportParametersLauncherValidator.params = params;
        return new ReportParametersLauncherValidator();
    }

    protected ReportParametersLauncherValidator validateReportPeriod() {
        if (params instanceof TripartiteReportParameters) {
            this.validateTripartiteReportParametersPeriod();
        } else if (params instanceof BaseTemplateReportParameters) {
            this.validateBaseTemplateReportParametersPeriod();
        } else {
            this.validateReportParametersPeriod();
        }
        return this;
    }

    private void validateBaseTemplateReportParametersPeriod() {
        BaseTemplateReportParameters ibtrp = (BaseTemplateReportParameters)params;
        LocalDate beginDate = DateUtils.asLocalDate((Date)ibtrp.getPeriodBegin());
        LocalDate endDate = DateUtils.asLocalDate((Date)ibtrp.getPeriodEnd());
        for (RequestedParameterValue val : ibtrp.getRequestedParameters()) {
            if (val.getKey().equals("periodBeginP") && beginDate == null) {
                if (val.getValue() == null) {
                    errorList.add(PERIOD_BEGIN_ABSENT);
                    continue;
                }
                beginDate = (LocalDate)val.getValue();
                continue;
            }
            if (!val.getKey().equals("periodEndP")) continue;
            if (val.getValue() == null && endDate == null) {
                errorList.add(PERIOD_END_ABSENT);
                continue;
            }
            endDate = (LocalDate)val.getValue();
        }
        if (beginDate == null && !errorList.contains(PERIOD_BEGIN_ABSENT)) {
            errorList.add(PERIOD_BEGIN_ABSENT);
        }
        if (endDate == null && !errorList.contains(PERIOD_END_ABSENT)) {
            errorList.add(PERIOD_END_ABSENT);
        }
        if (beginDate != null && endDate != null && beginDate.isAfter(endDate)) {
            errorList.add(WRONG_PERIOD_INTERVAL);
        } else if (beginDate != null && endDate != null && endDate.getDayOfYear() - beginDate.getDayOfYear() >= MAX_PERIOD_DAYS) {
            errorList.add(Messages.getReport_period_exceeded(MAX_PERIOD_DAYS));
        }
    }

    private void validateReportParametersPeriod() {
        if (params.getPeriodBegin() == null) {
            errorList.add(PERIOD_BEGIN_ABSENT);
        }
        if (params.getPeriodEnd() == null) {
            errorList.add(PERIOD_END_ABSENT);
        }
        if (params.getPeriodBegin() != null && params.getPeriodEnd() != null && params.getPeriodEnd().before(params.getPeriodBegin())) {
            errorList.add(WRONG_PERIOD_INTERVAL);
        }
    }

    private void validateTripartiteReportParametersPeriod() {
        if (params.getPeriodBegin() == null) {
            errorList.add(PERIOD_BEGIN_ABSENT);
        }
    }

    ReportParametersLauncherValidator validateSupplier() {
        if (((ReportParameters)params).getSupplier() == null) {
            errorList.add(SUPPLIER_ABSENT);
        }
        return this;
    }

    ReportParametersLauncherValidator validateVendors() {
        if (((ClientDebtReportParameters)params).getVendors() == null || ((ClientDebtReportParameters)params).getVendors().isEmpty()) {
            errorList.add(VENDORS_ABSENT);
        }
        return this;
    }

    protected ReportParametersLauncherValidator validateAgency() {
        if (params instanceof BaseTemplateReportParameters) {
            BaseTemplateReportParameters ibtrp = (BaseTemplateReportParameters)params;
            boolean isAgencyPresent = ibtrp.getAgency() != null;
            for (RequestedParameterValue val : ibtrp.getRequestedParameters()) {
                if (!val.getKey().equals("AGENCY") || isAgencyPresent || val.getValue() == null) continue;
                isAgencyPresent = true;
            }
            if (!isAgencyPresent) {
                errorList.add(AGENCY_ABSENT);
            }
        } else if (params.getAgency() == null) {
            errorList.add(AGENCY_ABSENT);
        }
        return this;
    }

    ReportParametersLauncherValidator validateBlankOwner() {
        if (params instanceof BaseTemplateReportParameters) {
            BaseTemplateReportParameters ibtrp = (BaseTemplateReportParameters)params;
            boolean isBlankOwnerPresent = false;
            for (RequestedParameterValue val : ibtrp.getRequestedParameters()) {
                if (!val.getKey().equals("BLANK_OWNER") || val.getValue() == null) continue;
                isBlankOwnerPresent = true;
            }
            if (!isBlankOwnerPresent) {
                errorList.add(BLANK_OWNER_ABSENT);
            }
        } else if (((ReportParameters)params).getBlankOwner() == null) {
            errorList.add(BLANK_OWNER_ABSENT);
        }
        return this;
    }

    ReportParametersLauncherValidator validateClientTripartite() {
        if (((TripartiteReportParameters)params).getClient() == null) {
            errorList.add(CLIENT_ABSENT);
        }
        return this;
    }

    ReportParametersLauncherValidator validateTchDate() {
        if (params.getPeriodBegin().getYear() > 2015 && params.getPeriodBegin().getDay() != TCH_DAYS[0] && params.getPeriodBegin().getDay() != TCH_DAYS[1] && params.getPeriodBegin().getDay() != TCH_DAYS[2]) {
            errorList.add(WRONG_TCH_REPORT_DAY);
        }
        return this;
    }
}

