/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.api.ReportHandlersSupplier;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.BorderPane;
import javafx.util.Pair;

class DocumentsCompactPane
extends BorderPane {
    final DataViewWidget<ReportDocumentInfo<?>> dataView;

    DocumentsCompactPane(ObservableMutex mutex) {
        this.getStyleClass().add((Object)"xtrip-report-documents-compact-pane");
        this.setTop((Node)new Label(Messages.Few_last_formed_reports));
        this.dataView = new DataViewWidget(true, mutex);
        TableColumnSettings columnSettings = new TableColumnSettings();
        columnSettings.setId("date");
        columnSettings.setDisplayName(Messages.Date);
        columnSettings.setSortable(false);
        columnSettings.setPrefWidth(Double.valueOf(150.0));
        TableColumn column = columnSettings.createColumn(ReportDocumentInfo::getCreated);
        column.setSortType(TableColumn.SortType.DESCENDING);
        this.dataView.getTableView().getColumns().add((Object)column);
        columnSettings = new TableColumnSettings();
        columnSettings.setId("caption");
        columnSettings.setDisplayName(Messages.Description);
        columnSettings.setSortable(false);
        this.dataView.getTableView().getColumns().add((Object)columnSettings.createColumn(item -> item.getSource().getCaption()));
        TableColumn column2 = TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo(item.getSource()));
        column2.setId("link");
        this.dataView.getTableView().getColumns().add((Object)column2);
        this.dataView.setDefaultActionHandler(() -> {
            ReportDocumentInfo selected = (ReportDocumentInfo)this.dataView.getTableView().getSelectionModel().getSelectedItem();
            if (selected != null) {
                RootEntityEditingService.navigateTo(selected.getSource());
            }
        });
        this.dataView.setHandler(new DataViewHandler<ReportDocumentInfo<?>>(){

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                Notifications.get().submitTask(() -> {
                    try {
                        this.loadData();
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }, this.getMutex());
            }

            private void loadData() throws Exception {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                ArrayList handlers = new ArrayList();
                for (ReportHandlersSupplier supplier : ClientRegistry.get().allOf(ReportHandlersSupplier.TYPE).values()) {
                    handlers.addAll(supplier.getDocumentHandlers());
                }
                int count = handlers.size();
                MiscUtil.Pair[] queries = new MiscUtil.Pair[count];
                for (int i = 0; i < count; ++i) {
                    ReportDocumentHandler handler = (ReportDocumentHandler)handlers.get(i);
                    queries[i] = new MiscUtil.Pair(handler.getIndexType(), (Object)handler.createRecentDocumentsQuery());
                    ((SearchQuery)queries[i].getSecond()).setLimit(this.getLimit());
                }
                List[] multiSearchResult = entityService.multiSearch(sic, queries);
                ArrayList docInfos = new ArrayList();
                for (int i = 0; i < count; ++i) {
                    for (EntityIndex idx : multiSearchResult[i]) {
                        docInfos.add(((ReportDocumentHandler)handlers.get(i)).buildDocumentInfo(idx));
                    }
                }
                docInfos.sort((info1, info2) -> MiscUtil.compare((Comparable)info2.getCreated(), (Comparable)info1.getCreated(), (boolean)true));
                FxUtil.waitForFxThread(() -> this.getData().setAll((Collection)(docInfos.size() <= this.getLimit() ? docInfos : new ArrayList(docInfos.subList(0, this.getLimit())))));
            }

            protected int getOffset() {
                return 0;
            }

            protected int getLimit() {
                return 10;
            }
        });
        this.setCenter((Node)this.dataView);
    }
}

