/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.reports.api.ReportTasksMonitor;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.DocumentsActions;
import com.gridnine.xtrip.client.fx.reports.manager.DocumentsCompactPane;
import com.gridnine.xtrip.client.fx.reports.manager.DocumentsFullPane;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportTaskInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.scene.Node;

class DocumentsTile
extends Tile<DocumentsCompactPane, DocumentsFullPane> {
    private final Consumer<ReportTasksMonitor.TasksListEvent> tasksListHandler = evt -> this.handleNewTasksList(evt.getAllTasks());
    private Set<String> finishedTasks;

    DocumentsTile(ObservableMutex mutex) {
        super("documents", Messages.Done_reports, (Node)new DocumentsCompactPane(mutex), (Node)new DocumentsFullPane(mutex));
        this.expandedProperty().addListener((src, o, n) -> {
            if (n.booleanValue()) {
                this.getActions().setAll((Object[])DocumentsActions.values());
            } else {
                this.getActions().clear();
            }
        });
        ((DocumentsFullPane)this.getFullNode()).getSelectedItems().addListener(src -> this.revalidateActions());
        EventBus.get().subscribe(ReportTasksMonitor.TasksListEvent.TYPE, this.tasksListHandler);
    }

    private void handleNewTasksList(List<ReportTaskInfo> tasksList) {
        boolean hasNewFinishedTasks = false;
        HashSet<String> newFinishedTasks = new HashSet<String>();
        for (ReportTaskInfo taskInfo : tasksList) {
            if (!taskInfo.getState().isFinished()) continue;
            newFinishedTasks.add(taskInfo.getTaskId());
            if (this.finishedTasks == null || this.finishedTasks.contains(taskInfo.getTaskId())) continue;
            hasNewFinishedTasks = true;
        }
        this.finishedTasks = newFinishedTasks;
        if (hasNewFinishedTasks) {
            FxUtil.submitToFxThread(() -> ((DocumentsCompactPane)this.getCompactNode()).dataView.reloadData());
        }
    }

    void init() {
        FxUtil.submitToFxThread(() -> ((DocumentsCompactPane)this.getCompactNode()).dataView.reloadData());
        ((DocumentsFullPane)this.getFullNode()).init();
    }

    void dispose() {
        EventBus.get().unsubscribe(this.tasksListHandler);
    }
}

