/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchEvent;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.HandlersListPane;
import com.gridnine.xtrip.client.fx.reports.manager.RecentReportsTracker;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;

class LaunchersCompactPane
extends BorderPane {
    private final HandlersListPane handlersListPane;
    private final Consumer<ReportLaunchEvent> launchHandler = evt -> {
        try {
            this.loadHandlers();
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    };

    LaunchersCompactPane() {
        this.getStyleClass().add((Object)"xtrip-report-launchers-compact-pane");
        this.setTop((Node)new Label(Messages.Few_last_reports));
        this.handlersListPane = new HandlersListPane();
        this.setCenter((Node)this.handlersListPane);
        EventBus.get().subscribe(ReportLaunchEvent.TYPE, this.launchHandler);
    }

    void setLauncher(Consumer<ReportLaunchHandler> value) {
        this.handlersListPane.setLauncher(value);
    }

    void loadHandlers() throws Exception {
        List<ReportLaunchHandler> recent = RecentReportsTracker.getRecent();
        FxUtil.submitToFxThread(() -> this.handlersListPane.populate(recent));
    }

    void dispose() {
        EventBus.get().unsubscribe(this.launchHandler);
    }
}

