/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportsHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.HandlersListPane;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

class LaunchersFullPane
extends BorderPane {
    final BooleanProperty initialized = new SimpleBooleanProperty();
    private final ObservableMutex mutex;
    private final StackPane indicatorPane;
    private final Label captionLabel = new Label();
    private final SearchTextField patternField;
    private final CardsContainer cardsPane;
    private List<ReportLaunchHandler> loadedHandlers = Collections.emptyList();
    private Consumer<ReportLaunchHandler> launcher;

    LaunchersFullPane() {
        this.getStyleClass().add((Object)"xtrip-report-launchers-full-pane");
        this.mutex = new ObservableMutex();
        ArrayList<Object> nodes = new ArrayList<Object>();
        Button button = new Button();
        button.setGraphic((Node)new IconNode((IconShape)StandardIconShapes.RELOAD_12x12, (Styleable)button, (IconIntention)StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
        button.getStyleClass().add((Object)"xtrip-button");
        UiUtil.setTooltip((Node)button, (String)Messages.Refresh_list_available_forming_reports);
        button.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)Bindings.not((ObservableBooleanValue)this.initialized), (ObservableBooleanValue)this.mutex.acquiredProperty()));
        button.setOnAction(evt -> {
            this.captionLabel.setText(Messages.Loading_list_available_reports);
            Notifications.get().submitTask(this::loadHandlers, this.mutex);
        });
        nodes.add(button);
        this.indicatorPane = new StackPane();
        GridPane.setHgrow((Node)this.indicatorPane, (Priority)Priority.NEVER);
        nodes.add(this.indicatorPane);
        GridPane.setHgrow((Node)this.captionLabel, (Priority)Priority.ALWAYS);
        nodes.add(this.captionLabel);
        this.patternField = new SearchTextField(){

            public void clear() {
                super.clear();
                LaunchersFullPane.this.updateCards();
            }
        };
        GridPane.setHgrow((Node)this.patternField, (Priority)Priority.NEVER);
        this.patternField.setPromptText(Messages.Find);
        this.patternField.setOnKeyReleased(evt -> this.updateCards());
        nodes.add(this.patternField);
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"header-pane");
        pane.addRow(0, nodes.toArray(new Node[nodes.size()]));
        this.setTop((Node)pane);
        this.cardsPane = new CardsContainer();
        ScrollPane sp = new ScrollPane((Node)this.cardsPane);
        sp.getStyleClass().add((Object)"edge-to-edge");
        sp.setFitToWidth(true);
        sp.setFitToHeight(true);
        this.setCenter((Node)sp);
        this.mutex.acquiredProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                if (this.indicatorPane.getChildren().isEmpty()) {
                    this.indicatorPane.getChildren().add((Object)new CustomProgressIndicator());
                }
            } else {
                this.indicatorPane.getChildren().clear();
            }
        });
    }

    protected void updateCards() {
        String pattern = TextUtil.isBlank((String)this.patternField.getText()) ? null : this.patternField.getText().toLowerCase(Locale.ROOT);
        Predicate<ReportLaunchHandler> filter = pattern == null ? handler -> true : handler -> handler.getName().toLowerCase(Locale.ROOT).contains(pattern);
        this.cardsPane.getCards().setAll(this.buildCards(this.loadedHandlers.stream().filter(filter)));
    }

    private List<Card<Node>> buildCards(Stream<ReportLaunchHandler> handlers) {
        HashMap category2tools = new HashMap();
        handlers.forEach(handler -> {
            ArrayList<ReportLaunchHandler> list = (ArrayList<ReportLaunchHandler>)category2tools.get(handler.getCategory());
            if (list == null) {
                list = new ArrayList<ReportLaunchHandler>();
                category2tools.put(handler.getCategory(), list);
            }
            list.add((ReportLaunchHandler)handler);
        });
        ArrayList<Card<Node>> result = new ArrayList<Card<Node>>();
        category2tools.entrySet().stream().sorted((entry1, entry2) -> FactoryToolCategory.COMPARATOR.compare(entry1.getKey(), entry2.getKey())).forEach(entry -> {
            Collections.sort((List)entry.getValue(), ReportLaunchHandler.COMPARATOR);
            HandlersListPane hlp = new HandlersListPane();
            hlp.setLauncher(this.launcher);
            hlp.populate((List)entry.getValue());
            result.add(new Card(((FactoryToolCategory)entry.getKey()).getId(), UiCardsContainer.Style.STATIC, ((FactoryToolCategory)entry.getKey()).getName(), (Node)hlp));
        });
        return result;
    }

    void setLauncher(Consumer<ReportLaunchHandler> value) {
        this.launcher = value;
        for (Card card : this.cardsPane.getCards()) {
            ((HandlersListPane)card.getContent()).setLauncher(value);
        }
    }

    void loadHandlers() throws Exception {
        ArrayList handlers = new ArrayList();
        ReportsHelper.enumerateAvailableHandlers(handlers::add, false);
        FxUtil.waitForFxThread(() -> {
            this.loadedHandlers = handlers;
            this.updateCards();
            this.captionLabel.setText(null);
        });
    }
}

