/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.reports.api.ReportTasksMonitor;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportTaskInfo;
import java.util.EnumMap;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

class QueueCompactPane
extends StackPane {
    private final Label labelEnqueued;
    private final Label labelRunning;
    private final Label labelFinished;
    private BooleanValueWidget allTasksWidget;

    QueueCompactPane() {
        this.getStyleClass().add((Object)"xtrip-report-tasks-compact-pane");
        GridPane pane = new GridPane();
        this.allTasksWidget = new BooleanValueWidget(false, false);
        this.allTasksWidget.setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean object) {
                return Boolean.TRUE.equals(object) ? Messages.All_tasks : Messages.Only_started_by_me_tasks;
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        this.allTasksWidget.setValue(false);
        this.allTasksWidget.valueProperty().addListener((s, o, n) -> ReportTasksMonitor.force());
        GridPane.setColumnSpan((Node)this.allTasksWidget, (Integer)2);
        pane.addRow(0, new Node[]{this.allTasksWidget});
        Label caption = new Label(Messages.Waiting_for_execution);
        caption.getStyleClass().add((Object)"caption");
        this.labelEnqueued = new Label("n/a");
        this.labelEnqueued.getStyleClass().add((Object)"value");
        pane.addRow(1, new Node[]{caption, this.labelEnqueued});
        caption = new Label(Messages.In_progress);
        caption.getStyleClass().add((Object)"caption");
        this.labelRunning = new Label("n/a");
        this.labelRunning.getStyleClass().add((Object)"value");
        pane.addRow(2, new Node[]{caption, this.labelRunning});
        caption = new Label(Messages.Executed);
        caption.getStyleClass().add((Object)"caption");
        this.labelFinished = new Label("n/a");
        this.labelFinished.getStyleClass().add((Object)"value");
        pane.addRow(3, new Node[]{caption, this.labelFinished});
        this.getChildren().add((Object)pane);
    }

    boolean isAllTasks() {
        return this.allTasksWidget.getValue();
    }

    void populate(List<ReportTaskInfo> tasks) {
        EnumMap<AsyncTaskAssignment.TaskState, Integer> counts = new EnumMap<AsyncTaskAssignment.TaskState, Integer>(AsyncTaskAssignment.TaskState.class);
        for (ReportTaskInfo task : tasks) {
            Integer count = (Integer)counts.get(task.getState());
            if (count == null) {
                counts.put(task.getState(), 1);
                continue;
            }
            counts.put(task.getState(), count + 1);
        }
        Integer count = (Integer)counts.get(AsyncTaskAssignment.TaskState.ENQUEUED);
        this.labelEnqueued.setText(count == null ? "0" : count.toString());
        count = (Integer)counts.get(AsyncTaskAssignment.TaskState.RUNNING);
        this.labelRunning.setText(count == null ? "0" : count.toString());
        Integer count1 = (Integer)counts.get(AsyncTaskAssignment.TaskState.COMPLETED);
        Integer count2 = (Integer)counts.get(AsyncTaskAssignment.TaskState.INTERRUPTED);
        this.labelFinished.setText(String.valueOf((count1 == null ? 0 : count1) + (count2 == null ? 0 : count2)));
    }
}

