/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportTaskInfo;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportsService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import java.text.Format;
import java.util.List;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

class TaskInfoPane
extends GridPane {
    TaskInfoPane(ReportTaskInfo taskInfo) {
        Label messageLabel;
        this.getStyleClass().add((Object)"task-pane");
        this.setMaxWidth(Double.MAX_VALUE);
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPercentWidth(50.0);
        this.getColumnConstraints().add((Object)cc);
        cc = new ColumnConstraints();
        cc.setPercentWidth(50.0);
        this.getColumnConstraints().add((Object)cc);
        DateFormat dtf = LocaleManager.get().getCurrentLocaleData().getDateTimeFormat();
        DateFormat df = LocaleManager.get().getCurrentLocaleData().getDateFormat();
        Label createdLabel = new Label(TextUtil.format((Format)dtf, (Object)taskInfo.getCreated()));
        Label titleLabel = new Label(taskInfo.getReportTitle());
        Label periodLabel = new Label(taskInfo.getPeriodBegin() == null && taskInfo.getPeriodEnd() == null ? "" : TextUtil.format((Format)df, (Object)taskInfo.getPeriodBegin(), (String)"??") + " \u2014 " + TextUtil.format((Format)df, (Object)taskInfo.getPeriodEnd(), (String)"??"));
        Label ownerLabel = new Label(taskInfo.getOwner());
        ProgressBar pb = new ProgressBar((double)taskInfo.getCurrentProgress() / 100.0);
        Button button = new Button();
        button.getStyleClass().add((Object)"xtrip-button");
        HyperlinkWidget logLink = new HyperlinkWidget();
        logLink.setText(Messages.Journal);
        logLink.setOnAction(evt -> this.showLog(taskInfo.getLog()));
        switch (taskInfo.getState()) {
            case ENQUEUED: {
                button.setGraphic((Node)new IconNode((IconShape)StandardIconShapes.CANCEL, (Styleable)button, (IconIntention)StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
                UiUtil.setTooltip((Node)button, (String)Messages.Cancel_execution);
                button.setOnAction(evt -> this.doCancel(taskInfo));
                messageLabel = new Label(Messages.Waiting_execution);
                break;
            }
            case RUNNING: {
                button.setGraphic((Node)new IconNode((IconShape)StandardIconShapes.ABORT, (Styleable)button, (IconIntention)StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
                UiUtil.setTooltip((Node)button, (String)Messages.Interrupt_execution);
                button.setOnAction(evt -> Dialog.confirm((Node)this, (String)Messages.Interrupt_forming_report, null, (String)Messages.Interrupt, () -> this.doCancel(taskInfo), null));
                if (TextUtil.isBlank((String)taskInfo.getCurrentMessage())) {
                    messageLabel = new Label(Messages.Executing);
                    break;
                }
                messageLabel = new Label(taskInfo.getCurrentMessage());
                break;
            }
            case COMPLETED: {
                if (taskInfo.getDocument() == null) {
                    button.setVisible(false);
                } else {
                    button.getStyleClass().add((Object)"view");
                    button.setGraphic((Node)new IconNode((IconShape)StandardIconShapes.BOX_NAVIGATE, (Styleable)button, (IconIntention)StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
                    UiUtil.setTooltip((Node)button, (String)(Messages.Open_doc_with_report_data + taskInfo.getDocument().getCaption()));
                    button.setOnAction(evt -> RootEntityEditingService.navigateTo((EntityReference)taskInfo.getDocument()));
                }
                pb.setProgress(1.0);
                if (taskInfo.getError() != null) {
                    HyperlinkWidget widget = new HyperlinkWidget();
                    widget.setText(Messages.Executed_with_errors);
                    widget.setOnAction(evt -> Dialog.error((Node)this, (Throwable)taskInfo.getError()));
                    messageLabel = widget;
                    break;
                }
                messageLabel = new Label(Messages.Executed2);
                break;
            }
            case INTERRUPTED: {
                button.setVisible(false);
                messageLabel = new Label(Messages.Execution_interrupted);
                break;
            }
            default: {
                messageLabel = new Label(Messages.Unknown_task_status);
            }
        }
        GridPane pane1 = new GridPane();
        pane1.getColumnConstraints().add((Object)new ColumnConstraints());
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setHgrow(Priority.SOMETIMES);
        pane1.getColumnConstraints().add((Object)cc2);
        createdLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        createdLabel.setMaxWidth(Double.NEGATIVE_INFINITY);
        GridPane.setRowIndex((Node)createdLabel, (Integer)0);
        GridPane.setColumnIndex((Node)createdLabel, (Integer)0);
        titleLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setRowIndex((Node)titleLabel, (Integer)0);
        GridPane.setColumnIndex((Node)titleLabel, (Integer)1);
        pb.setMaxWidth(Double.MAX_VALUE);
        GridPane.setRowIndex((Node)pb, (Integer)1);
        GridPane.setColumnIndex((Node)pb, (Integer)0);
        GridPane.setColumnSpan((Node)pb, (Integer)2);
        pane1.getChildren().addAll((Object[])new Node[]{createdLabel, titleLabel, pb});
        GridPane pane2 = new GridPane();
        pane2.getColumnConstraints().add((Object)new ColumnConstraints());
        ColumnConstraints cc3 = new ColumnConstraints();
        cc3.setHgrow(Priority.SOMETIMES);
        pane2.getColumnConstraints().add((Object)cc3);
        pane2.getColumnConstraints().add((Object)new ColumnConstraints(Double.NEGATIVE_INFINITY, -1.0, Double.NEGATIVE_INFINITY));
        periodLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        periodLabel.setMaxWidth(Double.NEGATIVE_INFINITY);
        GridPane.setConstraints((Node)periodLabel, (int)0, (int)0);
        ownerLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setConstraints((Node)ownerLabel, (int)1, (int)0);
        GridPane.setConstraints((Node)logLink, (int)2, (int)0);
        GridPane.setConstraints((Node)button, (int)3, (int)0, (int)1, (int)2);
        GridPane.setFillHeight((Node)button, (Boolean)Boolean.FALSE);
        GridPane.setFillWidth((Node)button, (Boolean)Boolean.FALSE);
        messageLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setConstraints((Node)messageLabel, (int)0, (int)1, (int)3, (int)1);
        pane2.getChildren().addAll((Object[])new Node[]{periodLabel, ownerLabel, logLink, button, messageLabel});
        this.addRow(0, new Node[]{pane1, pane2});
    }

    private void doCancel(ReportTaskInfo taskInfo) {
        Notifications.get().submitTask(() -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            ReportsService reportsService = (ReportsService)RpcServiceManager.get().getService(ReportsService.class);
            reportsService.cancelTask(sic, taskInfo.getTaskId());
        }, Messages.Canceling_forming_report);
    }

    private void showLog(List<Message> log) {
        StringBuilder buf = new StringBuilder();
        if (log.isEmpty()) {
            buf.append(Messages.No_messages);
        } else {
            L10nResourcesManager l10nResourceManager = LocaleManager.get().getL10nResourceManager();
            for (Message message : log) {
                buf.append(message.getType());
                buf.append(": ");
                buf.append(l10nResourceManager.getMessage(message.getMessage()));
                buf.append('\n');
                if (TextUtil.isBlank((String)message.getDetails())) continue;
                buf.append(Messages.Extra_info);
                buf.append(message.getDetails());
                buf.append("\n\n");
            }
        }
        TextAreaWidget widget = new TextAreaWidget(true);
        widget.getViewState().setNotEditable(true);
        widget.setValue(buf.toString());
        new Dialog().setTitle(Messages.Task_execution_journal).setBody((Node)widget).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close).setExpandToParent(true).show((Node)this);
    }
}

