/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.TemplatesCompactPane;
import com.gridnine.xtrip.client.fx.reports.manager.TemplatesFullPane;
import com.gridnine.xtrip.client.fx.reports.manager.templatecreate.CreateTemplateHandler;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.copy.CopyEntityActionHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportEntityHelper;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.TemplateReportDescriptionIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.util.StringConverter;

enum TemplatesActions implements TileAction<TemplatesCompactPane, TemplatesFullPane>
{
    CREATE{

        public String getName(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Create;
        }

        public String getDescription(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Add_new_report_template;
        }

        public boolean isEnabled(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return true;
        }

        public void execute(Control source, Tile<TemplatesCompactPane, TemplatesFullPane> tile, boolean alt) {
            ArrayList<RootEntityHandler> handlers = new ArrayList<RootEntityHandler>();
            for (RootEntityHandler entityHandler : ClientRegistry.get().allOf(RootEntityHandler.TYPE).values()) {
                if (!BaseTemplateReportDescription.class.isAssignableFrom(entityHandler.getEntityClass())) continue;
                handlers.add(entityHandler);
            }
            ComboBoxWidget widget = new ComboBoxWidget(false);
            widget.setItemsSupplier(() -> handlers);
            widget.setConverter(new StringConverter<RootEntityHandler<BaseTemplateReportDescription, ?>>(){

                public String toString(RootEntityHandler<BaseTemplateReportDescription, ?> object) {
                    return object == null ? null : RootEntityHandler.format(object);
                }

                public RootEntityHandler<BaseTemplateReportDescription, ?> fromString(String string) {
                    return null;
                }
            });
            widget.setNoNulls(true);
            if (!handlers.isEmpty()) {
                widget.setValue(handlers.get(0));
            }
            widget.guessPrefWidth();
            widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
            GridContainer generalContainer = new GridContainer();
            generalContainer.getCells().add((Object)new GridCell(Messages.Template_Type, (Node)widget));
            ValueHolder widgetHolder = new ValueHolder();
            widget.valueProperty().addListener((observable, oldValue, newValue) -> {
                GridCell gridCell;
                CreateTemplateHandler createHandler = CreateTemplateHandler.forTemplateClass(newValue.getEntityClass());
                int size = generalContainer.getCells().size();
                if (size > 1) {
                    generalContainer.getCells().remove(1, size);
                }
                if (createHandler != null && (gridCell = createHandler.createGridCell()) != null) {
                    generalContainer.getCells().add(gridCell);
                    widgetHolder.set((Object)gridCell.getPayload());
                }
            });
            Dialog dialog = new Dialog().setTitle(Messages.Choose_report_template).setBody((Node)generalContainer).setAutoClose(false);
            dialog.setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Add, () -> {
                RootEntityHandler handler = RootEntityHandler.forId((String)((RootEntityHandler)widget.getValue()).getId());
                DataTransferPackage dtp = new DataTransferPackage(new EntityContainer(handler.getEntityClass()));
                Class templateClass = ((RootEntityHandler)widget.getValue()).getEntityClass();
                CreateTemplateHandler createHandler = CreateTemplateHandler.forTemplateClass(templateClass);
                if (createHandler != null) {
                    createHandler.onCreate((Node)widgetHolder.get(), dtp);
                }
                RootEntityActivityHandler.editNew((DataTransferPackage)dtp);
                dialog.close();
            }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).show((Node)source);
        }
    }
    ,
    EDIT{

        public String getName(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Edit;
        }

        public String getDescription(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Open_report_templ_in_for_edit_another_tab;
        }

        public boolean isEnabled(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).selectionPresentProperty().get() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItem() != null;
        }

        public void execute(Control source, Tile<TemplatesCompactPane, TemplatesFullPane> tile, boolean alt) {
            RootEntityEditingService service = RootEntityEditingService.get();
            if (service == null) {
                return;
            }
            List items = tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).getSelectedItems() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItems();
            boolean bgLoad = false;
            for (TemplateReportDescriptionIndex item : items) {
                service.open(item.getSource(), true, null, bgLoad);
                bgLoad = true;
            }
        }
    }
    ,
    DELETE{

        public String getName(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Delete;
        }

        public String getDescription(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Delete_lighting_template;
        }

        public boolean isEnabled(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).selectionPresentProperty().get() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItem() != null;
        }

        public void execute(Control source, Tile<TemplatesCompactPane, TemplatesFullPane> tile, boolean alt) {
            List items = tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).getSelectedItems() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItems();
            if (items.isEmpty()) {
                return;
            }
            Dialog.confirm((Node)source, (String)Messages.Delete_template, null, (String)Messages.Delete, () -> Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask((Collection)items.stream().map(TemplateReportDescriptionIndex::getSource).collect(Collectors.toList()))), null);
        }
    }
    ,
    COPY{

        public String getName(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Copy;
        }

        public String getDescription(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Copy_Description;
        }

        public boolean isEnabled(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).selectionPresentProperty().get() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItem() != null;
        }

        public void execute(Control source, Tile<TemplatesCompactPane, TemplatesFullPane> tile, boolean alt) {
            List items = tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).getSelectedItems() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItems();
            Notifications.get().submitTask(() -> {
                ArrayList<DataTransferPackage> loadedTemplates = new ArrayList<DataTransferPackage>();
                CopyEntityActionHandler copyHandler = Objects.requireNonNull(CopyEntityActionHandler.forEntityClass(BaseTemplateReportDescription.class));
                for (TemplateReportDescriptionIndex item : items) {
                    DataTransferPackage dtp = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), item.getSource(), null);
                    if (dtp == null || dtp.getContainer() == null) {
                        Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Template_Description_Not_Found, (Object[])new Object[0])});
                        continue;
                    }
                    loadedTemplates.add(dtp);
                }
                FxUtil.submitToFxThread(() -> loadedTemplates.forEach(dtp -> {
                    try {
                        RootEntityActivityHandler.editNew((DataTransferPackage)copyHandler.createCopy(dtp));
                    }
                    catch (Exception ex) {
                        ErrorHandler.handle((Throwable)ex);
                    }
                }));
            }, Messages.Loading_Templates_For_Copy);
        }
    }
    ,
    EXPORT{

        public String getName(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Export;
        }

        public String getDescription(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return Messages.Export_Templates;
        }

        public boolean isEnabled(Tile<TemplatesCompactPane, TemplatesFullPane> tile) {
            return true;
        }

        public void execute(Control source, Tile<TemplatesCompactPane, TemplatesFullPane> tile, boolean alt) {
            List items = tile.isExpanded() ? ((TemplatesFullPane)tile.getFullNode()).getSelectedItems() : ((TemplatesCompactPane)tile.getCompactNode()).dataView.getTableView().getSelectionModel().getSelectedItems();
            SearchQuery query = ((TemplatesFullPane)tile.getFullNode()).buildQuery();
            ArrayList columnSettings = new ArrayList();
            ((TemplatesFullPane)tile.getFullNode()).getTableView().getColumns().forEach(column -> {
                TableColumnSettings settings;
                if (column.isVisible() && (settings = TableColumnSettings.getFor((TableColumn)column)) != null) {
                    columnSettings.add(settings);
                }
            });
            ExportEntityHelper.showExportEntitiesDialog((Node)source, TemplateReportDescriptionIndex.class, (List)items, (SearchQuery)query, columnSettings);
        }
    };


    public double getWeight() {
        return this.ordinal();
    }
}

