/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.TemplatesActions;
import com.gridnine.xtrip.client.fx.reports.manager.TemplatesCompactPane;
import com.gridnine.xtrip.client.fx.reports.manager.TemplatesFullPane;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import java.util.function.Consumer;
import javafx.scene.Node;

class TemplatesTile
extends Tile<TemplatesCompactPane, TemplatesFullPane> {
    private final Consumer<EntityModificationEvent> entityModificationEventListener;

    TemplatesTile(ObservableMutex mutex) {
        super("templates", Messages.Report_templates, (Node)new TemplatesCompactPane(), (Node)new TemplatesFullPane(mutex));
        this.getActions().addAll((Object[])TemplatesActions.values());
        ((TemplatesCompactPane)this.getCompactNode()).dataView.getTableView().getSelectionModel().selectedItemProperty().addListener(src -> this.revalidateActions());
        ((TemplatesFullPane)this.getFullNode()).selectionPresentProperty().addListener(src -> this.revalidateActions());
        this.expandedProperty().addListener(src -> this.revalidateActions());
        this.entityModificationEventListener = evt -> {
            for (EntityModification mod : evt.getModifications()) {
                if (mod.getReference() == null || !BaseTemplateReportDescription.class.isAssignableFrom(mod.getReference().getType())) continue;
                FxUtil.submitToFxThread(() -> {
                    ((TemplatesCompactPane)this.getCompactNode()).dataView.reloadData();
                    ((TemplatesFullPane)this.getFullNode()).reloadData();
                });
                return;
            }
        };
        EventBus.get().subscribe(EntityModificationEvent.TYPE, this.entityModificationEventListener);
    }

    void init() {
        FxUtil.submitToFxThread(() -> ((TemplatesCompactPane)this.getCompactNode()).dataView.reloadData());
    }
}

