/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager.templatecreate;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.templatecreate.CreateTemplateHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class IndexBasedTemplateReportCreateHandler
implements CreateTemplateHandler<ComboBoxWidget<String>, IndexBasedTemplateReportDescription> {
    private static Map<String, IndexType> INDEXES = MetaRegistry.get().getIndexes();
    private static StringConverter<String> INDEX_CONVERTER = new StringConverter<String>(){

        public String toString(String value) {
            return ((IndexType)INDEXES.get(value)).getDisplayName();
        }

        public String fromString(String value) {
            return null;
        }
    };

    @Override
    public Class<IndexBasedTemplateReportDescription> getTemplateClass() {
        return IndexBasedTemplateReportDescription.class;
    }

    @Override
    public GridCell<ComboBoxWidget<String>> createGridCell() {
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setNoNulls(true);
        INDEXES.keySet().stream().findFirst().ifPresent(arg_0 -> ((ComboBoxWidget)widget).setValue(arg_0));
        widget.setItemsSupplier(() -> INDEXES.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        widget.setConverter(INDEX_CONVERTER);
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        return new GridCell(Messages.Index, (Node)widget);
    }

    @Override
    public <N extends Node> void onCreate(N node, DataTransferPackage<?, Object> dtp) {
        IndexBasedTemplateReportDescription template = (IndexBasedTemplateReportDescription)dtp.getContainer().getEntity();
        ComboBoxWidget widget = (ComboBoxWidget)node;
        String index = (String)widget.getValue();
        if (index != null) {
            template.setIndexClassName(index);
        }
    }
}

