/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.sabre.helpers;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.AircraftSeatIndicator;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sabre.core.helper.CoreSabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class SabreHelper {
    public static final Map<CommunicationType, String> COMMUNICATION_TYPES = new EnumMap<CommunicationType, String>(CommunicationType.class);
    public static final Map<CommunicationType, String> COMMUNICATION_TYPES_AGENCY = new EnumMap<CommunicationType, String>(CommunicationType.class);
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static final Map<MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>, String> GIVEN_NAME_SUFFIXES = new HashMap<MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>, String>();
    private static final String DK_NUMBER_WEAK_PATTERN = "[A-Za-z0-9]{6}(([A-Za-z0-9]{4})|[A-Za-z1-9])?";
    private static final String DK_NUMBER_PATTERN = "[A-Za-z1-9]{2}[A-Za-z0-9]{4}([A-Za-z1-9]|[A-Za-z0-9]{4})?";
    private static final Map<PassportType, String> PASSPORT_TYPES = new HashMap<PassportType, String>();
    private static List<PassportType> SU_DOCUMENTS_P = Arrays.asList(PassportType.PASSPORT, PassportType.BIRTHDAY_NOTIFICATION, PassportType.IDENTITYCARD);
    public static final Logger SESSIONS_LOG;

    public static boolean isCertComplianceMode() {
        return MiscUtil.isTrue((String)System.getProperty("com.gridnine.xtrip.gds.sabre.certComplianceMode"));
    }

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref) {
        return CODE_TRANSLATOR.getNativeCode(ref, false);
    }

    public static <D extends BaseDictionary> String getNativeCodeOrNull(DictionaryReference<D> ref) {
        return CODE_TRANSLATOR.getNativeCode(ref, true);
    }

    public static String getCountryNativeCode(DictionaryReference<Country> countryRef) {
        Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
        String result = (String)country.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name());
        if (StringUtils.isBlank((String)result)) {
            result = (String)country.getCodeVariants().get(CodeSystem.IATA.name());
        }
        return result;
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, boolean createIfMissing, boolean reportMissing) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code, createIfMissing, reportMissing);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, boolean createIfMissing) {
        return CODE_TRANSLATOR.resolveNativeCode(cls, code, createIfMissing);
    }

    public static ZonedDateTime parseDateTimeWithoutYear(String string, String pattern, ZoneId timeZone) {
        return SabreHelper.parseLocalDateTimeWithoutYear(string, pattern, ZonedDateTime.now(timeZone).toLocalDateTime()).atZone(ZoneId.systemDefault());
    }

    public static LocalDate parseLocalDateWithoutYear(String string, String pattern) {
        return SabreHelper.parseLocalDateWithoutYear(string, pattern, LocalDate.now());
    }

    public static LocalDate parseLocalDateWithoutYear(String string, String pattern, LocalDate now) {
        LocalDate d = LocalDate.parse(string, new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.YEAR, 2000L).toFormatter());
        d = d.isBefore(now.withYear(2000)) ? (d.getDayOfMonth() == now.getDayOfMonth() && d.getMonth() == now.getMonth() ? d.withYear(now.getYear()) : d.withYear(now.getYear() + 1)) : d.withYear(now.getYear());
        return d;
    }

    public static LocalDateTime parseLocalDateTimeWithoutYear(String string, String pattern) {
        return SabreHelper.parseLocalDateTimeWithoutYear(string, pattern, LocalDateTime.now());
    }

    public static LocalDateTime parseLocalDateTimeWithoutYear(String string, String pattern, LocalDateTime now) {
        DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder();
        if (pattern.contains("T")) {
            dtfb.appendPattern(pattern).parseDefaulting(ChronoField.YEAR, 2000L);
        } else {
            dtfb.appendPattern(pattern).parseDefaulting(ChronoField.YEAR, 2000L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L);
        }
        LocalDateTime dt = LocalDateTime.parse(string, dtfb.toFormatter());
        dt = dt.isBefore(now.withYear(2000)) ? (dt.getDayOfMonth() == now.getDayOfMonth() && dt.getMonth() == now.getMonth() ? dt.withYear(now.getYear()) : dt.withYear(now.getYear() + 1)) : dt.withYear(now.getYear());
        return dt;
    }

    public static String getNameSuffix(DictionaryReference<PassengerType> passengerType, Gender gender) {
        return GIVEN_NAME_SUFFIXES.get(new MiscUtil.Pair((Object)DictHelper.findPrimaryCategory(passengerType), (Object)gender));
    }

    public static String buildGivenName(Passport passport, DictionaryReference<PassengerType> passengerType, SabreAviaParametersProvider parametersProvider) {
        StringBuilder sb = new StringBuilder();
        sb.append(passport.getFirstName());
        if (!StringUtils.isBlank((String)passport.getSecondName())) {
            sb.append(' ');
            sb.append(passport.getSecondName());
        }
        if (!StringUtils.isBlank((String)passport.getMiddleName())) {
            sb.append(' ');
            if (parametersProvider.isTchBlankOwner()) {
                sb.append(passport.getMiddleName(), 0, 1);
            } else {
                sb.append(passport.getMiddleName());
            }
        }
        String title = null;
        if (!parametersProvider.isSubsidizedTariff() || !parametersProvider.isSuCarrier()) {
            if (!DictHelper.isInfantPassengerType(passengerType) || !parametersProvider.isNoInfGenderSuffix()) {
                title = SabreHelper.getNameSuffix(passengerType, passport.getGender());
            }
            if (parametersProvider.isTchBlankOwner()) {
                if (DictHelper.isChildPassengerType(passengerType)) {
                    title = String.format("%s*%02d", SabreHelper.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInYears());
                } else if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
                    title = String.format("%s*%02dMTHS", SabreHelper.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInMonths());
                }
            }
        }
        if (!StringUtils.isBlank(title)) {
            sb.append(' ');
            sb.append(title);
        }
        if (sb.length() > 29) {
            sb = new StringBuilder();
            sb.append(passport.getFirstName());
            if (!StringUtils.isBlank((String)passport.getSecondName())) {
                sb.append(' ');
                sb.append(passport.getSecondName());
            }
            if (!StringUtils.isBlank((String)passport.getMiddleName())) {
                sb.append(' ');
                sb.append(passport.getMiddleName(), 0, 1);
            }
            title = null;
            if (!parametersProvider.isSubsidizedTariff() || !parametersProvider.isSuCarrier()) {
                if (!DictHelper.isInfantPassengerType(passengerType) || !parametersProvider.isNoInfGenderSuffix()) {
                    title = SabreHelper.getNameSuffix(passengerType, passport.getGender());
                }
                if (parametersProvider.isTchBlankOwner()) {
                    if (DictHelper.isChildPassengerType(passengerType)) {
                        title = String.format("%s*%02d", SabreHelper.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInYears());
                    } else if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
                        title = String.format("%s*%02dMTHS", SabreHelper.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInMonths());
                    }
                }
            }
            if (!StringUtils.isBlank((String)title)) {
                sb.append(' ');
                sb.append(title);
            }
        }
        return sb.length() > 29 ? sb.substring(0, 29) : sb.toString();
    }

    public static String buildSurname(Passport passport, boolean forNameField) {
        String lastName = passport.getLastName();
        if (!StringUtils.isBlank((String)lastName) && forNameField) {
            if (lastName.length() == 1) {
                return lastName + lastName;
            }
            if (lastName.length() > 29) {
                return lastName.substring(0, 29);
            }
        }
        return lastName;
    }

    public static Collection<String> getMarketingCarrierCodes(Flight flight) {
        HashSet<String> marketingCarrierCodes = new HashSet<String>();
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                marketingCarrierCodes.add(CODE_TRANSLATOR.getNativeCode(fs.getAirline()));
            }
        }
        return marketingCarrierCodes;
    }

    public static Collection<String> getMarketingCarrierCodes(Product product) {
        HashSet<String> marketingCarrierCodes = new HashSet<String>();
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                marketingCarrierCodes.add(CODE_TRANSLATOR.getNativeCode(s.getAirline()));
            }
        }
        return marketingCarrierCodes;
    }

    public static String buildPhoneNumber(Communication comm) {
        StringBuilder sb = new StringBuilder(18);
        if (!TextUtil.isBlank((String)comm.getCountryCode())) {
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()));
        }
        if (!TextUtil.isBlank((String)comm.getCityCode())) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()));
        }
        if (!TextUtil.isBlank((String)comm.getSense())) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        }
        return sb.toString();
    }

    public static boolean checkPhoneNumber(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidDkNumber(String dkNumber, boolean isWeakerDkNumberValidation) {
        return !StringUtils.isBlank((String)dkNumber) && dkNumber.matches(isWeakerDkNumberValidation ? DK_NUMBER_WEAK_PATTERN : DK_NUMBER_PATTERN);
    }

    public static String getCardVendorCode(CardVendor cardVendor) {
        if (cardVendor == null) {
            return null;
        }
        switch (cardVendor) {
            case VISA: {
                return "VI";
            }
            case MASTERCARD: {
                return "CA";
            }
            case AMEX: {
                return "AX";
            }
            case DINERS_CLUB: {
                return "DC";
            }
        }
        return null;
    }

    public static boolean isTchBlankOwner(EntityReference<Organization> blankOwnerRef) {
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr == null) {
            return false;
        }
        return "\u04281".equals(((Organization)blankOwnerCtr.getEntity()).getCode());
    }

    public static Commission getTotalVendorCommissionForSabre(Product product) {
        return SabreHelper.isTchBlankOwner((EntityReference<Organization>)product.getBlankOwnerRef()) || product.isSabreExcludeCommissionQualifier() ? null : BookingHelper.getTotalVendorCommission((Product)product);
    }

    public static Commission getTotalVendorCommissionForSabre(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return SabreHelper.isTchBlankOwner((EntityReference<Organization>)flight.getBlankOwner()) || Boolean.TRUE.equals(flight.getSabreExcludeCommissionQualifier().get(passengerType)) ? null : FlightHelper.getTotalVendorCommission((Flight)flight, passengerType);
    }

    public static boolean marriageGrp2MarriageGrp(String marriageGrp) {
        switch (marriageGrp) {
            case "O": {
                return false;
            }
            case "I": {
                return true;
            }
        }
        return false;
    }

    public static String buildPassportType(PassportType passportType) {
        return PASSPORT_TYPES.containsKey(passportType) ? PASSPORT_TYPES.get(passportType) : "P";
    }

    public static String buildPassportTypeSu(PassportType passportType) {
        if (SU_DOCUMENTS_P.contains(passportType)) {
            return "P";
        }
        return SabreHelper.buildPassportType(passportType);
    }

    public static String parseSingleValue(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String fixNameNumber(String nameNumber) {
        String[] parts = nameNumber.split(Pattern.quote("."));
        return String.format("%d.%d", Integer.valueOf(parts[0]), Integer.valueOf(parts[1]));
    }

    public static boolean isSuOnBsp(Flight flight, SalesContext salesContext) {
        return SabreHelper.isSuOnBsp((DictionaryReference<Airline>)flight.getCarrier(), (EntityReference<Organization>)flight.getBlankOwner(), (EntityReference<SalesPoint>)salesContext.getSalesPoint());
    }

    public static boolean isSuOnBsp(Product product) {
        return SabreHelper.isSuOnBsp((DictionaryReference<Airline>)product.getCarrier(), (EntityReference<Organization>)product.getBlankOwnerRef(), (EntityReference<SalesPoint>)product.getSalesPoint());
    }

    public static boolean isSuOnBsp(DictionaryReference<Airline> carrierRef, EntityReference<Organization> blankOwnerRef, EntityReference<SalesPoint> salesPointRef) {
        if (blankOwnerRef == null) {
            throw Xeption.forAdmin((String)"\u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u0430 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430 {1} , \u043a\u043e\u0434 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430 - {2}", (Object[])new Object[]{salesPointRef, carrierRef, DictHelper.getCode(carrierRef)});
        }
        return "SU".equals(SabreHelper.getNativeCode(carrierRef)) && "BSP".equals(((Organization)EntityStorage.get().resolve(blankOwnerRef).getEntity()).getCode());
    }

    public static boolean isSu(DictionaryReference<Airline> carrierRef) {
        return "SU".equals(SabreHelper.getNativeCode(carrierRef));
    }

    public static ClassOfService cabin2ClassOfService(String cabin) {
        if (StringUtils.isBlank((String)cabin)) {
            return null;
        }
        switch (cabin) {
            case "Y": {
                return ClassOfService.ECONOMY;
            }
            case "S": {
                return ClassOfService.PREMIUM;
            }
            case "C": {
                return ClassOfService.BUSINESS;
            }
            case "J": {
                return ClassOfService.PREMIUM_BUSINESS;
            }
            case "F": {
                return ClassOfService.FIRST;
            }
            case "P": {
                return ClassOfService.PREMIUM_FIRST;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected cabin {0}", (Object[])new Object[]{cabin});
    }

    public static String classOfService2Cabin(ClassOfService classOfService) {
        if (classOfService == null) {
            return null;
        }
        switch (classOfService) {
            case ECONOMY: {
                return "Y";
            }
            case PREMIUM: {
                return "S";
            }
            case BUSINESS: {
                return "C";
            }
            case PREMIUM_BUSINESS: {
                return "J";
            }
            case FIRST: {
                return "F";
            }
            case PREMIUM_FIRST: {
                return "P";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected class of service {0}", (Object[])new Object[]{classOfService});
    }

    public static ZoneId getDateTimeZone(String locationCode) {
        ZoneId zoneId = DictHelper.getZoneId(SabreHelper.resolveNativeCode(GeoLocation.class, locationCode));
        if (zoneId == null) {
            return ZoneId.systemDefault();
        }
        return zoneId;
    }

    public static Set<String> getTicketNumbersInTicketingLinesFormat(Reservation reservation) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).filter(prod -> !StringUtils.isBlank((String)prod.getCarrierNumber())).filter(prod -> !StringUtils.isBlank((String)prod.getSystemNumber())).map(prod -> AirProductHelper.getFullNumber((Product)prod)).map(n -> n.contains("/") ? n.substring(0, n.indexOf(47)) : n).collect(Collectors.toSet());
    }

    public static Set<String> getTicketNumbersInTicketingLinesFormat(List<Product> products) {
        return products.stream().filter(prod -> !StringUtils.isBlank((String)prod.getCarrierNumber())).filter(prod -> !StringUtils.isBlank((String)prod.getSystemNumber())).map(prod -> AirProductHelper.getFullNumber((Product)prod)).map(n -> n.contains("/") ? n.substring(0, n.indexOf(47)) : n).collect(Collectors.toSet());
    }

    public static Integer parseAvailability(String availability) {
        if (StringUtils.isBlank((String)availability)) {
            return null;
        }
        if (availability.length() > 1) {
            return 0;
        }
        if (Character.isDigit(availability.charAt(0))) {
            return Integer.valueOf(availability);
        }
        return 0;
    }

    public static boolean isIncludeBCEmailType(SalesContext salesContext) {
        EntityReference subagencyRef = salesContext.getSubagency();
        EntityContainer subagencyCont = EntityStorage.get().resolve(subagencyRef);
        if (subagencyCont == null) {
            return true;
        }
        Organization subagency = (Organization)subagencyCont.getEntity();
        Optional<Metadata> emailMetadata = subagency.getMetadata().stream().filter(md -> MetadataKey.ORGANIZATION_EMAIL_ADDRESS_BC_TYPE_IN_SABRE.name().equals(md.getKey().getCode())).findFirst();
        return !emailMetadata.isPresent() || emailMetadata.get().getValue() == null || Boolean.TRUE.equals(emailMetadata.get().getValue());
    }

    public static DictionaryReference<PassengerType> autocorrectPassengerType(DictionaryReference<PassengerType> ptRef, Flight flight) {
        if (flight.getSeats().stream().anyMatch(s -> s.getPassengerType().getCode().matches("CHILD_[0-1][0-9]"))) {
            return ptRef;
        }
        if (ptRef.getCode().matches("CHILD_[0-1][0-9]")) {
            return DictHelper.getChildPassengerType();
        }
        return ptRef;
    }

    public static List<AircraftSeatIndicator> gdsSeatCharacteristic2SeatIndicators(String gdsSeatCharacteristic) {
        ArrayList<AircraftSeatIndicator> result = new ArrayList<AircraftSeatIndicator>(2);
        switch (gdsSeatCharacteristic) {
            case "AisleSeat": 
            case "Aisle": 
            case "AdjacentAisleSeat": {
                result.add(AircraftSeatIndicator.AISLE_SEAT);
                break;
            }
            case "WindowAndAisleTogether": {
                result.add(AircraftSeatIndicator.AISLE_SEAT);
                result.add(AircraftSeatIndicator.WINDOW_SEAT);
                break;
            }
            case "Window": {
                result.add(AircraftSeatIndicator.WINDOW_SEAT);
                break;
            }
            case "BulkheadSeat": 
            case "AisleBulkhead": 
            case "BulkheadSeatWithMovieScreen": {
                result.add(AircraftSeatIndicator.BULKHEAD_SEAT);
                break;
            }
            case "ExitRowSeat": {
                result.add(AircraftSeatIndicator.EXIT_ROW_SEAT);
                break;
            }
            case "LapChild": 
            case "SeatSuitableForAdultWithInfant": {
                result.add(AircraftSeatIndicator.LAP_CHILD);
                break;
            }
            case "LegSpaceSeat": {
                result.add(AircraftSeatIndicator.LEG_SPACE_SEAT);
                break;
            }
            case "RestrictedRecline": {
                result.add(AircraftSeatIndicator.RESTRICTED_DECLINE);
            }
        }
        return result;
    }

    public static Pcc getPcc(SabreGdsAccount account, SalesContext salesContext) {
        return PccHelper.findPccGds((String)account.getPrimaryPCC(), (GdsName)account.getGds(), (EntityReference)(salesContext != null ? salesContext.getSalesPoint() : null));
    }

    public static String getRecordLocator(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }

    static {
        GIVEN_NAME_SUFFIXES.put((MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>)new MiscUtil.Pair((Object)DictHelper.getAdultPassengerCategory(), (Object)Gender.MALE), "MR");
        GIVEN_NAME_SUFFIXES.put((MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>)new MiscUtil.Pair((Object)DictHelper.getAdultPassengerCategory(), (Object)Gender.FEMALE), "MRS");
        GIVEN_NAME_SUFFIXES.put((MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>)new MiscUtil.Pair((Object)DictHelper.getChildPassengerCategory(), (Object)Gender.MALE), "MSTR");
        GIVEN_NAME_SUFFIXES.put((MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>)new MiscUtil.Pair((Object)DictHelper.getChildPassengerCategory(), (Object)Gender.FEMALE), "MISS");
        GIVEN_NAME_SUFFIXES.put((MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>)new MiscUtil.Pair((Object)DictHelper.getInfantPassengerCategory(), (Object)Gender.MALE), "MSTR");
        GIVEN_NAME_SUFFIXES.put((MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>)new MiscUtil.Pair((Object)DictHelper.getInfantPassengerCategory(), (Object)Gender.FEMALE), "MISS");
        COMMUNICATION_TYPES.put(CommunicationType.HOME_PHONE, "H");
        COMMUNICATION_TYPES.put(CommunicationType.WORK_PHONE, "B");
        COMMUNICATION_TYPES.put(CommunicationType.FAX, "F");
        COMMUNICATION_TYPES.put(CommunicationType.MOBILE, "M");
        COMMUNICATION_TYPES.put(CommunicationType.CELL, "C");
        COMMUNICATION_TYPES_AGENCY.putAll(COMMUNICATION_TYPES);
        COMMUNICATION_TYPES_AGENCY.put(CommunicationType.AGENCY, "A");
        PASSPORT_TYPES.put(PassportType.MILITARYID, "M");
        PASSPORT_TYPES.put(PassportType.ALIENRESIDENTCARD, "A");
        PASSPORT_TYPES.put(PassportType.PERMANENTRESIDENTCARD, "C");
        PASSPORT_TYPES.put(PassportType.TRAVELDOCUMENT, "T");
        PASSPORT_TYPES.put(PassportType.SERVICE_PASSPORT, "F");
        PASSPORT_TYPES.put(PassportType.FACILITATIONDOCUMENT, "F");
        PASSPORT_TYPES.put(PassportType.NATURALIZATIONCERTIFICATE, "N");
        PASSPORT_TYPES.put(PassportType.BORDERCROSSINGCARD, "V");
        PASSPORT_TYPES.put(PassportType.BIRTHDAY_NOTIFICATION, "I");
        PASSPORT_TYPES.put(PassportType.IDENTITYCARD, "I");
        SESSIONS_LOG = CoreSabreHelper.SESSIONS_LOG;
    }

    public static interface SabreAviaParametersProvider {
        public static final Collection<String> NO_INF_GENDER_SUFFIX_AIRLINES = Collections.unmodifiableCollection(Arrays.asList("AZ", "KL", "OK", "A3", "UA"));

        public boolean isNoInfGenderSuffix();

        public boolean isTchBlankOwner();

        public int getAgeInYears();

        public int getAgeInMonths();

        public boolean isSubsidizedTariff();

        public boolean isSuCarrier();
    }

    public static class ProductParametersProvider
    implements SabreAviaParametersProvider {
        private final Product product;

        public ProductParametersProvider(Product product) {
            this.product = product;
        }

        @Override
        public boolean isNoInfGenderSuffix() {
            return CollectionUtils.containsAny(SabreHelper.getMarketingCarrierCodes(this.product), (Collection)NO_INF_GENDER_SUFFIX_AIRLINES);
        }

        @Override
        public boolean isTchBlankOwner() {
            return SabreHelper.isTchBlankOwner((EntityReference<Organization>)this.product.getBlankOwnerRef());
        }

        @Override
        public int getAgeInYears() {
            return (int)ChronoUnit.YEARS.between(this.product.getTraveller().getPassport().getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), AirProductHelper.getLastArriveDate((Product)this.product).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }

        @Override
        public int getAgeInMonths() {
            return (int)ChronoUnit.MONTHS.between(this.product.getTraveller().getPassport().getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), AirProductHelper.getLastArriveDate((Product)this.product).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }

        @Override
        public boolean isSubsidizedTariff() {
            return this.product.isSubsidizedTariff();
        }

        @Override
        public boolean isSuCarrier() {
            return "SU".equals(SabreHelper.getNativeCode(this.product.getCarrier()));
        }
    }

    public static class FlightParametersProvider
    implements SabreAviaParametersProvider {
        private final Flight flight;
        private final Passport passport;

        public FlightParametersProvider(Flight flight, Passport passport) {
            this.flight = flight;
            this.passport = passport;
        }

        @Override
        public boolean isNoInfGenderSuffix() {
            return CollectionUtils.containsAny(SabreHelper.getMarketingCarrierCodes(this.flight), (Collection)NO_INF_GENDER_SUFFIX_AIRLINES);
        }

        @Override
        public boolean isTchBlankOwner() {
            return SabreHelper.isTchBlankOwner((EntityReference<Organization>)this.flight.getBlankOwner());
        }

        @Override
        public int getAgeInYears() {
            return (int)ChronoUnit.YEARS.between(this.passport.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), FlightHelper.getLastArrivalTime((Flight)this.flight).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }

        @Override
        public int getAgeInMonths() {
            return (int)ChronoUnit.MONTHS.between(this.passport.getBirthday().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), FlightHelper.getLastArrivalTime((Flight)this.flight).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }

        @Override
        public boolean isSubsidizedTariff() {
            return this.flight.isSubsidizedTariff();
        }

        @Override
        public boolean isSuCarrier() {
            return "SU".equals(SabreHelper.getNativeCode(this.flight.getCarrier()));
        }
    }
}

