/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.tandc;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;

public class TaNdcCommonHelper {
    public static boolean isTaNdcItinReceipts(Product product) {
        AirProductContractRelationData vendorContractRelation = AirProductHelper.getVendorContractRelation((Product)product);
        if (vendorContractRelation.getGeneralData().getRate() != null && vendorContractRelation.getGeneralData().getRate().getCoefficient() > 0.0) {
            return false;
        }
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation((Product)product);
        if (!"RUB".equals(clientContractRelation.getGeneralData().getCurrency().getCode())) {
            return false;
        }
        Reservation reservation = product.getReservation();
        EntityContainer clientCtr = EntityStorage.get().resolve(reservation.getBookingFile().getCustomerProfile());
        if (clientCtr != null && ((Organization)clientCtr.getEntity()).isTaNdcItinReceipts()) {
            return true;
        }
        EntityContainer subagencyCtr = EntityStorage.get().resolve(reservation.getSubagency());
        if (subagencyCtr != null && ((Organization)subagencyCtr.getEntity()).isTaNdcItinReceipts()) {
            return true;
        }
        EntityContainer agencyCtr = EntityStorage.get().resolve(reservation.getBookingFile().getAgency());
        return agencyCtr != null && ((Organization)agencyCtr.getEntity()).isTaNdcItinReceipts();
    }
}

