/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class LongRunningTaskInfo
extends BaseAsset {
    private static final long serialVersionUID = -1993104901845969547L;
    private byte progress;
    private String taskClassName;
    private boolean indefinite;
    private boolean singleton;
    private State state;
    private Events events = new Events();
    private Date startDate;
    private Date endDate;
    private L10nMessage description;
    private String createdBy;
    private Date created;
    private String instance;
    private String serverId;
    private XSerializable configuration;

    public LongRunningTaskInfo() {
    }

    public LongRunningTaskInfo(String uid) {
        super(uid);
    }

    public byte getProgress() {
        return this.progress;
    }

    public void setProgress(byte value) {
        this.progress = value;
    }

    public String getTaskClassName() {
        return this.taskClassName;
    }

    public void setTaskClassName(String value) {
        this.taskClassName = value;
    }

    public boolean isIndefinite() {
        return this.indefinite;
    }

    public void setIndefinite(boolean value) {
        this.indefinite = value;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean value) {
        this.singleton = value;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State value) {
        this.state = value;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public L10nMessage getDescription() {
        return this.description;
    }

    public void setDescription(L10nMessage value) {
        this.description = value;
    }

    public Events getEvents() {
        return this.events;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        this.endDate = value;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date value) {
        this.created = value;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String value) {
        this.createdBy = value;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String value) {
        this.serverId = value;
    }

    public XSerializable getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(XSerializable configuration) {
        this.configuration = configuration;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.progress = XHelper.readByte((Element)elm, (String)Property.progress.name(), (byte)0);
        this.taskClassName = XHelper.readString((Element)elm, (String)Property.taskClassName.name());
        this.indefinite = XHelper.readBoolean((Element)elm, (String)Property.indefinite.name(), (boolean)false);
        this.singleton = XHelper.readBoolean((Element)elm, (String)Property.singleton.name(), (boolean)false);
        this.state = (State)XHelper.readEnum((Element)elm, (String)Property.state.name(), State.class);
        this.events = (Events)XHelper.readObject((Element)elm, (String)Property.events.name());
        this.startDate = XHelper.readDate((Element)elm, (String)Property.startDate.name());
        this.endDate = XHelper.readDate((Element)elm, (String)Property.endDate.name());
        this.description = (L10nMessage)XHelper.readObject((Element)elm, (String)Property.description.name());
        this.createdBy = XHelper.readString((Element)elm, (String)Property.createdBy.name());
        this.created = XHelper.readDate((Element)elm, (String)Property.created.name());
        this.instance = XHelper.readString((Element)elm, (String)Property.instance.name());
        this.serverId = XHelper.readString((Element)elm, (String)Property.serverId.name());
        this.configuration = (XSerializable)XHelper.readObject((Element)elm, (String)Property.configuration.name());
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if (Property.progress.name().equals(tagName)) {
            this.progress = XSHelper.readByte((XMLStreamReader)reader, (byte)0);
            return true;
        }
        if (Property.taskClassName.name().equals(tagName)) {
            this.taskClassName = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.indefinite.name().equals(tagName)) {
            this.indefinite = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
            return true;
        }
        if (Property.singleton.name().equals(tagName)) {
            this.singleton = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
            return true;
        }
        if (Property.state.name().equals(tagName)) {
            this.state = (State)XSHelper.readEnum((XMLStreamReader)reader, State.class);
            return true;
        }
        if (Property.events.name().equals(tagName)) {
            this.events = (Events)XSHelper.readObject((XMLStreamReader)reader);
            return true;
        }
        if (Property.startDate.name().equals(tagName)) {
            this.startDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if (Property.endDate.name().equals(tagName)) {
            this.endDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if (Property.description.name().equals(tagName)) {
            this.description = (L10nMessage)XSHelper.readObject((XMLStreamReader)reader);
            return true;
        }
        if (Property.createdBy.name().equals(tagName)) {
            this.createdBy = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.created.name().equals(tagName)) {
            this.created = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if (Property.instance.name().equals(tagName)) {
            this.instance = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.serverId.name().equals(tagName)) {
            this.serverId = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if (Property.configuration.name().equals(tagName)) {
            this.configuration = (XSerializable)XSHelper.readObject((XMLStreamReader)reader);
            return true;
        }
        return false;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeByte((Element)elm, (String)Property.progress.name(), (byte)this.progress);
        XHelper.writeString((Element)elm, (String)Property.taskClassName.name(), (String)this.taskClassName);
        XHelper.writeBoolean((Element)elm, (String)Property.indefinite.name(), (boolean)this.indefinite);
        XHelper.writeBoolean((Element)elm, (String)Property.singleton.name(), (boolean)this.singleton);
        XHelper.writeEnum((Element)elm, (String)Property.state.name(), (Enum)this.state);
        XHelper.writeObject((Element)elm, (String)Property.events.name(), (Object)this.events);
        XHelper.writeDate((Element)elm, (String)Property.startDate.name(), (Date)this.startDate);
        XHelper.writeDate((Element)elm, (String)Property.endDate.name(), (Date)this.endDate);
        XHelper.writeObject((Element)elm, (String)Property.description.name(), (Object)this.description);
        XHelper.writeString((Element)elm, (String)Property.createdBy.name(), (String)this.createdBy);
        XHelper.writeDate((Element)elm, (String)Property.created.name(), (Date)this.created);
        XHelper.writeString((Element)elm, (String)Property.instance.name(), (String)this.instance);
        XHelper.writeString((Element)elm, (String)Property.serverId.name(), (String)this.serverId);
        XHelper.writeObject((Element)elm, (String)Property.configuration.name(), (Object)this.configuration);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeByte((XMLStreamWriter)writer, (String)Property.progress.name(), (byte)this.progress);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.taskClassName.name(), (String)this.taskClassName);
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)Property.indefinite.name(), (boolean)this.indefinite);
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)Property.singleton.name(), (boolean)this.singleton);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)Property.state.name(), (Enum)this.state);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)Property.events.name(), (Object)this.events);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)Property.startDate.name(), (Date)this.startDate);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)Property.endDate.name(), (Date)this.endDate);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)Property.description.name(), (Object)this.description);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.createdBy.name(), (String)this.createdBy);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)Property.created.name(), (Date)this.created);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.instance.name(), (String)this.instance);
        XSHelper.writeString((XMLStreamWriter)writer, (String)Property.serverId.name(), (String)this.serverId);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)Property.configuration.name(), (Object)this.configuration);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        LongRunningTaskInfo source = (LongRunningTaskInfo)sourceAsset;
        this.progress = source.progress;
        this.taskClassName = source.taskClassName;
        this.indefinite = source.indefinite;
        this.singleton = source.singleton;
        this.state = source.state;
        this.events = (Events)XCloneHelper.cloneObject((Object)source.events, (boolean)newUids, uids);
        this.startDate = XCloneHelper.cloneDate((Date)source.startDate);
        this.endDate = XCloneHelper.cloneDate((Date)source.endDate);
        this.description = (L10nMessage)XCloneHelper.cloneObject((Object)source.description, (boolean)newUids, uids);
        this.createdBy = source.createdBy;
        this.created = XCloneHelper.cloneDate((Date)source.created);
        this.instance = source.instance;
        this.serverId = source.serverId;
        this.configuration = source.configuration;
    }

    public static class Event
    implements XSerializable,
    XSSerializable,
    Serializable {
        private static final long serialVersionUID = -5468649903099476338L;
        private Date date;
        private Message description;
        private String user;

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date value) {
            this.date = value;
        }

        public Message getDescription() {
            return this.description;
        }

        public void setDescription(Message value) {
            this.description = value;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String value) {
            this.user = value;
        }

        public void fromXML(Element elm) throws Exception {
            this.date = XHelper.readDate((Element)elm, (String)"date");
            this.description = (Message)XHelper.readObject((Element)elm, (String)"description");
            this.user = XHelper.readString((Element)elm, (String)"user");
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("date".equals(tag)) {
                    this.date = XSHelper.readDate((XMLStreamReader)reader);
                    continue;
                }
                if ("description".equals(tag)) {
                    this.description = (Message)XSHelper.readObject((XMLStreamReader)reader);
                    continue;
                }
                if ("user".equals(tag)) {
                    this.user = XSHelper.readString((XMLStreamReader)reader);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeDate((Element)elm, (String)"date", (Date)this.date);
            XHelper.writeString((Element)elm, (String)"user", (String)this.user);
            XHelper.writeObject((Element)elm, (String)"description", (Object)this.description);
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            XSHelper.writeDate((XMLStreamWriter)writer, (String)"date", (Date)this.date);
            XSHelper.writeString((XMLStreamWriter)writer, (String)"user", (String)this.user);
            XSHelper.writeObject((XMLStreamWriter)writer, (String)"description", (Object)this.description);
        }
    }

    public static class Events
    implements XSerializable,
    XSSerializable,
    Serializable {
        private static final long serialVersionUID = -760956771169949480L;
        private final HashMap<String, Event> events = new HashMap();

        public synchronized void add(Message description, String user) {
            this.add(null, description, user);
        }

        public synchronized int size() {
            return this.events.size();
        }

        public synchronized void add(String eventId, Message description, String user) {
            Event data = new Event();
            data.setDate(new Date());
            data.setDescription(description);
            data.setUser(user);
            this.events.put(eventId != null ? eventId : UUIDGenerator.generate((boolean)false).toString(), data);
        }

        public synchronized List<Event> get() {
            ArrayList<Event> result = new ArrayList<Event>(this.events.values());
            Collections.sort(result, new Comparator<Event>(){

                @Override
                public int compare(Event o1, Event o2) {
                    if (o1.getDate() == null) {
                        return o2.getDate() != null ? 1 : 0;
                    }
                    if (o2.getDate() == null) {
                        return -1;
                    }
                    return MiscUtil.compare((Date)o1.getDate(), (Date)o2.getDate());
                }
            });
            return result;
        }

        public void fromXML(Element elm) throws Exception {
            this.events.clear();
            for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"events/item")) {
                Event item = (Event)XHelper.readObject((Element)itemElm, (String)".");
                if (item == null) continue;
                this.events.put(itemElm.getAttribute("eventId"), item);
            }
        }

        public void fromXML(XMLStreamReader reader) throws Exception {
            while (reader.nextTag() != 2) {
                String tag = reader.getName().getLocalPart();
                if ("events".equals(tag)) {
                    while (reader.nextTag() != 2) {
                        if ("item".equals(reader.getName().getLocalPart())) {
                            String eventId = reader.getAttributeValue(null, "eventId");
                            Event item = (Event)XSHelper.readObject((XMLStreamReader)reader);
                            if (item == null) continue;
                            this.events.put(eventId, item);
                            continue;
                        }
                        XSHelper.skipElement((XMLStreamReader)reader);
                    }
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
        }

        public void toXML(Element elm) throws Exception {
            for (Map.Entry<String, Event> item : this.events.entrySet()) {
                Element itemElm = XHelper.writeObject((Element)elm, (String)"events/item", (Object)item.getValue());
                itemElm.setAttribute("eventId", item.getKey());
            }
        }

        public void toXML(XMLStreamWriter writer) throws Exception {
            if (!this.events.isEmpty()) {
                writer.writeStartElement("events");
                for (Map.Entry<String, Event> item : this.events.entrySet()) {
                    XSHelper.writeObject((XMLStreamWriter)writer, (String)"item", (Object)item.getValue(), Collections.singletonMap("eventId", item.getKey()));
                }
                writer.writeEndElement();
            }
        }
    }

    public static enum State {
        NEW{

            @Override
            protected String getResourceKey() {
                return "LRT_INFO_STATE_NEW";
            }
        }
        ,
        RUNNING{

            @Override
            protected String getResourceKey() {
                return "LRT_INFO_STATE_RUNNING";
            }
        }
        ,
        STOPPED{

            @Override
            protected String getResourceKey() {
                return "LRT_INFO_STATE_STOPPED";
            }
        }
        ,
        PAUSED{

            @Override
            protected String getResourceKey() {
                return "LRT_INFO_STATE_PAUSED";
            }
        }
        ,
        ERROR{

            @Override
            protected String getResourceKey() {
                return "LRT_INFO_STATE_ERROR";
            }
        }
        ,
        COMPLETED{

            @Override
            protected String getResourceKey() {
                return "LRT_INFO_STATE_COMPLETED";
            }
        };


        public String toString() {
            return L10nResourcesManager.getStr((String)this.getResourceKey(), (Object[])new Object[0]);
        }

        protected abstract String getResourceKey();
    }

    public static enum Property {
        instance,
        serverId,
        progress,
        taskClassName,
        indefinite,
        singleton,
        state,
        events,
        startDate,
        endDate,
        description,
        createdBy,
        created,
        configuration;

    }
}

