/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.Repository;
import com.gridnine.xtrip.common.model.assets.WorkspaceCategory;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class Workspace
extends BaseAsset {
    private static final long serialVersionUID = 2293305294970482415L;
    private String owner;
    private String name;
    private WorkspaceCategory category;
    private String description;
    private byte[] icon;
    private final List<Repository> repositories = new ArrayList<Repository>();

    public Workspace() {
    }

    public Workspace(String uid) {
        super(uid);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String value) {
        this.owner = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public void setIcon(byte[] value) {
        this.icon = value;
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public WorkspaceCategory getCategory() {
        return this.category;
    }

    public void setCategory(WorkspaceCategory value) {
        this.category = value;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.owner = XHelper.readString((Element)elm, (String)"owner");
        this.name = XHelper.readString((Element)elm, (String)"name");
        this.description = XHelper.readString((Element)elm, (String)"description");
        this.icon = XHelper.readBytes((Element)elm, (String)"icon");
        this.category = (WorkspaceCategory)XHelper.readEnum((Element)elm, (String)"category", WorkspaceCategory.class);
        this.repositories.clear();
        for (Element repoElm : XmlUtil.getElements((Element)elm, (String)"repositories/item")) {
            Repository repo = new Repository();
            repo.fromXML(repoElm);
            this.repositories.add(repo);
        }
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("owner".equals(tagName)) {
            this.owner = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("name".equals(tagName)) {
            this.name = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("description".equals(tagName)) {
            this.description = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("icon".equals(tagName)) {
            this.icon = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        if ("category".equals(tagName)) {
            this.category = (WorkspaceCategory)XSHelper.readEnum((XMLStreamReader)reader, WorkspaceCategory.class);
            return true;
        }
        if ("repositories".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    Repository repo = new Repository();
                    repo.fromXML(reader);
                    this.repositories.add(repo);
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        return false;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString((Element)elm, (String)"owner", (String)this.owner);
        XHelper.writeString((Element)elm, (String)"name", (String)this.name, (boolean)true);
        XHelper.writeString((Element)elm, (String)"description", (String)this.description, (boolean)true);
        XHelper.writeBytes((Element)elm, (String)"icon", (byte[])this.icon);
        XHelper.writeEnum((Element)elm, (String)"category", (Enum)this.category);
        for (Repository repo : this.repositories) {
            repo.toXML(XmlUtil.addElement((Element)elm, (String)"repositories/item"));
        }
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"owner", (String)this.owner);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"name", (String)this.name, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"description", (String)this.description, (boolean)true);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"icon", (byte[])this.icon);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"category", (Enum)this.category);
        if (!this.repositories.isEmpty()) {
            writer.writeStartElement("repositories");
            for (Repository repo : this.repositories) {
                writer.writeStartElement("item");
                repo.toXML(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        Workspace source = (Workspace)sourceAsset;
        this.owner = source.owner;
        this.name = source.name;
        this.description = source.description;
        this.icon = (byte[])XCloneHelper.cloneArray((Object)source.icon, (boolean)newUids, uids);
        this.category = source.category;
        this.repositories.clear();
        this.repositories.addAll(XCloneHelper.cloneCollection(source.repositories, (boolean)newUids, uids));
    }

    public static enum Property {
        owner,
        name,
        category;

    }
}

