/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.archive;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchivedBookingHelper {
    private static final Logger log = LoggerFactory.getLogger(ArchivedBookingHelper.class);
    public static String KEY_BOOKING_UID = "KEY_BOOKING_UID";
    public static String KEY_BOOKING_REFERENCE = "KEY_BOOKING_REFERENCE";

    public static EntityContainer<BookingFile> getBookingContainer(ArchivedBooking ett) {
        return ArchivedBookingHelper.getLastVersion(ett.getBooking());
    }

    public static <E extends BaseEntity> EntityContainer<E> getLastVersion(ArchivedEntity booking) {
        if (booking == null) {
            return null;
        }
        int idx = ArchivedBookingHelper.getLastVersionIndex(booking.getVersions());
        return idx == -1 ? null : (EntityContainer)booking.getVersions().get(idx);
    }

    private static int getLastVersionIndex(List<EntityContainer> versions) {
        int result = -1;
        int index = -1;
        for (int q = 0; q < versions.size(); ++q) {
            EntityContainer item = versions.get(q);
            if (item.getVersionInfo().getVersionNumber() <= result) continue;
            result = item.getVersionInfo().getVersionNumber();
            index = q;
        }
        return index;
    }

    public static boolean isFinanciallyInert(EntityContainer<BookingFile> bookingCtr) {
        for (Reservation res : ((BookingFile)bookingCtr.getEntity()).getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(prod.getClass());
                ProductStatus status = productHandler.getStatus(prod);
                if (ProductStatusHandler.getAllVoidStatuses().contains(status)) continue;
                log.debug(String.format("product %s has status %s, booking must be archived", CollectionUtil.collectionToString(productHandler.getProductNumbers(prod), (String)",", (boolean)false), status));
                return false;
            }
        }
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.referencedEntity.name(), (Object)bookingCtr.toReference()));
        int totalCount = EntityStorage.get().search(BillingTransactionIndex.class, query).getTotalCount();
        if (totalCount > 0) {
            log.debug(String.format("booking has %s related transactions, booking must be archived", Integer.toString(totalCount)));
            return false;
        }
        query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)bookingCtr.getUid()));
        totalCount = EntityStorage.get().search(TransactionSplitIndex.class, query).getTotalCount();
        if (totalCount > 0) {
            log.debug(String.format("booking has %s related transaction splits, booking must be archived", Integer.toString(totalCount)));
            return false;
        }
        log.debug("booking has no related transactions, has no valuable products, threrefore can be deleted with all related entities");
        return true;
    }
}

