/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.booking.carrental;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductSettings;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProvider;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProviderProfile;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public final class CarRentalProductHelper {
    private static final EntityReference<CarRentalProductSettings> SETTINGS_REF = new EntityReference("CAR-RENTAL-PRODUCT-SETTINGS", CarRentalProductSettings.class, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \"\u0410\u0440\u0435\u043d\u0434\u0430 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u044f\"");

    private CarRentalProductHelper() {
    }

    public static SalesChain getSalesChain(CarRentalProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(CarRentalProduct prod) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getClientContractRelation(CarRentalProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(CarRentalProduct product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static EntityReference<Organization> getSupplier(CarRentalProduct prod) {
        return GeneralProductHelper.getContractor(CarRentalProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static Traveller getTraveller(CarRentalProduct product) {
        return BookingHelper.findTraveller(product.getReservation().getBookingFile(), !product.getTravellers().isEmpty() ? ((Traveller)product.getTravellers().get(0)).getUid() : null);
    }

    public static String getRouteLine(CarRentalProduct product) {
        String routeLine = product.getStartLocation() + " - " + product.getEndLocation();
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        return routeLine;
    }

    public static void setSupplier(CarRentalProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(CarRentalProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(CarRentalProduct prod) {
        return GeneralProductHelper.getContractor(CarRentalProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(CarRentalProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(CarRentalProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(CarRentalProduct prod) {
        return GeneralProductHelper.getContractor(CarRentalProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(CarRentalProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(CarRentalProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static List<GeneralProductFop> getVendorFops(CarRentalProduct prod) {
        return CarRentalProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(CarRentalProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = CarRentalProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(CarRentalProduct prod) {
        return CarRentalProductHelper.getClientContractRelation(prod).getFops();
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(CarRentalProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    private static GeneralProductContractRelationData getVendorContractRelation(CarRentalProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static CarRentalProduct createRefund(CarRentalProduct model) throws Exception {
        HashSet<String> excludedUids = new HashSet<String>();
        excludedUids.add(model.getReservation().getUid());
        model.getTravellers().forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        CarRentalProduct refund = (CarRentalProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
        model.getReservation().getProducts().add(refund);
        model.setNextProduct(refund);
        refund.setPreviousProduct(model);
        refund.setNextProduct(null);
        refund.setContractRulesApplied(false);
        refund.setStatus(ProductStatus.REFUND);
        refund.setIssueDate(new Date());
        refund.setCompleted(false);
        refund.setChecked(false);
        refund.getShipments().clear();
        refund.getPrepaymentDocuments().clear();
        refund.getFopDetalizations().clear();
        return refund;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(CarRentalProduct source, CarRentalProduct target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        CarRentalProduct sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        CarRentalProduct sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        CarRentalProduct targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        CarRentalProduct targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static BigDecimal getTotalPrice(CarRentalProduct product) {
        Money fare;
        Money money = fare = product.getEquivalentFare() != null ? product.getEquivalentFare() : product.getFare();
        if (fare == null) {
            return null;
        }
        if (product.getStatus() == ProductStatus.REFUND) {
            if (product.getPenalty() == null) {
                product.setPenalty(BigDecimal.ZERO);
            }
            return fare.getValue() != null ? fare.getValue().subtract(product.getPenalty()).negate() : null;
        }
        return fare.getValue();
    }

    public static BigDecimal getEquivalentVat(CarRentalProduct product) {
        return product.getEquivalentFareVatValue() != null ? product.getEquivalentFareVatValue().getAmount() : null;
    }

    public static void setEquivalentVat(CarRentalProduct product, BigDecimal value) {
        if (product.getEquivalentFareVatValue() != null) {
            product.getEquivalentFareVatValue().setAmount(value);
        } else if (value != null) {
            VatValue vatValue = new VatValue();
            vatValue.setAmount(value);
            product.setEquivalentFareVatValue(vatValue);
        }
    }

    public static BigDecimal getPenaltyVat(CarRentalProduct product) {
        return product.getPenaltyVatValue() != null ? product.getPenaltyVatValue().getAmount() : null;
    }

    public static void setPenaltyVat(CarRentalProduct product, BigDecimal value) {
        if (product.getPenaltyVatValue() != null) {
            product.getPenaltyVatValue().setAmount(value);
        } else if (value != null) {
            VatValue vatValue = new VatValue();
            vatValue.setAmount(value);
            product.setPenaltyVatValue(vatValue);
        }
    }

    public static void removeProduct(CarRentalProduct product, boolean removeEmptyReservations) {
        Iterator iterator = product.getReservation().getBookingFile().getReservations().iterator();
        while (iterator.hasNext()) {
            Reservation res = (Reservation)iterator.next();
            res.getProducts().remove(product);
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof CarRentalProduct)) continue;
                CarRentalProduct prod = (CarRentalProduct)bp;
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CarRentalProduct createExchange(CarRentalProduct model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        List trav = model.getTravellers();
        model.getTravellers().clear();
        try {
            CarRentalProduct exchange = (CarRentalProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            exchange.setReservation(res);
            res.getProducts().add(exchange);
            exchange.getTravellers().clear();
            exchange.getTravellers().addAll(trav);
            exchange.setContractRulesApplied(false);
            exchange.setStatus(ProductStatus.EXCHANGE);
            exchange.setIssueDate(new Date());
            CarRentalProduct sell2 = (CarRentalProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            sell2.setReservation(res);
            res.getProducts().add(sell2);
            sell2.getTravellers().clear();
            sell2.getTravellers().addAll(trav);
            model.setNextProduct(exchange);
            exchange.setPreviousProduct(model);
            sell2.setPreviousProduct(exchange);
            exchange.setNextProduct(sell2);
            sell2.setContractRulesApplied(false);
            sell2.setStatus(ProductStatus.SELL);
            sell2.setIssueDate(new Date());
            sell2.setSystemNumber(null);
            exchange.setCompleted(false);
            sell2.setCompleted(false);
            CarRentalProduct carRentalProduct = sell2;
            return carRentalProduct;
        }
        finally {
            model.setReservation(res);
            model.getTravellers().clear();
            model.getTravellers().addAll(trav);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityContainer<CarRentalProductSettings> getSettings() throws Exception {
        EntityContainer result = EntityStorage.get().resolve(SETTINGS_REF);
        if (result != null) {
            return result;
        }
        EntityReference<CarRentalProductSettings> entityReference = SETTINGS_REF;
        synchronized (entityReference) {
            result = EntityStorage.get().resolve(SETTINGS_REF);
            if (result != null) {
                return result;
            }
            result = new EntityContainer(CarRentalProductSettings.class, SETTINGS_REF.getUid());
            CarRentalProductSettings settings = (CarRentalProductSettings)result.getEntity();
            settings.setType(SystemSettingsType.OTHER);
            settings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \"\u0410\u0440\u0435\u043d\u0434\u0430 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u044f\"");
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(result, false);
        }
        return result;
    }

    public static EntityReference<Organization> getSupplierFor(CarRentalProvider provider) throws GetSupplierException {
        if (provider == null) {
            return null;
        }
        try {
            for (CarRentalProviderProfile pp : ((CarRentalProductSettings)CarRentalProductHelper.getSettings().getEntity()).getSuppliersMapping()) {
                if (provider != pp.getProvider()) continue;
                return pp.getProfile();
            }
            return null;
        }
        catch (Exception e) {
            throw new GetSupplierException(provider, e);
        }
    }

    public static EntityReference<Organization> getBlankOwnerFor(CarRentalProvider provider) throws GetBlankOwnerException {
        if (provider == null) {
            return null;
        }
        try {
            for (CarRentalProviderProfile pp : ((CarRentalProductSettings)CarRentalProductHelper.getSettings().getEntity()).getBlankOwnersMapping()) {
                if (provider != pp.getProvider()) continue;
                return pp.getProfile();
            }
            return null;
        }
        catch (Exception e) {
            throw new GetBlankOwnerException(provider, e);
        }
    }

    public static boolean removeProduct(CarRentalProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(CarRentalProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static String getCities(CarRentalProduct product, Locale locale) {
        StringBuilder locations = new StringBuilder();
        locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getStartLocation())).map(item -> item.toString(locale)).orElse("?"));
        locations.append(" - ");
        locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(product.getEndLocation())).map(item -> item.toString(locale)).orElse("?"));
        return locations.length() > 0 ? locations.toString() : null;
    }

    public static String getCountries(CarRentalProduct product, Locale locale) {
        StringBuilder countries = new StringBuilder();
        countries.append(Optional.ofNullable(DictHelper.getCountry((DictionaryReference<GeoLocation>)product.getStartLocation())).map(item -> item.toString(locale)).orElse("?"));
        countries.append(" - ");
        countries.append(Optional.ofNullable(DictHelper.getCountry((DictionaryReference<GeoLocation>)product.getEndLocation())).map(item -> item.toString(locale)).orElse("?"));
        return countries.length() > 0 ? countries.toString() : null;
    }

    public static final class GetBlankOwnerException
    extends Exception {
        public final CarRentalProvider provider;

        public GetBlankOwnerException(CarRentalProvider provider, Exception e) {
            super("Error getting blank owner for provider " + provider, e);
            this.provider = provider;
        }
    }

    public static final class GetSupplierException
    extends Exception {
        public final CarRentalProvider provider;

        public GetSupplierException(CarRentalProvider provider, Exception e) {
            super("Error getting supplier for provider " + provider, e);
            this.provider = provider;
        }
    }
}

