/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.cir;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.util.CardVendorUtils;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CirToken;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.SecurityHelper;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.StandardCharset;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CirHelper {
    public static Stream<Card> cirCardStream(Collection<Card> cards) {
        return cards.stream().filter(Objects::nonNull).filter(card -> TextUtil.nonBlank((String)card.getCirUid())).filter(card -> Objects.nonNull(card.getExpiration())).filter(card -> TextUtil.nonBlank((String)card.getNameOnCard())).filter(card -> Objects.nonNull(card.getVendor()));
    }

    public static CirToken cirToken(Person person) {
        EntityContainer<Organization> mainEmploymentCtr = ProfileHelper.getMainEmployment(person);
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        CirToken result = CirHelper.cirToken(mainEmploymentCtr, settings, new HashSet<EntityContainer<Organization>>());
        return result;
    }

    public static CirToken cirToken(Traveller traveller, PCIDSSServerExchangeSettings settings) {
        EntityContainer<Organization> travellerMainEmployment = CirHelper.mainEmployment(traveller);
        CirToken result = CirHelper.cirToken(travellerMainEmployment, settings, new HashSet<EntityContainer<Organization>>());
        return result;
    }

    private static EntityContainer<Organization> mainEmployment(Traveller traveller) {
        return Optional.ofNullable(traveller).map(Traveller::getPassenger).map(EntityStorageHelper::resolve).map(EntityContainer::getEntity).map(ProfileHelper::getMainEmployment).orElse(null);
    }

    private static CirToken cirToken(EntityContainer<Organization> organizationCtr, PCIDSSServerExchangeSettings pcidssServerExchangeSettings, Set<EntityContainer<Organization>> graph) {
        if (!CirHelper.cirEnabled(pcidssServerExchangeSettings) || Objects.isNull(organizationCtr) || graph.contains(organizationCtr)) {
            return null;
        }
        graph.add(organizationCtr);
        EntityReference organizationRef = organizationCtr.toReference();
        Optional<CirToken> cirTokenOptional = pcidssServerExchangeSettings.getAgencyTokens().stream().filter(Objects::nonNull).filter(cirToken -> organizationRef.equals((Object)cirToken.getAgencyProfile())).filter(cirToken -> Objects.nonNull(cirToken.getTokenData())).findAny();
        if (cirTokenOptional.isPresent()) {
            return cirTokenOptional.get();
        }
        Organization organization = (Organization)organizationCtr.getEntity();
        if (!organization.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            return null;
        }
        return CirHelper.cirToken((EntityContainer<Organization>)EntityStorageHelper.resolve((EntityReference)organization.getParent()), pcidssServerExchangeSettings, graph);
    }

    public static PCIDSSServerExchangeSettings getSettings() {
        EntityContainer entityContainer = EntityStorage.get().load(PCIDSSServerExchangeSettings.class, UniqueSettingsRegistry.get().getUidByClassName(PCIDSSServerExchangeSettings.class.getName()));
        if (entityContainer == null) {
            return null;
        }
        return (PCIDSSServerExchangeSettings)entityContainer.getEntity();
    }

    public static boolean cirEnabled(PCIDSSServerExchangeSettings cirSettings) {
        return cirSettings != null && cirSettings.isEnabled();
    }

    public static boolean isEnabled() {
        return CirHelper.cirEnabled(CirHelper.getSettings());
    }

    private static DateFormat expirationDateFormat() {
        return new SimpleDateFormat("MMyy");
    }

    public static MiscUtil.Pair<EntityReference<Organization>, String> cirToken(PCIDSSServerExchangeSettings settings, EntityReference<?> reference) {
        if (!CirHelper.cirEnabled(settings)) {
            return null;
        }
        if (Objects.isNull(reference)) {
            throw Xeption.forDeveloper((String)"null EntityReference", (Object[])new Object[0]);
        }
        Class referenceType = reference.getType();
        if (Organization.class.isAssignableFrom(referenceType)) {
            EntityReference<?> orgRef = reference;
            return CirHelper.findAuthTokenByOrganizationParentsOrContracts(settings, orgRef);
        }
        if (Person.class.isAssignableFrom(referenceType)) {
            EntityReference<?> perRef = reference;
            return CirHelper.findAuthTokenByPersonJobs(settings, perRef);
        }
        throw Xeption.forDeveloper((String)("bad EntityReference type " + referenceType), (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Card updateCard(Card card, PCIDSSServerExchangeSettings settings, String agencyToken) throws Exception {
        if (!CirHelper.cirEnabled(settings)) {
            return card;
        }
        if (TextUtil.nonBlank((String)card.getNumber()) && TextUtil.nonBlank((String)card.getCirUid())) {
            return card;
        }
        URL url = new URL(CirHelper.getAddressWithEndPoint(settings, "syncCardData"));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(agencyToken));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        String date = CirHelper.expirationDateFormat().format(card.getExpiration());
        JSONObject cardObject = new JSONObject();
        cardObject.put("xtripUid", (Object)card.getUid());
        if (card.getCirUid() != null && !card.getCirUid().isEmpty()) {
            cardObject.put("cirUid", (Object)card.getCirUid());
        }
        cardObject.put("expirationDate", (Object)date);
        cardObject.put("cardholderName", (Object)TextUtil.nonNullStr((String)card.getNameOnCard()));
        String cardEntity = cardObject.toString();
        connection.setRequestMethod("POST");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
            int bytesRead;
            writer.write(cardEntity);
            ((Writer)writer).flush();
            if (connection.getResponseCode() != 200) {
                throw new Exception("Unable to send card to CIR. Response code: " + connection.getResponseCode());
            }
            InputStream inputStream = connection.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buff = new byte[256];
            while ((bytesRead = inputStream.read(buff, 0, buff.length)) != -1) {
                outputStream.write(buff, 0, bytesRead);
            }
            outputStream.flush();
            String response = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            JSONObject jsonResponse = new JSONObject(response);
            card.setNumber(jsonResponse.getString("truncatedPan"));
            card.setCirUid(jsonResponse.getString("cirUid"));
            if (!jsonResponse.isNull("cardholderName")) {
                card.setNameOnCard(jsonResponse.getString("cardholderName"));
            }
            if (!jsonResponse.isNull("expirationDate")) {
                String expirationDateString = jsonResponse.getString("expirationDate");
                Date expirationDate = TextUtil.nonBlank((String)expirationDateString) ? CirHelper.expirationDateFormat().parse(expirationDateString) : null;
                card.setExpiration(expirationDate);
            }
        }
        finally {
            connection.disconnect();
        }
        return card;
    }

    /*
     * Loose catch block
     */
    public static Card getCardByCirUid(String cirUid, String cirToken) throws Exception {
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        if (!CirHelper.cirEnabled(settings)) {
            throw Xeption.forAdmin((String)Messages.cirSettingsNotEnabled, (Object[])new Object[0]);
        }
        URL url = new URL(CirHelper.getAddressWithEndPoint(settings, "card"));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(cirToken));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
                String expirationDateString;
                int bytesRead;
                writer.write(cirUid);
                ((Writer)writer).flush();
                if (connection.getResponseCode() != 200) {
                    throw new Exception("Unable to get card from CIR. Response code: " + connection.getResponseCode());
                }
                InputStream inputStream = connection.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buff = new byte[256];
                while ((bytesRead = inputStream.read(buff, 0, buff.length)) != -1) {
                    outputStream.write(buff, 0, bytesRead);
                }
                outputStream.flush();
                String response = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                JSONObject jsonResponse = new JSONObject(response);
                Card card = new Card();
                String number = jsonResponse.getString("pan");
                card.setNumber(number);
                card.setCirUid(jsonResponse.getString("uid"));
                if (!jsonResponse.isNull("cardholderName")) {
                    card.setNameOnCard(jsonResponse.getString("cardholderName"));
                }
                if (!jsonResponse.isNull("expirationDate") && TextUtil.nonBlank((String)(expirationDateString = jsonResponse.getString("expirationDate")))) {
                    Date expirationDate = CirHelper.expirationDateFormat().parse(expirationDateString);
                    card.setExpiration(expirationDate);
                }
                card.setVendor(CardVendorUtils.determineCardIssuer(number));
                Card card2 = card;
                return card2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    public static String prepareNewCard(Card card, String agencyToken, PCIDSSServerExchangeSettings settings) throws Exception {
        if (!CirHelper.cirEnabled(settings)) {
            throw new IllegalArgumentException("Cir is disabled in settings");
        }
        if (card.getExpiration() == null) {
            throw new IllegalArgumentException("Expiration date is null");
        }
        URL url = new URL(CirHelper.getAddressWithEndPoint(settings, "addCardPrepare"));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(agencyToken));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        JSONObject cardObject = new JSONObject();
        cardObject.put("xtripUid", (Object)card.getUid());
        cardObject.put("expirationDate", (Object)CirHelper.expirationDateFormat().format(card.getExpiration()));
        cardObject.put("cardholderName", (Object)TextUtil.nonNullStr((String)card.getNameOnCard()));
        String cardData = cardObject.toString();
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
                writer.write(cardData);
                ((Writer)writer).flush();
                if (connection.getResponseCode() != 200) {
                    throw new Exception("Unable to send card data to CIR. Response code: " + connection.getResponseCode());
                }
                InputStream inputStream = connection.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IoUtil.copyStream((InputStream)inputStream, (OutputStream)outputStream, (int)256);
                outputStream.flush();
                String response = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                JSONObject jsonResponse = new JSONObject(response);
                String string = jsonResponse.getString("addCardUrl");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCard(Card card, PCIDSSServerExchangeSettings settings, String agencyToken) throws Exception {
        if (!CirHelper.cirEnabled(settings)) {
            return;
        }
        URL url = new URL(CirHelper.getAddressWithEndPoint(settings, "cards/" + card.getCirUid()));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(agencyToken));
        connection.setDoOutput(false);
        connection.setDoInput(true);
        connection.setRequestMethod("DELETE");
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode != 200 && responseCode != 204) {
                throw new Exception("Cannot delete card, response code: " + responseCode);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static String getAddressWithEndPoint(PCIDSSServerExchangeSettings settings, String endPoint) {
        return settings.getServerAddress() + "/" + endPoint;
    }

    public static void writeNewCIRKeyToFile(PrivateKey newPrivateKey, String newKeyFileName, String newKeyPassword) throws Exception {
        SecurityHelper.PBE pbe = new SecurityHelper.PBE(newKeyPassword.toCharArray());
        SecurityHelper.PBEStorage storage = pbe.encrypt(newPrivateKey.getEncoded());
        Files.write(Paths.get(newKeyFileName, new String[0]), SecurityHelper.PBEStorage.write((SecurityHelper.PBEStorage)storage), new OpenOption[0]);
    }

    public static int sendCIRKeyToTheServer(PublicKey publicKey, PrivateKey privateKey, PCIDSSServerExchangeSettings settings, EntityReference<Organization> organizationRef) throws Exception {
        if (!CirHelper.cirEnabled(settings)) {
            return 400;
        }
        JSONObject payload = new JSONObject();
        payload.put("key", (Object)Base64.getEncoder().encodeToString(publicKey.getEncoded()));
        URL url = new URL(CirHelper.getAddressWithEndPoint(settings, "setKey"));
        return CirHelper.packJsonAndSendToServer(privateKey, payload, url, settings, organizationRef);
    }

    public static int sendCIRClaimToTheServer(String message, String email, String keyFileName, String keyPassword, PCIDSSServerExchangeSettings settings, EntityReference<Organization> organizationRef) throws Exception {
        if (!CirHelper.cirEnabled(settings)) {
            return 400;
        }
        JSONObject payload = new JSONObject();
        payload.put("message", (Object)message);
        payload.put("email", (Object)email);
        URL url = new URL(CirHelper.getAddressWithEndPoint(settings, "processMessage"));
        SecurityHelper.PBEStorage storage = SecurityHelper.PBEStorage.read((byte[])Files.readAllBytes(Paths.get(keyFileName, new String[0])));
        SecurityHelper.PBE pbe = new SecurityHelper.PBE(keyPassword.toCharArray());
        PrivateKey key = SecurityHelper.createPrivateKey((byte[])pbe.decrypt(storage));
        return CirHelper.packJsonAndSendToServer(key, payload, url, settings, organizationRef);
    }

    /*
     * Loose catch block
     */
    public static String getNewCardUrl(String profileUid, String successBackUrl, String failureBackUrl, String callbackUrl, EntityReference<Organization> organizationRef) throws Exception {
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        if (!CirHelper.cirEnabled(cirSettings)) {
            throw Xeption.forAdmin((String)Messages.cirSettingsNotEnabled, (Object[])new Object[0]);
        }
        String token = cirSettings.getAgencyTokens().stream().filter(Objects::nonNull).filter(cirToken -> TextUtil.equals((String)cirToken.getAgencyProfile().getUid(), (String)organizationRef.getUid(), (boolean)false)).findAny().orElseThrow(() -> {
            EntityContainer orgCtr = EntityStorageHelper.resolve((EntityReference)organizationRef);
            String orgName = ((Organization)orgCtr.getEntity()).getFullName().toString();
            return Xeption.forAdmin((String)Messages.cirAgencyTokenNotFound, (Object[])new Object[]{cirSettings.getName(), orgName});
        }).getTokenData();
        URL url = new URL(CirHelper.getAddressWithEndPoint(cirSettings, "getNewCardLink"));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(token));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        JSONObject requestData = new JSONObject();
        requestData.put("profileUid", (Object)profileUid);
        requestData.put("successBackUrl", (Object)successBackUrl);
        requestData.put("failureBackUrl", (Object)failureBackUrl);
        requestData.put("callbackUrl", (Object)callbackUrl);
        String request = requestData.toString();
        connection.setRequestMethod("POST");
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
                int bytesRead;
                writer.write(request);
                ((Writer)writer).flush();
                if (connection.getResponseCode() != 200) {
                    throw new Exception("Unable to receive new card link. Response code " + connection.getResponseCode());
                }
                InputStream inputStream = connection.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buff = new byte[256];
                while ((bytesRead = inputStream.read(buff, 0, buff.length)) != -1) {
                    outputStream.write(buff, 0, bytesRead);
                }
                outputStream.flush();
                String response = new String(outputStream.toByteArray(), "UTF-8");
                JSONObject jsonResponse = new JSONObject(response);
                String string = jsonResponse.getString("url");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseData send(String data, URL url, PCIDSSServerExchangeSettings settings, EntityReference<Organization> organizationRef, boolean empty) throws Exception {
        ResponseData responseData;
        block19: {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            responseData = new ResponseData();
            responseData.setCode(400);
            try {
                connection.setUseCaches(false);
                connection.setInstanceFollowRedirects(false);
                connection.setRequestMethod("POST");
                CirToken token = settings.getAgencyTokens().stream().filter(item -> item.getAgencyProfile().equals((Object)organizationRef)).findAny().orElse(null);
                if (token != null) {
                    connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(token.getTokenData()));
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    try (OutputStream os = connection.getOutputStream();){
                        os.write(data.getBytes(StandardCharset.UTF_8));
                    }
                    responseData.setCode(connection.getResponseCode());
                    if (responseData.getCode() == 200) {
                        String value = null;
                        if (!empty) {
                            value = IOUtils.toString((InputStream)connection.getInputStream(), (String)"utf-8");
                        }
                        responseData.setValue(value);
                    }
                    break block19;
                }
                throw new Exception("No token found for agency " + organizationRef);
            }
            finally {
                connection.disconnect();
            }
        }
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int packJsonAndSendToServer(PrivateKey privateKey, JSONObject payload, URL url, PCIDSSServerExchangeSettings settings, EntityReference<Organization> organizationRef) throws Exception {
        RSASSASigner signer = new RSASSASigner(privateKey);
        JWSObject jws = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.PS512).keyID("none").build(), new Payload(payload.toString()));
        jws.sign((JWSSigner)signer);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        int responseCode = 400;
        try {
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            String token = settings.getAgencyTokens().stream().filter(cirToken -> cirToken.getAgencyProfile().equals((Object)organizationRef)).findAny().orElseThrow(() -> new Exception("No token found for agency " + organizationRef.getCaption())).getTokenData();
            connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(token));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            try (OutputStream os = connection.getOutputStream();){
                os.write(jws.serialize().getBytes(StandardCharset.UTF_8));
            }
            responseCode = connection.getResponseCode();
        }
        finally {
            connection.disconnect();
        }
        return responseCode;
    }

    /*
     * Loose catch block
     */
    public static MultiAgencyTokenResponse getMultiAgencyToken(String cirBaseUrl, UUID uid, List<CirToken> agencyTokens) throws Exception {
        JSONObject request = new JSONObject();
        if (uid == null) {
            request.put("uid", (Object)"");
        } else {
            request.put("uid", (Object)uid.toString());
        }
        JSONArray tokens = new JSONArray();
        for (CirToken agencyToken : agencyTokens) {
            JSONObject jsonToken = new JSONObject();
            jsonToken.put("agencyUid", (Object)agencyToken.getAgencyUid());
            jsonToken.put("tokenData", (Object)agencyToken.getTokenData());
            tokens.put((Object)jsonToken);
        }
        request.put("tokens", (Object)tokens);
        HttpURLConnection connection = (HttpURLConnection)new URL(cirBaseUrl + "/authenticateExternalSystem").openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        try {
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(request.toString().getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    throw new Exception("Unexpected CIR return code: " + responseCode);
                }
                String responseString = IOUtils.toString((InputStream)connection.getInputStream());
                JSONObject responseJSON = new JSONObject(responseString);
                MultiAgencyTokenResponse multiAgencyTokenResponse = new MultiAgencyTokenResponse(UUID.fromString(responseJSON.getString("uid")), responseJSON.getString("token"));
                return multiAgencyTokenResponse;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static UUID getAgencyUidFromToken(String token) throws Exception {
        JWEObject jweObject = JWEObject.parse((String)token);
        return UUID.fromString(jweObject.getHeader().getCustomParam("agencyUid").toString());
    }

    public static void setCookie(HttpURLConnection connection, PCIDSSServerExchangeSettings cirSettings, String refUID) {
        if (!CirHelper.cirEnabled(cirSettings)) {
            return;
        }
        for (CirToken cirToken : cirSettings.getAgencyTokens()) {
            if (!TextUtil.isSame((String)refUID, (String)cirToken.getAgencyProfile().getUid())) continue;
            connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(cirToken.getTokenData()));
            return;
        }
    }

    public static String appToken2Cookie(String cookieValue) {
        if (TextUtil.isBlank((String)cookieValue)) {
            throw new IllegalArgumentException("Token is absent: " + cookieValue);
        }
        return "app-token-2=" + cookieValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int testCirConnection(String cirServerAddress, String token) throws Exception {
        URL url = new URL(cirServerAddress + "/currentUser");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie(token));
            connection.connect();
            int n = connection.getResponseCode();
            return n;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    public static MiscUtil.Pair<String, Date> createAddNewCardLink(EntityReference<Person> person, String callbackUrl) throws Exception {
        PCIDSSServerExchangeSettings cirSettings = CirHelper.getSettings();
        if (!CirHelper.cirEnabled(cirSettings)) {
            throw Xeption.forAdmin((String)Messages.cirSettingsNotEnabled, (Object[])new Object[0]);
        }
        TextUtil.requireNonBlank((String)callbackUrl, (String)"Callback url is absent");
        MiscUtil.Pair<EntityReference<Organization>, String> token = CirHelper.findAuthTokenByPersonJobs(cirSettings, person);
        if (token == null) {
            throw Xeption.forAdmin((String)Messages.cirAgencyTokenNotFound, (Object[])new Object[]{cirSettings.getName(), person.toString()});
        }
        URL url = new URL(CirHelper.getAddressWithEndPoint(cirSettings, "getNewCardByTravellerLink"));
        JSONObject requestData = new JSONObject();
        requestData.put("profileUid", (Object)person.getUid());
        requestData.put("profileType", (Object)person.getType().getSimpleName().toUpperCase());
        requestData.put("callbackUrl", (Object)callbackUrl);
        String request = requestData.toString();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.addRequestProperty("Cookie", CirHelper.appToken2Cookie((String)token.getSecond()));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));){
                int bytesRead;
                writer.write(request);
                ((Writer)writer).flush();
                if (connection.getResponseCode() != 200) {
                    throw new Exception("Unable to receive new card link. Response code " + connection.getResponseCode());
                }
                InputStream inputStream = connection.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buff = new byte[256];
                while ((bytesRead = inputStream.read(buff, 0, buff.length)) != -1) {
                    outputStream.write(buff, 0, bytesRead);
                }
                outputStream.flush();
                String response = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                JSONObject jsonResponse = new JSONObject(response);
                String newCardUrl = jsonResponse.getString("url");
                String expirationTimeString = jsonResponse.getString("expirationDateTime");
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(expirationTimeString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                Date expirationTime = Date.from(zonedDateTime.toInstant());
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)newCardUrl, (Object)expirationTime);
                return pair;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static MiscUtil.Pair<EntityReference<Organization>, String> findAuthTokenByPersonJobs(PCIDSSServerExchangeSettings settings, EntityReference<Person> ref) {
        EntityStorage es = EntityStorage.get();
        EntityReference per = ref;
        HashSet<EntityReference> usedRefs = new HashSet<EntityReference>();
        while (per != null && !usedRefs.contains(per)) {
            Person person = (Person)es.resolve(per).getEntity();
            MiscUtil.Pair<EntityReference<Organization>, String> token = CirHelper.findAuthTokenByPersonJobs(settings, person);
            if (Objects.nonNull(token)) {
                return token;
            }
            usedRefs.add(per);
            per = person.getParent();
        }
        return null;
    }

    public static MiscUtil.Pair<EntityReference<Organization>, String> findAuthTokenByPersonJobs(PCIDSSServerExchangeSettings settings, Person person) {
        List employments = person.getEmployments().stream().filter(emp -> emp.getOrganization() != null && (emp.getClosed() == null || emp.getClosed().after(new Date()))).collect(Collectors.toList());
        for (PersonEmployment employment : employments) {
            MiscUtil.Pair<EntityReference<Organization>, String> token = CirHelper.findAuthTokenByOrganizationParentsOrContracts(settings, (EntityReference<Organization>)employment.getOrganization());
            if (!Objects.nonNull(token)) continue;
            return token;
        }
        return null;
    }

    public static MiscUtil.Pair<EntityReference<Organization>, String> findAuthTokenByOrganizationParentsOrContracts(PCIDSSServerExchangeSettings settings, EntityReference<Organization> organizationRef) {
        HashSet<EntityReference> usedRefs = new HashSet<EntityReference>();
        EntityReference org = organizationRef;
        while (org != null && !usedRefs.contains(org)) {
            for (CirToken token : settings.getAgencyTokens()) {
                if (!token.getAgencyProfile().equals(org) || !TextUtil.nonBlank((String)token.getTokenData())) continue;
                return new MiscUtil.Pair((Object)token.getAgencyProfile(), (Object)token.getTokenData());
            }
            usedRefs.add(org);
            org = ((Organization)EntityStorage.get().resolve(org).getEntity()).getParent();
        }
        return CirHelper.findAuthTokenByOrganizationContracts(settings, organizationRef);
    }

    private static MiscUtil.Pair<EntityReference<Organization>, String> findAuthTokenByOrganizationContracts(PCIDSSServerExchangeSettings settings, EntityReference<Organization> organizationRef) {
        EntityStorage es = EntityStorage.get();
        HashSet<EntityReference> usedRefs = new HashSet<EntityReference>();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(organizationRef);
        while (!queue.isEmpty()) {
            EntityReference org = (EntityReference)queue.remove();
            for (CirToken token : settings.getAgencyTokens()) {
                if (token.getAgencyProfile().equals((Object)org) && TextUtil.nonBlank((String)token.getTokenData())) {
                    return new MiscUtil.Pair((Object)token.getAgencyProfile(), (Object)token.getTokenData());
                }
                usedRefs.add(org);
            }
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)org));
            List indices = es.search(ContractCustomerIndex.class, query).getData();
            for (ContractCustomerIndex index : indices) {
                if (index.getSupplier() == null || usedRefs.contains(index.getSupplier()) || queue.contains(index.getSupplier())) continue;
                queue.add(index.getSupplier());
            }
            query.getCriteria().getCriterions().clear();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)org.getUid()));
            List tripartiteContractIndices = es.search(TripartiteContractIndex.class, query).getData();
            for (TripartiteContractIndex index : tripartiteContractIndices) {
                if (index.getAgency() == null || usedRefs.contains(index.getAgency()) || queue.contains(index.getAgency())) continue;
                queue.add(index.getAgency());
            }
        }
        return null;
    }

    public static String agencyToken(PCIDSSServerExchangeSettings settings, EntityReference<Organization> agencyRef) {
        if (!CirHelper.cirEnabled(settings) || Objects.isNull(agencyRef)) {
            return null;
        }
        return settings.getAgencyTokens().stream().filter(Objects::nonNull).filter(cirToken -> agencyRef.equals((Object)cirToken.getAgencyProfile())).map(CirToken::getTokenData).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static class ResponseData {
        private int code;
        private String value;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class MultiAgencyTokenResponse {
        public final UUID uid;
        public final String token;

        MultiAgencyTokenResponse(UUID uid, String token) {
            this.uid = uid;
            this.token = token;
        }
    }
}

