/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dbf;

import com.linuxense.javadbf.DBFField;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class DbfRow {
    private final Map<DBFField, Object> values = new HashMap<DBFField, Object>();

    public Object getValue(DBFField field) {
        if (field == null) {
            return null;
        }
        return this.values.get(field);
    }

    public void setValue(DBFField field, Object value) {
        if (field == null) {
            return;
        }
        this.values.put(field, value);
    }

    public StringBuilder getContent() {
        NumberFormat snNumberFormat = NumberFormat.getNumberInstance();
        snNumberFormat.setGroupingUsed(false);
        snNumberFormat.setMaximumFractionDigits(0);
        StringBuilder result = new StringBuilder();
        int i = 1;
        for (DBFField dbfField : this.values.keySet()) {
            result.append(i + ".\t" + dbfField.getName() + " :\t");
            Object val = this.getValue(dbfField);
            if (val != null) {
                if (val instanceof Double) {
                    result.append(snNumberFormat.format((Double)val));
                } else if (val instanceof Date) {
                    result.append(val.toString());
                } else {
                    result.append(val.toString());
                }
            } else {
                result.append("null");
            }
            result.append("\n");
            ++i;
        }
        return result;
    }
}

