/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.dbf;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dbf.DbfFile;
import com.gridnine.xtrip.common.model.dbf.DbfRow;
import com.gridnine.xtrip.common.model.dbf.DbfUtil;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.linuxense.javadbf.DBFField;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LccPaymentDbfExportWorker {
    public List<Message> exportPayment(EntityContainer<BookingFile> bfCtr, Payment payment, String agentName, File outputFile) throws Exception {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        if (payment == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0441\u0447\u0435\u0442", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity()))));
            this.addStandardErrorMessage(messages, null);
            return new ArrayList<Message>(messages);
        }
        EntityContainer customerCtr = EntityStorage.get().resolve(((BookingFile)bfCtr.getEntity()).getCustomerProfile());
        if (customerCtr == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044c", TextUtil.buildFullNumber((CompositeNumber)payment)));
            this.addStandardErrorMessage(messages, payment);
            return new ArrayList<Message>(messages);
        }
        EntityContainer<Organization> agencyCtr = FinanceDocumentsHelper.getAgency((BookingFile)bfCtr.getEntity(), payment);
        if (agencyCtr == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e", TextUtil.buildFullNumber((CompositeNumber)payment)));
            this.addStandardErrorMessage(messages, payment);
            return new ArrayList<Message>(messages);
        }
        EntityContainer supplierCtr = EntityStorage.get().resolve(payment.getSupplier());
        if (supplierCtr == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a", TextUtil.buildFullNumber((CompositeNumber)payment)));
            this.addStandardErrorMessage(messages, payment);
            return new ArrayList<Message>(messages);
        }
        DbfFile dbfFile = new DbfFile(LccPaymentDbfExportWorker.createFields());
        Set<Product> products = this.getProducts((BookingFile)bfCtr.getEntity(), payment, messages);
        if (products.isEmpty()) {
            this.addStandardErrorMessage(messages, payment);
            return new ArrayList<Message>(messages);
        }
        Set<LCCExportRecord> records = this.createRecords(products, payment, messages);
        if (records.isEmpty()) {
            this.addStandardErrorMessage(messages, payment);
            return new ArrayList<Message>(messages);
        }
        for (LCCExportRecord record : records) {
            DbfRow row = this.addRow(dbfFile, record, bfCtr, payment, (EntityContainer<Organization>)customerCtr, agencyCtr, (EntityContainer<Organization>)supplierCtr, agentName, messages);
            if (row == null) {
                this.addStandardErrorMessage(messages, payment);
                return new ArrayList<Message>(messages);
            }
            dbfFile.getRows().add(row);
        }
        DbfUtil.write(dbfFile, outputFile);
        return new ArrayList<Message>(messages);
    }

    private DbfRow addRow(DbfFile dbfFile, LCCExportRecord record, EntityContainer<BookingFile> bfCtr, Payment payment, EntityContainer<Organization> customerCtr, EntityContainer<Organization> agencyCtr, EntityContainer<Organization> supplierCtr, String agentName, Set<Message> messages) throws Exception {
        DbfRow result = new DbfRow();
        result.setValue(dbfFile.getField(0), TextUtil.buildFullNumber((CompositeNumber)payment));
        result.setValue(dbfFile.getField(1), payment.getDate());
        EntityContainer customerParentCtr = EntityStorage.get().resolve(((Organization)customerCtr.getEntity()).getParent());
        if (!this.fillOrganizationSection(dbfFile, result, (Organization)customerCtr.getEntity(), (EntityContainer<Organization>)customerParentCtr, customerParentCtr != null ? EntityStorage.get().resolve(((Organization)customerParentCtr.getEntity()).getParent()) : null, 2, false, messages)) {
            return null;
        }
        result.setValue(dbfFile.getField(21), "0");
        Product product = record.product;
        if (product.getStatus() == ProductStatus.REFUND) {
            result.setValue(dbfFile.getField(22), "1");
        }
        result.setValue(dbfFile.getField(23), 1.0);
        Airline airline = (Airline)DictionaryCache.get().resolveReference(product.getCarrier());
        if (airline == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 {0}", product.getCarrier() != null ? product.getCarrier() : "???"));
            return null;
        }
        result.setValue(dbfFile.getField(24), airline.getAirlineNumber());
        result.setValue(dbfFile.getField(25), product.getSystemNumber());
        if (record.penaltyItem != null) {
            if (record.penaltyItem.getProductUids().size() == 0) {
                messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0448\u0442\u0440\u0430\u0444 \u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d \u043d\u0438 \u0441 \u043e\u0434\u043d\u0438\u043c \u0438\u0437 \u0431\u0438\u043b\u0435\u0442\u043e\u0432", TextUtil.buildFullNumber((CompositeNumber)payment)));
                return null;
            }
            PriceItem priceItem = new PriceItem(record.penaltyItem);
            result.setValue(dbfFile.getField(26), priceItem.total);
            result.setValue(dbfFile.getField(27), priceItem.vat);
        } else {
            result.setValue(dbfFile.getField(26), 0.0);
            result.setValue(dbfFile.getField(27), 0.0);
        }
        result.setValue(dbfFile.getField(28), 0.0);
        PriceItem productPriceItem = new PriceItem(record.productItem);
        result.setValue(dbfFile.getField(29), productPriceItem.total);
        result.setValue(dbfFile.getField(30), productPriceItem.vat);
        result.setValue(dbfFile.getField(31), 0.0);
        result.setValue(dbfFile.getField(32), productPriceItem.total);
        if (payment.isCanceled()) {
            result.setValue(dbfFile.getField(33), "1");
        }
        if (record.feeItems.size() > 6) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0447\u0438\u0441\u043b\u043e \u0441\u0431\u043e\u0440\u043e\u0432 {0} \u0432 \u0441\u0447\u0435\u0442\u0435 {1} \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 6", record.feeItems.size(), TextUtil.buildFullNumber((CompositeNumber)payment)));
            return null;
        }
        for (int n = 0; n < 6; ++n) {
            if (n < record.feeItems.size()) {
                FeeProperties fee;
                BillingItem item = record.feeItems.get(n);
                PriceItem itemPrice = new PriceItem(item);
                EntityContainer ctr = EntityStorage.get().resolve(item.getCommissionType());
                if (ctr == null) {
                    messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0441\u0431\u043e\u0440\u0430 {0}  \u0432 \u0441\u0447\u0435\u0442\u0435 {1}", item.getName(), TextUtil.buildFullNumber((CompositeNumber)payment)));
                    return null;
                }
                BaseCommissionProperties comm = (BaseCommissionProperties)ctr.getEntity();
                if (comm instanceof FeeProperties) {
                    fee = (FeeProperties)comm;
                    try {
                        result.setValue(dbfFile.getField(34 + n * 9), Double.valueOf(fee.getFinanceCode()));
                    }
                    catch (Exception e) {
                        messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430 {0} \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c", fee.getDisplayName() != null ? fee.getDisplayName() : "???"));
                        return null;
                    }
                    result.setValue(dbfFile.getField(35 + n * 9), fee.getFinanceName());
                    result.setValue(dbfFile.getField(36 + n * 9), itemPrice.total);
                    result.setValue(dbfFile.getField(37 + n * 9), itemPrice.vat);
                    result.setValue(dbfFile.getField(38 + n * 9), 0.0);
                    result.setValue(dbfFile.getField(39 + n * 9), itemPrice.total);
                    result.setValue(dbfFile.getField(40 + n * 9), "1");
                    if (fee.getOperation() == Operation.REFUND || fee.getOperation() == Operation.EXCHANGE) {
                        result.setValue(dbfFile.getField(41 + n * 9), "1");
                    }
                    result.setValue(dbfFile.getField(42 + n * 9), "0");
                }
                if (comm instanceof PaymentFeeProperties) {
                    fee = (PaymentFeeProperties)comm;
                    try {
                        result.setValue(dbfFile.getField(34 + n * 9), Double.valueOf(fee.getFinanceCode()));
                    }
                    catch (Exception e) {
                        messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043a\u043e\u0434 \u0441\u0431\u043e\u0440\u0430 {0} \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c", fee.getDisplayName() != null ? fee.getDisplayName() : "???"));
                        return null;
                    }
                    result.setValue(dbfFile.getField(35 + n * 9), fee.getFinanceName());
                    result.setValue(dbfFile.getField(36 + n * 9), itemPrice.total);
                    result.setValue(dbfFile.getField(37 + n * 9), itemPrice.vat);
                    result.setValue(dbfFile.getField(38 + n * 9), 0.0);
                    result.setValue(dbfFile.getField(39 + n * 9), itemPrice.total);
                    result.setValue(dbfFile.getField(40 + n * 9), "1");
                    if (fee.isChargeOnRefund() && product.getStatus() == ProductStatus.REFUND) {
                        result.setValue(dbfFile.getField(41 + n * 9), "1");
                    }
                    result.setValue(dbfFile.getField(42 + n * 9), "0");
                }
                messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0441\u0431\u043e\u0440\u0430 {0}  \u0432 \u0441\u0447\u0435\u0442\u0435 {1}", item.getName(), TextUtil.buildFullNumber((CompositeNumber)payment)));
                continue;
            }
            result.setValue(dbfFile.getField(34 + n * 9), 0.0);
            result.setValue(dbfFile.getField(36 + n * 9), 0.0);
            result.setValue(dbfFile.getField(37 + n * 9), 0.0);
            result.setValue(dbfFile.getField(38 + n * 9), 0.0);
            result.setValue(dbfFile.getField(39 + n * 9), 0.0);
        }
        EntityContainer supplierParentCtr = EntityStorage.get().resolve(((Organization)supplierCtr.getEntity()).getParent());
        if (!this.fillOrganizationSection(dbfFile, result, (Organization)supplierCtr.getEntity(), (EntityContainer<Organization>)supplierParentCtr, supplierParentCtr != null ? EntityStorage.get().resolve(((Organization)supplierParentCtr.getEntity()).getParent()) : null, 88, true, messages)) {
            return null;
        }
        result.setValue(dbfFile.getField(107), DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB"));
        if (payment.getFop() == null || payment.getFop().getType() == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0438\u043f \u043e\u043f\u043b\u0430\u0442\u044b", TextUtil.buildFullNumber((CompositeNumber)payment)));
            return null;
        }
        String fopCode = this.getFopTypeCode(payment.getFop().getType());
        result.setValue(dbfFile.getField(108), fopCode);
        if (payment.getFop().getType() == PaymentType.CREDIT_CARD) {
            if (payment.getFop().getCard() == null || payment.getFop().getCard().getVendor() == null) {
                messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0438\u043f \u043a\u0440\u0435\u0434\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b", TextUtil.buildFullNumber((CompositeNumber)payment)));
                return null;
            }
            String cardCode = null;
            switch (payment.getFop().getCard().getVendor()) {
                case AMEX: {
                    cardCode = "AX";
                    break;
                }
                case DINERS_CLUB: {
                    cardCode = "DC";
                    break;
                }
                case MASTERCARD: {
                    cardCode = "CA";
                    break;
                }
                case JCB: {
                    cardCode = "JC";
                    break;
                }
                default: {
                    cardCode = "VI";
                }
            }
            result.setValue(dbfFile.getField(109), cardCode);
            result.setValue(dbfFile.getField(110), payment.getFop().getCard().getNumber());
        }
        result.setValue(dbfFile.getField(111), record.discount != null ? record.discount : Double.valueOf(0.0));
        if (TextUtil.isBlank((String)agentName)) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0430\u0433\u0435\u043d\u0442, \u0432\u044b\u043f\u0438\u0441\u0430\u0432\u0448\u0438\u0439 \u043d\u0430\u043a\u043b\u0430\u0434\u043d\u0443\u044e", TextUtil.buildFullNumber((CompositeNumber)payment)));
            return null;
        }
        result.setValue(dbfFile.getField(112), agentName);
        Date departureDate = null;
        Date arrivalDate = null;
        for (Object st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (departureDate == null && seg.getStartDate() == null) {
                    messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0434\u0430\u0442\u0443 \u0432\u044b\u043b\u0435\u0442\u0430", TextUtil.buildFullNumber((CompositeNumber)payment)));
                    return null;
                }
                if (departureDate == null) {
                    departureDate = seg.getStartDate();
                }
                arrivalDate = seg.getEndDate();
            }
        }
        result.setValue(dbfFile.getField(113), AirProductHelper.getRouteLine(product, null, true, CodeSystem.IATA));
        if (product.getTraveller() == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u0432 \u0431\u0438\u043b\u0435\u0442\u0435 {1} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440", TextUtil.buildFullNumber((CompositeNumber)payment), product.getSystemNumber() != null ? product.getSystemNumber() : "???"));
            return null;
        }
        result.setValue(dbfFile.getField(114), product.getTraveller().getName());
        result.setValue(dbfFile.getField(115), 0.0);
        BigDecimal rate = AirProductHelper.calculateS7Rate(product);
        if (rate == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0443\u0440\u0441 \u043f\u043e \u0431\u0438\u043b\u0435\u0442\u0443 {1}", TextUtil.buildFullNumber((CompositeNumber)payment), product.getSystemNumber() != null ? product.getSystemNumber() : "???"));
            return null;
        }
        result.setValue(dbfFile.getField(134), rate.doubleValue());
        result.setValue(dbfFile.getField(135), 0.0);
        result.setValue(dbfFile.getField(136), AirProductHelper.calculateTransportationType(product) == TransportationType.DOMESTIC ? Double.valueOf(1.0) : Double.valueOf(0.0));
        result.setValue(dbfFile.getField(137), 0.0);
        result.setValue(dbfFile.getField(140), 0.0);
        for (FinanceDocument doc : payment.getFinanceDocuments()) {
            if (doc.getType() == null) {
                messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \"{1}\"", TextUtil.buildFullNumber((CompositeNumber)payment), doc.getTemplate()));
                return null;
            }
            switch (doc.getType()) {
                case INVOICE: {
                    result.setValue(dbfFile.getField(142), TextUtil.buildFullNumber((CompositeNumber)doc));
                    result.setValue(dbfFile.getField(143), doc.getDate());
                    break;
                }
                case INTERNAL_BILL: {
                    result.setValue(dbfFile.getField(144), TextUtil.buildFullNumber((CompositeNumber)doc));
                    result.setValue(dbfFile.getField(145), doc.getDate());
                    break;
                }
                case INVOICE_FACTURA: {
                    result.setValue(dbfFile.getField(146), TextUtil.buildFullNumber((CompositeNumber)doc));
                    result.setValue(dbfFile.getField(147), doc.getDate());
                    break;
                }
                case RECEIPT: {
                    result.setValue(dbfFile.getField(148), TextUtil.buildFullNumber((CompositeNumber)doc));
                    result.setValue(dbfFile.getField(149), doc.getDate());
                    break;
                }
                case CASH_ORDER: {
                    result.setValue(dbfFile.getField(150), TextUtil.buildFullNumber((CompositeNumber)doc));
                    result.setValue(dbfFile.getField(151), doc.getDate());
                    break;
                }
            }
        }
        Organization customer = (Organization)customerCtr.getEntity();
        result.setValue(dbfFile.getField(154), ProfileHelper.getFullName(customer.getCode(), customer.getShortName(), customer.getFullName(), (DictionaryReference<LegalForm>)customer.getLegalForm(), LocaleHelper.getCurrentLocale(), false));
        if (!product.getScns().isEmpty()) {
            result.setValue(dbfFile.getField(155), product.getScns().get(0));
            result.setValue(dbfFile.getField(156), 1.0);
        } else {
            result.setValue(dbfFile.getField(156), 0.0);
        }
        result.setValue(dbfFile.getField(157), customer.getCode().equals(DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null)) ? Double.valueOf(1.0) : Double.valueOf(0.0));
        Organization agency = (Organization)agencyCtr.getEntity();
        result.setValue(dbfFile.getField(158), LccPaymentDbfExportWorker.getInnKpp(agency.getRegistrationId(), agency.getKpp()));
        result.setValue(dbfFile.getField(160), product.getTicketType() != TicketType.OWN ? Double.valueOf(1.0) : Double.valueOf(0.0));
        result.setValue(dbfFile.getField(161), product.getStatus() == ProductStatus.VOID ? Double.valueOf(1.0) : Double.valueOf(0.0));
        result.setValue(dbfFile.getField(163), 0.0);
        result.setValue(dbfFile.getField(164), 0.0);
        result.setValue(dbfFile.getField(165), 0.0);
        result.setValue(dbfFile.getField(166), 0.0);
        result.setValue(dbfFile.getField(167), 0.0);
        result.setValue(dbfFile.getField(168), 0.0);
        result.setValue(dbfFile.getField(169), 0.0);
        result.setValue(dbfFile.getField(170), 0.0);
        result.setValue(dbfFile.getField(171), 1.0);
        if (departureDate != null) {
            result.setValue(dbfFile.getField(172), departureDate);
        }
        if (arrivalDate != null) {
            result.setValue(dbfFile.getField(173), arrivalDate);
        }
        result.setValue(dbfFile.getField(174), product.getMcoCategory() == MCOCategory.PENALTY ? Double.valueOf(1.0) : Double.valueOf(0.0));
        if (payment.getSupplierFop() == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0441\u0447\u0435\u0442\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0444\u043e\u0440\u043c\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u043f\u0435\u0440\u0435\u0434 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u043c", TextUtil.buildFullNumber((CompositeNumber)payment)));
            return null;
        }
        result.setValue(dbfFile.getField(176), this.getFopTypeCode(payment.getSupplierFop().getType()));
        result.setValue(dbfFile.getField(177), product.isEticket() ? Double.valueOf(1.0) : Double.valueOf(0.0));
        result.setValue(dbfFile.getField(178), 0.0);
        result.setValue(dbfFile.getField(179), 0.0);
        return result;
    }

    private String getFopTypeCode(PaymentType type) {
        switch (type) {
            case INVOICE: {
                return "In";
            }
            case CREDIT_CARD: {
                return "CC";
            }
        }
        return "Ca";
    }

    private boolean fillOrganizationSection(DbfFile dbfFile, DbfRow result, Organization profile, EntityContainer<Organization> profileParentCtr, EntityContainer<Organization> profileParentParent, int shift, boolean isSupplier, Set<Message> messages) {
        Organization profileParent;
        String fullName = ProfileHelper.getFullName(profile.getCode(), profile.getShortName(), profile.getFullName(), null, LocaleHelper.getCurrentLocale(), false);
        String code = SystemHelper.findMetadataAsString(profile.getMetadata(), MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
        if (isSupplier) {
            try {
                result.setValue(dbfFile.getField(shift), new Double(code));
                result.setValue(dbfFile.getField(shift + 1), fullName);
            }
            catch (Exception e) {
                messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043a\u043e\u0434 \"{0}\" \u043f\u0440\u043e\u0444\u0438\u043b\u044f \"{1}\" \u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 (\u0417\u0430\u043b\u0430\u0434\u043a\u0430 \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b) \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0446\u0438\u0444\u0440\u043e\u0432\u044b\u043c", code != null ? code : "???", profile.toString()));
                return false;
            }
        } else {
            result.setValue(dbfFile.getField(shift), fullName);
            result.setValue(dbfFile.getField(shift + 1), code);
            if (profileParentParent != null) {
                profileParent = (Organization)profileParentParent.getEntity();
                result.setValue(dbfFile.getField(shift + 4), SystemHelper.findMetadataAsString(profileParent.getMetadata(), MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE));
                result.setValue(dbfFile.getField(shift + 5), ProfileHelper.getFullName(profileParent.getCode(), profileParent.getShortName(), profileParent.getFullName(), null, LocaleHelper.getCurrentLocale(), false));
            }
        }
        if (profileParentCtr != null) {
            profileParent = (Organization)profileParentCtr.getEntity();
            result.setValue(dbfFile.getField(shift + 2), SystemHelper.findMetadataAsString(profileParent.getMetadata(), MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE));
            result.setValue(dbfFile.getField(shift + 3), ProfileHelper.getFullName(profileParent.getCode(), profileParent.getShortName(), profileParent.getFullName(), null, LocaleHelper.getCurrentLocale(), false));
        }
        result.setValue(dbfFile.getField(shift + 6), LccPaymentDbfExportWorker.getInnKpp(profile.getRegistrationId(), profile.getKpp()));
        List<Address> addresses = ProfileHelper.getOrganizationAddresses(profile);
        for (Address address : addresses) {
            AddressType addressType = address.getAddressType();
            if (AddressType.LEGAL.equals((Object)addressType)) {
                result.setValue(dbfFile.getField(shift + 7), ProfileHelper.buildFullAddress(address, LocaleHelper.getCurrentLocale(), false));
                continue;
            }
            if (!AddressType.CONTACT.equals((Object)addressType)) continue;
            result.setValue(dbfFile.getField(shift + 8), ProfileHelper.buildFullAddress(address, LocaleHelper.getCurrentLocale(), false));
        }
        result.setValue(dbfFile.getField(shift + 9), LccPaymentDbfExportWorker.getPhoneNumber(profile.getCommunications()));
        for (int n = 0; n < 3 && profile.getBankAccounts().size() > n; ++n) {
            BankAccount bankAccount = (BankAccount)profile.getBankAccounts().get(n);
            result.setValue(dbfFile.getField(shift + 10 + 3 * n), bankAccount.getSettlementAccount());
            result.setValue(dbfFile.getField(shift + 11 + 3 * n), bankAccount.getBankName());
            result.setValue(dbfFile.getField(shift + 12 + 3 * n), bankAccount.getBik());
        }
        return true;
    }

    private static String getInnKpp(String registrationId, String kpp) {
        if (TextUtil.isBlank((String)kpp)) {
            return !TextUtil.isBlank((String)registrationId) ? registrationId.trim() : null;
        }
        if (TextUtil.isBlank((String)registrationId)) {
            return !TextUtil.isBlank((String)kpp) ? kpp.trim() : null;
        }
        return registrationId.trim() + "\\" + kpp.trim();
    }

    private static String getPhoneNumber(List<Communication> communications) {
        for (Communication comm : communications) {
            CommunicationType type = comm.getType();
            if (!CommunicationType.WORK_PHONE.equals((Object)type) && !CommunicationType.HOME_PHONE.equals((Object)type) && !CommunicationType.MOBILE.equals((Object)type)) continue;
            return comm.getSense();
        }
        return null;
    }

    private void addStandardErrorMessage(Set<Message> messages, Payment payment) {
        messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0441\u0447\u0435\u0442 {0} \u043d\u0435 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d", payment != null ? TextUtil.buildFullNumber((CompositeNumber)payment) : ""));
    }

    private Set<LCCExportRecord> createRecords(Set<Product> products, Payment payment, Set<Message> messages) {
        LinkedHashSet<LCCExportRecord> result = new LinkedHashSet<LCCExportRecord>();
        FinanceDocument bill = null;
        FinanceDocument invoice = null;
        FinanceDocument paymentOrder = null;
        FinanceDocument receipt = null;
        for (FinanceDocument doc : payment.getFinanceDocuments()) {
            if (doc.getType() == null) {
                messages.add(SystemHelper.createMessage(MessageType.WARNING, "\u0442\u0438\u043f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d", doc.getTemplate()));
                continue;
            }
            switch (doc.getType()) {
                case INTERNAL_BILL: {
                    bill = doc;
                    break;
                }
                case INVOICE: {
                    invoice = doc;
                    break;
                }
                case CASH_ORDER: {
                    paymentOrder = doc;
                    break;
                }
                case RECEIPT: {
                    receipt = doc;
                    break;
                }
            }
        }
        for (Product product : products) {
            LCCExportRecord record = new LCCExportRecord();
            record.product = product;
            record.bill = bill;
            record.invoice = invoice;
            record.paymentOrder = paymentOrder;
            record.receipt = receipt;
            for (BillingItem item : payment.getBillingItems()) {
                if (!item.getProductUids().contains(product.getUid())) continue;
                if (item.getServiceType() == null) {
                    messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {0} \u0441\u0447\u0435\u0442\u0430 {1}  \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438", item.getName(), TextUtil.buildFullNumber((CompositeNumber)payment)));
                    return Collections.emptySet();
                }
                switch (item.getServiceType()) {
                    case TICKET: {
                        record.productItem = item;
                        break;
                    }
                    case FEE: {
                        record.feeItems.add(item);
                        break;
                    }
                    case DISCOUNT: {
                        PriceItem priceItem = new PriceItem(item);
                        if (priceItem.total == null) break;
                        record.discount = record.discount != null ? Double.valueOf(record.discount + priceItem.total) : priceItem.total;
                        break;
                    }
                    case PENALTY: {
                        record.penaltyItem = item;
                    }
                }
            }
            result.add(record);
        }
        return result;
    }

    private Set<Product> getProducts(BookingFile bf, Payment payment, Set<Message> messages) {
        LinkedHashSet<Product> result = new LinkedHashSet<Product>();
        for (BillingItem item : payment.getBillingItems()) {
            if (item.getProductUids().isEmpty()) {
                messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {0} \u0441\u0447\u0435\u0442\u0430 {1}  \u043d\u0435\u0442 \u0441\u0441\u044b\u043b\u043e\u043a \u043d\u0430 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u044b", item.getName(), TextUtil.buildFullNumber((CompositeNumber)payment)));
                return Collections.emptySet();
            }
            for (String productUid : item.getProductUids()) {
                BaseProduct prod = BookingHelper.findProduct(bf, productUid);
                if (!(prod instanceof Product)) {
                    messages.add(SystemHelper.createMessage(MessageType.ERROR, "\u043f\u043e\u0437\u0438\u0446\u0438\u0438 {0} \u0441\u0447\u0435\u0442\u0430 {1}  \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u043d\u0430 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442", item.getName(), TextUtil.buildFullNumber((CompositeNumber)payment)));
                    return Collections.emptySet();
                }
                result.add((Product)prod);
            }
        }
        return result;
    }

    private static List<DBFField> createFields() {
        ArrayList<DBFField> fields = new ArrayList<DBFField>();
        fields.add(DbfUtil.createField("NUMDOC", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("DATEDOC", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("NAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("CODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("PARCODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("PARNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("PARPARCODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("PARPARNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("INN", (byte)67, 25, 0));
        fields.add(DbfUtil.createField("LEGALADDR", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("POSTADDR", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("PHONE", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("ACC1", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("BANKNAME1", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("BIC1", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("ACC2", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("BANKNAME2", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("BIC2", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("ACC3", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("BANKNAME3", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("BIC3", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("FSUBAGENT", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("FREFUND", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("SERVCODE", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("AIRCODE", (byte)67, 3, 0));
        fields.add(DbfUtil.createField("NUMTICKET", (byte)67, 16, 0));
        fields.add(DbfUtil.createField("PENALTY", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("PENVAT", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("PENNP", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("PRICE", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("VAT", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("NP", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("TOTAL", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("FDELETE", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGCODE1", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("CHRGNAME1", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("CHRGPRICE1", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGVAT1", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGNP1", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGTOTAL1", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGOWN1", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGREF1", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGNCALC1", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGCODE2", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("CHRGNAME2", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("CHRGPRICE2", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGVAT2", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGNP2", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGTOTAL2", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGOWN2", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGREF2", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGNCALC2", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGCODE3", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("CHRGNAME3", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("CHRGPRICE3", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGVAT3", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGNP3", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGTOTAL3", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGOWN3", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGREF3", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGNCALC3", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGCODE4", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("CHRGNAME4", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("CHRGPRICE4", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGVAT4", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGNP4", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGTOTAL4", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGOWN4", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGREF4", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGNCALC4", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGCODE5", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("CHRGNAME5", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("CHRGPRICE5", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGVAT5", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGNP5", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGTOTAL5", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGOWN5", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGREF5", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGNCALC5", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGCODE6", (byte)78, 4, 0));
        fields.add(DbfUtil.createField("CHRGNAME6", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("CHRGPRICE6", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGVAT6", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGNP6", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGTOTAL6", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("CHRGOWN6", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGREF6", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("CHRGNCALC6", (byte)67, 1, 0));
        fields.add(DbfUtil.createField("SCODE", (byte)78, 5, 0));
        fields.add(DbfUtil.createField("SNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("SPARCODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("SPARNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("SPPARCODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("SPPARNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("SINN", (byte)67, 25, 0));
        fields.add(DbfUtil.createField("SLEGALADDR", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("SPOSTADDR", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("SPHONE", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("SACC1", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("SBANKNAME1", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("SBIC1", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("SACC2", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("SBANKNAME2", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("SBIC2", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("SACC3", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("SBANKNAME3", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("SBIC3", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("CURRCODE", (byte)67, 3, 0));
        fields.add(DbfUtil.createField("FP", (byte)67, 2, 0));
        fields.add(DbfUtil.createField("CCCODE", (byte)67, 3, 0));
        fields.add(DbfUtil.createField("CCNUMBER", (byte)67, 30, 0));
        fields.add(DbfUtil.createField("DISCOUNT", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("AGENTNAME", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("ROUTE", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("PASSNAME", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("KCODE", (byte)78, 5, 0));
        fields.add(DbfUtil.createField("KNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("KPARCODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("KPARNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("KPPARCODE", (byte)67, 8, 0));
        fields.add(DbfUtil.createField("KPPARNAME", (byte)67, 80, 0));
        fields.add(DbfUtil.createField("KINN", (byte)67, 25, 0));
        fields.add(DbfUtil.createField("KLEGALADDR", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("KPOSTADDR", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("KPHONE", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("KACC1", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("KBANKNAME1", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("KBIC1", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("KACC2", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("KBANKNAME2", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("KBIC2", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("KACC3", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("KBANKNAME3", (byte)67, 48, 0));
        fields.add(DbfUtil.createField("KBIC3", (byte)67, 9, 0));
        fields.add(DbfUtil.createField("RATE", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("RATEINV", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("VVLMVL", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("OFFSHOR", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("NUMDOCP", (byte)67, 16, 0));
        fields.add(DbfUtil.createField("DATEDOCP", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("KAVIA", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("KRSNUM", (byte)67, 100, 0));
        fields.add(DbfUtil.createField("INVNUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("INVDATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("NAKNUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("NAKDATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("SFNUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("SFDATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("PKONUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("PKODATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("RKONUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("RKODATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("PONUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("PODATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("PNAME", (byte)67, 120, 0));
        fields.add(DbfUtil.createField("NUMTICBSO", (byte)67, 10, 0));
        fields.add(DbfUtil.createField("FBSP", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("FPRIVATE", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("OURINN", (byte)67, 25, 0));
        fields.add(DbfUtil.createField("CONJ", (byte)67, 32, 0));
        fields.add(DbfUtil.createField("EXTERNAL", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("VOID", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("REMARK", (byte)67, 64, 0));
        fields.add(DbfUtil.createField("NETSUM", (byte)78, 19, 2));
        fields.add(DbfUtil.createField("INTEGRATED", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("CHRGCC1", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("CHRGCC2", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("CHRGCC3", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("CHRGCC4", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("CHRGCC5", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("CHRGCC6", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("BRANCH", (byte)78, 5, 0));
        fields.add(DbfUtil.createField("DEPDATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("ARRDATE", (byte)68, 8, 0));
        fields.add(DbfUtil.createField("MCOPENALTY", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("NUMAGREE", (byte)67, 64, 0));
        fields.add(DbfUtil.createField("FPSUPP", (byte)67, 2, 0));
        fields.add(DbfUtil.createField("ETIC", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("TBSP", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("FSTB", (byte)78, 1, 0));
        fields.add(DbfUtil.createField("SUMDOCNUM", (byte)67, 20, 0));
        fields.add(DbfUtil.createField("SUMDOCDATE", (byte)68, 8, 0));
        return fields;
    }

    static final class PriceItem {
        Double total;
        Double vat;

        PriceItem(BillingItem item) {
            VatAmount amount = item.getAmount();
            if (amount == null) {
                this.total = 0.0;
                this.vat = 0.0;
                return;
            }
            this.total = Math.abs(amount.getTotal().divide(BigDecimal.valueOf(item.getProductUids().size()), 2, RoundingMode.HALF_UP).doubleValue());
            this.vat = Math.abs(amount.getVatAmount().divide(BigDecimal.valueOf(item.getProductUids().size()), 2, RoundingMode.HALF_UP).doubleValue());
        }
    }

    static final class LCCExportRecord {
        Product product;
        BillingItem productItem;
        final List<BillingItem> feeItems = new ArrayList<BillingItem>();
        Double discount;
        FinanceDocument bill;
        FinanceDocument invoice;
        FinanceDocument paymentOrder;
        FinanceDocument receipt;
        BillingItem penaltyItem;

        LCCExportRecord() {
        }
    }
}

