/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.fiscal;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FiscalReceiptCalculatedDataHolder {
    private final List<ReceiptLine> receiptLines = new ArrayList<ReceiptLine>();
    private final Map<PaymentType, BigDecimal> paymentsMap = new HashMap<PaymentType, BigDecimal>();
    private static final Comparator<ReceiptLine> compareReceiptLinesByType = (line1, line2) -> {
        if (line1.getLineType() == ReceiptLineType.FEES || line1.getLineType() == ReceiptLineType.VENDOR_FEES) {
            if (line2.getLineType() != ReceiptLineType.FEES && line2.getLineType() != ReceiptLineType.VENDOR_FEES) {
                return 1;
            }
            return 0;
        }
        if (line2.getLineType() == ReceiptLineType.FEES || line2.getLineType() == ReceiptLineType.VENDOR_FEES) {
            if (line1.getLineType() != ReceiptLineType.FEES && line1.getLineType() != ReceiptLineType.VENDOR_FEES) {
                return -1;
            }
            return 0;
        }
        if (line1.getLineType() == ReceiptLineType.PRODUCT && line2.getLineType() != ReceiptLineType.PRODUCT) {
            return -1;
        }
        if (line2.getLineType() == ReceiptLineType.PRODUCT && line1.getLineType() != ReceiptLineType.PRODUCT) {
            return 1;
        }
        return 0;
    };

    public FiscalReceiptCalculatedDataHolder(ReceiptData data) {
        HashMap<String, List> groupedReceiptLines = new HashMap<String, List>();
        ReceiptData clonedData = new ReceiptData();
        try {
            clonedData.copyFrom((BaseEntity)data, false, new HashMap());
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"Failed to clone receiptData", (Throwable)e, (Object[])new Object[0]);
        }
        for (ReceiptLine receiptLine : clonedData.getItems()) {
            if (MiscUtil.compare((Comparable)receiptLine.getTotal(), (Comparable)BigDecimal.ZERO) == 0) continue;
            String supplierRegistrationId = Optional.ofNullable(receiptLine.getSupplier()).map(Supplier::getINN).orElse(null);
            String key = String.format("%s-%s-%s-%s", receiptLine.getLineType(), receiptLine.getPrintName(), receiptLine.getVatType(), supplierRegistrationId);
            groupedReceiptLines.computeIfAbsent(key, type -> new ArrayList()).add(receiptLine);
            PaymentType paymentType = PaymentType.valueOf((String)receiptLine.getPaymentType().name());
            this.paymentsMap.put(paymentType, this.paymentsMap.computeIfAbsent(paymentType, type -> BigDecimal.ZERO).add(receiptLine.getPrice()));
        }
        this.receiptLines.addAll(groupedReceiptLines.values().stream().map(linesList -> linesList.stream().reduce((line1, line2) -> {
            line1.setPrice(MiscUtil.sum((BigDecimal[])new BigDecimal[]{line1.getPrice(), line2.getPrice()}));
            line1.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{line1.getTotal(), line2.getTotal()}));
            return line1;
        })).filter(Optional::isPresent).map(Optional::get).sorted(MiscUtil.comparator(Arrays.asList(compareReceiptLinesByType, MiscUtil.comparator(ReceiptLine::getPrintName)))).collect(Collectors.toList()));
    }

    public List<ReceiptLine> getReceiptLines() {
        return this.receiptLines;
    }

    public Map<PaymentType, BigDecimal> getPaymentsMap() {
        return this.paymentsMap;
    }
}

