/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre;

import com.google.common.base.Splitter;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CarsSupplier;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeCategoryReference;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.ServicePlatform;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.gds.sabre.ContractSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.CostCodesHelper;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileLineDataProxy;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.TripartiteContractSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.calcfee.ParsingUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCodeInfo;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.CwtOrganizationData;
import com.gridnine.xtrip.common.model.profile.CwtPersonData;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PNRBuilder;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PassportCorrelationQualifier;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeComparisonType;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.RiskManagementCompany;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.profile.SabreCsvDocumentType;
import com.gridnine.xtrip.common.model.profile.SabreKeyContactEmailType;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand1Fnbts;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand3Wt;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionAir;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineSubsectionHotel;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesUniqueIDSettings;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.profile.WorkMode;
import com.gridnine.xtrip.common.model.profile.WorkModeType;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ProfileSynchronizationUtil {
    private static final String CORPORATE_DEALS = "CORP DEALS";
    public static final Pattern SABRE_ILLEGAL_SYMBOLS_GENERAL = Pattern.compile("[^A-Za-z0-9 \\-\\.,:_/\\*\\+\\(\\)\u00a4\u00a5\u0080\u0081]+");
    public static final Pattern SABRE_ILLEGAL_SYMBOLS_STRICT = Pattern.compile("[^A-Za-z0-9 \\-\\.]+");
    public static final Pattern SABRE_ILLEGAL_SYMBOLS_EMAIL = Pattern.compile("[^A-Za-z0-9 \\-\\._@]+");
    public static final Pattern CYRILLIC_SYMBOLS = Pattern.compile("[\u0410-\u042f\u0430-\u044f]+");
    public static final Pattern SABRE_ILLEGAL_SYMBOLS_CARD_NUMBER = Pattern.compile("[^A-Za-z0-9 \\-\\./]+");
    public static final String ORGANIZATION_SHORT_NAME = "ORGANIZATION_SHORT_NAME";
    public static final String ORGANIZATION_GET_THERE_SETTIMGS = "ORGANIZATION_GET_THERE_SETTINGS";
    public static final String ORGANIZATION_CODE = "ORGANIZATION_CODE";
    public static final String ORGANIZATION_FOUND = "ORGANIZATION_FOUND";
    public static final String PERSON_POSITION = "PERSON_POSITION";

    public static String getDelimiterLine(String string, String alphaCode, boolean isFinish) {
        StringBuilder line = new StringBuilder("5" + alphaCode + '\u00a5');
        for (int i = 0; i < 10; ++i) {
            line.append("-");
        }
        line.append(" ");
        if (isFinish) {
            line.append("END OF ");
        }
        line.append(string.toUpperCase());
        line.append(" ");
        while (line.length() < 57) {
            line.append("-");
        }
        return line.toString();
    }

    public static boolean checkForLatinSymbols(Passport passengerPassport, L10nString lastName, L10nString firstName) {
        if (!ProfileSynchronizationUtil.checkForLatinSymbols(passengerPassport.getLastName(), true) && TextUtil.isBlank((String)ProfileSynchronizationUtil.getSabreLocale(lastName))) {
            return false;
        }
        return ProfileSynchronizationUtil.checkForLatinSymbols(passengerPassport.getFirstName(), true) || !TextUtil.isBlank((String)ProfileSynchronizationUtil.getSabreLocale(firstName));
    }

    public static boolean checkForLatinSymbols(String str, boolean allowPunctuations) {
        if (TextUtil.isBlank((String)str)) {
            return true;
        }
        Pattern p1 = Pattern.compile("[a-zA-Z0-9\\-\\.\\, ]*");
        Pattern p2 = Pattern.compile("[a-zA-Z0-9 ]*");
        Matcher m1 = p1.matcher(str);
        Matcher m2 = p2.matcher(str);
        return allowPunctuations && m1.matches() || m2.matches();
    }

    public static boolean checkForLatinSymbols(String str, String punctuations) {
        if (TextUtil.isBlank((String)str)) {
            return true;
        }
        Pattern p1 = Pattern.compile("[a-zA-Z0-9" + punctuations + "]*");
        Matcher m1 = p1.matcher(str);
        return m1.matches();
    }

    public static List<String> removeIllegalSymbols(List<String> list, boolean strict) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s : list) {
            res.add(ProfileSynchronizationUtil.removeIllegalSymbols(s, strict));
        }
        return res;
    }

    public static String removeBracket(String str) {
        if (TextUtil.isBlank((String)str)) {
            return "";
        }
        return str.replaceAll("[()]", "");
    }

    public static boolean checkSymbols(StringBuilder str, boolean needRemove) {
        String specialsRegexp = " \\*\\-/\\,\\.\\n\u00a5\u0081128\u00a4";
        boolean res = ProfileSynchronizationUtil.checkForLatinSymbols(str.toString(), specialsRegexp);
        if (needRemove) {
            String newStr = str.toString().replaceAll("[^a-zA-Z0-9" + specialsRegexp + "]", "");
            str.delete(0, str.length());
            str.append(newStr);
        }
        return res;
    }

    public static String removeIllegalSymbols(String str, boolean strict) {
        if (TextUtil.isBlank((String)str)) {
            return str;
        }
        return strict ? str.replaceAll(SABRE_ILLEGAL_SYMBOLS_STRICT.pattern(), "") : str.replaceAll(SABRE_ILLEGAL_SYMBOLS_GENERAL.pattern(), "");
    }

    public static String removeIllegalSymbolsCardNumber(String str) {
        if (TextUtil.isBlank((String)str)) {
            return str;
        }
        return str.replaceAll(SABRE_ILLEGAL_SYMBOLS_CARD_NUMBER.pattern(), "");
    }

    public static String removeIllegalSymbolsEmail(String str) {
        if (TextUtil.isBlank((String)str)) {
            return str;
        }
        return str.replaceAll(SABRE_ILLEGAL_SYMBOLS_EMAIL.pattern(), "");
    }

    public static boolean checkIllegalSymbols(String str, boolean strict) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        Matcher m = strict ? SABRE_ILLEGAL_SYMBOLS_STRICT.matcher(str) : SABRE_ILLEGAL_SYMBOLS_GENERAL.matcher(str);
        return m.find();
    }

    public static String replaceSymbolsEmail(String str) {
        if (TextUtil.isBlank((String)str)) {
            return str;
        }
        return str.replaceAll("@", "//").replaceAll("_", "..").replaceAll("-", "./");
    }

    public static <D extends BaseDictionary> String getIso3OrIataCode(DictionaryReference<D> ref) {
        if (ref == null) {
            return null;
        }
        BaseDictionary loc = DictionaryCache.get().resolveReference(ref);
        if (loc == null) {
            return ref.getCode();
        }
        String iso3 = (String)loc.getCodeVariants().get(CodeSystem.ISO_ALPHA3.name());
        if (iso3 != null) {
            return iso3;
        }
        String iata = (String)loc.getCodeVariants().get(CodeSystem.IATA.name());
        if (iata != null) {
            return iata;
        }
        return loc.getCode();
    }

    public static String substituteSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('/', ' ').replace('-', ' ');
    }

    public static String toSabreDocumentType(PassportType passportType) {
        if (passportType == null) {
            return "P";
        }
        switch (passportType) {
            case ALIENRESIDENTCARD: {
                return "A";
            }
            case PERMANENTRESIDENTCARD: {
                return "C";
            }
            case IDENTITYCARD: 
            case BIRTHDAY_NOTIFICATION: {
                return "I";
            }
            case DIPLOMATIC: {
                return "PD";
            }
            case SERVICE_PASSPORT: {
                return "PM";
            }
            case TRAVELDOCUMENT: {
                return "T";
            }
            case FACILITATIONDOCUMENT: {
                return "F";
            }
            case MILITARYID: {
                return "M";
            }
            case NATURALIZATIONCERTIFICATE: {
                return "N";
            }
            case BORDERCROSSINGCARD: {
                return "V";
            }
        }
        return "P";
    }

    public static PassportType fromSabreDocumentType(String documentType) {
        if (documentType == null) {
            return null;
        }
        switch (documentType) {
            case "A": {
                return PassportType.ALIENRESIDENTCARD;
            }
            case "C": {
                return PassportType.PERMANENTRESIDENTCARD;
            }
            case "I": {
                return PassportType.IDENTITYCARD;
            }
            case "P": {
                return PassportType.PASSPORT;
            }
            case "PD": {
                return PassportType.DIPLOMATIC;
            }
            case "PM": {
                return PassportType.SERVICE_PASSPORT;
            }
            case "T": {
                return PassportType.TRAVELDOCUMENT;
            }
            case "F": {
                return PassportType.FACILITATIONDOCUMENT;
            }
            case "M": {
                return PassportType.MILITARYID;
            }
            case "N": {
                return PassportType.NATURALIZATIONCERTIFICATE;
            }
            case "V": {
                return PassportType.BORDERCROSSINGCARD;
            }
            case "D": 
            case "DB": 
            case "PS": {
                return PassportType.OTHER;
            }
        }
        return null;
    }

    public static String makeAlphaNumStr(String str) {
        if (TextUtil.isBlank((String)str)) {
            return "";
        }
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z') && (ch < 'a' || ch > 'z')) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static String toSabreGenger(Passport passport, Gender gender) {
        Gender g;
        Gender gender2 = g = passport != null && passport.getGender() != null ? passport.getGender() : gender;
        if (g == Gender.MALE) {
            return "M";
        }
        if (g == Gender.FEMALE) {
            return "F";
        }
        return "U";
    }

    public static List<String> splitStringBySpace(String line, int limit) {
        String[] rows;
        ArrayList<String> res = new ArrayList<String>();
        if (TextUtil.isBlank((String)line)) {
            return res;
        }
        if (limit <= 0) {
            res.add(line);
            return res;
        }
        for (String row : rows = line.split("\\n")) {
            if ((row = row.trim()).length() <= limit) {
                res.add(row);
                continue;
            }
            while (row.length() > limit) {
                int prevSpacePos = -1;
                int newSpacePos = row.indexOf(" ", prevSpacePos);
                while (newSpacePos <= limit && newSpacePos > 0) {
                    prevSpacePos = newSpacePos;
                    newSpacePos = row.indexOf(" ", prevSpacePos + 1);
                }
                if (prevSpacePos != -1) {
                    res.add(row.substring(0, prevSpacePos));
                    row = row.substring(prevSpacePos).trim();
                    continue;
                }
                res.add(row.substring(0, limit));
                row = row.substring(limit).trim();
            }
            res.add(row);
        }
        res.removeIf(TextUtil::isBlank);
        return res;
    }

    private static String crop30Chars(String string) {
        return TextUtil.truncate((String)string, (int)30);
    }

    public static String formatField(String string) {
        return string != null ? string.toUpperCase(Locale.ENGLISH) : null;
    }

    public static String formatDate(Date date, DateFormat df) {
        if (date == null) {
            return null;
        }
        if (df == null) {
            return ProfileSynchronizationUtil.formatDate(date);
        }
        return df.format(date).toUpperCase();
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return ProfileSynchronizationUtil.formatDate(date, new SimpleDateFormat("ddMMMyyyy", Locale.ENGLISH));
    }

    public static List<Person> getPersonListFromParameters(List<Metadata> metadata, String key) {
        ArrayList<Person> res = new ArrayList<Person>();
        for (Metadata m : metadata) {
            Person per;
            if (m.getKey() == null || !m.getKey().getCode().equals(key) || m.getValue() == null || !(m.getValue() instanceof EntityReference)) continue;
            EntityReference perRef = (EntityReference)m.getValue();
            try {
                EntityContainer perCont = EntityStorage.get().resolve(perRef);
                per = perCont != null ? (Person)perCont.getEntity() : null;
            }
            catch (Exception e) {
                per = null;
            }
            if (per == null) continue;
            res.add(per);
        }
        return res;
    }

    public static List<EntityReference<Person>> getPersonReferencesListFromParameters(List<Metadata> metadata, String key) {
        ArrayList<EntityReference<Person>> res = new ArrayList<EntityReference<Person>>();
        for (Metadata m : metadata) {
            if (m.getKey() == null || !m.getKey().getCode().equals(key) || m.getValue() == null || !(m.getValue() instanceof EntityReference)) continue;
            EntityReference perRef = (EntityReference)m.getValue();
            res.add((EntityReference<Person>)perRef);
        }
        return res;
    }

    public static String getUdidNumberString(CostCodeType type) {
        if (type == null) {
            return "";
        }
        if (!ProfileSynchronizationConstants.CostCodeType2String.containsKey(type)) {
            return type.toString();
        }
        return ProfileSynchronizationConstants.CostCodeType2String.get(type);
    }

    public static int getUdidNumberSafe(CostCodeType type) {
        Integer udidNumber = ProfileSynchronizationUtil.getUdidNumber(type);
        return udidNumber != null ? udidNumber : 1;
    }

    public static Integer getUdidNumber(CostCodeType type) {
        if (type == null || !ProfileSynchronizationConstants.CostCodeType2Number.containsKey(type)) {
            return null;
        }
        return ProfileSynchronizationConstants.CostCodeType2Number.get(type);
    }

    public static CostCodeType getCostCodeTypeForNumber(String number) {
        if (TextUtil.isBlank((String)number) || !ProfileSynchronizationConstants.String2CostCodeType.containsKey(number)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2CostCodeType.get(number);
    }

    public static String getPhoneTypeLetter(CommunicationType type) {
        if (type == null || !ProfileSynchronizationConstants.CommunicationType2String.containsKey(type)) {
            return "";
        }
        return ProfileSynchronizationConstants.CommunicationType2String.get(type);
    }

    public static String getOsiPhoneTypeLetter(CommunicationType type) {
        if (type != null) {
            switch (type) {
                case MOBILE: 
                case CELL: {
                    return "M";
                }
                case WORK_PHONE: {
                    return "B";
                }
            }
        }
        return "P";
    }

    public static CommunicationType getCommTypeFromString(String type) {
        if (TextUtil.isBlank((String)type) || !ProfileSynchronizationConstants.String2CommunicationType.containsKey(type)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2CommunicationType.get(type);
    }

    public static String getLineTypeString(SabreProfileLineType lineType) {
        if (lineType == null || !ProfileSynchronizationConstants.SabreLineType2String.containsKey(lineType)) {
            return "N";
        }
        return ProfileSynchronizationConstants.SabreLineType2String.get(lineType);
    }

    public static SabreProfileLineType getLineTypeFromString(String type) {
        if (TextUtil.isBlank((String)type) || !ProfileSynchronizationConstants.String2SabreLineType.containsKey(type)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2SabreLineType.get(type);
    }

    public static String getLineServiceTypeStringForRemark(String lineType) {
        if (lineType == null || !ProfileSynchronizationConstants.SabreLineServiceType2StringForRemark2.containsKey(lineType)) {
            return "";
        }
        return ProfileSynchronizationConstants.SabreLineServiceType2StringForRemark2.get(lineType);
    }

    public static String getLineServiceTypeStringForRemark(SabreProfileLineServiceType lineType) {
        if (lineType == null || !ProfileSynchronizationConstants.SabreLineServiceType2StringForRemark.containsKey(lineType)) {
            return "";
        }
        return ProfileSynchronizationConstants.SabreLineServiceType2StringForRemark.get(lineType);
    }

    public static String getLineServiceTypeString(SabreProfileLineServiceType lineType) {
        if (lineType == null || !ProfileSynchronizationConstants.SabreLineServiceType2String.containsKey(lineType)) {
            return "";
        }
        return ProfileSynchronizationConstants.SabreLineServiceType2String.get(lineType);
    }

    public static SabreProfileLineServiceType getLineServiceTypeFromString(String lineTypeStr) {
        if (TextUtil.isBlank((String)lineTypeStr) || !ProfileSynchronizationConstants.String2SabreLineServiceType.containsKey(lineTypeStr)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2SabreLineServiceType.get(lineTypeStr);
    }

    public static boolean isErrorResponseFromSabre(String resp, List<Message> listOfErrors) {
        boolean res = false;
        if (TextUtil.isBlank((String)resp)) {
            return res;
        }
        if (resp.trim().startsWith("USE NX") || resp.trim().startsWith("NG-") || resp.trim().startsWith("NG-IN")) {
            listOfErrors.add(MessageHelper.createErrorMessage("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 Sabre: " + resp, (Object[])null));
            res = true;
        }
        if (resp.trim().startsWith("STAR UNAVAIL-UPDATE IN PROGRESS")) {
            listOfErrors.add(MessageHelper.createErrorMessage("\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0443\u0436\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f: " + resp, (Object[])null));
            res = true;
        }
        return res;
    }

    public static String getWorkModeTypeForSabre(WorkModeType type) {
        if (type == null || !ProfileSynchronizationConstants.WorkModeType2String.containsKey(type)) {
            return "";
        }
        return ProfileSynchronizationConstants.WorkModeType2String.get(type);
    }

    public static WorkModeType getWorkModeTypeFromString(String str) {
        if (TextUtil.isBlank((String)str) || !ProfileSynchronizationConstants.String2WorkModeType.containsKey(str)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2WorkModeType.get(str);
    }

    public static String getCommunicationByType(List<? extends Communication> communications, CommunicationType type) {
        if (type == null || communications == null) {
            return null;
        }
        for (Communication communication : communications) {
            if (communication.getType() == null || !communication.getType().equals((Object)type)) continue;
            return communication.getSense();
        }
        return null;
    }

    public static CardVendor getCardVendorByString(String str) {
        if (TextUtil.isBlank((String)str) || !ProfileSynchronizationConstants.Abbr2Card.containsKey(str)) {
            return null;
        }
        return ProfileSynchronizationConstants.Abbr2Card.get(str);
    }

    public static String getStringByCardVendor(CardVendor cv) {
        if (cv == null || !ProfileSynchronizationConstants.Card2Abbr.containsKey(cv)) {
            return "";
        }
        return ProfileSynchronizationConstants.Card2Abbr.get(cv);
    }

    public static String getServicePlatformString(ServicePlatform plat) {
        if (plat == null || !ProfileSynchronizationConstants.ServicePlatform2String.containsKey(plat)) {
            return "";
        }
        return ProfileSynchronizationConstants.ServicePlatform2String.get(plat);
    }

    public static ServicePlatform getServicePlatformByString(String str) {
        if (str == null || !ProfileSynchronizationConstants.String2ServicePlatform.containsKey(str)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2ServicePlatform.get(str);
    }

    public static SabreCsvDocumentType getSabreCsvDocumentTypeByString(String str) {
        if (str == null || !ProfileSynchronizationConstants.String2SabreCsvDocumentType.containsKey(str)) {
            return null;
        }
        return ProfileSynchronizationConstants.String2SabreCsvDocumentType.get(str);
    }

    public static String getSabreCsvDocumentTypeString(SabreCsvDocumentType type) {
        if (type == null || !ProfileSynchronizationConstants.SabreCsvDocumentType2String.containsKey(type)) {
            return "";
        }
        return ProfileSynchronizationConstants.SabreCsvDocumentType2String.get(type);
    }

    public static String getCodeByDocType(PassportType type) {
        if (type == null) {
            return "OTHR";
        }
        switch (type) {
            case FOREIGN: 
            case PASSPORT: 
            case FOREIGN_NATIONAL_PASSPORT: {
                return "PSPT";
            }
            case MILITARYID: {
                return "MLID";
            }
            case ALIENRESIDENTCARD: {
                return "ALNR";
            }
            case PERMANENTRESIDENTCARD: {
                return "PRID";
            }
            case BIRTHDAY_NOTIFICATION: {
                return "BRTH";
            }
            case INTERNAL: {
                return "NTID";
            }
        }
        return "OTHR";
    }

    public static PassportType getDocTypeByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        switch (code) {
            case "PSPT": {
                return PassportType.FOREIGN;
            }
            case "MLID": {
                return PassportType.MILITARYID;
            }
            case "ALNR": {
                return PassportType.ALIENRESIDENTCARD;
            }
            case "PRID": {
                return PassportType.PERMANENTRESIDENTCARD;
            }
            case "BRTH": {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            case "NTID": {
                return PassportType.INTERNAL;
            }
        }
        return PassportType.OTHER;
    }

    public static List<String> getCommunicationsByType(List<? extends Communication> communications, CommunicationType type) {
        ArrayList<String> res = new ArrayList<String>();
        if (communications == null || type == null) {
            return res;
        }
        for (Communication communication : communications) {
            if (communication.getType() == null || !communication.getType().equals((Object)type)) continue;
            res.add(communication.getSense());
        }
        return res;
    }

    public static String getDkNumber(String code) {
        return !TextUtil.isBlank((String)code) ? "DK" + code : "";
    }

    public static String getClientId(String clientId, Set<OrganizationType> types) {
        String type = types.contains(OrganizationType.AGENCY) ? "A" : "C";
        return !TextUtil.isBlank((String)clientId) ? "CID-" + type + clientId : "";
    }

    public static List<String> getReasonCodesByType(List<ReasonCode> reasonCodes, ReasonCodeType type, String alphaCode, String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        if (reasonCodes == null || type == null) {
            return res;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (alphaCode == null) {
            alphaCode = "";
        }
        for (ReasonCode rc : reasonCodes) {
            if (!rc.getType().equals((Object)type)) continue;
            String comparisonTypePrefix = "";
            if (rc.getType() == ReasonCodeType.REASON_CODE_AIR) {
                comparisonTypePrefix = rc.getComparisonType() == ReasonCodeComparisonType.AFR ? "AFR - " : "AFS - ";
            }
            String str = prefix + comparisonTypePrefix + (rc.getName() != null ? rc.getName() : "") + " - " + (rc.getSabreName() != null ? rc.getSabreName() : "");
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(str, alphaCode, "5", true));
        }
        return res;
    }

    public static String getReasonAlphaCode(ReasonCodeType type) {
        if (type == null) {
            return "";
        }
        if (type.equals((Object)ReasonCodeType.REASON_CODE_AIR)) {
            return "A";
        }
        if (type.equals((Object)ReasonCodeType.REASON_CODE_CAR)) {
            return "C";
        }
        if (type.equals((Object)ReasonCodeType.REASON_CODE_HOTEL) || type.equals((Object)ReasonCodeType.REASON_CODE_NO_HOTEL)) {
            return "H";
        }
        return "A";
    }

    public static List<String> prepareMultiLineStrings(List<String> list, int max, String delimiter) {
        ArrayList<String> res = new ArrayList<String>();
        if (list == null || max <= 0) {
            return res;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        ArrayDeque<String> q = new ArrayDeque<String>(list);
        String curStr = "";
        while (!q.isEmpty()) {
            String elem = (String)q.poll();
            if (elem.length() < max) {
                if (curStr.length() > 0 && curStr.length() + elem.length() + delimiter.length() <= max) {
                    curStr = curStr + delimiter + elem;
                    continue;
                }
                if (curStr.length() == 0) {
                    curStr = elem;
                    continue;
                }
                res.add(curStr);
                curStr = elem;
                continue;
            }
            if (curStr.length() > 0) {
                res.add(curStr);
            }
            curStr = elem.substring(0, max);
            res.add(curStr);
            curStr = "";
            q.addFirst(elem.substring(max));
        }
        if (curStr.length() > 0) {
            res.add(curStr);
        }
        return res;
    }

    public static void split(String content, int treshold, List<String> lines) {
        if (TextUtil.isBlank((String)content)) {
            return;
        }
        if (treshold < 1) {
            throw new IllegalArgumentException("trashold must be greater than zero");
        }
        String line = content.trim();
        if (line.length() > treshold) {
            int index = line.substring(0, treshold - 1).lastIndexOf(" ");
            if (index == -1) {
                index = treshold;
            }
            lines.add(line.substring(0, index));
            ProfileSynchronizationUtil.split(line.substring(index), treshold, lines);
        } else {
            lines.add(line);
        }
    }

    public static List<String> advancedPrepareRemarkForSabre(String str, int limit, String alphaCode, String serviceTypeLocal, String subsection, String prefixCmd, boolean needCross, boolean needSpaceAfterPrefix) {
        ArrayList<String> remarks = new ArrayList<String>();
        String prefix = prefixCmd + alphaCode + (needCross ? Character.valueOf('\u00a5') : "") + serviceTypeLocal + subsection;
        int treshold = limit - prefix.length();
        ArrayList<String> lines = new ArrayList<String>();
        ProfileSynchronizationUtil.split(str, treshold, lines);
        for (String line : lines) {
            String res = prefix.trim() + (needSpaceAfterPrefix && prefix.length() > 3 ? " " : "") + line.trim();
            res = res.replace('\u2026', '.');
            remarks.add(res.toUpperCase());
        }
        return remarks;
    }

    public static String prepareRemarkForSabre(String str, String alphaCode, String prefixCmd, boolean needCross, boolean ignoreMaxLength) {
        if (TextUtil.isBlank((String)str)) {
            return "";
        }
        String res = prefixCmd + alphaCode;
        if (needCross) {
            res = res + '\u00a5';
        }
        res = res + ProfileSynchronizationUtil.removeIllegalSymbols(str, false);
        if (!ignoreMaxLength && res.length() > 57) {
            res = res.substring(0, 57);
        }
        res = res.replace('\u2026', '.');
        return res.toUpperCase();
    }

    public static String prepareRemarkForSabre(String str, String alphaCode, String prefixCmd, boolean needCross) {
        return ProfileSynchronizationUtil.prepareRemarkForSabre(str, alphaCode, prefixCmd, needCross, false);
    }

    public static List<String> prepareRemarkListForSabre(List<String> remarks, String alphaCode) {
        ArrayList<String> res = new ArrayList<String>();
        for (String remark : remarks) {
            if (TextUtil.isBlank((String)remark)) continue;
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(remark, alphaCode, "5", true));
        }
        return res;
    }

    public static String prepareSeatRemarkForSabre(String body, String subsection, String cmdPrefix, String nameLine) {
        return (cmdPrefix + subsection + "/" + body + nameLine.substring(0, nameLine.indexOf(" "))).toUpperCase();
    }

    @Deprecated
    public static List<Address> getAddressFromModel(List<? extends Address> addresses, AddressType type) {
        ArrayList<Address> res = new ArrayList<Address>();
        for (Address address : addresses) {
            if (address.getAddressType() == null || !address.getAddressType().equals((Object)type)) continue;
            res.add(address);
        }
        return res;
    }

    public static String fillLine(String str, char c, int length) {
        if (str == null) {
            str = "";
        }
        if (length < 0) {
            return str;
        }
        if (length < str.length()) {
            str = str.substring(0, length).trim();
        }
        StringBuilder res = new StringBuilder(str);
        while (res.length() < length) {
            res.append(c);
        }
        return res.toString();
    }

    public static String prepareName(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (Character.isLetter(c)) {
                res.append(c);
                continue;
            }
            res.append(' ');
        }
        return res.toString().trim();
    }

    private static Organization resolveOrganization(EntityReference<Organization> orgRef) {
        try {
            return ProfileHelper.resolveReference(orgRef);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBrandCodeOwnerString(EntityReference<Organization> orgRef) {
        return ProfileSynchronizationUtil.getBrandCodeOwnerString(ProfileSynchronizationUtil.resolveOrganization(orgRef));
    }

    public static String getBrandCodeValueString(EntityReference<Organization> orgRef) {
        return ProfileSynchronizationUtil.getBrandCodeValueString(ProfileSynchronizationUtil.resolveOrganization(orgRef));
    }

    public static String getBrandCodeOwnerString(Organization org) {
        return ProfileSynchronizationUtil.getMetadataString(org, MetadataKey.KEY_ORGANIZATION_BRAND_CODE_OWNER);
    }

    public static String getBrandCodeValueString(Organization org) {
        return ProfileSynchronizationUtil.getMetadataString(org, MetadataKey.KEY_ORGANIZATION_BRAND_CODE_VALUE);
    }

    private static String getMetadataString(Organization org, MetadataKey key) {
        if (org == null) {
            return null;
        }
        for (Metadata m : org.getMetadata()) {
            if (m.getKey() == null || !m.getKey().getCode().equals(key.name()) || m.getValue() == null || !(m.getValue() instanceof String)) continue;
            return (String)m.getValue();
        }
        return null;
    }

    private static String getMetadataString(Person per, MetadataKey key) {
        if (per == null) {
            return null;
        }
        for (PersonMetadata m : per.getMetadata()) {
            if (m.getKey() == null || !m.getKey().getCode().equals(key.name()) || m.getValue() == null || !(m.getValue() instanceof String)) continue;
            return (String)m.getValue();
        }
        return null;
    }

    public static EntityReference<Organization> findBrandForOrganization(EntityReference<Organization> orgRef) {
        return ProfileSynchronizationUtil.findBrandForOrganization(ProfileSynchronizationUtil.resolveOrganization(orgRef));
    }

    public static EntityReference<Organization> findBrandForOrganization(Organization org) {
        return ProfileSynchronizationUtil.findBrandForOrganization(ProfileSynchronizationUtil.getBrandCodeValueString(org));
    }

    public static EntityReference<Organization> findBrandForOrganization(String brandCodeOwner) {
        if (TextUtil.isBlank((String)brandCodeOwner)) {
            return null;
        }
        EntityReference<Organization> res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.brandCodeOwner.name(), (Object)brandCodeOwner));
        List indexes = new ArrayList();
        try {
            indexes = EntityStorage.get().search(OrganizationIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (indexes.size() > 0) {
            return ((OrganizationIndex)indexes.get(0)).getSource();
        }
        return res;
    }

    public static List<EntityReference<Organization>> findChildsForBrandOrganization(EntityReference<Organization> orgRef) {
        return ProfileSynchronizationUtil.findChildsForBrandOrganization(ProfileSynchronizationUtil.resolveOrganization(orgRef));
    }

    public static List<EntityReference<Organization>> findChildsForBrandOrganization(Organization org) {
        return ProfileSynchronizationUtil.findChildsForBrandOrganization(ProfileSynchronizationUtil.getBrandCodeOwnerString(org));
    }

    public static List<EntityReference<Organization>> findChildsForBrandOrganization(String brandCodeValue) {
        ArrayList<EntityReference<Organization>> res = new ArrayList<EntityReference<Organization>>();
        if (TextUtil.isBlank((String)brandCodeValue)) {
            return res;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.brandCodeValue.name(), (Object)brandCodeValue));
        List indexes = new ArrayList();
        try {
            indexes = EntityStorage.get().search(OrganizationIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (OrganizationIndex index : indexes) {
            res.add((EntityReference<Organization>)index.getSource());
        }
        return res;
    }

    @Deprecated
    public static List<String> getAddressList(Address address, String separator, int maxLength) {
        String ctrLoc;
        String region;
        String cityLoc;
        if (address == null) {
            return null;
        }
        if (separator == null) {
            separator = ", ";
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getAddress()));
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getHouse()));
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getHousing()));
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getBuilding()));
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getPavilion()));
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getFlat()));
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getOffice()));
        values.add(address.getPoBox());
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getTown()));
        String string = cityLoc = address.getCity() != null ? address.getCity().toString(Locale.ENGLISH) : "";
        if (TextUtil.isBlank((String)cityLoc)) {
            String string2 = cityLoc = address.getCity() != null ? address.getCity().toString(Locale.ROOT) : "";
        }
        if (!TextUtil.isBlank((String)cityLoc)) {
            values.add(cityLoc);
        }
        values.add(ProfileSynchronizationUtil.getSabreLocale(address.getDistrict()));
        String string3 = region = address.getRegion() != null ? address.getRegion().toString(Locale.ENGLISH) : "";
        if (TextUtil.isBlank((String)region)) {
            String string4 = region = address.getRegion() != null ? address.getRegion().toString(Locale.ROOT) : "";
        }
        if (!TextUtil.isBlank((String)region)) {
            values.add(region);
        }
        values.add(address.getZip());
        String string5 = ctrLoc = address.getCountry() != null ? address.getCountry().toString(Locale.ENGLISH) : "";
        if (TextUtil.isBlank((String)ctrLoc)) {
            String string6 = ctrLoc = address.getCountry() != null ? address.getCountry().toString(Locale.ROOT) : "";
        }
        if (!TextUtil.isBlank((String)ctrLoc)) {
            values.add(ctrLoc);
        }
        return ProfileHelper.createAddressList(values, separator, maxLength, true);
    }

    public static String getSabreLocale(L10nString loc) {
        return loc != null ? ProfileSynchronizationUtil.getSabreLocale(loc.getValues()) : null;
    }

    public static String getSabreLocale(Map<Locale, String> loc) {
        if (loc == null) {
            return "";
        }
        String res = loc.get(Locale.ENGLISH);
        if (TextUtil.isBlank((String)res)) {
            res = loc.get(Locale.ROOT);
        }
        res = res != null ? res.toUpperCase() : "";
        return res;
    }

    public static Integer getSumForMap(Map<String, Integer> map) {
        Integer res = null;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (res == null) {
                res = 0;
            }
            if (entry.getValue() == null) continue;
            res = res + entry.getValue();
        }
        return res;
    }

    public static int getListItemNumber(String response, String name) {
        int lineNumber = 0;
        for (String line : response.split("\\n")) {
            if (line == null || !line.trim().startsWith(++lineNumber + " " + name + " ")) continue;
            return lineNumber;
        }
        return 0;
    }

    public static void sortMessages(List<Message> messages) {
        if (messages == null) {
            return;
        }
        messages.sort(Comparator.comparingInt(ProfileSynchronizationUtil::getMessagePriority));
    }

    private static int getMessagePriority(Message message) {
        if (message != null && message.getType() != null) {
            switch (message.getType()) {
                case ERROR: {
                    return 0;
                }
                case WARNING: {
                    return 1;
                }
                case MESSAGE: {
                    return 2;
                }
                case FOR_USER: {
                    return 3;
                }
            }
        }
        return Integer.MAX_VALUE;
    }

    public static ProfileSynchronizationConstants.ValidationStatus getValidationStatus(List<Message> msgs) {
        ProfileSynchronizationConstants.ValidationStatus res = ProfileSynchronizationConstants.ValidationStatus.NO_ERRORS_NO_WARNINGS;
        for (Message m : msgs) {
            if (res == ProfileSynchronizationConstants.ValidationStatus.NO_ERRORS_NO_WARNINGS && m.getType() == MessageType.WARNING) {
                res = ProfileSynchronizationConstants.ValidationStatus.SOME_WARNINGS_NO_ERRORS;
            }
            if (m.getType() != MessageType.ERROR) continue;
            res = ProfileSynchronizationConstants.ValidationStatus.SOME_ERRORS;
            break;
        }
        return res;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static Map<String, List<String>> createPersonRemarksMap(EntityContainer<Person> perCont, String keyForNoServiceList, boolean needServiceTypeInRemarkBody) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        ProfileSynchronizationUtil.addGeneralRemarks(((Person)perCont.getEntity()).getSabreAdditionalProfileLines(), keyForNoServiceList, needServiceTypeInRemarkBody, result);
        return result;
    }

    public static Map<String, List<String>> createOrganizationRemarksMap(EntityContainer<Organization> orgCont, String keyForNoServiceList, boolean needServiceTypeInRemarkBody, List<Message> messages) {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        ProfileSynchronizationUtil.addGeneralRemarks(((Organization)orgCont.getEntity()).getSabreAdditionalProfileLines(), keyForNoServiceList, needServiceTypeInRemarkBody, result);
        TripartiteContractSynchronizationUtil.addTripartiteContractRemarks((EntityReference<Organization>)orgCont.toReference(), result, messages);
        return result;
    }

    public static void addGeneralRemarks(List<SabreProfileLine> profileLines, String keyForNoServiceList, boolean needServiceTypeInRemarkBody, Map<String, List<String>> remarksMap) {
        remarksMap.put(keyForNoServiceList, new ArrayList());
        for (SabreProfileLine profileLine : profileLines) {
            StringBuffer lineBody = new StringBuffer();
            StringBuffer lineType = new StringBuffer();
            StringBuffer alphaCode = new StringBuffer();
            StringBuffer serviceType = new StringBuffer();
            StringBuffer serviceTypeLocal = new StringBuffer();
            StringBuffer subsectionType = new StringBuffer();
            String lineText = ProfileSynchronizationUtil.createRemarkString(profileLine, lineBody, lineType, alphaCode, serviceType, serviceTypeLocal, subsectionType, needServiceTypeInRemarkBody);
            if (serviceType.length() > 4) {
                serviceType = new StringBuffer(serviceType.substring(4));
            }
            if (!remarksMap.containsKey(serviceType.toString())) {
                remarksMap.put(serviceType.toString(), new ArrayList());
            }
            List<String> lines = !lineType.toString().equals(ProfileSynchronizationUtil.getLineTypeString(SabreProfileLineType.P)) ? ProfileSynchronizationUtil.advancedPrepareRemarkForSabre(lineText, 56, alphaCode.toString(), serviceTypeLocal.toString(), subsectionType.toString(), "5", true, true) : ProfileSynchronizationUtil.advancedPrepareRemarkForSabre(lineText, 56, alphaCode.toString(), serviceTypeLocal.toString(), subsectionType.toString(), "", false, true);
            if (TextUtil.isBlank((String)lineBody.toString())) continue;
            for (String line : lines) {
                List<String> tempList;
                line = lineType.toString() + line;
                if (!TextUtil.isBlank((String)serviceType.toString())) {
                    tempList = remarksMap.get(serviceType.toString());
                    tempList.add(line.toUpperCase());
                    remarksMap.put(serviceType.toString(), tempList);
                    continue;
                }
                tempList = remarksMap.get(keyForNoServiceList);
                tempList.add(line.toUpperCase());
                remarksMap.put(keyForNoServiceList, tempList);
            }
        }
    }

    public static String createRemarkString(SabreProfileLine line, StringBuffer lineBody, StringBuffer lineType, StringBuffer alphaCode, StringBuffer serviceType, StringBuffer serviceTypeLocal, StringBuffer subsectionType, boolean needServiceTypeInRemarkBody) {
        String subsection;
        String lineText = "";
        lineType.append(line.getLineType() != null ? ProfileSynchronizationUtil.getLineTypeString(line.getLineType()) : ProfileSynchronizationUtil.getLineTypeString(SabreProfileLineType.N));
        if (line.getLineServiceType() != null) {
            String serviceTypeLocalStr = ProfileSynchronizationUtil.getLineServiceTypeStringForRemark(line.getLineServiceType());
            serviceType.append(ProfileSynchronizationUtil.getLineServiceTypeString(line.getLineServiceType()));
            alphaCode.append(ProfileSynchronizationUtil.getLineServiceTypeString(line.getLineServiceType()));
            if (serviceTypeLocalStr.length() > 1 && needServiceTypeInRemarkBody) {
                serviceTypeLocal.append(serviceTypeLocalStr).append(" ");
            }
        }
        String string = subsection = line.getLineSubsection() != null ? line.getLineSubsection() : "";
        if (subsection.equals(SabreProfileLineSubsectionAir.CORPORATE_DEALS.toString())) {
            subsection = CORPORATE_DEALS;
        }
        if (subsection.length() > 0) {
            subsectionType.append(subsection).append(" / ");
        }
        if (line.getLineFlag() != null) {
            if (subsection.equals(SabreProfileLineSubsectionHotel.PREF_BOOK_CHANNEL.toString())) {
                lineBody.append(line.getLineFlag() != false ? "GDS" : "NON GDS");
            } else {
                lineBody.append(line.getLineFlag() != false ? "YES" : "NO");
            }
        }
        if (!TextUtil.isBlank((String)line.getLineBody())) {
            if (!TextUtil.isBlank((String)lineBody.toString())) {
                lineBody.append(" - ");
            }
            lineBody.append(line.getLineBody());
        }
        lineText = !TextUtil.isBlank((String)lineText) && !TextUtil.isBlank((String)lineBody.toString()) ? lineText + (lineText.endsWith(" ") ? "/ " : " / ") + lineBody : lineBody.toString();
        return lineText;
    }

    public static List<String> createWorkModeLines(List<WorkMode> workModes) {
        ArrayList<String> res = new ArrayList<String>();
        for (WorkMode wm : workModes) {
            String remark = ProfileSynchronizationUtil.prepareRemarkForSabre(" WORKING HOURS / ", ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.K), "5", true);
            if (wm.getWorkModeType() != null) {
                remark = remark + ProfileSynchronizationUtil.getWorkModeTypeForSabre(wm.getWorkModeType());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("hh-mma");
            remark = remark + " ";
            if (wm.getStartTime() != null) {
                remark = remark + sdf.format(wm.getStartTime());
            }
            if (wm.getFinishTime() != null) {
                remark = remark + " - " + sdf.format(wm.getFinishTime());
            }
            res.add(remark);
        }
        return res;
    }

    public static String createBrandCodeOwnerRemark(String brandCodeOwner) {
        return ProfileSynchronizationUtil.prepareRemarkForSabre("BR OWN CD-" + brandCodeOwner, "", "5.X*", false);
    }

    public static String createBrandCodeValueRemark(String brandCodeOwner) {
        return ProfileSynchronizationUtil.prepareRemarkForSabre("BR CD-" + brandCodeOwner, "", "5.X*", false);
    }

    public static List<String> createAccountManagersList(List<Metadata> metadata) {
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.K);
        List<Person> personList = ProfileSynchronizationUtil.getPersonListFromParameters(metadata, "KEY_ORGANIZATION_ACCOUNT_MANAGER");
        for (Person per : personList) {
            String firstName = ProfileSynchronizationUtil.getSabreLocale(per.getFirstName());
            String lastName = ProfileSynchronizationUtil.getSabreLocale(per.getLastName());
            String line = "ACC MANAGER/" + (!TextUtil.isBlank((String)firstName) ? firstName : "") + " " + (!TextUtil.isBlank((String)lastName) ? lastName : "");
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, alphaCode, "5", true));
        }
        return res;
    }

    public static List<String> createServicePlatformList(List<Metadata> metadata, String key) {
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.K);
        for (Metadata m : metadata) {
            if (m.getKey() == null || !m.getKey().getCode().equals(key) || m.getValue() == null || !(m.getValue() instanceof ServicePlatform)) continue;
            String value = ProfileSynchronizationUtil.getServicePlatformString((ServicePlatform)m.getValue());
            String comment = m.getRemarks();
            String line = value + (!TextUtil.isBlank((String)comment) ? " - " + comment : "");
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, alphaCode, "5", true));
        }
        return res;
    }

    public static List<SabreProfileLineDataProxy> createSabreAdditionalCommands(List<SabreProfileCommand1Fnbts> sabreAdditionalCommand1Lines, List<SabreProfileCommand2Osi> sabreAdditionalCommand2Lines, List<SabreProfileCommand3Wt> sabreAdditionalCommand3Lines, List<SabreProfileCommand4SSR> sabreAdditionalCommand4Lines) {
        ArrayList<SabreProfileLineDataProxy> res = new ArrayList<SabreProfileLineDataProxy>();
        for (SabreProfileCommand1Fnbts sabreProfileCommand1Fnbts : sabreAdditionalCommand1Lines) {
            String line;
            if (!(TextUtil.isBlank((String)sabreProfileCommand1Fnbts.getEntry1()) || TextUtil.isBlank((String)sabreProfileCommand1Fnbts.getEntry2()) || TextUtil.isBlank((String)sabreProfileCommand1Fnbts.getEntry3()) || TextUtil.isBlank((String)sabreProfileCommand1Fnbts.getEntry4()))) {
                line = "FNBTS-" + (sabreProfileCommand1Fnbts.getEntry1() != null ? sabreProfileCommand1Fnbts.getEntry1().toUpperCase() : "");
                line = line + "/" + (sabreProfileCommand1Fnbts.getEntry2() != null ? sabreProfileCommand1Fnbts.getEntry2().toUpperCase() : "");
                line = line + "/" + (sabreProfileCommand1Fnbts.getEntry3() != null ? sabreProfileCommand1Fnbts.getEntry3().toUpperCase() : "");
                line = line + "-" + (sabreProfileCommand1Fnbts.getEntry4() != null ? sabreProfileCommand1Fnbts.getEntry4().toUpperCase() : "");
                res.add(new SabreProfileLineDataProxy("A", line));
            }
            if (TextUtil.isBlank((String)sabreProfileCommand1Fnbts.getEntry5())) continue;
            line = "5Z\u00a5PDQ." + (sabreProfileCommand1Fnbts.getEntry5() != null ? sabreProfileCommand1Fnbts.getEntry5().toUpperCase() : "");
            res.add(new SabreProfileLineDataProxy("A", line));
        }
        for (SabreProfileCommand2Osi sabreProfileCommand2Osi : sabreAdditionalCommand2Lines) {
            boolean isValidCmd = !TextUtil.isBlank((String)sabreProfileCommand2Osi.getEntry1()) && !TextUtil.isBlank((String)sabreProfileCommand2Osi.getEntry2());
            if (!isValidCmd) continue;
            String line = "3OSI " + (sabreProfileCommand2Osi.getEntry1() != null ? sabreProfileCommand2Osi.getEntry1().toUpperCase() : "") + " " + (sabreProfileCommand2Osi.getEntry2() != null ? sabreProfileCommand2Osi.getEntry2().toUpperCase() : "");
            line = line.replaceAll("\u2116", "");
            res.add(new SabreProfileLineDataProxy(sabreProfileCommand2Osi.getLineType() == null ? "A" : ProfileSynchronizationUtil.getLineTypeString(sabreProfileCommand2Osi.getLineType()), line));
        }
        for (SabreProfileCommand4SSR sabreProfileCommand4SSR : sabreAdditionalCommand4Lines) {
            String ssrCode = sabreProfileCommand4SSR.getSsrCode();
            boolean isValidCmd = !TextUtil.isBlank((String)ssrCode) && (ssrCode.length() == 4 || ssrCode.length() == 6) && ProfileSynchronizationUtil.checkForLatinSymbols(ssrCode, "-\\ \\\\/") && ProfileSynchronizationUtil.checkForLatinSymbols(sabreProfileCommand4SSR.getSsrInfo(), "-\\ \\\\/");
            if (!isValidCmd) continue;
            String prefix = "3";
            String ssrInfo = sabreProfileCommand4SSR.getSsrInfo() != null ? "/" + sabreProfileCommand4SSR.getSsrInfo().toUpperCase() : "";
            String line = prefix + ssrCode.toUpperCase() + ssrInfo;
            res.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(sabreProfileCommand4SSR.getLineType()), line));
        }
        for (SabreProfileCommand3Wt sabreProfileCommand3Wt : sabreAdditionalCommand3Lines) {
            boolean isValidCmd = !TextUtil.isBlank((String)sabreProfileCommand3Wt.getEntry1()) && !TextUtil.isBlank((String)sabreProfileCommand3Wt.getEntry2()) && !TextUtil.isBlank((String)sabreProfileCommand3Wt.getEntry3());
            if (!isValidCmd) continue;
            String line = "5WT-" + (sabreProfileCommand3Wt.getEntry1() != null ? sabreProfileCommand3Wt.getEntry1().toUpperCase() : "");
            line = line + "/ON-QP/" + (sabreProfileCommand3Wt.getEntry2() != null ? sabreProfileCommand3Wt.getEntry2().toUpperCase() : "");
            line = line + "/" + (sabreProfileCommand3Wt.getEntry3() != null ? sabreProfileCommand3Wt.getEntry3().toUpperCase() : "");
            res.add(new SabreProfileLineDataProxy("A", line));
        }
        return res;
    }

    public static List<SabreProfileLineDataProxy> createRemarkList(Map<String, List<String>> linesMap, String key, String keyForNoServiceList, boolean needDelimiters) {
        ArrayList<SabreProfileLineDataProxy> res = new ArrayList<SabreProfileLineDataProxy>();
        List<String> tempList = linesMap.get(key);
        if (tempList != null && tempList.size() > 0) {
            if (needDelimiters && !key.equals(keyForNoServiceList)) {
                res.add(new SabreProfileLineDataProxy("A", ProfileSynchronizationUtil.getDelimiterLine(ProfileSynchronizationUtil.getLineServiceTypeStringForRemark(key), key.substring(0, 1), false)));
            }
            for (String line : tempList) {
                String lineType = line.substring(0, 1);
                String lineBody = line.substring(1);
                StringBuilder sb = new StringBuilder(lineBody);
                ProfileSynchronizationUtil.checkSymbols(sb, true);
                lineBody = sb.toString();
                res.add(new SabreProfileLineDataProxy(lineType, lineBody));
            }
            if (needDelimiters && !key.equals(keyForNoServiceList)) {
                res.add(new SabreProfileLineDataProxy("A", ProfileSynchronizationUtil.getDelimiterLine(ProfileSynchronizationUtil.getLineServiceTypeStringForRemark(key), key.substring(0, 1), true)));
            }
        }
        return res;
    }

    public static List<String> createUdidList(Organization model, EntityReference<Organization> orgRef) {
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.U);
        ArrayList<Boolean> validationLineList = new ArrayList<Boolean>(){
            private static final long serialVersionUID = 2118927825859022891L;
            {
                for (int i = 0; i < CostCodeType.values().length; ++i) {
                    this.add(Boolean.FALSE);
                }
            }
        };
        HashMap<CostCodeType, List<String>> udidDropListMap = new HashMap<CostCodeType, List<String>>();
        ArrayList<CostCodeType> udidNumbers = new ArrayList<CostCodeType>();
        ArrayList<Object> udidNames = new ArrayList<Object>();
        ArrayList<String> udidFiveDotFormats = new ArrayList<String>();
        ArrayList<String> udidValues = new ArrayList<String>();
        ArrayList<String> udidSyntax = new ArrayList<String>();
        ArrayList<String> udidDropList = new ArrayList<String>();
        for (Object ccp : model.getCostCodeProperties()) {
            if (ccp.getCategory() == null || ccp.isDontSyncToSabre()) continue;
            CostCodeCategoryReference catRef = (CostCodeCategoryReference)ccp.getCategory();
            CostCodeCategory cat = (CostCodeCategory)DictionaryCache.get().resolveReference((DictionaryReference)catRef);
            if (cat == null) continue;
            if (!TextUtil.isBlank((String)ccp.getSabreValue())) {
                String number = String.valueOf(ProfileSynchronizationUtil.getUdidNumberSafe(ccp.getType()));
                String fiveDotFormatString = ProfileSynchronizationUtil.prepareRemarkForSabre("U" + number + "-" + ccp.getSabreValue(), "", "5.", false);
                udidFiveDotFormats.add(fiveDotFormatString);
            }
            if (udidNumbers.contains(ccp.getType()) || TextUtil.isBlank((String)cat.getName())) continue;
            udidNumbers.add(ccp.getType());
            int number = ProfileSynchronizationUtil.getUdidNumberSafe(ccp.getType());
            String numberString = ProfileSynchronizationUtil.getUdidNumberString(ccp.getType());
            validationLineList.set(number - 1, Boolean.TRUE);
            String nameString = ProfileSynchronizationUtil.prepareRemarkForSabre(numberString + " - " + (!TextUtil.isBlank((String)cat.getName()) ? cat.getName() : ""), alphaCode, "5", true);
            udidNames.add(nameString);
            String shortNameStringMain = cat.getShortName() != null ? ProfileSynchronizationUtil.fillLine(cat.getShortName(), '.', 15) : "";
            String sabreValue = ccp.getSabreValue();
            String valueStringMain = sabreValue != null ? (!TextUtil.isBlank((String)sabreValue) ? sabreValue : "BLANK") : "";
            String valueString = numberString + "*" + shortNameStringMain + "*";
            String value = !TextUtil.isBlank((String)valueStringMain) ? valueStringMain : "BLANK";
            valueString = valueString + value + "*";
            valueString = ProfileSynchronizationUtil.prepareRemarkForSabre(valueString, "", "5.X*", false);
            if (valueString.charAt(valueString.length() - 1) != '*') {
                valueString = valueString.substring(0, valueString.length() - 1) + "*";
            }
            udidValues.add(valueString);
            if (ccp.isSabreDropList()) {
                ArrayList<String> dropList = new ArrayList<String>(ProfileHelper.getCostCodesForOrganization((CostCodeProperties)ccp, orgRef, false));
                udidDropListMap.put(ccp.getType(), ProfileSynchronizationUtil.removeIllegalSymbols(dropList, true));
            }
            String syntaxStringMain = ccp.getSabreRemarks() != null ? ccp.getSabreRemarks() : "";
            String prefix = ProfileSynchronizationUtil.getUdidNumberString(ccp.getType()) + "*SYNTAX*";
            List<String> syntaxList = ProfileSynchronizationUtil.splitStringBySpace(syntaxStringMain, 57 - prefix.length() - 4);
            for (String s : syntaxList) {
                String line = ProfileSynchronizationUtil.prepareRemarkForSabre(prefix + s + "*", alphaCode, "5", true);
                udidSyntax.add(line);
            }
        }
        ArrayList udidDropListMapKeys = new ArrayList(udidDropListMap.keySet());
        udidDropListMapKeys.sort(Comparator.naturalOrder());
        for (CostCodeType key : udidDropListMapKeys) {
            if (udidDropListMap.get(key) == null) continue;
            String prefix = ProfileSynchronizationUtil.getUdidNumberString(key) + "*DL*";
            List<String> list = ProfileSynchronizationUtil.prepareMultiLineStrings((List)udidDropListMap.get(key), 53 - prefix.length(), ",");
            int i = 1;
            for (String str : list) {
                String endSymbol = i < list.size() ? "," : "*";
                ++i;
                String line = ProfileSynchronizationUtil.prepareRemarkForSabre(prefix + str + endSymbol, alphaCode, "5", true);
                udidDropList.add(line);
            }
            if (list.size() != 0) continue;
            String line = ProfileSynchronizationUtil.prepareRemarkForSabre(prefix + "*", alphaCode, "5", true);
            udidDropList.add(line);
        }
        String validationLine = "5" + alphaCode + '\u00a5' + "UDID VALIDATION - ";
        for (Boolean b : validationLineList) {
            if (b != null && b.booleanValue()) {
                validationLine = validationLine + "Y";
                continue;
            }
            validationLine = validationLine + "N";
        }
        res.add(0, validationLine);
        res.addAll(udidNames);
        res.addAll(udidFiveDotFormats);
        res.add(ProfileSynchronizationUtil.getDelimiterLine("FOR UDID SCRIPT", alphaCode, false));
        res.addAll(udidValues);
        res.addAll(udidSyntax);
        res.addAll(udidDropList);
        return res;
    }

    public static List<String> createUdidPersonList(Person person, EntityReference<Organization> orgRef, List<CostCodeInfo> udidValues) {
        return ProfileSynchronizationUtil.createUdidPersonList(person, orgRef, CostCodeProperties::isDontSyncToSabre, udidValues);
    }

    public static List<String> createUdidPersonList(Person person, EntityReference<Organization> orgRef, Predicate<CostCodeProperties> costCodePropPredicate, List<CostCodeInfo> udidValues) {
        List list;
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.U);
        Organization org = null;
        try {
            org = ProfileHelper.resolveReference(orgRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (org == null) {
            return res;
        }
        HashMap<CostCodeProperties, String> mapTypes = new HashMap<CostCodeProperties, String>();
        HashMap<CostCodeProperties, String> mapShortNames = new HashMap<CostCodeProperties, String>();
        HashMap mapDropList = new HashMap();
        for (CostCodeProperties ccp : org.getCostCodeProperties()) {
            mapTypes.put(ccp, ProfileSynchronizationUtil.getUdidNumberString(ccp.getType()));
            CostCodeCategory cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory());
            mapShortNames.put(ccp, cat != null ? cat.getShortName() : "");
        }
        LinkedHashMap<String, List> mapUniqueShortNames = new LinkedHashMap<String, List>();
        LinkedHashMap mapFiveDotFormats = new LinkedHashMap();
        for (PersonCostCode cc : person.getCostCodes()) {
            CostCodeInfo costCodeInfo;
            String type;
            CostCodeProperties costCodeProperties;
            if (!orgRef.equals((Object)cc.getOrganization()) || cc.getCostCodeProperties() == null || costCodePropPredicate.test(costCodeProperties = ProfileSynchronizationUtil.getCostCodePropertiesFromOrganization(cc, org)) || (type = (String)mapTypes.get(costCodeProperties)) == null) continue;
            String line = type + "*";
            String fiveDotLine = "";
            String shortName = (String)mapShortNames.get(costCodeProperties);
            if (TextUtil.isBlank((String)shortName)) {
                for (CostCodeProperties ccp : mapShortNames.keySet()) {
                    CostCodeCategory cat = (CostCodeCategory)DictionaryCache.get().resolveReference(ccp.getCategory());
                    if (!ProfileSynchronizationUtil.getUdidNumberString(ccp.getType()).equals(type) || cat == null || TextUtil.isBlank((String)cat.getShortName())) continue;
                    shortName = cat.getShortName();
                    break;
                }
            }
            if (shortName != null) {
                line = line + ProfileSynchronizationUtil.fillLine(shortName, '.', 15) + "*";
            }
            if (cc.getValue() != null) {
                List<String> list2;
                String udidValue = ProfileSynchronizationUtil.removeIllegalSymbols(cc.getValue(), true);
                line = line + udidValue + "*";
                fiveDotLine = type.replaceAll("0(?!$)", "") + "-" + cc.getValue();
                if (!mapDropList.containsKey(type)) {
                    list2 = new ArrayList<String>();
                    list2.add(udidValue);
                    mapDropList.put(type, list2);
                } else {
                    list2 = (List)mapDropList.get(type);
                    list2.add(udidValue);
                    mapDropList.put(type, list2);
                }
            }
            if (!mapUniqueShortNames.containsKey(type)) {
                mapUniqueShortNames.put(type, new ArrayList());
            }
            if (!mapFiveDotFormats.containsKey(type)) {
                mapFiveDotFormats.put(type, new ArrayList());
            }
            List temp = (List)mapUniqueShortNames.get(type);
            temp.add(line);
            mapUniqueShortNames.put(type, temp);
            if (!TextUtil.isBlank((String)fiveDotLine)) {
                List temp2 = (List)mapFiveDotFormats.get(type);
                temp2.add(fiveDotLine);
            }
            if (org.getExternalSystem() == null || costCodeProperties.getType() == null || !TextUtil.nonBlank((String)cc.getValue()) || (costCodeInfo = CostCodesHelper.createCostCodeInfo(cc, costCodeProperties, org.getExternalSystem())) == null) continue;
            udidValues.add(costCodeInfo);
        }
        for (Object type : mapUniqueShortNames.keySet()) {
            list = (List)mapUniqueShortNames.get(type);
            if (list.size() != 1) continue;
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre((String)list.get(0), "", "5.X*", false));
        }
        for (Object type : mapFiveDotFormats.keySet()) {
            list = (List)mapFiveDotFormats.get(type);
            if (list.size() != 1) continue;
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre((String)list.get(0), "", "5.", false));
        }
        ArrayList udidDropListMapKeys = new ArrayList(mapDropList.keySet());
        udidDropListMapKeys.sort(String::compareTo);
        for (String key : udidDropListMapKeys) {
            if (mapDropList.get(key) == null || ((List)mapDropList.get(key)).size() < 2) continue;
            List dropList = (List)mapDropList.get(key);
            String prefix = key + "*DL*";
            List<String> list3 = ProfileSynchronizationUtil.prepareMultiLineStrings(dropList, 53 - prefix.length(), ",");
            int i = 1;
            for (String str : list3) {
                String endSymbol = i < list3.size() ? "," : "*";
                ++i;
                String line = ProfileSynchronizationUtil.prepareRemarkForSabre(prefix + str + endSymbol, alphaCode, "5", true);
                res.add(line);
            }
            if (list3.size() != 0) continue;
            String line = ProfileSynchronizationUtil.prepareRemarkForSabre(prefix + "*", alphaCode, "5", true);
            res.add(line);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getPersonGetThereAcquisitionCode(person)) && ProfileSynchronizationUtil.getOrganizationWithSyncParam(person) != null) {
            String loginToGT = ProfileSynchronizationUtil.getPersonGetThereAcquisitionCode(person).toUpperCase().replaceAll("@", "AT").replaceAll("_", "");
            if (loginToGT.length() > 16) {
                loginToGT = loginToGT.substring(0, 16);
            }
            String s = "5.U*1-" + loginToGT;
            res.add(s);
        }
        return res;
    }

    static CostCodeProperties getCostCodePropertiesFromOrganization(PersonCostCode costCode, Organization organization) {
        return organization.getCostCodeProperties().stream().filter(arg_0 -> ((CostCodeProperties)costCode.getCostCodeProperties()).equals(arg_0)).findFirst().orElse(costCode.getCostCodeProperties());
    }

    public static String getPersonGetThereAcquisitionCode(Person person) {
        String acquisitionCode = ProfileSynchronizationUtil.getMetadataString(person, MetadataKey.KEY_PERSON_GET_THERE_ACQUISITION_CODE);
        if (TextUtil.isBlank((String)acquisitionCode)) {
            acquisitionCode = person.getResourceIdForGetThere();
        }
        return acquisitionCode;
    }

    public static List<String> createReasonCodeList(List<ReasonCode> reasonCodes, ReasonCodeType type, String afsSettings) {
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getReasonAlphaCode(type);
        if (type.equals((Object)ReasonCodeType.REASON_CODE_AIR)) {
            String afsValidationLine = "AFS VALIDATION - " + ProfileSynchronizationUtil.createAfsValidationLine(afsSettings, reasonCodes);
            afsValidationLine = ProfileSynchronizationUtil.prepareRemarkForSabre(afsValidationLine, alphaCode, "5", true);
            res.add(afsValidationLine);
            res.addAll(ProfileSynchronizationUtil.getReasonCodesByType(reasonCodes, type, alphaCode, "AIR "));
            ArrayList<String> dropList = new ArrayList<String>();
            for (ReasonCode rc : reasonCodes) {
                if (!rc.getType().equals((Object)type) || !TextUtil.nonBlank((String)rc.getName())) continue;
                dropList.add(rc.getName());
            }
        } else if (type.equals((Object)ReasonCodeType.REASON_CODE_CAR)) {
            res.addAll(ProfileSynchronizationUtil.getReasonCodesByType(reasonCodes, type, alphaCode, "CAR RC - "));
        } else if (type.equals((Object)ReasonCodeType.REASON_CODE_HOTEL)) {
            String hfsValidationLine = "HFS VALIDATION - " + ProfileSynchronizationUtil.createHfsValidationLine(null, reasonCodes);
            hfsValidationLine = ProfileSynchronizationUtil.prepareRemarkForSabre(hfsValidationLine, alphaCode, "5", true);
            res.add(hfsValidationLine);
            res.addAll(ProfileSynchronizationUtil.getReasonCodesByType(reasonCodes, type, alphaCode, "HOTEL RC - "));
        } else if (type.equals((Object)ReasonCodeType.REASON_CODE_NO_HOTEL)) {
            res.addAll(ProfileSynchronizationUtil.getReasonCodesByType(reasonCodes, type, alphaCode, "NO HOTEL RC - "));
        } else if (type.equals((Object)ReasonCodeType.REASON_CODE_DECLINED)) {
            res.addAll(ProfileSynchronizationUtil.getReasonCodesByType(reasonCodes, type, alphaCode, "DECL RSN RC - "));
        }
        return res;
    }

    public static String createAfsValidationLine(String afsSettings, List<ReasonCode> reasonCodes) {
        StringBuilder res = new StringBuilder();
        if (afsSettings == null) {
            afsSettings = "";
        }
        for (AFSType type : AFSType.values()) {
            if (AFSType.ATF1.equals((Object)type) || afsSettings.contains(type.name())) {
                res.append("Y");
                continue;
            }
            res.append("N");
        }
        boolean hasAirReasonCodes = false;
        for (ReasonCode rc : reasonCodes) {
            if (!ReasonCodeType.REASON_CODE_AIR.equals((Object)rc.getType())) continue;
            hasAirReasonCodes = true;
            break;
        }
        res.append(hasAirReasonCodes ? "Y" : "N");
        return res.toString();
    }

    public static String createHfsValidationLine(String hfsSettings, List<ReasonCode> reasonCodes) {
        StringBuilder res = new StringBuilder();
        if (hfsSettings == null) {
            hfsSettings = "";
        }
        boolean hasHotelReasonCodes = false;
        for (ReasonCode rc : reasonCodes) {
            if (!ReasonCodeType.REASON_CODE_HOTEL.equals((Object)rc.getType())) continue;
            hasHotelReasonCodes = true;
            break;
        }
        res.append(hasHotelReasonCodes ? "Y" : "N");
        return res.toString();
    }

    public static String createAfsTimeWindow(Organization org) {
        if (org != null && org.getAfsTimeWindow() != null && org.getAfsTimeWindow() >= 1 && org.getAfsTimeWindow() <= 9) {
            return "5A\u00a5AFS-TW-" + org.getAfsTimeWindow();
        }
        return null;
    }

    public static String createAfsAirports(Organization org) {
        if (org != null) {
            String isCalculation = org.isAfsAirports() ? "Y" : "N";
            return "5A\u00a5AFS-AP-" + isCalculation;
        }
        return null;
    }

    public static List<String> createPaymentList(List<EntityReference<Organization>> payers, EntityReference<Organization> selfRef) {
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.P);
        if (selfRef != null) {
            payers = new ArrayList<EntityReference<Organization>>(payers);
            payers.removeIf(arg_0 -> selfRef.equals(arg_0));
            payers.add(0, selfRef);
        }
        for (EntityReference<Organization> orgRef : payers) {
            Organization org;
            try {
                org = ProfileHelper.resolveReference(orgRef);
            }
            catch (Exception e) {
                org = null;
            }
            if (org == null) continue;
            String name = ProfileSynchronizationUtil.getSabreLocale(org.getShortName());
            String line = "PAYER/" + name + " *" + org.getCode() + "*";
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, alphaCode, "5", true));
        }
        return res;
    }

    public static List<String> createPreferencesCodeList(List<SabreProfileLine> sabreAdditionalProfileLines, String nameLine, SabreProfileLineServiceType serviceType, String prefix, boolean isPerson) {
        ArrayList<String> res = new ArrayList<String>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(serviceType);
        for (SabreProfileLine line : sabreAdditionalProfileLines) {
            if (line.getLineServiceType() == null || !line.getLineServiceType().equals((Object)serviceType)) continue;
            if (TextUtil.nonBlank((String)line.getLineSubsection()) && isPerson) {
                String subsection = line.getLineSubsection();
                String[] parts = line.getLineSubsection().split("\\s+");
                if (parts.length > 1) {
                    subsection = parts[0];
                }
                String str = prefix + subsection + (!TextUtil.isBlank((String)nameLine) ? nameLine : "") + "*";
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(str, alphaCode, "5", true));
                if (!TextUtil.nonBlank((String)line.getLineBody())) continue;
                res.add(ProfileSynchronizationUtil.prepareSeatRemarkForSabre(line.getLineBody(), subsection, "3", nameLine));
                continue;
            }
            if (!TextUtil.nonBlank((String)line.getLineBody())) continue;
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line.getLineBody(), alphaCode, "5", true));
        }
        return res;
    }

    public static List<SabreProfileLineDataProxy> createFreeTextRemarksList(List<String> sabreFreeTextRemarks) {
        ArrayList<SabreProfileLineDataProxy> res = new ArrayList<SabreProfileLineDataProxy>();
        for (String s : sabreFreeTextRemarks) {
            ArrayList<String> parts = new ArrayList<String>();
            ProfileSynchronizationUtil.split(s, 63, parts);
            for (String part : parts) {
                StringBuilder sb = new StringBuilder(part);
                ProfileSynchronizationUtil.checkSymbols(sb, true);
                part = sb.toString();
                if (TextUtil.isBlank((String)part)) continue;
                String lineBody = "5" + part.toUpperCase();
                res.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(SabreProfileLineType.A), lineBody));
            }
        }
        return res;
    }

    public static List<String> replaceCross(List<String> list) {
        for (String line : list) {
            String string = line.replaceAll(String.valueOf('\u0081'), String.valueOf('\u00a5'));
        }
        return list;
    }

    public static void replaceCross(Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            ArrayList<String> list = new ArrayList<String>();
            for (String line : entry.getValue()) {
                list.add(line.replaceAll(String.valueOf('\u0081'), String.valueOf('\u00a5')));
            }
            entry.setValue(list);
        }
    }

    public static String preparePassportName(L10nString nameFromProfile, String nameFromPassport, boolean removeSlashesAndHyphens, boolean removeSpaces) {
        String nameStr = nameFromPassport;
        nameStr = ProfileSynchronizationUtil.removeIllegalSymbols(nameStr, true);
        if (TextUtil.isBlank((String)(nameStr = ProfileSynchronizationUtil.removeSpacesSlashesAndHyphens(nameStr, removeSlashesAndHyphens, removeSpaces))) || !ProfileSynchronizationUtil.checkForLatinSymbols(nameStr, true)) {
            nameStr = ProfileSynchronizationUtil.getSabreLocale(nameFromProfile);
            nameStr = ProfileSynchronizationUtil.removeIllegalSymbols(nameStr, true);
            nameStr = ProfileSynchronizationUtil.removeSpacesSlashesAndHyphens(nameStr, removeSlashesAndHyphens, removeSpaces);
        }
        return ProfileSynchronizationUtil.formatField(nameStr);
    }

    public static String removeSpacesSlashesAndHyphens(String str) {
        return ProfileSynchronizationUtil.removeSpacesSlashesAndHyphens(str, true, true);
    }

    public static String removeSlashesAndHyphens(String str) {
        return ProfileSynchronizationUtil.removeSpacesSlashesAndHyphens(str, true, false);
    }

    public static String removeSpacesSlashesAndHyphens(String str, boolean removeSlashesAndHyphens, boolean removeSpaces) {
        if (str == null) {
            return null;
        }
        return removeSlashesAndHyphens ? (removeSpaces ? str.replaceAll("[\\s-/]", "") : str.replaceAll("[-/]", "")) : (removeSpaces ? str.replaceAll("[\\s]", "") : str);
    }

    public static Map<String, List<String>> createPassportStrings(Person passenger, boolean needVQualifier) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        HashSet<String> uniquePassports = new HashSet<String>();
        String lastNameFromProfile = ProfileSynchronizationUtil.removeSlashesAndHyphens(ProfileSynchronizationUtil.getSabreLocale(passenger.getLastName()));
        String firstNameFromProfile = ProfileSynchronizationUtil.removeSlashesAndHyphens(ProfileSynchronizationUtil.getSabreLocale(passenger.getFirstName()));
        for (Passport passengerPassport : passenger.getPassports()) {
            String documentExpirationDate;
            if (passengerPassport.getCorrelationId() != null && PassportCorrelationQualifier.CYRILLIC == passengerPassport.getCorrelationQualifier()) continue;
            String number = passengerPassport.getNumber();
            if (number != null) {
                number = number.replaceAll("\\s+", "");
            }
            if (passengerPassport.getOriginCountry() == null || TextUtil.isBlank((String)number) || !ProfileSynchronizationUtil.checkForLatinSymbols(number, ",/\\-\\.") || passengerPassport.getGender() == null) continue;
            String lastName = ProfileSynchronizationUtil.preparePassportName(passenger.getLastName(), passengerPassport.getLastName(), true, false);
            String firstName = ProfileSynchronizationUtil.preparePassportName(passenger.getFirstName(), passengerPassport.getFirstName(), true, false);
            if (TextUtil.isBlank((String)lastName) || TextUtil.isBlank((String)firstName)) continue;
            String middleName = TextUtil.isBlank((String)passengerPassport.getMiddleName()) ? null : ProfileSynchronizationUtil.preparePassportName(passenger.getMiddleName(), passengerPassport.getMiddleName(), true, false);
            String secondName = ProfileSynchronizationUtil.preparePassportName(null, passengerPassport.getSecondName(), true, false);
            String salutation = ProfileSynchronizationUtil.createSalutation(passenger);
            String nameLine = ProfileSynchronizationUtil.createPersonNameLine(lastName, firstName, salutation, ProfileHelper.isPersonInfant(passengerPassport));
            if (!res.containsKey(nameLine)) {
                res.put(nameLine, new ArrayList());
            }
            String dateOfBirth = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.formatDate(passengerPassport.getBirthday()));
            String documentType = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.toSabreDocumentType(passengerPassport.getType()));
            String documentIssueCountry = ProfileSynchronizationUtil.getIso3OrIataCode(passengerPassport.getOriginCountry());
            String documentNumber = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.makeAlphaNumStr(passengerPassport.getNumber()));
            StringBuilder mainPassportData = new StringBuilder();
            mainPassportData.append(TextUtil.nonNullStr((String)documentType)).append(TextUtil.nonNullStr((String)documentNumber));
            if (uniquePassports.contains(mainPassportData.toString())) continue;
            uniquePassports.add(mainPassportData.toString());
            String documentNationalityCountry = ProfileSynchronizationUtil.getIso3OrIataCode(passengerPassport.getCitizenship());
            String gender = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.toSabreGenger(passengerPassport, passenger.getGender()));
            java.sql.Date expirationDate = ProfileSynchronizationUtil.calculateExpirationDocumentDate(passengerPassport);
            if (expirationDate == null || MiscUtil.clearTime((Date)new Date()).after(expirationDate) || (documentExpirationDate = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.formatDate(expirationDate))) == null) continue;
            String refNumber = "-" + ProfileSynchronizationUtil.crop30Chars(lastNameFromProfile) + "/" + ProfileSynchronizationUtil.crop30Chars(firstNameFromProfile);
            String passStr = (needVQualifier ? ",V" : "") + "3DOCS/" + documentType + "/" + documentIssueCountry + "/" + documentNumber + "/" + documentNationalityCountry + "/" + dateOfBirth + "/" + gender + "/" + documentExpirationDate + "/" + ProfileSynchronizationUtil.crop30Chars(lastName) + "/" + ProfileSynchronizationUtil.crop30Chars(firstName) + (!TextUtil.isBlank((String)secondName) ? "/" + ProfileSynchronizationUtil.crop30Chars(secondName) : "") + refNumber;
            List temp = (List)res.get(nameLine);
            temp.add(passStr);
            if (!TextUtil.isBlank((String)middleName)) {
                String passStrWithMiddleAndSecondName = (needVQualifier ? ",V" : "") + "3DOCS/" + documentType + "/" + documentIssueCountry + "/" + documentNumber + "/" + documentNationalityCountry + "/" + dateOfBirth + "/" + gender + "/" + documentExpirationDate + "/" + ProfileSynchronizationUtil.crop30Chars(lastName) + "/" + ProfileSynchronizationUtil.crop30Chars(firstName) + " " + ProfileSynchronizationUtil.crop30Chars(middleName) + (!TextUtil.isBlank((String)secondName) ? "/" + ProfileSynchronizationUtil.crop30Chars(secondName) : "") + refNumber;
                temp.add(passStrWithMiddleAndSecondName);
            }
            res.put(nameLine, temp);
        }
        return res;
    }

    public static Map<String, List<String>> createPassportStringsInfant(Person passenger) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (Passport passengerPassport : passenger.getPassports()) {
            String number = passengerPassport.getNumber();
            if (number != null) {
                number = number.replaceAll("\\s+", "");
            }
            if (passengerPassport.getOriginCountry() == null || TextUtil.isBlank((String)number) || !ProfileSynchronizationUtil.checkForLatinSymbols(number, ",/\\-\\.")) continue;
            String lastName = ProfileSynchronizationUtil.preparePassportName(passenger.getLastName(), passengerPassport.getLastName(), true, false);
            String firstName = ProfileSynchronizationUtil.preparePassportName(passenger.getFirstName(), passengerPassport.getFirstName(), true, false);
            String salutation = ProfileSynchronizationUtil.createSalutation(passenger);
            if (TextUtil.isBlank((String)lastName) || TextUtil.isBlank((String)firstName) || !ProfileHelper.isPersonInfant(passengerPassport)) continue;
            String nameLine = ProfileSynchronizationUtil.createPersonNameLine(lastName, firstName, salutation, true);
            if (!res.containsKey(nameLine)) {
                res.put(nameLine, new ArrayList());
            }
            String documentType = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.toSabreDocumentType(passengerPassport.getType()));
            String documentNumber = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.makeAlphaNumStr(passengerPassport.getNumber()));
            String dateOfBirth = ProfileSynchronizationUtil.formatField(ProfileSynchronizationUtil.formatDate(passengerPassport.getBirthday()));
            String passStr = "3OSI PSPT" + documentType + documentNumber + "/DOB" + dateOfBirth + "-" + ProfileSynchronizationUtil.crop30Chars(lastName) + "/" + ProfileSynchronizationUtil.crop30Chars(firstName);
            List temp = (List)res.get(nameLine);
            temp.add(passStr);
            res.put(nameLine, temp);
        }
        return res;
    }

    public static List<String> createSpecialServiceSSRs(Person passenger, SabreProfileLineServiceType type) {
        ArrayList<String> res = new ArrayList<String>();
        String lastNameFromProfile = ProfileSynchronizationUtil.getSabreLocale(passenger.getLastName());
        String firstNameFromProfile = ProfileSynchronizationUtil.getSabreLocale(passenger.getFirstName());
        String refNumber = lastNameFromProfile + "/" + firstNameFromProfile;
        refNumber = refNumber.replaceAll(" ", "").replaceAll("-", "");
        for (SabreProfileLine line : passenger.getSabreAdditionalProfileLines()) {
            if (!type.equals((Object)line.getLineServiceType()) || TextUtil.isBlank((String)line.getLineSubsection())) continue;
            String ssr = "3" + (line.getLineSubsection().length() > 4 ? line.getLineSubsection().substring(0, 4) : line.getLineSubsection()) + "-" + refNumber;
            res.add(ssr);
        }
        return res;
    }

    public static List<String> createCWTPersonRemarks(CwtOrganizationData orgData, CwtPersonData perData) {
        String line;
        ArrayList<String> res = new ArrayList<String>();
        if (orgData != null) {
            if (!TextUtil.isBlank((String)orgData.getClientTopGUID()) || !TextUtil.isBlank((String)orgData.getClientSubGUID())) {
                line = "GUID/CT-" + orgData.getClientTopGUID() + "/SU-" + orgData.getClientSubGUID();
                line = line.replaceAll(":", "-");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, "P", "5", true));
            }
            if (TextUtil.nonBlank((String)orgData.getClientTopName())) {
                line = "PORTRAIT CLIENT-" + orgData.getClientTopName();
                line = line.replaceAll(":", "-");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, "P", "5", true));
            }
            if (TextUtil.nonBlank((String)orgData.getClientSubName())) {
                line = "PORTRAIT SUB-" + ProfileSynchronizationUtil.removeBracket(orgData.getClientSubName());
                line = line.replaceAll(":", "-");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, "P", "5", true));
            }
        }
        if (perData != null) {
            if (!TextUtil.isBlank((String)perData.getTravellerTypeGUID()) || !TextUtil.isBlank((String)perData.getTravellerGUID())) {
                line = "GUID/TT-" + perData.getTravellerTypeGUID() + "/T-" + perData.getTravellerGUID();
                line = line.replaceAll(":", "-");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, "P", "5", true));
            }
            if (TextUtil.nonBlank((String)perData.getTravellerGUID())) {
                line = ".*0650*" + perData.getTravellerGUID();
                line = line.replaceAll(":", "-");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, "", "5", false));
            }
            if (TextUtil.nonBlank((String)perData.getTravellerTypeName())) {
                line = "TRVLR TYPE-" + perData.getTravellerTypeName();
                line = line.replaceAll(":", "-");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line, "P", "5", true));
            }
        }
        return res;
    }

    private static String createReferenceName(Person passenger) {
        String lastNameFromProfile = ProfileSynchronizationUtil.getSabreLocale(passenger.getLastName());
        String firstNameFromProfile = ProfileSynchronizationUtil.getSabreLocale(passenger.getFirstName());
        String refNameWithSlash = lastNameFromProfile + "/" + firstNameFromProfile;
        refNameWithSlash = refNameWithSlash.replaceAll("-", "");
        return refNameWithSlash;
    }

    private static String createReferenceName(Organization organization) {
        String lastNameFromProfile = ProfileSynchronizationUtil.getSabreLocale(organization.getShortName());
        return lastNameFromProfile.replaceAll("[-_]", "");
    }

    public static List<String> createPhonesAndEmailsSSRs(Person passenger) {
        ArrayList<String> res = new ArrayList<String>();
        String refNameWithSlash = ProfileSynchronizationUtil.createReferenceName(passenger);
        for (Communication comm : passenger.getCommunications()) {
            String line = null;
            if (comm.getType() == CommunicationType.EMAIL) {
                line = ProfileSynchronizationUtil.createEmailSSR(comm, refNameWithSlash);
            } else if (comm.getType() == CommunicationType.MOBILE || comm.getType() == CommunicationType.CELL) {
                line = ProfileSynchronizationUtil.createPhoneSSR(comm, refNameWithSlash);
            }
            if (TextUtil.isBlank((String)line)) continue;
            res.add(line);
        }
        return res;
    }

    public static List<String> createPhonesAndEmailsSSRs(Organization organization) {
        ArrayList<String> res = new ArrayList<String>();
        for (Communication comm : organization.getCommunications()) {
            String line = null;
            if (comm.getType() == CommunicationType.EMAIL) {
                line = ProfileSynchronizationUtil.createEmailSSR(comm, null);
            } else if (comm.getType() == CommunicationType.MOBILE || comm.getType() == CommunicationType.CELL) {
                line = ProfileSynchronizationUtil.createPhoneSSR(comm, null);
            }
            if (TextUtil.isBlank((String)line)) continue;
            res.add(line);
        }
        return res;
    }

    public static String createPhoneSSR(Communication comm, String refName) {
        if (TextUtil.isBlank((String)comm.getSense()) || comm.getType() == CommunicationType.EMAIL || comm.getType() == CommunicationType.WEB) {
            return null;
        }
        StringBuilder ssrStr = new StringBuilder();
        StringBuilder number = new StringBuilder();
        if (!TextUtil.isBlank((String)comm.getCountryCode())) {
            number.append(comm.getCountryCode());
        }
        if (!TextUtil.isBlank((String)comm.getCityCode())) {
            number.append(comm.getCityCode());
        }
        if (!TextUtil.isBlank((String)comm.getSense())) {
            number.append(comm.getSense());
        }
        ssrStr.append("3CTCM/").append(number.toString().replaceAll("[^0-9]+", ""));
        if (TextUtil.nonBlank((String)refName)) {
            ssrStr.append("-").append(refName);
        }
        return ssrStr.toString();
    }

    public static String createEmailSSR(Communication comm, String refName) {
        if (TextUtil.isBlank((String)comm.getSense()) || comm.getType() != CommunicationType.EMAIL) {
            return null;
        }
        StringBuilder ssrStr = new StringBuilder();
        ssrStr.append("3CTCE/").append(ProfileSynchronizationUtil.replaceSymbolsEmail(comm.getSense().toUpperCase()));
        if (TextUtil.nonBlank((String)refName)) {
            ssrStr.append("-").append(refName);
        }
        return ssrStr.toString();
    }

    public static List<String> createPhonesAndEmailsForRiskManagementCompanies(Person person, Set<RiskManagementCompany> riskCompanies) {
        ArrayList<String> res = new ArrayList<String>();
        for (PersonCommunication comm : person.getCommunications()) {
            if (TextUtil.isBlank((String)comm.getSense()) || comm.getType() != CommunicationType.MOBILE && comm.getType() != CommunicationType.EMAIL && comm.getType() != CommunicationType.CELL) continue;
            String line = "";
            StringBuilder number = new StringBuilder();
            if (!TextUtil.isBlank((String)comm.getCountryCode())) {
                number.append(comm.getCountryCode().replaceAll("\\s+", "").replaceAll("-", "")).append(" ");
            }
            if (!TextUtil.isBlank((String)comm.getCityCode())) {
                number.append(comm.getCityCode().replaceAll("\\s+", "").replaceAll("-", "")).append("-");
            }
            if (!TextUtil.isBlank((String)comm.getSense())) {
                number.append(comm.getSense().replaceAll("\\s+", "").replaceAll("-", ""));
            }
            if (riskCompanies.contains(RiskManagementCompany.IJET)) {
                if (comm.getType() != CommunicationType.EMAIL) {
                    line = "5E\u00a5IJET PHONE/" + number.toString();
                } else if (comm.getType() == CommunicationType.EMAIL) {
                    line = "5E\u00a5IJET EMAIL/" + ProfileSynchronizationUtil.replaceSymbolsEmail(comm.getSense().toUpperCase());
                }
            }
            if (TextUtil.isBlank((String)line)) continue;
            res.add(line);
        }
        return res;
    }

    public static List<String> createPhonesAndEmails3OSIs(Person passenger) {
        ArrayList<String> res = new ArrayList<String>();
        String refNameWithSlash = ProfileSynchronizationUtil.createReferenceName(passenger);
        for (Communication c : passenger.getCommunications()) {
            String name = c.getType() == CommunicationType.MOBILE || c.getType() == CommunicationType.CELL ? null : refNameWithSlash;
            String line = c.getType() == CommunicationType.EMAIL ? ProfileSynchronizationUtil.create3OsiEmail(c) : ProfileSynchronizationUtil.create3OsiPhone(c, null, name);
            if (!TextUtil.nonBlank((String)line)) continue;
            res.add(line);
        }
        return res;
    }

    public static List<String> createPhonesAndEmails3OSIs(Organization organization) {
        ArrayList<String> res = new ArrayList<String>();
        String refName = ProfileSynchronizationUtil.createReferenceName(organization);
        for (Communication c : organization.getCommunications()) {
            String line = c.getType() == CommunicationType.EMAIL ? ProfileSynchronizationUtil.create3OsiEmail(c) : ProfileSynchronizationUtil.create3OsiPhone(c, null, refName);
            if (!TextUtil.nonBlank((String)line)) continue;
            res.add(line);
        }
        return res;
    }

    public static String create3OsiPhone(Communication comm, String commTypeLetter, String nameRef) {
        if (TextUtil.isBlank((String)comm.getSense()) || comm.getType() != CommunicationType.WORK_PHONE && comm.getType() != CommunicationType.MOBILE && comm.getType() != CommunicationType.HOME_PHONE && comm.getType() != CommunicationType.CELL && comm.getType() != CommunicationType.AGENCY) {
            return null;
        }
        String primaryCommunicationType = TextUtil.nonBlank((String)commTypeLetter) ? commTypeLetter : ProfileSynchronizationUtil.getOsiPhoneTypeLetter(comm.getType());
        StringBuilder osiStr = new StringBuilder();
        osiStr.append("3OSI").append(" YY CTC").append(primaryCommunicationType).append(" ");
        StringBuilder phone = new StringBuilder();
        if (TextUtil.nonBlank((String)comm.getCountryCode())) {
            phone.append(comm.getCountryCode());
        }
        if (TextUtil.nonBlank((String)comm.getCityCode())) {
            if (phone.length() > 0) {
                phone.append(" ");
            }
            phone.append(comm.getCityCode());
        }
        if (TextUtil.nonBlank((String)comm.getSense())) {
            if (phone.length() > 0) {
                phone.append(" ");
            }
            phone.append(comm.getSense());
        }
        if (TextUtil.nonBlank((String)comm.getInternalNumber())) {
            phone.append("X").append(comm.getInternalNumber());
        }
        if (TextUtil.isBlank((String)phone.toString())) {
            return null;
        }
        osiStr.append(phone.toString().replaceAll("[^0-9X]+", ""));
        if (TextUtil.nonBlank((String)nameRef)) {
            osiStr.append(" ").append(nameRef);
        }
        return osiStr.toString();
    }

    public static String create3OsiEmail(Communication comm) {
        if (TextUtil.isBlank((String)comm.getSense())) {
            return null;
        }
        return "3OSI YY CTCE " + ProfileSynchronizationUtil.replaceSymbolsEmail(comm.getSense().toUpperCase());
    }

    public static List<String> createVisasList(Person passenger, boolean needVQualifier) {
        if (passenger == null || passenger.getVisas().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        String firstName = ProfileSynchronizationUtil.getSabreLocale(passenger.getFirstName()).replaceAll("[\\s\\-]+", "");
        String lastName = ProfileSynchronizationUtil.getSabreLocale(passenger.getLastName()).replaceAll("[\\s\\-]+", "");
        String secondName = ProfileSynchronizationUtil.getSabreLocale(passenger.getSecondName()).replaceAll("[\\s\\-]+", "");
        boolean isInfant = ProfileHelper.isPersonInfant(passenger);
        String nameLine = (isInfant ? "-I" : "-") + (TextUtil.nonBlank((String)lastName) ? lastName + "/" : "") + (TextUtil.nonBlank((String)firstName) ? firstName : "") + (TextUtil.nonBlank((String)secondName) ? " " + secondName : "");
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
        for (Visa visa : passenger.getVisas()) {
            if (TextUtil.isBlank((String)visa.getNumber()) || visa.getBirthPlace() == null || visa.getCountry() == null || visa.getIssueCity() == null || visa.getIssueCountry() == null || visa.getIssueDate() == null || visa.getEndDate() == null) continue;
            String birthPlaceCode = ProfileSynchronizationUtil.getIso3OrIataCode(visa.getBirthPlace());
            String issueCountryCode = ProfileSynchronizationUtil.getIso3OrIataCode(visa.getIssueCountry());
            String targetCountryCode = ProfileSynchronizationUtil.getIso3OrIataCode(visa.getCountry());
            String issueDate = visa.getIssueDate() != null ? dateFormat.format(visa.getIssueDate()) : "";
            String expireDate = dateFormat.format(visa.getEndDate());
            GeoLocation issueCity = (GeoLocation)DictionaryCache.get().resolveReference(visa.getIssueCity());
            String issueCityStr = issueCity != null ? ProfileSynchronizationUtil.getSabreLocale(issueCity.getTranslations()) : "";
            String issueStr = (!TextUtil.isBlank((String)issueCityStr) ? issueCityStr : "") + " " + (!TextUtil.isBlank((String)issueCountryCode) ? issueCountryCode : "");
            String line = (needVQualifier ? ",V" : "") + "3DOCO" + (!TextUtil.isBlank((String)birthPlaceCode) ? "/" + birthPlaceCode : "") + "/V" + (!TextUtil.isBlank((String)visa.getNumber()) ? "/" + visa.getNumber() : "") + (!TextUtil.isBlank((String)issueStr) ? "/" + issueStr : "") + (!TextUtil.isBlank((String)issueDate) ? "/" + issueDate : "") + (!TextUtil.isBlank((String)targetCountryCode) ? "/" + targetCountryCode : "") + (!TextUtil.isBlank((String)expireDate) ? String.format("//%s", expireDate) : "//") + (!TextUtil.isBlank((String)nameLine) ? nameLine : "");
            res.add(line.toUpperCase());
        }
        return res;
    }

    public static List<String> createCreditCardList(List<Card> cards, boolean useCir) {
        ArrayList<String> res = new ArrayList<String>();
        for (Card card : cards) {
            if (TextUtil.isBlank((String)card.getNumber()) || TextUtil.isBlank((String)card.getNameOnCard()) || card.getExpiration() == null || card.getVendor() == null || !ProfileSynchronizationConstants.Card2Abbr.containsKey(card.getVendor())) continue;
            StringBuilder line1 = new StringBuilder("/CC\u00a5");
            StringBuilder line2 = new StringBuilder("CC");
            String abbr = ProfileSynchronizationUtil.getStringByCardVendor(card.getVendor());
            if (!TextUtil.isBlank((String)abbr)) {
                line1.append(abbr);
                line2.append(abbr);
            }
            if (useCir) {
                line1.append("UID:").append(card.getCirUid());
            } else if (card.getNumber() != null) {
                line1.append(card.getNumber());
            }
            if (card.getNumber().length() > 4) {
                line2.append(" ").append(card.getNumber().substring(card.getNumber().length() - 4));
            } else {
                line2.append(" ").append(card.getNumber());
            }
            if (card.getExpiration() != null) {
                String exp = new SimpleDateFormat("MM/yy").format(card.getExpiration());
                line1.append(" EXP ").append(exp);
            }
            if (card.isSof()) {
                line2.append(" SOF");
            }
            if (card.isBta()) {
                line2.append(" BTA");
            }
            if (!TextUtil.isBlank((String)card.getRemarks()) && ProfileSynchronizationUtil.checkForLatinSymbols(card.getRemarks(), true)) {
                line2.append("-").append(card.getRemarks());
            }
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line1.toString(), "", "5H-", false, true));
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line2.toString(), "", "5H-", false));
        }
        return res;
    }

    public static List<String> createCarBonusCardList(Collection<CarBonusCard> carBonusCards, boolean isPerson) {
        ArrayList<String> res = new ArrayList<String>();
        for (CarBonusCard card : carBonusCards) {
            CarsSupplier supplier = (CarsSupplier)DictionaryCache.get().resolveReference(card.getCarSupplier());
            if (supplier == null) continue;
            String supplierName = ProfileSynchronizationUtil.removeIllegalSymbols(supplier.toString(Locale.ENGLISH), true);
            String cardNumber = ProfileSynchronizationUtil.removeIllegalSymbolsCardNumber(card.getNumber());
            if (TextUtil.isBlank((String)supplierName) || TextUtil.isBlank((String)cardNumber)) continue;
            res.add(ProfileSynchronizationUtil.createBonusCardString(SabreProfileLineServiceType.C, supplierName, cardNumber, isPerson));
        }
        return res;
    }

    public static List<String> createHotelBonusCardList(Collection<HotelBonusCard> hotelBonusCards, boolean isPerson) {
        ArrayList<String> res = new ArrayList<String>();
        for (HotelBonusCard card : hotelBonusCards) {
            HotelsBrand hotelBrand = (HotelsBrand)DictionaryCache.get().resolveReference(card.getHotelBrand());
            if (hotelBrand == null) continue;
            String hotelBrandName = ProfileSynchronizationUtil.removeIllegalSymbols(hotelBrand.toString(Locale.ENGLISH), true);
            String cardNumber = ProfileSynchronizationUtil.removeIllegalSymbolsCardNumber(card.getNumber());
            if (TextUtil.isBlank((String)hotelBrandName) || TextUtil.isBlank((String)cardNumber)) continue;
            res.add(ProfileSynchronizationUtil.createBonusCardString(SabreProfileLineServiceType.H, hotelBrandName, cardNumber, isPerson));
        }
        return res;
    }

    public static List<String> createRailwayBonusCardList(Collection<RailwayBonusCard> railwayBonusCards, boolean isPerson) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[^-]*-(.+)");
        for (RailwayBonusCard card : railwayBonusCards) {
            Matcher matcher;
            String railwayCarrierCode = card.getRailwayCarrierCode();
            if (railwayCarrierCode == null || !(matcher = pattern.matcher(railwayCarrierCode)).find()) continue;
            String railwayCarrierName = ProfileSynchronizationUtil.removeIllegalSymbols(matcher.group(1), true);
            String cardNumber = ProfileSynchronizationUtil.removeIllegalSymbolsCardNumber(card.getNumber());
            if (TextUtil.isBlank((String)railwayCarrierName) || TextUtil.isBlank((String)cardNumber)) continue;
            res.add(ProfileSynchronizationUtil.createBonusCardString(SabreProfileLineServiceType.R, railwayCarrierName, cardNumber, isPerson));
        }
        return res;
    }

    private static String createBonusCardString(SabreProfileLineServiceType serviceType, String name, String number, boolean isPerson) {
        return ("5" + ProfileSynchronizationUtil.getLineServiceTypeString(serviceType) + '\u00a5' + ProfileSynchronizationUtil.getLineServiceTypeStringForRemark(serviceType) + " " + (isPerson ? "PERSONAL ID" : "CORPORATE ID") + "/ " + name.trim() + " - " + number.trim()).toUpperCase();
    }

    public static List<SabreProfileLineDataProxy> createNotesList(SabreProfileLineType lineType, String notes) {
        String[] rows;
        ArrayList<SabreProfileLineDataProxy> res = new ArrayList<SabreProfileLineDataProxy>();
        for (String row : rows = ParsingUtils.getLines(notes)) {
            if (TextUtil.isBlank((String)row)) continue;
            row = row.trim();
            List<String> parts = ProfileSynchronizationUtil.splitStringBySpace(row, 54);
            for (String part : parts) {
                if (TextUtil.isBlank((String)part)) continue;
                res.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(lineType), ProfileSynchronizationUtil.prepareRemarkForSabre(part, "", "5", true)));
            }
        }
        return res;
    }

    public static String createSalutation(Person person) {
        String res = person.getTitle() != null ? person.getTitle().toString() : (person.getGender() == null || person.getGender().equals((Object)Gender.MALE) ? "MR" : "MRS");
        return res;
    }

    public static String createPersonNameLine(Person person, String salutation, boolean isInfant) {
        String lastName = ProfileSynchronizationUtil.getSabreLocale(person.getLastName());
        lastName = lastName.replaceAll("\\W+", "").replaceAll("\\d+", "");
        String firstName = ProfileSynchronizationUtil.getSabreLocale(person.getFirstName());
        firstName = firstName.replaceAll("\\W+", "").replaceAll("\\d+", "");
        return ProfileSynchronizationUtil.createPersonNameLine(lastName, firstName, salutation, isInfant);
    }

    public static String createPersonNameLine(String lastName, String firstName, String salutation, boolean isInfant) {
        String res = "";
        if (!TextUtil.isBlank((String)lastName)) {
            res = res + lastName.toUpperCase();
        }
        if (!TextUtil.isBlank((String)firstName)) {
            if (!TextUtil.isBlank((String)lastName)) {
                res = res + "/";
            }
            res = res + firstName.toUpperCase();
        }
        res = res.replaceAll("[\\s\\-]+", "");
        if (!TextUtil.isBlank((String)salutation)) {
            res = res + " " + salutation;
        }
        res = isInfant ? "-I/" + res : "-" + res;
        return res;
    }

    public static String preparePhone(String countryCode, String cityCode, String sense, String internalNumber, String typeLetter, String contactName) {
        StringBuilder phone = new StringBuilder();
        if (!TextUtil.isBlank((String)countryCode)) {
            phone.append(countryCode);
            phone.append(" ");
        }
        if (!TextUtil.isBlank((String)cityCode)) {
            phone.append(cityCode);
            phone.append(" ");
        }
        String initialPhone = sense;
        for (int i = 0; i < initialPhone.length(); ++i) {
            if (!Character.isDigit(initialPhone.charAt(i))) continue;
            phone.append(initialPhone.charAt(i));
        }
        if (!TextUtil.isBlank((String)internalNumber)) {
            phone.append("X");
            phone.append(internalNumber);
        }
        if (!TextUtil.isBlank((String)typeLetter)) {
            phone.append("-").append(typeLetter);
        }
        if (!TextUtil.isBlank((String)contactName)) {
            phone.append("-").append(contactName);
        }
        return phone.toString();
    }

    public static EntityReference<Organization> getOrganizationWithSyncParam(Person per) {
        EntityReference res = null;
        if (per == null) {
            return res;
        }
        for (PersonEmployment pe : per.getEmployments()) {
            EntityContainer orgCont;
            if (pe.getOrganization() == null || (orgCont = EntityStorage.get().resolve(pe.getOrganization())) == null || orgCont.getEntity() == null) continue;
            Organization org = (Organization)orgCont.getEntity();
            for (Metadata meta : org.getMetadata()) {
                if (meta.getKey() == null || !"KEY_ORGANIZATION_GET_THERE_SYNC".equals(meta.getKey().getCode()) || !Boolean.TRUE.equals(meta.getValue())) continue;
                res = orgCont.toReference();
            }
        }
        return res;
    }

    public static List<String> createVisaRemarksList(List<SabreProfileLine> sabreAdditionalProfileLines) {
        ArrayList<String> res = new ArrayList<String>();
        SabreProfileLineServiceType serviceType = SabreProfileLineServiceType.V;
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(serviceType);
        for (SabreProfileLine line : sabreAdditionalProfileLines) {
            if (line.getLineServiceType() == null || !line.getLineServiceType().equals((Object)serviceType)) continue;
            if (!TextUtil.isBlank((String)line.getLineSubsection())) {
                String str = line.getLineSubsection() + (!TextUtil.isBlank((String)line.getLineBody()) ? " - " + line.getLineBody() : "");
                res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(str, alphaCode, "5", true));
                continue;
            }
            if (TextUtil.isBlank((String)line.getLineBody())) continue;
            res.add(ProfileSynchronizationUtil.prepareRemarkForSabre(line.getLineBody(), alphaCode, "5", true));
        }
        return res;
    }

    public static List<SabreProfileLineDataProxy> createKeyContactsList(List<ProfileKeyContactPerson> keyContacts, EntityReference<Organization> orgRef, boolean needVQualifier) {
        ArrayList<SabreProfileLineDataProxy> res = new ArrayList<SabreProfileLineDataProxy>();
        String alphaCode = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.K);
        for (ProfileKeyContactPerson keyContact : keyContacts) {
            String profession;
            Object c2;
            Person person;
            if (keyContact.getPerson() == null) continue;
            EntityContainer perCont = null;
            try {
                perCont = EntityStorage.get().resolve(keyContact.getPerson());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((person = perCont != null ? (Person)perCont.getEntity() : null) == null) continue;
            String firstName = ProfileSynchronizationUtil.getSabreLocale(person.getFirstName());
            String lastName = ProfileSynchronizationUtil.getSabreLocale(person.getLastName());
            String phoneStr = "";
            for (Object c2 : person.getCommunications()) {
                String initialPhone;
                if (c2.getType() != CommunicationType.WORK_PHONE && c2.getType() != CommunicationType.MOBILE) continue;
                StringBuilder phone = new StringBuilder();
                if (!TextUtil.isBlank((String)c2.getCountryCode())) {
                    phone.append(c2.getCountryCode().replaceAll("\\s+", "").replaceAll("-", ""));
                    phone.append("-");
                }
                if (!TextUtil.isBlank((String)c2.getCityCode())) {
                    phone.append(c2.getCityCode().replaceAll("\\s+", "").replaceAll("-", ""));
                    phone.append("-");
                }
                if (!TextUtil.isBlank((String)(initialPhone = c2.getSense()))) {
                    for (int i = 0; i < initialPhone.length(); ++i) {
                        if (!Character.isDigit(initialPhone.charAt(i)) && initialPhone.charAt(i) != '-') continue;
                        phone.append(initialPhone.charAt(i));
                    }
                }
                if (!TextUtil.isBlank((String)c2.getInternalNumber())) {
                    phone.append("X");
                    phone.append(c2.getInternalNumber());
                }
                if (c2.getType() == CommunicationType.WORK_PHONE) {
                    phone.append("-B");
                } else if (c2.getType() == CommunicationType.MOBILE) {
                    phone.append("-M");
                }
                phoneStr = phone.toString();
                break;
            }
            if (!TextUtil.isBlank((String)(profession = ProfileSynchronizationUtil.createProfession(person, null)))) {
                profession = "-" + profession;
            }
            c2 = person.getEmployments().iterator();
            while (c2.hasNext()) {
                PersonPosition pos;
                PersonEmployment pe = (PersonEmployment)c2.next();
                if (pe.getPosition() == null || (pos = (PersonPosition)DictionaryCache.get().resolveReference(pe.getPosition())) == null) continue;
                String posEng = ProfileSynchronizationUtil.getSabreLocale(pos.getTranslations());
                profession = !TextUtil.isBlank((String)posEng) ? "-" + posEng : "";
            }
            String line = ProfileSynchronizationUtil.prepareRemarkForSabre(phoneStr + profession + "-" + firstName + " " + lastName, alphaCode, "5", true);
            res.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(keyContact.getLineType()), (needVQualifier ? ",K" : "") + line));
            String email = ProfileSynchronizationUtil.getCommunicationByType(person.getCommunications(), CommunicationType.EMAIL);
            if (TextUtil.isBlank((String)email)) continue;
            email = email.replaceAll("_", "==");
            email = "PE\u0081" + email.toUpperCase() + '\u0081';
            if (SabreKeyContactEmailType.BC.equals((Object)keyContact.getEmailType())) {
                email = email + "BC" + "/";
            } else if (SabreKeyContactEmailType.CC.equals((Object)keyContact.getEmailType())) {
                email = email + "CC" + "/";
            }
            res.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(keyContact.getLineType()), (needVQualifier ? ",K" : "") + email));
        }
        return res;
    }

    public static void createKeyContactsAsRemarksList(List<ProfileKeyContactPerson> keyContacts, EntityReference<Organization> orgRef, List<SabreProfileLineDataProxy> phonesAndEmails) {
        String alphaCodeK = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.K);
        String alphaCodeW = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.W);
        for (ProfileKeyContactPerson keyContact : keyContacts) {
            String comment;
            String profession;
            Object c2;
            Person person;
            if (keyContact.getPerson() == null) continue;
            EntityContainer perCont = null;
            try {
                perCont = EntityStorage.get().resolve(keyContact.getPerson());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((person = perCont != null ? (Person)perCont.getEntity() : null) == null) continue;
            String firstName = ProfileSynchronizationUtil.getSabreLocale(person.getFirstName());
            String lastName = ProfileSynchronizationUtil.getSabreLocale(person.getLastName());
            String phoneStr = "NO PHONE NUM";
            for (Object c2 : person.getCommunications()) {
                String initialPhone;
                if (c2.getType() != CommunicationType.WORK_PHONE && c2.getType() != CommunicationType.MOBILE) continue;
                StringBuilder phone = new StringBuilder();
                if (!TextUtil.isBlank((String)c2.getCountryCode())) {
                    phone.append(c2.getCountryCode().replaceAll("\\s+", "").replaceAll("-", ""));
                    phone.append("-");
                }
                if (!TextUtil.isBlank((String)c2.getCityCode())) {
                    phone.append(c2.getCityCode().replaceAll("\\s+", "").replaceAll("-", ""));
                    phone.append("-");
                }
                if (!TextUtil.isBlank((String)(initialPhone = c2.getSense()))) {
                    for (int i = 0; i < initialPhone.length(); ++i) {
                        if (!Character.isDigit(initialPhone.charAt(i)) && initialPhone.charAt(i) != '-') continue;
                        phone.append(initialPhone.charAt(i));
                    }
                }
                if (!TextUtil.isBlank((String)c2.getInternalNumber())) {
                    phone.append("X");
                    phone.append(c2.getInternalNumber());
                }
                if (c2.getType() == CommunicationType.WORK_PHONE) {
                    phone.append("-B");
                } else if (c2.getType() == CommunicationType.MOBILE) {
                    phone.append("-M");
                }
                phoneStr = phone.toString();
                break;
            }
            if (!TextUtil.isBlank((String)(profession = ProfileSynchronizationUtil.createProfession(person, null)))) {
                profession = "-" + profession;
            }
            c2 = person.getEmployments().iterator();
            while (c2.hasNext()) {
                PersonPosition pos;
                PersonEmployment pe = (PersonEmployment)c2.next();
                if (pe.getPosition() == null || (pos = (PersonPosition)DictionaryCache.get().resolveReference(pe.getPosition())) == null) continue;
                String posEng = ProfileSynchronizationUtil.getSabreLocale(pos.getTranslations());
                profession = !TextUtil.isBlank((String)posEng) ? "-" + posEng : "";
            }
            String line = ProfileSynchronizationUtil.prepareRemarkForSabre(phoneStr + profession + "-" + firstName + " " + lastName, alphaCodeK, "5", true);
            phonesAndEmails.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(keyContact.getLineType()), line));
            String email = ProfileSynchronizationUtil.getCommunicationByType(person.getCommunications(), CommunicationType.EMAIL);
            if (TextUtil.isBlank((String)email)) {
                email = "NO EMAIL ADDRESS";
            }
            email = email.replaceAll("_", ".UN.");
            email = email.replaceAll("@", ".AT.");
            email = email.toUpperCase() + '\u00a5';
            String string = comment = !TextUtil.isBlank((String)keyContact.getNotes()) ? keyContact.getNotes().toUpperCase() : "";
            if (SabreKeyContactEmailType.BC.equals((Object)keyContact.getEmailType())) {
                email = email + "BC" + "/" + comment;
            } else if (SabreKeyContactEmailType.CC.equals((Object)keyContact.getEmailType())) {
                email = email + "CC" + "/" + comment;
            } else if (SabreKeyContactEmailType.TO.equals((Object)keyContact.getEmailType())) {
                email = email + "TO" + "/" + comment;
            }
            email = email + ProfileSynchronizationUtil.getLanguageForEmailNewChangeSign(person.getPreferredLocale());
            line = ProfileSynchronizationUtil.prepareRemarkForSabre(email, alphaCodeW, "5", true);
            phonesAndEmails.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(keyContact.getLineType()), line));
        }
    }

    public static void createSabreContactsAsRemarksList(Person person, List<SabreProfileLineDataProxy> phones, List<SabreProfileLineDataProxy> emails) {
        String line;
        String alphaCodeK = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.K);
        String alphaCodeW = ProfileSynchronizationUtil.getLineServiceTypeString(SabreProfileLineServiceType.W);
        for (SabreContactPhone c : person.getSabrePhoneContacts()) {
            String initialPhone;
            if (c.getType() != CommunicationType.WORK_PHONE && c.getType() != CommunicationType.MOBILE) continue;
            StringBuilder phone = new StringBuilder();
            if (!TextUtil.isBlank((String)c.getCountryCode())) {
                phone.append(c.getCountryCode());
                phone.append("-");
            }
            if (!TextUtil.isBlank((String)c.getCityCode())) {
                phone.append(c.getCityCode());
                phone.append("-");
            }
            if (!TextUtil.isBlank((String)(initialPhone = c.getSense()))) {
                for (int i = 0; i < initialPhone.length(); ++i) {
                    if (!Character.isDigit(initialPhone.charAt(i)) && initialPhone.charAt(i) != '-') continue;
                    phone.append(initialPhone.charAt(i));
                }
            }
            if (!TextUtil.isBlank((String)c.getInternalNumber())) {
                phone.append("X");
                phone.append(c.getInternalNumber());
            }
            if (c.getType() == CommunicationType.WORK_PHONE) {
                phone.append("-B");
            } else if (c.getType() == CommunicationType.MOBILE) {
                phone.append("-M");
            }
            String phoneStr = phone.toString();
            line = ProfileSynchronizationUtil.prepareRemarkForSabre(phoneStr + TextUtil.join((String)" ", Arrays.asList(c.getContactFirstName(), c.getContactName()), (boolean)true), alphaCodeK, "5", true);
            phones.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(SabreProfileLineType.A), line));
        }
        for (SabreContactEmail e : person.getSabreEmailContacts()) {
            String email = e.getSense();
            if (TextUtil.isBlank((String)email)) continue;
            email = email.replaceAll("_", ".UN.");
            email = email.replaceAll("@", ".AT.");
            email = email.toUpperCase() + '\u00a5';
            String comment = TextUtil.join((String)" ", Arrays.asList(e.getContactFirstName(), e.getContactName()), (boolean)true);
            if (ProfileSynchronizationUtil.emailTypesEqual(SabreKeyContactEmailType.BC, e.getType())) {
                email = email + "BC" + "/" + comment;
            } else if (ProfileSynchronizationUtil.emailTypesEqual(SabreKeyContactEmailType.CC, e.getType())) {
                email = email + "CC" + "/" + comment;
            } else if (ProfileSynchronizationUtil.emailTypesEqual(SabreKeyContactEmailType.TO, e.getType())) {
                email = email + "TO" + "/" + comment;
            }
            email = email + ProfileSynchronizationUtil.getLanguageForEmailNewChangeSign(person.getPreferredLocale());
            line = ProfileSynchronizationUtil.prepareRemarkForSabre(email, alphaCodeW, "5", true);
            emails.add(new SabreProfileLineDataProxy(ProfileSynchronizationUtil.getLineTypeString(SabreProfileLineType.A), line));
        }
    }

    public static boolean emailTypesEqual(SabreKeyContactEmailType type1, String type2) {
        if (SabreKeyContactEmailType.TO.equals((Object)type1) && "TO".equalsIgnoreCase(type2)) {
            return true;
        }
        if (SabreKeyContactEmailType.CC.equals((Object)type1) && "CC".equalsIgnoreCase(type2)) {
            return true;
        }
        return SabreKeyContactEmailType.BC.equals((Object)type1) && "BC".equalsIgnoreCase(type2);
    }

    public static String createProfession(Person person, EntityReference<Organization> orgRef) {
        String result = "";
        for (PersonEmployment pe : person.getEmployments()) {
            PersonPosition pos;
            if (pe.getPosition() == null || orgRef != null && !pe.getOrganization().equals(orgRef) || (pos = (PersonPosition)DictionaryCache.get().resolveReference(pe.getPosition())) == null) continue;
            result = ProfileSynchronizationUtil.getSabreLocale(pos.getTranslations());
            break;
        }
        return result.toUpperCase();
    }

    public static String getLanguageForEmail(Locale locale) {
        Locale curLocale;
        String res = locale != null ? (locale.getLanguage().equals("ru") || locale.getLanguage().equals("uk") ? "\u0080U" : "\u0080E") : ((curLocale = LocaleManager.get().getCurrentLocale()) != null && curLocale.getLanguage().equals("ru") || curLocale != null && curLocale.getLanguage().equals("uk") ? "\u0080U" : "\u0080E");
        return res;
    }

    public static String getLanguageForEmailNewChangeSign(Locale locale) {
        Locale curLocale;
        String res = locale != null ? (locale.getLanguage().equals("ru") || locale.getLanguage().equals("uk") ? "\u00a4U" : "\u00a4E") : ((curLocale = LocaleManager.get().getCurrentLocale()) != null && curLocale.getLanguage().equals("ru") || curLocale != null && curLocale.getLanguage().equals("uk") ? "\u00a4U" : "\u00a4E");
        return res;
    }

    public static boolean hasSabreProfilesUniqueID(Organization org, String pcc) {
        return TextUtil.nonBlank((String)ProfileSynchronizationUtil.getSabreProfilesUniqueID(org, pcc));
    }

    public static String getSabreProfilesUniqueID(Organization org, String pcc) {
        if (TextUtil.isBlank((String)pcc)) {
            return null;
        }
        for (SabreProfilesUniqueIDSettings s : org.getSabreProfilesUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            return s.getUniqueID();
        }
        return null;
    }

    public static void setSabreProfilesUniqueID(Organization org, String pcc, String uniqueID) {
        if (TextUtil.isBlank((String)pcc)) {
            return;
        }
        boolean found = false;
        for (SabreProfilesUniqueIDSettings s : org.getSabreProfilesUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            s.setUniqueID(uniqueID);
            found = true;
            break;
        }
        if (!found) {
            SabreProfilesUniqueIDSettings s = new SabreProfilesUniqueIDSettings();
            s.setPcc(pcc);
            s.setUniqueID(uniqueID);
            org.getSabreProfilesUniqueIDs().add(s);
        }
    }

    public static String getSabreProfilesUniqueID(Person per, String pcc) {
        if (TextUtil.isBlank((String)pcc)) {
            return null;
        }
        for (SabreProfilesUniqueIDSettings s : per.getSabreProfilesUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            return s.getUniqueID();
        }
        return null;
    }

    public static void setSabreProfilesUniqueID(Person per, String pcc, String uniqueID) {
        if (TextUtil.isBlank((String)pcc)) {
            return;
        }
        boolean found = false;
        for (SabreProfilesUniqueIDSettings s : per.getSabreProfilesUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            s.setUniqueID(uniqueID);
            found = true;
            break;
        }
        if (!found) {
            SabreProfilesUniqueIDSettings s = new SabreProfilesUniqueIDSettings();
            s.setPcc(pcc);
            s.setUniqueID(uniqueID);
            per.getSabreProfilesUniqueIDs().add(s);
        }
    }

    public static void setSabreProfilesProfileName(Person per, String pcc, String profileName) {
        if (TextUtil.isBlank((String)profileName)) {
            return;
        }
        for (SabreProfilesUniqueIDSettings s : per.getSabreProfilesUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            s.setProfileName(profileName);
            return;
        }
    }

    public static void updatePnrBuildersFromSabreProfile(List<PNRBuilder> pnrBuildersFromMOMProfile, List<PNRBuilder> pnrBuildersFromSabreProfile, String pcc) {
        Iterator<PNRBuilder> iter1 = pnrBuildersFromMOMProfile.iterator();
        while (iter1.hasNext()) {
            PNRBuilder bld = iter1.next();
            bld.getBuilderUniqueIDs().removeIf(set -> TextUtil.isSame((String)set.getPcc(), (String)pcc, (boolean)true));
            if (!bld.getBuilderUniqueIDs().isEmpty()) continue;
            iter1.remove();
        }
        for (PNRBuilder bld : pnrBuildersFromSabreProfile) {
            List newSettings = bld.getBuilderUniqueIDs().stream().filter(set -> TextUtil.isSame((String)pcc, (String)set.getPcc())).map(set -> {
                SabreProfilesUniqueIDSettings newSet = new SabreProfilesUniqueIDSettings();
                newSet.setPcc(set.getPcc());
                newSet.setUniqueID(set.getUniqueID());
                return newSet;
            }).collect(Collectors.toList());
            boolean found = false;
            for (PNRBuilder bldMom : pnrBuildersFromMOMProfile) {
                if (!TextUtil.isSame((String)bld.getType(), (String)bldMom.getType(), (boolean)true) || !TextUtil.isSame((String)bld.getName(), (String)bldMom.getName(), (boolean)true)) continue;
                bldMom.getBuilderUniqueIDs().addAll(newSettings);
                found = true;
                break;
            }
            if (found) continue;
            PNRBuilder newBld = new PNRBuilder();
            newBld.setName(bld.getName());
            newBld.setType(bld.getType());
            newBld.getBuilderUniqueIDs().addAll(newSettings);
            pnrBuildersFromMOMProfile.add(newBld);
        }
    }

    public static void clearSabreProfilesUniqueID(List<SabreProfilesUniqueIDSettings> settings, String pcc) {
        if (TextUtil.nonBlank((String)pcc)) {
            settings.removeIf(s -> TextUtil.isSame((String)s.getPcc(), (String)pcc));
        }
    }

    public static String getSabreProfilesUniqueID(PNRBuilder bld, String pcc) {
        if (TextUtil.isBlank((String)pcc)) {
            return null;
        }
        for (SabreProfilesUniqueIDSettings s : bld.getBuilderUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            return s.getUniqueID();
        }
        return null;
    }

    public static void setSabreProfilesUniqueID(PNRBuilder bld, String pcc, String uniqueID) {
        if (TextUtil.isBlank((String)pcc)) {
            return;
        }
        boolean found = false;
        for (SabreProfilesUniqueIDSettings s : bld.getBuilderUniqueIDs()) {
            if (!TextUtil.isSame((String)s.getPcc(), (String)pcc)) continue;
            s.setUniqueID(uniqueID);
            found = true;
            break;
        }
        if (!found) {
            SabreProfilesUniqueIDSettings s = new SabreProfilesUniqueIDSettings();
            s.setPcc(pcc);
            s.setUniqueID(uniqueID);
            bld.getBuilderUniqueIDs().add(s);
        }
    }

    public static List<String> getAirlineCodes() {
        ArrayList<String> res = new ArrayList<String>();
        Map airlines = DictionaryCache.get().getAll(Airline.class);
        for (Map.Entry entry : airlines.entrySet()) {
            String code = (String)((Airline)entry.getValue()).getCodeVariants().get(CodeSystem.IATA.toString());
            if (code == null) continue;
            res.add(code);
        }
        return res;
    }

    public static List<SabreProfilesPccSettings> getSabreProfilesPccConnectionSettings() {
        SabreProfilesConnectionSettings connectionSettings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        return connectionSettings != null ? connectionSettings.getPccSettings() : Collections.emptyList();
    }

    public static SabreProfilesConnectionSettings getSabreProfilesConnectionSettings() {
        EntityContainer<SabreProfilesConnectionSettings> setCont = ProfileSynchronizationUtil.getSabreProfilesConnectionSettingsContainer();
        return setCont != null ? (SabreProfilesConnectionSettings)setCont.getEntity() : null;
    }

    public static EntityContainer<SabreProfilesConnectionSettings> getSabreProfilesConnectionSettingsContainer() {
        List indices;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.installationId.name(), (Object)"sabre-profiles-connection-settings-uid"));
        SearchResult searchResult = EntityStorage.get().search(BasicSystemSettingsIndex.class, query);
        List list = indices = searchResult != null ? searchResult.getData() : null;
        if (indices == null) {
            return null;
        }
        for (BasicSystemSettingsIndex ind : indices) {
            EntityContainer setCont = EntityStorage.get().resolve(ind.getSource());
            if (setCont == null || !(setCont.getEntity() instanceof SabreProfilesConnectionSettings) || !((SabreProfilesConnectionSettings)setCont.getEntity()).isActive()) continue;
            EntityContainer result = setCont;
            return result;
        }
        return null;
    }

    public static java.sql.Date calculateExpirationDocumentDate(PersonPassportWrapper passport) {
        return ProfileSynchronizationUtil.calculateExpirationDocumentDate(passport.getExpired(), passport.getType(), passport.getBirthday(), passport.getCitizenship());
    }

    public static java.sql.Date calculateExpirationDocumentDate(Passport passport) {
        return ProfileSynchronizationUtil.calculateExpirationDocumentDate(passport.getExpired(), passport.getType(), passport.getBirthday(), (DictionaryReference<Country>)passport.getCitizenship());
    }

    public static java.sql.Date calculateExpirationDocumentDate(Date expired, PassportType type, Date birthday, DictionaryReference<Country> citizenship) {
        if (expired != null) {
            return new java.sql.Date(expired.getTime());
        }
        if (type != null) {
            switch (type) {
                case INTERNAL: {
                    return ProfileSynchronizationUtil.calculateExpirationDateForRussianPassport(birthday);
                }
                case PASSPORT: {
                    if (!DictHelper.getUaRef().equals(citizenship)) break;
                    return ProfileSynchronizationUtil.calculateExpirationDateForUkrainianPassport();
                }
                case BIRTHDAY_NOTIFICATION: {
                    return ProfileSynchronizationUtil.calculateExpirationDateForBirthdayNotification(birthday, citizenship);
                }
            }
        }
        return null;
    }

    public static java.sql.Date calculateExpirationDateForRussianPassport(Date birthday) {
        return ProfileSynchronizationUtil.calculateExpirationDateForRussianPassport(birthday, 0);
    }

    public static java.sql.Date calculateExpirationDateForRussianPassport(Date birthday, int daysToReplacePassport) {
        if (Objects.isNull(birthday)) {
            return null;
        }
        Calendar currentDateCalendar = Calendar.getInstance();
        currentDateCalendar.add(6, -daysToReplacePassport);
        Date currentDate = currentDateCalendar.getTime();
        Calendar birthdayDateCalendar = Calendar.getInstance();
        birthdayDateCalendar.setTime(birthday);
        birthdayDateCalendar.add(1, 20);
        Date birthdayDate = birthdayDateCalendar.getTime();
        if (currentDate.before(birthdayDate)) {
            return new java.sql.Date(birthdayDate.getTime());
        }
        birthdayDateCalendar.add(1, 25);
        birthdayDate = birthdayDateCalendar.getTime();
        if (currentDate.before(birthdayDate)) {
            return new java.sql.Date(birthdayDate.getTime());
        }
        birthdayDateCalendar.add(1, 55);
        birthdayDate = birthdayDateCalendar.getTime();
        return new java.sql.Date(birthdayDate.getTime());
    }

    public static java.sql.Date calculateExpirationDateForUkrainianPassport() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 2099);
        return new java.sql.Date(cal.getTime().getTime());
    }

    public static java.sql.Date calculateExpirationDateForBirthdayNotification(Date birthday, DictionaryReference<Country> country) {
        if (birthday == null) {
            return null;
        }
        int ageExpire = DictHelper.getRuRef().equals(country) ? 14 : 18;
        return new java.sql.Date(MiscUtil.addYearsToDate((Date)birthday, (int)ageExpire).getTime());
    }

    public static String getFullNumber(SabreContactPhone phone) {
        StringBuilder fullPhone = new StringBuilder();
        if (TextUtil.nonBlank((String)phone.getCountryCode())) {
            fullPhone.append(phone.getCountryCode());
        }
        if (TextUtil.nonBlank((String)phone.getCityCode())) {
            fullPhone.append(phone.getCityCode());
        }
        if (TextUtil.nonBlank((String)phone.getSense())) {
            fullPhone.append(phone.getSense());
        }
        if (TextUtil.nonBlank((String)phone.getInternalNumber())) {
            fullPhone.append(phone.getInternalNumber());
        }
        return fullPhone.toString();
    }

    public static List<SabreProfilesPccSettings> getPccsFromSettings() {
        EntityContainer<Person> currentUserCtr = ProfileHelper.getCurrentUserCtr();
        ArrayList<SabreProfilesPccSettings> pccsFromSettings = new ArrayList<SabreProfilesPccSettings>();
        if (currentUserCtr != null && currentUserCtr.getEntity() != null) {
            pccsFromSettings.addAll(((Person)currentUserCtr.getEntity()).getSabreProfilesPccSettings());
        }
        if (pccsFromSettings.isEmpty()) {
            pccsFromSettings.addAll(ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings());
        }
        return pccsFromSettings;
    }

    public static List<SabreProfilesPccSettings> getPccSettingsFromProfile(EntityContainer<Person> personCont) {
        Person person = (Person)personCont.getEntity();
        if (!person.getSabreProfilesPccSettings().isEmpty()) {
            return person.getSabreProfilesPccSettings();
        }
        List<EntityContainer<Organization>> orgConts = ProfileHelper.getEmployments(person);
        HashSet<SabreProfilesPccSettings> res = new HashSet<SabreProfilesPccSettings>();
        List<SabreProfilesPccSettings> generalSettings = ProfileSynchronizationUtil.getPccsFromSettings();
        for (EntityContainer<Organization> orgCont : orgConts) {
            List<SabreProfilesPccSettings> settings = ProfileSynchronizationUtil.getPccSettingsFromProfiles(orgCont);
            res.addAll(!settings.isEmpty() ? settings : generalSettings);
        }
        return new ArrayList<SabreProfilesPccSettings>(res);
    }

    public static List<SabreProfilesPccSettings> getPccSettingsFromProfiles(EntityContainer<Organization> orgCont) {
        Organization organization;
        EntityContainer parentOrgCont;
        EntityContainer holdCont;
        Organization org = (Organization)orgCont.getEntity();
        if (!org.getSabreProfilesPccSettings().isEmpty()) {
            return org.getSabreProfilesPccSettings();
        }
        if (org.getHolding() != null && (holdCont = EntityStorage.get().resolve(org.getHolding())) != null && !((Holding)holdCont.getEntity()).getSabreProfilesPccSettings().isEmpty()) {
            return ((Holding)holdCont.getEntity()).getSabreProfilesPccSettings();
        }
        EntityReference orgRef = orgCont.toReference();
        Date now = new Date();
        ArrayList<EntityContainer<Contract>> clientContracts = new ArrayList<EntityContainer<Contract>>(ContractSynchronizationUtil.findNewClientContracts((EntityReference<Organization>)orgRef, now));
        clientContracts.addAll(ContractSynchronizationUtil.findOldClientContracts((EntityReference<Organization>)orgRef, now));
        for (EntityContainer entityContainer : clientContracts) {
            EntityContainer agencyCont;
            Contract contract = (Contract)entityContainer.getEntity();
            if (contract == null || (agencyCont = EntityStorage.get().resolve(contract.getSupplier())) == null || agencyCont.getEntity() == null || ((Organization)agencyCont.getEntity()).getSabreProfilesPccSettings().isEmpty()) continue;
            return ((Organization)agencyCont.getEntity()).getSabreProfilesPccSettings();
        }
        if (org.getParent() != null && (parentOrgCont = EntityStorage.get().resolve(org.getParent())) != null && !(organization = (Organization)parentOrgCont.getEntity()).getSabreProfilesPccSettings().isEmpty()) {
            return organization.getSabreProfilesPccSettings();
        }
        return Collections.emptyList();
    }

    public static List<String> getPccValues(Collection<SabreProfilesPccSettings> settings) {
        return settings.stream().filter(Objects::nonNull).map(SabreProfilesPccSettings::getPcc).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static List<SabreProfilesPccSettings> filterPccsSettings(List<SabreProfilesPccSettings> predefinedPccSettings, List<SabreProfilesPccSettings> allowedPccSettings) {
        if (predefinedPccSettings.isEmpty()) {
            return allowedPccSettings;
        }
        List<String> predefinedPccs = ProfileSynchronizationUtil.getPccValues(predefinedPccSettings);
        return allowedPccSettings.stream().filter(Objects::nonNull).filter(set -> predefinedPccs.contains(set.getPcc())).collect(Collectors.toList());
    }

    public static List<SabreProfilesPccSettings> filterIDsPccsSettings(List<String> pccSettings, List<SabreProfilesPccSettings> allowedPccSettings) {
        if (pccSettings.isEmpty()) {
            return allowedPccSettings;
        }
        return allowedPccSettings.stream().filter(Objects::nonNull).filter(allowedPcc -> pccSettings.contains(allowedPcc.getPcc())).collect(Collectors.toList());
    }

    public static String getEnglishValue(L10nString l10nString) {
        if (l10nString == null || l10nString.getValues().isEmpty()) {
            return null;
        }
        return l10nString.getValues().entrySet().stream().filter(entry -> Locale.ENGLISH.equals(LocaleUtil.createNormalizedLocale((Locale)((Locale)entry.getKey())))).map(Map.Entry::getValue).filter(TextUtil::nonBlank).map(String::trim).findAny().orElse(null);
    }

    public static void setEnglishValue(L10nString l10nString, String value) {
        l10nString.getValues().keySet().removeIf(locale -> Locale.ENGLISH.equals(LocaleUtil.createNormalizedLocale((Locale)locale)));
        if (TextUtil.isBlank((String)value)) {
            return;
        }
        l10nString.getValues().put(Locale.ENGLISH, value.trim());
    }

    public static String createCityLine(Address address) {
        GeoLocation city;
        String add;
        StringBuilder curCityLine = new StringBuilder();
        GeoRegion region = (GeoRegion)DictionaryCache.get().resolveReference(address.getRegion());
        if (region != null) {
            add = DictHelper.getTranslation((BaseDictionary)region, LocaleUtil.LOCALE_EN, true);
            if (TextUtil.nonBlank((String)(add = ProfileSynchronizationUtil.removeIllegalSymbols(add, true)))) {
                if (curCityLine.length() > 0) {
                    curCityLine.append(",");
                }
                curCityLine.append(add);
            }
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getDistrict()))) {
            add = ProfileSynchronizationUtil.getEnglishOrNullValue(address.getDistrict());
            if (curCityLine.length() > 0) {
                curCityLine.append(",");
            }
            curCityLine.append(add);
        }
        if (address.getCity() != null && (city = (GeoLocation)DictionaryCache.get().resolveReference(address.getCity())) != null) {
            String add2 = (String)city.getTranslations().get(LocaleUtil.LOCALE_EN);
            if (curCityLine.length() > 0) {
                curCityLine.append(",");
            }
            curCityLine.append(add2);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getTown()))) {
            add = ProfileSynchronizationUtil.getEnglishOrNullValue(address.getTown());
            if (curCityLine.length() > 0) {
                curCityLine.append(",");
            }
            curCityLine.append(add);
        }
        return TextUtil.truncate((String)curCityLine.toString(), (int)60);
    }

    public static List<String> createAddressLines(Address address) {
        String add;
        int addressLineLimit = 64;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder curAddressLine = new StringBuilder();
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getAddress()))) {
            add = ProfileSynchronizationUtil.getEnglishOrNullValue(address.getAddress());
            if (add.length() > 64) {
                for (String s : Splitter.fixedLength((int)64).split((CharSequence)add)) {
                    if (curAddressLine.length() + add.length() > 64) {
                        result.add(curAddressLine.toString());
                        curAddressLine = new StringBuilder();
                    }
                    if (curAddressLine.length() > 0) {
                        curAddressLine.append(",");
                    }
                    curAddressLine.append(s);
                }
            } else {
                curAddressLine.append(add);
            }
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getHouse()))) {
            add = "house " + ProfileSynchronizationUtil.getEnglishOrNullValue(address.getHouse());
            if (curAddressLine.length() + add.length() > 64) {
                result.add(curAddressLine.toString());
                curAddressLine = new StringBuilder();
            }
            if (curAddressLine.length() > 0) {
                curAddressLine.append(",");
            }
            curAddressLine.append(add);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getHousing()))) {
            add = "housing " + ProfileSynchronizationUtil.getEnglishOrNullValue(address.getHousing());
            if (curAddressLine.length() + add.length() > 64) {
                result.add(curAddressLine.toString());
                curAddressLine = new StringBuilder();
            }
            if (curAddressLine.length() > 0) {
                curAddressLine.append(",");
            }
            curAddressLine.append(add);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getBuilding()))) {
            add = "bld. " + ProfileSynchronizationUtil.getEnglishOrNullValue(address.getBuilding());
            if (curAddressLine.length() + add.length() > 64) {
                result.add(curAddressLine.toString());
                curAddressLine = new StringBuilder();
            }
            if (curAddressLine.length() > 0) {
                curAddressLine.append(",");
            }
            curAddressLine.append(add);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getPavilion()))) {
            add = "pav. " + ProfileSynchronizationUtil.getEnglishOrNullValue(address.getPavilion());
            if (curAddressLine.length() + add.length() > 64) {
                result.add(curAddressLine.toString());
                curAddressLine = new StringBuilder();
            }
            if (curAddressLine.length() > 0) {
                curAddressLine.append(",");
            }
            curAddressLine.append(add);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getOffice()))) {
            add = "ofc. " + ProfileSynchronizationUtil.getEnglishOrNullValue(address.getOffice());
            if (curAddressLine.length() + add.length() > 64) {
                result.add(curAddressLine.toString());
                curAddressLine = new StringBuilder();
            }
            if (curAddressLine.length() > 0) {
                curAddressLine.append(",");
            }
            curAddressLine.append(add);
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.getEnglishOrNullValue(address.getFlat()))) {
            add = "apt. " + ProfileSynchronizationUtil.getEnglishOrNullValue(address.getFlat());
            if (curAddressLine.length() + add.length() > 64) {
                result.add(curAddressLine.toString());
                curAddressLine = new StringBuilder();
            }
            if (curAddressLine.length() > 0) {
                curAddressLine.append(",");
            }
            curAddressLine.append(add);
        }
        result.add(curAddressLine.toString());
        result.removeIf(TextUtil::isBlank);
        return result;
    }

    public static String getEnglishOrNullValue(L10nString str) {
        if (str == null || str.getValues().size() == 0) {
            return null;
        }
        String res = "";
        if (str.getValues().containsKey(LocaleUtil.LOCALE_EN)) {
            res = (String)str.getValues().get(LocaleUtil.LOCALE_EN);
        } else if (str.getValues().containsKey(null)) {
            res = (String)str.getValues().get(null);
        }
        if (res != null) {
            res = res.trim();
        }
        return ProfileSynchronizationUtil.removeIllegalSymbols(res, true);
    }
}

