/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveProductData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsClientMode;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.SabrePassiveSegmentsConnectionSettings;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

public class SabrePassiveSegmentsUtil {
    public static final int REMARK_LIMIT = 66;
    private static final String BOOKING_NUMBER_REMARK_PREFIX = "X*BR";
    private static final Pattern digitsWhitespace = Pattern.compile("\\s*[0-9]+\\s*");
    public static final String SABRE_ILLEGAL_SYMBOLS = "[^A-Za-z0-9 ,/\\-\\.\\*\u00a4\u00a5\u0080\u0081]+";
    public static final Map<CommunicationType, String> COMMUNICATION_TYPES = new HashMap<CommunicationType, String>(){
        {
            this.put(CommunicationType.HOME_PHONE, "H");
            this.put(CommunicationType.WORK_PHONE, "B");
            this.put(CommunicationType.FAX, "F");
            this.put(CommunicationType.MOBILE, "M");
            this.put(CommunicationType.AGENCY, "B");
        }
    };
    private static final Map<MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>, String> GIVEN_NAME_SUFFIXES = new HashMap<MiscUtil.Pair<DictionaryReference<PassengerTypeCategory>, Gender>, String>(){
        {
            this.put(new MiscUtil.Pair(DictHelper.getAdultPassengerCategory(), (Object)Gender.MALE), "MR");
            this.put(new MiscUtil.Pair(DictHelper.getAdultPassengerCategory(), (Object)Gender.FEMALE), "MRS");
            this.put(new MiscUtil.Pair(DictHelper.getChildPassengerCategory(), (Object)Gender.MALE), "MSTR");
            this.put(new MiscUtil.Pair(DictHelper.getChildPassengerCategory(), (Object)Gender.FEMALE), "MISS");
            this.put(new MiscUtil.Pair(DictHelper.getInfantPassengerCategory(), (Object)Gender.MALE), "MSTR");
            this.put(new MiscUtil.Pair(DictHelper.getInfantPassengerCategory(), (Object)Gender.FEMALE), "MISS");
        }
    };
    private static final Map<GdsName, String> gds2str = new HashMap<GdsName, String>(){
        {
            this.put(GdsName.SIRENA, "SIRENA TRAVEL");
            this.put(GdsName.WEB_SITE, "WEB");
        }
    };
    private static final Map<String, GdsName> str2gds = new HashMap<String, GdsName>(){
        {
            this.put("SIRENA TRAVEL", GdsName.SIRENA);
        }
    };

    public static String formatDate(Date d) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("ddMMM", LocaleUtil.LOCALE_EN);
        return sdfDate.format(d);
    }

    public static String formatTime(Date d) {
        if (d == null) {
            return "";
        }
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmm", LocaleUtil.LOCALE_EN);
        return sdfTime.format(d);
    }

    public static Date parseDate(String s) throws ParseException {
        if (TextUtil.isBlank((String)s)) {
            return null;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("ddMMM", LocaleUtil.LOCALE_EN);
        return sdfDate.parse(s);
    }

    public static String formatDecimal(BigDecimal value, boolean needDecimals) {
        if (value == null) {
            return "";
        }
        DecimalFormat format = null;
        if (needDecimals) {
            format = new DecimalFormat("#0.00");
            DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols();
            decimalSymbols.setDecimalSeparator('.');
            format.setDecimalFormatSymbols(decimalSymbols);
        } else {
            format = new DecimalFormat("#0");
        }
        return format.format(value);
    }

    public static List<SabrePassiveRemarkData> prepareCrossSRemark(String uid, String text) {
        return SabrePassiveSegmentsUtil.prepareCrossSRemark(uid, "", text);
    }

    public static List<SabrePassiveRemarkData> prepareCrossSRemark(String uid, String prefix, String text) {
        return SabrePassiveSegmentsUtil.prepareCrossSRemark(uid, prefix, text, false);
    }

    public static List<SabrePassiveRemarkData> prepareCrossSRemark(String uid, String prefix, String text, boolean hasPrefixOnlyInFirstLine) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        List<String> lines = SabrePassiveSegmentsUtil.splitRemark(prefix, text);
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
            remark.setSegmentId(uid);
            remark.setType(SabrePassiveRemarkType.CROSS_S);
            if (hasPrefixOnlyInFirstLine) {
                remark.setText(lineNumber == 0 ? prefix + line : line);
            } else {
                remark.setText(prefix + line);
            }
            res.add(remark);
        }
        return res;
    }

    public static List<SabrePassiveRemarkData> prepareDotSRemark(String uid, String text) {
        return SabrePassiveSegmentsUtil.prepareDotSRemark(uid, "", text);
    }

    public static List<SabrePassiveRemarkData> prepareDotSRemark(String uid, String prefix, String text) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        List<String> lines = SabrePassiveSegmentsUtil.splitRemark(prefix, text);
        for (String line : lines) {
            SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
            remark.setSegmentId(uid);
            remark.setType(SabrePassiveRemarkType.DOT_S);
            remark.setText(prefix + line);
            res.add(remark);
        }
        return res;
    }

    private static List<String> splitRemark(String prefix, String text) {
        ArrayList<String> lines = new ArrayList<String>();
        if (prefix == null) {
            prefix = "";
        }
        int limit = 66 - prefix.length();
        int pos = 0;
        while (text.substring(pos).length() > limit) {
            lines.add(text.substring(pos, pos + limit));
            pos += limit;
        }
        lines.add(text.substring(pos));
        return lines;
    }

    public static SabrePassiveRemarkData prepareCrossRemark(String text) {
        SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
        remark.setType(SabrePassiveRemarkType.CROSS);
        remark.setText(text);
        return remark;
    }

    public static SabrePassiveRemarkData prepareDotXStarSegmentRemark(String text) {
        SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
        remark.setType(SabrePassiveRemarkType.DOT_X_STAR);
        remark.setText(text);
        return remark;
    }

    public static SabrePassiveRemarkData prepareDotXStarProductRemark(String text) {
        SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
        remark.setType(SabrePassiveRemarkType.DOT_X_STAR);
        remark.setText(text);
        return remark;
    }

    public static SabrePassiveRemarkData prepareDotProductRemark(String text) {
        SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
        remark.setType(SabrePassiveRemarkType.DOT);
        remark.setText(text);
        return remark;
    }

    public static SabrePassiveRemarkData prepareHistoricalRemark(String text) {
        SabrePassiveRemarkData remark = new SabrePassiveRemarkData();
        remark.setType(SabrePassiveRemarkType.HISTORICAL);
        remark.setText(text);
        return remark;
    }

    public static String getTranslation(DictionaryReference<? extends BaseDictionary> dictRef) {
        return TranslitUtil.cyr2lat((String)DictHelper.getTranslation(dictRef, LocaleUtil.LOCALE_EN, false), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006);
    }

    public static String getTranslation(BaseDictionary dict) {
        return TranslitUtil.cyr2lat((String)DictHelper.getTranslation(dict, LocaleUtil.LOCALE_EN, false), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006);
    }

    public static String getTranslation(String str) {
        return SabrePassiveSegmentsUtil.getTranslation(str, TranslitUtil.TranslitRules.GOST_52535_1_2006);
    }

    public static String getTranslation(String str, TranslitUtil.TranslitRules rules) {
        return TranslitUtil.cyr2lat((String)str, (TranslitUtil.TranslitRules)rules);
    }

    public static String buildGivenName(Traveller traveller, DictionaryReference<PassengerType> passengerType, SabreAviaParametersProvider parametersProvider) {
        String translated;
        Passport passport = traveller.getPassport();
        Person person = SabrePassiveSegmentsUtil.getPersonByTraveller(traveller);
        StringBuilder sb = new StringBuilder();
        String engLocaleFirstName = null;
        if (person != null) {
            engLocaleFirstName = L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)Locale.ENGLISH, (boolean)true);
        }
        String fistName = TextUtil.isBlank(engLocaleFirstName) ? passport.getFirstName() : engLocaleFirstName;
        sb.append(fistName);
        String engLocaleSecondName = null;
        if (person != null) {
            engLocaleSecondName = L10nStringHelper.getValue((L10nString)person.getSecondName(), (Locale)Locale.ENGLISH, (boolean)true);
        }
        boolean isEngLocaleSecondNameBlank = TextUtil.isBlank(engLocaleSecondName);
        String secondName = null;
        if (!isEngLocaleSecondNameBlank || !StringUtils.isBlank((String)passport.getSecondName())) {
            sb.append(' ');
            secondName = isEngLocaleSecondNameBlank ? passport.getSecondName() : engLocaleSecondName;
            sb.append(secondName);
        }
        if (sb.length() == 0) {
            sb.append(SabrePassiveSegmentsUtil.retrieveGivenName(traveller.getName()));
        }
        String title = null;
        if (!parametersProvider.isSubsidizedTariff() || !parametersProvider.isSuCarrier()) {
            if (!DictHelper.isInfantPassengerType(passengerType) || !parametersProvider.isNoInfGenderSuffix()) {
                title = SabrePassiveSegmentsUtil.getNameSuffix(passengerType, passport.getGender());
            }
            if (parametersProvider.isTchBlankOwner()) {
                if (DictHelper.isChildPassengerType(passengerType)) {
                    title = String.format("%s*%02d", SabrePassiveSegmentsUtil.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInYears());
                } else if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
                    title = String.format("%s*%02dMTHS", SabrePassiveSegmentsUtil.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInMonths());
                }
            }
        }
        if (!StringUtils.isBlank(title)) {
            sb.append(' ');
            sb.append(title);
        }
        if (sb.length() > 29) {
            sb = new StringBuilder();
            sb.append(fistName);
            if (!StringUtils.isBlank((String)secondName)) {
                sb.append(' ');
                sb.append(passport.getSecondName());
            }
            title = null;
            if (!parametersProvider.isSubsidizedTariff() || !parametersProvider.isSuCarrier()) {
                if (!DictHelper.isInfantPassengerType(passengerType) || !parametersProvider.isNoInfGenderSuffix()) {
                    title = SabrePassiveSegmentsUtil.getNameSuffix(passengerType, passport.getGender());
                }
                if (parametersProvider.isTchBlankOwner()) {
                    if (DictHelper.isChildPassengerType(passengerType)) {
                        title = String.format("%s*%02d", SabrePassiveSegmentsUtil.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInYears());
                    } else if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
                        title = String.format("%s*%02dMTHS", SabrePassiveSegmentsUtil.getNameSuffix(passengerType, passport.getGender()), parametersProvider.getAgeInMonths());
                    }
                }
            }
            if (!StringUtils.isBlank((String)title)) {
                sb.append(' ');
                sb.append(title);
            }
        }
        return (translated = SabrePassiveSegmentsUtil.getTranslation(sb.toString()).replaceAll("[^A-Za-z ]", "")).length() > 29 ? translated.substring(0, 29) : translated.toString();
    }

    private static String retrieveSurname(String fullName) {
        return Stream.of(fullName).filter(TextUtil::nonBlank).flatMap(s -> Stream.of(s.split(" "))).findFirst().orElse("");
    }

    private static String retrieveGivenName(String fullName) {
        return Stream.of(fullName).filter(TextUtil::nonBlank).flatMap(s -> Stream.of(s.split(" "))).skip(1L).collect(Collectors.joining(" "));
    }

    public static String buildSurname(Traveller traveller) {
        String lastName;
        Passport passport = traveller.getPassport();
        Person person = SabrePassiveSegmentsUtil.getPersonByTraveller(traveller);
        String engLocaleLastName = null;
        if (person != null) {
            engLocaleLastName = L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)Locale.ENGLISH, (boolean)true);
        }
        String string = lastName = TextUtil.isBlank(engLocaleLastName) ? passport.getLastName() : engLocaleLastName;
        if (TextUtil.isBlank((String)lastName)) {
            lastName = SabrePassiveSegmentsUtil.retrieveSurname(traveller.getName());
        }
        if (!StringUtils.isBlank((String)(lastName = SabrePassiveSegmentsUtil.getTranslation(lastName).replaceAll("[^A-Za-z ]", "")))) {
            if (lastName.length() == 1) {
                return lastName + lastName;
            }
            if (lastName.length() > 29) {
                return lastName.substring(0, 29);
            }
        }
        return lastName;
    }

    public static String getPersonLastName(Person person) {
        if (person == null) {
            return "";
        }
        String lastName = L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)Locale.ENGLISH, (boolean)false);
        return SabrePassiveSegmentsUtil.getTranslation(lastName).replaceAll("[^A-Za-z ]", "");
    }

    public static String getPersonGivenName(Person person) {
        if (person == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String firstName = L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)Locale.ENGLISH, (boolean)false);
        builder.append(firstName);
        String secondName = L10nStringHelper.getValue((L10nString)person.getSecondName(), (Locale)Locale.ENGLISH, (boolean)false);
        if (!TextUtil.isBlank((String)secondName)) {
            builder.append(" ").append(secondName);
        }
        return SabrePassiveSegmentsUtil.getTranslation(builder.toString()).replaceAll("[^A-Za-z ]", "");
    }

    public static String getNameSuffix(DictionaryReference<PassengerType> passengerType, Gender gender) {
        return GIVEN_NAME_SUFFIXES.get(new MiscUtil.Pair(DictHelper.findPrimaryCategory(passengerType), (Object)gender));
    }

    public static boolean isTchBlankOwner(EntityReference<Organization> blankOwnerRef) {
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr == null) {
            return false;
        }
        return "\u04281".equals(((Organization)blankOwnerCtr.getEntity()).getCode());
    }

    public static SabreAviaParametersProvider getAviaProvider(final Product p) {
        return new SabreAviaParametersProvider(){

            @Override
            public boolean isNoInfGenderSuffix() {
                return CollectionUtils.containsAny((Collection)p.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(s -> DictHelper.getCodeVariant(s.getAirline(), CodeSystem.IATA)).collect(Collectors.toList()), (Collection)NO_INF_GENDER_SUFFIX_AIRLINES);
            }

            @Override
            public boolean isTchBlankOwner() {
                return SabrePassiveSegmentsUtil.isTchBlankOwner((EntityReference<Organization>)p.getBlankOwnerRef());
            }

            @Override
            public int getAgeInYears() {
                return Years.yearsBetween((ReadableInstant)new DateTime((Object)p.getTraveller().getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)AirProductHelper.getLastArriveDate(p))).getYears();
            }

            @Override
            public int getAgeInMonths() {
                return Months.monthsBetween((ReadableInstant)new DateTime((Object)p.getTraveller().getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)AirProductHelper.getLastArriveDate(p))).getMonths();
            }

            @Override
            public boolean isSubsidizedTariff() {
                return p.isSubsidizedTariff();
            }

            @Override
            public boolean isSuCarrier() {
                return "SU".equals(DictHelper.getCodeVariant(p.getCarrier(), CodeSystem.IATA));
            }
        };
    }

    public static SabreAviaParametersProvider getHotelProvider(HotelProduct p, final Traveller t) {
        final Date lastCheckOutDate = p.getRooms().size() > 0 ? ((Room)p.getRooms().get(p.getRooms().size() - 1)).getCheckOutDate() : new Date();
        return new SabreAviaParametersProvider(){

            @Override
            public boolean isNoInfGenderSuffix() {
                return false;
            }

            @Override
            public boolean isTchBlankOwner() {
                return false;
            }

            @Override
            public int getAgeInYears() {
                return Years.yearsBetween((ReadableInstant)new DateTime((Object)t.getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)lastCheckOutDate)).getYears();
            }

            @Override
            public int getAgeInMonths() {
                return Months.monthsBetween((ReadableInstant)new DateTime((Object)t.getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)lastCheckOutDate)).getMonths();
            }

            @Override
            public boolean isSubsidizedTariff() {
                return false;
            }

            @Override
            public boolean isSuCarrier() {
                return false;
            }
        };
    }

    public static SabrePassiveSegmentsConnectionSettings getSabrePassiveSegmentsSettings() {
        List indices;
        SabrePassiveSegmentsConnectionSettings res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.installationId.name(), (Object)"sabre-passive-segments-connection-settings-uid"));
        SearchResult searchResult = EntityStorage.get().search(BasicSystemSettingsIndex.class, query);
        List list = indices = searchResult != null ? searchResult.getData() : null;
        if (indices == null) {
            return res;
        }
        for (BasicSystemSettingsIndex ind : indices) {
            EntityContainer setCont = EntityStorage.get().resolve(ind.getSource());
            if (setCont == null || !(setCont.getEntity() instanceof SabrePassiveSegmentsConnectionSettings) || !((SabrePassiveSegmentsConnectionSettings)setCont.getEntity()).isActive()) continue;
            res = (SabrePassiveSegmentsConnectionSettings)setCont.getEntity();
            break;
        }
        return res;
    }

    public static String getTravelerName(Traveller trv) {
        String res = "";
        if (trv != null) {
            String[] parts;
            if (trv.getPassport() != null && !TextUtil.isBlank((String)trv.getPassport().getLastName()) && !TextUtil.isBlank((String)trv.getPassport().getFirstName())) {
                res = SabrePassiveSegmentsUtil.getTranslation(trv.getPassport().getLastName()) + "/" + SabrePassiveSegmentsUtil.getTranslation(trv.getPassport().getFirstName());
                if (!TextUtil.isBlank((String)trv.getPassport().getSecondName())) {
                    res = res + " " + SabrePassiveSegmentsUtil.getTranslation(trv.getPassport().getSecondName());
                }
                if (!TextUtil.isBlank((String)trv.getPassport().getMiddleName())) {
                    res = res + " " + SabrePassiveSegmentsUtil.getTranslation(trv.getPassport().getMiddleName());
                }
            } else if (!TextUtil.isBlank((String)trv.getName()) && (parts = trv.getName().split("\\s+")).length > 0) {
                res = SabrePassiveSegmentsUtil.getTranslation(parts[0]);
                if (parts.length > 1) {
                    res = res + "/" + parts[1];
                }
                for (int i = 2; i < parts.length; ++i) {
                    res = res + " " + parts[i];
                }
            }
        }
        return res;
    }

    public static List<Communication> getAgentPhones(List<Communication> comms) {
        ArrayList<Communication> res = new ArrayList<Communication>();
        for (Communication c : comms) {
            if (c == null || c.getType() == null || !COMMUNICATION_TYPES.containsKey(c.getType())) continue;
            if (c.getType() == CommunicationType.AGENCY) {
                c.setType(CommunicationType.WORK_PHONE);
            }
            res.add(c);
        }
        return res;
    }

    public static List<Communication> getAgentPhones(BookingFile bf) {
        EntityContainer agCont;
        ArrayList<Communication> res = new ArrayList<Communication>();
        if (bf.getAgency() != null && (agCont = EntityStorage.get().resolve(bf.getAgency())) != null) {
            res.addAll(SabrePassiveSegmentsUtil.getAgentPhones(((Organization)agCont.getEntity()).getCommunications()));
        }
        return res;
    }

    public static void verifySegmentsAndRemarks(List<SabrePassiveProductData> dataList) {
        int bookingNumbersCount = 0;
        for (SabrePassiveProductData data : dataList) {
            Iterator remarksIter = data.getRemarks().iterator();
            while (remarksIter.hasNext()) {
                SabrePassiveRemarkData remark = (SabrePassiveRemarkData)remarksIter.next();
                if (TextUtil.isBlank((String)remark.getText())) {
                    remarksIter.remove();
                    continue;
                }
                if (remark.getText().length() > 66) {
                    remark.setText(remark.getText().substring(0, 66));
                }
                if (remark.getText().startsWith(BOOKING_NUMBER_REMARK_PREFIX) && ++bookingNumbersCount > 1) {
                    remarksIter.remove();
                }
                remark.setText(SabrePassiveSegmentsUtil.removeIllegalSymbols(SabrePassiveSegmentsUtil.getTranslation(remark.getText())));
            }
            for (SabrePassiveSegmentData seg : data.getSegments()) {
                seg.setCommandToCreate(SabrePassiveSegmentsUtil.removeIllegalSymbols(SabrePassiveSegmentsUtil.getTranslation(seg.getCommandToCreate())));
            }
        }
    }

    public static SabrePassiveSegmentsClientMode getClientModeByProductData(EntityReference<Organization> subagency, EntityReference<Organization> agency) {
        EntityContainer parentCont;
        EntityContainer orgCont;
        if (subagency != null && (orgCont = EntityStorage.get().resolve(subagency)) != null) {
            if (((Organization)orgCont.getEntity()).getCwtProfileData() != null && ((Organization)orgCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) {
                return SabrePassiveSegmentsClientMode.CWT;
            }
            if (((Organization)orgCont.getEntity()).getParent() != null && (parentCont = EntityStorage.get().resolve(((Organization)orgCont.getEntity()).getParent())) != null && ((Organization)parentCont.getEntity()).getCwtProfileData() != null && ((Organization)parentCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) {
                return SabrePassiveSegmentsClientMode.CWT;
            }
        }
        if (agency != null && (orgCont = EntityStorage.get().resolve(agency)) != null) {
            if (((Organization)orgCont.getEntity()).getCwtProfileData() != null && ((Organization)orgCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) {
                return SabrePassiveSegmentsClientMode.CWT;
            }
            if (((Organization)orgCont.getEntity()).getParent() != null && (parentCont = EntityStorage.get().resolve(((Organization)orgCont.getEntity()).getParent())) != null && ((Organization)parentCont.getEntity()).getCwtProfileData() != null && ((Organization)parentCont.getEntity()).getCwtProfileData().isUseCwtPassiveSegmentScheme()) {
                return SabrePassiveSegmentsClientMode.CWT;
            }
        }
        return SabrePassiveSegmentsClientMode.REGULAR;
    }

    public static String convertGDS2String(GdsName gds) {
        if (gds == null) {
            return "";
        }
        if (gds2str.containsKey(gds)) {
            return gds2str.get(gds);
        }
        return gds.name();
    }

    public static GdsName convertString2Gds(String gds) {
        GdsName res;
        if (TextUtil.isBlank((String)gds)) {
            return null;
        }
        if (str2gds.containsKey(gds)) {
            return str2gds.get(gds);
        }
        try {
            res = GdsName.valueOf((String)gds);
        }
        catch (IllegalArgumentException e) {
            res = null;
        }
        return res;
    }

    public static String removeIllegalSymbols(String str) {
        if (TextUtil.isBlank((String)str)) {
            return str;
        }
        return str.replaceAll(SABRE_ILLEGAL_SYMBOLS, "");
    }

    private static Person getPersonByTraveller(Traveller traveller) {
        EntityContainer personCtr;
        EntityReference personRef = traveller.getPassenger();
        Person person = null;
        if (personRef != null && (personCtr = EntityStorage.get().resolve(personRef)) != null) {
            person = (Person)personCtr.getEntity();
        }
        return person;
    }

    public static String replaceSlashInHotelName(String hotelName) {
        if (StringUtils.isBlank((String)hotelName) || !hotelName.contains("/")) {
            return hotelName;
        }
        String[] hotelNameParts = hotelName.split("/");
        if (digitsWhitespace.matcher(hotelNameParts[1]).matches()) {
            return hotelName.replace("/", "-");
        }
        return hotelName.replace("/", " ");
    }

    public static List<CostCode> getCostCodes(StatisticalData data) {
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<CostCode> result = new ArrayList<CostCode>();
        data.getTravellerCostCodes().forEach(tcc -> result.addAll(tcc.getCostCodes()));
        return result;
    }

    public static String getDotXStarRemarkUDIDText(CostCode costCode) {
        StringBuilder builder = new StringBuilder("X*");
        builder.append("U");
        builder.append(String.format("%02d", costCode.getCostCodeProperties().getType().ordinal() + 1));
        builder.append("*");
        String costCodeName = costCode.getCostCodeProperties().getName();
        if (costCodeName.length() < 15) {
            costCodeName = StringUtils.rightPad((String)costCodeName, (int)15, (char)'.');
            builder.append(costCodeName);
        } else {
            if (costCodeName.length() > 15) {
                costCodeName = costCodeName.substring(0, 15);
            }
            builder.append(costCodeName);
            builder.append("*");
        }
        builder.append(costCode.getValue());
        return builder.toString();
    }

    public static String getDotRemarkUDIDText(CostCode costCode) {
        StringBuilder builder = new StringBuilder();
        builder.append("U");
        builder.append(String.valueOf(costCode.getCostCodeProperties().getType().ordinal() + 1));
        builder.append("-");
        builder.append(costCode.getValue());
        return builder.toString();
    }

    public static interface SabreAviaParametersProvider {
        public static final Collection<String> NO_INF_GENDER_SUFFIX_AIRLINES = Collections.unmodifiableCollection(Arrays.asList("AZ", "KL", "OK", "A3", "UA"));

        public boolean isNoInfGenderSuffix();

        public boolean isTchBlankOwner();

        public int getAgeInYears();

        public int getAgeInMonths();

        public boolean isSubsidizedTariff();

        public boolean isSuCarrier();
    }
}

