/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.handlers.standard.AirProductFinanceHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.localization.routeLine.AviaLocalizer;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirProductHandler
implements ProductHandler<Product> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, Product product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return result;
        }
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
            }
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) == ContractType.VENDOR) {
                if (product.getTotalVendorEquivalentVatAmount() == null) {
                    result.setTotalVatAmount(totalPrice, BigDecimal.ZERO);
                    return result;
                }
                result.setTotalVatAmount(totalPrice, product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? product.getTotalVendorEquivalentVatAmount().negate() : product.getTotalVendorEquivalentVatAmount());
                return result;
            }
            if (product.getTotalVendorEquivalentVatAmount() == null) {
                result.setTotalVat(totalPrice, AirProductHelper.isHasVat(product) ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue() : 0.0);
                return result;
            }
            result.setTotalVatAmount(totalPrice, totalPrice.compareTo(BigDecimal.ZERO) > 0 ? product.getTotalVendorEquivalentVatAmount() : product.getTotalVendorEquivalentVatAmount().negate());
            return result;
        }
        BigDecimal price = AirProductHelper.getEquivalentFare(product);
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        price = price.add(AirProductTaxHelper.getEquivalentTaxesAmount(product));
        if (product.getPenalty() != null) {
            BigDecimal penalty = product.getPenalty();
            if ((status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) && penalty != null && penalty.doubleValue() != 0.0) {
                Product penaltyMco = null;
                for (Product prod : AirProductHelper.getMcoByRelatedProduct(product)) {
                    if (prod.getMcoCategory() != MCOCategory.PENALTY && prod.getMcoCategory() != MCOCategory.REBOOKING) continue;
                    penaltyMco = prod;
                    break;
                }
                if (penaltyMco == null) {
                    price = price.subtract(penalty);
                }
            } else if (status == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && penalty != null && penalty.doubleValue() > 0.0) {
                price = price.add(penalty);
            } else if (product.getMcoCategory() == MCOCategory.REBOOKING || product.getMcoCategory() == MCOCategory.STICKER) {
                price = price.add(penalty);
            }
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            price = price.negate();
        }
        if (product.getTotalVendorEquivalentVatAmount() == null) {
            result.setTotalVat(price, AirProductHelper.isHasVat(product) ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate())).doubleValue() : 0.0);
            return result;
        }
        result.setTotalVatAmount(price, price.compareTo(BigDecimal.ZERO) > 0 ? product.getTotalVendorEquivalentVatAmount() : product.getTotalVendorEquivalentVatAmount().negate());
        return result;
    }

    @Override
    public VatAmount calculateProductPrice(Product product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(Product product) {
        StringBuilder sb = new StringBuilder();
        sb.append(DictHelper.getProductCategoryShortName(product.getProductCategory()));
        MCOCategory mcoCategory = product.getMcoCategory();
        if (mcoCategory != null) {
            sb.append(" ").append(mcoCategory);
        }
        if (!TextUtil.isBlank((String)AirProductHelper.getTicketNumber(product))) {
            sb.append(" ").append(AirProductHelper.getTicketNumber(product));
        }
        if (product.getStatus() != null) {
            sb.append(" ").append(product.getStatus());
        }
        return sb.toString();
    }

    @Override
    public String generateProductName(Product product) {
        StringBuilder sb = new StringBuilder();
        sb.append(product.getProductCategory());
        MCOCategory mcoCategory = product.getMcoCategory();
        if (mcoCategory != null) {
            sb.append(" ").append(mcoCategory);
        }
        sb.append(" ").append(product.getStatus());
        String ticketNumber = AirProductHelper.getTicketNumber(product);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            sb.append(' ').append(ticketNumber);
        }
        sb.append(" ").append(AirProductHelper.getLocalizedRouteLine(product));
        Traveller traveller = product.getTraveller();
        if (traveller != null) {
            sb.append(" ").append(traveller.getName());
        }
        return sb.toString();
    }

    @Override
    public Date findFirstTravelDate(Product product) {
        return AirProductHelper.getFirstDepartureDate(product);
    }

    @Override
    public Date findLastTravelDate(Product product) {
        return AirProductHelper.getLastArriveDate(product);
    }

    @Override
    public List<String> getProductNumbers(Product product) {
        ArrayList<String> result = new ArrayList<String>();
        String systemNumber = product.getSystemNumber();
        if (!TextUtil.isBlank((String)systemNumber)) {
            result.add(systemNumber);
            for (int n = 1; n <= product.getConjCount(); ++n) {
                try {
                    result.add(FormattedNumberUtil.add((String)systemNumber, (long)n));
                    continue;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("failed generating conjunction ticket number", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(Product product) {
        return product.getCashier();
    }

    @Override
    public String findIssuingAgentCode(Product product) {
        return product.getCashierCode();
    }

    @Override
    public TravelSubject findTravelSubject(Product product) {
        return TravelSubject.AIR;
    }

    @Override
    public Date findIssueDate(Product product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(Product product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(Product product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(Product product) {
        return AirProductFinanceHelper.includeInFinanceDocuments(product);
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<Product> prods = new HashSet<Product>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof Product)) continue;
            prods.add((Product)bp);
        }
        return AirProductFinanceHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<com.gridnine.xtrip.common.model.booking.BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<Product> prods = new ArrayList<Product>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof Product)) continue;
            prods.add((Product)bp);
        }
        return AirProductFinanceHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(Product product, String relatedInvoiceNumber) {
        return AirProductFinanceHelper.getCommonPart(product, relatedInvoiceNumber);
    }

    @Override
    public Collection<Traveller> getTravellers(Product product) {
        return product.getTraveller() == null ? new ArrayList() : Collections.singletonList(product.getTraveller());
    }

    @Override
    public String getRfic(Product product) {
        return product.getRfic();
    }

    @Override
    public String getRfisc(Product product) {
        return product.getRfisc();
    }

    @Override
    public void replaceTraveller(Product product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller.equals((Object)product.getTraveller())) {
            product.setTraveller(newTraveller);
        }
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(Product product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.setTraveller(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void setOrReplaceTraveller(Product product, Traveller newTraveller) {
        this.setOrReplaceTraveller(product, product.getTraveller(), newTraveller);
    }

    @Override
    public void updateBillingItems(Collection<com.gridnine.xtrip.common.model.booking.BillingItem> items, List<Product> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(Product product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(Product product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(Product product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(Product product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(Product product) {
        return AirProductHelper.getProductType(product);
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.AIR_TICKET, ProductType.EXCESS_BAGAGE, ProductType.MCO_ADDITIONAL_SERVICES, ProductType.MCO_ADDITIONAL_TARIFF, ProductType.MCO_ADDITIONAL_TAX, ProductType.MCO_STANDART_PLUS, ProductType.MCO_COMFORT, ProductType.MCO_COMFORT_PLUS, ProductType.MCO_DUPLICATE_TICKET, ProductType.MCO_EXCESS_LUGGAGE, ProductType.MCO_GROUP_PENALTY, ProductType.MCO_RESIDUAL_VALUE_FOR_REFUND, ProductType.MCO_GROUP_PREPAYMENT, ProductType.MCO_PENALTY, ProductType.MCO_PTA, ProductType.MCO_REBOOKING, ProductType.MCO_RETURN_FARE_DIFFERENCE, ProductType.MCO_RETURN_TICKET, ProductType.MCO_SEAT_RESERVATION, ProductType.MCO_UNESCORTED_MINOR, ProductType.MCO_POSTAGE_FEE, ProductType.MCO_INFORMATION, ProductType.MCO_PAPER_SURCHARGE, ProductType.MCO_SPECIAL_FOOD, ProductType.MCO_STICKER, ProductType.MCO_NOT_SOLD_SEATS, ProductType.MCO_ANIMALS, ProductType.MCO_WEAPON, ProductType.MCO_VOUCHER, ProductType.MCO_NAME_CHANGE, ProductType.MCO_VIP_LOUNGE, ProductType.MCO_BUSINESS_LOUNGE, ProductType.MCO_BUS_TICKET).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.PRODUCT_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(Product product) {
        return product.getBlankOwnerRef();
    }

    @Override
    public EntityReference<Branch> getBranch(Product product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(Product product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = AirProductHelper.calculateTotalEquivalentFare(product);
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            source.setIsTotalSum(true);
            res.add(source);
        }
        for (Commission comm : AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    @Override
    public boolean isCompleted(Product product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(Product product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(Product product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(Product product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(Product product) {
        return AirProductHelper.getTransportationType(product);
    }

    @Override
    public ServiceLocationType getServiceLocationType(Product product) {
        return product.getServiceLocationType() != null ? product.getServiceLocationType() : AirProductHelper.getServiceLocationType(product);
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, Product product) {
        for (SegmentTariff tariff : product.getSegmentTariffs()) {
            for (Segment seg : tariff.getSegments()) {
                if (momentOfTime.compareTo(seg.getStartDate()) > 0) continue;
                return seg.getStartDate();
            }
        }
        return null;
    }

    private List<GeneralProductFop> getGeneralFops(Product product, ContractType vendor) {
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) != vendor) continue;
            for (ProductFop fop : item.getFops()) {
                result.add(AirProductHelper.toGeneralProductFop(fop));
            }
        }
        return result;
    }

    @Override
    public Product getPreviousProduct(Product product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(Product product, Product previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(Product product, Product nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public Product getNextProduct(Product product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(Product product, BaseProduct relatedProduct) {
        product.getRelatedProducts().add((Product)relatedProduct);
    }

    @Override
    public List<BaseProduct> getRelatedProducts(Product product) {
        return new ArrayList<BaseProduct>(product.getRelatedProducts());
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(Product product) {
        return product.getCancellationDetails();
    }

    @Override
    public ProductCategory getProductCategory(Product product) {
        return product.getProductCategory();
    }

    @Override
    public MCOCategory getMCOCategory(Product product) {
        return product.getMcoCategory();
    }

    @Override
    public List<GeneralProductTax> getTaxes(Product product) {
        ArrayList<GeneralProductTax> taxes = new ArrayList<GeneralProductTax>();
        for (Tax tax : product.getTaxes()) {
            taxes.add(AirProductHelper.toGeneralProductTax(tax));
        }
        return taxes;
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(Product product) {
        return product.getBlankType();
    }

    @Override
    public BigDecimal getEquivalentFare(Product product) {
        return AirProductHelper.getEquivalentFare(product);
    }

    @Override
    public BigDecimal getServiceFare(Product product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(Product product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(Product product) {
        return product.getConjCount();
    }

    @Override
    public String getRouteLine(Product product) {
        return AirProductHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(Product product) {
        return AirProductHelper.getLocalizedRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(Product product) {
        if (product == null) {
            return null;
        }
        ArrayList route = new ArrayList();
        MiscUtil.Value last = new MiscUtil.Value();
        product.getSegmentTariffs().stream().filter(Objects::nonNull).map(SegmentTariff::getSegments).flatMap(Collection::stream).filter(Objects::nonNull).forEach(segment -> {
            GeoLocationReference departure = AirProductHelper.getGeoLocationReference((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), segment.getDepartCityCode());
            GeoLocationReference arrive = AirProductHelper.getGeoLocationReference((DictionaryReference<GeoLocation>)segment.getArriveLocation(), segment.getArriveCityCode());
            if (CollectionUtil.isEmpty((Collection)route)) {
                route.add(departure);
                last.setValue((Object)departure);
            }
            if (!TextUtil.isSame((String)((GeoLocationReference)last.getValue()).getCode(), (String)departure.getCode())) {
                ((GeoLocationReference)last.getValue()).setCode(String.format("%s%s%s", ((GeoLocationReference)last.getValue()).getCode(), "~", departure.getCode()));
            }
            route.add(arrive);
            last.setValue((Object)arrive);
        });
        return AviaLocalizer.get().encode(route);
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(Product product) {
        ArrayList<GeneralProductContractRelationData> result = new ArrayList<GeneralProductContractRelationData>();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(product)) {
            GeneralProductContractRelationData generalData = new GeneralProductContractRelationData();
            generalData.setUid(item.getUid());
            generalData.setDescription(item.getDescription());
            try {
                XCloneModelHelper.copy((BaseEntity)item.getServiceData(), (BaseEntity)generalData.getServiceData());
                XCloneModelHelper.copy((BaseEntity)item.getGeneralData(), (BaseEntity)generalData.getGeneralData());
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
            for (Commission comm : item.getCommissions()) {
                generalData.getCommissions().add(AirProductHelper.toGeneralProductCommission(comm));
            }
            for (ProductFop fop : item.getFops()) {
                generalData.getFops().add(AirProductHelper.toGeneralProductFop(fop));
            }
            result.add(generalData);
        }
        return result;
    }

    @Override
    public SalesChain getSalesChain(Product product) {
        return AirProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(Product product, List<GeneralProductContractRelationData> relations) {
        ArrayList<AirProductContractRelationData> result = new ArrayList<AirProductContractRelationData>();
        List<AirProductContractRelationData> originalRelations = AirProductHelper.getContractRelations(product);
        boolean updateRelations = originalRelations.size() != relations.size();
        for (GeneralProductContractRelationData generalProductRelation : relations) {
            AirProductContractRelationData relation = (AirProductContractRelationData)CollectionUtil.find(originalRelations, (String)generalProductRelation.getUid());
            if (relation == null) {
                relation = new AirProductContractRelationData();
                relation.setUid(generalProductRelation.getUid());
                relation.setDescription(generalProductRelation.getDescription());
                updateRelations = true;
            }
            try {
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getGeneralData(), (BaseEntity)relation.getGeneralData());
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getServiceData(), (BaseEntity)relation.getServiceData());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"unable to xcopy object", (Throwable)e, (Object[])new Object[0]);
            }
            result.add(relation);
            ArrayList<Commission> commissions = new ArrayList<Commission>();
            boolean updateCommissions = generalProductRelation.getCommissions().size() != relation.getCommissions().size();
            for (GeneralProductCommission generalProductCommission : generalProductRelation.getCommissions()) {
                Commission commission = (Commission)CollectionUtil.find((Iterable)relation.getCommissions(), (String)generalProductCommission.getUid());
                if (commission == null) {
                    commission = new Commission();
                    commission.setUid(generalProductCommission.getUid());
                    updateCommissions = true;
                }
                commissions.add(commission);
                commission.setContractType(generalProductCommission.getContractType());
                commission.setRate(generalProductCommission.getRate());
                commission.setAmount(generalProductCommission.getAmount());
                commission.setEquivalentAmount(generalProductCommission.getEquivalentAmount());
                commission.setContractEquivalentAmount(generalProductCommission.getContractEquivalentAmount());
                commission.setCommissionProperties(generalProductCommission.getCommissionProperties());
            }
            if (updateCommissions) {
                relation.getCommissions().clear();
                relation.getCommissions().addAll(commissions);
            }
            ArrayList<ProductFop> fops = new ArrayList<ProductFop>();
            boolean updateFops = generalProductRelation.getFops().size() != relation.getFops().size();
            for (GeneralProductFop generalProductFop : generalProductRelation.getFops()) {
                ProductFop fop = (ProductFop)CollectionUtil.find((Iterable)relation.getFops(), (String)generalProductFop.getUid());
                if (fop == null) {
                    fop = new ProductFop();
                    fop.setUid(generalProductFop.getUid());
                    updateFops = true;
                }
                fops.add(fop);
                fop.setType(generalProductFop.getType());
                fop.setCard(generalProductFop.getCard());
                fop.setRelatedTicketNumber(generalProductFop.getRelatedTicketNumber());
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(DictHelper.getLocalCurrency());
                    fop.setAmount(money);
                }
                fop.getAmount().setValue(generalProductFop.getEquivalentAmount());
                fop.getAmount().setCurrency(generalProductRelation.getGeneralData().getCurrency() != null ? generalProductRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency());
                fop.setOperationDate(generalProductFop.getOperationDate());
                fop.setAgent(generalProductFop.getAgent());
                fop.setRefused(generalProductFop.isRefused());
                fop.setPayer(generalProductFop.getPayer());
                fop.getCommissions().clear();
                for (GeneralProductCommission generalProductCommission : generalProductFop.getCommissions()) {
                    Commission commission = (Commission)BookingHelper.findEntityByUid(commissions, generalProductCommission.getUid());
                    if (commission == null) continue;
                    fop.getCommissions().add(commission);
                }
            }
            if (!updateFops) continue;
            relation.getFops().clear();
            relation.getFops().addAll(fops);
        }
        if (updateRelations) {
            originalRelations.clear();
            originalRelations.addAll(result);
        }
    }

    @Override
    public TicketType getTicketType(Product product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(Product product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(Product product) {
        return product.getPcc();
    }

    @Override
    public void updateProductFops(Product product) {
        AirProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(Product product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(Product product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(Product product) {
        return product.getProvider();
    }

    @Override
    public PassengerStatus getPassengerStatus(Product product) {
        for (ProductFop fop : AirProductHelper.getClientFops(product)) {
            if (fop.getType() != PaymentType.MTD || fop.getPassengerStatus() == null) continue;
            return fop.getPassengerStatus();
        }
        return null;
    }

    @Override
    public boolean isHoldable(Product product) {
        return false;
    }

    @Override
    public Date getUnholdDate(Product product) {
        return null;
    }

    @Override
    public String getValidatorNumber(Product product) {
        return product.getValidatorCode();
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(Product product) {
        return product.getPassengerType();
    }

    @Override
    public StatisticalData getStatisticalData(Product product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(Product product) {
        return true;
    }

    @Override
    public void newStatisticalData(Product product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(Product product) {
        return product.getAddCollectEquivalent();
    }

    @Override
    public String getGdsCurrency(Product product) {
        return product.getGdsCurrency();
    }

    @Override
    public Money getProductBaseFare(Product product) {
        return AirProductHelper.getBaseFare(product);
    }

    @Override
    public VatDetalization getVendorVatDetalization(Product product) {
        return product.getVendorVatDetalization();
    }

    @Override
    public BigDecimal getObFees(Product product) {
        return AirProductHelper.getObFeesValue(product);
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.AIR;
    }

    @Override
    public Product newInstance() {
        return new Product();
    }

    @Override
    public String getCarrierNumber(Product product) {
        return product.getCarrierNumber();
    }

    @Override
    public Supplier getFiscalSupplier(Product product) {
        Airline carrier = (Airline)DictHelper.resolve(product.getCarrier());
        if (carrier != null) {
            String carrierRegistrationId;
            String legalForm = null;
            LegalForm form = (LegalForm)DictHelper.resolve(carrier.getLegalForm());
            if (form != null) {
                legalForm = form.getAbbreviations().entrySet().stream().filter(entry -> LocaleHelper.RU_LOCALE.getLanguage().equals(((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).findFirst().orElse(null);
            }
            if (TextUtil.isBlank((String)(carrierRegistrationId = carrier.getRegistrationId()))) {
                carrierRegistrationId = carrier.getCountry() != null && MiscUtil.equals((Object)carrier.getCountry().getCode(), (Object)"RU") ? null : "0000000000";
            }
            String supplierName = carrier.getTranslations().entrySet().stream().filter(entry -> LocaleHelper.RU_LOCALE.getLanguage().equals(((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).findFirst().orElse((String)carrier.getTranslations().get(LocaleHelper.EN_LOCALE));
            String supplierFullName = legalForm != null ? legalForm + " " + supplierName : supplierName;
            Supplier supplier = new Supplier();
            supplier.setName(supplierFullName);
            supplier.setINN(carrierRegistrationId);
            supplier.setPhoneNum(carrier.getPhone());
            return supplier;
        }
        return null;
    }

    @Override
    public void setAgent(Product product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    @Override
    public void setComments(Product product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(Product product, EntityReference<Organization> agency) {
        AirProductHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(Product product, EntityReference<Organization> blankOwner) {
        product.setBlankOwnerRef(blankOwner);
    }

    @Override
    public void setBranch(Product product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(Product product, EntityReference<Organization> supplier) {
        AirProductHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(Product product, EntityReference<Organization> subagency) {
        AirProductHelper.setSubagency(product, subagency);
    }

    @Override
    public void setTechnicalProvider(Product product, EntityReference<Organization> technicalProvider) {
        AirProductHelper.setTechnicalProvider(product, technicalProvider);
    }

    @Override
    public void setSalesPoint(Product product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void setValidatorCode(Product product, String code) {
        product.setValidatorCode(code);
    }

    @Override
    public void changeFopsPaymentTypes(Product product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<ProductFop> fops = new ArrayList<ProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(AirProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(AirProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(AirProductHelper.getClientFops(product));
            }
        }
        AirProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(Product product, EntityReference<Person> agent, ContractType contractType) {
        List<ProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(Product product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<ProductFop> getFops(Product product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return AirProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return AirProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return AirProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(Product product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    @Override
    public Money getBspCommissionValue(Product product) {
        return product.getBspCommissionValue();
    }

    @Override
    public Double getBspCommissionRate(Product product) {
        return product.getBspCommissionRate();
    }

    @Override
    public boolean removeProduct(Product product) {
        return AirProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(Product product, BaseProduct relatedProduct) {
        return AirProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(Product product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, BillingItem billingItem, List<BillingItem> billingItems, List<BillingItem> prepaymentBillingItems) {
        if (type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) {
            if (Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
                return false;
            }
            if (billingItem.getServiceType() != ServiceType.FEE) {
                return false;
            }
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return billingItem.getServiceType() == ServiceType.TICKET || billingItem.getServiceType() == ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && mode == BillingItemIncludeMode.ALL_EXCEPT_TICKET) {
            return billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<BillingItem> remainingList = new ArrayList<BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public boolean isVatIncludeBillingItem(Product product, VatViewMode mode, BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    @Override
    public String getCities(Product product, Locale locale) {
        return AirProductHelper.getCities(product, locale);
    }

    @Override
    public String getCountries(Product product, Locale locale) {
        return AirProductHelper.getCountries(product, locale);
    }

    @Override
    public Date getFirstStartDate(Product product) {
        List dates = product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getStartDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    @Override
    public Date getLastStartDate(Product product) {
        List dates = product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getStartDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    @Override
    public Date getFirstEndDate(Product product) {
        List dates = product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getEndDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    @Override
    public Date getLastEndDate(Product product) {
        List dates = product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getEndDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    @Override
    public String getDescriptionLine(Product product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(Product product) {
        return product.getCarrier();
    }

    @Override
    public boolean isContractRulesApplied(Product product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(Product product) {
        return false;
    }

    @Override
    public String getTourCode(Product product) {
        return product.getTourCode();
    }

    @Override
    public boolean isDuplicate(Product product) {
        return product.isDuplicate();
    }

    @Override
    public boolean isTripartiteDiscount(Product product) {
        return AirProductHelper.isTripartiteDiscount(product);
    }

    @Override
    public Set<String> getServiceClasses(Product product, Locale locale) {
        return product.getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).map(Segment::getServiceClass).filter(Objects::nonNull).map(classOfService -> classOfService.toString(locale)).collect(Collectors.toSet());
    }
}

