/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveFOP;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassivePassengerData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveProductData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsClientMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSubagencyMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsXIData;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class AirProductPassiveSegmentsHandler
implements ProductPassiveSegmentsHandler<Product> {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("ddMMMyy", Locale.ENGLISH);

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public boolean isAcceptableForPassiveSegmentsCreation(Product product, List<Message> messages) {
        if (product == null) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyProduct, new Object[0]));
            return false;
        }
        if (product.getStatus() != ProductStatus.SELL) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationInvalidProductStatusDetails, product.getStatus().toString()));
            return false;
        }
        if (product.getReservation() == null) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyReservationDetails, product.getSystemNumber()));
            return false;
        }
        if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName(product.getReservation()) == GdsName.SABRE) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationSabreGdsDetails, product.getSystemNumber()));
            return false;
        }
        if (product.getProductCategory() != ProductCategory.AIR) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationInvalidProductCategoryDetails, product.getProductCategory(), product.getSystemNumber()));
            return false;
        }
        if (product.getNextProduct() != null) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationHasNextProductDetails, product.getSystemNumber()));
            return false;
        }
        if (product.getTraveller() == null) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyTravellersDetails, product.getSystemNumber()));
            return false;
        }
        List segments = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
        if (segments.isEmpty()) {
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptySegmentsDetails, product.getSystemNumber()));
            return false;
        }
        for (Segment seg : segments) {
            if (seg.getStartDate() == null) {
                messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyStartDateDetails, new Object[]{product.getSystemNumber(), seg.getRecordNumber()}));
                return false;
            }
            if (!seg.getStartDate().before(new Date())) continue;
            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationStartDateIsBeforeCurrentDateDetails, new Object[]{product.getSystemNumber(), seg.getRecordNumber()}));
            return false;
        }
        return true;
    }

    @Override
    public boolean validateProducts(List<Product> products, List<Message> incomingMessages) {
        if (this.getSeatsAmount(products) < 1L) {
            incomingMessages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsZeroPassengers, new Object[0]));
            return false;
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Product p : products) {
            for (SegmentTariff st : p.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    if (!"OPEN".equals(seg.getFlightNo())) {
                        if (seg.getStartDate() == null) {
                            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyStartDateDetails, new Object[]{p.getSystemNumber(), seg.getRecordNumber()}));
                        }
                        if (TextUtil.isBlank((String)seg.getFlightNo())) {
                            messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyFlightNoDetails, new Object[]{p.getSystemNumber(), seg.getRecordNumber()}));
                        }
                    }
                    if (seg.getDepartureLocation() == null) {
                        messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyDepartureLocationDetails, new Object[]{p.getSystemNumber(), seg.getRecordNumber()}));
                    }
                    if (seg.getArriveLocation() == null) {
                        messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyArriveLocationDetails, new Object[]{p.getSystemNumber(), seg.getRecordNumber()}));
                    }
                    if (TextUtil.isBlank((String)seg.getClassOfSvcCode())) {
                        messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyClassOfSvcCodeDetails, new Object[]{p.getSystemNumber(), seg.getRecordNumber()}));
                    }
                    if (seg.getAirline() != null) continue;
                    messages.add(MessageHelper.createErrorMessage(Messages.sabrePassiveSegmentsValidationEmptyAirlineDetails, new Object[]{p.getSystemNumber(), seg.getRecordNumber()}));
                }
            }
        }
        if (!messages.isEmpty()) {
            incomingMessages.addAll(messages);
            return false;
        }
        return true;
    }

    @Override
    public List<SabrePassivePassengerData> getTravellers(List<Product> products) {
        ArrayList<SabrePassivePassengerData> res = new ArrayList<SabrePassivePassengerData>();
        products.stream().filter(p -> p.getTraveller() != null).forEach(p -> {
            Traveller t = p.getTraveller();
            SabrePassivePassengerData trv = new SabrePassivePassengerData();
            trv.setUid(t.getUid());
            trv.setFirstName(SabrePassiveSegmentsUtil.buildGivenName(t, (DictionaryReference<PassengerType>)p.getPassengerType(), SabrePassiveSegmentsUtil.getAviaProvider(p)));
            trv.setLastName(SabrePassiveSegmentsUtil.buildSurname(t));
            trv.setInfant(Boolean.valueOf(DictHelper.isInfantPassengerType((DictionaryReference<PassengerType>)p.getPassengerType())).booleanValue());
            trv.setPassengerType(p.getPassengerType() == null ? null : DictHelper.getCodeVariant(p.getPassengerType(), CodeSystem.IATA));
            res.add(trv);
        });
        return res;
    }

    @Override
    public SabrePassiveProductData getSabrePassiveData(List<Product> originalProducts, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode, List<Message> messages, boolean throwException) {
        SabrePassiveProductData data = new SabrePassiveProductData();
        List<SegmentWrapper> segmentWrappers = this.groupProductsBySegments(originalProducts);
        Map<String, String> product2Num = this.assignProductNumbers(originalProducts);
        HashSet<String> usedProductsUids = new HashSet<String>();
        for (SegmentWrapper sw : segmentWrappers) {
            String result;
            String crsLocator;
            Segment s = sw.getSegment();
            List<Product> products = sw.getProducts();
            TranslitUtil.TranslitRules rules = TranslitUtil.TranslitRules.GOST_52535_1_2006;
            TranslitUtil.TranslitRules rulesClass = sw.getGdsName() == GdsName.SIRENA ? TranslitUtil.TranslitRules.SIRENA_SERVICE_CLASSES_RULES : TranslitUtil.TranslitRules.GOST_52535_1_2006;
            TranslitUtil.TranslitRules rulesRecloc = sw.getGdsName() == GdsName.SIRENA ? TranslitUtil.TranslitRules.SIRENA_REDAPP_RULES : TranslitUtil.TranslitRules.GOST_52535_1_2006;
            SabrePassiveSegmentData seg = new SabrePassiveSegmentData();
            seg.setSegmentType(SabrePassiveSegmentType.AIR);
            String iataArrivalLocationCode = DictHelper.getCodeVariant(s.getArriveLocation(), CodeSystem.IATA);
            if (iataArrivalLocationCode == null) {
                iataArrivalLocationCode = "AVH";
            }
            seg.setArrivalCode(iataArrivalLocationCode);
            String iataDepartureLocationCode = DictHelper.getCodeVariant(s.getDepartureLocation(), CodeSystem.IATA);
            if (iataDepartureLocationCode == null) {
                iataDepartureLocationCode = "DVH";
            }
            seg.setDepartureCode(iataDepartureLocationCode);
            seg.setStartDate(s.getStartDate());
            String seatsAmount = String.valueOf(this.getSeatsAmount(products));
            seg.setSeatsAmount(seatsAmount);
            seg.setId(s.getUid());
            seg.setClassOfService(SabrePassiveSegmentsUtil.getTranslation(s.getClassOfSvcCode(), rulesClass));
            seg.setCommandToCreate(this.getCreationCommand(s, seatsAmount, rules, rulesClass, rulesRecloc, subagencyMode));
            data.getSegments().add(seg);
            data.getRemarks().addAll(AirProductPassiveSegmentsHandler.createCrossSRemarks(products, s, sw.getSeats(), clientMode, rulesRecloc));
            String gdsName = SabrePassiveSegmentsUtil.convertGDS2String(sw.getGdsName());
            StringBuilder text = new StringBuilder();
            if (!TextUtil.isBlank((String)gdsName)) {
                text.append("SRC-").append(gdsName);
            }
            if (!TextUtil.isBlank((String)(crsLocator = SabrePassiveSegmentsUtil.getTranslation(sw.getGdsRecloc(), rulesRecloc)))) {
                if (text.length() > 0) {
                    text.append("/");
                }
                text.append("CRSPNR-").append(crsLocator);
            }
            if (!(result = text.toString()).isEmpty()) {
                data.getRemarks().addAll(SabrePassiveSegmentsUtil.prepareDotSRemark(s.getUid(), result));
            }
            for (Product product : products) {
                if (TextUtil.isBlank((String)this.getTicketNumber(product))) continue;
                data.getRemarks().addAll(this.createDotSRemarks(product, s, sw.getRecordNumber(product.getUid()), sw.getSeat(product.getUid()), sw.getBaggage(product.getUid())));
                data.getRemarks().addAll(this.createCrossRemarks(product, s, sw.getRecordNumber(product.getUid()), sw.getSeat(product.getUid()), sw.getBaggage(product.getUid())));
                data.getRemarks().addAll(this.createDotXStarSegmentRemarks(product, product2Num.get(product.getUid()), sw.getRecordNumber(product.getUid()), sw.getBaggage(product.getUid()), sw.getFareBasis(product.getUid())));
                if (!usedProductsUids.contains(product.getUid())) {
                    data.getRemarks().addAll(this.createDotXStarProductRemarks(product, product2Num.get(product.getUid()), clientMode, subagencyMode));
                    data.getRemarks().addAll(this.createDotProductRemarks(product, product2Num.get(product.getUid()), clientMode, subagencyMode));
                    usedProductsUids.add(product.getUid());
                }
                data.getAccountingLines().add(this.createAccountingLine(product));
            }
        }
        Product veryFirstProduct = originalProducts.get(0);
        if (veryFirstProduct.getReservation() != null && veryFirstProduct.getReservation().getBookingFile() != null && !TextUtil.isBlank((String)veryFirstProduct.getReservation().getBookingFile().getNumber())) {
            StringBuilder text = new StringBuilder("X*BR" + SabrePassiveSegmentsUtil.getTranslation(veryFirstProduct.getReservation().getBookingFile().getNumber()));
            data.getRemarks().add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text.toString()));
        }
        return data;
    }

    private SabrePassiveAccountingLineData createAccountingLine(Product product) {
        SabrePassiveAccountingLineData result = new SabrePassiveAccountingLineData();
        String firstName = SabrePassiveSegmentsUtil.buildGivenName(product.getTraveller(), (DictionaryReference<PassengerType>)product.getPassengerType(), SabrePassiveSegmentsUtil.getAviaProvider(product));
        String lastName = SabrePassiveSegmentsUtil.buildSurname(product.getTraveller());
        result.setTravelerFirstName(firstName);
        result.setTravelerLastName(lastName);
        result.setTicketNumber(product.getSystemNumber());
        result.setType(SabrePassiveAccountingLineType.AIR);
        String command = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && TextUtil.nonBlank((String)product.getPreviousProduct().getSystemNumber()) ? this.createExchangeLineCommand(product, firstName, lastName) : this.createAccountingLineCommand(product, firstName, lastName);
        result.setCreationCommand(command);
        return result;
    }

    private String createExchangeLineCommand(Product product, String firstName, String lastName) {
        return "ACA/" + this.getCarrierCode(product.getCarrierNumber()) + "/" + product.getSystemNumber() + "/0/" + this.getExchangedEquivFareSum(product) + "/" + this.getExchangedEquivTaxesSum(product) + "/" + "%s" + SabrePassiveAccountingType.ONE.name() + "/" + SabrePassiveFOP.CA.name() + " %s" + lastName + " " + firstName.substring(0, 1) + "/" + (product.getConjCount() + 1) + "/E0/" + (product.getServiceLocationType() == ServiceLocationType.DOMESTIC ? "D" : "F") + "/E-" + '\u00a4' + product.getPreviousProduct().getCarrierNumber() + product.getPreviousProduct().getSystemNumber() + "/A/" + DATE_FORMATTER.format(LocalDate.now()) + "MOW";
    }

    private String createAccountingLineCommand(Product product, String firstName, String lastName) {
        return "AC/" + this.getCarrierCode(product.getCarrierNumber()) + "/" + product.getSystemNumber() + "/0/" + this.getEquivFare(product) + "/" + this.getTaxesSum(product) + "/" + "%s" + SabrePassiveAccountingType.ONE.name() + "/" + SabrePassiveFOP.CA.name() + " %s" + lastName + " " + firstName.substring(0, 1) + "/" + (product.getConjCount() + 1) + "/" + (product.getServiceLocationType() == ServiceLocationType.DOMESTIC ? "D" : "F") + "/E";
    }

    private String getCarrierCode(String carrierNumber) {
        return Optional.ofNullable(carrierNumber).map(DictHelper::findAirlineByNumber).map(BaseDictionary::getCodeVariants).map(m -> (String)m.get(CodeSystem.IATA.name())).orElse("00");
    }

    private String getEquivFare(Product product) {
        return Optional.ofNullable(AirProductHelper.getEquivalentFare(product)).map(f -> SabrePassiveSegmentsUtil.formatDecimal(f, false)).orElse("0");
    }

    private String getExchangedEquivFareSum(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal currentProductFare = AirProductHelper.getEquivalentFare(product);
        BigDecimal exchProductFare = AirProductHelper.getEquivalentFare(product.getPreviousProduct());
        if (currentProductFare != null && exchProductFare != null && (result = currentProductFare.subtract(exchProductFare)).signum() == -1) {
            result = BigDecimal.ZERO;
        }
        return SabrePassiveSegmentsUtil.formatDecimal(result, false);
    }

    private String getExchangedEquivTaxesSum(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal currentProductTaxes = AirProductHelper.calculateTaxesEquivalentAmount(product);
        BigDecimal exchProductTaxes = AirProductHelper.calculateTaxesEquivalentAmount(product.getPreviousProduct());
        if (currentProductTaxes != null && exchProductTaxes != null && (result = currentProductTaxes.subtract(exchProductTaxes)).signum() == -1) {
            result = BigDecimal.ZERO;
        }
        return SabrePassiveSegmentsUtil.formatDecimal(result, false);
    }

    private String getTaxesSum(Product product) {
        return Optional.of(product).map(AirProductHelper::calculateTaxesEquivalentAmount).map(f -> SabrePassiveSegmentsUtil.formatDecimal(f, false)).orElse("0");
    }

    @Override
    public void setActualPassiveSegmentsXIDataToCurrentProduct(Product oldProd, Product prod) {
        SabrePassiveSegmentsResult res;
        if (oldProd == null || prod == null) {
            return;
        }
        Product oldProduct = oldProd;
        while (oldProduct.getPreviousProduct() != null) {
            oldProduct = oldProduct.getPreviousProduct();
        }
        SabrePassiveSegmentsResult result = oldProduct.getPassiveSegmentsCreationResult();
        String pnr = null;
        Date responseDate = null;
        if (result != null && result.getPassiveSegmentsXIData() != null && !TextUtil.isBlank((String)result.getPassiveSegmentsXIData().getPnr())) {
            pnr = result.getPassiveSegmentsXIData().getPnr();
            responseDate = result.getPassiveSegmentsXIData().getResponseDate();
        }
        while (oldProduct.getNextProduct() != null) {
            res = (oldProduct = oldProduct.getNextProduct()).getPassiveSegmentsCreationResult();
            if (res == null || res.getPassiveSegmentsXIData() == null || TextUtil.isBlank((String)res.getPassiveSegmentsXIData().getPnr())) continue;
            SabrePassiveSegmentsXIData data = res.getPassiveSegmentsXIData();
            if (!TextUtil.isBlank((String)pnr) && !data.getResponseDate().after(responseDate)) continue;
            pnr = data.getPnr();
            responseDate = data.getResponseDate();
        }
        if (!TextUtil.isBlank(pnr)) {
            SabrePassiveSegmentsXIData data;
            if (prod.getPassiveSegmentsCreationResult() == null) {
                res = new SabrePassiveSegmentsResult();
                prod.setPassiveSegmentsCreationResult(res);
            }
            if (prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData() == null) {
                data = new SabrePassiveSegmentsXIData();
                prod.getPassiveSegmentsCreationResult().setPassiveSegmentsXIData(data);
            }
            if (TextUtil.isBlank((String)prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().getPnr()) || responseDate.after(prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().getResponseDate())) {
                data = prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData();
                data.setPnr(pnr);
                data.setResponseDate(responseDate);
            }
        }
    }

    @Override
    public boolean isRestoreFromRefundOrExchange(Product oldProd) {
        Product oldProduct = oldProd;
        while (oldProduct.getPreviousProduct() != null) {
            if ((oldProduct = oldProduct.getPreviousProduct()).getStatus() != ProductStatus.EXCHANGE && oldProduct.getStatus() != ProductStatus.REFUND) continue;
            return true;
        }
        while (oldProduct.getNextProduct() != null) {
            if ((oldProduct = oldProduct.getNextProduct()).getStatus() != ProductStatus.EXCHANGE && oldProduct.getStatus() != ProductStatus.REFUND) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptableForPassiveSegmentsSynchronization() {
        return true;
    }

    private Map<String, String> assignProductNumbers(List<Product> originalProducts) {
        HashMap<String, String> res = new HashMap<String, String>();
        int i = 1;
        for (Product p : originalProducts) {
            res.put(p.getUid(), String.valueOf(i));
            ++i;
        }
        return res;
    }

    private List<SegmentWrapper> groupProductsBySegments(List<Product> products) {
        ArrayList<SegmentWrapper> res = new ArrayList<SegmentWrapper>();
        for (Product product : products) {
            GdsName gdsName = null;
            String gdsRecloc = null;
            if (product.getReservation() != null) {
                gdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName(product.getReservation());
                gdsRecloc = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(product.getReservation());
            }
            for (Segment segment : product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList())) {
                SegmentWrapper segWrapper = new SegmentWrapper(segment, gdsName, gdsRecloc);
                if (!res.contains(segWrapper)) {
                    res.add(segWrapper);
                } else {
                    segWrapper = (SegmentWrapper)res.get(res.indexOf(segWrapper));
                }
                String baggage = "";
                if (segment.getLuggageInfo() != null && segment.getLuggageInfo().getQuantity() != null) {
                    LuggageUnit lu;
                    baggage = baggage + segment.getLuggageInfo().getQuantity();
                    if (segment.getLuggageInfo().getUnit() != null && (lu = (LuggageUnit)DictionaryCache.get().resolveReference(segment.getLuggageInfo().getUnit())) != null) {
                        baggage = baggage + SabrePassiveSegmentsUtil.getTranslation((String)lu.getTranslations().get(LocaleUtil.LOCALE_EN));
                    }
                }
                segWrapper.addProduct(product, String.valueOf(segment.getRecordNumber()), segment.getSeatNo(), baggage, segment.getFareBasis());
            }
        }
        return res;
    }

    private long getSeatsAmount(List<Product> products) {
        return products.stream().filter(p -> !DictHelper.isInfantPassengerType((DictionaryReference<PassengerType>)p.getPassengerType())).count();
    }

    @Override
    public SabrePassiveSegmentsClientMode getClientMode(Product product) {
        return SabrePassiveSegmentsUtil.getClientModeByProductData(AirProductHelper.getSubagency(product), AirProductHelper.getAgency(product));
    }

    private static List<SabrePassiveRemarkData> createCrossSRemarks(List<Product> products, Segment s, Collection<String> seats, SabrePassiveSegmentsClientMode clientMode, TranslitUtil.TranslitRules rulesRecloc) {
        StringBuilder text;
        String locatorWithDelimiters;
        Iterator<Product> locator;
        String airlineName;
        StringBuilder text2;
        Airline airline;
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        if (!(s.getAirline() == null || (airline = (Airline)DictionaryCache.get().resolveReference(s.getAirline())) == null || TextUtil.isBlank((String)airline.getAirlineNumber()) && TextUtil.isBlank((String)SabrePassiveSegmentsUtil.getTranslation((BaseDictionary)airline)))) {
            text2 = new StringBuilder();
            text2.append("AIRLINE-");
            if (!TextUtil.isBlank((String)airline.getAirlineNumber())) {
                text2.append(SabrePassiveSegmentsUtil.getTranslation(airline.getAirlineNumber()) + " ");
            }
            if (!TextUtil.isBlank((String)(airlineName = SabrePassiveSegmentsUtil.getTranslation((BaseDictionary)airline)))) {
                text2.append(airlineName);
            }
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text2.toString()));
        }
        StringBuilder text3 = new StringBuilder("DEPARTURE-");
        if (s.getDepartureLocation() != null) {
            text3.append(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference<? extends BaseDictionary>)s.getDepartureLocation()));
        }
        if (!TextUtil.isBlank((String)s.getDepartTerminal())) {
            text3.append("/TERMINAL-" + SabrePassiveSegmentsUtil.getTranslation(s.getDepartTerminal()));
        }
        res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text3.toString()));
        text3 = new StringBuilder("ARRIVAL-");
        if (s.getArriveLocation() != null) {
            text3.append(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference<? extends BaseDictionary>)s.getArriveLocation()));
        }
        if (!TextUtil.isBlank((String)s.getArriveTerminal())) {
            text3.append("/TERMINAL-" + SabrePassiveSegmentsUtil.getTranslation(s.getArriveTerminal()));
        }
        res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text3.toString()));
        if (s.getBoard() != null) {
            text3 = new StringBuilder("EQUIPMENT-");
            text3.append(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference<? extends BaseDictionary>)s.getBoard()));
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text3.toString()));
        }
        if (!TextUtil.isBlank((String)s.getAirlineLocator()) && ((String)((Object)(locator = SabrePassiveSegmentsUtil.getTranslation(s.getAirlineLocator(), rulesRecloc)))).length() > 6 && !TextUtil.isBlank((String)(locatorWithDelimiters = TranslitUtil.cyr2latWithDelimiter((String)s.getAirlineLocator(), (TranslitUtil.TranslitRules)rulesRecloc, (char)' ')))) {
            text = new StringBuilder("RECLOC-");
            text.append(locatorWithDelimiters);
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text.toString()));
        }
        if (clientMode == SabrePassiveSegmentsClientMode.CWT) {
            String locatorWithDelimiters2;
            for (String seat : seats) {
                text = new StringBuilder("SEN-");
                text.append(seat);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text.toString()));
            }
            for (Product p : products) {
                if (!TextUtil.isBlank((String)p.getSystemNumber())) {
                    text = new StringBuilder("TK-");
                    text.append(SabrePassiveSegmentsUtil.getTranslation(p.getSystemNumber()));
                    res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text.toString()));
                }
                text = new StringBuilder("TTL-");
                BigDecimal total = AirProductHelper.getTotalEquivalentFare(p);
                String curr = DictHelper.getEquivCurrency();
                if (total != null) {
                    if (curr != null && "RUB".equals(curr)) {
                        text.append(SabrePassiveSegmentsUtil.formatDecimal(total, false));
                    } else {
                        text.append(SabrePassiveSegmentsUtil.formatDecimal(total, true));
                    }
                }
                if (curr != null) {
                    text.append(curr);
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text.toString()));
            }
            if (!TextUtil.isBlank((String)s.getAirlineLocator()) && !TextUtil.isBlank((String)(locatorWithDelimiters2 = TranslitUtil.cyr2latWithDelimiter((String)s.getAirlineLocator(), (TranslitUtil.TranslitRules)rulesRecloc, (char)' ')))) {
                text2 = new StringBuilder("CF-");
                text2.append(locatorWithDelimiters2.replaceAll(" ", ""));
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text2.toString()));
            }
            if (s.getAirline() != null) {
                String prefix = "SUN-";
                text2 = new StringBuilder();
                airlineName = SabrePassiveSegmentsUtil.getTranslation((DictionaryReference<? extends BaseDictionary>)s.getAirline());
                if (!TextUtil.isBlank((String)airlineName)) {
                    text2.append(airlineName);
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), prefix, text2.toString()));
            }
            if (s.getServiceClass() != null) {
                text3 = new StringBuilder("CL-");
                text3.append(s.getServiceClass().name().replaceAll("_", " "));
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark(s.getUid(), text3.toString()));
            }
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotSRemarks(Product product, Segment s, String recordNumber, String seat, String baggage) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        String ticketNumber = this.getTicketNumber(product, recordNumber);
        String prefix = "TICKET-" + ticketNumber + "/";
        CharSequence text = this.getPassengerName(product);
        res.addAll(SabrePassiveSegmentsUtil.prepareDotSRemark(s.getUid(), prefix, ((String)text).toString()));
        prefix = "TICKET-" + ticketNumber;
        text = new StringBuilder();
        boolean seatOrBaggage = false;
        if (!TextUtil.isBlank((String)seat)) {
            ((StringBuilder)text).append("/SEAT-");
            ((StringBuilder)text).append(SabrePassiveSegmentsUtil.getTranslation(seat));
            seatOrBaggage = true;
        }
        if (!TextUtil.isBlank((String)baggage)) {
            ((StringBuilder)text).append("/BAGGAGE-");
            ((StringBuilder)text).append(baggage);
            seatOrBaggage = true;
        }
        if (seatOrBaggage) {
            res.addAll(SabrePassiveSegmentsUtil.prepareDotSRemark(s.getUid(), prefix, ((StringBuilder)text).toString()));
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createCrossRemarks(Product product, Segment s, String recordNumber, String seat, String baggage) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        String ticketNumber = this.getTicketNumber(product, recordNumber);
        StringBuilder text = new StringBuilder("TICKET-");
        text.append(ticketNumber);
        text.append("/" + this.getPassengerName(product));
        res.add(SabrePassiveSegmentsUtil.prepareCrossRemark(text.toString()));
        text = new StringBuilder("TICKET-");
        text.append(ticketNumber);
        boolean seatOrBaggage = false;
        if (!TextUtil.isBlank((String)seat)) {
            text.append("/SEAT-");
            text.append(SabrePassiveSegmentsUtil.getTranslation(seat));
            seatOrBaggage = true;
        }
        if (!TextUtil.isBlank((String)baggage)) {
            text.append("/BAGGAGE-");
            text.append(baggage);
            seatOrBaggage = true;
        }
        if (seatOrBaggage) {
            res.add(SabrePassiveSegmentsUtil.prepareCrossRemark(text.toString()));
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotXStarSegmentRemarks(Product product, String productNum, String recordNumber, String baggage, String fareBasis) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        String ticketNumber = this.getTicketNumber(product, recordNumber);
        if (!TextUtil.isBlank((String)fareBasis) || !TextUtil.isBlank((String)baggage)) {
            StringBuilder text = new StringBuilder("X*PA" + productNum + "*");
            text.append(ticketNumber);
            if (!TextUtil.isBlank((String)fareBasis)) {
                text.append("*FAREBASIS " + fareBasis);
            }
            if (!TextUtil.isBlank((String)baggage)) {
                text.append("*BA ");
                text.append(baggage);
            }
            res.add(SabrePassiveSegmentsUtil.prepareDotXStarSegmentRemark(text.toString()));
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotXStarProductRemarks(Product product, String productNum, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        StringBuilder text = new StringBuilder("X*PA" + productNum + "*");
        text.append(this.getTicketNumber(product));
        text.append("*PAX*");
        text.append(this.getPassengerName(product));
        res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text.toString()));
        text = new StringBuilder("X*PA" + productNum + "*");
        text.append(this.getTicketNumber(product));
        text.append("*TOTAL ");
        BigDecimal total = AirProductHelper.getTotalEquivalentFare(product);
        String curr = DictHelper.getEquivCurrency();
        if (curr != null) {
            text.append(curr);
        }
        if (total != null) {
            if (curr != null && "RUB".equals(curr)) {
                text.append(SabrePassiveSegmentsUtil.formatDecimal(total, false));
            } else {
                text.append(SabrePassiveSegmentsUtil.formatDecimal(total, true));
            }
        }
        res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text.toString()));
        text = new StringBuilder("X*PA" + productNum + "*");
        text.append(this.getTicketNumber(product));
        text.append("*FARE ");
        Money baseFare = AirProductHelper.getBaseFare(product);
        if (baseFare != null && baseFare.getCurrency() != null) {
            text.append(baseFare.getCurrency());
        }
        if (baseFare != null && baseFare.getValue() != null) {
            if (baseFare.getCurrency() != null && "RUB".equals(baseFare.getCurrency())) {
                text.append(SabrePassiveSegmentsUtil.formatDecimal(baseFare.getValue(), false));
            } else {
                text.append(SabrePassiveSegmentsUtil.formatDecimal(baseFare.getValue(), true));
            }
        }
        text.append("*EQUIV ");
        BigDecimal eqFare = AirProductHelper.getEquivalentFare(product);
        String curr2 = DictHelper.getEquivCurrency();
        if (curr2 != null) {
            text.append(curr2);
        }
        if (eqFare != null) {
            if (curr2 != null && "RUB".equals(curr2)) {
                text.append(SabrePassiveSegmentsUtil.formatDecimal(eqFare, false));
            } else {
                text.append(SabrePassiveSegmentsUtil.formatDecimal(eqFare, true));
            }
        }
        res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(text.toString()));
        StringBuilder prefix = new StringBuilder("X*PA" + productNum + "*");
        prefix.append(this.getTicketNumber(product));
        prefix.append("*TAXES");
        for (String taxesStr : this.getTaxesStrings(product, prefix)) {
            res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(prefix.toString() + taxesStr));
        }
        if (clientMode == SabrePassiveSegmentsClientMode.CWT) {
            res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark("X*CWTCLIENT"));
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            List<CostCode> costCodes = SabrePassiveSegmentsUtil.getCostCodes(product.getStatisticalData());
            costCodes.forEach(cc -> res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark(SabrePassiveSegmentsUtil.getDotXStarRemarkUDIDText(cc))));
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotProductRemarks(Product product, String productNum, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            List<CostCode> costCodes = SabrePassiveSegmentsUtil.getCostCodes(product.getStatisticalData());
            costCodes.forEach(cc -> res.add(SabrePassiveSegmentsUtil.prepareDotProductRemark(SabrePassiveSegmentsUtil.getDotRemarkUDIDText(cc))));
        }
        return res;
    }

    private List<String> getTaxesStrings(Product p, StringBuilder prefix) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder currStr = new StringBuilder();
        for (Tax tax : p.getTaxes()) {
            if (tax == null || tax.getEquivalentAmount() == null) continue;
            String taxStr = "*" + SabrePassiveSegmentsUtil.formatDecimal(tax.getEquivalentAmount(), false) + (tax.getCode() != null ? tax.getCode().toUpperCase() : "");
            if (prefix.length() + currStr.length() + taxStr.length() < 66) {
                currStr.append(taxStr);
                continue;
            }
            res.add(currStr.toString());
            currStr = new StringBuilder(taxStr);
        }
        if (currStr.length() > 0) {
            res.add(currStr.toString());
        }
        return res;
    }

    private String getTicketNumber(Product p, String recordNumber) {
        String coupon = "";
        if (!TextUtil.isBlank((String)recordNumber)) {
            coupon = "/" + String.valueOf(recordNumber);
        }
        return this.getTicketNumber(p) + coupon;
    }

    private String getTicketNumber(Product p) {
        String endNumber;
        String conj = "";
        if (p.getConjCount() > 0 && (endNumber = FormattedNumberUtil.add((String)p.getSystemNumber(), (long)p.getConjCount())).length() > 2) {
            conj = "-" + endNumber.substring(endNumber.length() - 2);
        }
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)p.getCarrierNumber())) {
            sb.append(p.getCarrierNumber());
        }
        sb.append(p.getSystemNumber());
        sb.append(conj);
        return SabrePassiveSegmentsUtil.getTranslation(sb.toString());
    }

    private String getPassengerName(Product p) {
        return SabrePassiveSegmentsUtil.getTravelerName(p.getTraveller());
    }

    private String getCreationCommand(Segment s, String seatsAmount, TranslitUtil.TranslitRules rules, TranslitUtil.TranslitRules rulesClass, TranslitUtil.TranslitRules rulesRecloc, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        StringBuilder res = subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT ? new StringBuilder("0ZZ") : new StringBuilder("0YY");
        boolean isOpenDate = "OPEN".equalsIgnoreCase(s.getFlightNo());
        if (isOpenDate) {
            res.append("OPEN");
        } else {
            res.append(SabrePassiveSegmentsUtil.getTranslation(s.getFlightNo(), rules));
        }
        if (s.getClassOfSvcCode() != null) {
            res.append(SabrePassiveSegmentsUtil.getTranslation(s.getClassOfSvcCode(), rulesClass));
        }
        if (s.getStartDate() != null) {
            res.append(SabrePassiveSegmentsUtil.formatDate(s.getStartDate()));
        }
        if (s.getDepartureLocation() != null) {
            String iataDepartureLocationCode = DictHelper.getCodeVariant(s.getDepartureLocation(), CodeSystem.IATA);
            if (iataDepartureLocationCode == null) {
                iataDepartureLocationCode = "DVH";
            }
            res.append(iataDepartureLocationCode);
        }
        if (s.getArriveLocation() != null) {
            String iataArriveLocationCode = DictHelper.getCodeVariant(s.getArriveLocation(), CodeSystem.IATA);
            if (iataArriveLocationCode == null) {
                iataArriveLocationCode = "AVH";
            }
            res.append(iataArriveLocationCode);
        }
        res.append(isOpenDate ? "DS" : "YK");
        res.append(seatsAmount);
        if (s.getStartDate() != null) {
            res.append("/" + SabrePassiveSegmentsUtil.formatTime(s.getStartDate()));
            if (!isOpenDate) {
                if (s.getEndDate() != null) {
                    res.append(SabrePassiveSegmentsUtil.formatTime(s.getEndDate()));
                } else {
                    res.append("0000");
                }
            }
        }
        if (!TextUtil.isBlank((String)s.getAirlineLocator())) {
            int len = s.getAirlineLocator().length();
            String locator = SabrePassiveSegmentsUtil.getTranslation(s.getAirlineLocator(), rulesRecloc);
            while (locator.length() > 6) {
                locator = SabrePassiveSegmentsUtil.getTranslation(s.getAirlineLocator().substring(0, --len), rulesRecloc);
            }
            if (!isOpenDate && !TextUtil.isBlank((String)locator)) {
                res.append("*");
                res.append(locator);
            }
        }
        return res.toString().toUpperCase();
    }

    private static boolean segmentsEqual(List<Segment> list1, List<Segment> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (AirProductPassiveSegmentsHandler.segmentsEqual(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean segmentsEqual(Segment s1, Segment s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!DictHelper.equals(s1.getAirline(), s2.getAirline())) {
            return false;
        }
        if (!TextUtil.isSame((String)s1.getFlightNo(), (String)s2.getFlightNo())) {
            return false;
        }
        if (!TextUtil.isSame((String)s1.getClassOfSvcCode(), (String)s2.getClassOfSvcCode())) {
            return false;
        }
        if (!DictHelper.equals(s1.getDepartureLocation(), s2.getDepartureLocation())) {
            return false;
        }
        if (!DictHelper.equals(s1.getArriveLocation(), s2.getArriveLocation())) {
            return false;
        }
        if (!MiscUtil.equals((Object)s1.getStartDate(), (Object)s2.getStartDate())) {
            return false;
        }
        return TextUtil.isSame((String)s1.getAirlineLocator(), (String)s2.getAirlineLocator());
    }

    private static int getSegmentHashCode(Segment seg, int result) {
        if (seg.getAirline() != null && seg.getAirline().getCode() != null) {
            result = 31 * result + seg.getAirline().getCode().hashCode();
        }
        if (seg.getFlightNo() != null) {
            result = 31 * result + seg.getFlightNo().hashCode();
        }
        if (seg.getClassOfSvcCode() != null) {
            result = 31 * result + seg.getClassOfSvcCode().hashCode();
        }
        if (seg.getDepartureLocation() != null && seg.getDepartureLocation().getCode() != null) {
            result = 31 * result + seg.getDepartureLocation().getCode().hashCode();
        }
        if (seg.getArriveLocation() != null && seg.getArriveLocation().getCode() != null) {
            result = 31 * result + seg.getArriveLocation().getCode().hashCode();
        }
        if (seg.getStartDate() != null) {
            result = 31 * result + seg.getStartDate().hashCode();
        }
        if (seg.getEndDate() != null) {
            result = 31 * result + seg.getEndDate().hashCode();
        }
        if (seg.getAirlineLocator() != null) {
            result = 31 * result + seg.getAirlineLocator().hashCode();
        }
        return result;
    }

    private static class SegmentWrapper {
        private Segment segment;
        private GdsName gdsName;
        private String gdsRecloc;
        private List<Product> products = new ArrayList<Product>();
        private Map<String, String> product2seat = new HashMap<String, String>();
        private Map<String, String> product2baggage = new HashMap<String, String>();
        private Map<String, String> product2fareBasis = new HashMap<String, String>();
        private Map<String, String> product2segmentRecordNumber = new HashMap<String, String>();

        SegmentWrapper(Segment seg, GdsName gdsName, String gdsRecloc) {
            this.segment = seg;
            this.gdsRecloc = gdsRecloc;
            this.gdsName = gdsName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentWrapper) || o == null) {
                return false;
            }
            SegmentWrapper seg = (SegmentWrapper)o;
            if (this.gdsName != seg.getGdsName()) {
                return false;
            }
            if (!TextUtil.isSame((String)this.gdsRecloc, (String)seg.getGdsRecloc())) {
                return false;
            }
            return AirProductPassiveSegmentsHandler.segmentsEqual(this.segment, seg.getSegment());
        }

        public int hashCode() {
            int result = 17;
            if (this.gdsName != null) {
                result = 31 * result + this.gdsName.hashCode();
            }
            if (this.gdsRecloc != null) {
                result = 31 * result + this.gdsRecloc.hashCode();
            }
            return AirProductPassiveSegmentsHandler.getSegmentHashCode(this.segment, result);
        }

        public Segment getSegment() {
            return this.segment;
        }

        public GdsName getGdsName() {
            return this.gdsName;
        }

        public String getGdsRecloc() {
            return this.gdsRecloc;
        }

        public List<Product> getProducts() {
            return Collections.unmodifiableList(this.products);
        }

        public void addProduct(Product product, String recordNumber, String seatNo, String baggage, String fareBasis) {
            this.products.add(product);
            this.product2segmentRecordNumber.put(product.getUid(), recordNumber);
            if (!TextUtil.isBlank((String)seatNo)) {
                this.product2seat.put(product.getUid(), SabrePassiveSegmentsUtil.getTranslation(seatNo));
            }
            if (!TextUtil.isBlank((String)baggage)) {
                this.product2baggage.put(product.getUid(), SabrePassiveSegmentsUtil.getTranslation(baggage));
            }
            if (!TextUtil.isBlank((String)fareBasis)) {
                this.product2fareBasis.put(product.getUid(), SabrePassiveSegmentsUtil.getTranslation(fareBasis));
            }
        }

        public Collection<String> getSeats() {
            return this.product2seat.values();
        }

        public String getSeat(String productUid) {
            return this.product2seat.get(productUid);
        }

        public String getFareBasis(String productUid) {
            return this.product2fareBasis.get(productUid);
        }

        public String getBaggage(String productUid) {
            return this.product2baggage.get(productUid);
        }

        public String getRecordNumber(String productUid) {
            return this.product2segmentRecordNumber.get(productUid);
        }
    }
}

