/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class HotelProductFinanceHelper {
    static Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<HotelProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        boolean hasFees = false;
        boolean hasRefundFees = false;
        boolean hasRefund = false;
        boolean hasSellOrExchange = false;
        boolean hasCashFopInRefund = false;
        block0: for (HotelProduct product : products) {
            if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.EXCHANGE) {
                hasSellOrExchange = true;
            }
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.VOID) {
                hasRefund = true;
                hasCashFopInRefund = HotelProductFinanceHelper.hasCashFopInRefund(product);
            }
            if (hasFees && hasRefundFees) continue;
            for (GeneralProductCommission comm : GeneralProductHelper.filterCommissions(HotelProductHelper.getUnmodifiableCommissions(product, null), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories)) {
                hasFees = true;
                if (!BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) continue;
                hasRefundFees = true;
                continue block0;
            }
        }
        HashSet<FinanceDocument> documents = new HashSet<FinanceDocument>();
        for (FinanceDocument finDoc : availableDocuments) {
            FinanceDocumentType financeDocumentType = finDoc.getType();
            if (financeDocumentType == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && (!hasFees || hasRefund && !hasRefundFees) || financeDocumentType == FinanceDocumentType.CASH_ORDER && (!hasRefund || hasSellOrExchange || !hasCashFopInRefund)) continue;
            documents.add(finDoc);
        }
        return documents;
    }

    private static boolean hasCashFopInRefund(HotelProduct product) throws Exception {
        boolean hasCashFopInRefund = false;
        for (HotelProductFop fop : HotelProductHelper.getClientContractRelation(product).getFops()) {
            if (fop == null || PaymentType.CASH != fop.getType()) continue;
            boolean isFopForFeeForRefund = false;
            for (GeneralProductCommission comm : GeneralProductHelper.filterCommissions(fop.getCommissions(), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories)) {
                if (!BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)comm.getCommissionProperties())) continue;
                isFopForFeeForRefund = true;
                break;
            }
            if (isFopForFeeForRefund) break;
            hasCashFopInRefund = true;
            break;
        }
        return hasCashFopInRefund;
    }

    static boolean includeInFinanceDocuments(HotelProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && !ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus());
    }

    static Collection<BillingItem> getBillingItems(List<HotelProduct> prods, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap tickets = new HashMap();
        HashMap penalties = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        ArrayList<BillingItem> billingItems = new ArrayList<BillingItem>();
        for (HotelProduct product : prods) {
            BigDecimal bigDecimal;
            String description = HotelProductFinanceHelper.getDescription(product);
            FinanceDocumentsHelper.updateMap(tickets, description, product);
            ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
            commissions.addAll(GeneralProductHelper.filterCommissions(HotelProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), null, null, GeneralProductHelper.standardCommissionCategories));
            for (GeneralProductCommission generalProductCommission : commissions) {
                CommissionData cData;
                EntityContainer ctr = EntityStorage.get().resolve(generalProductCommission.getCommissionProperties());
                if (ctr == null) continue;
                if (ctr.getEntity() instanceof FeeProperties) {
                    FeeProperties prop = (FeeProperties)ctr.getEntity();
                    if (generalProductCommission.getContractType() != ContractType.CLIENT && !prop.isChargeToClientForAllContractTypes()) continue;
                }
                if (FeeProperties.class.equals((Object)ctr.getEntityType()) || PaymentFeeProperties.class.equals((Object)ctr.getEntityType())) {
                    cData = new CommissionData(generalProductCommission, product);
                    FinanceDocumentsHelper.updateMap(fees, HotelProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
                    continue;
                }
                if (!DiscountProperties.class.getName().equals(ctr.getEntityType().getName())) continue;
                cData = new CommissionData(generalProductCommission, product);
                FinanceDocumentsHelper.updateMap(discounts, HotelProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
            }
            HotelProduct previousProduct = product.getPreviousProduct();
            if (previousProduct != null && previousProduct.getStatus() == ProductStatus.EXCHANGE) {
                for (GeneralProductCommission comm2 : HotelProductHelper.getUnmodifiableCommissions(previousProduct, null)) {
                    EntityContainer ctr = EntityStorage.get().resolve(comm2.getCommissionProperties());
                    if (ctr == null || !FeeProperties.class.getName().equals(ctr.getEntityType().getName()) || ((FeeProperties)ctr.getEntity()).getOperation() != Operation.EXCHANGE) continue;
                    CommissionData cData = new CommissionData(comm2, previousProduct);
                    FinanceDocumentsHelper.updateMap(fees, HotelProductFinanceHelper.getDescription((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
                }
            }
            if (product.getStatus() != ProductStatus.REFUND && (product.getStatus() != ProductStatus.SELL || product.getPreviousProduct() == null || product.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) || (bigDecimal = HotelProductHelper.calculatePenaltyEquivalentAmount(product, true)) == null || BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
            FinanceDocumentsHelper.updateMap(penalties, HotelProductFinanceHelper.getDescription(bigDecimal), product);
        }
        HotelProductFinanceHelper.updateProductItems(billingItems, tickets.values(), noVat);
        HotelProductFinanceHelper.updateCommissions(billingItems, fees.values(), false, noVat);
        HotelProductFinanceHelper.updateCommissions(billingItems, discounts.values(), true, noVat);
        HotelProductFinanceHelper.updatePenalties(billingItems, penalties.values(), noVat);
        return billingItems;
    }

    private static String getDescription(HotelProduct prod) {
        String result = prod.getStatus() + "_" + prod.getSystemNumber();
        VatAmount money = HotelProductFinanceHelper.calculateProductPrice(prod, false);
        return FinanceDocumentsHelper.getDescription(result, money);
    }

    private static VatAmount calculateProductPrice(HotelProduct prod, boolean ignoreExchange) {
        BigDecimal value = BigDecimal.ZERO;
        if (prod.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)prod, ContractType.CLIENT);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus())) {
            BigDecimal penalty;
            if (!HotelProductHelper.getClientContractRelation(prod).getFops().isEmpty()) {
                for (HotelProductFop fop : HotelProductHelper.getClientContractRelation(prod).getFops()) {
                    if (fop.getType() == PaymentType.TICKET || fop.getType() == PaymentType.PTA || fop.getAmount() == null || fop.getAmount().getValue() == null || !HotelProductHelper.isServiceFop(fop)) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            } else {
                for (HotelProductFop fop : HotelProductHelper.getVendorContractRelation(prod).getFops()) {
                    if (fop.getType() == PaymentType.TICKET || fop.getType() == PaymentType.PTA || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            }
            if ((penalty = HotelProductHelper.calculatePenaltyEquivalentAmount(prod, true)) != null) {
                value = prod.getStatus() == ProductStatus.REFUND || prod.getStatus() == ProductStatus.EXCHANGE ? value.add(penalty) : value.subtract(penalty);
            }
            boolean hasRelatedExchange = prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            VatAmount result = new VatAmount();
            BigDecimal totalVatAmount = HotelProductHelper.calculateTotalVatAmount(prod);
            if (totalVatAmount == null) {
                boolean hasVat = HotelProductHelper.isHasVat(prod);
                result.setTotalVat(value, hasVat ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue() : 0.0);
            } else if (hasRelatedExchange) {
                result.setTotalVatAmount(value, MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVatAmount, MiscUtil.negate((BigDecimal)HotelProductHelper.calculateTotalVatAmount(prod.getPreviousProduct()))}));
            } else {
                result.setTotalVatAmount(value, totalVatAmount);
            }
            if (ignoreExchange) {
                return result;
            }
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    public static String getCommonPart(HotelProduct prod, String relatedInvoiceNumber) {
        if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
            return String.format("\u0411\u0440\u043e\u043d\u044c \u043e\u0442\u0435\u043b\u044f %s, %s - %s ($group_info) %s", prod.getHotelName() != null ? prod.getHotelName() : "?", HotelProductFinanceHelper.getCheckInDate(prod), HotelProductFinanceHelper.getCheckOutDate(prod), HotelProductFinanceHelper.getExhangeInfo(prod, relatedInvoiceNumber));
        }
        if (prod.getStatus() == ProductStatus.REFUND) {
            return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0440\u043e\u043d\u0438 \u043e\u0442\u0435\u043b\u044f %s, %s - %s ($group_info)", prod.getHotelName() != null ? prod.getHotelName() : "?", HotelProductFinanceHelper.getCheckInDate(prod), HotelProductFinanceHelper.getCheckOutDate(prod));
        }
        return "";
    }

    public static String getExhangeInfo(HotelProduct prod, String relatedInvoiceNumber) {
        if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            return "";
        }
        HotelProduct firstSell = prod.getPreviousProduct().getPreviousProduct();
        return String.format("(\u0421 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0439 \u0432 \u043e\u0431\u043c\u0435\u043d \u0431\u0440\u043e\u043d\u0438 \u2116 %s%s)", HotelProductFinanceHelper.getTicketNumber(firstSell), !TextUtil.isBlank((String)relatedInvoiceNumber) ? String.format(", \u0441\u0447\u0435\u0442 \u2116 %s", relatedInvoiceNumber) : "");
    }

    private static String getCommonPart(HotelProduct prod) {
        if (prod.getStatus() == ProductStatus.SELL || prod.getStatus() == ProductStatus.BOOKING) {
            return String.format("\u0411\u0440\u043e\u043d\u044c \u043e\u0442\u0435\u043b\u044f %s, %s - %s ($group_info)%s", prod.getHotelName() != null ? prod.getHotelName() : "?", HotelProductFinanceHelper.getCheckInDate(prod), HotelProductFinanceHelper.getCheckOutDate(prod), HotelProductFinanceHelper.getExhangeInfo(prod));
        }
        if (prod.getStatus() == ProductStatus.REFUND) {
            return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0440\u043e\u043d\u0438 \u043e\u0442\u0435\u043b\u044f %s, %s - %s ($group_info)", prod.getHotelName() != null ? prod.getHotelName() : "?", HotelProductFinanceHelper.getCheckInDate(prod), HotelProductFinanceHelper.getCheckOutDate(prod));
        }
        return "";
    }

    private static String getExhangeInfo(HotelProduct prod) {
        if (prod.getStatus() != ProductStatus.SELL || prod.getPreviousProduct() == null || prod.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            return "";
        }
        return String.format(" (\u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u043e\u0439 \u0432 \u043e\u0431\u043c\u0435\u043d \u0431\u0440\u043e\u043d\u0438 \u2116%s)", HotelProductFinanceHelper.getTicketNumber(prod.getPreviousProduct().getPreviousProduct()));
    }

    private static String getTicketNumber(HotelProduct prod) {
        return String.format("%s-%s", prod.getHotelName(), prod.getSystemNumber());
    }

    private static String getCheckInDate(HotelProduct prod) {
        if (prod.getRooms().isEmpty()) {
            return "?";
        }
        Date startDate = ((Room)prod.getRooms().get(0)).getCheckInDate();
        if (startDate == null) {
            return "?";
        }
        return LocaleManager.get().getCurrentLocaleData().getDateFormat().format(startDate);
    }

    private static String getCheckOutDate(HotelProduct prod) {
        Date endDate;
        if (prod.getRooms().isEmpty()) {
            return "?";
        }
        Date date = endDate = ((Room)prod.getRooms().get(prod.getRooms().size() - 1)).getCheckOutDate() != null ? ((Room)prod.getRooms().get(prod.getRooms().size() - 1)).getCheckOutDate() : ((Room)prod.getRooms().get(prod.getRooms().size() - 1)).getCheckInDate();
        if (endDate == null) {
            return "?";
        }
        return LocaleManager.get().getCurrentLocaleData().getDateFormat().format(endDate);
    }

    private static void updateProductItems(List<BillingItem> billingItems, Collection<List<HotelProduct>> values, boolean noVat) {
        for (List<HotelProduct> lst : values) {
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (HotelProduct product : lst) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.TICKET);
            item.setName(HotelProductFinanceHelper.getCommonPart(lst.get(0)).replace("$group_info", HotelProductFinanceHelper.getGroupInfo(lst)));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (HotelProduct product : lst) {
                VatAmount price = HotelProductFinanceHelper.calculateProductPrice(product, false);
                total = total.add(price.getTotal());
                if (price.getVatAmount() == null) continue;
                vat = vat.add(price.getVatAmount());
            }
            ProductStatus status = lst.get(0).getStatus();
            if (status == ProductStatus.REFUND) {
                total = total.negate();
                vat = vat.negate();
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static String getGroupInfo(List<HotelProduct> lst) {
        StringBuilder sb = new StringBuilder();
        for (HotelProduct product : lst) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            StringBuilder travellers = new StringBuilder();
            for (Traveller traveller : product.getTravellers()) {
                if (travellers.length() > 0) {
                    travellers.append(", ");
                }
                travellers.append(traveller.getName());
            }
            sb.append(travellers.length() > 0 ? travellers.toString() : "?");
            if (product.getStatus() == ProductStatus.BOOKING) continue;
            sb.append(": \u2116").append(HotelProductFinanceHelper.getTicketNumber(product));
        }
        return sb.toString();
    }

    private static String getDescription(EntityContainer<? extends BaseCommissionProperties> ctr, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        return FinanceDocumentsHelper.getDescription(UUIDGenerator.generate((boolean)false).toString(), amount);
    }

    private static String getDescription(BigDecimal penalty) {
        return Double.toString(penalty.doubleValue());
    }

    private static void updateCommissions(List<BillingItem> billingItems, Collection<List<CommissionData>> values, boolean discount, boolean noVat) throws Exception {
        for (List<CommissionData> lst : values) {
            FeeProperties prop;
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (CommissionData data : lst) {
                item.getProductUids().add(data.product.getUid());
            }
            item.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            item.setCommissionType(lst.get((int)0).commission.getCommissionProperties());
            EntityContainer ctr = EntityStorage.get().resolve(lst.get((int)0).commission.getCommissionProperties());
            BigDecimal coef = BigDecimal.ONE;
            if (ctr.getEntityType().getName().equals(FeeProperties.class.getName())) {
                prop = (FeeProperties)ctr.getEntity();
                item.setName(prop.getFinanceName());
                if (lst.get((int)0).product.getStatus() == ProductStatus.EXCHANGE && prop.getOperation() == Operation.EXCHANGE) {
                    coef = coef.negate();
                }
            } else if (ctr.getEntityType().equals(PaymentFeeProperties.class)) {
                prop = (PaymentFeeProperties)ctr.getEntity();
                item.setName(prop.getFinanceName());
            } else {
                item.setName(((DiscountProperties)ctr.getEntity()).getFinanceName());
            }
            if (lst.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coef = coef.negate();
            }
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<HotelProduct> products = new ArrayList<HotelProduct>();
            for (CommissionData cdata : lst) {
                BigDecimal ec = cdata.commission.getEquivalentAmount();
                if (ec != null) {
                    BigDecimal bigDecimal = total = discount ? total.subtract(ec) : total.add(ec);
                }
                if (cdata.product == null || products.contains(cdata.product)) continue;
                products.add(cdata.product);
            }
            if (!TextUtil.isBlank((String)item.getName())) {
                item.setName(item.getName().replace("${air_tickets_info}", HotelProductFinanceHelper.getGroupInfo(products)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVat(coef.multiply(total), noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(lst.get((int)0).product.getIssueDate())).doubleValue());
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static void updatePenalties(List<BillingItem> billingItems, Collection<List<HotelProduct>> values, boolean noVat) {
        for (List<HotelProduct> lst : values) {
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            BigDecimal penalty = BigDecimal.ZERO;
            BigDecimal totalVat = BigDecimal.ZERO;
            boolean refund = false;
            boolean exchange = false;
            for (HotelProduct product : lst) {
                item.getProductUids().add(product.getUid());
                penalty = MiscUtil.sum((BigDecimal[])new BigDecimal[]{penalty, HotelProductHelper.calculatePenaltyEquivalentAmount(product, true)});
                totalVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVat, HotelProductHelper.calculatePenaltyEquivalentVatAmount(product, true)});
                if (refund || exchange) continue;
                refund = product.getStatus() == ProductStatus.REFUND;
                exchange = product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            }
            if (BigDecimal.ZERO.compareTo(penalty) == 0) continue;
            item.setServiceType(ServiceType.PENALTY);
            if (refund) {
                item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0440\u043e\u043d\u0438 \u043e\u0442\u0435\u043b\u044f (%s)", HotelProductFinanceHelper.getGroupInfo(lst)));
            } else if (exchange) {
                item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0440\u043e\u043d\u0438 \u043e\u0442\u0435\u043b\u044f (%s)", HotelProductFinanceHelper.getGroupInfo(lst)));
            } else {
                item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 (%s)", HotelProductFinanceHelper.getGroupInfo(lst)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(penalty, totalVat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private HotelProductFinanceHelper() {
    }

    static final class CommissionData {
        public HotelProduct product;
        public GeneralProductCommission commission;

        public CommissionData(GeneralProductCommission commission, HotelProduct product) {
            this.commission = commission;
            this.product = product;
        }
    }
}

