/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.MCOFeesType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MCOFeesHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MCOFeesHandler
implements ProductHandler<MCOFees> {
    @Override
    public Class<MCOFees> getProductClass() {
        return MCOFees.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, MCOFees product) {
        return this.calculateProductPrice(product, (ContractType)null);
    }

    @Override
    public VatAmount calculateProductPrice(MCOFees product, ContractType ctype) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    @Override
    public String generateShortProductName(MCOFees product) {
        return L10nResourcesManager.getStr((String)"MCO_FEES_SHORT_PRODUCT_NAME", (Object[])new Object[]{product.getScn(), product.getStatus()});
    }

    @Override
    public String generateProductName(MCOFees product) {
        String relatedProductNumbers = product.getSources().stream().map(MCOFeesSource::getProductUid).distinct().map(item -> BookingHelper.findProduct(product.getReservation().getBookingFile(), item)).filter(Objects::nonNull).flatMap(item -> ProductHandler.of(item).getProductNumbers((BaseProduct)item).stream()).filter(Objects::nonNull).collect(Collectors.joining(", "));
        return L10nResourcesManager.getStr((String)"MCO_FEES_PRODUCT_NAME", (Object[])new Object[]{product.getStatus(), product.getScn(), relatedProductNumbers});
    }

    @Override
    public Date findFirstTravelDate(MCOFees product) {
        return null;
    }

    @Override
    public Date findLastTravelDate(MCOFees product) {
        return null;
    }

    @Override
    public List<String> getProductNumbers(MCOFees product) {
        return product.getScn() == null ? Collections.emptyList() : Collections.singletonList(product.getScn());
    }

    @Override
    public EntityReference<Person> findIssuingAgent(MCOFees product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(MCOFees product) {
        return null;
    }

    @Override
    public Date findIssueDate(MCOFees product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(MCOFees product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(MCOFees product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(MCOFees product) {
        return product.getType() == MCOFeesType.FEES;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        return new HashSet<FinanceDocument>(availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public String getBillingItemName(MCOFees product, String relatedInvoiceNumber) {
        return null;
    }

    @Override
    public Collection<Traveller> getTravellers(MCOFees product) {
        Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getTravellerUid());
        return traveller == null ? new ArrayList() : Collections.singletonList(traveller);
    }

    @Override
    public void replaceTraveller(MCOFees product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller.getUid().equals(product.getTravellerUid())) {
            product.setTravellerUid(newTraveller.getUid());
        }
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(MCOFees product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.setTravellerUid(newTraveller.getUid());
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void setOrReplaceTraveller(MCOFees product, Traveller newTraveller) {
        Collection<Traveller> travellers = this.getTravellers(product);
        this.setOrReplaceTraveller(product, travellers.isEmpty() ? null : (Traveller)travellers.stream().findFirst().orElse(null), newTraveller);
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<MCOFees> products) {
        if (products.isEmpty()) {
            return;
        }
        BookingFile bf = products.get(0).getReservation().getBookingFile();
        HashMap<MCOFees, List> fees = new HashMap<MCOFees, List>();
        block0: for (BillingItem billingItem : items) {
            if (billingItem.getServiceType() != ServiceType.FEE) continue;
            for (String uid : billingItem.getProductUids()) {
                BaseProduct bp = BookingHelper.findProduct(bf, uid);
                if (bp == null) continue;
                for (MCOFees mco : products) {
                    Set relatedProductUids = mco.getSources().stream().map(MCOFeesSource::getProductUid).collect(Collectors.toSet());
                    if (!relatedProductUids.contains(bp.getUid())) continue;
                    List list = fees.computeIfAbsent(mco, k -> new ArrayList());
                    list.add(billingItem);
                    continue block0;
                }
            }
        }
        if (fees.isEmpty()) {
            return;
        }
        for (Map.Entry entry : fees.entrySet()) {
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            HashSet uids = new HashSet();
            EntityReference comm = null;
            MCOFees mcoFees = (MCOFees)entry.getKey();
            for (BillingItem item : (List)entry.getValue()) {
                uids.addAll(item.getProductUids());
                if (item.getAmount() != null) {
                    total = total.add(item.getAmount().getTotal());
                    vat = vat.add(item.getAmount().getVatAmount());
                }
                if (comm != null || item.getCommissionType() == null) continue;
                comm = item.getCommissionType();
            }
            BillingItem item = new BillingItem();
            item.setServiceType(ServiceType.FEE);
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            item.setCommissionType(comm);
            item.getProductUids().add(((MCOFees)entry.getKey()).getUid());
            ArrayList<String> productNumbers = new ArrayList<String>();
            for (String uid : uids) {
                BaseProduct bp = BookingHelper.findProduct(bf, uid);
                if (bp == null || bp instanceof MCOFees) continue;
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                productNumbers.addAll(handler.getProductNumbers(bp));
            }
            Collections.sort(productNumbers);
            StringBuilder sb = new StringBuilder();
            for (String number : productNumbers) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(number);
            }
            item.setName(String.format("\u041a\u0420\u0421 %s \u0437\u0430 %s %s", mcoFees.getScn(), productNumbers.size() > 1 ? "\u0431\u0438\u043b\u0435\u0442\u044b" : "\u0431\u0438\u043b\u0435\u0442", sb));
            items.add(item);
            items.removeAll((Collection)entry.getValue());
        }
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(MCOFees product) {
        return product.getSalesPoint();
    }

    @Override
    public ProductStatus getStatus(MCOFees product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(MCOFees product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(MCOFees product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(MCOFees product) {
        return ProductType.MCO_FEES;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.MCO_FEES).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return null;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(MCOFees product) {
        return null;
    }

    @Override
    public EntityReference<Branch> getBranch(MCOFees product) {
        return product.getBranch();
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(MCOFees product) {
        return Collections.emptyList();
    }

    @Override
    public boolean isCompleted(MCOFees product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(MCOFees product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(MCOFees product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(MCOFees product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public TransportationType getTransportationType(MCOFees product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(MCOFees product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, MCOFees product) {
        return null;
    }

    @Override
    public MCOFees getPreviousProduct(MCOFees product) {
        return product.getPreviousMCO();
    }

    @Override
    public void setPreviousProduct(MCOFees product, MCOFees previousProduct) {
        product.setPreviousMCO(previousProduct);
    }

    @Override
    public void setNextProduct(MCOFees product, MCOFees nextProduct) {
        product.setNextMCO(nextProduct);
    }

    @Override
    public MCOFees getNextProduct(MCOFees product) {
        return product.getNextMCO();
    }

    @Override
    public void addRelatedProduct(MCOFees product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(MCOFees product) {
        return MCOFeesHelper.getRelatedProducts(product);
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(MCOFees product) {
        return null;
    }

    @Override
    public ProductCategory getProductCategory(MCOFees product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(MCOFees product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(MCOFees product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(MCOFees product) {
        return product.getBlankType();
    }

    @Override
    public BigDecimal getEquivalentFare(MCOFees product) {
        return null;
    }

    @Override
    public BigDecimal getServiceFare(MCOFees product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(MCOFees product) {
        return null;
    }

    @Override
    public int getConjunction(MCOFees product) {
        return 0;
    }

    @Override
    public String getRouteLine(MCOFees product) {
        return null;
    }

    @Override
    public String getLocalizedRouteLine(MCOFees product) {
        return null;
    }

    @Override
    public String getCodeRouteLine(MCOFees product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(MCOFees product) {
        return Collections.emptyList();
    }

    @Override
    public SalesChain getSalesChain(MCOFees product) {
        SalesChain result = new SalesChain();
        result.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.OWN, null));
        GeneralProductHelper.setContractor(result, PredefinedContractorType.AGENCY, (EntityReference<Organization>)product.getAgency());
        return result;
    }

    @Override
    public void updateContractRelations(MCOFees product, List<GeneralProductContractRelationData> relations) {
    }

    @Override
    public TicketType getTicketType(MCOFees product) {
        return null;
    }

    @Override
    public void setTicketType(MCOFees product, TicketType ticketType) {
    }

    @Override
    public String getPCC(MCOFees product) {
        return null;
    }

    @Override
    public void updateProductFops(MCOFees product) {
    }

    @Override
    public void setContractRulesApplied(MCOFees product, boolean value) {
    }

    @Override
    public List<ValidationMessage> getValidationMessages(MCOFees product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(MCOFees product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(MCOFees product) {
        return null;
    }

    @Override
    public boolean isHoldable(MCOFees product) {
        return false;
    }

    @Override
    public Date getUnholdDate(MCOFees product) {
        return null;
    }

    @Override
    public String getValidatorNumber(MCOFees product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(MCOFees product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(MCOFees product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(MCOFees product) {
        return true;
    }

    @Override
    public void newStatisticalData(MCOFees product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(MCOFees product) {
        return null;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    @Override
    public MCOFees newInstance() {
        return new MCOFees();
    }

    @Override
    public String getCarrierNumber(MCOFees product) {
        return null;
    }

    @Override
    public void setAgent(MCOFees product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(MCOFees product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(MCOFees product, EntityReference<Organization> agency) {
        product.setAgency(agency);
    }

    @Override
    public void setBlankOwner(MCOFees product, EntityReference<Organization> blankOwner) {
    }

    @Override
    public void setBranch(MCOFees product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    @Override
    public void setSupplier(MCOFees product, EntityReference<Organization> supplier) {
    }

    @Override
    public void setSubagency(MCOFees product, EntityReference<Organization> subagency) {
    }

    @Override
    public void setSalesPoint(MCOFees product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(MCOFees product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
    }

    @Override
    public void changeFopsAgent(MCOFees product, EntityReference<Person> agent, ContractType contractType) {
    }

    @Override
    public List<String> getFopsUids(MCOFees product, ContractType contractType) {
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(MCOFees product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    @Override
    public Money getBspCommissionValue(MCOFees product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(MCOFees product) {
        return null;
    }

    @Override
    public boolean removeProduct(MCOFees product) {
        return MCOFeesHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(MCOFees product, BaseProduct relatedProduct) {
        return MCOFeesHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(MCOFees product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(MCOFees product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(MCOFees product, Locale locale) {
        return null;
    }

    @Override
    public Date getFirstStartDate(MCOFees product) {
        return null;
    }

    @Override
    public Date getLastStartDate(MCOFees product) {
        return null;
    }

    @Override
    public Date getFirstEndDate(MCOFees product) {
        return null;
    }

    @Override
    public Date getLastEndDate(MCOFees product) {
        return null;
    }

    @Override
    public String getDescriptionLine(MCOFees product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(MCOFees product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(MCOFees product) {
        return false;
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(MCOFees product) {
        return false;
    }

    @Override
    public String getRfic(MCOFees product) {
        return null;
    }

    @Override
    public String getRfisc(MCOFees product) {
        return null;
    }

    @Override
    public String getTourCode(MCOFees product) {
        return null;
    }

    @Override
    public boolean isDuplicate(MCOFees product) {
        return false;
    }
}

