/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.handlers.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VisaProductHandler
implements ProductHandler<VisaProduct> {
    @Override
    public Class<VisaProduct> getProductClass() {
        return VisaProduct.class;
    }

    @Override
    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, VisaProduct product) {
        return GeneralProductHelper.calculateProductPrice(relation, this, product);
    }

    @Override
    public VatAmount calculateProductPrice(VisaProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice((GeneralProductContractRelationData)null, product);
    }

    @Override
    public String generateShortProductName(VisaProduct product) {
        return L10nResourcesManager.getStr((String)"VISA_SHORT_PRODUCT_NAME", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", product.getStatus() != null ? product.getStatus() : ""});
    }

    @Override
    public String generateProductName(VisaProduct product) {
        return L10nResourcesManager.getStr((String)"VISA_PRODUCT_NAME", (Object[])new Object[]{TextUtil.nonNullStr((String)product.getSystemNumber()), TextUtil.objToNotNullString((Object)product.getStatus()), !product.getTravellers().isEmpty() ? " (" + product.getTravellers().stream().map(Traveller::getName).collect(Collectors.joining(", ")) + ")" : ""});
    }

    @Override
    public List<String> getProductNumbers(VisaProduct product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    @Override
    public EntityReference<Person> findIssuingAgent(VisaProduct product) {
        return product.getAgent();
    }

    @Override
    public TravelSubject findTravelSubject(VisaProduct product) {
        return TravelSubject.VISA;
    }

    @Override
    public Date findIssueDate(VisaProduct product) {
        return product.getIssueDate();
    }

    @Override
    public Date findLocalIssueDate(VisaProduct product) {
        return product.getLocalIssueDate();
    }

    @Override
    public void setIssueDate(VisaProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    @Override
    public boolean includeInFinanceDocuments(VisaProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    @Override
    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        HashSet<GeneralProductHelper.FinanceCapableProduct> prods = new HashSet<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof VisaProduct)) continue;
            prods.add(this.createFinanceCapableProduct((VisaProduct)bp));
        }
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    @Override
    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<GeneralProductHelper.FinanceCapableProduct> prods = new ArrayList<GeneralProductHelper.FinanceCapableProduct>();
        for (BaseProduct bp : products) {
            if (!(bp instanceof VisaProduct)) continue;
            prods.add(this.createFinanceCapableProduct((VisaProduct)bp));
        }
        return GeneralProductHelper.getBillingItems(prods, fdp, noVat);
    }

    @Override
    public String getBillingItemName(VisaProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    @Override
    public Collection<Traveller> getTravellers(VisaProduct product) {
        return product.getTravellers();
    }

    @Override
    public void replaceTraveller(VisaProduct product, Traveller oldTraveller, Traveller newTraveller) {
        for (int i = 0; i < product.getTravellers().size(); ++i) {
            if (!oldTraveller.equals(product.getTravellers().get(i))) continue;
            product.getTravellers().set(i, newTraveller);
            break;
        }
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    @Override
    public void setOrReplaceTraveller(VisaProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    @Override
    public void updateBillingItems(Collection<BillingItem> items, List<VisaProduct> products) {
    }

    @Override
    public EntityReference<SalesPoint> findSalesPoint(VisaProduct product) {
        return product.getSalesPoint();
    }

    @Override
    public Date findLastTravelDate(VisaProduct product) {
        return product.getEndDate();
    }

    @Override
    public ProductStatus getStatus(VisaProduct product) {
        return product.getStatus();
    }

    @Override
    public ProductStatus getBaseStatus(VisaProduct product) {
        return product.getStatus();
    }

    @Override
    public void setStatus(VisaProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    @Override
    public ProductType getProductType(VisaProduct product) {
        return ProductType.VISA_PRODUCT;
    }

    @Override
    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.VISA_PRODUCT).collect(Collectors.toSet()));
    }

    @Override
    public RuleTarget getCommissionRuleTarget() {
        return Targets.VISA_PRODUCT_COMMISSION;
    }

    @Override
    public EntityReference<Organization> getBlankOwner(VisaProduct product) {
        return product.getBlankOwner();
    }

    @Override
    public EntityReference<Branch> getBranch(VisaProduct product) {
        return null;
    }

    @Override
    public boolean isCompleted(VisaProduct product) {
        return product.isCompleted();
    }

    @Override
    public void setCompleted(VisaProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    @Override
    public boolean isChecked(VisaProduct product) {
        return product.isChecked();
    }

    @Override
    public void setChecked(VisaProduct product, boolean checked) {
        product.setChecked(checked);
    }

    @Override
    public List<MCOFeesSource> getMcoFeesSources(VisaProduct product) {
        return Collections.emptyList();
    }

    @Override
    public TransportationType getTransportationType(VisaProduct product) {
        return null;
    }

    @Override
    public ServiceLocationType getServiceLocationType(VisaProduct product) {
        return null;
    }

    @Override
    public Date findNearestTravelDate(Date momentOfTime, VisaProduct product) {
        Date startDate = product.getStartDate();
        if (momentOfTime.compareTo(startDate) > 0) {
            return null;
        }
        return startDate;
    }

    @Override
    public VisaProduct getPreviousProduct(VisaProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public void setPreviousProduct(VisaProduct product, VisaProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    @Override
    public void setNextProduct(VisaProduct product, VisaProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    @Override
    public VisaProduct getNextProduct(VisaProduct product) {
        return product.getNextProduct();
    }

    @Override
    public void addRelatedProduct(VisaProduct product, BaseProduct relatedProduct) {
    }

    @Override
    public List<BaseProduct> getRelatedProducts(VisaProduct product) {
        return Collections.emptyList();
    }

    @Override
    public ProductCategory getProductCategory(VisaProduct product) {
        return null;
    }

    @Override
    public MCOCategory getMCOCategory(VisaProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductTax> getTaxes(VisaProduct product) {
        return Collections.emptyList();
    }

    @Override
    public DictionaryReference<BlankType> getBlankType(VisaProduct product) {
        return null;
    }

    @Override
    public BigDecimal getEquivalentFare(VisaProduct product) {
        return product.getEquivalentFare() != null ? product.getEquivalentFare().getValue() : null;
    }

    @Override
    public BigDecimal getServiceFare(VisaProduct product) {
        return null;
    }

    @Override
    public BigDecimal getPenalty(VisaProduct product) {
        return product.getPenalty();
    }

    @Override
    public int getConjunction(VisaProduct product) {
        return 0;
    }

    @Override
    public String getRouteLine(VisaProduct product) {
        return VisaProductHelper.getRouteLine(product);
    }

    @Override
    public String getLocalizedRouteLine(VisaProduct product) {
        return VisaProductHelper.getRouteLine(product);
    }

    @Override
    public String getCodeRouteLine(VisaProduct product) {
        return VisaProductHelper.getRouteLine(product);
    }

    @Override
    public Date findFirstTravelDate(VisaProduct product) {
        return product.getStartDate();
    }

    @Override
    public ProductCancellationDetails getCancellationDetails(VisaProduct product) {
        return null;
    }

    @Override
    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(VisaProduct product) {
        return VisaProductHelper.getContractRelations(product).stream().map(oldData -> {
            try {
                return (GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)oldData);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public SalesChain getSalesChain(VisaProduct product) {
        return VisaProductHelper.getSalesChain(product);
    }

    @Override
    public void updateContractRelations(VisaProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    @Override
    public TicketType getTicketType(VisaProduct product) {
        return product.getTicketType();
    }

    @Override
    public void setTicketType(VisaProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    @Override
    public String getPCC(VisaProduct product) {
        return null;
    }

    @Override
    public void updateProductFops(VisaProduct product) {
        GeneralProductHelper.updateProductFops(product);
    }

    @Override
    public void setContractRulesApplied(VisaProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    @Override
    public List<ValidationMessage> getValidationMessages(VisaProduct product) {
        return product.getValidationMessages();
    }

    @Override
    public EntityReference<Organization> getProvider(VisaProduct product) {
        return null;
    }

    @Override
    public PassengerStatus getPassengerStatus(VisaProduct product) {
        return null;
    }

    @Override
    public boolean isHoldable(VisaProduct product) {
        return false;
    }

    @Override
    public Date getUnholdDate(VisaProduct product) {
        return null;
    }

    @Override
    public String getValidatorNumber(VisaProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<PassengerType> getPassengerType(VisaProduct product) {
        return null;
    }

    @Override
    public StatisticalData getStatisticalData(VisaProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public boolean isStatisticalDataAvailable(VisaProduct product) {
        return true;
    }

    @Override
    public void newStatisticalData(VisaProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public BigDecimal getAddCollect(VisaProduct product) {
        return null;
    }

    GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final VisaProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            @Override
            public Date getIssueDate() {
                return VisaProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return VisaProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return VisaProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return VisaProductHelper.getClientFops(product);
            }

            @Override
            public ProductStatus getStatus() {
                return product.getStatus();
            }

            @Override
            public List<GeneralProductCommission> getCommissions() {
                return VisaProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            @Override
            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? VisaProductHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            @Override
            public VatAmount calculateProductPrice() {
                return VisaProductHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            @Override
            public boolean isHasVat() {
                return true;
            }

            @Override
            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"VISA_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"VISA_PRODUCT_INFO", (Object[])new Object[0]);
            }

            @Override
            public BigDecimal getPenalty() {
                return product.getPenalty();
            }

            @Override
            public String getProductUid() {
                return product.getUid();
            }

            @Override
            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            @Override
            public Traveller getTraveller() {
                if (product.getTravellers().isEmpty()) {
                    return null;
                }
                return (Traveller)product.getTravellers().get(0);
            }
        };
    }

    @Override
    public VatDetalization getVendorVatDetalization(VisaProduct product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        if (product.getEquivalentFare() != null) {
            GeneralProductHelper.addVatComponent(vatComponents, product.getEquivalentFare().getValue(), product.getEquivalentFareVatValue(), VatBasisType.FARE);
        }
        GeneralProductHelper.addVatComponent(vatComponents, product.getPenalty(), product.getPenaltyVatValue(), VatBasisType.PENALTY);
        result.setDetalized(true);
        return result;
    }

    @Override
    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.VISA;
    }

    @Override
    public VisaProduct newInstance() {
        return new VisaProduct();
    }

    @Override
    public String getCarrierNumber(VisaProduct product) {
        return null;
    }

    @Override
    public void setAgent(VisaProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public void setComments(VisaProduct product, String comments) {
        product.setComments(comments);
    }

    @Override
    public void setAgency(VisaProduct product, EntityReference<Organization> agency) {
        VisaProductHelper.setAgency(product, agency);
    }

    @Override
    public void setBlankOwner(VisaProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    @Override
    public void setBranch(VisaProduct product, EntityReference<Branch> branch) {
    }

    @Override
    public void setSupplier(VisaProduct product, EntityReference<Organization> supplier) {
        VisaProductHelper.setSupplier(product, supplier);
    }

    @Override
    public void setSubagency(VisaProduct product, EntityReference<Organization> subagency) {
        VisaProductHelper.setSubagency(product, subagency);
    }

    @Override
    public void setSalesPoint(VisaProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    @Override
    public void changeFopsPaymentTypes(VisaProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(VisaProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(VisaProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(VisaProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    @Override
    public void changeFopsAgent(VisaProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    @Override
    public List<String> getFopsUids(VisaProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(VisaProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return VisaProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return VisaProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return VisaProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setBlankType(VisaProduct product, DictionaryReference<BlankType> blankType) {
    }

    @Override
    public Money getBspCommissionValue(VisaProduct product) {
        return null;
    }

    @Override
    public Double getBspCommissionRate(VisaProduct product) {
        return null;
    }

    @Override
    public boolean removeProduct(VisaProduct product) {
        return VisaProductHelper.removeProduct(product);
    }

    @Override
    public boolean removeRelatedProduct(VisaProduct product, BaseProduct relatedProduct) {
        return VisaProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    @Override
    public boolean isAppropriateBillingItem(VisaProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    @Override
    public String getCities(VisaProduct product, Locale locale) {
        return null;
    }

    @Override
    public String getCountries(VisaProduct product, Locale locale) {
        return VisaProductHelper.getCountries(product, locale);
    }

    @Override
    public Date getFirstStartDate(VisaProduct product) {
        return product.getStartDate();
    }

    @Override
    public Date getLastStartDate(VisaProduct product) {
        return product.getStartDate();
    }

    @Override
    public Date getFirstEndDate(VisaProduct product) {
        return product.getEndDate();
    }

    @Override
    public Date getLastEndDate(VisaProduct product) {
        return product.getEndDate();
    }

    @Override
    public String getDescriptionLine(VisaProduct product) {
        return null;
    }

    @Override
    public DictionaryReference<Airline> getCarrier(VisaProduct product) {
        return null;
    }

    @Override
    public boolean isContractRulesApplied(VisaProduct product) {
        return product.isContractRulesApplied();
    }

    @Override
    public boolean isSystemNumberDuplicateAllowed(VisaProduct product) {
        return false;
    }

    @Override
    public String getRfic(VisaProduct product) {
        return null;
    }

    @Override
    public String getRfisc(VisaProduct product) {
        return null;
    }

    @Override
    public String getTourCode(VisaProduct product) {
        return null;
    }

    @Override
    public boolean isDuplicate(VisaProduct product) {
        return false;
    }

    @Override
    public String getGdsCurrency(VisaProduct product) {
        return Optional.ofNullable(product.getEquivalentFare()).map(Money::getCurrency).orElse(null);
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }
}

