/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.air.AgencyMemo;
import com.gridnine.xtrip.common.model.booking.air.AgencyMemoItem;
import com.gridnine.xtrip.common.model.system.Money;
import java.math.BigDecimal;
import java.util.Collection;

public final class AgencyMemoHelper {
    public static boolean isReportAssociatedAgencyMemo(AgencyMemo agencyMemo) {
        for (AgencyMemoItem agencyMemoItem : agencyMemo.getItems()) {
            if (agencyMemoItem.getRelatedProductNumbers().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static Money calculateTotalBaseFareValue(AgencyMemo agencyMemo) {
        return AgencyMemoHelper.calculateTotalBaseAmount(agencyMemo.getItems());
    }

    public static Money calculateTotalBaseAmount(Collection<AgencyMemoItem> agencyMemoItems) {
        BigDecimal totalBaseAmount = null;
        String totalBaseCurrecny = null;
        for (AgencyMemoItem agencyMemoItem : agencyMemoItems) {
            if (agencyMemoItem.getAmount() == null) continue;
            BigDecimal amount = agencyMemoItem.getAmount().getValue();
            String currency = agencyMemoItem.getAmount().getCurrency();
            if (amount != null) {
                BigDecimal bigDecimal = totalBaseAmount = totalBaseAmount != null ? totalBaseAmount.add(amount) : amount;
            }
            if (totalBaseCurrecny != null || currency == null) continue;
            totalBaseCurrecny = currency;
        }
        if (totalBaseAmount != null && totalBaseCurrecny != null) {
            Money money = new Money();
            money.setValue(totalBaseAmount);
            money.setCurrency(totalBaseCurrecny);
            return money;
        }
        return null;
    }

    public static BigDecimal calculateAgencyMemoItemsEquivalentValue(Collection<AgencyMemoItem> agencyMemoItems) {
        BigDecimal value = null;
        for (AgencyMemoItem agencyMemoItem : agencyMemoItems) {
            if (agencyMemoItem.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(agencyMemoItem.getEquivalentAmount()) : agencyMemoItem.getEquivalentAmount();
        }
        return value;
    }
}

