/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductRelatedProductGroup;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class AgencyMemoProductHelper {
    public static final Set<AgencyMemoProductEntryType> tariffEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.TARIFF));
    public static final Set<AgencyMemoProductEntryType> taxEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.TAX_CARRIER, AgencyMemoProductEntryType.TAX_FUEL, AgencyMemoProductEntryType.TAX_STATE, AgencyMemoProductEntryType.TAX_OTHERS));
    public static final Set<AgencyMemoProductEntryType> taxCarrierEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.TAX_CARRIER));
    public static final Set<AgencyMemoProductEntryType> taxFuelEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.TAX_FUEL));
    public static final Set<AgencyMemoProductEntryType> taxStateEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.TAX_STATE));
    public static final Set<AgencyMemoProductEntryType> taxOthersEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.TAX_OTHERS));
    public static final Set<AgencyMemoProductEntryType> penaltyEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.PENALTY));
    public static final Set<AgencyMemoProductEntryType> contractPenaltyEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.CONTRACT_PENALTY));
    public static final Set<AgencyMemoProductEntryType> commissionEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.COMMISSION));
    public static final Set<AgencyMemoProductEntryType> bonusEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.BONUS));
    public static final Set<AgencyMemoProductEntryType> feeEntryTypes = new HashSet<AgencyMemoProductEntryType>(Arrays.asList(AgencyMemoProductEntryType.FEE));
    public static final Set<AgencyMemoProductEntryAssociationType> productEntryAssociationTypes = new HashSet<AgencyMemoProductEntryAssociationType>(Arrays.asList(AgencyMemoProductEntryAssociationType.PRODUCT));
    public static final Set<AgencyMemoProductEntryAssociationType> reportEntryAssociationTypes = new HashSet<AgencyMemoProductEntryAssociationType>(Arrays.asList(AgencyMemoProductEntryAssociationType.REPORT));

    public static boolean isReportAssociated(Collection<AgencyMemoProductEntry> entries) {
        for (AgencyMemoProductEntry entry : entries) {
            if (entry.getAssociationType() == AgencyMemoProductEntryAssociationType.REPORT) continue;
            return false;
        }
        return true;
    }

    public static Money calculateItemGroupsBaseAmount(Collection<AgencyMemoProductItemGroup> itemGroups) {
        BigDecimal totalBaseAmount = null;
        String totalBaseCurrecny = null;
        for (AgencyMemoProductItemGroup itemGroup : itemGroups) {
            if (itemGroup.getAmount() == null) continue;
            BigDecimal amount = itemGroup.getAmount().getValue();
            String currency = itemGroup.getAmount().getCurrency();
            if (amount != null) {
                BigDecimal bigDecimal = totalBaseAmount = totalBaseAmount != null ? totalBaseAmount.add(amount) : amount;
            }
            if (totalBaseCurrecny != null || currency == null) continue;
            totalBaseCurrecny = currency;
        }
        if (totalBaseAmount != null && totalBaseCurrecny != null) {
            Money money = new Money();
            money.setValue(totalBaseAmount);
            money.setCurrency(totalBaseCurrecny);
            return money;
        }
        return null;
    }

    public static BigDecimal calculateItemGroupsEquivalentAmount(Collection<AgencyMemoProductItemGroup> itemGroups) {
        BigDecimal value = null;
        for (AgencyMemoProductItemGroup itemGroup : itemGroups) {
            if (itemGroup.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(itemGroup.getEquivalentAmount()) : itemGroup.getEquivalentAmount();
        }
        return value;
    }

    public static Money calculateEntriesBaseAmount(Collection<AgencyMemoProductEntry> entries) {
        BigDecimal totalBaseAmount = null;
        String totalBaseCurrecny = null;
        for (AgencyMemoProductEntry entry : entries) {
            if (entry.getAmount() == null) continue;
            BigDecimal amount = entry.getAmount().getValue();
            String currency = entry.getAmount().getCurrency();
            if (amount != null) {
                BigDecimal bigDecimal = totalBaseAmount = totalBaseAmount != null ? totalBaseAmount.add(amount) : amount;
            }
            if (totalBaseCurrecny != null || currency == null) continue;
            totalBaseCurrecny = currency;
        }
        if (totalBaseAmount != null && totalBaseCurrecny != null) {
            Money money = new Money();
            money.setValue(totalBaseAmount);
            money.setCurrency(totalBaseCurrecny);
            return money;
        }
        return null;
    }

    public static BigDecimal calculateEntriesEquivalentAmount(Collection<AgencyMemoProductEntry> entries) {
        BigDecimal value = null;
        for (AgencyMemoProductEntry entry : entries) {
            if (entry.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(entry.getEquivalentAmount()) : entry.getEquivalentAmount();
        }
        return value;
    }

    public static Collection<AgencyMemoProductItemGroup> filterItemGroups(Collection<AgencyMemoProductItemGroup> groups, Set<AgencyMemoProductEntryType> types) {
        return AgencyMemoProductHelper.filterItemGroupsByTypes(groups, types);
    }

    private static Collection<AgencyMemoProductItemGroup> filterItemGroupsByTypes(Collection<AgencyMemoProductItemGroup> groups, Set<AgencyMemoProductEntryType> types) {
        if (groups == null) {
            return Collections.emptyList();
        }
        if (types == null) {
            return new ArrayList<AgencyMemoProductItemGroup>(groups);
        }
        ArrayList<AgencyMemoProductItemGroup> filteredGroups = new ArrayList<AgencyMemoProductItemGroup>();
        for (AgencyMemoProductItemGroup group : groups) {
            if (group.getType() == null || !types.contains(group.getType())) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public static Collection<AgencyMemoProductRelatedProductGroup> filterRelatedProductGroups(Collection<AgencyMemoProductRelatedProductGroup> groups, Set<AgencyMemoProductEntryAssociationType> associationTypes, Set<String> relatedProductNumbers) {
        return AgencyMemoProductHelper.filterRelatedProductGroupsByAssociationTypes(AgencyMemoProductHelper.filterRelatedProductGroupsByRelatedProductNumbers(groups, relatedProductNumbers), associationTypes);
    }

    private static Collection<AgencyMemoProductRelatedProductGroup> filterRelatedProductGroupsByAssociationTypes(Collection<AgencyMemoProductRelatedProductGroup> groups, Set<AgencyMemoProductEntryAssociationType> associationTypes) {
        if (groups == null) {
            return Collections.emptyList();
        }
        if (associationTypes == null) {
            return new ArrayList<AgencyMemoProductRelatedProductGroup>(groups);
        }
        ArrayList<AgencyMemoProductRelatedProductGroup> filteredGroups = new ArrayList<AgencyMemoProductRelatedProductGroup>();
        for (AgencyMemoProductRelatedProductGroup group : groups) {
            if (group.getAssociationType() == null || !associationTypes.contains(group.getAssociationType())) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private static Collection<AgencyMemoProductRelatedProductGroup> filterRelatedProductGroupsByRelatedProductNumbers(Collection<AgencyMemoProductRelatedProductGroup> groups, Set<String> relatedProductNumbers) {
        if (groups == null) {
            return Collections.emptyList();
        }
        if (relatedProductNumbers == null) {
            return new ArrayList<AgencyMemoProductRelatedProductGroup>(groups);
        }
        ArrayList<AgencyMemoProductRelatedProductGroup> filteredGroups = new ArrayList<AgencyMemoProductRelatedProductGroup>();
        for (AgencyMemoProductRelatedProductGroup group : groups) {
            if (group.getRelatedProductNumber() == null || !relatedProductNumbers.contains(group.getRelatedProductNumber())) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public static Collection<AgencyMemoProductEntry> filterEntries(Collection<AgencyMemoProductEntry> entries, Set<AgencyMemoProductEntryType> types, Set<String> relatedProductNumbers, Set<AgencyMemoProductEntryAssociationType> associationTypes) {
        return AgencyMemoProductHelper.filterEntriesByTypes(AgencyMemoProductHelper.filterEntriesByRelatedProductNembers(AgencyMemoProductHelper.filterEntriesByAssociationTypes(entries, associationTypes), relatedProductNumbers), types);
    }

    private static Collection<AgencyMemoProductEntry> filterEntriesByTypes(Collection<AgencyMemoProductEntry> entries, Set<AgencyMemoProductEntryType> types) {
        if (entries == null) {
            return Collections.emptyList();
        }
        if (types == null) {
            return new ArrayList<AgencyMemoProductEntry>(entries);
        }
        ArrayList<AgencyMemoProductEntry> filteredEntries = new ArrayList<AgencyMemoProductEntry>();
        for (AgencyMemoProductEntry entry : entries) {
            if (entry.getType() == null || !types.contains(entry.getType())) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    private static Collection<AgencyMemoProductEntry> filterEntriesByRelatedProductNembers(Collection<AgencyMemoProductEntry> entries, Set<String> relatedProductNumbers) {
        if (entries == null) {
            return Collections.emptyList();
        }
        if (relatedProductNumbers == null) {
            return new ArrayList<AgencyMemoProductEntry>(entries);
        }
        ArrayList<AgencyMemoProductEntry> filteredEntries = new ArrayList<AgencyMemoProductEntry>();
        for (AgencyMemoProductEntry entry : entries) {
            if (entry.getRelatedProductNumber() == null || !relatedProductNumbers.contains(entry.getRelatedProductNumber())) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    private static Collection<AgencyMemoProductEntry> filterEntriesByAssociationTypes(Collection<AgencyMemoProductEntry> entries, Set<AgencyMemoProductEntryAssociationType> associationTypes) {
        if (entries == null) {
            return Collections.emptyList();
        }
        if (associationTypes == null) {
            return new ArrayList<AgencyMemoProductEntry>(entries);
        }
        ArrayList<AgencyMemoProductEntry> filteredEntries = new ArrayList<AgencyMemoProductEntry>();
        for (AgencyMemoProductEntry entry : entries) {
            if (entry.getAssociationType() == null || !associationTypes.contains(entry.getAssociationType())) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    public static void updateItemGroups(AgencyMemoProduct product) {
        ArrayList<AgencyMemoProductItemGroup> groups = new ArrayList<AgencyMemoProductItemGroup>();
        List itemGroups = product.getItemGroups();
        for (AgencyMemoProductItemGroup itemGroup : itemGroups) {
            itemGroup.getEntries().clear();
        }
        block1: for (AgencyMemoProductEntry entry : product.getEntries()) {
            for (AgencyMemoProductItemGroup itemGroup : itemGroups) {
                if (entry.getType() != itemGroup.getType()) continue;
                if (!groups.contains(itemGroup)) {
                    groups.add(itemGroup);
                }
                if (itemGroup.getEntries().contains(entry)) continue block1;
                itemGroup.getEntries().add(entry);
                continue block1;
            }
            for (AgencyMemoProductItemGroup group : groups) {
                if (entry.getType() != group.getType()) continue;
                if (group.getEntries().contains(entry)) continue block1;
                group.getEntries().add(entry);
                continue block1;
            }
            AgencyMemoProductItemGroup group = new AgencyMemoProductItemGroup();
            group.setType(entry.getType());
            group.getEntries().add(entry);
            groups.add(group);
        }
        product.getItemGroups().clear();
        product.getItemGroups().addAll(groups);
    }

    public static void updateRelatedProductGroups(AgencyMemoProduct product) {
        ArrayList<AgencyMemoProductRelatedProductGroup> groups = new ArrayList<AgencyMemoProductRelatedProductGroup>();
        List productGroups = product.getRelatedProductGroups();
        for (AgencyMemoProductRelatedProductGroup productGroup : productGroups) {
            productGroup.getEntries().clear();
        }
        block1: for (AgencyMemoProductEntry entry : product.getEntries()) {
            for (AgencyMemoProductRelatedProductGroup productGroup : productGroups) {
                if (entry.getAssociationType() != productGroup.getAssociationType() || entry.getAssociationType() == AgencyMemoProductEntryAssociationType.PRODUCT && !TextUtil.isSame((String)entry.getRelatedProductNumber(), (String)productGroup.getRelatedProductNumber(), (boolean)false, (boolean)false)) continue;
                if (!groups.contains(productGroup)) {
                    groups.add(productGroup);
                }
                if (productGroup.getEntries().contains(entry)) continue block1;
                productGroup.getEntries().add(entry);
                continue block1;
            }
            for (AgencyMemoProductRelatedProductGroup group : groups) {
                if (entry.getAssociationType() != group.getAssociationType() || entry.getAssociationType() == AgencyMemoProductEntryAssociationType.PRODUCT && !TextUtil.isSame((String)entry.getRelatedProductNumber(), (String)group.getRelatedProductNumber(), (boolean)false, (boolean)false)) continue;
                if (group.getEntries().contains(entry)) continue block1;
                group.getEntries().add(entry);
                continue block1;
            }
            AgencyMemoProductRelatedProductGroup group = new AgencyMemoProductRelatedProductGroup();
            group.setAssociationType(entry.getAssociationType());
            group.setRelatedProductNumber(entry.getRelatedProductNumber());
            group.getEntries().add(entry);
            groups.add(group);
        }
        product.getRelatedProductGroups().clear();
        product.getRelatedProductGroups().addAll(groups);
    }

    public static boolean removeProduct(AgencyMemoProduct product) {
        product.getReservation().getProducts().remove(product);
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(AgencyMemoProduct product, BaseProduct relatedProduct) {
        return true;
    }
}

