/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RefexType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.LuggageUnitReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FOPHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.McoCategoriesCodesUtil;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public final class AirProductHelper {
    private static final Pattern tchSpecialSchemePattern = Pattern.compile("([0-9]{2}C)");
    private static final String VOID_VIRTUAL_TICKET_PREFIX = "VOID_TICKET_VIRTUAL:";
    private static final Map<String, List<String>> penaltyTaxesForAirlines = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = -8488992693587584571L;
        {
            this.put(null, Arrays.asList("CP", "OD"));
            this.put("A3", Arrays.asList("DU", "DV"));
            this.put("BT", Arrays.asList("DU"));
            this.put("OK", Arrays.asList("DU"));
        }
    };
    private static final Pattern LUGGAGE_INFO_CHARS_PATTERN = Pattern.compile("[a-zA-Z\u0430-\u044f\u0410-\u042f]+", 2);
    private static final Pattern LUGGAGE_INFO_DIGITS_PATTERN = Pattern.compile("[0-9]+");
    private static final Date date_2018_07_01;
    private static final Date date_2018_10_01;
    private static final Date date_2025_01_01;
    private static final DictionaryReference<GeoRegion> dvfoRegion;
    public static final DictionaryReference<GeoRegion> cisRegion;
    private static final Set<MCOCategory> MCO_Category_Without_Ticket;

    private AirProductHelper() {
    }

    public static int getArmCount(Product product) {
        if (product == null) {
            return 0;
        }
        return AirProductHelper.getArmCount(AirProductHelper.getRouteLine(product));
    }

    public static int getArmCount(String routeLine) {
        if (TextUtil.isBlank((String)routeLine)) {
            return 0;
        }
        String[] tokens = routeLine.split("-");
        return Math.max(0, tokens.length - 1);
    }

    public static String getTicketSeries(Product product) {
        String result = null;
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
        if (blankType != null) {
            result = blankType.getName();
        }
        String number = product.getSystemNumber();
        if (TextUtil.isBlank((String)result) && number != null && number.length() >= 3) {
            result = number.substring(0, 3);
        }
        return result;
    }

    public static BigDecimal getEquivalentFare(Product product) {
        if (product == null) {
            return null;
        }
        List fares = product.getFares();
        if (fares.isEmpty()) {
            return null;
        }
        BigDecimal segmentResult = null;
        BigDecimal productResult = null;
        for (ProductFare fare : fares) {
            BigDecimal equivalentFare = fare.getEquivalentFare();
            if (equivalentFare == null) continue;
            if (fare.getSegmentTariff() == null) {
                productResult = productResult != null ? productResult.add(equivalentFare) : equivalentFare;
                continue;
            }
            segmentResult = segmentResult != null ? segmentResult.add(equivalentFare) : equivalentFare;
        }
        return productResult != null ? productResult : segmentResult;
    }

    public static BigDecimal getEquivalentFeeAmount(Product prod, ContractType ctype) {
        BigDecimal fe = BigDecimal.ZERO;
        for (Commission c : AirProductHelper.getUnmodifiableCommissions(prod, ctype)) {
            BigDecimal value;
            if (c.getCommissionProperties() == null || !FeeProperties.class.getName().equals(c.getCommissionProperties().getType().getName()) || (value = c.getEquivalentAmount()) == null) continue;
            fe = fe.add(value);
        }
        return fe;
    }

    public static CardVendor getCreditCardVendor(Collection<ProductFop> fops) {
        for (ProductFop fop : fops) {
            if (fop.getCard() == null || fop.getCard().getVendor() == null) continue;
            return fop.getCard().getVendor();
        }
        return null;
    }

    public static BigDecimal getTotalEquivalentFare(Product product) {
        BigDecimal equivalentObFeesAmount;
        BigDecimal equivalentTaxAmount;
        BigDecimal totalEquivalentFare = BigDecimal.ZERO;
        if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            return totalEquivalentFare;
        }
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare(product);
        if (equivalentFare != null) {
            totalEquivalentFare = totalEquivalentFare.add(equivalentFare);
        }
        if ((equivalentTaxAmount = AirProductTaxHelper.getEquivalentTaxesAmount(product)) != null) {
            totalEquivalentFare = totalEquivalentFare.add(equivalentTaxAmount);
        }
        if ((equivalentObFeesAmount = AirProductHelper.calculateOBFeesEquivalentAmount(product)) != null) {
            totalEquivalentFare = totalEquivalentFare.add(equivalentObFeesAmount);
        }
        if (product.getPenalty() != null) {
            totalEquivalentFare = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? totalEquivalentFare.subtract(product.getPenalty()) : totalEquivalentFare.add(product.getPenalty());
        }
        return totalEquivalentFare;
    }

    public static BigDecimal getNucFare(Product product) {
        List fares = product.getFares();
        if (fares.isEmpty()) {
            return null;
        }
        BigDecimal segmentResult = null;
        BigDecimal productResult = null;
        for (ProductFare fare : fares) {
            BigDecimal nucFare = fare.getNucFare();
            if (nucFare == null) continue;
            if (fare.getSegmentTariff() == null) {
                productResult = productResult != null ? productResult.add(nucFare) : nucFare;
                continue;
            }
            segmentResult = segmentResult == null ? nucFare : segmentResult.add(nucFare);
        }
        return productResult != null ? productResult : segmentResult;
    }

    public static BigDecimal getNucRoe(Product product) {
        List fares = product.getFares();
        if (fares.isEmpty()) {
            return null;
        }
        for (ProductFare fare : fares) {
            BigDecimal roe = fare.getRoe();
            if (roe == null) continue;
            return roe;
        }
        return null;
    }

    public static String getGdsOrLocalCurrency(Product product) {
        String gdsCurrency = product.getGdsCurrency();
        return gdsCurrency != null ? gdsCurrency : DictHelper.getLocalCurrency();
    }

    public static Money getBaseFare(Product product) {
        String currency = null;
        BigDecimal segmentValue = null;
        BigDecimal productValue = null;
        for (ProductFare fare : product.getFares()) {
            Money money = fare.getBaseFare();
            if (money == null) continue;
            String cur = money.getCurrency();
            BigDecimal val = money.getValue();
            if (cur == null || val == null) continue;
            currency = cur;
            if (fare.getSegmentTariff() == null) {
                productValue = productValue == null ? val : productValue.add(val);
                continue;
            }
            segmentValue = segmentValue == null ? val : segmentValue.add(val);
        }
        if (currency == null) {
            return null;
        }
        Money result = new Money();
        result.setCurrency(currency);
        result.setValue(productValue != null ? productValue : segmentValue);
        return result;
    }

    public static ProductFare getOrCreateFare(Product product, SegmentTariff st) {
        boolean found = false;
        Iterator it = product.getFares().iterator();
        while (it.hasNext()) {
            SegmentTariff productSt = ((ProductFare)it.next()).getSegmentTariff();
            if (st == null && productSt == null) {
                if (found) {
                    it.remove();
                }
                found = true;
            }
            if (st == null || !st.equals((Object)productSt)) continue;
            if (found) {
                it.remove();
            }
            found = true;
        }
        for (ProductFare fare : product.getFares()) {
            if (st == null && fare.getSegmentTariff() == null) {
                return fare;
            }
            if (st == null || !st.equals((Object)fare.getSegmentTariff())) continue;
            return fare;
        }
        ProductFare result = new ProductFare();
        result.setSegmentTariff(st);
        product.getFares().add(result);
        return result;
    }

    public static ProductFare getFare(Product product, SegmentTariff st) {
        for (ProductFare fare : product.getFares()) {
            if (st == null && fare.getSegmentTariff() == null) {
                return fare;
            }
            if (st == null || !st.equals((Object)fare.getSegmentTariff())) continue;
            return fare;
        }
        return null;
    }

    public static Money getSegmentBaseFare(Product product, SegmentTariff st) {
        if (st == null) {
            return AirProductHelper.getBaseFare(product);
        }
        for (ProductFare fare : product.getFares()) {
            if (!st.equals((Object)fare.getSegmentTariff())) continue;
            return fare.getBaseFare();
        }
        return null;
    }

    public static BigDecimal getSegmentEquivalentFare(Product product, SegmentTariff st) {
        if (st == null) {
            return AirProductHelper.getEquivalentFare(product);
        }
        for (ProductFare fare : product.getFares()) {
            if (!st.equals((Object)fare.getSegmentTariff())) continue;
            return fare.getEquivalentFare();
        }
        return null;
    }

    public static BigDecimal getSegmentNucFare(Product product, SegmentTariff st) {
        if (st == null) {
            return AirProductHelper.getNucFare(product);
        }
        for (ProductFare fare : product.getFares()) {
            if (!st.equals((Object)fare.getSegmentTariff())) continue;
            return fare.getNucFare();
        }
        return null;
    }

    public static void setEquivalentFare(Product product, BigDecimal value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, null);
        fare.setEquivalentFare(value);
    }

    public static void setBaseFare(Product product, Money value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, null);
        fare.setBaseFare(value);
    }

    public static void setSegmentEquivalentFare(Product product, SegmentTariff st, BigDecimal value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, st);
        fare.setEquivalentFare(value);
    }

    public static void setNucFare(Product product, BigDecimal value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, null);
        fare.setNucFare(value);
    }

    public static void setNucRoe(Product product, BigDecimal value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, null);
        fare.setRoe(value);
    }

    public static void setSegmentBaseFare(Product product, SegmentTariff st, Money value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, st);
        fare.setBaseFare(value);
    }

    public static void setSegmentNucFare(Product product, SegmentTariff st, BigDecimal value) {
        ProductFare fare = AirProductHelper.getOrCreateFare(product, st);
        fare.setNucFare(value);
    }

    public static String getLocalizedRouteLine(Product product) {
        return AirProductHelper.getLocalizedRouteLine(product.getSegmentTariffs());
    }

    public static String getLocalizedRouteLine(List<SegmentTariff> segmentTariffs) {
        return AirProductHelper.getLocalizedRouteLine(LocaleManager.get().getCurrentLocale(), segmentTariffs);
    }

    public static String getLocalizedRouteLine(Locale locale, List<SegmentTariff> segmentTariffs) {
        return AirProductHelper.getRouteLine(segmentTariffs, locale, false, CodeSystem.IATA);
    }

    public static Date getFlightDate(Product product) {
        List segmentTariffs = product.getSegmentTariffs();
        if (segmentTariffs.isEmpty()) {
            return null;
        }
        List segments = ((SegmentTariff)segmentTariffs.get(0)).getSegments();
        if (segments.isEmpty()) {
            return null;
        }
        return ((Segment)segments.get(0)).getStartDate();
    }

    public static String getRouteLine(Product product) {
        return AirProductHelper.getRouteLine(product, null, true, CodeSystem.IATA);
    }

    private static String getRouteLineSeparator(boolean onlyCodes) {
        return onlyCodes ? "-" : " - ";
    }

    public static String getRouteLine(Product product, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        return AirProductHelper.getRouteLine(product.getSegmentTariffs(), loc, onlyCodes, codeSystem);
    }

    public static String getRouteLine(List<SegmentTariff> segmentTariffs, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        String prevCityCode = null;
        for (SegmentTariff st : segmentTariffs) {
            for (Segment seg : st.getSegments()) {
                String curCityCode;
                GeoLocation departureLocation = AirProductHelper.getGeoLocation((DictionaryReference<GeoLocation>)seg.getDepartureLocation(), seg.getDepartCityCode());
                GeoLocation arriveLocation = AirProductHelper.getGeoLocation((DictionaryReference<GeoLocation>)seg.getArriveLocation(), seg.getArriveCityCode());
                departureLocation = DictHelper.findCityByAirport(departureLocation != null ? departureLocation.getCode() : null);
                arriveLocation = DictHelper.findCityByAirport(arriveLocation != null ? arriveLocation.getCode() : null);
                if (first) {
                    curCityCode = DictHelper.getCityCode(arriveLocation, seg.getArriveCityCode());
                    result.append(DictHelper.getCityName(departureLocation, loc, seg.getDepartCityCode(), onlyCodes, codeSystem));
                    result.append(AirProductHelper.getRouteLineSeparator(onlyCodes));
                    result.append(DictHelper.getCityName(arriveLocation, loc, seg.getArriveCityCode(), onlyCodes, codeSystem));
                    prevCityCode = curCityCode;
                    first = false;
                    continue;
                }
                curCityCode = DictHelper.getCityCode(departureLocation, seg.getDepartCityCode());
                if (!TextUtil.isSame(prevCityCode, (String)curCityCode)) {
                    result.append("//");
                    result.append(DictHelper.getCityName(departureLocation, loc, seg.getDepartCityCode(), onlyCodes, codeSystem));
                }
                result.append(AirProductHelper.getRouteLineSeparator(onlyCodes));
                prevCityCode = DictHelper.getCityCode(arriveLocation, seg.getArriveCityCode());
                result.append(DictHelper.getCityName(arriveLocation, loc, seg.getArriveCityCode(), onlyCodes, codeSystem));
            }
        }
        return result.toString();
    }

    public static String getRouteDescription(Product product, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                if (seg.getAirline() != null) {
                    result.append(seg.getAirline().getCode());
                }
                if (TextUtil.nonBlank((String)seg.getFlightNo())) {
                    result.append(seg.getFlightNo());
                }
                result.append(" ");
                GeoLocation departureLocation = AirProductHelper.getGeoLocation((DictionaryReference<GeoLocation>)seg.getDepartureLocation(), seg.getDepartCityCode());
                GeoLocation arriveLocation = AirProductHelper.getGeoLocation((DictionaryReference<GeoLocation>)seg.getArriveLocation(), seg.getArriveCityCode());
                departureLocation = DictHelper.findCityByAirport(departureLocation != null ? departureLocation.getCode() : null);
                arriveLocation = DictHelper.findCityByAirport(arriveLocation != null ? arriveLocation.getCode() : null);
                result.append(DictHelper.getCityName(departureLocation, loc, seg.getDepartCityCode(), onlyCodes, codeSystem));
                result.append(AirProductHelper.getRouteLineSeparator(onlyCodes));
                result.append(DictHelper.getCityName(arriveLocation, loc, seg.getArriveCityCode(), onlyCodes, codeSystem)).append(" ");
                SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                if (seg.getStartDate() != null) {
                    result.append(f.format(seg.getStartDate()));
                }
                result.append(" - ");
                if (seg.getEndDate() == null) continue;
                result.append(f.format(seg.getEndDate()));
            }
        }
        return result.toString();
    }

    public static GeoLocationReference getGeoLocationReference(DictionaryReference<GeoLocation> reference, String code) {
        GeoLocation location = DictHelper.findCityByAirport(DictHelper.getCode(AirProductHelper.getGeoLocation(reference, code)));
        if (location == null) {
            return new GeoLocationReference(code);
        }
        return location.toReference();
    }

    public static GeoLocation getGeoLocation(DictionaryReference<GeoLocation> reference, String code) {
        Set lcs;
        GeoLocation res = (GeoLocation)DictionaryCache.get().resolveReference(reference);
        if (res == null && CollectionUtil.isNotEmpty((Collection)(lcs = DictionaryCache.get().lookup(GeoLocation.class, code, new String[0])))) {
            res = (GeoLocation)lcs.iterator().next();
        }
        return res;
    }

    public static String getRouteLineWithFlightNum(Product product, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        String prevCityCode = null;
        DictionaryCache cache = DictionaryCache.get();
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                String curCityCode;
                Set lcs;
                GeoLocation arriveLocation;
                Set lcs2;
                GeoLocation departureLocation = (GeoLocation)cache.resolveReference(seg.getDepartureLocation());
                if (departureLocation == null && !(lcs2 = cache.lookup(GeoLocation.class, seg.getDepartCityCode(), new String[0])).isEmpty()) {
                    departureLocation = (GeoLocation)lcs2.iterator().next();
                }
                if ((arriveLocation = (GeoLocation)cache.resolveReference(seg.getArriveLocation())) == null && !(lcs = cache.lookup(GeoLocation.class, seg.getArriveCityCode(), new String[0])).isEmpty()) {
                    arriveLocation = (GeoLocation)lcs.iterator().next();
                }
                departureLocation = DictHelper.findCityByAirport(departureLocation != null ? departureLocation.getCode() : null);
                arriveLocation = DictHelper.findCityByAirport(arriveLocation != null ? arriveLocation.getCode() : null);
                if (first) {
                    curCityCode = DictHelper.getCityCode(arriveLocation, seg.getArriveCityCode());
                    result.append(seg.getFlightNo()).append(" ");
                    result.append(DictHelper.getCityName(departureLocation, loc, seg.getDepartCityCode(), onlyCodes, codeSystem));
                    result.append(AirProductHelper.getRouteLineSeparator(onlyCodes));
                    result.append(DictHelper.getCityName(arriveLocation, loc, seg.getArriveCityCode(), onlyCodes, codeSystem));
                    prevCityCode = curCityCode;
                    first = false;
                    continue;
                }
                curCityCode = DictHelper.getCityCode(departureLocation, seg.getDepartCityCode());
                if (!TextUtil.isSame(prevCityCode, (String)curCityCode)) {
                    result.append("//");
                    result.append(DictHelper.getCityName(departureLocation, loc, seg.getDepartCityCode(), onlyCodes, codeSystem));
                }
                result.append(AirProductHelper.getRouteLineSeparator(onlyCodes));
                prevCityCode = DictHelper.getCityCode(arriveLocation, seg.getArriveCityCode());
                result.append(DictHelper.getCityName(arriveLocation, loc, seg.getArriveCityCode(), onlyCodes, codeSystem));
            }
        }
        return result.toString();
    }

    public static String getRouteLineBySegment(Product product, Locale loc, boolean onlyCodes, CodeSystem codeSystem, int segmentNumber) {
        StringBuilder result = new StringBuilder();
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (seg.getRecordNumber() != segmentNumber) continue;
                result.append(AirProductHelper.getRouteLineBySegment(seg, loc, onlyCodes, codeSystem));
            }
        }
        return result.toString();
    }

    public static String getLocalizedRouteLineBySegment(Segment seg) {
        return AirProductHelper.getRouteLineBySegment(seg, LocaleManager.get().getCurrentLocale(), false, CodeSystem.IATA);
    }

    public static String getRouteLineBySegment(Segment seg, Locale loc, boolean onlyCodes, CodeSystem codeSystem) {
        Set lcs;
        GeoLocation arriveLocation;
        Set lcs2;
        StringBuilder result = new StringBuilder();
        DictionaryCache cache = DictionaryCache.get();
        GeoLocation departureLocation = (GeoLocation)cache.resolveReference(seg.getDepartureLocation());
        if (departureLocation == null && !(lcs2 = cache.lookup(GeoLocation.class, seg.getDepartCityCode(), new String[0])).isEmpty()) {
            departureLocation = (GeoLocation)lcs2.iterator().next();
        }
        if ((arriveLocation = (GeoLocation)cache.resolveReference(seg.getArriveLocation())) == null && !(lcs = cache.lookup(GeoLocation.class, seg.getArriveCityCode(), new String[0])).isEmpty()) {
            arriveLocation = (GeoLocation)lcs.iterator().next();
        }
        departureLocation = DictHelper.findCityByAirport(departureLocation != null ? departureLocation.getCode() : null);
        arriveLocation = DictHelper.findCityByAirport(arriveLocation != null ? arriveLocation.getCode() : null);
        result.append(DictHelper.getCityName(departureLocation, loc, seg.getDepartCityCode(), onlyCodes, codeSystem));
        result.append(AirProductHelper.getRouteLineSeparator(onlyCodes));
        result.append(DictHelper.getCityName(arriveLocation, loc, seg.getArriveCityCode(), onlyCodes, codeSystem));
        return result.toString();
    }

    public static boolean isHasVat(Product product) {
        if (product == null) {
            return false;
        }
        Product prod = product;
        if ((product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) && (prod = product.getPreviousProduct()) == null) {
            prod = product;
        }
        boolean hasDomestic = false;
        boolean hasInternational = false;
        boolean after20180101 = prod.getIssueDate() != null && prod.getIssueDate().after(date_2018_07_01);
        boolean after20181001 = prod.getIssueDate() != null && prod.getIssueDate().after(date_2018_10_01);
        boolean before20250101 = prod.getIssueDate() != null && prod.getIssueDate().before(date_2025_01_01);
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                boolean arrivalIsDomestic;
                DictionaryReference arriveLocation = seg.getArriveLocation();
                DictionaryReference departureLocation = seg.getDepartureLocation();
                String arrive = arriveLocation != null ? arriveLocation.getCode() : null;
                String depart = departureLocation != null ? departureLocation.getCode() : null;
                Country arriveCountry = DictHelper.findCountry(arrive);
                Country departCountry = DictHelper.findCountry(depart);
                if (arriveCountry == null || departCountry == null) continue;
                boolean departureIsDomestic = !(!departCountry.isDomestic() || before20250101 && AirProductHelper.isCrimea((DictionaryReference<GeoLocation>)departureLocation) || before20250101 && after20180101 && AirProductHelper.isKaliningrad((DictionaryReference<GeoLocation>)departureLocation) || before20250101 && after20181001 && AirProductHelper.isDVFO((DictionaryReference<GeoLocation>)departureLocation));
                boolean bl = arrivalIsDomestic = !(!arriveCountry.isDomestic() || before20250101 && AirProductHelper.isCrimea((DictionaryReference<GeoLocation>)arriveLocation) || before20250101 && after20180101 && AirProductHelper.isKaliningrad((DictionaryReference<GeoLocation>)arriveLocation) || before20250101 && after20181001 && AirProductHelper.isDVFO((DictionaryReference<GeoLocation>)arriveLocation));
                if (departureIsDomestic && arrivalIsDomestic) {
                    hasDomestic = true;
                    continue;
                }
                hasInternational = true;
            }
        }
        return hasDomestic && !hasInternational;
    }

    public static boolean isCrimea(DictionaryReference<GeoLocation> loc) {
        if (loc == null) {
            return false;
        }
        return "SIP".equals(loc.getCode()) || "airport SIP".equals(loc.getCode()) || "\u0421\u0435\u0432\u0430\u0441\u0442\u043e\u043f\u043e\u043b\u044c".equals(loc.getCode()) || "UKS".equals(loc.getCode()) || "airport UKS".equals(loc.getCode());
    }

    public static boolean isKaliningrad(DictionaryReference<GeoLocation> loc) {
        if (loc == null) {
            return false;
        }
        return "KGD".equals(loc.getCode()) || "airport KGD".equals(loc.getCode());
    }

    public static boolean isMoscow(DictionaryReference<GeoLocation> loc) {
        if (loc == null) {
            return false;
        }
        String code = DictHelper.getCodeVariant(loc, CodeSystem.IATA);
        if (code == null) {
            code = loc.getCode();
        }
        return "DME".equals(code) || "\u0414\u041c\u041e".equals(code) || "airport DME".equals(code) || "VKO".equals(code) || "airport VKO".equals(code) || "SVO".equals(code) || "airport SVO".equals(code) || "ZIA".equals(code) || "airport ZIA".equals(code) || "MOW".equals(code);
    }

    public static boolean isCISWithoutDomestic(DictionaryReference<GeoLocation> locRef) {
        if (locRef == null) {
            return false;
        }
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (loc == null) {
            return false;
        }
        DictionaryReference dictCountry = loc.getCountry();
        if (dictCountry == null) {
            return false;
        }
        Country country = (Country)DictionaryCache.get().resolveReference(dictCountry);
        if (country == null) {
            return false;
        }
        if (country.isDomestic()) {
            return false;
        }
        return country.getRegions().contains(cisRegion);
    }

    public static boolean isCIS(DictionaryReference<GeoLocation> locRef) {
        if (locRef == null) {
            return false;
        }
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (loc == null) {
            return false;
        }
        DictionaryReference dictCountry = loc.getCountry();
        if (dictCountry == null) {
            return false;
        }
        Country country = (Country)DictionaryCache.get().resolveReference(dictCountry);
        if (country == null) {
            return false;
        }
        return country.getRegions().contains(cisRegion);
    }

    public static boolean isDVFO(DictionaryReference<GeoLocation> locRef) {
        return AirProductHelper.isDVFO(locRef, new HashSet<DictionaryReference<GeoLocation>>());
    }

    private static boolean isDVFO(DictionaryReference<GeoLocation> locRef, Set<DictionaryReference<GeoLocation>> processed) {
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (loc == null) {
            return false;
        }
        if (loc.getRegions().contains(dvfoRegion)) {
            return true;
        }
        if (loc.getParent() == null) {
            return false;
        }
        if (processed.contains(loc.getParent())) {
            return false;
        }
        processed.add(locRef);
        return AirProductHelper.isDVFO((DictionaryReference<GeoLocation>)loc.getParent(), processed);
    }

    public static boolean isRouteContainCrimea(Product product) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!AirProductHelper.isCrimea((DictionaryReference<GeoLocation>)seg.getDepartureLocation()) && !AirProductHelper.isCrimea((DictionaryReference<GeoLocation>)seg.getArriveLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRouteContainsKaliningrad(Product product) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!AirProductHelper.isKaliningrad((DictionaryReference<GeoLocation>)seg.getDepartureLocation()) && !AirProductHelper.isKaliningrad((DictionaryReference<GeoLocation>)seg.getArriveLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRouteContainsDVFO(Product product) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!AirProductHelper.isDVFO((DictionaryReference<GeoLocation>)seg.getDepartureLocation()) && !AirProductHelper.isDVFO((DictionaryReference<GeoLocation>)seg.getArriveLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRouteContainsCIS(Product product) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!AirProductHelper.isCIS((DictionaryReference<GeoLocation>)seg.getDepartureLocation()) && !AirProductHelper.isCIS((DictionaryReference<GeoLocation>)seg.getArriveLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRouteContainsCISWithoutDomestic(Product product) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!AirProductHelper.isCISWithoutDomestic((DictionaryReference<GeoLocation>)seg.getDepartureLocation()) && !AirProductHelper.isCISWithoutDomestic((DictionaryReference<GeoLocation>)seg.getArriveLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLocationInCountry(DictionaryReference<GeoLocation> locationRef, String countryCode) {
        if (TextUtil.isBlank((String)countryCode)) {
            return false;
        }
        String locationCode = locationRef != null ? locationRef.getCode() : null;
        Country country = DictHelper.findCountry(locationCode);
        return country != null && countryCode.equals(country.getCode());
    }

    public static boolean isInRegion(Product product, GeoLocation region) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!DictHelper.getCodeVariants((DictionaryReference<GeoLocation>)seg.getDepartureLocation(), Collections.singletonList(CodeSystem.IATA), false, false, true).contains(region.getCode()) && !DictHelper.getCodeVariants((DictionaryReference<GeoLocation>)seg.getArriveLocation(), Collections.singletonList(CodeSystem.IATA), false, false, true).contains(region.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public static TransportationType calculateTransportationType(Product product) {
        boolean hasDomestic = false;
        boolean hasInternational = false;
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                DictionaryReference arriveLocation = seg.getArriveLocation();
                DictionaryReference departureLocation = seg.getDepartureLocation();
                String arrive = arriveLocation != null ? arriveLocation.getCode() : null;
                String depart = departureLocation != null ? departureLocation.getCode() : null;
                Country arriveCountry = DictHelper.findCountry(arrive);
                Country departCountry = DictHelper.findCountry(depart);
                if (arriveCountry == null || departCountry == null) continue;
                if (departCountry.isDomestic() && arriveCountry.isDomestic()) {
                    hasDomestic = true;
                    continue;
                }
                hasInternational = true;
            }
        }
        if (!hasDomestic && !hasInternational) {
            return TransportationType.NONE;
        }
        if (hasDomestic && !hasInternational) {
            return TransportationType.DOMESTIC;
        }
        return TransportationType.INTERNATIONAL;
    }

    public static Product findRelatedAirProduct(Product mco, ProductStatus status, boolean ignorePtaMco) {
        return AirProductHelper.findRelatedAirProduct(mco, status, ignorePtaMco, true);
    }

    public static Product findRelatedAirProduct(Product mco, ProductStatus status, boolean ignorePtaMco, boolean ignoreBusTicketMco) {
        boolean isAppropriateProduct;
        for (Product prod : mco.getRelatedProducts()) {
            boolean bl = isAppropriateProduct = prod.getProductCategory() == ProductCategory.AIR;
            if (prod.getProductCategory() == ProductCategory.MCO) {
                isAppropriateProduct |= !ignorePtaMco && prod.getMcoCategory() == MCOCategory.PTA;
                isAppropriateProduct |= !ignoreBusTicketMco && prod.getMcoCategory() == MCOCategory.BUS_TICKET;
                isAppropriateProduct |= prod.getMcoCategory() == MCOCategory.DEPOSIT;
            }
            if (!isAppropriateProduct || status != null && status != prod.getStatus()) continue;
            return prod;
        }
        for (Product prod : mco.getRelatedProducts()) {
            Product rp2;
            isAppropriateProduct = prod.getProductCategory() == ProductCategory.MCO;
            isAppropriateProduct &= !ignorePtaMco || prod.getMcoCategory() != MCOCategory.PTA;
            if (!(isAppropriateProduct &= !ignoreBusTicketMco || prod.getMcoCategory() != MCOCategory.BUS_TICKET) || (rp2 = AirProductHelper.findRelatedAirProduct(prod, status, ignorePtaMco)) == null) continue;
            return rp2;
        }
        return null;
    }

    public static boolean isGroupTicket(Product ticket) {
        if (ticket.getTariffType() == TariffType.BLOCKCHARTER) {
            return true;
        }
        return ticket.getTariffType() == TariffType.CHARTER;
    }

    public static BigDecimal calculateFareRate(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        Money baseFare = AirProductHelper.getBaseFare(product);
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare(product);
        if (baseFare != null && equivalentFare != null && baseFare.getValue().compareTo(BigDecimal.ZERO) != 0) {
            result = equivalentFare.divide(baseFare.getValue(), 5, RoundingMode.HALF_UP);
            if (!baseFare.getCurrency().equals("USD") && !baseFare.getCurrency().equals("EUR")) {
                return result;
            }
        }
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            return result;
        }
        long round = Math.round(result.doubleValue());
        double delta = (double)round - result.doubleValue();
        if (Math.abs(delta) > (double)0.2f) {
            if (delta > 0.0) {
                return BigDecimal.valueOf((float)round - 0.5f);
            }
            if (delta < 0.0) {
                return BigDecimal.valueOf((float)round + 0.5f);
            }
        }
        return BigDecimal.valueOf(round);
    }

    public static BigDecimal calculateS7Rate(Product product) {
        Money baseFare = AirProductHelper.getBaseFare(product);
        if (baseFare != null && baseFare.getCurrency() != null && baseFare.getCurrency().equals(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB"))) {
            return BigDecimal.ONE;
        }
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare(product);
        if (equivalentFare == null || baseFare == null || baseFare.getValue() == null || baseFare.getValue().doubleValue() == 0.0) {
            return null;
        }
        BigDecimal result = baseFare.getValue().compareTo(equivalentFare) <= 0 ? equivalentFare.divide(baseFare.getValue(), 2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(0.5), 0, RoundingMode.DOWN).multiply(BigDecimal.valueOf(0.5)) : equivalentFare.divide(baseFare.getValue(), 5, RoundingMode.HALF_UP);
        return result;
    }

    public static String[] getConjunctions(Product product) {
        if (product == null) {
            return new String[0];
        }
        int conjCount = product.getConjCount();
        String systemNumber = product.getSystemNumber();
        if (TextUtil.isBlank((String)systemNumber) || conjCount == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < conjCount; ++i) {
            result.add(FormattedNumberUtil.add((String)systemNumber, (long)(i + 1)));
        }
        return result.toArray(new String[0]);
    }

    public static String[] getConjunctionsScns(Product product) {
        if (product == null || product.getScns() == null || product.getScns().isEmpty()) {
            return new String[0];
        }
        int conjCount = product.getConjCount();
        String scn = (String)product.getScns().get(0);
        if (TextUtil.isBlank((String)scn) || conjCount == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < conjCount; ++i) {
            result.add(FormattedNumberUtil.add((String)scn, (long)(i + 1)));
        }
        return result.toArray(new String[0]);
    }

    public static Collection<Product> getMcoByRelatedProduct(Product product) {
        if (product == null) {
            return Collections.emptySet();
        }
        Reservation reservation = product.getReservation();
        if (reservation == null) {
            return Collections.emptySet();
        }
        BookingFile bookingFile = reservation.getBookingFile();
        if (bookingFile == null) {
            return Collections.emptySet();
        }
        String uid = product.getUid();
        HashSet<Product> result = new HashSet<Product>();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                Product product2;
                if (!(prod instanceof Product) || prod.getUid().equals(uid) || (product2 = (Product)prod).getProductCategory() != ProductCategory.MCO) continue;
                for (Product prod2 : product2.getRelatedProducts()) {
                    if (!uid.equals(prod2.getUid())) continue;
                    result.add(product2);
                }
            }
        }
        return result;
    }

    public static Collection<Product> getDuplicateByRelatedProduct(Product product) {
        if (product == null) {
            return Collections.emptySet();
        }
        Reservation reservation = product.getReservation();
        if (reservation == null) {
            return Collections.emptySet();
        }
        BookingFile bookingFile = reservation.getBookingFile();
        if (bookingFile == null) {
            return Collections.emptySet();
        }
        String uid = product.getUid();
        HashSet<Product> result = new HashSet<Product>();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                Product product2;
                if (!(prod instanceof Product) || prod.getUid().equals(uid) || !(product2 = (Product)prod).isDuplicate()) continue;
                for (Product prod2 : product2.getRelatedProducts()) {
                    if (!uid.equals(prod2.getUid())) continue;
                    result.add(product2);
                }
            }
        }
        return result;
    }

    public static Product clone(Product product) throws Exception {
        Product newProduct = new Product();
        AirProductHelper.copy(product, newProduct, true);
        return newProduct;
    }

    public static Product clone(Product product, boolean keepReservation) throws Exception {
        Product newProduct = new Product();
        AirProductHelper.copy(product, newProduct, keepReservation);
        return newProduct;
    }

    public static void copy(Product source, Product target, boolean keepReservation) throws Exception {
        StatisticalData sourceStatisticalData;
        if (source == null || target == null) {
            return;
        }
        Product sourcePrevProduct = source.getPreviousProduct();
        Product sourceNextProduct = source.getNextProduct();
        Product targetPrevProduct = target.getPreviousProduct();
        Product targetNextProduct = target.getNextProduct();
        List targetRelatedProducts = target.getRelatedProducts();
        source.setPreviousProduct(null);
        source.setNextProduct(null);
        Reservation reservation = source.getReservation();
        Traveller traveller = source.getTraveller();
        source.setReservation(null);
        source.setTraveller(null);
        ArrayList relatedProducts = new ArrayList(source.getRelatedProducts());
        source.getRelatedProducts().clear();
        EntityReference cashier = source.getCashier();
        EntityReference salesPoint = source.getSalesPoint();
        EntityReference<Organization> subagency = AirProductHelper.getSubagency(source);
        EntityReference<Organization> agency = AirProductHelper.getAgency(source);
        EntityReference<Organization> supplier = AirProductHelper.getSupplier(source);
        EntityReference<Organization> technicalProvider = AirProductHelper.getTechnicalProvider(source);
        HashSet<String> excludedUids = new HashSet<String>();
        if (traveller != null) {
            excludedUids.add(traveller.getUid());
        }
        if ((sourceStatisticalData = source.getStatisticalData()) != null) {
            sourceStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        StatisticalData targetStatisticalData = (StatisticalData)XCloneHelper.clone((XCloneable)source.getStatisticalData(), (boolean)true, excludedUids);
        source.setStatisticalData(null);
        HashMap<String, String> uidsMapping = new HashMap<String, String>();
        XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true, uidsMapping);
        source.setStatisticalData(sourceStatisticalData);
        target.setStatisticalData(targetStatisticalData);
        source.getRelatedProducts().addAll(relatedProducts);
        target.setReservation(reservation);
        source.setReservation(reservation);
        target.setTraveller(traveller);
        source.setTraveller(traveller);
        source.setPreviousProduct(sourcePrevProduct);
        source.setNextProduct(sourceNextProduct);
        if (keepReservation && source.getReservation() != null && !source.getReservation().getProducts().contains(target)) {
            source.getReservation().getProducts().add(target);
        }
        target.setNextProduct(targetNextProduct);
        target.setPreviousProduct(targetPrevProduct);
        target.getRelatedProducts().clear();
        target.getRelatedProducts().addAll(targetRelatedProducts);
        target.setIssueDate(source.getIssueDate());
        target.setSystemNumber(source.getSystemNumber());
        target.setCashier(cashier);
        target.setSalesPoint(salesPoint);
        if (target.getVendorVatDetalization() != null) {
            FOPHelper.updateTaxesUids(target.getVendorVatDetalization().getComponents(), uidsMapping);
        }
        AirProductHelper.setSubagency(target, subagency);
        AirProductHelper.setAgency(target, agency);
        AirProductHelper.setSupplier(target, supplier);
        AirProductHelper.setTechnicalProvider(target, technicalProvider);
        for (AirProductContractRelationData contractRelation : AirProductHelper.getContractRelations(target)) {
            if (contractRelation.getServiceData().getDetalization().getVat() == null) continue;
            FOPHelper.updateTaxesUids(contractRelation.getServiceData().getDetalization().getVat().getComponents(), uidsMapping);
        }
        target.setCompleted(false);
        target.getShipments().clear();
        target.getPrepaymentDocuments().clear();
        target.getFopDetalizations().clear();
    }

    public static FopType getFopType(ProductFop fop) {
        FopType fopType = null;
        if (AirProductHelper.isServiceFop(fop)) {
            fopType = FopType.PRODUCT;
        } else {
            for (Commission commission : fop.getCommissions()) {
                if (fopType == null && commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && GeneralProductHelper.serviceFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.SERVICE;
                }
                if (commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.PAYMENT;
                    break;
                }
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !GeneralProductHelper.discountDiscountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                fopType = FopType.DISCOUNT;
                break;
            }
        }
        return fopType;
    }

    public static void checkFares(Product prod, EntityContainer<Organization> blankOwner, List<ValidationMessage> messages) {
        String carrierCode;
        BigDecimal segmentEquiveFare = null;
        BigDecimal segmentBaseFare = null;
        BigDecimal segmentRoundedEquiveFare = null;
        BigDecimal segmentRoundedBaseFare = null;
        BigDecimal productBaseFare = null;
        BigDecimal productEquiveFare = null;
        boolean hasDifferentCurrencies = false;
        String currency = null;
        for (ProductFare fare : prod.getFares()) {
            Money baseFare;
            if (fare.getSegmentTariff() == null) {
                if (fare.getEquivalentFare() != null) {
                    BigDecimal bigDecimal = productEquiveFare = productEquiveFare != null ? productEquiveFare.add(fare.getEquivalentFare()) : fare.getEquivalentFare();
                }
                if (fare.getBaseFare() == null) continue;
                baseFare = fare.getBaseFare();
                if (baseFare.getCurrency() != null) {
                    if (currency != null && !currency.equals(baseFare.getCurrency())) {
                        hasDifferentCurrencies = true;
                    }
                    currency = baseFare.getCurrency();
                }
                if (baseFare.getValue() == null) continue;
                productBaseFare = productBaseFare != null ? productBaseFare.add(baseFare.getValue()) : baseFare.getValue();
                continue;
            }
            if (fare.getEquivalentFare() != null) {
                segmentEquiveFare = segmentEquiveFare != null ? segmentEquiveFare.add(fare.getEquivalentFare()) : fare.getEquivalentFare();
                segmentRoundedEquiveFare = (BigDecimal)MiscUtil.guarded((Object)segmentEquiveFare, (Object)fare.getEquivalentFare().setScale(0, RoundingMode.DOWN));
            }
            if (fare.getBaseFare() == null) continue;
            baseFare = fare.getBaseFare();
            if (baseFare.getCurrency() != null) {
                if (currency != null && !currency.equals(baseFare.getCurrency())) {
                    hasDifferentCurrencies = true;
                }
                currency = baseFare.getCurrency();
            }
            if (baseFare.getValue() == null) continue;
            BigDecimal addValue = baseFare.getValue().setScale(2, RoundingMode.HALF_UP);
            segmentBaseFare = segmentBaseFare != null ? segmentBaseFare.add(addValue) : addValue;
            segmentRoundedBaseFare = (BigDecimal)MiscUtil.guarded((Object)segmentBaseFare, (Object)addValue.setScale(0, RoundingMode.DOWN));
        }
        boolean S7 = blankOwner != null && ((Organization)blankOwner.getEntity()).getAirline() != null && "S7".equals(((Organization)blankOwner.getEntity()).getAirline().getCode());
        String string = carrierCode = prod.getCarrier() != null ? prod.getCarrier().getCode() : null;
        if (hasDifferentCurrencies) {
            messages.add(ValidationMessageHelper.createValidationMessage(S7 ? StandartValidationMessageType.APH_FARES_DIFF_CURRENCIES_S7 : StandartValidationMessageType.APH_FARES_DIFF_CURRENCIES_ALL));
        }
        if ("SU".equals(carrierCode)) {
            if (segmentEquiveFare != null) {
                segmentEquiveFare = MiscUtil.up((BigDecimal)segmentEquiveFare, (BigDecimal)BigDecimal.valueOf(5.0));
            }
            if (segmentBaseFare != null) {
                segmentBaseFare = MiscUtil.up(segmentBaseFare, (BigDecimal)BigDecimal.valueOf(5.0));
            }
        }
        if (!(AirProductHelper.isExchangeWithFakeFirstSell(prod) || productEquiveFare == null || segmentEquiveFare == null || AirProductHelper.isEquivalentFareValid(prod, productEquiveFare, segmentEquiveFare) || segmentRoundedEquiveFare.compareTo(segmentEquiveFare) != 0 && AirProductHelper.isEquivalentFareValid(prod, productEquiveFare, segmentRoundedEquiveFare))) {
            if (AirProductHelper.isPartialExchangeTicket(prod)) {
                segmentEquiveFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{segmentEquiveFare, AirProductHelper.getNotExchangedEquiveFare(prod)});
                segmentRoundedEquiveFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{segmentRoundedEquiveFare, AirProductHelper.getNotExchangedEquiveFare(prod)});
            }
            if (!(AirProductHelper.isEquivalentFareValid(prod, productEquiveFare, segmentEquiveFare) || segmentRoundedEquiveFare.compareTo(segmentEquiveFare) != 0 && AirProductHelper.isEquivalentFareValid(prod, productEquiveFare, segmentRoundedEquiveFare))) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)(S7 ? StandartValidationMessageType.APH_WRONG_SEGMENT_EQUIVALENT_FARE_S7 : StandartValidationMessageType.APH_WRONG_SEGMENT_EQUIVALENT_FARE_ALL), productEquiveFare, segmentEquiveFare));
            }
        }
        if (!(AirProductHelper.isExchangeWithFakeFirstSell(prod) || productBaseFare == null || segmentBaseFare == null || AirProductHelper.isBaseFareValid(prod, productBaseFare, segmentBaseFare) || segmentRoundedBaseFare.compareTo(segmentBaseFare) != 0 && AirProductHelper.isBaseFareValid(prod, productBaseFare, segmentRoundedBaseFare))) {
            if (AirProductHelper.isPartialExchangeTicket(prod)) {
                segmentBaseFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{segmentBaseFare, AirProductHelper.getNotExchangedBaseFare(prod)});
                segmentRoundedBaseFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{segmentRoundedBaseFare, AirProductHelper.getNotExchangedBaseFare(prod)});
            }
            if (!(AirProductHelper.isBaseFareValid(prod, productBaseFare, segmentBaseFare) || segmentRoundedBaseFare.compareTo(segmentBaseFare) != 0 && AirProductHelper.isBaseFareValid(prod, productBaseFare, segmentRoundedBaseFare))) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)(S7 ? StandartValidationMessageType.APH_WRONG_SEGMENT_BASE_FARE_S7 : StandartValidationMessageType.APH_WRONG_SEGMENT_BASE_FARE_ALL), productBaseFare, segmentBaseFare));
            }
        }
    }

    private static List<ProductFare> getNotExchangeFares(Product prod) {
        ArrayList<ProductFare> result = new ArrayList<ProductFare>();
        List exchangedSegmentsNumbers = prod.getPreviousProduct().getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(Segment::getRecordNumber).collect(Collectors.toList());
        block0: for (ProductFare firstSellFare : prod.getPreviousProduct().getPreviousProduct().getFares()) {
            if (firstSellFare.getSegmentTariff() == null) continue;
            for (Segment segmentOfFirstSellFare : firstSellFare.getSegmentTariff().getSegments()) {
                if (exchangedSegmentsNumbers.contains(segmentOfFirstSellFare.getRecordNumber())) continue;
                result.add(firstSellFare);
                continue block0;
            }
        }
        return result;
    }

    private static BigDecimal getNotExchangedEquiveFare(Product prod) {
        BigDecimal result = null;
        for (ProductFare notExchangeFare : AirProductHelper.getNotExchangeFares(prod)) {
            if (notExchangeFare.getEquivalentFare() == null) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, notExchangeFare.getEquivalentFare()});
        }
        return result;
    }

    private static BigDecimal getNotExchangedBaseFare(Product prod) {
        BigDecimal result = null;
        for (ProductFare notExchangeFare : AirProductHelper.getNotExchangeFares(prod)) {
            Money baseFare;
            if (notExchangeFare.getBaseFare() == null || (baseFare = notExchangeFare.getBaseFare()) == null) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, baseFare.getValue()});
        }
        return result;
    }

    private static boolean isBaseFareValid(Product product, BigDecimal baseFare, BigDecimal segmentFare) {
        if (AirProductHelper.isFareBasisWithDiscount(product)) {
            return AirProductHelper.checkFareValidWithDiscount(baseFare, segmentFare);
        }
        return baseFare.subtract(segmentFare).abs().compareTo(BigDecimal.valueOf(0.1)) <= 0;
    }

    private static boolean isEquivalentFareValid(Product product, BigDecimal equivalentFare, BigDecimal segmentFare) {
        if (AirProductHelper.isFareBasisWithDiscount(product)) {
            return AirProductHelper.checkFareValidWithDiscount(equivalentFare, segmentFare);
        }
        return equivalentFare.compareTo(segmentFare) == 0;
    }

    private static boolean checkFareValidWithDiscount(BigDecimal fare, BigDecimal segmentFare) {
        return fare.subtract(segmentFare).compareTo(BigDecimal.valueOf(5L)) < 0 && fare.subtract(segmentFare).signum() > -1;
    }

    private static boolean isFareBasisWithDiscount(Product product) {
        Pattern pattern = Pattern.compile("(\\w+)/(\\w+)");
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                Matcher m;
                if (segment.getFareBasis() == null || !(m = pattern.matcher(segment.getFareBasis())).find()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPartialExchangeTicket(Product product) {
        if (product.getPreviousProduct() == null || product.getPreviousProduct().getPreviousProduct() == null) {
            return false;
        }
        Product exchangeProduct = product.getPreviousProduct();
        Product prevSell = exchangeProduct.getPreviousProduct();
        if (exchangeProduct.getStatus() != ProductStatus.EXCHANGE || prevSell.getStatus() != ProductStatus.SELL) {
            return false;
        }
        int firstSellSegmentTariffsCount = prevSell.getSegmentTariffs().size();
        int exchangeSegmentTariffsCount = exchangeProduct.getSegmentTariffs().size();
        int sellSegmentTariffsCount = product.getSegmentTariffs().size();
        return firstSellSegmentTariffsCount > exchangeSegmentTariffsCount && exchangeSegmentTariffsCount == sellSegmentTariffsCount;
    }

    private static boolean isExchangeWithFakeFirstSell(Product product) {
        if (product.getPreviousProduct() == null || product.getPreviousProduct().getPreviousProduct() == null) {
            return false;
        }
        return product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && product.getPreviousProduct().getPreviousProduct().getStatus() == ProductStatus.SELL && product.getPreviousProduct().getPreviousProduct().getTicketType() == TicketType.FAKE;
    }

    public static BillingItem createProductItem(Product product, Organization client) {
        String name;
        VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, ContractType.CLIENT);
        if (price == null || price.getTotal() == null) {
            return null;
        }
        BillingItem bi = new BillingItem();
        bi.setAmount(price);
        bi.getProductUids().add(product.getUid());
        if (product.getProductCategory() == ProductCategory.AIR) {
            Locale loc = client.getPreferredLocale();
            if (loc == null) {
                loc = Locale.ENGLISH;
            }
            StringBuilder result = new StringBuilder("\u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442 ");
            if (product.isEticket()) {
                result.append("(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439) ");
            }
            result.append(AirProductHelper.getTicketNumber(product));
            result.append(" \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 ").append(AirProductHelper.getRouteLine(product, loc, false, null));
            if (product.getTraveller() != null) {
                result.append(" ").append(product.getTraveller().getName());
            }
            name = result.toString().trim();
        } else {
            name = "\u0414\u0440\u0443\u0433\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430";
        }
        bi.setName(name);
        return bi;
    }

    public static BillingItem createPenaltyItem(Product product, Organization entity) {
        BigDecimal penalty;
        Product mco = null;
        for (Product prod : AirProductHelper.getMcoByRelatedProduct(product)) {
            if (prod.getMcoCategory() != MCOCategory.PENALTY) continue;
            mco = prod;
            break;
        }
        BigDecimal bigDecimal = penalty = mco != null ? AirProductHelper.getEquivalentFare(mco) : product.getPenalty();
        if (penalty == null || penalty.doubleValue() == 0.0) {
            return null;
        }
        BillingItem bi = new BillingItem();
        VatAmount vatAmount = new VatAmount();
        vatAmount.setTotalVat(penalty, MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        bi.setAmount(vatAmount);
        bi.getProductUids().add(mco != null ? mco.getUid() : product.getUid());
        bi.setName(String.format("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 %s", AirProductHelper.getTicketNumber(product)));
        return bi;
    }

    public static BillingItem createDiscountItem(Product product, Organization entity) {
        BigDecimal discount = BigDecimal.ZERO;
        for (Commission comm : AirProductHelper.getUnmodifiableCommissions(product, null)) {
            if (comm.getEquivalentAmount() == null || comm.getContractType() != ContractType.CLIENT) continue;
            discount = discount.add(comm.getEquivalentAmount());
        }
        if (discount.doubleValue() == 0.0) {
            return null;
        }
        BillingItem bi = new BillingItem();
        VatAmount vatAmount = new VatAmount();
        vatAmount.setTotalVat(discount, MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        bi.setAmount(vatAmount);
        bi.getProductUids().add(product.getUid());
        bi.setName(String.format("\u0421\u043a\u0438\u0434\u043a\u0430 \u043d\u0430 \u0431\u0438\u043b\u0435\u0442 %s", AirProductHelper.getTicketNumber(product)));
        return bi;
    }

    public static SearchQuery createValidatorQuery(Product prod, boolean useSell) {
        String validatorCode;
        Date issueDate;
        if (useSell && prod.getStatus() == ProductStatus.REFUND) {
            if (prod.getPreviousProduct() == null || prod.getPreviousProduct().getTicketType() != TicketType.OWN) {
                return null;
            }
            issueDate = prod.getPreviousProduct().getIssueDate();
            validatorCode = prod.getPreviousProduct().getValidatorCode();
        } else {
            issueDate = prod.getIssueDate();
            validatorCode = prod.getValidatorCode();
        }
        if (TextUtil.isBlank((String)validatorCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validatorCode));
        if (issueDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.closed.name(), null), SearchCriterion.ge((String)ValidatorIndex.Property.closed.name(), (Object)issueDate)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.opened.name(), null), SearchCriterion.le((String)ValidatorIndex.Property.opened.name(), (Object)issueDate)}));
        }
        if (prod.getBlankOwnerRef() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), null), SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), (Object)prod.getBlankOwnerRef())}));
        }
        return query;
    }

    public static String getTicketNumber(Product product) {
        StringBuilder result = new StringBuilder();
        result.append(!TextUtil.isBlank((String)product.getSystemNumber()) ? product.getSystemNumber() : "");
        if (product.getConjCount() != 0) {
            result.append("/").append(product.getConjCount());
        }
        return result.toString().trim();
    }

    public static void updateFopsByDate(Product product, Date date) {
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(product)) {
            for (ProductFop fop : item.getFops()) {
                fop.setOperationDate(date);
            }
        }
    }

    public static void updateSubagentFop(Product product, Date operationDate, EntityReference<Person> agent) throws Exception {
        AirProductContractRelationData subagentContractRelation = AirProductHelper.getSubagentContractRelation(product, false);
        if (subagentContractRelation != null) {
            if (subagentContractRelation.getFops().isEmpty()) {
                for (ProductFop fop : AirProductHelper.getVendorContractRelation(product).getFops()) {
                    ProductFop copyFop = (ProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    subagentContractRelation.getFops().add(copyFop);
                }
            }
            for (ProductFop fop : subagentContractRelation.getFops()) {
                if ((operationDate != null || agent != null) && fop.getAgent() != null && fop.getOperationDate() != null) continue;
                fop.setAgent(agent);
                fop.setOperationDate(operationDate);
            }
        }
    }

    public static void updateClientFop(Product product, Date operationDate, EntityReference<Person> agent) throws Exception {
        AirProductContractRelationData clientContractRelation = AirProductHelper.getClientContractRelation(product);
        if (clientContractRelation.getFops().isEmpty()) {
            for (ProductFop fop : AirProductHelper.getVendorContractRelation(product).getFops()) {
                ProductFop copyFop = (ProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                clientContractRelation.getFops().add(copyFop);
            }
        }
        for (ProductFop fop : clientContractRelation.getFops()) {
            if (agent == null) continue;
            fop.setAgent(agent);
            fop.setOperationDate(operationDate);
        }
    }

    @Deprecated
    public static void recalcFops(Product product) {
        AirProductHelper.updateFops(product);
    }

    public static void updateFops(Product product) {
        AirProductHelper.updateProductFops(product);
        AirProductHelper.updateFeeFops(product);
        AirProductHelper.updateDiscountFops(product);
    }

    public static void updateProductFops(Product product) {
        boolean isFareFopsRelevant = AirProductHelper.isFareFopsRelevant(product);
        GeneralProductHelper.RelationData last = new GeneralProductHelper.RelationData(product);
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(product)) {
            boolean exchange;
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            GeneralProductHelper.updateServiceData(product, (BaseContractRelationData)relation, last);
            last = new GeneralProductHelper.RelationData((BaseContractRelationData)relation, last);
            if (!isFareFopsRelevant) {
                relation.getFops().removeIf(f -> GeneralProductHelper.productFopTypes.contains(AirProductHelper.getFopType(f)));
                continue;
            }
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            BigDecimal totalEquivalentFare = relation.getServiceData().getTotalPrice();
            List fops = relation.getFops();
            for (ProductFop fop : AirProductHelper.filterFopsByFopTypes(fops, GeneralProductHelper.productFopTypes)) {
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(currency);
                    fop.setAmount(money);
                    continue;
                }
                if (fop.getAmount().getValue() == null) {
                    fop.getAmount().setValue(BigDecimal.ZERO);
                }
                if (fop.getAmount().getCurrency() != null) continue;
                fop.getAmount().setCurrency(currency);
            }
            Collection<ProductFop> ticketPaymentTypeFops = AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.TICKET), null, null);
            fops.removeAll(ticketPaymentTypeFops);
            HashSet<PaymentType> allPaymentTypesExceptTicket = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
            allPaymentTypesExceptTicket.remove(PaymentType.TICKET);
            boolean bl = exchange = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            if (exchange) {
                AirProductContractRelationData prevRelation = AirProductHelper.findContractRelation(AirProductHelper.getContractRelations(product.getPreviousProduct()), (EntityReference<ContractRelationDescription>)relation.getDescription());
                Collection<ProductFop> filteredPreviousFops = AirProductHelper.filterFops(prevRelation != null ? prevRelation.getFops() : null, GeneralProductHelper.productFopTypes, null, null, null);
                Iterator<ProductFop> filteredTotalEquivalentFop = MiscUtil.minimum((BigDecimal[])new BigDecimal[]{AirProductHelper.calculateTotalEquivalentFop(filteredPreviousFops, currency, FinanceHelper.getCurrencyRateType(currency), product.getPreviousProduct().getIssueDate(), GeneralProductHelper.getSupplier((BaseProduct)product.getPreviousProduct())), totalEquivalentFare});
                if (ticketPaymentTypeFops.isEmpty()) {
                    ProductFop ticketPaymentTypeFop = AirProductHelper.createFop(product, PaymentType.TICKET, filteredTotalEquivalentFop, currency, contractType);
                    fops.add(ticketPaymentTypeFop);
                } else {
                    Money money = new Money();
                    money.setValue(filteredTotalEquivalentFop);
                    money.setCurrency(currency);
                    ProductFop ticketPaymentTypeFop = ticketPaymentTypeFops.iterator().next();
                    ticketPaymentTypeFop.setAmount(money);
                    fops.add(ticketPaymentTypeFop);
                }
            }
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.hiddenCommissionCategories);
            ArrayList<Commission> unusedCommissions = new ArrayList<Commission>(commissions);
            for (ProductFop productFop : AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                ArrayList<Commission> productCommissions = new ArrayList<Commission>();
                for (Commission fopCommission : productFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    Commission productCommission = (Commission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (productCommission == null) continue;
                    productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), MiscUtil.negate((BigDecimal)productCommission.getEquivalentAmount())}));
                    if (productFop.getAmount().getValue() != null && productFop.getAmount().getValue().compareTo(BigDecimal.ZERO) < 0) {
                        productFop.getAmount().setValue(BigDecimal.ZERO);
                    }
                    productCommissions.add(productCommission);
                }
                productFop.getCommissions().clear();
                productFop.getCommissions().addAll(productCommissions);
            }
            AirProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.productFopTypes, currency, contractType, null);
            for (ProductFop productFop : AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(productFop.getCommissions());
                productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), commissionsEquivalentValue}));
                productFop.getAmount().setCurrency(currency);
            }
            BigDecimal difference = totalEquivalentFare;
            Collection<ProductFop> productFops = AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null);
            BigDecimal totalEquivalentFopValue = AirProductHelper.calculateTotalEquivalentFop(productFops, currency, FinanceHelper.getCurrencyRateType(currency), product.getIssueDate(), GeneralProductHelper.getSupplier((BaseProduct)product));
            if ((difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{difference, MiscUtil.negate((BigDecimal)(totalEquivalentFopValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFopValue, MiscUtil.negate((BigDecimal)AirProductHelper.calculateHiddenFeesEquivalentValue(productFops))})))})).compareTo(BigDecimal.ZERO) == 0 && !AirProductHelper.filterFopsByPaymentTypes(productFops, allPaymentTypesExceptTicket).isEmpty()) continue;
            Collection<ProductFop> cashPaymentTypeFops = AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.CASH), Collections.singleton(currency), null);
            if (!cashPaymentTypeFops.isEmpty()) {
                ProductFop cashPaymentTypeFop = cashPaymentTypeFops.iterator().next();
                cashPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{cashPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<ProductFop> invoicePaymentTypeFops = AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.INVOICE), Collections.singleton(currency), null);
            if (!invoicePaymentTypeFops.isEmpty()) {
                ProductFop invoicePaymentTypeFop = invoicePaymentTypeFops.iterator().next();
                invoicePaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{invoicePaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<ProductFop> anyPaymentTypeFops = AirProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, allPaymentTypesExceptTicket, Collections.singleton(currency), null);
            if (!anyPaymentTypeFops.isEmpty()) {
                ProductFop anyPaymentTypeFop = anyPaymentTypeFops.iterator().next();
                anyPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{anyPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            ProductFop cashPaymentTypeFop = AirProductHelper.createFop(product, PaymentType.CASH, difference, currency, contractType);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static void updateFeeFops(Product product) {
        boolean separateSupplierFees = false;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            EntityContainer customerCtr = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            separateSupplierFees = customerCtr != null && ((Organization)customerCtr.getEntity()).isSeparateSupplierFees();
        }
        AirProductContractRelationData prevRelation = null;
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(product)) {
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories);
            ArrayList<Commission> unusedCommissions = new ArrayList<Commission>(commissions);
            for (ProductFop feeFop : AirProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                ArrayList<Commission> feeCommissions = new ArrayList<Commission>();
                for (Commission fopCommission : feeFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    Commission feeCommission = (Commission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (feeCommission == null) continue;
                    feeCommissions.add(feeCommission);
                }
                if (feeCommissions.isEmpty()) {
                    fops.remove(feeFop);
                    continue;
                }
                feeFop.getCommissions().clear();
                feeFop.getCommissions().addAll(feeCommissions);
            }
            if (separateSupplierFees && prevRelation != null && !unusedCommissions.isEmpty()) {
                List prevCommissions = prevRelation.getCommissions();
                List<Commission> addUnusedCommissions = unusedCommissions.stream().filter(c -> AirProductHelper.isSupplierFee(c, prevCommissions)).collect(Collectors.toList());
                unusedCommissions.removeAll(addUnusedCommissions);
                AirProductHelper.distributeCommissionsToFops(product, fops, addUnusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes, currency, contractType, prevRelation.getCommissions());
            }
            AirProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes, currency, contractType, separateSupplierFees && prevRelation != null ? prevRelation.getCommissions() : null);
            prevRelation = relation;
            AirProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.paymentFeePropertyTypes, GeneralProductHelper.paymentFeeFopTypes, currency, contractType, null);
            for (ProductFop feeFop : AirProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(feeFop.getCommissions());
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(currency);
                feeFop.setAmount(money);
            }
        }
    }

    public static boolean isSupplierFee(Commission c, List<Commission> prevCommissions) {
        EntityReference propRef = c.getCommissionProperties();
        EntityContainer commPropCtr = EntityStorage.get().resolve(propRef);
        if (null == commPropCtr || !FeeProperties.class.isAssignableFrom(commPropCtr.getEntityType())) {
            return false;
        }
        FeeProperties commProp = (FeeProperties)commPropCtr.getEntity();
        if (!commProp.isTechFee() && !commProp.isChargeToClientForAllContractTypes()) {
            return false;
        }
        return prevCommissions.stream().anyMatch(p -> propRef.equals((Object)p.getCommissionProperties()));
    }

    private static void updateDiscountFops(Product product) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(product)) {
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), GeneralProductHelper.discountPropertyTypes, null, null);
            ArrayList<Commission> unusedCommissions = new ArrayList<Commission>(commissions);
            for (ProductFop discountFop : AirProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                ArrayList<Commission> discountCommissions = new ArrayList<Commission>();
                for (Commission fopCommission : discountFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    Commission discountCommission = (Commission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (discountCommission == null) continue;
                    discountCommissions.add(discountCommission);
                }
                if (discountCommissions.isEmpty()) {
                    fops.remove(discountFop);
                    continue;
                }
                discountFop.getCommissions().clear();
                discountFop.getCommissions().addAll(discountCommissions);
            }
            AirProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.discountDiscountPropertyTypes, GeneralProductHelper.discountFopTypes, currency, contractType, null);
            for (ProductFop discountFop : AirProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(discountFop.getCommissions());
                commissionsEquivalentValue = MiscUtil.negate((BigDecimal)commissionsEquivalentValue);
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(currency);
                discountFop.setAmount(money);
            }
        }
    }

    private static void distributeCommissionsToFops(Product product, Collection<ProductFop> fops, Collection<Commission> commissions, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, String currency, ContractType contractType, List<Commission> prevCommissions) {
        Collection<Commission> filteredCommissions = GeneralProductHelper.filterCommissions(commissions, commissionProperties, null, null);
        if (filteredCommissions.isEmpty()) {
            return;
        }
        boolean done = AirProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.CASH), fopTypes, currency, prevCommissions);
        if (!done) {
            done = AirProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.INVOICE), fopTypes, currency, prevCommissions);
        }
        if (!done) {
            done = AirProductHelper.distributeCommissionsToFops(fops, filteredCommissions, null, fopTypes, currency, prevCommissions);
        }
        if (!done) {
            ProductFop cashPaymentTypeFop = AirProductHelper.createFop(product, PaymentType.CASH, BigDecimal.ZERO, currency, contractType);
            cashPaymentTypeFop.getCommissions().addAll(filteredCommissions);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static boolean distributeCommissionsToFops(Collection<ProductFop> fops, Collection<Commission> commissions, Set<PaymentType> paymentTypes, Set<FopType> fopTypes, String currency, List<Commission> prevCommissions) {
        Collection<ProductFop> filteredFops = AirProductHelper.filterFops(fops, fopTypes, paymentTypes, Collections.singleton(currency), null);
        if (filteredFops.size() > 0) {
            ProductFop filteredFop;
            if (null == prevCommissions) {
                filteredFop = filteredFops.iterator().next();
            } else {
                boolean supplierFee = !commissions.isEmpty() && AirProductHelper.isSupplierFee(commissions.iterator().next(), prevCommissions);
                filteredFop = filteredFops.stream().filter(f -> (!f.getCommissions().isEmpty() && AirProductHelper.isSupplierFee((Commission)f.getCommissions().get(0), prevCommissions)) == supplierFee).findFirst().orElse(null);
                if (null == filteredFop) {
                    return false;
                }
            }
            filteredFop.getCommissions().addAll(commissions);
            return true;
        }
        return false;
    }

    private static ProductFop createFop(Product product, PaymentType paymentType, BigDecimal amount, String currency, ContractType contractType) {
        ProductFop fop = new ProductFop();
        fop.setType(paymentType);
        Money money = new Money();
        money.setValue(amount != null ? amount : BigDecimal.ZERO);
        money.setCurrency(currency);
        fop.setAmount(money);
        OnCreateFopListener.fire((BaseProduct)product, (Fop)fop, contractType);
        return fop;
    }

    public static ClassOfService calculateClassOfService(Product product) {
        if (product == null) {
            return null;
        }
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (TextUtil.isBlank((String)seg.getFareBasis())) continue;
                return DictHelper.findClassOfService((Segment)st.getSegments().get(0), product.getIssueDate());
            }
        }
        return null;
    }

    public static void removeProduct(Product product, BookingFile bookingFile) {
        for (Reservation res : bookingFile.getReservations()) {
            res.getProducts().remove(product);
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof Product)) continue;
                Product prod = (Product)bp;
                prod.getRelatedProducts().remove(product);
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
        }
    }

    public static TransportationType getTransportationType(Product model) {
        if (model == null) {
            return null;
        }
        Product prod = model;
        if (model.getProductCategory() == ProductCategory.MCO && model.getMcoCategory() != MCOCategory.PTA && model.getMcoCategory() != MCOCategory.POSTAGE_FEE) {
            Product relProd = AirProductHelper.findRelatedAirProduct(model, null, false);
            if (relProd != null) {
                prod = relProd;
            }
        } else if (model.getStatus() == ProductStatus.REFUND || model.getStatus() == ProductStatus.EXCHANGE) {
            Product p = model.getPreviousProduct();
            if (p != null && p.getTicketType() != TicketType.FAKE) {
                prod = p;
            }
        } else if (model.getStatus() == ProductStatus.SELL && model.getPreviousProduct() != null && model.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && (model.getPreviousProduct().getProductCategory() != ProductCategory.MCO || model.getPreviousProduct().getMcoCategory() != MCOCategory.VOUCHER) && model.getPreviousProduct().getPreviousProduct() != null && model.getPreviousProduct().getPreviousProduct().getStatus() == ProductStatus.SELL) {
            prod = model.getPreviousProduct().getPreviousProduct();
        }
        if (prod.getSegmentTariffs().isEmpty()) {
            Money fare = AirProductHelper.getBaseFare(model);
            if (fare == null || fare.getCurrency() == null) {
                return null;
            }
            String equivCurr = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB");
            if (equivCurr == null) {
                return null;
            }
            if (fare.getCurrency().equals(equivCurr)) {
                return TransportationType.DOMESTIC;
            }
            return TransportationType.INTERNATIONAL;
        }
        return AirProductHelper.calculateTransportationType(prod);
    }

    public static ServiceLocationType getServiceLocationType(Product prod) {
        return AirProductHelper.getTransportationType(prod) == TransportationType.DOMESTIC ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
    }

    public static List<Product> getProducts(Reservation reservation) {
        ArrayList<Product> result = new ArrayList<Product>();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            result.add(product);
        }
        return result;
    }

    public static List<SegmentTariff> getSegmentTariffs(Reservation reservation) {
        HashSet set = new HashSet();
        for (Product product : AirProductHelper.getProducts(reservation)) {
            set.addAll(product.getSegmentTariffs());
        }
        return new ArrayList<SegmentTariff>(set);
    }

    public static List<Segment> getSegments(Collection<SegmentTariff> segmentTariffs) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        for (SegmentTariff segmentTariff : segmentTariffs) {
            result.addAll(segmentTariff.getSegments());
        }
        return result;
    }

    @Deprecated
    public static Double calculateCommissionRate(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass) throws Exception {
        return AirProductHelper.calculateCommissionRate(commissions, contractType, commissionPropertiesClass, Collections.singletonList(GeneralProductHelper.CommissionType.STANDARD));
    }

    @Deprecated
    public static Double calculateCommissionRate(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass, GeneralProductHelper.CommissionType commissionType) throws Exception {
        return AirProductHelper.calculateCommissionRate(commissions, contractType, commissionPropertiesClass, Collections.singletonList(commissionType));
    }

    @Deprecated
    public static Double calculateCommissionRate(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass, List<GeneralProductHelper.CommissionType> commissionTypes) throws Exception {
        for (Commission commission : commissions) {
            if (contractType == null || commission.getContractType() != contractType || commission.getRate() == null || commissionPropertiesClass != null && (commission.getCommissionProperties() != null && !commissionPropertiesClass.getName().equals(commission.getCommissionProperties().getType().getName()) || commission.getCommissionProperties() == null && !CommissionProperties.class.getName().equals(commissionPropertiesClass.getName()))) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                boolean valid = false;
                if (commissionTypes.contains((Object)GeneralProductHelper.CommissionType.STANDARD) && (commissionPropertiesContainer == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() && !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus())) {
                    valid = true;
                } else if (commissionTypes.contains((Object)GeneralProductHelper.CommissionType.BSP) && commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission()) {
                    valid = true;
                } else if (commissionTypes.contains((Object)GeneralProductHelper.CommissionType.BONUS) && commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) {
                    valid = true;
                }
                if (!valid) continue;
            }
            return commission.getRate();
        }
        return null;
    }

    @Deprecated
    public static BigDecimal calculateCommissionValue(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass) throws Exception {
        return AirProductHelper.calculateCommissionValue(commissions, contractType, commissionPropertiesClass, Collections.singletonList(GeneralProductHelper.CommissionType.STANDARD));
    }

    @Deprecated
    public static BigDecimal calculateCommissionValue(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass, GeneralProductHelper.CommissionType commissionType) throws Exception {
        return AirProductHelper.calculateCommissionValue(commissions, contractType, commissionPropertiesClass, Collections.singletonList(commissionType));
    }

    @Deprecated
    public static BigDecimal calculateCommissionValue(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass, List<GeneralProductHelper.CommissionType> commissionTypes) throws Exception {
        BigDecimal commissionValue = null;
        for (Commission commission : commissions) {
            if (contractType == null || commission.getContractType() != contractType || commission.getEquivalentAmount() == null || commissionPropertiesClass != null && (commission.getCommissionProperties() != null && !commissionPropertiesClass.getName().equals(commission.getCommissionProperties().getType().getName()) || commission.getCommissionProperties() == null && !CommissionProperties.class.getName().equals(commissionPropertiesClass.getName()))) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                boolean valid = false;
                if (commissionTypes.contains((Object)GeneralProductHelper.CommissionType.STANDARD) && (commissionPropertiesContainer == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() && !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus())) {
                    valid = true;
                } else if (commissionTypes.contains((Object)GeneralProductHelper.CommissionType.BSP) && commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission()) {
                    valid = true;
                } else if (commissionTypes.contains((Object)GeneralProductHelper.CommissionType.BONUS) && commissionPropertiesContainer != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) {
                    valid = true;
                }
                if (!valid) continue;
            }
            commissionValue = commissionValue != null ? commissionValue.add(commission.getEquivalentAmount()) : commission.getEquivalentAmount();
        }
        return commissionValue;
    }

    public static void setClonedSegmentTariffs(Product product, List<SegmentTariff> segmentTariffs) throws Exception {
        for (SegmentTariff segmentTariff : segmentTariffs) {
            product.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)segmentTariff, (boolean)true));
        }
    }

    public static String getShortNameString(Product product) {
        StringBuilder sb = new StringBuilder();
        sb.append(DictHelper.getProductCategoryShortName(product.getProductCategory()));
        MCOCategory mcoCategory = product.getMcoCategory();
        if (mcoCategory != null) {
            sb.append(" ").append(mcoCategory);
        }
        if (product.getTariffType() == TariffType.BLOCKCHARTER || product.getTariffType() == TariffType.CHARTER) {
            sb.append(" (").append(product.getTariffType()).append(")");
        }
        sb.append(" ").append(AirProductHelper.getTicketNumber(product)).append(' ').append(product.getStatus());
        return sb.toString();
    }

    public static String getCouponsList(Product product) {
        StringBuilder sb = new StringBuilder();
        for (SegmentTariff tariff : product.getSegmentTariffs()) {
            for (Segment segment : tariff.getSegments()) {
                sb.append(segment.getRecordNumber());
                sb.append(',');
            }
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean isBSPTicket(Product product) {
        return ProfileHelper.isOrganizationCode((EntityReference<Organization>)product.getBlankOwnerRef(), "BSP") || DictHelper.isBspTicket(product.getSystemNumber());
    }

    public static boolean isTCHTicket(Product product) {
        return ProfileHelper.isOrganizationCode((EntityReference<Organization>)product.getBlankOwnerRef(), "\u04281") || "99A".equals(product.getBlankOwnerNumber()) || "99\u0410".equals(product.getBlankOwnerNumber());
    }

    public static BigDecimal calculateTariffEquivalentFare(Product product) {
        BigDecimal segmentResult = null;
        BigDecimal productResult = null;
        for (ProductFare fare : product.getFares()) {
            BigDecimal equivalentFare = fare.getEquivalentFare();
            if (equivalentFare == null) continue;
            if (fare.getSegmentTariff() == null) {
                productResult = productResult != null ? productResult.add(equivalentFare) : equivalentFare;
                continue;
            }
            segmentResult = segmentResult != null ? segmentResult.add(equivalentFare) : equivalentFare;
        }
        return productResult != null ? productResult : segmentResult;
    }

    public static BigDecimal calculateTariffEquivalentVat(Product model) {
        if (model.getTotalVendorEquivalentVatAmount() == null) {
            return null;
        }
        if (model.getVendorVatDetalization() != null) {
            if (!GeneralProductHelper.isVendorVatDetalizationComplete(model.getVendorVatDetalization())) {
                return null;
            }
            BigDecimal result = BigDecimal.ZERO;
            for (VatComponent comp : model.getVendorVatDetalization().getComponents()) {
                if (!comp.getBasisTypes().contains(VatBasisType.FARE)) continue;
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, comp.getSum()});
            }
            return result;
        }
        HashMap<String, Boolean> taxesVAT = new HashMap<String, Boolean>();
        for (Tax tax : model.getTaxes()) {
            String taxCode = TextUtil.isBlank((String)tax.getCode()) ? "" : tax.getCode();
            if (Boolean.TRUE.equals(taxesVAT.get(taxCode))) continue;
            taxesVAT.put(taxCode, tax.getValue("equivalentVatAmount") == null ? Boolean.FALSE : Boolean.TRUE);
        }
        for (Boolean value : taxesVAT.values()) {
            if (!Boolean.FALSE.equals(value)) continue;
            return null;
        }
        BigDecimal tariffEquivalentFareVat = null;
        BigDecimal taxesEquivalentVat = AirProductHelper.calculateTaxesVatAmount(model);
        BigDecimal penaltyEquivalentVat = AirProductHelper.getPenaltyVatAmount(model);
        BigDecimal totalEquivalentVat = model.getTotalVendorEquivalentVatAmount();
        if (taxesEquivalentVat != null && totalEquivalentVat != null) {
            if (model.getStatus() == ProductStatus.REFUND || model.getStatus() == ProductStatus.EXCHANGE) {
                if (penaltyEquivalentVat != null) {
                    tariffEquivalentFareVat = totalEquivalentVat.subtract(taxesEquivalentVat).add(penaltyEquivalentVat);
                }
            } else if (model.getStatus() == ProductStatus.SELL && model.getPreviousProduct() != null && model.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                if (penaltyEquivalentVat != null) {
                    tariffEquivalentFareVat = totalEquivalentVat.subtract(taxesEquivalentVat).subtract(penaltyEquivalentVat);
                }
            } else {
                tariffEquivalentFareVat = totalEquivalentVat.subtract(taxesEquivalentVat);
            }
        }
        return tariffEquivalentFareVat;
    }

    public static BigDecimal calculateTaxesEquivalentAmount(Product product) {
        BigDecimal taxesAmount = null;
        for (Tax tax : product.getTaxes()) {
            if (tax.getEquivalentAmount() == null) continue;
            taxesAmount = taxesAmount != null ? taxesAmount.add(tax.getEquivalentAmount()) : tax.getEquivalentAmount();
        }
        return taxesAmount;
    }

    public static BigDecimal calculateOBFeesEquivalentAmount(List<OBFee> obFees) {
        BigDecimal obFeesEquivalentAmount = null;
        String equivalentCurrencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
        for (OBFee obFee : obFees) {
            if (obFee == null || obFee.getAmount() == null || obFee.getAmount().getCurrency() == null || !TextUtil.isSame((String)obFee.getAmount().getCurrency(), (String)equivalentCurrencyCode)) continue;
            obFeesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{obFeesEquivalentAmount, obFee.getAmount().getValue()});
        }
        return obFeesEquivalentAmount;
    }

    public static BigDecimal calculateOBFeesEquivalentAmount(Product product) {
        return AirProductHelper.calculateOBFeesEquivalentAmount(product.getObFees());
    }

    public static BigDecimal calculateTaxesEquivalentAddCollect(Product product) {
        BigDecimal addCollect = null;
        for (Tax tax : product.getTaxes()) {
            if (tax.getEquivalentAmount() == null || tax.getAddCollect() == null) continue;
            addCollect = addCollect != null ? addCollect.add(tax.getAddCollect()) : tax.getAddCollect();
        }
        return addCollect;
    }

    public static BigDecimal calculateTotalAdditionalAmount(Product product) {
        BigDecimal taxEqAddCollect = AirProductHelper.calculateTaxesEquivalentAddCollect(product);
        BigDecimal addCollectEquivalent = product.getAddCollectEquivalent();
        BigDecimal addPenalty = BigDecimal.ZERO;
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && product.getPenalty() != null) {
            addPenalty = product.getPenalty();
        }
        if (taxEqAddCollect == null && addCollectEquivalent == null) {
            return null;
        }
        return (taxEqAddCollect != null ? taxEqAddCollect : BigDecimal.ZERO).add(addCollectEquivalent != null ? addCollectEquivalent : BigDecimal.ZERO).add(addPenalty);
    }

    public static BigDecimal calculateTotalEquivalentFare(Product product) {
        BigDecimal totalEquivalentFare = null;
        totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, AirProductHelper.calculateTariffEquivalentFare(product)});
        totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, AirProductHelper.calculateTaxesEquivalentAmount(product)});
        totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, AirProductHelper.calculateOBFeesEquivalentAmount(product)});
        totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)product.getPenalty()) : product.getPenalty()});
        return totalEquivalentFare;
    }

    public static BigDecimal calculateTotalEquivalentFareForUIData(Product product) {
        BigDecimal totalEquivalentFare = AirProductHelper.calculateTariffEquivalentFare(product);
        totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, AirProductHelper.calculateTaxesEquivalentAmount(product)});
        totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, AirProductHelper.calculateOBFeesEquivalentAmount(product)});
        if (product.getPreviousProduct() == null || product.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) {
            totalEquivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFare, product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)product.getPenalty()) : product.getPenalty()});
        }
        return totalEquivalentFare;
    }

    public static boolean isBSPCommission(Commission commission) {
        if (commission == null) {
            return false;
        }
        EntityReference baseCommissionProperties = commission.getCommissionProperties();
        if (baseCommissionProperties != null && !CommissionProperties.class.equals((Object)baseCommissionProperties.getType())) {
            return false;
        }
        EntityContainer commissionPropertiesContainer = null;
        try {
            commissionPropertiesContainer = EntityStorage.get().resolve(baseCommissionProperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (commissionPropertiesContainer == null) {
            return false;
        }
        return ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission();
    }

    public static Collection<ProductFop> filterFops(Collection<ProductFop> fops, Set<FopType> fopTypes, Set<PaymentType> paymentTypes, Set<String> currencies, Set<Class<? extends BaseCommissionProperties>> properties) {
        return AirProductHelper.filterFopsByFopTypes(AirProductHelper.filterFopsByPaymentTypes(AirProductHelper.filterFopsByCurrencies(AirProductHelper.filterFopsByCommissionProperties(fops, properties), currencies), paymentTypes), fopTypes);
    }

    private static Collection<ProductFop> filterFopsByFopTypes(Collection<ProductFop> fops, Set<FopType> fopTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (fopTypes == null) {
            return new ArrayList<ProductFop>(fops);
        }
        ArrayList<ProductFop> filteredFops = new ArrayList<ProductFop>();
        for (ProductFop fop : fops) {
            FopType fopType = AirProductHelper.getFopType(fop);
            if (!fopTypes.contains(fopType)) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<ProductFop> filterFopsByPaymentTypes(Collection<ProductFop> fops, Set<PaymentType> paymentTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (paymentTypes == null) {
            return new ArrayList<ProductFop>(fops);
        }
        ArrayList<ProductFop> filteredFops = new ArrayList<ProductFop>();
        for (ProductFop fop : fops) {
            if (fop.getType() == null || !paymentTypes.contains(fop.getType())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<ProductFop> filterFopsByCurrencies(Collection<ProductFop> fops, Set<String> currencies) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (currencies == null) {
            return new ArrayList<ProductFop>(fops);
        }
        ArrayList<ProductFop> filteredFops = new ArrayList<ProductFop>();
        for (ProductFop fop : fops) {
            if (fop.getAmount() == null || fop.getAmount().getCurrency() == null || !currencies.contains(fop.getAmount().getCurrency())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<ProductFop> filterFopsByCommissionProperties(Collection<ProductFop> fops, Set<Class<? extends BaseCommissionProperties>> properties) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (properties == null) {
            return new ArrayList<ProductFop>(fops);
        }
        ArrayList<ProductFop> filteredFops = new ArrayList<ProductFop>();
        block0: for (ProductFop fop : fops) {
            for (Commission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !properties.contains(commission.getCommissionProperties().getType())) continue;
                filteredFops.add(fop);
                continue block0;
            }
        }
        return filteredFops;
    }

    public static Collection<Tax> filterTaxes(Collection<Tax> taxes, Set<String> codes) {
        return AirProductHelper.filterTaxesByCodes(taxes, codes);
    }

    private static Collection<Tax> filterTaxesByCodes(Collection<Tax> taxes, Set<String> codes) {
        if (taxes == null) {
            return Collections.emptyList();
        }
        if (codes == null) {
            return new ArrayList<Tax>(taxes);
        }
        ArrayList<Tax> filteredTaxes = new ArrayList<Tax>();
        for (Tax tax : taxes) {
            if (!codes.contains(tax.getCode())) continue;
            filteredTaxes.add(tax);
        }
        return filteredTaxes;
    }

    public static BigDecimal calculateTotalEquivalentFop(Collection<ProductFop> fops, String equivalentCurrencyCode, CurrencyRateType currencyRateType, Date date, EntityReference<Organization> supplier) {
        BigDecimal totalEquivalentFop = null;
        Collection<Money> totalFops = AirProductHelper.calculateTotalFops(fops);
        for (Money money : totalFops) {
            BigDecimal amount = money.getValue();
            String currency = money.getCurrency();
            if (!TextUtil.isSame((String)currency, (String)equivalentCurrencyCode)) {
                CurrencyRate currencyRate = DictHelper.findCurrencyRate(currency, date, currencyRateType, null, supplier);
                if (currencyRate == null) continue;
                amount = amount.multiply(BigDecimal.valueOf(currencyRate.getRate()));
            }
            totalEquivalentFop = totalEquivalentFop != null ? totalEquivalentFop.add(amount) : amount;
        }
        return totalEquivalentFop;
    }

    public static Collection<Money> calculateTotalFops(Collection<ProductFop> fops) {
        HashMap<String, Money> totalFops = new HashMap<String, Money>();
        for (ProductFop fop : fops) {
            if (fop.getAmount() == null) continue;
            BigDecimal amount = fop.getAmount().getValue();
            String currency = fop.getAmount().getCurrency();
            if (amount == null || currency == null) continue;
            Money money = (Money)totalFops.get(currency);
            if (money == null) {
                money = new Money();
                totalFops.put(currency, money);
                money.setValue(amount);
                money.setCurrency(currency);
                continue;
            }
            money.setValue(money.getValue().add(amount));
        }
        return totalFops.values();
    }

    public static BigDecimal calculateHiddenFeesEquivalentValue(Collection<ProductFop> fops) {
        BigDecimal result = BigDecimal.ZERO;
        for (ProductFop fop : fops) {
            for (Commission comm : fop.getCommissions()) {
                FeeProperties feeProp;
                EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null || !(ctr.getEntity() instanceof FeeProperties) || !(feeProp = (FeeProperties)ctr.getEntity()).isHidden()) continue;
                result = result.add(comm.getEquivalentAmount());
            }
        }
        return result;
    }

    private static Collection<Commission> getCommissions(Product product) {
        HashSet<GeneralProductHelper.CommissionType> commissionTypes = !MiscUtil.equals((Object)product.getBlankOwnerRef(), AirProductHelper.getSupplier(product)) ? Collections.singleton(GeneralProductHelper.CommissionType.STANDARD) : new HashSet<GeneralProductHelper.CommissionType>(Arrays.asList(GeneralProductHelper.CommissionType.STANDARD, GeneralProductHelper.CommissionType.BSP));
        return GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.VENDOR), GeneralProductHelper.commissionPropertyTypes, (Set<GeneralProductHelper.CommissionType>)commissionTypes, null);
    }

    public static BigDecimal calculateSupplierCommissionsRate(Product product, boolean max) throws Exception {
        Collection<Commission> commissions = AirProductHelper.getCommissions(product);
        return AirProductHelper.calculateCommissionsRate(commissions, max);
    }

    public static BigDecimal calculateSupplierCommissionsEquivalentValue(Product product) throws Exception {
        Collection<Commission> commissions = AirProductHelper.getCommissions(product);
        return AirProductHelper.calculateCommissionsEquivalentValue(commissions);
    }

    public static Double calculateCommissionsRateAsDouble(Collection<Commission> commissions, boolean max) {
        BigDecimal value = AirProductHelper.calculateCommissionsRate(commissions, max);
        return value == null ? null : Double.valueOf(value.doubleValue());
    }

    public static BigDecimal calculateCommissionsRate(Collection<Commission> commissions, boolean max) {
        BigDecimal rate = null;
        for (Commission commission : commissions) {
            if (commission.getRate() == null) continue;
            BigDecimal value = BigDecimal.valueOf(commission.getRate());
            rate = rate != null ? (max ? rate.max(value) : rate.add(value)) : value;
        }
        return rate;
    }

    public static BigDecimal calculateCommissionsBaseValue(Collection<Commission> commissions) {
        BigDecimal value = null;
        for (Commission commission : commissions) {
            if (commission.getAmount() == null || commission.getAmount().getValue() == null) continue;
            value = value != null ? value.add(commission.getAmount().getValue()) : commission.getAmount().getValue();
        }
        return value;
    }

    public static BigDecimal calculateCommissionsEquivalentValue(Collection<Commission> commissions) {
        BigDecimal value = null;
        for (Commission commission : commissions) {
            if (commission.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(commission.getEquivalentAmount()) : commission.getEquivalentAmount();
        }
        return value;
    }

    public static BigDecimal getIATARate(Product product) {
        String endorsement = product.getEndorsement();
        if (!TextUtil.isBlank((String)endorsement)) {
            Money baseFare;
            Matcher matcher = Pattern.compile("BSR[0-9]+\\.?[0-9]*").matcher(endorsement);
            if (matcher.find()) {
                return new BigDecimal(matcher.group().substring(3));
            }
            String equivalentCurrencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
            if (!TextUtil.isBlank((String)equivalentCurrencyCode) && (baseFare = AirProductHelper.getBaseFare(product)) != null && baseFare.getValue() != null && baseFare.getCurrency() != null) {
                String currencyCode = baseFare.getCurrency();
                matcher = Pattern.compile("1" + currencyCode + "=[0-9]+\\.?[0-9]*" + equivalentCurrencyCode).matcher(endorsement);
                if (matcher.find()) {
                    String rateString = matcher.group();
                    return new BigDecimal(rateString.substring(currencyCode.length() + 2, rateString.length() - 3));
                }
            }
        }
        return null;
    }

    public static void updateSegmentTariffsEquivalentFare(Product product) throws Exception {
        Money baseFare;
        DictionaryReference validatingCarrierReference;
        EntityReference blankOwnerReference = product.getBlankOwnerRef();
        if (blankOwnerReference == null) {
            return;
        }
        EntityContainer blankOwnerContainer = EntityStorage.get().resolve(blankOwnerReference);
        if (blankOwnerContainer == null) {
            return;
        }
        Organization blankOwner = (Organization)blankOwnerContainer.getEntity();
        if (blankOwner == null || TextUtil.isBlank((String)blankOwner.getCode()) || !blankOwner.getCode().equalsIgnoreCase("S7") && !blankOwner.getCode().equalsIgnoreCase("BSP")) {
            return;
        }
        if (blankOwner.getCode().equalsIgnoreCase("BSP") && ((validatingCarrierReference = product.getCarrier()) == null || !validatingCarrierReference.getCode().equalsIgnoreCase("VV"))) {
            return;
        }
        if (product.getFares().isEmpty() || product.getSegmentTariffs().isEmpty()) {
            return;
        }
        String equivalentCurrencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
        BigDecimal rate = null;
        if (!TextUtil.isBlank((String)equivalentCurrencyCode) && (baseFare = AirProductHelper.getBaseFare(product)) != null && baseFare.getValue() != null && baseFare.getCurrency() != null) {
            String currencyCode = baseFare.getCurrency();
            if (currencyCode.equals(equivalentCurrencyCode)) {
                rate = BigDecimal.ONE;
            } else {
                CurrencyRate currencyRate = BookingHelper.findCurrencyRate(equivalentCurrencyCode, currencyCode, product.getIssueDate(), CurrencyRateType.IATA, product.getTariffType(), (EntityReference<Organization>)product.getBlankOwnerRef(), GeneralProductHelper.getSupplier((BaseProduct)product));
                if (currencyRate != null) {
                    rate = BigDecimal.valueOf(currencyRate.getRate());
                }
            }
        }
        if (rate == null) {
            rate = AirProductHelper.getIATARate(product);
        }
        ArrayList segmentTariffs = new ArrayList(product.getSegmentTariffs());
        BigDecimal distributedEquivalentFare = BigDecimal.ZERO;
        for (ProductFare fare : product.getFares()) {
            if (fare.getSegmentTariff() == null || fare.getEquivalentFare() == null) continue;
            distributedEquivalentFare = distributedEquivalentFare.add(fare.getEquivalentFare());
            segmentTariffs.remove(fare.getSegmentTariff());
        }
        for (int i = 0; i < segmentTariffs.size(); ++i) {
            SegmentTariff segmentTariff = (SegmentTariff)segmentTariffs.get(i);
            if (i < segmentTariffs.size() - 1) {
                if (rate == null) {
                    if (!product.isChecked()) {
                        product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage(StandartValidationMessageType.APH_CANT_CALK_EQU_SUM_IATA_NOT_DEFINED));
                    }
                    return;
                }
                BigDecimal equivalentFare = AirProductHelper.calculateSegmentTariffsEquivalentFare(product, segmentTariff, rate);
                if (equivalentFare != null) {
                    distributedEquivalentFare = distributedEquivalentFare.add(equivalentFare);
                }
                AirProductHelper.setSegmentEquivalentFare(product, segmentTariff, equivalentFare);
                continue;
            }
            BigDecimal totalEquivalentFare = AirProductHelper.getEquivalentFare(product);
            if (totalEquivalentFare == null) continue;
            BigDecimal equivalentFare = totalEquivalentFare.subtract(distributedEquivalentFare);
            AirProductHelper.setSegmentEquivalentFare(product, segmentTariff, equivalentFare.compareTo(BigDecimal.ZERO) != 0 ? equivalentFare : null);
        }
    }

    private static BigDecimal calculateSegmentTariffsEquivalentFare(Product product, SegmentTariff segmentTariff, BigDecimal rate) {
        String equivalentCurrencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
        if (TextUtil.isBlank((String)equivalentCurrencyCode)) {
            return null;
        }
        SegmentTariffEquivalentFareCalculator equivalentFareCalculator = null;
        if (TextUtil.isSame((String)"RUB", (String)equivalentCurrencyCode)) {
            equivalentFareCalculator = RussiaSegmentTariffEquivalentFareCalculator.getInstance();
        } else if (TextUtil.isSame((String)"UAH", (String)equivalentCurrencyCode)) {
            equivalentFareCalculator = UkraineSegmentTariffEquivalentFareCalculator.getInstance();
        }
        if (equivalentFareCalculator == null) {
            return null;
        }
        return ((SegmentTariffEquivalentFareCalculator)equivalentFareCalculator).calculateEquivalentFare(product, segmentTariff, rate);
    }

    public static Date getCurrencyRateDate(Product product) {
        Product currencyRateDateProduct;
        Product oldSellProduct = null;
        if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            oldSellProduct = product.getPreviousProduct().getPreviousProduct();
            HashSet<Product> processedProducts = new HashSet<Product>();
            while (oldSellProduct != null && !processedProducts.contains(oldSellProduct) && oldSellProduct.getPreviousProduct() != null && oldSellProduct.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                processedProducts.add(oldSellProduct);
                oldSellProduct = oldSellProduct.getPreviousProduct().getPreviousProduct();
            }
        }
        if (!(oldSellProduct == null || oldSellProduct.getSegmentTariffs().isEmpty() || ((SegmentTariff)oldSellProduct.getSegmentTariffs().get(0)).getSegments().isEmpty() || product.getSegmentTariffs().isEmpty() || ((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().isEmpty())) {
            Segment oldFirstSegment = (Segment)((SegmentTariff)oldSellProduct.getSegmentTariffs().get(0)).getSegments().get(0);
            Segment currentFirstSegment = (Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0);
            currencyRateDateProduct = oldFirstSegment.getStartDate() != null && product.getIssueDate() != null && oldFirstSegment.getStartDate().before(product.getIssueDate()) || MiscUtil.equals((Object)currentFirstSegment.getAirline(), (Object)oldFirstSegment.getAirline()) && MiscUtil.equals((Object)currentFirstSegment.getArriveLocation(), (Object)oldFirstSegment.getArriveLocation()) && MiscUtil.equals((Object)currentFirstSegment.getClassOfService(), (Object)oldFirstSegment.getClassOfService()) && MiscUtil.equals((Object)currentFirstSegment.getClassOfSvcCode(), (Object)oldFirstSegment.getClassOfSvcCode()) && MiscUtil.equals((Object)currentFirstSegment.getCodeShareCarrier(), (Object)oldFirstSegment.getCodeShareCarrier()) && MiscUtil.equals((Object)currentFirstSegment.getDepartureLocation(), (Object)oldFirstSegment.getDepartureLocation()) && MiscUtil.equals((Object)currentFirstSegment.getEndDate(), (Object)oldFirstSegment.getEndDate()) && MiscUtil.equals((Object)currentFirstSegment.getFareBasis(), (Object)oldFirstSegment.getFareBasis()) && MiscUtil.equals((Object)currentFirstSegment.getFlightNo(), (Object)oldFirstSegment.getFlightNo()) && MiscUtil.equals((Object)currentFirstSegment.getStartDate(), (Object)oldFirstSegment.getStartDate()) ? oldSellProduct : product;
        } else {
            currencyRateDateProduct = (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) && product.getPreviousProduct() != null && product.getPreviousProduct().getTicketType() != TicketType.FAKE ? product.getPreviousProduct() : product;
        }
        return currencyRateDateProduct.getIssueDate();
    }

    public static Double getSupplierCommissionRate(Product prod) throws Exception {
        EntityContainer supplierCtr = EntityStorage.get().resolve(AirProductHelper.getSupplier(prod));
        List<Commission> commissions = AirProductHelper.getUnmodifiableCommissions(prod, ContractType.VENDOR);
        if (supplierCtr != null && "BSP".equals(((Organization)supplierCtr.getEntity()).getCode())) {
            Double bspCommRate = prod.getBspCommissionRate();
            if (bspCommRate != null) {
                return bspCommRate;
            }
            BigDecimal rate = AirProductHelper.calculateCommissionsRate(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.STANDARD), null), true);
            if (rate != null) {
                return rate.doubleValue();
            }
            rate = AirProductHelper.calculateCommissionsRate(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.BSP), null), true);
            return rate == null ? null : Double.valueOf(rate.doubleValue());
        }
        BigDecimal rate = AirProductHelper.calculateCommissionsRate(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.STANDARD), null), true);
        return rate == null ? null : Double.valueOf(rate.doubleValue());
    }

    public static BigDecimal getSupplierCommissionValue(Product prod) throws Exception {
        EntityContainer supplierCtr = EntityStorage.get().resolve(AirProductHelper.getSupplier(prod));
        List<Commission> commissions = AirProductHelper.getUnmodifiableCommissions(prod, ContractType.VENDOR);
        if (supplierCtr != null && "BSP".equals(((Organization)supplierCtr.getEntity()).getCode())) {
            Money bspCommValue = prod.getBspCommissionValue();
            if (bspCommValue != null) {
                return bspCommValue.getValue();
            }
            BigDecimal value = AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.STANDARD), null));
            if (value != null) {
                return value;
            }
            return AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.BSP), null));
        }
        return AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.STANDARD), null));
    }

    public static BigDecimal getSupplierCommissionBaseValue(Product prod) throws Exception {
        EntityContainer supplierCtr = EntityStorage.get().resolve(AirProductHelper.getSupplier(prod));
        List<Commission> commissions = AirProductHelper.getUnmodifiableCommissions(prod, ContractType.VENDOR);
        if (supplierCtr != null && "BSP".equals(((Organization)supplierCtr.getEntity()).getCode())) {
            Money bspCommValue = prod.getBspCommissionValue();
            if (bspCommValue != null) {
                return bspCommValue.getValue();
            }
            BigDecimal value = AirProductHelper.calculateCommissionsBaseValue(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.STANDARD), null));
            if (value != null) {
                return value;
            }
            return AirProductHelper.calculateCommissionsBaseValue(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.BSP), null));
        }
        return AirProductHelper.calculateCommissionsBaseValue(GeneralProductHelper.filterCommissions(commissions, null, Collections.singleton(GeneralProductHelper.CommissionType.STANDARD), null));
    }

    public static BigDecimal calculateAgentPenaltyForCommissions(Product product) throws Exception {
        BigDecimal agentPenaltyForCommissions = null;
        if (product.getProductCategory() == ProductCategory.AIR && AirProductHelper.isBSPTicket(product)) {
            BigDecimal gdsCommissionAmount;
            String currency;
            Money bspCommission;
            BigDecimal contractCommissionsAmount = AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.VENDOR), null, GeneralProductHelper.bspCommissionTypes, null));
            if (contractCommissionsAmount != null) {
                agentPenaltyForCommissions = contractCommissionsAmount;
            }
            if ((bspCommission = product.getBspCommissionValue()) != null && bspCommission.getValue() != null && bspCommission.getCurrency() != null && (currency = DictHelper.getLocalCurrency2()) != null && (gdsCommissionAmount = FinanceHelper.exchange(bspCommission.getValue(), bspCommission.getCurrency(), currency, FinanceHelper.getCurrencyRateType(currency), null, AirProductHelper.getCurrencyRateDate(product), GeneralProductHelper.getSupplier((BaseProduct)product), false)) != null) {
                agentPenaltyForCommissions = agentPenaltyForCommissions != null ? agentPenaltyForCommissions.subtract(gdsCommissionAmount) : gdsCommissionAmount.negate();
            }
        }
        return agentPenaltyForCommissions;
    }

    public static boolean isSpecialSchemeTourCode(String tourCode) {
        if (TextUtil.isBlank((String)tourCode)) {
            return false;
        }
        return tchSpecialSchemePattern.matcher(tourCode).matches();
    }

    public static boolean isSpecialSchemeTCHTicket(Product product) {
        if (!AirProductHelper.isTCHTicket(product)) {
            return false;
        }
        if (product.getProductCategory() == ProductCategory.MCO) {
            Product rp = AirProductHelper.findRelatedAirProduct(product, null, false);
            if (rp == null) {
                return AirProductHelper.isSpecialSchemeTourCode(product.getTourCode());
            }
            if (rp.getStatus() == ProductStatus.REFUND && rp.getPreviousProduct() != null) {
                return AirProductHelper.isSpecialSchemeTourCode(rp.getPreviousProduct().getTourCode());
            }
            return AirProductHelper.isSpecialSchemeTourCode(rp.getTourCode());
        }
        return AirProductHelper.isSpecialSchemeTourCode(product.getTourCode());
    }

    public static boolean isFewCarriersAggreementCarrierNumber(String carrierNumber) {
        if (TextUtil.isBlank((String)carrierNumber)) {
            return false;
        }
        return "99A".equals(carrierNumber) || "99\u0410".equals(carrierNumber);
    }

    public static boolean isFewCarrierAggreementTCHTicket(Product product) {
        return AirProductHelper.isTCHTicket(product) && AirProductHelper.isFewCarriersAggreementCarrierNumber(product.getCarrierNumber());
    }

    public static Segment getFirstSegment(Product product) {
        Segment firstSegment = null;
        Date departureDate = null;
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment.getStartDate() == null || departureDate != null && !segment.getStartDate().before(departureDate)) continue;
                firstSegment = segment;
                departureDate = segment.getStartDate();
            }
        }
        return firstSegment;
    }

    public static Segment getLastSegment(Product product) {
        Segment lastSegment = null;
        Date departureDate = null;
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment.getStartDate() == null || departureDate != null && !segment.getStartDate().after(departureDate)) continue;
                lastSegment = segment;
                departureDate = segment.getStartDate();
            }
        }
        return lastSegment;
    }

    public static Segment getFirstFutureOrLastSegment(Product product, Date now) {
        Segment firstFutureSegment = null;
        Date departureDate = null;
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment.getStartDate() == null || departureDate != null && !segment.getStartDate().before(departureDate) || !segment.getStartDate().after(now)) continue;
                firstFutureSegment = segment;
                departureDate = segment.getStartDate();
            }
        }
        return firstFutureSegment != null ? firstFutureSegment : AirProductHelper.getLastSegment(product);
    }

    public static Date getFirstDepartureDate(Product product) {
        Segment firstSegment = AirProductHelper.getFirstSegment(product);
        return firstSegment != null ? firstSegment.getStartDate() : null;
    }

    public static Date getFirstArriveDate(Product product) {
        Segment firstSegment = AirProductHelper.getFirstSegment(product);
        return firstSegment != null ? firstSegment.getStartDate() : null;
    }

    public static Date getLastDepartureDate(Product product) {
        Segment lastSegment = AirProductHelper.getLastSegment(product);
        return lastSegment != null ? lastSegment.getStartDate() : null;
    }

    public static Date getLastArriveDate(Product product) {
        Segment lastSegment = AirProductHelper.getLastSegment(product);
        return lastSegment != null ? lastSegment.getEndDate() : null;
    }

    public static String generateTaxLine(Product prod, String delimeter, NumberFormat nf) {
        String equivCurr = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "");
        StringBuilder sb = new StringBuilder();
        for (Tax tax : prod.getTaxes()) {
            if (sb.length() > 0) {
                sb.append(delimeter);
            }
            if (!TextUtil.isBlank((String)tax.getCode())) {
                sb.append(tax.getCode()).append(' ');
            }
            sb.append(equivCurr).append(nf.format(tax.getEquivalentAmount()));
        }
        return sb.toString();
    }

    public static GeneralProductFop toGeneralProductFop(ProductFop fop) {
        GeneralProductFop generalProductFop = new GeneralProductFop();
        generalProductFop.setUid(fop.getUid());
        generalProductFop.setType(fop.getType());
        generalProductFop.setCard(fop.getCard());
        generalProductFop.setPassengerStatus(fop.getPassengerStatus());
        generalProductFop.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        generalProductFop.setEquivalentAmount(fop.getAmount() != null ? fop.getAmount().getValue() : null);
        generalProductFop.setOperationDate(fop.getOperationDate());
        generalProductFop.setAgent(fop.getAgent());
        generalProductFop.setRefused(fop.isRefused());
        generalProductFop.setPayer(fop.getPayer());
        generalProductFop.getCommissions().clear();
        for (Commission commission : fop.getCommissions()) {
            generalProductFop.getCommissions().add(AirProductHelper.toGeneralProductCommission(commission));
        }
        return generalProductFop;
    }

    public static List<GeneralProductCommission> toGeneralProductCommission(List<Commission> commissions) {
        ArrayList<GeneralProductCommission> result = new ArrayList<GeneralProductCommission>(commissions.size());
        for (Commission commission : commissions) {
            result.add(AirProductHelper.toGeneralProductCommission(commission));
        }
        return result;
    }

    public static GeneralProductCommission toGeneralProductCommission(Commission commission) {
        GeneralProductCommission generalProductCommission = new GeneralProductCommission();
        generalProductCommission.setUid(commission.getUid());
        generalProductCommission.setContractType(commission.getContractType());
        generalProductCommission.setRate(commission.getRate());
        generalProductCommission.setVatRate(commission.getVatRate());
        generalProductCommission.setAmount(commission.getAmount());
        generalProductCommission.setEquivalentAmount(commission.getEquivalentAmount());
        generalProductCommission.setContractEquivalentAmount(commission.getContractEquivalentAmount());
        generalProductCommission.setCommissionProperties(commission.getCommissionProperties());
        generalProductCommission.setTransferred(commission.isTransferred());
        return generalProductCommission;
    }

    public static Commission fromGeneralProductCommission(GeneralProductCommission generalProductCommission) {
        Commission commission = new Commission();
        commission.setContractType(generalProductCommission.getContractType());
        if (generalProductCommission.getAmount() != null) {
            Money money = new Money();
            money.setCurrency(generalProductCommission.getAmount().getCurrency());
            money.setValue(generalProductCommission.getAmount().getValue());
            commission.setAmount(money);
        }
        commission.setRate(generalProductCommission.getRate());
        commission.setEquivalentAmount(generalProductCommission.getEquivalentAmount());
        commission.setContractEquivalentAmount(generalProductCommission.getContractEquivalentAmount());
        commission.setCommissionProperties(generalProductCommission.getCommissionProperties());
        commission.setContractType(generalProductCommission.getContractType());
        commission.setUid(generalProductCommission.getUid());
        EntityContainer commissionPropertiesCtr = EntityStorage.get().resolve(generalProductCommission.getCommissionProperties());
        if (commissionPropertiesCtr != null) {
            BaseCommissionProperties commissionProperties = (BaseCommissionProperties)commissionPropertiesCtr.getEntity();
            commission.setRoundingMode(commissionProperties.getRoundingMode());
            commission.setRoundingValue(commissionProperties.getRoundingValue());
        }
        return commission;
    }

    public static GeneralProductTax toGeneralProductTax(Tax tax) {
        GeneralProductTax generalProductTax = new GeneralProductTax();
        generalProductTax.setUid(tax.getUid());
        generalProductTax.setCode(tax.getCode());
        generalProductTax.setAmount(tax.getAmount());
        generalProductTax.setEquivalentAmount(tax.getEquivalentAmount());
        return generalProductTax;
    }

    public static void updateCommission(List<Commission> commissions, GeneralProductCommission generalProductCommission) {
        Commission commission = BookingHelper.findEntityByUid(commissions, generalProductCommission.getUid());
        if (commission == null) {
            commission = new Commission();
            commissions.add(commission);
        }
        commission.setUid(generalProductCommission.getUid());
        commission.setContractType(generalProductCommission.getContractType());
        commission.setRate(generalProductCommission.getRate());
        commission.setAmount(generalProductCommission.getAmount());
        commission.setEquivalentAmount(generalProductCommission.getEquivalentAmount());
        commission.setCommissionProperties(generalProductCommission.getCommissionProperties());
    }

    public static void updateTax(List<Tax> taxes, GeneralProductTax generalProductTax) {
        Tax tax = BookingHelper.findEntityByUid(taxes, generalProductTax.getUid());
        if (tax == null) {
            tax = new Tax();
            taxes.add(tax);
        }
        tax.setUid(generalProductTax.getUid());
        tax.setCode(generalProductTax.getCode());
        tax.setAmount(generalProductTax.getAmount());
        tax.setEquivalentAmount(generalProductTax.getEquivalentAmount());
    }

    public static String getRficCodeByMcoCategory(MCOCategory mcoCat) {
        if (mcoCat == null) {
            return null;
        }
        return McoCategoriesCodesUtil.Mco2rficCodes.get(mcoCat);
    }

    public static List<MCOCategory> getMcoCategoriesByRficCode(String rficCode) {
        ArrayList<MCOCategory> res = new ArrayList<MCOCategory>();
        if (TextUtil.isBlank((String)rficCode)) {
            return res;
        }
        for (Map.Entry<MCOCategory, String> entry : McoCategoriesCodesUtil.Mco2rficCodes.entrySet()) {
            if (!TextUtil.isSame((String)entry.getValue(), (String)rficCode)) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    public static MCOCategory getMcoCategory(String rfic, String rfisc, String description, ProductStatus relatedProductStatus) {
        MCOCategory res = MCOCategory.ADDITIONAL_SERVICES;
        if (!TextUtil.isBlank((String)rfic) && McoCategoriesCodesUtil.rfic2McoUniqueCodes.containsKey(rfic)) {
            return McoCategoriesCodesUtil.rfic2McoUniqueCodes.get(rfic);
        }
        if ("98F".equals(rfisc) && relatedProductStatus == ProductStatus.EXCHANGE) {
            return MCOCategory.REBOOKING;
        }
        if ("98F".equals(rfisc) && relatedProductStatus == ProductStatus.REFUND) {
            return MCOCategory.PENALTY;
        }
        if (!TextUtil.isBlank((String)rfisc) && McoCategoriesCodesUtil.rfiscMCOCategoryCodes.containsKey(rfisc)) {
            return McoCategoriesCodesUtil.rfiscMCOCategoryCodes.get(rfisc);
        }
        if ("993".equals(rfisc) && (relatedProductStatus == ProductStatus.EXCHANGE || relatedProductStatus == ProductStatus.REFUND)) {
            return relatedProductStatus == ProductStatus.EXCHANGE ? MCOCategory.REBOOKING : MCOCategory.PENALTY;
        }
        if ("07X".equals(rfisc)) {
            return MCOCategory.TICKET_REFUNDABILITY;
        }
        if ("997".equals(rfisc)) {
            return MCOCategory.DEPOSIT;
        }
        if (!TextUtil.isBlank((String)rfisc)) {
            for (Map.Entry<MCOCategory, List<String>> entry : McoCategoriesCodesUtil.MCOCategory2RficCodes.entrySet()) {
                List<String> values = entry.getValue();
                if (!values.contains(rfisc)) continue;
                return entry.getKey();
            }
        } else {
            if ("PENALTY".equals(description) && (relatedProductStatus == ProductStatus.EXCHANGE || relatedProductStatus == ProductStatus.REFUND)) {
                return relatedProductStatus == ProductStatus.EXCHANGE ? MCOCategory.REBOOKING : MCOCategory.PENALTY;
            }
            if (!TextUtil.isBlank((String)description) && McoCategoriesCodesUtil.mcoTypeDescription2Mco.containsKey(description)) {
                return McoCategoriesCodesUtil.mcoTypeDescription2Mco.get(description);
            }
        }
        return res;
    }

    public static boolean isProductInterline(Product product) {
        boolean result = false;
        DictionaryReference validatingCarrier = product.getCarrier();
        block0: for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                DictionaryReference marketingCarrier = seg.getAirline();
                result = validatingCarrier != null && marketingCarrier != null && !validatingCarrier.equals((Object)marketingCarrier);
                if (!result) continue;
                break block0;
            }
        }
        return result;
    }

    public static boolean isProductCodeShare(Product product) {
        boolean result = false;
        block0: for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                DictionaryReference marketingCarrier = seg.getAirline();
                DictionaryReference operatingCarrier = seg.getCodeShareCarrier();
                result = operatingCarrier != null && marketingCarrier != null && !operatingCarrier.equals((Object)marketingCarrier);
                if (!result) continue;
                break block0;
            }
        }
        return result;
    }

    public static ProductType getProductType(Product product) {
        if (product == null) {
            return null;
        }
        ProductCategory productCategory = product.getProductCategory();
        MCOCategory mcoCategory = product.getMcoCategory();
        return AirProductHelper.getProductType(productCategory, mcoCategory);
    }

    public static ProductType getProductType(ProductCategory productCategory, MCOCategory mcoCategory) {
        if (productCategory == ProductCategory.AIR) {
            return ProductType.AIR_TICKET;
        }
        if (productCategory == ProductCategory.EXCESS_BAGAGE) {
            return ProductType.EXCESS_BAGAGE;
        }
        if (productCategory == ProductCategory.MCO && mcoCategory != null) {
            switch (mcoCategory) {
                case ADDITIONAL_SERVICES: {
                    return ProductType.MCO_ADDITIONAL_SERVICES;
                }
                case ADDITIONAL_TARIFF: {
                    return ProductType.MCO_ADDITIONAL_TARIFF;
                }
                case ADDITIONAL_TAX: {
                    return ProductType.MCO_ADDITIONAL_TAX;
                }
                case STANDARD_PLUS: {
                    return ProductType.MCO_STANDART_PLUS;
                }
                case COMFORT: {
                    return ProductType.MCO_COMFORT;
                }
                case COMFORT_PLUS: {
                    return ProductType.MCO_COMFORT_PLUS;
                }
                case DUPLICATE_TICKET: {
                    return ProductType.MCO_DUPLICATE_TICKET;
                }
                case EXCESS_LUGGAGE: {
                    return ProductType.MCO_EXCESS_LUGGAGE;
                }
                case GROUP_PENALTY: {
                    return ProductType.MCO_GROUP_PENALTY;
                }
                case RESIDUAL_VALUE_FOR_REFUND: {
                    return ProductType.MCO_RESIDUAL_VALUE_FOR_REFUND;
                }
                case GROUP_PREPAYMENT: {
                    return ProductType.MCO_GROUP_PREPAYMENT;
                }
                case PENALTY: {
                    return ProductType.MCO_PENALTY;
                }
                case PTA: {
                    return ProductType.MCO_PTA;
                }
                case REBOOKING: {
                    return ProductType.MCO_REBOOKING;
                }
                case RETURN_FARE_DIFFERENCE: {
                    return ProductType.MCO_RETURN_FARE_DIFFERENCE;
                }
                case RETURN_TICKET: {
                    return ProductType.MCO_RETURN_TICKET;
                }
                case SEAT_RESERVATION: {
                    return ProductType.MCO_SEAT_RESERVATION;
                }
                case UNESCORTED_MINOR: {
                    return ProductType.MCO_UNESCORTED_MINOR;
                }
                case POSTAGE_FEE: {
                    return ProductType.MCO_POSTAGE_FEE;
                }
                case INFORMATION: {
                    return ProductType.MCO_INFORMATION;
                }
                case PAPER_SURCHARGE: {
                    return ProductType.MCO_PAPER_SURCHARGE;
                }
                case SPECIAL_FOOD: {
                    return ProductType.MCO_SPECIAL_FOOD;
                }
                case STICKER: {
                    return ProductType.MCO_STICKER;
                }
                case NOT_SOLD_SEATS: {
                    return ProductType.MCO_NOT_SOLD_SEATS;
                }
                case ANIMALS: {
                    return ProductType.MCO_ANIMALS;
                }
                case WEAPON: {
                    return ProductType.MCO_WEAPON;
                }
                case VOUCHER: {
                    return ProductType.MCO_VOUCHER;
                }
                case NAME_CHANGE: {
                    return ProductType.MCO_NAME_CHANGE;
                }
                case VIP_LOUNGE: {
                    return ProductType.MCO_VIP_LOUNGE;
                }
                case BUSINESS_LOUNGE: {
                    return ProductType.MCO_BUSINESS_LOUNGE;
                }
                case BUS_TICKET: {
                    return ProductType.MCO_BUS_TICKET;
                }
                case DEPOSIT: {
                    return ProductType.MCO_DEPOSIT;
                }
                case HOTEL: {
                    return ProductType.MCO_HOTEL;
                }
            }
        }
        return null;
    }

    public static Map<String, BigDecimal> getFaresByCarriersMap(Product product) {
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>();
        String noCarrierKey = "**";
        BigDecimal eqFare = AirProductHelper.getEquivalentFare(product);
        Money baseFareMoney = AirProductHelper.getBaseFare(product);
        BigDecimal baseFare = baseFareMoney != null ? baseFareMoney.getValue() : BigDecimal.ZERO;
        String eqCurrency = DictHelper.getEquivCurrency();
        BigDecimal rateEqToBase = eqFare != null && baseFare != null && BigDecimal.ZERO.compareTo(baseFare) < 0 ? eqFare.divide(baseFare, new MathContext(8, RoundingMode.HALF_UP)) : BigDecimal.ONE;
        MathContext mc = new MathContext(2, RoundingMode.HALF_UP);
        for (ProductFare fare : product.getFares()) {
            if (fare.getEquivalentFare() == null && fare.getNucFare() == null) continue;
            BigDecimal value = BigDecimal.ZERO;
            if (fare.getEquivalentFare() != null) {
                value = fare.getEquivalentFare();
            } else if (fare.getNucFare() != null) {
                if (fare.getRoe() != null) {
                    BigDecimal valueBase = fare.getNucFare().multiply(fare.getRoe());
                    value = valueBase.multiply(rateEqToBase, mc);
                } else {
                    value = FinanceHelper.exchange(fare.getNucFare(), "USD", eqCurrency, TariffType.REGULAR, product.getIssueDate());
                }
            }
            if (fare.getSegmentTariff() != null && fare.getSegmentTariff().getSegments().size() > 0) {
                String carrierCode = null;
                if (fare.getSegmentTariff().getSegments().size() == 1) {
                    if (fare.getSegmentTariff().getSegments().get(0) != null && ((Segment)fare.getSegmentTariff().getSegments().get(0)).getAirline() != null) {
                        carrierCode = ((Segment)fare.getSegmentTariff().getSegments().get(0)).getAirline().getCode();
                    }
                } else {
                    ArrayList<String> airlinesCodes = new ArrayList<String>();
                    for (Segment seg : fare.getSegmentTariff().getSegments()) {
                        if (seg == null || seg.getAirline() == null || seg.getAirline().getCode() == null) continue;
                        airlinesCodes.add(seg.getAirline().getCode());
                    }
                    carrierCode = product.getCarrier() != null && airlinesCodes.contains(product.getCarrier().getCode()) ? product.getCarrier().getCode() : (String)airlinesCodes.get(0);
                }
                if (TextUtil.isBlank(carrierCode)) {
                    carrierCode = noCarrierKey;
                }
                if (!res.containsKey(carrierCode)) {
                    res.put(carrierCode, value);
                    continue;
                }
                if (res.get(carrierCode) == null) continue;
                res.put(carrierCode, ((BigDecimal)res.get(carrierCode)).add(value));
                continue;
            }
            if (!res.containsKey(noCarrierKey)) {
                res.put(noCarrierKey, value);
                continue;
            }
            res.put(noCarrierKey, ((BigDecimal)res.get(noCarrierKey)).add(value));
        }
        if (res.keySet().size() == 1) {
            String key = (String)res.keySet().iterator().next();
            res.put(key, AirProductHelper.getEquivalentFare(product));
        }
        if (res.keySet().size() > 1 && res.containsKey(noCarrierKey)) {
            BigDecimal noCarrierValue = (BigDecimal)res.get(noCarrierKey);
            res.put(noCarrierKey, BigDecimal.ZERO);
            if (res.keySet().size() == 1) {
                res.put((String)res.keySet().iterator().next(), noCarrierValue);
            }
        }
        return res;
    }

    public static EntityReference<Organization> getSupplier(Product prod) {
        return GeneralProductHelper.getContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(Product prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(Product prod) {
        return GeneralProductHelper.getContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(Product prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(Product prod) {
        return GeneralProductHelper.getContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(Product prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static EntityReference<Organization> getTechnicalProvider(Product prod) {
        return GeneralProductHelper.getContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.TECHNICAL_PROVIDER);
    }

    public static void setTechnicalProvider(Product prod, EntityReference<Organization> value) {
        prod.setValue("technicalProvider", value);
        GeneralProductHelper.setContractor(AirProductHelper.getSalesChain(prod), PredefinedContractorType.TECHNICAL_PROVIDER, value);
    }

    public static List<ProductFop> getFops(Product prod, ContractType contractType) {
        if (ContractType.VENDOR.equals((Object)contractType)) {
            return AirProductHelper.getVendorFops(prod);
        }
        if (ContractType.SUBAGENCY.equals((Object)contractType)) {
            return AirProductHelper.getSubagentFops(prod, false);
        }
        if (ContractType.CLIENT.equals((Object)contractType)) {
            return AirProductHelper.getClientFops(prod);
        }
        return Collections.emptyList();
    }

    public static List<ProductFop> getVendorFops(Product prod) {
        return AirProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<ProductFop> getSubagentFops(Product prod, boolean autoUpdateSalesChain) {
        AirProductContractRelationData relation = AirProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<ProductFop> getClientFops(Product prod) {
        return AirProductHelper.getClientContractRelation(prod).getFops();
    }

    public static AirProductContractRelationData getVendorContractRelation(Product prod) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.VENDOR) continue;
            return relation;
        }
        throw new IllegalStateException("suppplier contract relation is absent in product");
    }

    public static AirProductContractRelationData getSubagentContractRelation(Product prod) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
            return relation;
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static AirProductContractRelationData getClientContractRelation(Product prod) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.CLIENT) continue;
            return relation;
        }
        throw new IllegalStateException("client contract relation is absent in product");
    }

    public static AirProductContractRelationData getSubagentContractRelation(Product prod, boolean autoUpdateSalesChain) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
            return relation;
        }
        SalesChain salesChain = AirProductHelper.getSalesChain(prod);
        SalesChainDescription description = (SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity();
        if (GeneralProductHelper.isOwnPredefinedSalesChainType(description.getPredefinedType())) {
            if (!autoUpdateSalesChain) {
                return null;
            }
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
            Contractor contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(PredefinedContractorType.SUBAGENCY));
            contractor.setContractor(GeneralProductHelper.getContractor(salesChain, PredefinedContractorType.AGENCY));
            List lst = salesChain.getContractors();
            lst.add(lst.size() - 1, contractor);
            for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(prod)) {
                if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ContractType.SUBAGENCY) continue;
                return relation;
            }
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static List<Commission> getUnmodifiableCommissions(Product prod, ContractType contractType) {
        ArrayList<Commission> filteredCommissions = new ArrayList<Commission>();
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations(prod)) {
            if (contractType != null && GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != contractType) continue;
            filteredCommissions.addAll(relation.getCommissions());
        }
        return filteredCommissions;
    }

    public static void clearCommissions(Product prod) {
        AirProductHelper.getCommissionFromOldSource(prod).clear();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(prod)) {
            item.getCommissions().clear();
        }
    }

    public static void clearFops(Product prod) {
        AirProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR).clear();
        AirProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY).clear();
        AirProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT).clear();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(prod)) {
            item.getFops().clear();
        }
    }

    public static void clearContractRelations(Product prod) {
        List relations = (List)prod.getValue("contractRelations");
        relations.clear();
    }

    public static void addFopToAllContractRelations(Product prod, ProductFop fop) {
        AirProductHelper.addFopsToAllContractRelations(prod, Collections.singletonList(fop));
    }

    private static void addFopsToAllContractRelations(Product prod, List<ProductFop> fops) {
        boolean first = true;
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(prod)) {
            ArrayList<ProductFop> newFops = new ArrayList<ProductFop>();
            if (first) {
                newFops.addAll(fops);
            } else {
                for (ProductFop fop : fops) {
                    ArrayList fares = new ArrayList(fop.getFares());
                    ArrayList taxes = new ArrayList(fop.getTaxes());
                    ArrayList commissions = new ArrayList(fop.getCommissions());
                    fop.getFares().clear();
                    fop.getTaxes().clear();
                    fop.getCommissions().clear();
                    try {
                        ProductFop newFop = (ProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                        newFops.add(newFop);
                        newFop.getFares().addAll(fares);
                        newFop.getTaxes().addAll(taxes);
                        newFop.getCommissions().addAll(commissions);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                    finally {
                        fop.getFares().addAll(fares);
                        fop.getTaxes().addAll(taxes);
                        fop.getCommissions().addAll(commissions);
                    }
                }
            }
            item.getFops().addAll(newFops);
            first = false;
        }
    }

    public static SalesChain getSalesChain(Product prod) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)prod);
    }

    public static void setSalesChain(Product prod, SalesChain salesChain) throws Exception {
        SalesChain sc = (SalesChain)XCloneHelper.clone((XCloneable)salesChain);
        for (Contractor item : sc.getContractors()) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getDescription());
            if (ctr == null || ((ContractorDescription)ctr.getEntity()).getPredefinedType() != PredefinedContractorType.CLIENT) continue;
            sc.getContractors().remove(item);
            break;
        }
        prod.setValue("salesChain", (Object)sc);
    }

    public static List<AirProductContractRelationData> getContractRelations(Product prod) {
        List originalRelations = (List)prod.getValue("contractRelations");
        SalesChain salesChain = AirProductHelper.getSalesChain(prod);
        ArrayList<AirProductContractRelationData> subresult = new ArrayList<AirProductContractRelationData>();
        ArrayList toDelete = new ArrayList(originalRelations);
        boolean modified = false;
        for (EntityReference item : ((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getContractRelations()) {
            AirProductContractRelationData relation = AirProductHelper.findContractRelation((List<AirProductContractRelationData>)originalRelations, (EntityReference<ContractRelationDescription>)item);
            if (relation != null) {
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            PredefinedContractRelationType predefinedType = ((ContractRelationDescription)EntityStorage.get().resolve(item).getEntity()).getPredefinedType();
            if ((predefinedType == PredefinedContractRelationType.AGENCY_TO_CLIENT || predefinedType == PredefinedContractRelationType.SUBAGENCY_TO_CLIENT) && (relation = AirProductHelper.findContractRelation((List<AirProductContractRelationData>)originalRelations, ContractType.CLIENT)) != null) {
                relation.setDescription(item);
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            relation = new AirProductContractRelationData();
            relation.setDescription(item);
            AirProductHelper.updateRelationFromOldFields(prod, relation);
            subresult.add(relation);
            modified = true;
        }
        if (modified || !toDelete.isEmpty()) {
            originalRelations.clear();
            originalRelations.addAll(subresult);
            AirProductHelper.getCommissionFromOldSource(prod).clear();
            AirProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR).clear();
            AirProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY).clear();
            AirProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT).clear();
        }
        return originalRelations;
    }

    public static AirProductContractRelationData findContractRelation(List<AirProductContractRelationData> relations, EntityReference<ContractRelationDescription> description) {
        if (description == null) {
            return null;
        }
        for (AirProductContractRelationData relation : relations) {
            if (relation.getDescription() == null || !relation.getDescription().equals(description)) continue;
            return relation;
        }
        return null;
    }

    public static AirProductContractRelationData findContractRelation(List<AirProductContractRelationData> relations, ContractType type) {
        for (AirProductContractRelationData relation : relations) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != type) continue;
            return relation;
        }
        return null;
    }

    private static void updateRelationFromOldFields(Product prod, AirProductContractRelationData relation) {
        relation.getCommissions().clear();
        relation.getFops().clear();
        switch (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription())) {
            case VENDOR: {
                relation.getCommissions().addAll(AirProductHelper.getUnmodifiableCommissionFromOldSource(prod, ContractType.VENDOR));
                relation.getFops().addAll(AirProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR));
                break;
            }
            case SUBAGENCY: {
                relation.getCommissions().addAll(AirProductHelper.getUnmodifiableCommissionFromOldSource(prod, ContractType.SUBAGENCY));
                relation.getFops().addAll(AirProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY));
                break;
            }
            case CLIENT: {
                relation.getCommissions().addAll(AirProductHelper.getUnmodifiableCommissionFromOldSource(prod, ContractType.CLIENT));
                relation.getFops().addAll(AirProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT));
            }
        }
    }

    private static List<Commission> getCommissionFromOldSource(Product prod) {
        return (List)prod.getValue("commissions");
    }

    private static List<Commission> getUnmodifiableCommissionFromOldSource(Product prod, ContractType ctype) {
        ArrayList<Commission> result = new ArrayList<Commission>();
        for (Commission item : AirProductHelper.getCommissionFromOldSource(prod)) {
            if (ctype != null && ctype != item.getContractType()) continue;
            result.add(item);
        }
        return result;
    }

    private static List<ProductFop> getFopsFromOldSource(Product prod, ContractType contractType) {
        String propertyName = null;
        switch (contractType) {
            case VENDOR: {
                propertyName = "vendorFops";
                break;
            }
            case SUBAGENCY: {
                propertyName = "subagentFops";
                break;
            }
            case CLIENT: {
                propertyName = "clientFops";
            }
        }
        return (List)prod.getValue(propertyName);
    }

    public static BigDecimal getPenaltyWithMcoValue(Product product) {
        BigDecimal result = MiscUtil.guarded((BigDecimal)product.getPenalty());
        for (Product mco : AirProductHelper.getMcoByRelatedProduct(product)) {
            BigDecimal pen = AirProductHelper.getEquivalentFare(mco);
            if (pen == null) continue;
            result = result.add(pen);
        }
        return result;
    }

    public static BigDecimal getObFeesValue(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        for (OBFee ob : product.getObFees()) {
            if (ob == null || ob.getAmount() == null || ob.getAmount().getValue() == null) continue;
            result = result.add(ob.getAmount().getValue());
        }
        return result;
    }

    public static BigDecimal calculateTaxVatAmount(Product product, Tax tax, boolean nullIfUndefined) {
        if (product.getVendorVatDetalization() != null) {
            for (VatComponent comp : product.getVendorVatDetalization().getComponents()) {
                if (!comp.getTaxesUids().contains(tax.getUid())) continue;
                return comp.getTaxesUids().size() > 1 && nullIfUndefined ? null : comp.getSum();
            }
            return null;
        }
        return (BigDecimal)tax.getValue("equivalentVatAmount");
    }

    public static BigDecimal getPenaltyVatAmount(Product product) {
        if (product.getVendorVatDetalization() != null) {
            BigDecimal result = BigDecimal.ZERO;
            for (VatComponent comp : product.getVendorVatDetalization().getComponents()) {
                if (!comp.getBasisTypes().contains(VatBasisType.PENALTY)) continue;
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, comp.getSum()});
            }
            return result;
        }
        return MiscUtil.guarded((BigDecimal)((BigDecimal)product.getValue("penaltyEquivalentVatAmount")));
    }

    public static BigDecimal calculateTaxesVatAmount(Product product, String taxCode) {
        if (product.getVendorVatDetalization() != null) {
            BigDecimal result = null;
            for (VatComponent comp : product.getVendorVatDetalization().getComponents()) {
                boolean matched = false;
                for (String taxUid : comp.getTaxesUids()) {
                    Tax tax = (Tax)CollectionUtil.find((Iterable)product.getTaxes(), (String)taxUid);
                    if (tax == null || taxCode != null && !taxCode.equalsIgnoreCase(tax.getCode())) continue;
                    matched = true;
                    break;
                }
                if (!matched) continue;
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, comp.getSum()});
            }
            return result;
        }
        BigDecimal taxesVat = null;
        for (Tax tax : product.getTaxes()) {
            BigDecimal equivalentTaxAmount = (BigDecimal)tax.getValue("equivalentVatAmount");
            if (equivalentTaxAmount == null || taxCode != null && !taxCode.equalsIgnoreCase(tax.getCode())) continue;
            taxesVat = taxesVat != null ? taxesVat.add(equivalentTaxAmount) : equivalentTaxAmount;
        }
        return taxesVat;
    }

    public static BigDecimal calculateTaxesVatAmount(Product product) {
        return AirProductHelper.calculateTaxesVatAmount(product, null);
    }

    public static String getSettlementAccount(Product product) {
        List payments;
        BookingFile bookingFile;
        String settlementAccount = "";
        Reservation reservation = product.getReservation();
        if (reservation != null && (bookingFile = product.getReservation().getBookingFile()) != null && (payments = bookingFile.getPayments()) != null) {
            for (Payment payment : payments) {
                BankAccount bankAccount;
                List billingItems = payment.getBillingItems();
                if (billingItems == null || !AirProductHelper.isBillingItemWithAssociatedProductUid(billingItems, product.getUid()) || (bankAccount = payment.getBankAccount()) == null || bankAccount.getSettlementAccount() == null) continue;
                settlementAccount = bankAccount.getSettlementAccount();
                break;
            }
        }
        return settlementAccount;
    }

    public static boolean isBillingItemWithAssociatedProductUid(List<BillingItem> items, String productUid) {
        return items.stream().flatMap(item -> item.getProductUids().stream()).collect(Collectors.toList()).contains(productUid);
    }

    public static Commission getApplicableCommission(Collection<Commission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> commissionPropertiesClass) throws Exception {
        for (Commission commission : commissions) {
            if (contractType == null || commission.getContractType() != contractType || commission.getEquivalentAmount() == null || commissionPropertiesClass != null && (commission.getCommissionProperties() != null && !commissionPropertiesClass.getName().equals(commission.getCommissionProperties().getType().getName()) || commission.getCommissionProperties() == null && !CommissionProperties.class.getName().equals(commissionPropertiesClass.getName()))) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                boolean valid;
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                boolean bl = valid = commissionPropertiesContainer == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() && !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus();
                if (!valid) continue;
            }
            return commission;
        }
        return null;
    }

    public static boolean isDirect(Product product) {
        boolean hasStartingSegment = false;
        block0: for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                if (!s.isStarting()) continue;
                hasStartingSegment = true;
                break block0;
            }
        }
        if (!hasStartingSegment) {
            int segmentsCount = 0;
            DictionaryReference departureLocation = null;
            DictionaryReference arrivalLocation = null;
            for (SegmentTariff st : product.getSegmentTariffs()) {
                for (Segment s : st.getSegments()) {
                    if (segmentsCount == 0) {
                        departureLocation = s.getDepartureLocation();
                    }
                    arrivalLocation = s.getArriveLocation();
                    ++segmentsCount;
                }
            }
            if (segmentsCount == 1) {
                return true;
            }
            if (segmentsCount == 2 && departureLocation != null && arrivalLocation != null) {
                GeoLocation departureCity = DictHelper.findCity(departureLocation);
                GeoLocation arrivalCity = DictHelper.findCity(arrivalLocation);
                return departureCity != null && departureCity.equals((Object)arrivalCity);
            }
            return false;
        }
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                if (s.isStarting()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isServiceFop(ProductFop fop) {
        boolean hasNotHiddenFee = false;
        for (Commission comm : fop.getCommissions()) {
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof FeeProperties)) {
                hasNotHiddenFee = true;
                break;
            }
            FeeProperties feeProp = (FeeProperties)ctr.getEntity();
            if (feeProp.isHidden()) continue;
            hasNotHiddenFee = true;
        }
        return !hasNotHiddenFee;
    }

    public static String getProductTitle(Product product) {
        return product.getSystemNumber() != null ? product.getSystemNumber() : (product.getTraveller() != null ? product.getTraveller().getName() : "?");
    }

    public static BigDecimal getClientCommissionsEquivalentAmount(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        for (Commission commission : AirProductHelper.getClientContractRelation(product).getCommissions()) {
            result = result.add(commission.getEquivalentAmount());
        }
        return result;
    }

    public static boolean isPenaltyTax(DictionaryReference<Airline> airline, Tax tax) {
        if (tax == null || tax.getCode() == null) {
            return false;
        }
        return AirProductHelper.isPenaltyTax(airline, tax.getCode());
    }

    public static boolean isPenaltyTax(DictionaryReference<Airline> airline, String taxCode) {
        String airlineCode;
        String string = airlineCode = airline != null ? airline.getCode() : null;
        if (taxCode == null) {
            return false;
        }
        if (penaltyTaxesForAirlines.containsKey(airlineCode)) {
            return penaltyTaxesForAirlines.get(airlineCode).contains(taxCode.toUpperCase());
        }
        return penaltyTaxesForAirlines.get(null).contains(taxCode.toUpperCase());
    }

    public static void changeProductSubagencyForVip(EntityContainer<BookingFile> bfc) {
        EntityContainer bfcPrev;
        if (bfc == null || bfc.getEntity() == null) {
            return;
        }
        HashMap<String, EntityReference<Organization>> bookings2Subagency = new HashMap<String, EntityReference<Organization>>();
        EntityReference<Organization> subagencyFromVoidedBooking = null;
        if (bfc.getUid() != null && bfc.getVersionInfo() != null && (bfcPrev = EntityStorage.get().load(BookingFile.class, bfc.getUid(), Integer.valueOf(bfc.getVersionInfo().getVersionNumber()))) != null && bfcPrev.getEntity() != null) {
            boolean hasAtLeastOneOnlineReservation = false;
            for (Reservation res : ((BookingFile)bfcPrev.getEntity()).getReservations()) {
                if (res.getType() != ReservationType.INTERNET && res.getType() != ReservationType.IBE) continue;
                hasAtLeastOneOnlineReservation = true;
                break;
            }
            if (hasAtLeastOneOnlineReservation) {
                for (Reservation res : ((BookingFile)bfcPrev.getEntity()).getReservations()) {
                    for (BaseProduct bp : res.getProducts()) {
                        if (!(bp instanceof Product)) continue;
                        Product prevProd = (Product)bp;
                        if (prevProd.getStatus() == ProductStatus.BOOKING) {
                            bookings2Subagency.put(prevProd.getUid(), AirProductHelper.getSubagency(prevProd));
                        }
                        if (prevProd.getStatus() != ProductStatus.VOID_BOOKING) continue;
                        subagencyFromVoidedBooking = AirProductHelper.getSubagency(prevProd);
                    }
                }
            }
        }
        boolean hasAtLeastOneOnlineReservation = false;
        for (Reservation res : ((BookingFile)bfc.getEntity()).getReservations()) {
            if (res.getType() != ReservationType.INTERNET && res.getType() != ReservationType.IBE) continue;
            hasAtLeastOneOnlineReservation = true;
            break;
        }
        if (hasAtLeastOneOnlineReservation) {
            for (Reservation res : ((BookingFile)bfc.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    if (!(bp instanceof Product)) continue;
                    AirProductHelper.changeProductSubagencyForVip((Product)bp, bookings2Subagency, subagencyFromVoidedBooking);
                }
            }
        }
    }

    private static void changeProductSubagencyForVip(Product product, Map<String, EntityReference<Organization>> bookings2Subagency, EntityReference<Organization> subagencyFromVoidedBooking) {
        if (bookings2Subagency.get(product.getUid()) != null) {
            AirProductHelper.setSubagency(product, bookings2Subagency.get(product.getUid()));
        }
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getPreviousProduct() != null) {
            AirProductHelper.setSubagency(product, AirProductHelper.getSubagency(product.getPreviousProduct().getPreviousProduct()));
            AirProductHelper.setSubagency(product.getPreviousProduct(), AirProductHelper.getSubagency(product.getPreviousProduct().getPreviousProduct()));
        } else if (product.getPreviousProduct() != null) {
            AirProductHelper.setSubagency(product, AirProductHelper.getSubagency(product.getPreviousProduct()));
        } else if (!product.getRelatedProducts().isEmpty()) {
            AirProductHelper.setSubagency(product, AirProductHelper.getSubagency((Product)product.getRelatedProducts().get(0)));
        } else if (subagencyFromVoidedBooking != null) {
            AirProductHelper.setSubagency(product, subagencyFromVoidedBooking);
        }
    }

    public static MiscUtil.Pair<Segment, SpecialServiceRequest> findSegmentAndSsr(Product product, String ssrUid) {
        if (TextUtil.isBlank((String)ssrUid)) {
            return null;
        }
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                for (SpecialServiceRequest ssr : seg.getSsrs()) {
                    if (!ssrUid.equals(ssr.getUid())) continue;
                    return new MiscUtil.Pair((Object)seg, (Object)ssr);
                }
            }
        }
        return null;
    }

    public static Segment findSegmentByUid(Product product, String uid) {
        for (Segment s : AirProductHelper.getSegments(product.getSegmentTariffs())) {
            if (!uid.equals(s.getUid())) continue;
            return s;
        }
        return null;
    }

    public static boolean isIssuedInExchange(Product prod) {
        return prod != null && prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
    }

    @Deprecated
    public static Collection<Commission> filterSubagentCommissionsIncludeFilterByChargeToClient(Product prod) {
        ArrayList<Commission> filteredCommissions = new ArrayList<Commission>();
        Collection<Commission> filteredCommissionsByProperties = GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(prod, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, null);
        for (Commission commission : filteredCommissionsByProperties) {
            EntityContainer propCtr;
            if (commission.getCommissionProperties().getType() == FeeProperties.class && ((propCtr = EntityStorage.get().resolve(commission.getCommissionProperties())) == null || !((FeeProperties)propCtr.getEntity()).isChargeToClientForAllContractTypes())) continue;
            filteredCommissions.add(commission);
        }
        return filteredCommissions;
    }

    public static LuggageInfo parseLuggageInfo(String data) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        String chars = null;
        Matcher mChars = LUGGAGE_INFO_CHARS_PATTERN.matcher(data);
        if (mChars.find()) {
            chars = mChars.group();
        }
        if (chars == null) {
            return null;
        }
        LuggageInfo info = new LuggageInfo();
        LuggageUnit lu = DictHelper.findLuggageUnitBySpellVariant(chars);
        if (lu != null && DictHelper.isNil(lu)) {
            info.setNil(true);
            info.setUnit((DictionaryReference)lu.toReference());
        } else {
            if (lu != null) {
                info.setUnit((DictionaryReference)lu.toReference());
            } else {
                info.setUnit((DictionaryReference)new LuggageUnitReference(chars));
            }
            String digits = null;
            Matcher mDigits = LUGGAGE_INFO_DIGITS_PATTERN.matcher(data);
            if (mDigits.find()) {
                digits = mDigits.group();
            }
            if (digits != null) {
                info.setQuantity(Integer.valueOf(digits));
            }
        }
        return info;
    }

    public static LuggageInfo buildLuggageInfo(Integer quantity, String luggageUnitCode) {
        if (StringUtils.isBlank((String)luggageUnitCode)) {
            return null;
        }
        LuggageInfo info = new LuggageInfo();
        LuggageUnit lu = DictHelper.findLuggageUnitBySpellVariant(luggageUnitCode);
        if (lu != null && DictHelper.isNil(lu)) {
            info.setNil(true);
            info.setUnit((DictionaryReference)lu.toReference());
        } else {
            if (lu != null) {
                info.setUnit((DictionaryReference)lu.toReference());
            } else {
                info.setUnit((DictionaryReference)new LuggageUnitReference(luggageUnitCode));
            }
            info.setQuantity(quantity);
            if (quantity != null && quantity == 0) {
                info.setNil(true);
            }
        }
        return info;
    }

    public static LuggageInfo buildNilLuggageInfo() {
        LuggageInfo info = new LuggageInfo();
        info.setNil(true);
        info.setUnit(DictHelper.toReference(DictHelper.getNilLuggageUnit()));
        return info;
    }

    public static String luggageInfoToCodeSring(LuggageInfo info) {
        if (info == null) {
            return null;
        }
        String digits = null;
        if (info.getQuantity() != null) {
            digits = info.getQuantity().toString();
        }
        String units = null;
        if (info.getUnit() != null) {
            LuggageUnit lu = (LuggageUnit)DictionaryCache.get().resolveReference(info.getUnit());
            units = lu != null && !lu.getSpellVariants().isEmpty() ? (String)lu.getSpellVariants().iterator().next() : info.getUnit().getCode();
        } else if (info.isNil()) {
            units = DictHelper.getNilLuggageUnit().getCode();
        }
        StringBuilder sb = new StringBuilder();
        if (digits != null) {
            sb.append(digits);
        }
        if (units != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(units);
        }
        return sb.toString();
    }

    public static String luggageInfoToSring(LuggageInfo info, Locale locale) {
        if (info == null) {
            return null;
        }
        if (info.isNil()) {
            return (String)MiscUtil.findByLocale((Map)DictHelper.getNilLuggageUnit().getTranslations(), (Locale)locale);
        }
        String digits = null;
        if (info.getQuantity() != null) {
            digits = info.getQuantity().toString();
        }
        String units = null;
        if (info.getUnit() != null) {
            LuggageUnit lu = (LuggageUnit)DictionaryCache.get().resolveReference(info.getUnit());
            units = lu != null ? (String)MiscUtil.findByLocale((Map)lu.getTranslations(), (Locale)locale) : info.getUnit().getCode();
        }
        StringBuilder sb = new StringBuilder();
        if (digits != null) {
            sb.append(digits);
        }
        if (units != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(units);
        }
        return sb.toString();
    }

    public static boolean isAirProduct(BaseProduct product) {
        return product instanceof Product && ((Product)product).getProductCategory() == ProductCategory.AIR;
    }

    public static boolean isEmdProduct(BaseProduct product) {
        return product instanceof Product && ((Product)product).getProductCategory() == ProductCategory.MCO;
    }

    public static boolean isAirProductOrEMD(BaseProduct product) {
        return product instanceof Product && (((Product)product).getProductCategory() == ProductCategory.AIR || ((Product)product).getProductCategory() == ProductCategory.MCO);
    }

    public static boolean isAirProductOrEMDOrBagage(BaseProduct product) {
        return product instanceof Product && (((Product)product).getProductCategory() == ProductCategory.AIR || ((Product)product).getProductCategory() == ProductCategory.MCO || ((Product)product).getProductCategory() == ProductCategory.EXCESS_BAGAGE || ((Product)product).getProductCategory() == null);
    }

    public static Stream<Segment> getProductSegmentsStream(Product product) {
        return product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream());
    }

    public static List<Segment> getProductSegmentsList(Product product) {
        return AirProductHelper.getProductSegmentsStream(product).collect(Collectors.toList());
    }

    public static Stream<Product> getAirProductsStream(Reservation reservation) {
        return reservation.getProducts().stream().filter(AirProductHelper::isAirProduct).map(AirProductHelper::toAirProduct);
    }

    public static List<Product> getAirProductsList(Reservation reservation) {
        return AirProductHelper.getAirProductsStream(reservation).collect(Collectors.toList());
    }

    public static Function<BaseProduct, Product> toAirProduct() {
        return p -> (Product)p;
    }

    public static Product toAirProduct(BaseProduct baseProduct) {
        return (Product)baseProduct;
    }

    public static Reservation getAirReservation(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().filter(AirProductHelper::isAirReservation).findFirst().orElse(null);
    }

    public static boolean isAirReservation(Reservation reservation) {
        return reservation.getProducts().stream().anyMatch(AirProductHelper::isAirProduct);
    }

    public static Reservation getAviaReservation(EntityContainer<BookingFile> bookingFile) {
        return AirProductHelper.getAviaReservation((BookingFile)bookingFile.getEntity());
    }

    public static Reservation getAviaReservation(BookingFile bookingFile) {
        return BookingHelper.getFirstReservationForProduct(bookingFile, Product.class);
    }

    public static boolean isWithoutBaggage(LuggageInfo luggageInfo) {
        return luggageInfo.isNil() || luggageInfo.getUnit() != null && DictHelper.getNilLuggageUnit().getCode().equals(luggageInfo.getUnit().getCode());
    }

    public static boolean isWithBaggage(LuggageInfo luggageInfo) {
        return !AirProductHelper.isWithoutBaggage(luggageInfo);
    }

    public static String getClassOfServiceCode(Segment segment) {
        String result = segment.getClassOfSvcCode();
        if (TextUtil.isBlank((String)result) || result.trim().length() > 1) {
            result = segment.getClassOfService();
        }
        if (!TextUtil.isBlank((String)segment.getFareBasis()) && (TextUtil.isBlank((String)result) || result.trim().length() > 1)) {
            result = segment.getFareBasis().trim().substring(0, 1);
        }
        return result;
    }

    public static String getFullNumber(Product product) {
        StringBuilder sb = new StringBuilder();
        sb.append(product.getCarrierNumber());
        sb.append(product.getSystemNumber());
        if (product.getConjCount() > 0) {
            BigDecimal n = new BigDecimal(product.getSystemNumber());
            n = n.add(BigDecimal.valueOf(product.getConjCount()));
            DecimalFormat df = new DecimalFormat("##########");
            String nstr = df.format(n);
            int i = 0;
            while (product.getSystemNumber().charAt(i) == nstr.charAt(i)) {
                ++i;
            }
            sb.append('/');
            sb.append(nstr.substring(i));
        }
        return sb.toString();
    }

    public static void clearCommissionsExceptManuallyCalculated(Product prod) throws Exception {
        AirProductHelper.clearCommissionsExceptManuallyCalculated(prod, false);
    }

    public static void clearCommissionsExceptManuallyCalculated(Product prod, boolean processRefundVoidExchange) throws Exception {
        HashSet previousManualFees = new HashSet();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(prod)) {
            HashSet<Commission> manualFees = new HashSet<Commission>();
            Iterator it = item.getCommissions().iterator();
            while (it.hasNext()) {
                Commission commission = (Commission)it.next();
                if (processRefundVoidExchange || prod.getStatus() != ProductStatus.EXCHANGE && prod.getStatus() != ProductStatus.REFUND && !ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus())) {
                    EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
                    if (ctr != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).getType() == FeeType.MANUALLY_CALCULATED) {
                        boolean partialRefund;
                        Set cases = ((FeeProperties)ctr.getEntity()).getReturnCases();
                        Set refexTypes = ((FeeProperties)ctr.getEntity()).getRefexTypes();
                        boolean bl = partialRefund = prod.getPreviousProduct() != null && prod.getSegmentTariffs().size() < prod.getPreviousProduct().getSegmentTariffs().size();
                        if (prod.getStatus() == ProductStatus.REFUND) {
                            if (prod.isForcedRefund() && !cases.isEmpty() && !cases.contains(ReturnCase.FORCED_REFUND)) {
                                it.remove();
                                continue;
                            }
                            if (!(prod.isForcedRefund() || cases.isEmpty() || cases.contains(ReturnCase.REFUND))) {
                                it.remove();
                                continue;
                            }
                            if (partialRefund && !refexTypes.contains(RefexType.PARTIAL)) {
                                it.remove();
                                continue;
                            }
                            if (!partialRefund && !refexTypes.contains(RefexType.FULL)) {
                                it.remove();
                                continue;
                            }
                        }
                        if (prod.getStatus() == ProductStatus.EXCHANGE) {
                            if (prod.isForcedRefund() && !cases.isEmpty() && !cases.contains(ReturnCase.FORCED_EXCHANGE)) {
                                it.remove();
                                continue;
                            }
                            if (!(prod.isForcedRefund() || cases.isEmpty() || cases.contains(ReturnCase.EXCHANGE))) {
                                it.remove();
                                continue;
                            }
                            if (partialRefund && !refexTypes.contains(RefexType.PARTIAL)) {
                                it.remove();
                                continue;
                            }
                            if (!partialRefund && !refexTypes.contains(RefexType.FULL)) {
                                it.remove();
                                continue;
                            }
                        }
                        if ((ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus()) || prod.getUid().contains(VOID_VIRTUAL_TICKET_PREFIX)) && cases.contains(ReturnCase.VOID)) {
                            it.remove();
                            continue;
                        }
                        boolean existInPrevRelations = false;
                        for (Commission manualComm : previousManualFees) {
                            if (!manualComm.getCommissionProperties().equals((Object)commission.getCommissionProperties())) continue;
                            existInPrevRelations = true;
                            break;
                        }
                        if (!existInPrevRelations) {
                            manualFees.add(commission);
                            continue;
                        }
                    }
                    if (ctr != null && ctr.getEntity() instanceof CommissionProperties && ((CommissionProperties)ctr.getEntity()).isManuallyCalculated() || ctr != null && ctr.getEntity() instanceof DiscountProperties && ((DiscountProperties)ctr.getEntity()).getType() == DiscountType.MANUALLY_CALCULATED) continue;
                }
                it.remove();
            }
            previousManualFees.addAll(manualFees);
        }
    }

    public static void copyManualCommissions(Product source, Product dest) {
        try {
            AirProductHelper.clearCommissionsExceptManuallyCalculated(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations(source)) {
            AirProductContractRelationData subagencyRelation;
            if (item == null) continue;
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) == ContractType.VENDOR) {
                AirProductHelper.getVendorContractRelation(dest).getCommissions().addAll(item.getCommissions());
            }
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) == ContractType.SUBAGENCY && (subagencyRelation = AirProductHelper.getSubagentContractRelation(dest, false)) != null) {
                subagencyRelation.getCommissions().addAll(item.getCommissions());
            }
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) != ContractType.CLIENT) continue;
            AirProductHelper.getClientContractRelation(dest).getCommissions().addAll(item.getCommissions());
        }
    }

    public static boolean isRoundTrip(Product product) {
        if (product.getSegmentTariffs().isEmpty()) {
            return false;
        }
        List firstSegments = ((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments();
        if (firstSegments.isEmpty()) {
            return false;
        }
        GeoLocation departureCity = DictHelper.findCity((DictionaryReference<GeoLocation>)((Segment)firstSegments.get(0)).getDepartureLocation());
        if (departureCity == null) {
            return false;
        }
        List lastSegments = ((SegmentTariff)product.getSegmentTariffs().get(product.getSegmentTariffs().size() - 1)).getSegments();
        if (lastSegments.isEmpty()) {
            return false;
        }
        GeoLocation arrivalCity = DictHelper.findCity((DictionaryReference<GeoLocation>)((Segment)lastSegments.get(lastSegments.size() - 1)).getArriveLocation());
        if (arrivalCity == null) {
            return false;
        }
        return departureCity.equals((Object)arrivalCity);
    }

    public static boolean isFareAndTaxesVatSeparated(VatDetalization vendorVatDetalization) {
        if (vendorVatDetalization == null) {
            return false;
        }
        boolean notSeparated = vendorVatDetalization.getComponents().stream().anyMatch(it -> it.getBasisTypes().contains(VatBasisType.FARE) && it.getBasisTypes().contains(VatBasisType.TAXES));
        return !notSeparated;
    }

    public static boolean isFareFopsRelevant(Product product) {
        return GeneralProductHelper.getHandler(product).isFareFopsRelevant(product);
    }

    public static Integer getGeoDistanceInMiles(Segment segment) {
        return DictHelper.getGeoDistanceInMiles((DictionaryReference<GeoLocation>)segment.getArriveLocation(), (DictionaryReference<GeoLocation>)segment.getDepartureLocation());
    }

    public static Predicate<Product> productStatus(ProductStatus productStatus) {
        return product -> product.getStatus() == productStatus;
    }

    public static void updateRecordNumbers(Product prod) {
        int n = 1;
        DictionaryReference lastSegArrival = null;
        for (Segment seg : AirProductHelper.getSegments(prod.getSegmentTariffs())) {
            if (lastSegArrival != null && !lastSegArrival.equals((Object)seg.getDepartureLocation())) {
                ++n;
            }
            seg.setRecordNumber(n);
            lastSegArrival = seg.getArriveLocation();
            ++n;
        }
    }

    public static boolean isVatCalculated(Product product) {
        return product.getTotalVendorEquivalentVatAmount() != null || product.isVendorVatCalculated();
    }

    public static void changeFopsPaymentTypes(List<ProductFop> fops, PaymentType newPaymentType, boolean updateOnlyFeeFops) {
        if (updateOnlyFeeFops) {
            fops.stream().filter(fop -> !AirProductHelper.isServiceFop(fop)).forEach(fop -> fop.setType(newPaymentType));
        } else {
            fops.stream().filter(AirProductHelper::isServiceFop).forEach(fop -> fop.setType(newPaymentType));
        }
    }

    public static boolean removeProduct(Product product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        if (AirProductHelper.getDuplicateByRelatedProduct(product).size() > 0) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            AirProductHelper.removeProduct(product.getPreviousProduct());
        }
        return true;
    }

    public static boolean removeRelatedProduct(Product product, BaseProduct relatedProduct) {
        product.getRelatedProducts().remove((Product)relatedProduct);
        return true;
    }

    public static boolean isEffectiveProduct(Product product) {
        return product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null;
    }

    public static boolean isTripartiteDiscount(TripartiteContractDetails tripartiteContractDetails) {
        return Optional.ofNullable(tripartiteContractDetails).map(TripartiteContractDetails::isIssuedUnder3d).orElse(false);
    }

    public static boolean isTripartiteDiscount(Product product) {
        return AirProductHelper.isTripartiteDiscount(product.getTripartiteContractDetails());
    }

    public static String getCities(List<SegmentTariff> segmentTariffs, Locale locale) {
        StringBuilder cities = new StringBuilder();
        DictionaryReference<GeoLocation> previousArriveCity = null;
        boolean first = true;
        for (Segment segment : segmentTariffs.stream().flatMap(item -> item.getSegments().stream()).collect(Collectors.toList())) {
            DictionaryReference<GeoLocation> departureCity = DictHelper.getCity((DictionaryReference<GeoLocation>)segment.getDepartureLocation());
            DictionaryReference<GeoLocation> arriveCity = DictHelper.getCity((DictionaryReference<GeoLocation>)segment.getArriveLocation());
            if (first) {
                cities.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureCity)).map(item -> item.toString(locale)).orElse("?"));
                first = false;
            } else if (!MiscUtil.equals(previousArriveCity, departureCity)) {
                cities.append(" / ");
                cities.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureCity)).map(item -> item.toString(locale)).orElse("?"));
            }
            cities.append(" - ");
            cities.append(Optional.ofNullable(DictionaryCache.get().resolveReference(arriveCity)).map(item -> item.toString(locale)).orElse("?"));
            previousArriveCity = arriveCity;
        }
        return cities.length() > 0 ? cities.toString() : null;
    }

    public static String getCities(Product product, Locale locale) {
        return AirProductHelper.getCities(product.getSegmentTariffs(), locale);
    }

    public static String getCountries(List<SegmentTariff> segmentTariffs, Locale locale) {
        StringBuilder countries = new StringBuilder();
        DictionaryReference<Country> previousArriveCountry = null;
        boolean first = true;
        for (Segment segment : segmentTariffs.stream().flatMap(item -> item.getSegments().stream()).collect(Collectors.toList())) {
            DictionaryReference<Country> departureCountry = DictHelper.getCountry((DictionaryReference<GeoLocation>)segment.getDepartureLocation());
            DictionaryReference<Country> arriveCountry = DictHelper.getCountry((DictionaryReference<GeoLocation>)segment.getArriveLocation());
            if (first) {
                countries.append(Optional.ofNullable(departureCountry).map(item -> item.toString(locale)).orElse("?"));
                first = false;
            } else if (!MiscUtil.equals(previousArriveCountry, departureCountry)) {
                countries.append(" / ");
                countries.append(Optional.ofNullable(departureCountry).map(item -> item.toString(locale)).orElse("?"));
            }
            if (!MiscUtil.equals(departureCountry, arriveCountry)) {
                countries.append(" - ");
                countries.append(Optional.ofNullable(arriveCountry).map(item -> item.toString(locale)).orElse("?"));
            }
            previousArriveCountry = arriveCountry;
        }
        return countries.length() > 0 ? countries.toString() : null;
    }

    public static String getCountries(Product product, Locale locale) {
        return AirProductHelper.getCountries(product.getSegmentTariffs(), locale);
    }

    public static Collection<List<Product>> getProductsGroupBySegmentGroups(List<Product> mcoProducts) {
        HashMap<String, List> productsGroupBySegmentGroups = new HashMap<String, List>();
        for (Product product : mcoProducts) {
            List<Segment> segments = AirProductHelper.getSegments(product.getSegmentTariffs());
            String segmentKey = AirProductHelper.buildSegmentKey(segments);
            List products = productsGroupBySegmentGroups.computeIfAbsent(segmentKey, k -> new ArrayList());
            products.add(product);
        }
        return productsGroupBySegmentGroups.values();
    }

    private static String buildSegmentKey(List<Segment> segments) {
        return segments.stream().filter(Objects::nonNull).map(Segment::getGdsId).filter(Objects::nonNull).sorted().collect(Collectors.joining("-"));
    }

    public static boolean needRelatedTicketForMCO(MCOCategory mcoCategory) {
        if (mcoCategory == null) {
            return false;
        }
        return !MCO_Category_Without_Ticket.contains(mcoCategory);
    }

    public static DictionaryReference<GeoLocation> destinationLocations(Product product) {
        GeoLocation destinationLocation = null;
        HashSet<GeoLocation> cities = new HashSet<GeoLocation>();
        int n = 0;
        for (Segment seg : AirProductHelper.getSegments(product.getSegmentTariffs())) {
            GeoLocation arrivalCity;
            GeoLocation departureCity = DictHelper.findCity((DictionaryReference<GeoLocation>)seg.getDepartureLocation());
            if (n == 0) {
                destinationLocation = departureCity;
            }
            if (departureCity != null) {
                cities.add(departureCity);
            }
            if ((arrivalCity = DictHelper.findCity((DictionaryReference<GeoLocation>)seg.getArriveLocation())) != null) {
                if (cities.contains(arrivalCity)) break;
                destinationLocation = arrivalCity;
            }
            ++n;
        }
        if (destinationLocation != null) {
            return destinationLocation.toReference();
        }
        return new GeoLocationReference("", "");
    }

    public static String getOverallClassService(Product product) {
        List cs = product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(Segment::getServiceClass).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        String classService = null;
        if (cs.size() > 0) {
            if (cs.size() > 2) {
                classService = "X";
            } else if (cs.size() > 1) {
                classService = cs.contains(ClassOfService.ECONOMY) && cs.contains(ClassOfService.PREMIUM) ? "Y" : (cs.contains(ClassOfService.BUSINESS) && cs.contains(ClassOfService.PREMIUM_BUSINESS) ? "C" : (cs.contains(ClassOfService.FIRST) && cs.contains(ClassOfService.PREMIUM_FIRST) ? "F" : "X"));
            } else {
                switch ((ClassOfService)cs.get(0)) {
                    case ECONOMY: 
                    case PREMIUM: {
                        classService = "Y";
                        break;
                    }
                    case BUSINESS: 
                    case PREMIUM_BUSINESS: {
                        classService = "C";
                        break;
                    }
                    case FIRST: 
                    case PREMIUM_FIRST: {
                        classService = "F";
                    }
                }
            }
        }
        return classService;
    }

    public static ProductFopCategory getProductFopCategory(ProductFop productFop) {
        if (!AirProductHelper.isServiceFop(productFop)) {
            for (Commission commission : productFop.getCommissions()) {
                if (commission.getCommissionProperties() == null) continue;
                Class type = commission.getCommissionProperties().getType();
                if (GeneralProductHelper.paymentFeePropertyTypes.contains(type)) {
                    return ProductFopCategory.PAYMENT_FEE;
                }
                if (!GeneralProductHelper.discountPropertyTypes.contains(type)) continue;
                return ProductFopCategory.DISCOUNT;
            }
            return ProductFopCategory.SERVICE_FEE;
        }
        return ProductFopCategory.PRODUCT;
    }

    static {
        dvfoRegion = new GeoRegionReference("DVFO");
        cisRegion = new GeoRegionReference("CIS");
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2018);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2018_07_01 = cal.getTime();
        cal.set(1, 2018);
        cal.set(2, 9);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2018_10_01 = cal.getTime();
        cal.set(1, 2025);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2025_01_01 = cal.getTime();
        MCO_Category_Without_Ticket = EnumSet.of(MCOCategory.VIP_LOUNGE, new MCOCategory[]{MCOCategory.BUSINESS_LOUNGE, MCOCategory.POSTAGE_FEE, MCOCategory.GROUP_PENALTY, MCOCategory.NOT_SOLD_SEATS, MCOCategory.BUS_TICKET, MCOCategory.HOTEL, MCOCategory.DEPOSIT, MCOCategory.GROUP_PREPAYMENT});
    }

    public static abstract class SegmentTariffEquivalentFareCalculator {
        abstract BigDecimal calculateEquivalentFare(Product var1, SegmentTariff var2, BigDecimal var3);

        protected Money calculateBaseFare(Product product, SegmentTariff segmentTariff) {
            Money baseFare = AirProductHelper.getBaseFare(product);
            if (baseFare == null || baseFare.getCurrency() == null) {
                return null;
            }
            if (segmentTariff == null) {
                return baseFare;
            }
            Money segmentBaseFare = AirProductHelper.getSegmentBaseFare(product, segmentTariff);
            if (segmentBaseFare != null) {
                return segmentBaseFare;
            }
            BigDecimal segmentNucFare = AirProductHelper.getSegmentNucFare(product, segmentTariff);
            if (segmentNucFare == null) {
                return null;
            }
            BigDecimal nucRoe = AirProductHelper.getNucRoe(product);
            if (nucRoe == null) {
                return null;
            }
            Money money = new Money();
            money.setCurrency(baseFare.getCurrency());
            money.setValue(BigDecimal.valueOf(Math.round(segmentNucFare.multiply(nucRoe).doubleValue())));
            return money;
        }
    }

    private static class UkraineSegmentTariffEquivalentFareCalculator
    extends SegmentTariffEquivalentFareCalculator {
        private static final UkraineSegmentTariffEquivalentFareCalculator equivalentFareCalculator = new UkraineSegmentTariffEquivalentFareCalculator();

        private UkraineSegmentTariffEquivalentFareCalculator() {
        }

        public static UkraineSegmentTariffEquivalentFareCalculator getInstance() {
            return equivalentFareCalculator;
        }

        @Override
        public BigDecimal calculateEquivalentFare(Product product, SegmentTariff segmentTariff, BigDecimal rate) {
            Money money = this.calculateBaseFare(product, segmentTariff);
            if (money == null || money.getValue() == null) {
                return null;
            }
            if (rate == null || BigDecimal.ONE.compareTo(rate) == 0) {
                return money.getValue();
            }
            return MiscUtil.round((BigDecimal)money.getValue().multiply(rate), (BigDecimal)BigDecimal.valueOf(1L));
        }
    }

    private static class RussiaSegmentTariffEquivalentFareCalculator
    extends SegmentTariffEquivalentFareCalculator {
        private static final RussiaSegmentTariffEquivalentFareCalculator equivalentFareCalculator = new RussiaSegmentTariffEquivalentFareCalculator();

        private RussiaSegmentTariffEquivalentFareCalculator() {
        }

        public static RussiaSegmentTariffEquivalentFareCalculator getInstance() {
            return equivalentFareCalculator;
        }

        @Override
        public BigDecimal calculateEquivalentFare(Product product, SegmentTariff segmentTariff, BigDecimal rate) {
            Money money = this.calculateBaseFare(product, segmentTariff);
            if (money == null || money.getValue() == null) {
                return null;
            }
            if (rate == null || BigDecimal.ONE.compareTo(rate) == 0) {
                return money.getValue();
            }
            return MiscUtil.round((BigDecimal)money.getValue().multiply(rate), (BigDecimal)BigDecimal.valueOf(5L));
        }
    }
}

