/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class BillingTransactionHelper {
    private static final Logger log = LoggerFactory.getLogger(BillingTransactionHelper.class);
    private static final String MONITORING_DATA_KEY_COMB = "storage.comb.comb-search";
    private static final String MONITORING_DATA_KEY_HIT = "storage.comb.hit";
    private static final String MONITORING_DATA_KEY_NO_CACHE = "storage.balance.oldmodule";
    private static final String MONITORING_DATA_KEY_NEWMODULE_HIT = "storage.balance.newmodule.hit";
    private static final String MONITORING_DATA_KEY_NEWMODULE_MISS = "storage.balance.newmodule.miss";
    public static final boolean DISABLE_CURRENCY = false;

    public static BigDecimal calculateBillingTransactionsSum(ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionStatus status, Date startDate, Date endDate) throws Exception {
        return BillingTransactionHelper.calculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, category, null, status, DictHelper.getLocalCurrency(), startDate, endDate, false, false, false);
    }

    public static BigDecimal calculateBillingTransactionsSum(ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionType type, BillingTransactionStatus status, Date startDate, Date endDate) throws Exception {
        return BillingTransactionHelper.calculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, category, type, status, DictHelper.getLocalCurrency(), startDate, endDate, false, false, false);
    }

    public static BigDecimal calculateBillingTransactionsSum(ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionStatus status, String currency, Date startDate, Date endDate, boolean noCache, boolean forComb) throws Exception {
        return BillingTransactionHelper.calculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, category, null, status, DictHelper.getLocalCurrency(), startDate, endDate, noCache, false, false);
    }

    public static BigDecimal calculateBillingTransactionsSum(ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionStatus status, String currency, Date startDate, Date endDate, boolean noCache, boolean forComb, boolean forceOldFinanceModule) throws Exception {
        return BillingTransactionHelper.calculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, category, null, status, currency, startDate, endDate, noCache, false, forceOldFinanceModule);
    }

    public static BigDecimal calculateBillingTransactionsSum(ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionType type, BillingTransactionStatus status, String currency, Date startDate, Date endDate, boolean noCache, boolean forComb, boolean forceOldFinanceModule) throws Exception {
        if (category == null) {
            BigDecimal billingTransactionsSum = BillingTransactionHelper.calculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, BillingTransactionCategory.DEBIT, type, status, currency, startDate, endDate, noCache, forComb, forceOldFinanceModule);
            billingTransactionsSum = billingTransactionsSum.subtract(BillingTransactionHelper.calculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, BillingTransactionCategory.CREDIT, type, status, currency, startDate, endDate, noCache, forComb, forceOldFinanceModule));
            return billingTransactionsSum;
        }
        return BillingTransactionHelper.standardCalculateBillingTransactionsSum(contractType, clientReference, agencyReference, agentReference, category, type, status, currency, startDate, endDate, noCache, forComb);
    }

    private static BigDecimal standardCalculateBillingTransactionsSum(ContractType contractType, EntityReference<? extends BaseProfile> clientReference, EntityReference<? extends BaseProfile> agencyReference, EntityReference<? extends BaseProfile> agentReference, BillingTransactionCategory category, BillingTransactionType type, BillingTransactionStatus status, String currency, Date startDate, Date endDate, boolean noCache, boolean forComb) {
        ProjectionQuery bilingTransactionQuery = new ProjectionQuery();
        if (contractType != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.contractType.name(), (Object)contractType));
        }
        if (clientReference != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), clientReference));
        }
        if (agencyReference != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.agency.name(), agencyReference));
        }
        if (agentReference != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.agent.name(), agentReference));
        }
        bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.category.name(), (Object)category));
        if (type != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)type));
        }
        if (status != null) {
            SearchCriterion sc = SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)status);
            SearchCriterion asc = BillingTransactionStatus.ACTIVE == status ? SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc, SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), null)}) : sc;
            bilingTransactionQuery.getCriteria().getCriterions().add(asc);
        }
        bilingTransactionQuery.getCriteria().getCriterions().add(DictHelper.getLocalCurrency().equals(currency) ? SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCurrency.name(), (Object)currency), SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCurrency.name(), null)}) : SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCurrency.name(), (Object)currency));
        if (startDate != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)startDate));
        }
        if (endDate != null) {
            bilingTransactionQuery.getCriteria().getCriterions().add(!forComb ? SearchCriterion.le((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)endDate) : SearchCriterion.lt((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)endDate));
        }
        bilingTransactionQuery.getProjections().add(Projection.sum((String)BillingTransactionIndex.Property.transactionSum.name(), (String)"sum"));
        long start = System.currentTimeMillis();
        ProjectionResult bilingTransactionResult = EntityStorage.get().search(BillingTransactionIndex.class, bilingTransactionQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(noCache));
        BillingTransactionHelper.statMonitoringData(MONITORING_DATA_KEY_NO_CACHE, start);
        BigDecimal bilingTransactionSum = bilingTransactionResult.uniqueBigDecimal();
        return bilingTransactionSum;
    }

    public static void statMonitoringData(String key, long start) {
        if (!(Environment.isPublished(Profiler.class) && Profiler.get().isProfilingEnabled() && Profiler.get().isProfilingEnabled(key))) {
            return;
        }
        Profiler.get().updateTiming(key, start, null);
    }

    public static BillingTransactionCategory getBillingTransactionCategory(ProductStatus productStatus) {
        if (productStatus == null) {
            return null;
        }
        switch (productStatus) {
            case SELL: {
                return BillingTransactionCategory.CREDIT;
            }
            case REFUND: 
            case EXCHANGE: {
                return BillingTransactionCategory.DEBIT;
            }
        }
        return null;
    }

    public static BillingTransactionType getBillingTransactionType(ProductStatus productStatus) {
        if (productStatus == null) {
            return null;
        }
        switch (productStatus) {
            case SELL: {
                return BillingTransactionType.EXPENSE;
            }
            case REFUND: 
            case EXCHANGE: {
                return BillingTransactionType.REPAYMENT;
            }
        }
        return null;
    }
}

