/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommonReservationGdsNameInfoHelper {
    public static String getDisplayedRecordLocator(Reservation reservation) {
        return CommonReservationGdsNameInfoHelper.getDisplayedRecordLocatorOptional(reservation).orElse(null);
    }

    public static Optional<String> getDisplayedRecordLocatorOptional(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        HashSet<String> locators = new HashSet<String>();
        for (ReservationSystemInfo rsi : gdsNameInfo.getSystemInfos()) {
            for (RecordLocatorInfo rli : rsi.getRecordLocators()) {
                if (!rli.isDisplay()) continue;
                locators.add(rli.getRecordLocator());
            }
        }
        return Optional.ofNullable(CollectionUtil.singleOrNull(locators));
    }

    public static GdsName getDisplayedGdsName(Reservation reservation) {
        return CommonReservationGdsNameInfoHelper.getDisplayedGdsNameOptional(reservation).orElse(null);
    }

    public static Optional<GdsName> getDisplayedGdsNameOptional(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        HashSet<GdsName> gdsNames = new HashSet<GdsName>();
        for (ReservationSystemInfo rsi : gdsNameInfo.getSystemInfos()) {
            for (RecordLocatorInfo rli : rsi.getRecordLocators()) {
                if (!rli.isDisplay()) continue;
                gdsNames.add(rsi.getGdsName());
            }
        }
        return Optional.ofNullable(CollectionUtil.singleOrNull(gdsNames));
    }

    public static String getDisplayedBookingAgentDutyCode(Reservation reservation) {
        return CommonReservationGdsNameInfoHelper.getDisplayedBookingAgentDutyCodeOptional(reservation).orElse(null);
    }

    public static Optional<String> getDisplayedBookingAgentDutyCodeOptional(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        HashSet<String> codes = new HashSet<String>();
        for (ReservationSystemInfo rsi : gdsNameInfo.getSystemInfos()) {
            for (RecordLocatorInfo rli : rsi.getRecordLocators()) {
                if (!rli.isDisplay()) continue;
                codes.add(rsi.getBookingAgentDutyCode());
            }
        }
        return Optional.ofNullable(CollectionUtil.singleOrNull(codes));
    }

    public static String getExport1CRecordLocator(Reservation reservation) {
        return CommonReservationGdsNameInfoHelper.getExport1CRecordLocatorOptional(reservation).orElse(null);
    }

    public static Optional<String> getExport1CRecordLocatorOptional(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        HashSet<String> locators = new HashSet<String>();
        for (ReservationSystemInfo rsi : gdsNameInfo.getSystemInfos()) {
            for (RecordLocatorInfo rli : rsi.getRecordLocators()) {
                if (!rli.isExport1C()) continue;
                locators.add(rli.getRecordLocator());
            }
        }
        return Optional.ofNullable(CollectionUtil.singleOrNull(locators));
    }

    public static GdsName getExport1CGdsName(Reservation reservation) {
        return CommonReservationGdsNameInfoHelper.getExport1CGdsNameOptional(reservation).orElse(null);
    }

    public static Optional<GdsName> getExport1CGdsNameOptional(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        HashSet<GdsName> gdsNames = new HashSet<GdsName>();
        for (ReservationSystemInfo rsi : gdsNameInfo.getSystemInfos()) {
            for (RecordLocatorInfo rli : rsi.getRecordLocators()) {
                if (!rli.isExport1C()) continue;
                gdsNames.add(rsi.getGdsName());
            }
        }
        return Optional.ofNullable(CollectionUtil.singleOrNull(gdsNames));
    }

    public static String getRecordLocator(Reservation reservation, GdsName gdsName, RecordLocatorType type) {
        return CommonReservationGdsNameInfoHelper.getRecordLocatorOptional(reservation, gdsName, type).orElse(null);
    }

    public static Optional<String> getRecordLocatorOptional(Reservation reservation, GdsName gdsName, RecordLocatorType type) {
        ReservationSystemInfo rsi = CommonReservationGdsNameInfoHelper.getReservationSystemInfo(reservation, gdsName);
        if (rsi == null) {
            return Optional.empty();
        }
        RecordLocatorInfo rli = (RecordLocatorInfo)Streams.singleOrNull(rsi.getRecordLocators().stream().filter(info -> info.getType() == type));
        if (rli == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(rli.getRecordLocator());
    }

    public static ReservationSystemInfo getReservationSystemInfo(Reservation reservation, GdsName gdsName) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        return (ReservationSystemInfo)Streams.singleOrNull(gdsNameInfo.getSystemInfos().stream().filter(si -> si.getGdsName() == gdsName));
    }

    public static GdsName getRulesGdsName(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        return gdsNameInfo.getRulesGdsName();
    }

    public static GdsName getStatisticsGdsName(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        return gdsNameInfo.getStatisticsGdsName();
    }

    public static String getBookingPcc(Reservation reservation, GdsName gdsName) {
        return CommonReservationGdsNameInfoHelper.getBookingPccOptional(reservation, gdsName).orElse(null);
    }

    public static Optional<String> getBookingPccOptional(Reservation reservation, GdsName gdsName) {
        ReservationSystemInfo rsi = CommonReservationGdsNameInfoHelper.getReservationSystemInfo(reservation, gdsName);
        if (rsi == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(rsi.getBookingPcc());
    }

    public static String getBookingAgentDutyCode(Reservation reservation, GdsName gdsName) {
        return CommonReservationGdsNameInfoHelper.getBookingAgentDutyCodeOptional(reservation, gdsName).orElse(null);
    }

    public static Optional<String> getBookingAgentDutyCodeOptional(Reservation reservation, GdsName gdsName) {
        ReservationSystemInfo rsi = CommonReservationGdsNameInfoHelper.getReservationSystemInfo(reservation, gdsName);
        if (rsi == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(rsi.getBookingAgentDutyCode());
    }

    public static boolean containsRecordLocator(Reservation reservation, String recordLocator, GdsName gdsName) {
        if (reservation == null || TextUtil.isBlank((String)recordLocator)) {
            return false;
        }
        return reservation.getGdsNameInfo().getSystemInfos().stream().anyMatch(rsi -> rsi.getGdsName() == gdsName && rsi.getRecordLocators().stream().anyMatch(rli -> recordLocator.equals(rli.getRecordLocator())));
    }

    public static boolean containsGds(Reservation reservation, GdsName gdsName) {
        return reservation.getGdsNameInfo().getSystemInfos().stream().anyMatch(rsi -> rsi.getGdsName() == gdsName);
    }

    public static boolean recordLocatorsMatch(Reservation res1, Reservation res2) {
        Map systemInfos1 = res1.getGdsNameInfo().getSystemInfos().stream().collect(Collectors.toMap(ReservationSystemInfo::getGdsName, Function.identity()));
        Map systemInfos2 = res2.getGdsNameInfo().getSystemInfos().stream().collect(Collectors.toMap(ReservationSystemInfo::getGdsName, Function.identity()));
        for (GdsName gdsName : systemInfos1.keySet()) {
            ReservationSystemInfo systemInfo2;
            ReservationSystemInfo systemInfo1;
            if (!systemInfos2.containsKey(gdsName) || !CommonReservationGdsNameInfoHelper.isSameReservationSystemInfo(systemInfo1 = (ReservationSystemInfo)systemInfos1.get(gdsName), systemInfo2 = (ReservationSystemInfo)systemInfos2.get(gdsName))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameReservationSystemInfo(ReservationSystemInfo systemInfo1, ReservationSystemInfo systemInfo2) {
        Map<RecordLocatorType, String> recordLocators1 = systemInfo1.getRecordLocators().stream().collect(Collectors.toMap(RecordLocatorInfo::getType, RecordLocatorInfo::getRecordLocator));
        Map<RecordLocatorType, String> recordLocators2 = systemInfo2.getRecordLocators().stream().collect(Collectors.toMap(RecordLocatorInfo::getType, RecordLocatorInfo::getRecordLocator));
        if (recordLocators1.isEmpty() || recordLocators2.isEmpty()) {
            return false;
        }
        Collection<List<RecordLocatorType>> typeGroups = Stream.of(RecordLocatorType.values()).filter(RecordLocatorType::isComparable).collect(Collectors.groupingBy(RecordLocatorType::getGroupId)).values();
        if (typeGroups.isEmpty()) {
            return false;
        }
        for (List<RecordLocatorType> typesGroup : typeGroups) {
            boolean isAllGroupLocatorsEquals;
            if (!recordLocators1.keySet().containsAll(typesGroup) || !recordLocators2.keySet().containsAll(typesGroup) || !(isAllGroupLocatorsEquals = typesGroup.stream().allMatch(type -> MiscUtil.equals(recordLocators1.get(type), recordLocators2.get(type))))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRecordLocator(Reservation reservation, String recordLocator) {
        return reservation.getGdsNameInfo().getSystemInfos().stream().anyMatch(rsi -> rsi.getRecordLocators().stream().anyMatch(rli -> recordLocator.equals(rli.getRecordLocator())));
    }

    public static List<GdsName> getGdsNames(Reservation reservation) {
        return reservation.getGdsNameInfo().getSystemInfos().stream().map(ReservationSystemInfo::getGdsName).collect(Collectors.toList());
    }

    private static ReservationSystemInfo getOrCreateReservationSystemInfo(Reservation reservation, GdsName gdsName) {
        ReservationSystemInfo systemInfo = (ReservationSystemInfo)Streams.singleOrNull(reservation.getGdsNameInfo().getSystemInfos().stream().filter(si -> si.getGdsName() == gdsName));
        if (systemInfo == null) {
            systemInfo = new ReservationSystemInfo();
            systemInfo.setGdsName(gdsName);
            reservation.getGdsNameInfo().getSystemInfos().add(systemInfo);
        }
        return systemInfo;
    }

    private static RecordLocatorInfo getOrCreateRecordLocatorInfo(ReservationSystemInfo systemInfo, RecordLocatorType locatorType) {
        RecordLocatorInfo recordLocatorInfo = (RecordLocatorInfo)Streams.singleOrNull(systemInfo.getRecordLocators().stream().filter(rli -> rli.getType() == locatorType));
        if (recordLocatorInfo == null) {
            recordLocatorInfo = new RecordLocatorInfo();
            recordLocatorInfo.setType(locatorType);
            systemInfo.getRecordLocators().add(recordLocatorInfo);
        }
        return recordLocatorInfo;
    }

    public static void setRecordLocator(Reservation reservation, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator) {
        ReservationSystemInfo systemInfo = CommonReservationGdsNameInfoHelper.getOrCreateReservationSystemInfo(reservation, gdsName);
        RecordLocatorInfo recordLocatorInfo = CommonReservationGdsNameInfoHelper.getOrCreateRecordLocatorInfo(systemInfo, recordLocatorType);
        recordLocatorInfo.setRecordLocator(recordLocator);
    }

    public static void setBookingAgentDutyCode(Reservation reservation, GdsName gdsName, String bookingAgentDutyCode) {
        ReservationSystemInfo systemInfo = CommonReservationGdsNameInfoHelper.getOrCreateReservationSystemInfo(reservation, gdsName);
        systemInfo.setBookingAgentDutyCode(bookingAgentDutyCode);
    }

    public static void setBookingPcc(Reservation reservation, GdsName gdsName, String bookingPcc) {
        ReservationSystemInfo systemInfo = CommonReservationGdsNameInfoHelper.getOrCreateReservationSystemInfo(reservation, gdsName);
        systemInfo.setBookingPcc(bookingPcc);
    }

    public static void setRulesGdsName(Reservation reservation, GdsName gdsName) {
        reservation.getGdsNameInfo().setRulesGdsName(gdsName);
    }

    public static void setStatisticsGdsName(Reservation reservation, GdsName gdsName) {
        reservation.getGdsNameInfo().setStatisticsGdsName(gdsName);
    }
}

