/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CommunicationHelper {
    private CommunicationHelper() throws RuntimeException {
        throw new RuntimeException("don't do this");
    }

    public static Predicate<Communication> type(CommunicationType communicationType) {
        return c -> c.getType() == communicationType;
    }

    public static String email(Collection<? extends Communication> communications) {
        Optional<String> emailOptional = communications.stream().filter(Objects::nonNull).filter(CommunicationHelper.type(CommunicationType.EMAIL)).map(Communication::getSense).filter(TextUtil::nonBlank).findAny();
        return emailOptional.orElse(null);
    }

    public static Communication createEmailCommunication(String email) {
        Communication c = new Communication();
        c.setType(CommunicationType.EMAIL);
        c.setSense(email);
        return c;
    }

    public static boolean isPhoneCommunication(Communication communication) {
        return communication.getType() == CommunicationType.WORK_PHONE || communication.getType() == CommunicationType.HOME_PHONE || communication.getType() == CommunicationType.MOBILE || communication.getType() == CommunicationType.AGENCY || communication.getType() == CommunicationType.CELL;
    }
}

