/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.aggregator.HotelAggregatorHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategoryValue;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.delivery.DeliveryRegion;
import com.gridnine.xtrip.common.model.delivery.MetroStation;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.AircraftSeatInfo;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.BspTicketPrefixNo;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.CarsSupplier;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.CostCodeCategoryReference;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictUpdateField;
import com.gridnine.xtrip.common.model.dict.DictUpdateItem;
import com.gridnine.xtrip.common.model.dict.DictUpdateItemIndex;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.HotelCCType;
import com.gridnine.xtrip.common.model.dict.HotelRating;
import com.gridnine.xtrip.common.model.dict.HotelStar;
import com.gridnine.xtrip.common.model.dict.HotelType;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.HotelsBrandType;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.RelatedLocation;
import com.gridnine.xtrip.common.model.dict.RelatedLocationSubType;
import com.gridnine.xtrip.common.model.dict.RelatedLocationType;
import com.gridnine.xtrip.common.model.dict.RemoteDictionaryResolver;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestCategory;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.dict.TrainName;
import com.gridnine.xtrip.common.model.dict.TrainType;
import com.gridnine.xtrip.common.model.dict.ValidationMessageDict;
import com.gridnine.xtrip.common.model.dict.WeekDay;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CurrencyRateSuperCache;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.GeoDistanceUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictHelper {
    public static final String MIDOFFICE_USE_CURRENCY_SUPER_CACHE_KEY = "midoffice.useCurrencySuperCache";
    private static final boolean useCurrencySuperCache = !"false".equals(System.getProperty("midoffice.useCurrencySuperCache"));
    public static final String NOT_RECOGNIZED_ROOM_TYPE = "Not recognized room type";
    private static final CountryReference ruRef = new CountryReference("RU");
    private static final CountryReference byRef = new CountryReference("BY");
    private static final CountryReference kzRef = new CountryReference("KZ");
    private static final CountryReference uaRef = new CountryReference("UA");
    private static final CountryReference uzRef = new CountryReference("UZ");
    private static final CountryReference mdRef = new CountryReference("MD");
    private static final CountryReference tjRef = new CountryReference("TJ");
    private static final Logger log = LoggerFactory.getLogger(DictHelper.class);
    private static final HashSet<Class<? extends BaseDictionary>> remoteDictionaries = new HashSet();
    public static String[] CODE_SYSTEMS_IATA_CRT;
    public static final CurrencyInfo percent;
    static final Map<CardVendor, String> defaultCardCodes;
    public static final Map<CardVendor, String> sabreCardCodes;
    private static final String LUGGAGE_UNIT_NIL = "NIL";
    public static final String LUGGAGE_UNIT_KG = "KG";
    private static final String LUGGAGE_UNIT_LB = "LB";
    public static final String LUGGAGE_UNIT_PC = "PC";

    public static <D extends BaseDictionary> boolean equals(D d1, D d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)d1.getCode(), (Object)d2.getCode());
    }

    public static <D extends BaseDictionary> boolean equals(DictionaryReference<D> ref1, DictionaryReference<D> ref2) {
        if (ref1 == null && ref2 == null) {
            return true;
        }
        if (ref1 == null || ref2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)ref1.getCode(), (Object)ref2.getCode());
    }

    public static <D extends BaseDictionary> D resolve(DictionaryReference<D> dictRef) {
        return (D)DictionaryCache.get().resolveReference(dictRef);
    }

    public static String getCodeVariant(BaseDictionary baseDictionary, CodeSystem codeSystem) {
        return DictHelper.getCodeVariant(baseDictionary, Collections.singletonList(codeSystem));
    }

    public static String getCodeVariant(BaseDictionary baseDictionary, CodeSystem codeSystem, String def) {
        String res = DictHelper.getCodeVariant(baseDictionary, Collections.singletonList(codeSystem));
        if (TextUtil.isBlank((String)res)) {
            res = def;
        }
        return res;
    }

    public static Set<String> getCodeVariants(BaseDictionary baseDictionary, List<CodeSystem> codeSystems) {
        HashSet<String> codeVariants = new HashSet<String>();
        for (CodeSystem codeSystem : codeSystems) {
            String code = (String)baseDictionary.getCodeVariants().get(codeSystem.name());
            if (TextUtil.isBlank((String)code)) continue;
            codeVariants.add(code);
        }
        return codeVariants;
    }

    public static String getCodeVariant(BaseDictionary baseDictionary, List<CodeSystem> codeSystems) {
        if (baseDictionary == null) {
            return null;
        }
        return codeSystems.stream().map(Enum::name).map(baseDictionary.getCodeVariants()::get).filter(TextUtil::nonBlank).findFirst().orElse(null);
    }

    public static String getCodeVariant(BaseDictionary baseDictionary, CodeSystem ... codeSystem) {
        return DictHelper.getCodeVariant(baseDictionary, Arrays.asList(codeSystem));
    }

    public static String getCodeVariant(DictionaryReference<?> ref, CodeSystem ... codeSystem) {
        return DictHelper.getCodeVariant(DictionaryCache.get().resolveReference(ref), Arrays.asList(codeSystem));
    }

    public static <D extends BaseDictionary> String getCodeVariant(DictionaryReference<D> ref, boolean failSafe, CodeSystem ... codeSystem) {
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        if (dict == null) {
            if (failSafe) {
                log.debug("can't resolve dictionary reference " + ref);
                return ref.getCode();
            }
            throw Xeption.forDeveloper((String)("can't resolve dictionary reference " + ref), (Object[])new Object[0]);
        }
        String codeVariant = DictHelper.getCodeVariant(dict, Arrays.asList(codeSystem));
        if (codeVariant != null) {
            return codeVariant;
        }
        if (failSafe) {
            log.debug("can't find native code for " + ref);
            return dict.getCode();
        }
        throw Xeption.forAdmin((String)"\u0414\u043b\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '{0}' \u0441 \u043a\u043e\u0434\u043e\u043c '{1}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u0434\u044b \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u0441\u0442\u0435\u043c: '{2}'", (Object[])new Object[]{MetaRegistryHelper.getDictionaryType((String)dict.getClass().getName()).getDisplayName(), dict.getCode(), Arrays.toString(codeSystem)});
    }

    public static Set<String> getCodeVariants(DictionaryReference<GeoLocation> geoLocationReference, List<CodeSystem> codeSystems, boolean includeGeoLocationCodes, boolean includeCountryCodes, boolean includeRegionCodes) {
        if (geoLocationReference == null) {
            return Collections.emptySet();
        }
        if (!(includeGeoLocationCodes || includeCountryCodes || includeRegionCodes)) {
            return Collections.emptySet();
        }
        HashSet<String> codeVeriants = new HashSet<String>();
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(geoLocationReference);
        if (geoLocation == null) {
            return codeVeriants;
        }
        if (includeGeoLocationCodes) {
            codeVeriants.addAll(DictHelper.getCodeVariants((BaseDictionary)geoLocation, codeSystems));
        }
        if (!includeCountryCodes && !includeRegionCodes) {
            return codeVeriants;
        }
        DictionaryReference countryReference = geoLocation.getCountry();
        if (countryReference == null) {
            return codeVeriants;
        }
        Country country = (Country)DictionaryCache.get().resolveReference(countryReference);
        if (country == null) {
            return codeVeriants;
        }
        if (includeCountryCodes) {
            codeVeriants.addAll(DictHelper.getCodeVariants((BaseDictionary)country, codeSystems));
        }
        if (!includeRegionCodes) {
            return codeVeriants;
        }
        Set regionReferences = country.getRegions();
        for (DictionaryReference regionReference : regionReferences) {
            GeoRegion region = (GeoRegion)DictionaryCache.get().resolveReference(regionReference);
            if (region == null) continue;
            codeVeriants.addAll(DictHelper.getCodeVariants((BaseDictionary)region, codeSystems));
        }
        return codeVeriants;
    }

    public static String getTranslation(BaseDictionary dict, Locale locale, boolean strict) {
        if (dict == null || locale == null) {
            return null;
        }
        String name = (String)dict.getTranslations().get(locale);
        if (name != null) {
            return name;
        }
        name = dict.getTranslations().entrySet().stream().filter(entry -> entry.getKey() != null && TextUtil.isSame((String)locale.getLanguage(), (String)((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(null);
        if (strict || name != null) {
            return name;
        }
        if (!LocaleHelper.EN_LOCALE.equals(locale)) {
            name = (String)dict.getTranslations().get(LocaleHelper.EN_LOCALE);
        }
        if (name != null) {
            return name;
        }
        if (!dict.getTranslations().isEmpty()) {
            return (String)dict.getTranslations().values().iterator().next();
        }
        return null;
    }

    public static String getTranslation(DictionaryReference<?> ref, Locale locale, boolean strict) {
        return DictHelper.getTranslation(DictionaryCache.get().resolveReference(ref), locale, strict);
    }

    public static String findCityCode(String code, CodeSystem codeSystem) {
        return DictHelper.findCityCode(code, codeSystem, new ArrayList<String>());
    }

    private static String findCityCode(String code, CodeSystem codeSystem, List<String> codes) {
        codes.add(code);
        DictionaryCache cache = DictionaryCache.get();
        for (GeoLocation location : cache.lookup(GeoLocation.class, code, new String[]{codeSystem.name()})) {
            if (location.getType() == LocationType.CITY) {
                return (String)location.getCodeVariants().get(codeSystem.name());
            }
            GeoLocation parentLocation = (GeoLocation)cache.resolveReference(location.getParent());
            if (parentLocation == null || parentLocation.equals((Object)location)) continue;
            if (parentLocation.getType() == LocationType.CITY) {
                return (String)parentLocation.getCodeVariants().get(codeSystem.name());
            }
            if (!codes.contains(parentLocation.getCodeVariants().get(codeSystem.name()))) {
                String result = DictHelper.findCityCode((String)parentLocation.getCodeVariants().get(codeSystem.name()), codeSystem, codes);
                if (result == null) continue;
                return result;
            }
            codes.add((String)parentLocation.getCodeVariants().get(codeSystem.name()));
            log.error("findCityCode() failed. Cycle found in chain of GeoLocation codes (linked by parents): " + codes);
        }
        return null;
    }

    public static GeoLocation findCityByCode(String code, CodeSystem codeSystem) {
        return DictHelper.findCityByCode(code, codeSystem, new ArrayList<String>());
    }

    private static GeoLocation findCityByCode(String code, CodeSystem codeSystem, List<String> codes) {
        codes.add(code);
        DictionaryCache cache = DictionaryCache.get();
        for (GeoLocation location : cache.lookup(GeoLocation.class, code, new String[]{codeSystem.name()})) {
            if (location.getType() == LocationType.CITY) {
                return location;
            }
            GeoLocation parentLocation = (GeoLocation)cache.resolveReference(location.getParent());
            if (parentLocation == null || parentLocation.equals((Object)location)) continue;
            if (parentLocation.getType() == LocationType.CITY) {
                return parentLocation;
            }
            if (!codes.contains(parentLocation.getCodeVariants().get(codeSystem.name()))) {
                GeoLocation result = DictHelper.findCityByCode((String)parentLocation.getCodeVariants().get(codeSystem.name()), codeSystem, codes);
                if (result == null) continue;
                return result;
            }
            codes.add((String)parentLocation.getCodeVariants().get(codeSystem.name()));
            log.error("findCityByCode() failed. Cycle found in chain of GeoLocation codes (linked by parents): " + codes);
        }
        return null;
    }

    public static Set<GeoLocation> getCityByAnyCode(String code, String ... codeSystems) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<GeoLocation> result = new HashSet<GeoLocation>();
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference((DictionaryReference)new GeoLocationReference(code));
        if (geoLocation != null) {
            result.add(geoLocation);
        }
        result.addAll(DictionaryCache.get().lookup(GeoLocation.class, code, codeSystems == null || codeSystems.length == 0 ? CODE_SYSTEMS_IATA_CRT : codeSystems));
        return result;
    }

    public static CurrencyRate findCurrencyRate(String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> supplier) {
        return DictHelper.findCurrencyRate(currencyCode, issueDate, rateType, tariffType, null, supplier);
    }

    public static CurrencyRate findCurrencyRate(String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        if (TextUtil.isBlank((String)currencyCode)) {
            return null;
        }
        EntityReference<Organization> requiredSupplier = null;
        if (CurrencyRateType.VENDOR == rateType) {
            requiredSupplier = supplier;
        }
        if (Environment.isPublished(CurrencyRateSuperCache.class)) {
            return DictHelper.findCurrencyRateWithSuperCache(currencyCode, issueDate, rateType, tariffType, blankOwner, requiredSupplier);
        }
        CurrencyRate result = null;
        CurrencyRate ttResult = null;
        for (CurrencyRate rate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            Date date;
            String dictCurCode;
            if (rate == null || !MiscUtil.equals((Object)rate.getBaseCurrency(), (Object)DictHelper.getEquivCurrency()) || rateType != null && rate.getType() != rateType || tariffType != null && rate.getTariffType() != null && rate.getTariffType() != tariffType || blankOwner != null && !blankOwner.equals((Object)rate.getBlankOwner()) || requiredSupplier != null && !requiredSupplier.equals((Object)rate.getSupplier()) || TextUtil.isBlank((String)(dictCurCode = rate.getCurrency())) || !dictCurCode.equalsIgnoreCase(currencyCode) || (date = rate.getDate()) == null || issueDate != null && MiscUtil.clearTime((Date)date).getTime() > MiscUtil.clearTime((Date)issueDate).getTime()) continue;
            if (result == null || date.getTime() > result.getDate().getTime()) {
                result = rate;
            }
            if (tariffType != rate.getTariffType() || ttResult != null && date.getTime() <= ttResult.getDate().getTime()) continue;
            ttResult = rate;
        }
        if (tariffType != null) {
            return ttResult != null ? ttResult : result;
        }
        return result;
    }

    private static CurrencyRate findCurrencyRateWithSuperCache(String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        if (tariffType == null) {
            return CurrencyRateSuperCache.get().findCurrencyRate(null, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
        }
        CurrencyRate result = CurrencyRateSuperCache.get().findCurrencyRate(null, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
        if (result != null) {
            return result;
        }
        return CurrencyRateSuperCache.get().findCurrencyRate(null, currencyCode, issueDate, rateType, null, null, supplier);
    }

    public static CurrencyRate findExactCurrencyRate(String currencyCode, String baseCurrencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> supplier) {
        if (TextUtil.isBlank((String)currencyCode)) {
            return null;
        }
        EntityReference<Organization> requiredSupplier = null;
        if (CurrencyRateType.VENDOR == rateType) {
            requiredSupplier = supplier;
        }
        if (useCurrencySuperCache && Environment.isPublished(CurrencyRateSuperCache.class)) {
            return DictHelper.findExactCurrencyRateWithSuperCache(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, requiredSupplier);
        }
        CurrencyRate result = null;
        CurrencyRate ttResult = null;
        for (CurrencyRate rate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            Date date;
            String dictBaseCurCode;
            String dictCurCode;
            if (rate == null || rateType != null && rate.getType() != rateType || tariffType != null && rate.getTariffType() != null && rate.getTariffType() != tariffType || TextUtil.isBlank((String)(dictCurCode = rate.getCurrency())) || !dictCurCode.equalsIgnoreCase(currencyCode) || TextUtil.isBlank((String)(dictBaseCurCode = rate.getBaseCurrency())) || !dictBaseCurCode.equalsIgnoreCase(baseCurrencyCode) || (date = rate.getDate()) == null || requiredSupplier != null && !requiredSupplier.equals((Object)rate.getSupplier()) || CurrencyRateType.VENDOR == rateType && requiredSupplier == null && rate.getSupplier() != null || issueDate != null && MiscUtil.clearTime((Date)date).getTime() > MiscUtil.clearTime((Date)issueDate).getTime()) continue;
            if (result == null || date.getTime() > result.getDate().getTime()) {
                result = rate;
            }
            if (tariffType != rate.getTariffType() || ttResult != null && date.getTime() <= ttResult.getDate().getTime()) continue;
            ttResult = rate;
        }
        if (tariffType != null) {
            return ttResult != null ? ttResult : result;
        }
        return result;
    }

    public static void invalidateCurrencySuperCache() {
        CurrencyRateSuperCache.get().invalidateAll();
    }

    private static CurrencyRate findExactCurrencyRateWithSuperCache(String baseCurrencyCode, String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> supplier) {
        if (tariffType == null) {
            CurrencyRate result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, null, supplier);
            if (result == null && rateType == CurrencyRateType.VENDOR) {
                result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, null, null);
            }
            return result;
        }
        CurrencyRate result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, null, supplier);
        if (result == null && rateType == CurrencyRateType.VENDOR) {
            result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, null, null);
        }
        if (result != null) {
            return result;
        }
        result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, null, null, supplier);
        if (result == null && rateType == CurrencyRateType.VENDOR) {
            result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, null, null, null);
        }
        return result;
    }

    public static CurrencyRate findCurrencyRate(String currencyCode, String baseCurrencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        if (TextUtil.isBlank((String)currencyCode)) {
            return null;
        }
        if (useCurrencySuperCache && Environment.isPublished(CurrencyRateSuperCache.class)) {
            return DictHelper.findCurrencyRateWithSuperCache(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
        }
        CurrencyRate result = null;
        CurrencyRate ttResult = null;
        for (CurrencyRate rate : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            Date date;
            String dictBaseCurCode;
            String dictCurCode;
            if (rate == null || rateType != null && rate.getType() != rateType || blankOwner != null && rate.getBlankOwner() != null && !blankOwner.equals((Object)rate.getBlankOwner()) || tariffType != null && rate.getTariffType() != null && rate.getTariffType() != tariffType || TextUtil.isBlank((String)(dictCurCode = rate.getCurrency())) || !dictCurCode.equalsIgnoreCase(currencyCode) || TextUtil.isBlank((String)(dictBaseCurCode = rate.getBaseCurrency())) || !dictBaseCurCode.equalsIgnoreCase(baseCurrencyCode) || (date = rate.getDate()) == null || issueDate != null && MiscUtil.clearTime((Date)date).getTime() > MiscUtil.clearTime((Date)issueDate).getTime()) continue;
            if (result == null || date.getTime() > result.getDate().getTime()) {
                result = rate;
            }
            if (tariffType != rate.getTariffType() || ttResult != null && date.getTime() <= ttResult.getDate().getTime()) continue;
            ttResult = rate;
        }
        if (tariffType != null) {
            return ttResult != null ? ttResult : result;
        }
        return result;
    }

    private static CurrencyRate findCurrencyRateWithSuperCache(String baseCurrencyCode, String currencyCode, Date issueDate, CurrencyRateType rateType, TariffType tariffType, EntityReference<Organization> blankOwner, EntityReference<Organization> supplier) {
        if (null == tariffType && null == blankOwner) {
            return CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
        }
        CurrencyRate result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, blankOwner, supplier);
        if (result != null) {
            return result;
        }
        result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, tariffType, null, supplier);
        if (result != null) {
            return result;
        }
        result = CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, null, blankOwner, supplier);
        if (result != null) {
            return result;
        }
        return CurrencyRateSuperCache.get().findCurrencyRate(baseCurrencyCode, currencyCode, issueDate, rateType, null, null, supplier);
    }

    public static DictionaryReference<GeoLocation> findCityByName(String name) {
        GeoLocation gl = DictHelper.findGeoLocationByName(name, LocationType.CITY, null);
        return gl != null ? gl.toReference() : null;
    }

    public static DictionaryReference<GeoLocation> findCityByNameAndAnyVariants(String name) {
        GeoLocation gl = DictHelper.findGeoLocationsByNameAndAnyVariants(name, LocationType.CITY, null);
        return gl != null ? gl.toReference() : null;
    }

    public static DictionaryReference<GeoLocation> findAirportByNameAndAnyVariants(String name) {
        GeoLocation gl = DictHelper.findGeoLocationsByNameAndAnyVariants(name, LocationType.AIRPORT, null);
        return gl != null ? gl.toReference() : null;
    }

    public static GeoLocation findGeoLocationByName(String name, LocationType type, String countryCode) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        for (GeoLocation location : cache.getAll(GeoLocation.class).values()) {
            if (location.getType() != type) continue;
            if (countryCode != null) {
                String cc;
                DictionaryReference ref = location.getCountry();
                String string = cc = ref != null ? ref.getCode() : null;
                if (!countryCode.equalsIgnoreCase(cc)) continue;
            }
            for (Locale locale : location.getTranslations().keySet()) {
                if (!name.equalsIgnoreCase((String)location.getTranslations().get(locale))) continue;
                return location;
            }
        }
        return null;
    }

    public static Set<GeoLocation> findGeoLocationsByName(String name, LocationType type, String countryCode) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        HashSet<GeoLocation> result = new HashSet<GeoLocation>(1);
        for (GeoLocation location : cache.getAll(GeoLocation.class).values()) {
            if (location.getType() != type) continue;
            if (countryCode != null) {
                String cc;
                DictionaryReference ref = location.getCountry();
                String string = cc = ref != null ? ref.getCode() : null;
                if (!countryCode.equals(cc)) continue;
            }
            for (Locale locale : location.getTranslations().keySet()) {
                if (!name.equalsIgnoreCase((String)location.getTranslations().get(locale))) continue;
                result.add(location);
            }
        }
        return result;
    }

    public static GeoLocation findGeoLocationsByNameAndAnyVariants(String name, LocationType type, String countryCode) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        for (GeoLocation location : cache.getAll(GeoLocation.class).values()) {
            for (String translation : location.getTranslations().values()) {
                if (TextUtil.isBlank((String)translation) || !translation.equalsIgnoreCase(name)) continue;
                return location;
            }
            for (String variation : location.getSpellVariants()) {
                if (TextUtil.isBlank((String)variation) || !variation.equalsIgnoreCase(name)) continue;
                return location;
            }
        }
        return null;
    }

    public static DictionaryReference<GeoRegion> findGeoRegionByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        for (GeoRegion location : cache.getAll(GeoRegion.class).values()) {
            for (String translation : location.getTranslations().values()) {
                if (TextUtil.isBlank((String)translation) || !translation.equalsIgnoreCase(name.trim())) continue;
                return location.toReference();
            }
        }
        return null;
    }

    public static Map<Locale, String> getTranslationsFromL10nString(String value) {
        HashMap<Locale, String> translations = new HashMap<Locale, String>();
        Pattern pattern = Pattern.compile("[a-zA-Z]{2}(_){2}(\\|){2}[0-9\u0430-\u044f\u0410-\u042fa-zA-Z\\s-]+");
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String[] translation = matcher.group().split("\\|\\|");
            Locale locale = LocaleHelper.getLocale((String)translation[0].replaceAll("_", "").trim());
            String name = translation[1].trim();
            translations.put(locale, name);
        }
        return translations;
    }

    public static String getGeoRegionCode(Map<Locale, String> translations) {
        Locale currentLocale = LocaleHelper.getCurrentLocale();
        for (Map.Entry<Locale, String> entry : translations.entrySet()) {
            if (!MiscUtil.equals((Object)entry.getKey().getLanguage(), (Object)currentLocale.getLanguage())) continue;
            return entry.getValue();
        }
        if (!translations.isEmpty()) {
            return (String)translations.values().stream().sorted().iterator().next();
        }
        return null;
    }

    public static DictionaryReference<Country> findCountryByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        for (Country location : cache.getAll(Country.class).values()) {
            for (Locale locale : location.getTranslations().keySet()) {
                if (!name.equalsIgnoreCase((String)location.getTranslations().get(locale))) continue;
                return location.toReference();
            }
        }
        return null;
    }

    public static String findCityNameByCode(String code, CodeSystem codeSystem, Locale locale) {
        DictionaryCache cache = DictionaryCache.get();
        for (GeoLocation location : cache.lookup(GeoLocation.class, code, new String[]{codeSystem.name()})) {
            String result;
            GeoLocation parentLocation;
            if (location.getType() == LocationType.CITY && location.getCodeVariants().containsKey(codeSystem.name())) {
                for (Map.Entry translation : location.getTranslations().entrySet()) {
                    if (!((Locale)translation.getKey()).getLanguage().equals(locale.getLanguage())) continue;
                    return (String)translation.getValue();
                }
            }
            if ((parentLocation = (GeoLocation)cache.resolveReference(location.getParent())) == null || parentLocation.equals((Object)location)) continue;
            if (parentLocation.getType() == LocationType.CITY && parentLocation.getCodeVariants().containsKey(codeSystem.name())) {
                Map.Entry translation;
                translation = parentLocation.getTranslations().entrySet().iterator();
                while (translation.hasNext()) {
                    Map.Entry translation2 = (Map.Entry)translation.next();
                    if (!((Locale)translation2.getKey()).getLanguage().equals(locale.getLanguage())) continue;
                    return (String)translation2.getValue();
                }
            }
            if ((result = DictHelper.findCityNameByCode((String)parentLocation.getCodeVariants().get(codeSystem.name()), codeSystem, locale)) == null) continue;
            return result;
        }
        return null;
    }

    public static GeoLocation findCityByAirport(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        HashSet<String> seen = new HashSet<String>();
        GeoLocation loc = (GeoLocation)DictionaryCache.get().findByCode(GeoLocation.class, code);
        if (loc != null) {
            return DictHelper.findCity(seen, loc);
        }
        for (GeoLocation location : DictionaryCache.get().lookup(GeoLocation.class, code, new String[0])) {
            if ((location = DictHelper.findCity(seen, location)) == null) continue;
            return location;
        }
        return null;
    }

    public static GeoLocation findAirport(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        GeoLocation loc = (GeoLocation)cache.findByCode(GeoLocation.class, code);
        if (loc != null && loc.getType().equals((Object)LocationType.AIRPORT)) {
            return loc;
        }
        for (GeoLocation location : cache.lookup(GeoLocation.class, code, new String[0])) {
            if (location == null || !location.getType().equals((Object)LocationType.AIRPORT)) continue;
            return location;
        }
        return null;
    }

    public static List<DictionaryReference<GeoLocation>> findAirportsByCity(DictionaryReference<GeoLocation> locRef, boolean requireIATA) {
        ArrayList<DictionaryReference<GeoLocation>> result = new ArrayList<DictionaryReference<GeoLocation>>();
        if (locRef == null) {
            return result;
        }
        DictionaryCache cache = DictionaryCache.get();
        GeoLocation loc = (GeoLocation)cache.resolveReference(locRef);
        if (LocationType.AIRPORT.equals((Object)loc.getType())) {
            if (!requireIATA || loc.getCodeVariants().containsKey(CodeSystem.IATA.name())) {
                result.add(locRef);
            }
            return result;
        }
        for (GeoLocation value : cache.getAll(GeoLocation.class).values()) {
            if (value == null || !LocationType.AIRPORT.equals((Object)value.getType()) || value.getParent() == null || !value.getParent().equals(locRef) || requireIATA && !value.getCodeVariants().containsKey(CodeSystem.IATA.name())) continue;
            result.add((DictionaryReference<GeoLocation>)value.toReference());
        }
        return result;
    }

    public static List<DictionaryReference<GeoLocation>> findAirportsByCity(DictionaryReference<GeoLocation> locRef) {
        return DictHelper.findAirportsByCity(locRef, false);
    }

    public static GeoLocation findCityByStation(String code) {
        return DictHelper.findCityByAirport(code);
    }

    public static GeoLocation findLocation(DictionaryReference<GeoLocation> locationReference, LocationType locationType) {
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationReference);
        if (location == null) {
            return null;
        }
        return DictHelper.findLocation(location, locationType);
    }

    public static GeoLocation findLocation(GeoLocation location, LocationType locationType) {
        if (location == null) {
            return null;
        }
        if (locationType == null) {
            return location;
        }
        if (location.getType() == locationType) {
            return location;
        }
        GeoLocation parentLocation = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
        if (parentLocation == null || parentLocation.equals((Object)location)) {
            return null;
        }
        return DictHelper.findLocation(parentLocation, locationType);
    }

    public static GeoLocation findCity(DictionaryReference<GeoLocation> ref) {
        GeoLocation result = DictHelper.findCity(new HashSet<String>(), (GeoLocation)DictionaryCache.get().resolveReference(ref));
        if (result == null && ref != null) {
            log.warn("couldn't find city for " + ref.getCode());
        }
        return result;
    }

    public static DictionaryReference<GeoLocation> getCity(DictionaryReference<GeoLocation> ref) {
        return DictHelper.getCity(ref, new HashSet<DictionaryReference<GeoLocation>>());
    }

    private static DictionaryReference<GeoLocation> getCity(DictionaryReference<GeoLocation> ref, Set<DictionaryReference<GeoLocation>> seen) {
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(ref);
        if (loc == null || seen.contains(ref)) {
            return null;
        }
        if (loc.getType() == LocationType.CITY) {
            return ref;
        }
        if (loc.getParent() == null) {
            return null;
        }
        seen.add(ref);
        return DictHelper.getCity((DictionaryReference<GeoLocation>)loc.getParent(), seen);
    }

    public static GeoLocation findCity(GeoLocation location) {
        return DictHelper.findCity(new HashSet<String>(), location);
    }

    private static GeoLocation findCity(Set<String> seen, GeoLocation location) {
        if (location == null) {
            return null;
        }
        if (location.getType() == LocationType.CITY) {
            return location;
        }
        if (seen.contains(location.getUid())) {
            return null;
        }
        seen.add(location.getUid());
        GeoLocation parent = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
        if (parent == null || parent.equals((Object)location)) {
            return null;
        }
        return DictHelper.findCity(seen, parent);
    }

    public static String findCityCode(DictionaryReference<GeoLocation> location, CodeSystem codeSystem, boolean strict) {
        GeoLocation city = DictHelper.findCity(new HashSet<String>(), (GeoLocation)DictionaryCache.get().resolveReference(location));
        if (city == null) {
            return null;
        }
        if (codeSystem != null) {
            String res = (String)city.getCodeVariants().get(codeSystem.name());
            if (!TextUtil.isBlank((String)res)) {
                return res.trim();
            }
            if (strict) {
                return null;
            }
            return !city.getCodeVariants().isEmpty() ? ((String)city.getCodeVariants().values().iterator().next()).trim() : city.getCode().trim();
        }
        return !city.getCodeVariants().isEmpty() ? ((String)city.getCodeVariants().values().iterator().next()).trim() : city.getCode().trim();
    }

    public static String findGeolocationName(String variationCode) {
        Set items;
        if (TextUtil.isBlank((String)variationCode)) {
            return null;
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        GeoLocation item = (GeoLocation)dictionaryCache.findByCode(GeoLocation.class, variationCode);
        if (item == null && !(items = dictionaryCache.lookup(GeoLocation.class, variationCode, new String[0])).isEmpty()) {
            item = (GeoLocation)items.iterator().next();
        }
        if (item == null) {
            return variationCode;
        }
        return item.toString();
    }

    public static <T extends BaseDictionary> String findDictionaryCode(Class<T> cls, String variationCode, boolean unique) {
        if (TextUtil.isBlank((String)variationCode)) {
            return null;
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        BaseDictionary item = dictionaryCache.findByCode(cls, variationCode);
        if (item == null) {
            Set items = dictionaryCache.lookup(cls, variationCode, new String[0]);
            int size = items.size();
            if (unique && size > 1) {
                log.warn("More than one items found for code " + variationCode);
                return null;
            }
            if (!items.isEmpty()) {
                log.warn("No items found for code " + variationCode);
                item = (BaseDictionary)items.iterator().next();
            }
        }
        if (item == null) {
            return null;
        }
        return item.getCode();
    }

    public static <T extends BaseDictionary> Set<T> getDictionaryItemsByCode(Class<T> cls, String variationCode) {
        if (TextUtil.isBlank((String)variationCode)) {
            return Collections.emptySet();
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        BaseDictionary item = dictionaryCache.findByCode(cls, variationCode);
        HashSet<BaseDictionary> result = new HashSet<BaseDictionary>();
        if (item != null) {
            result.add(item);
        }
        result.addAll(dictionaryCache.lookup(cls, variationCode, new String[0]));
        return result;
    }

    public static DictionaryReference<Country> getCountry(DictionaryReference<GeoLocation> geoLocationRef) {
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(geoLocationRef);
        if (geoLocation == null) {
            return null;
        }
        if (geoLocation.getCountry() != null) {
            return geoLocation.getCountry();
        }
        DictionaryReference parent = geoLocation.getParent();
        if (parent == null) {
            return null;
        }
        return DictHelper.getCountry((DictionaryReference<GeoLocation>)parent);
    }

    public static boolean isInternational(DictionaryReference<GeoLocation> getLocationBegin, DictionaryReference<GeoLocation> getLocationEnd) {
        return !MiscUtil.equals(DictHelper.getCountry(getLocationBegin), DictHelper.getCountry(getLocationEnd));
    }

    public static Country findCountry(String geoLocationCode) {
        String parentCode;
        Set items;
        if (TextUtil.isBlank((String)geoLocationCode)) {
            return null;
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        GeoLocation item = (GeoLocation)dictionaryCache.findByCode(GeoLocation.class, geoLocationCode);
        if (item == null && !(items = dictionaryCache.lookup(GeoLocation.class, geoLocationCode, new String[0])).isEmpty()) {
            item = (GeoLocation)items.iterator().next();
        }
        if (item == null) {
            return null;
        }
        Country country = (Country)dictionaryCache.resolveReference(item.getCountry());
        if (country != null) {
            return country;
        }
        DictionaryReference parent = item.getParent();
        String string = parentCode = parent != null ? parent.getCode() : null;
        if (TextUtil.isBlank((String)parentCode) || parentCode.equals(geoLocationCode)) {
            return null;
        }
        return DictHelper.findCountry(parentCode);
    }

    public static String findCountryCode(DictionaryReference<Country> location, CodeSystem codeSystem, boolean strict) {
        Country country = DictHelper.findCountry(location.getCode());
        if (country == null) {
            return null;
        }
        if (codeSystem != null) {
            String res = (String)country.getCodeVariants().get(codeSystem.name());
            if (!TextUtil.isBlank((String)res)) {
                return res.trim();
            }
            if (strict) {
                return null;
            }
            return !country.getCodeVariants().isEmpty() ? ((String)country.getCodeVariants().values().iterator().next()).trim() : country.getCode().trim();
        }
        return !country.getCodeVariants().isEmpty() ? ((String)country.getCodeVariants().values().iterator().next()).trim() : country.getCode().trim();
    }

    public static double getPreferenceValue(PreferenceKey key, double def) {
        Preference preference = DictHelper.getPreference(key);
        if (preference != null) {
            try {
                return Double.parseDouble(preference.getValue());
            }
            catch (Exception e) {
                log.error("Unable to parse preference value " + key.name(), (Throwable)e);
                return def;
            }
        }
        log.warn("Unable to find preference value for " + key.name() + ". Default value " + def + " will be used");
        return def;
    }

    public static boolean getPreferenceValue(PreferenceKey key, boolean def) {
        Preference preference = DictHelper.getPreference(key);
        if (preference != null) {
            try {
                return Boolean.parseBoolean(preference.getValue());
            }
            catch (Exception e) {
                log.error("Unable to parse preference value " + key.name(), (Throwable)e);
                return def;
            }
        }
        log.warn("Unable to find preference value for " + key.name() + ". Default value " + def + " will be used");
        return def;
    }

    public static String getPreferenceValue(PreferenceKey key, String def) {
        Preference preference = DictHelper.getPreference(key);
        return preference != null ? preference.getValue() : def;
    }

    public static Preference getPreference(PreferenceKey key) {
        if (key == null) {
            return null;
        }
        for (Preference preference : DictionaryCache.get().getAll(Preference.class).values()) {
            if (preference.getKey() != key) continue;
            return preference;
        }
        return null;
    }

    public static Airline findAirlineByNumber(String number) {
        return DictHelper.findAirlineByNumber(number, null);
    }

    public static Airline findAirlineByNumber(String number, Date date) {
        if (TextUtil.isBlank((String)number)) {
            return null;
        }
        List<Airline> airlines = DictHelper.getAirlinesByNumber(number, date);
        if (airlines.isEmpty()) {
            return null;
        }
        return airlines.iterator().next();
    }

    public static List<Airline> getAirlinesByNumber(String airlineNumber, Date date) {
        if (TextUtil.isBlank((String)airlineNumber)) {
            return Collections.emptyList();
        }
        ArrayList<Airline> result = new ArrayList<Airline>();
        for (Airline airline : DictionaryCache.get().getAll(Airline.class).values()) {
            if (!DictHelper.isAirlineFitByDates(airline, date) || !airlineNumber.equalsIgnoreCase(airline.getAirlineNumber())) continue;
            result.add(airline);
        }
        return result;
    }

    public static Airline findAirlineByAnyCode(String code) {
        return DictHelper.findAirlineByAnyCode(code, null);
    }

    public static Aircraft findAircraftByAnyCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        Set<Aircraft> aircrafts = DictHelper.getAircraftsByAnyCode(code);
        if (aircrafts.isEmpty()) {
            return null;
        }
        return aircrafts.iterator().next();
    }

    public static Airline findAirlineByAnyCode(String code, Date date) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        Set airlinesByIataCode = DictionaryCache.get().lookup(Airline.class, code, new String[]{CodeSystem.IATA.name()});
        airlinesByIataCode.removeIf(airline -> !DictHelper.isAirlineFitByDates(airline, date));
        if (!airlinesByIataCode.isEmpty()) {
            return (Airline)airlinesByIataCode.iterator().next();
        }
        List airlineList = DictHelper.getAirlinesByAnyCodeStream(code, date).collect(Collectors.toList());
        if (airlineList.size() > 1) {
            return airlineList.stream().filter(airline -> airline.getCodeVariants().containsKey("IATA")).findFirst().orElseGet(() -> (Airline)airlineList.get(0));
        }
        if (airlineList.size() == 1) {
            return (Airline)airlineList.get(0);
        }
        return null;
    }

    public static Set<Aircraft> getAircraftsByAnyCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<Aircraft> result = new HashSet<Aircraft>();
        block0: for (Aircraft aircraft : DictionaryCache.get().getAll(Aircraft.class).values()) {
            if (code.equalsIgnoreCase(aircraft.getCode())) {
                result.add(aircraft);
                continue;
            }
            for (Map.Entry entry2 : aircraft.getCodeVariants().entrySet()) {
                String codeVariant = (String)entry2.getValue();
                if (!code.equalsIgnoreCase(codeVariant)) continue;
                result.add(aircraft);
                continue block0;
            }
        }
        return result;
    }

    public static CostCodeCategory getCostCodeCategoryBySabreName(String sabreShortName, String sabreFullName) {
        if (TextUtil.isBlank((String)sabreShortName) && TextUtil.isBlank((String)sabreFullName)) {
            return null;
        }
        return DictionaryCache.get().getAll(CostCodeCategory.class).values().stream().filter(category -> TextUtil.nonBlank((String)category.getShortName()) && MiscUtil.equals((Object)category.getShortName(), (Object)sabreShortName) || TextUtil.nonBlank((String)category.getName()) && MiscUtil.equals((Object)category.getName(), (Object)sabreFullName)).findFirst().orElse(null);
    }

    private static Stream<Airline> getAirlinesByAnyCodeStream(String code, Date date) {
        if (TextUtil.isBlank((String)code)) {
            return Stream.empty();
        }
        return DictionaryCache.get().getAll(Airline.class).values().stream().filter(airline -> DictHelper.isAirlineFitByDates(airline, date)).filter(airline -> {
            if (code.equalsIgnoreCase(airline.getCode())) return true;
            if (airline.getCodeVariants().values().stream().anyMatch(code::equalsIgnoreCase)) return true;
            if (!code.equalsIgnoreCase(airline.getAirlineNumber())) return false;
            return true;
        });
    }

    public static boolean isAirlineFitByDates(Airline airline, Date date) {
        if (airline == null || date == null) {
            return true;
        }
        return MiscUtil.isBetween((Date)airline.getOpenDate(), (Date)airline.getCloseDate(), (Date)date);
    }

    public static Set<Airline> getAirlinesByAnyCode(String code, Date date) {
        return DictHelper.getAirlinesByAnyCodeStream(code, date).collect(Collectors.toSet());
    }

    public static Airline getAirlineByCode(String code, CodeSystem codeSystem, Date date) {
        return DictionaryCache.get().getAll(Airline.class).values().stream().filter(a -> DictHelper.isAirlineFitByDates(a, date)).filter(a -> a.getCodeVariants().containsKey(codeSystem.name())).filter(a -> TextUtil.equals((String)((String)a.getCodeVariants().get(codeSystem.name())), (String)code, (boolean)false)).findFirst().orElse(null);
    }

    public static DictionaryReference<Airline> getAirlineByName(String airlineName) {
        if (TextUtil.isBlank((String)airlineName)) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        Map airlines = dcache.getAll(Airline.class);
        if (airlines.isEmpty()) {
            return null;
        }
        AirlineReference result = null;
        block0: for (Airline airline : airlines.values()) {
            for (String translation : airline.getTranslations().values()) {
                if (TextUtil.isBlank((String)translation) || !translation.equalsIgnoreCase(airlineName)) continue;
                result = airline.toReference();
                break block0;
            }
        }
        return result;
    }

    public static DictionaryReference<Airline> getAirlineByNameAndAnyVariants(String airlineName) {
        if (TextUtil.isBlank((String)airlineName)) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        Map airlines = dcache.getAll(Airline.class);
        if (airlines.isEmpty()) {
            return null;
        }
        AirlineReference result = null;
        block0: for (Airline airline : airlines.values()) {
            for (String translation : airline.getTranslations().values()) {
                if (TextUtil.isBlank((String)translation) || !translation.equalsIgnoreCase(airlineName)) continue;
                result = airline.toReference();
                break block0;
            }
            for (String variation : airline.getSpellVariants()) {
                if (TextUtil.isBlank((String)variation) || !variation.equalsIgnoreCase(airlineName)) continue;
                result = airline.toReference();
                break block0;
            }
        }
        return result;
    }

    public static DictionaryReference<CostCodeCategory> getCostCodeCategoryByName(String categoryName) {
        if (TextUtil.isBlank((String)categoryName)) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        Map categories = dcache.getAll(CostCodeCategory.class);
        if (categories.isEmpty()) {
            return null;
        }
        CostCodeCategoryReference result = null;
        block0: for (CostCodeCategory cat : categories.values()) {
            for (String translation : cat.getTranslations().values()) {
                if (TextUtil.isBlank((String)translation) || !translation.equalsIgnoreCase(categoryName.toUpperCase())) continue;
                result = cat.toReference();
                continue block0;
            }
        }
        return result;
    }

    public static boolean validateAlliances(DictionaryReference<Airline> cardOwner, Set<DictionaryReference<Airline>> segmentCarriers) {
        DictionaryCache dc = DictionaryCache.get();
        if (((Airline)dc.resolveReference(cardOwner)).getAlliance() != null) {
            for (DictionaryReference<Airline> segmentCarrier : segmentCarriers) {
                if (((Airline)dc.resolveReference(segmentCarrier)).getAlliance() == null || ((Airline)dc.resolveReference(cardOwner)).getAlliance().getCode().equals(((Airline)dc.resolveReference(segmentCarrier)).getAlliance().getCode())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static Set<Airline> findAirlinesByAlliance(DictionaryReference<AirlineAlliance> allianceRef) {
        HashSet<Airline> res = new HashSet<Airline>();
        Map airlines = DictionaryCache.get().getAll(Airline.class);
        for (Airline a : airlines.values()) {
            if (a.getAlliance() == null || !a.getAlliance().equals(allianceRef)) continue;
            res.add(a);
        }
        return res;
    }

    public static String toString(BaseDictionary value) {
        if (value == null) {
            return null;
        }
        String code = (String)value.getCodeVariants().get(CodeSystem.IATA.name());
        if (!TextUtil.isBlank((String)code)) {
            return code + " (" + value + ")";
        }
        code = (String)value.getCodeVariants().get(CodeSystem.CRT.name());
        if (!TextUtil.isBlank((String)code)) {
            return code + " (" + value + ")";
        }
        return value.getCode() + " (" + value + ")";
    }

    public static String toString(DictionaryReference<?> ref) {
        if (ref == null) {
            return null;
        }
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        return dict == null ? ref.toString() : DictHelper.toString(dict);
    }

    public static String toStringWithL10n(DictionaryReference<?> ref, Locale locale) {
        if (ref == null) {
            return null;
        }
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        if (dict == null) {
            return ref.getCode();
        }
        return (String)MiscUtil.findByLocale((Map)dict.getTranslations(), (Locale)locale);
    }

    public static String toStringWithL10n(DictionaryReference<?> ref, Locale locale, Locale defaultLocale) {
        if (ref == null) {
            return null;
        }
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        if (dict == null) {
            return ref.getCode();
        }
        return (String)MiscUtil.findByLocale((Map)dict.getTranslations(), (Locale)locale, (Locale)defaultLocale);
    }

    public static String getCurrencyByAnyCode(String currencyCode) {
        CurrencyInfo result = DictHelper.getCurrencyInfoByAnyCode(currencyCode);
        if (result != null) {
            return result.getCode();
        }
        return null;
    }

    public static boolean isPercent(CurrencyInfo info) {
        return "%".equals(info.getCode());
    }

    public static CurrencyInfo getCurrencyInfoByAnyCode(String currencyCode) {
        if (TextUtil.isBlank((String)currencyCode)) {
            return null;
        }
        if ("%".equals(currencyCode)) {
            return percent;
        }
        HashSet<CurrencyInfo> result = new HashSet<CurrencyInfo>();
        block0: for (CurrencyInfo currency : DictionaryCache.get().getAll(CurrencyInfo.class).values()) {
            String codeVariant;
            if (currency == null) continue;
            if (currencyCode.equalsIgnoreCase(currency.getCode())) {
                result.add(currency);
                continue;
            }
            for (Map.Entry entry2 : currency.getCodeVariants().entrySet()) {
                codeVariant = (String)entry2.getValue();
                if (!currencyCode.equalsIgnoreCase(codeVariant)) continue;
                result.add(currency);
                break;
            }
            for (String spellVar : currency.getSpellVariants()) {
                if (!currencyCode.equalsIgnoreCase(spellVar)) continue;
                result.add(currency);
                break;
            }
            for (Map.Entry transl : currency.getTranslations().entrySet()) {
                codeVariant = (String)transl.getValue();
                if (!currencyCode.equalsIgnoreCase(codeVariant)) continue;
                result.add(currency);
                continue block0;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return (CurrencyInfo)result.iterator().next();
    }

    public static boolean isSameCarriers(DictionaryReference<Airline> ref1, DictionaryReference<Airline> ref2) {
        String code2;
        if (ref1 == null) {
            return ref2 == null;
        }
        if (ref2 == null) {
            return false;
        }
        String code1 = ref1.getCode();
        if (code1.equals(code2 = ref2.getCode())) {
            return true;
        }
        for (Airline ac1 : DictHelper.getAirlinesByAnyCode(code1, null)) {
            for (Airline ac2 : DictHelper.getAirlinesByAnyCode(code2, null)) {
                if (!ac1.equals((Object)ac2)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Country> findCountryByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<Country> result = new HashSet<Country>();
        block0: for (Country country : DictionaryCache.get().getAll(Country.class).values()) {
            if (country == null) continue;
            if (code.equalsIgnoreCase(country.getCode())) {
                result.add(country);
                continue;
            }
            for (Map.Entry codeVariantEntry : country.getCodeVariants().entrySet()) {
                String codeVariant = (String)codeVariantEntry.getValue();
                if (!code.equalsIgnoreCase(codeVariant)) continue;
                result.add(country);
                continue block0;
            }
        }
        return result;
    }

    public static MetroStation findMetroStationByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        for (MetroStation station : DictionaryCache.get().getAll(MetroStation.class).values()) {
            if (station == null || !code.equalsIgnoreCase(station.getCode())) continue;
            return station;
        }
        return null;
    }

    public static DeliveryRegion findDeliveryRegionByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        for (DeliveryRegion region : DictionaryCache.get().getAll(DeliveryRegion.class).values()) {
            if (region == null || !code.equalsIgnoreCase(region.getCode())) continue;
            return region;
        }
        return null;
    }

    public static Set<GeoLocation> findGeoLocationByCode(String code, LocationType type) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<GeoLocation> geoLocations = new HashSet<GeoLocation>();
        block0: for (GeoLocation geoLocation : DictionaryCache.get().getAll(GeoLocation.class).values()) {
            if (geoLocation == null || type != null && geoLocation.getType() != type) continue;
            if (code.equalsIgnoreCase(geoLocation.getCode())) {
                geoLocations.add(geoLocation);
                continue;
            }
            for (Map.Entry codeVariantEntry : geoLocation.getCodeVariants().entrySet()) {
                String codeVariant = (String)codeVariantEntry.getValue();
                if (!code.equalsIgnoreCase(codeVariant)) continue;
                geoLocations.add(geoLocation);
                continue block0;
            }
        }
        return geoLocations;
    }

    public static Set<LegalForm> findLegalFormByAbbreviation(String abbreviation) {
        if (TextUtil.isBlank((String)abbreviation)) {
            return Collections.emptySet();
        }
        HashSet<LegalForm> legalForms = new HashSet<LegalForm>();
        block0: for (LegalForm legalForm : DictionaryCache.get().getAll(LegalForm.class).values()) {
            if (legalForm == null) continue;
            if (abbreviation.equalsIgnoreCase(legalForm.getCode())) {
                legalForms.add(legalForm);
                continue;
            }
            for (Map.Entry codeVariantEntry : legalForm.getCodeVariants().entrySet()) {
                String codeVariant = (String)codeVariantEntry.getValue();
                if (!abbreviation.equalsIgnoreCase(codeVariant)) continue;
                legalForms.add(legalForm);
                break;
            }
            for (Map.Entry abbreviationEntry : legalForm.getAbbreviations().entrySet()) {
                String abbreviationValue = (String)abbreviationEntry.getValue();
                if (!abbreviation.equalsIgnoreCase(abbreviationValue)) continue;
                legalForms.add(legalForm);
                continue block0;
            }
        }
        return legalForms;
    }

    public static Set<HotelsBrand> findHotelBrandByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<HotelsBrand> result = new HashSet<HotelsBrand>();
        block0: for (HotelsBrand hotel : DictionaryCache.get().getAll(HotelsBrand.class).values()) {
            if (hotel == null) continue;
            if (code.equalsIgnoreCase(hotel.getCode())) {
                result.add(hotel);
                continue;
            }
            for (Map.Entry codeVariantEntry : hotel.getCodeVariants().entrySet()) {
                String codeVariant = (String)codeVariantEntry.getValue();
                if (!code.equalsIgnoreCase(codeVariant)) continue;
                result.add(hotel);
                continue block0;
            }
        }
        return result;
    }

    public static Set<HotelsBrand> findHotelBrandByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return Collections.emptySet();
        }
        HashSet<HotelsBrand> result = new HashSet<HotelsBrand>();
        for (HotelsBrand hotel : DictionaryCache.get().getAll(HotelsBrand.class).values()) {
            if (hotel == null || !TextUtil.isSame((String)hotel.getName(), (String)name, (boolean)true) && !hotel.getTranslations().containsValue(name)) continue;
            result.add(hotel);
        }
        return result;
    }

    public static Set<CarsSupplier> findCarsSupplierByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<CarsSupplier> result = new HashSet<CarsSupplier>();
        block0: for (CarsSupplier car : DictionaryCache.get().getAll(CarsSupplier.class).values()) {
            if (car == null) continue;
            if (code.equalsIgnoreCase(car.getCode())) {
                result.add(car);
                continue;
            }
            for (Map.Entry codeVariantEntry : car.getCodeVariants().entrySet()) {
                String codeVariant = (String)codeVariantEntry.getValue();
                if (!code.equalsIgnoreCase(codeVariant)) continue;
                result.add(car);
                continue block0;
            }
        }
        return result;
    }

    public static Set<CarsSupplier> findCarsSupplierByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return Collections.emptySet();
        }
        HashSet<CarsSupplier> result = new HashSet<CarsSupplier>();
        for (CarsSupplier car : DictionaryCache.get().getAll(CarsSupplier.class).values()) {
            if (car == null || !car.getTranslations().containsValue(name)) continue;
            result.add(car);
        }
        return result;
    }

    public static CarClass findCarsClassByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        return (CarClass)DictionaryCache.get().findByCode(CarClass.class, code);
    }

    public static CarClass findCarsClassByCodeVariant(String code, CodeSystem codeSystem) {
        Collection allClasses = DictionaryCache.get().getAll(CarClass.class).values();
        for (CarClass carClass : allClasses) {
            List split;
            String codeVariant = (String)carClass.getCodeVariants().get(codeSystem.name());
            if (TextUtil.isBlank((String)codeVariant) || !(split = TextUtil.split((String)codeVariant, (String)",", (boolean)true, (boolean)true)).stream().anyMatch(s -> s.equals(code))) continue;
            return carClass;
        }
        return null;
    }

    public static CarClass findCarsClassByTranslation(String translation) {
        Collection allClasses = DictionaryCache.get().getAll(CarClass.class).values();
        return allClasses.stream().filter(carClass -> carClass.getTranslations().containsValue(translation)).findAny().orElse(null);
    }

    public static boolean isBspTicket(String number) {
        DictionaryCache cache = DictionaryCache.get();
        if (!TextUtil.isBlank((String)number) && number.length() >= 3) {
            BspTicketPrefixNo prefix = (BspTicketPrefixNo)cache.findByCode(BspTicketPrefixNo.class, number.substring(0, 3));
            if (prefix != null) {
                return true;
            }
            prefix = (BspTicketPrefixNo)cache.findByCode(BspTicketPrefixNo.class, number.substring(0, 2));
            return prefix != null;
        }
        return false;
    }

    public static boolean isTchTicket(String number) {
        return number != null && number.startsWith("61");
    }

    public static String getShortLegalForm(DictionaryReference<LegalForm> legalForm, Locale loc) {
        Locale locale;
        LegalForm form = (LegalForm)DictionaryCache.get().resolveReference(legalForm);
        if (form == null || form.getAbbreviations().isEmpty()) {
            return null;
        }
        Locale locale2 = locale = loc != null ? loc : LocaleManager.get().getCurrentLocale();
        if (form.getAbbreviations().containsKey(locale)) {
            return (String)form.getAbbreviations().get(locale);
        }
        return (String)form.getAbbreviations().values().iterator().next();
    }

    public static DictionaryReference<LegalForm> getLegalForm(String shortLegalForm) {
        Map allLegalForms = DictionaryCache.get().getAll(LegalForm.class);
        if (allLegalForms == null || allLegalForms.isEmpty()) {
            return null;
        }
        for (LegalForm lf : allLegalForms.values()) {
            if (!lf.getAbbreviations().containsValue(shortLegalForm)) continue;
            return lf.toReference();
        }
        return null;
    }

    public static ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, ClassOfService serviceClass) {
        return DictHelper.findClassOfServiceCode(airline, null, serviceClass);
    }

    public static ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, ClassOfService serviceClass) {
        for (ClassOfServiceCode item : DictionaryCache.get().getAll(ClassOfServiceCode.class).values()) {
            if (item.getClassOfService() != serviceClass || !MiscUtil.equals(airline, (Object)item.getAirline()) || operatingAirline != null && !MiscUtil.equals(operatingAirline, (Object)item.getOperatingAirline())) continue;
            return item;
        }
        return null;
    }

    public static ClassOfService findClassOfService(Segment segment, Date issueDate) {
        return DictHelper.findClassOfService(segment, issueDate, false);
    }

    public static ClassOfService findClassOfService(Segment segment, Date issueDate, boolean nullable) {
        if (segment.getServiceClass() != null) {
            return segment.getServiceClass();
        }
        String classOfSvcCode = AirProductHelper.getClassOfServiceCode(segment);
        ClassOfServiceCode classOfServiceCode = DictHelper.findClassOfServiceCode((DictionaryReference<Airline>)segment.getAirline(), (DictionaryReference<Airline>)segment.getCodeShareCarrier(), classOfSvcCode, issueDate, DictHelper.isInternational((DictionaryReference<GeoLocation>)segment.getDepartureLocation(), (DictionaryReference<GeoLocation>)segment.getArriveLocation()));
        if (classOfServiceCode == null) {
            log.warn(String.format("class of service code not found for airline=%s, codeShareCarrier=%s, classOfSvcCode=%s, issueDate=%s", segment.getAirline(), segment.getCodeShareCarrier(), classOfSvcCode, issueDate));
            return nullable ? null : ClassOfService.ECONOMY;
        }
        return classOfServiceCode.getClassOfService();
    }

    public static ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, String code, boolean international) {
        return DictHelper.findClassOfServiceCode(airline, null, code, null, international);
    }

    public static ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, DictionaryReference<Airline> operating, String code, boolean international) {
        return DictHelper.findClassOfServiceCode(airline, operating, code, null, international);
    }

    public static Collection<ClassOfServiceCode> getListLocationBasedInternational(Collection<ClassOfServiceCode> list, boolean international) {
        return list.stream().filter(item -> item.getTransportationType() == null || international == (item.getTransportationType() == TransportationType.INTERNATIONAL)).sorted(Comparator.comparing(ClassOfServiceCode::getTransportationType, (s1, s2) -> MiscUtil.compare((Comparable)s1, (Comparable)s2, (boolean)false))).collect(Collectors.toList());
    }

    public static ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, String code, Date issueDate, boolean international) {
        return DictHelper.findClassOfServiceCode(airline, operatingAirline, code, issueDate, international, false);
    }

    public static ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, String code, Date issueDate, boolean international, boolean strict) {
        ClassOfServiceCode res;
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        Collection<ClassOfServiceCode> list = DictHelper.getListLocationBasedInternational(DictionaryCache.get().getAll(ClassOfServiceCode.class).values(), international);
        Comparator comparator = (c1, c2) -> c1.getStartDate() == null && c1.getEndDate() == null ? 1 : (c2.getStartDate() == null && c2.getEndDate() == null ? -1 : 0);
        if (airline != null && operatingAirline != null && ((res = (ClassOfServiceCode)list.stream().filter(cos -> airline.equals((Object)cos.getAirline()) && operatingAirline.equals((Object)cos.getOperatingAirline())).map(cos -> DictHelper.checkCode(cos, issueDate, code)).filter(Objects::nonNull).min(comparator).orElse(null)) != null || strict)) {
            return res;
        }
        if (airline != null && ((res = (ClassOfServiceCode)list.stream().filter(cos -> airline.equals((Object)cos.getAirline()) && cos.getOperatingAirline() == null).map(cos -> DictHelper.checkCode(cos, issueDate, code)).filter(Objects::nonNull).min(comparator).orElse(null)) != null || strict)) {
            return res;
        }
        return list.stream().filter(cos -> cos.getAirline() == null && cos.getOperatingAirline() == null).map(cos -> DictHelper.checkCode(cos, issueDate, code)).filter(Objects::nonNull).min(comparator).orElse(null);
    }

    public static ClassOfServiceCode findClassOfServiceCodeV2(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, String code, Date issueDate, boolean allowOnlyOneCode) {
        List<ClassOfServiceCode> codeList = DictHelper.findBestMatchingClassOfServiceCodes(airline, operatingAirline, code, issueDate);
        if (codeList == null) {
            return null;
        }
        if (codeList.size() > 1) {
            ArrayList<String> codes = new ArrayList<String>(codeList.size());
            for (ClassOfServiceCode cosc : codeList) {
                codes.add(cosc.getClassOfService().name());
            }
            log.error(String.format("More than 1 class of service record was matched for booking class %s, airline %s, operating airline %s: %s", code, airline == null ? "null" : airline.getCode(), operatingAirline == null ? "null" : operatingAirline.getCaption(), TextUtil.join((String)",", codes)));
            if (allowOnlyOneCode) {
                return null;
            }
        }
        return codeList.get(0);
    }

    public static List<ClassOfServiceCode> findBestMatchingClassOfServiceCodes(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, String code, Date issueDate) {
        List<ClassOfServiceCode> codeList = DictHelper.findClassOfServiceCodes(airline, operatingAirline, code, issueDate);
        if (codeList.isEmpty()) {
            if (operatingAirline != null) {
                codeList = DictHelper.findClassOfServiceCodes(airline, null, code, issueDate);
            }
            if (codeList.isEmpty()) {
                if (airline != null) {
                    codeList = DictHelper.findClassOfServiceCodes(null, null, code, issueDate);
                    if (codeList.isEmpty()) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
        }
        return codeList;
    }

    public static List<ClassOfServiceCode> findClassOfServiceCodes(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, String code, Date issueDate) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptyList();
        }
        Collection list = DictionaryCache.get().getAll(ClassOfServiceCode.class).values();
        ClassOfServiceCode firstResult = null;
        List results = null;
        for (ClassOfServiceCode item : list) {
            ClassOfServiceCode res;
            if (!MiscUtil.equals(airline, (Object)item.getAirline()) || !MiscUtil.equals(operatingAirline, (Object)item.getOperatingAirline()) || (res = DictHelper.checkCode(item, issueDate, code)) == null) continue;
            if (firstResult == null) {
                firstResult = res;
                continue;
            }
            if (results == null) {
                results = new ArrayList();
                results.add(firstResult);
            }
            results.add(res);
        }
        return results != null ? results : (firstResult == null ? Collections.emptyList() : Collections.singletonList(firstResult));
    }

    public static Collection<ClassOfServiceCode> getAllClassOfServiceCodes() {
        return DictionaryCache.get().getAll(ClassOfServiceCode.class).values();
    }

    private static ClassOfServiceCode checkCode(ClassOfServiceCode item, Date issueDate, String code) {
        if (item.getClassOfService() == null || item.getCodes().isEmpty()) {
            return null;
        }
        GregorianCalendar calStart = null;
        if (item.getStartDate() != null) {
            calStart = new GregorianCalendar();
            calStart.setTime(item.getStartDate());
            calStart.set(11, 0);
            calStart.set(12, 0);
            calStart.set(13, 0);
        }
        GregorianCalendar calEnd = null;
        if (item.getEndDate() != null) {
            calEnd = new GregorianCalendar();
            calEnd.setTime(item.getEndDate());
            calEnd.set(11, 23);
            calEnd.set(12, 59);
            calEnd.set(13, 59);
        }
        if (calStart != null && issueDate != null && calStart.getTime().after(issueDate)) {
            return null;
        }
        if (calEnd != null && issueDate != null && calEnd.getTime().before(issueDate)) {
            return null;
        }
        if (item.getCodes().contains(code.toLowerCase()) || item.getCodes().contains(code.toUpperCase())) {
            return item;
        }
        return null;
    }

    public static Set<GeoLocation> findCity(String cityName) {
        if (TextUtil.isBlank((String)cityName)) {
            return Collections.emptySet();
        }
        return DictionaryCache.get().search(GeoLocation.class, cityName);
    }

    public static String getAirportCode(DictionaryReference<GeoLocation> location, CodeSystem codeSystem) {
        if (location == null || codeSystem == null) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        GeoLocation gl = (GeoLocation)dcache.resolveReference(location);
        if (gl == null || gl.getCodeVariants() == null) {
            return null;
        }
        return (String)gl.getCodeVariants().get(codeSystem.name());
    }

    public static DictionaryReference<GeoLocation> getAirport(String airportCode, CodeSystem codeSystem) {
        if (TextUtil.isBlank((String)airportCode) || codeSystem == null) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        Set airlines = dcache.lookup(GeoLocation.class, airportCode, new String[]{codeSystem.toString()});
        if (airlines.isEmpty()) {
            return null;
        }
        Iterator iterator = airlines.iterator();
        GeoLocationReference result = null;
        while (iterator.hasNext()) {
            GeoLocation geoLocation = (GeoLocation)iterator.next();
            if (geoLocation.getType() != LocationType.AIRPORT) continue;
            result = geoLocation.toReference();
            break;
        }
        return result;
    }

    public static DictionaryReference<GeoLocation> getAirportByName(String airportName) {
        if (TextUtil.isBlank((String)airportName)) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        Set airlines = dcache.lookup(GeoLocation.class, airportName, new String[0]);
        if (airlines.isEmpty()) {
            return null;
        }
        Iterator iterator = airlines.iterator();
        GeoLocationReference result = null;
        if (iterator.hasNext()) {
            result = ((GeoLocation)iterator.next()).toReference();
        }
        return result;
    }

    public static String findAirportName(DictionaryReference<GeoLocation> location, Locale locale) {
        if (location == null || locale == null) {
            return null;
        }
        DictionaryCache dcache = DictionaryCache.get();
        GeoLocation gl = (GeoLocation)dcache.resolveReference(location);
        if (gl == null || gl.getCodeVariants() == null) {
            return null;
        }
        return (String)gl.getTranslations().get(locale);
    }

    public static String getCityName(GeoLocation location, Locale locale, String defaultValue, boolean onlyCodes, CodeSystem codeSystem) {
        String defResult;
        String string = defResult = defaultValue != null ? defaultValue : "?";
        if (location == null) {
            return defResult;
        }
        if (!onlyCodes) {
            return locale != null ? location.toString(locale) : location.toString();
        }
        if (location.getCodeVariants().isEmpty()) {
            return defResult;
        }
        String result = null;
        if (codeSystem != null) {
            result = (String)location.getCodeVariants().get(codeSystem.name());
        }
        return result != null ? result : (String)location.getCodeVariants().entrySet().iterator().next().getValue();
    }

    public static String getProductCategoryShortName(ProductCategory category) {
        if (category == null) {
            return "";
        }
        switch (category) {
            case AIR: {
                return "\u0410/\u0411";
            }
            case EXCESS_BAGAGE: {
                return "\u0411\u0430\u0433\u0430\u0436\u043d\u0430\u044f\u00a0\u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f";
            }
        }
        return category.toString();
    }

    public static String getLocalCurrencyCode() {
        return DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
    }

    public static String getLocalCurrency() {
        return DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB");
    }

    public static String getLocalCurrency2() {
        String currencyCode = DictHelper.getLocalCurrencyCode();
        return !TextUtil.isBlank((String)currencyCode) ? currencyCode : null;
    }

    public static boolean isHasDifferentAirportCode(DictionaryReference<GeoLocation> cityRef, CodeSystem cs) {
        DictionaryCache dc = DictionaryCache.get();
        GeoLocation city = (GeoLocation)dc.resolveReference(cityRef);
        if (city == null || city.getType() != LocationType.CITY) {
            return false;
        }
        for (GeoLocation loc : dc.search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.parent.name(), cityRef))) {
            if (loc.getType() != LocationType.AIRPORT) continue;
            if (DictHelper.codesDiffer(loc.getCodeVariants().entrySet(), city.getCodeVariants().entrySet(), cs)) {
                return true;
            }
            if (!DictHelper.codesDiffer(city.getCodeVariants().entrySet(), loc.getCodeVariants().entrySet(), cs)) continue;
            return true;
        }
        return false;
    }

    private static boolean codesDiffer(Set<Map.Entry<String, String>> codes1, Set<Map.Entry<String, String>> codes2, CodeSystem cs) {
        block0: for (Map.Entry<String, String> entry1 : codes1) {
            String csName1 = entry1.getKey();
            if (cs != null && !cs.name().equals(csName1)) continue;
            for (Map.Entry<String, String> entry2 : codes2) {
                String csName2 = entry2.getKey();
                if (!csName2.equals(csName1) || !TextUtil.isSame((String)entry1.getValue(), (String)entry2.getValue())) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static String getCityCode(GeoLocation location, String defaultValue) {
        return location != null ? location.getCode() : defaultValue;
    }

    public static GeoLocation findStationByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        Set geoLocations = cache.search(GeoLocation.class, name);
        for (GeoLocation geoLocation : geoLocations) {
            if (geoLocation.getType() != LocationType.STATION) continue;
            return geoLocation;
        }
        return null;
    }

    public static String getWeekDay(int weekDayNumber) {
        String result = null;
        switch (weekDayNumber) {
            case 0: {
                result = WeekDay.SUNDAY.name();
                break;
            }
            case 1: {
                result = WeekDay.MONDAY.name();
                break;
            }
            case 2: {
                result = WeekDay.TUESDAY.name();
                break;
            }
            case 3: {
                result = WeekDay.WEDNESDAY.name();
                break;
            }
            case 4: {
                result = WeekDay.THURSDAY.name();
                break;
            }
            case 5: {
                result = WeekDay.FRIDAY.name();
                break;
            }
            case 6: {
                result = WeekDay.SATURDAY.name();
            }
        }
        return result;
    }

    public static <E extends Enum<?>, D extends BaseDictionary> E getDictionaryStandardValueType(DictionaryReference<D> dictionary, Class<E> type) {
        String code = dictionary.getCode();
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        for (Enum enumConstant : (Enum[])type.getEnumConstants()) {
            if (!enumConstant.name().equals(code)) continue;
            return (E)enumConstant;
        }
        return null;
    }

    public static GeoLocation findAirportByCodeVariant(String codeVariant) {
        if (TextUtil.isBlank((String)codeVariant)) {
            return null;
        }
        for (GeoLocation geoLocation : DictHelper.findGeoLocationsByCodeVariant(codeVariant)) {
            if (geoLocation.getType() != LocationType.AIRPORT) continue;
            return geoLocation;
        }
        return null;
    }

    public static GeoLocation findGeoLocationByCodeVariant(String codeVariant) {
        return DictHelper.findGeoLocationByCodeVariant(codeVariant, null, null);
    }

    public static GeoLocation findGeoLocationByCodeVariant(String codeVariant, CodeSystem codeSystem, LocationType type) {
        if (TextUtil.isBlank((String)codeVariant)) {
            return null;
        }
        Set geoLocations = codeSystem != null ? DictionaryCache.get().lookup(GeoLocation.class, codeVariant, new String[]{codeSystem.name()}) : DictHelper.findGeoLocationsByCodeVariant(codeVariant);
        for (GeoLocation geoLocation : geoLocations) {
            if (geoLocation == null || type != null && type != geoLocation.getType()) continue;
            return geoLocation;
        }
        return null;
    }

    public static Collection<GeoLocation> findGeoLocationsByCodeVariant(String codeVariant) {
        if (TextUtil.isBlank((String)codeVariant)) {
            return Collections.emptySet();
        }
        Collection codeSystemNames = CollectionUtil.transform(Enum::name, (Object[])CodeSystem.values());
        return DictionaryCache.get().lookup(GeoLocation.class, codeVariant, codeSystemNames.toArray(new String[0]));
    }

    public static List<HotelsBrand> getHotelsBrands() {
        ArrayList<HotelsBrand> result = new ArrayList<HotelsBrand>();
        for (HotelsBrand brand : DictionaryCache.get().getAll(HotelsBrand.class).values()) {
            if (!brand.getType().equals((Object)HotelsBrandType.BRAND)) continue;
            result.add(brand);
        }
        return result;
    }

    public static DictionaryReference<RoomSizeDict> findRoomSizeByAnyCode(String code, String productUid) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        RoomSizeDict res = DictHelper.getRoomSize(code, false);
        if (res != null) {
            return res.toReference();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DictUpdateItemIndex.Property.newValue.name(), (Object)code));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DictUpdateItemIndex.Property.field.name(), (Object)DictUpdateField.HOTEL_ROOM_ADDITIONAL_CODE));
        SearchResult searchRes = EntityStorage.get().search(DictUpdateItemIndex.class, query);
        if (searchRes.getData().size() > 0) {
            if (productUid != null) {
                ExceptionUtil.wrap(() -> LockUtil.lock((EntityReference)((DictUpdateItemIndex)searchRes.getData().get(0)).getSource(), ctr -> {
                    if (ctr != null && ctr.getEntity() != null) {
                        ((DictUpdateItem)ctr.getEntity()).getProductUids().add(productUid);
                        EntityStorage.get().save(ctr, false);
                    }
                }));
            }
        } else {
            EntityContainer ctr = new EntityContainer(DictUpdateItem.class);
            DictUpdateItem item = (DictUpdateItem)ctr.getEntity();
            item.setDictClassName(RoomSizeDict.class.getName());
            item.setField(DictUpdateField.HOTEL_ROOM_ADDITIONAL_CODE);
            item.setNewValue(code);
            if (productUid != null) {
                item.getProductUids().add(productUid);
            }
            EntityStorage.get().save(ctr, false);
        }
        return DictHelper.getEmptyRSD(code).toReference();
    }

    public static RoomSizeDict getRoomSize(String code, boolean strict) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        if (strict) {
            return (RoomSizeDict)DictionaryCache.get().findByCode(RoomSizeDict.class, code);
        }
        for (RoomSizeDict dict : DictionaryCache.get().getAll(RoomSizeDict.class).values()) {
            if (!dict.getCode().equals(code) && !dict.getCodes().contains(code) && !dict.getCode().replaceAll("[^a-zA-Z0-9 ]", "").equals(code) && !dict.getCodes().stream().anyMatch(dictCode -> dictCode != null && code.equals(dictCode.replaceAll("[^a-zA-Z0-9 ]", "")))) continue;
            return dict;
        }
        return null;
    }

    public static List<String> findAllRoomSizeCodesByAnyCode(String code) {
        ArrayList<String> res = new ArrayList<String>();
        if (code == null) {
            return res;
        }
        for (RoomSizeDict dict : DictionaryCache.get().getAll(RoomSizeDict.class).values()) {
            if (!dict.getCode().equals(code) && !dict.getCodes().contains(code)) continue;
            res.add(dict.getCode());
            res.addAll(dict.getCodes());
            break;
        }
        return res;
    }

    private static RoomSizeDict getEmptyRSD(String code) {
        RoomSizeDict empty = new RoomSizeDict();
        empty.setCode(code);
        empty.setImportedFromSabre(true);
        empty.getTranslations().put(Locale.ENGLISH, NOT_RECOGNIZED_ROOM_TYPE);
        return empty;
    }

    public static <P extends BaseProduct> BigDecimal getDefaultVat(P prod) {
        ProductHandler<P> handler = GeneralProductHelper.getHandler(prod);
        Date issueDate = handler.getStatus(prod) == ProductStatus.EXCHANGE || handler.getStatus(prod) == ProductStatus.REFUND && (!Environment.isTest() || handler.getPreviousProduct(prod) != null) ? handler.findIssueDate(handler.getPreviousProduct(prod)) : handler.findIssueDate(prod);
        return DictHelper.getDefaultVat(issueDate);
    }

    public static BigDecimal getDefaultVat() {
        return DictHelper.getDefaultVat(new Date());
    }

    public static BigDecimal getDefaultVat(Date date) {
        boolean ri = SystemHelper.isRussianInstallation();
        if (ri) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date != null ? date : new Date());
            int year = cal.get(1);
            if (year >= 2019) {
                return BigDecimal.valueOf(20L);
            }
            return BigDecimal.valueOf(18L);
        }
        BigDecimal defaultVat = null;
        try {
            String defaultVatString = DictHelper.getPreferenceValue(PreferenceKey.DEFAULT_VAT, null);
            if (defaultVatString != null) {
                defaultVat = new BigDecimal(defaultVatString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultVat;
    }

    public static String getEquivCurrency() {
        return DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null);
    }

    public static List<DictionaryReference<Country>> findDomesticCountries() {
        ArrayList<DictionaryReference<Country>> res = new ArrayList<DictionaryReference<Country>>();
        DictionaryCache cache = DictionaryCache.get();
        for (Country location : cache.getAll(Country.class).values()) {
            if (!location.isDomestic()) continue;
            res.add((DictionaryReference<Country>)location.toReference());
        }
        return res;
    }

    public static String getDomesticCountryRussianName() {
        String country;
        List<DictionaryReference<Country>> domCountryRefs = DictHelper.findDomesticCountries();
        DictionaryReference<Country> domRef = domCountryRefs.size() != 0 ? domCountryRefs.get(0) : DictHelper.findCountryByName("\u0420\u043e\u0441\u0441\u0438\u044f");
        Country dom = null;
        if (domRef != null) {
            dom = (Country)DictionaryCache.get().resolveReference(domRef);
        }
        if (dom != null) {
            Locale loc = LocaleHelper.getLocale((String)"RU");
            country = (String)dom.getTranslations().get(loc);
        } else {
            country = "\u0420\u043e\u0441\u0441\u0438\u044f";
        }
        return country;
    }

    public static String getDefaultCardCode(CardVendor v) {
        return defaultCardCodes.get(v);
    }

    public static String getSabreCardCode(CardVendor v) {
        return sabreCardCodes.get(v);
    }

    public static Hotel getSabreHotel(String hotelId) {
        Hotel result = null;
        if (HotelAggregatorHelper.isHotelAggregatorEnabled()) {
            result = HotelAggregatorHelper.searchHotelByProviderCode(hotelId, HotelProvider.SABRE);
        }
        if (result == null) {
            return (Hotel)CollectionUtil.head(DictHelper.getSabreHotelsFromRemoteServer(hotelId));
        }
        return result;
    }

    public static List<Hotel> getSabreHotels(String hotelId, String country, String city, String chain, String partOfName, int limit) {
        ArrayList<Hotel> result = new ArrayList<Hotel>();
        if (HotelAggregatorHelper.isHotelAggregatorEnabled()) {
            if (TextUtil.nonBlank((String)hotelId)) {
                result.addAll(CollectionUtil.toList((Object)HotelAggregatorHelper.searchHotelByProviderCode(hotelId, HotelProvider.SABRE)));
            } else {
                result.addAll(HotelAggregatorHelper.searchHotels(HotelProvider.SABRE, (DictionaryReference<Country>)(TextUtil.nonBlank((String)country) ? new CountryReference(country) : null), (DictionaryReference<GeoLocation>)(TextUtil.nonBlank((String)city) ? new GeoLocationReference(city) : null), partOfName, limit, null));
            }
        }
        if (result.size() < limit) {
            result.addAll(DictHelper.getSabreHotelsFromRemoteServer(hotelId, country, city, chain, partOfName, limit - result.size()));
        }
        return result;
    }

    public static List<Hotel> getSabreHotelsFromRemoteServer(String hotelId) {
        return ((RemoteDictionaryResolver)Environment.getPublished(RemoteDictionaryResolver.class)).getHotel(hotelId);
    }

    public static List<Hotel> getSabreHotelsFromRemoteServer(String hotelId, String country, String city, String chain, String partOfName, int limit) {
        return ((RemoteDictionaryResolver)Environment.getPublished(RemoteDictionaryResolver.class)).getHotel(hotelId, country, city, chain, partOfName, limit);
    }

    public static Set<String> findAirportCodesByCode(String cityOrAirportCode) {
        GeoLocation city;
        HashSet<String> res = new HashSet<String>();
        GeoLocation alreadyIsAnAirport = DictHelper.findAirport(cityOrAirportCode);
        if (alreadyIsAnAirport != null && alreadyIsAnAirport.getCodeVariants().get(CodeSystem.IATA.name()) != null) {
            res.add((String)alreadyIsAnAirport.getCodeVariants().get(CodeSystem.IATA.name()));
        }
        if ((city = DictHelper.findCityByCode(cityOrAirportCode, CodeSystem.IATA)) != null) {
            List<DictionaryReference<GeoLocation>> airports = DictHelper.findAirportsByCity((DictionaryReference<GeoLocation>)city.toReference());
            for (DictionaryReference<GeoLocation> airportRef : airports) {
                GeoLocation airport = (GeoLocation)DictionaryCache.get().resolveReference(airportRef);
                if (airport == null || airport.getCodeVariants().get(CodeSystem.IATA.name()) == null) continue;
                res.add((String)airport.getCodeVariants().get(CodeSystem.IATA.name()));
            }
        }
        return res;
    }

    public static Collection<SpecialServiceRequestDict> getSpecialServiceRequestsByCategory(SpecialServiceRequestCategory category) {
        HashSet<SpecialServiceRequestDict> result = new HashSet<SpecialServiceRequestDict>();
        for (SpecialServiceRequestDict ssrd : DictionaryCache.get().getAll(SpecialServiceRequestDict.class).values()) {
            if (ssrd.getCategory() != category) continue;
            result.add(ssrd);
        }
        return result;
    }

    public static Set<SpecialServiceRequestDict> getSpecialServiceRequestsByAnyCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptySet();
        }
        HashSet<SpecialServiceRequestDict> result = new HashSet<SpecialServiceRequestDict>();
        block0: for (SpecialServiceRequestDict ssrd : DictionaryCache.get().getAll(SpecialServiceRequestDict.class).values()) {
            if (code.equalsIgnoreCase(ssrd.getCode())) {
                result.add(ssrd);
                continue;
            }
            for (Map.Entry entry2 : ssrd.getCodeVariants().entrySet()) {
                String codeVariant = (String)entry2.getValue();
                if (!code.equalsIgnoreCase(codeVariant)) continue;
                result.add(ssrd);
                continue block0;
            }
        }
        return result;
    }

    public static SpecialServiceRequestDict findSpecialServiceRequestByAnyCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        Set<SpecialServiceRequestDict> ssrds = DictHelper.getSpecialServiceRequestsByAnyCode(code);
        if (ssrds.isEmpty()) {
            return null;
        }
        return ssrds.iterator().next();
    }

    public static String getValueByLocale(Map<Locale, String> map, Locale locale) {
        if (map.isEmpty()) {
            return null;
        }
        String value = map.get(LocaleUtil.createNormalizedLocale((Locale)locale));
        if (TextUtil.isBlank((String)value)) {
            value = map.get(Locale.ROOT);
        }
        if (TextUtil.isBlank((String)value)) {
            value = map.values().iterator().next();
        }
        return value;
    }

    public static Set<Class<? extends BaseDictionary>> getRemoteDictionaries() {
        return remoteDictionaries;
    }

    public static <D extends BaseDictionary> D getPredifinedValue(DictPredifinedValueProvider<D> valueProvider) {
        if (valueProvider == null) {
            return null;
        }
        return (D)DictionaryCache.get().findByCode(valueProvider.getDictClass(), valueProvider.name());
    }

    public static <D extends BaseDictionary, E extends Enum<E>> E getEnumPredifinedValue(DictionaryReference<D> dictRef, E[] enumValues) {
        if (dictRef == null || TextUtil.isBlank((String)dictRef.getCode())) {
            return null;
        }
        for (E ev : enumValues) {
            if (!((Enum)ev).name().equals(dictRef.getCode())) continue;
            return ev;
        }
        return null;
    }

    public static DictionaryReference<PassengerTypeCategory> findPrimaryCategory(DictionaryReference<PassengerType> passengerTypeRef) {
        PassengerType pt = (PassengerType)DictionaryCache.get().resolveReference(passengerTypeRef);
        if (null == pt) {
            return null;
        }
        for (DictionaryReference passengerTypeCategoryRef : pt.getCategories()) {
            if (DictHelper.getPassengerTypeCategoryValue((DictionaryReference<PassengerTypeCategory>)passengerTypeCategoryRef) == null) continue;
            return passengerTypeCategoryRef;
        }
        return null;
    }

    public static PassengerTypeCategoryValue findPrimaryCategoryValue(DictionaryReference<PassengerType> passengerTypeRef) {
        DictionaryReference<PassengerTypeCategory> ptc = DictHelper.findPrimaryCategory(passengerTypeRef);
        return ptc == null ? null : DictHelper.getPassengerTypeCategoryValue(ptc);
    }

    public static PassengerTypeValue getPassengerTypeValue(DictionaryReference<PassengerType> dictRef) {
        return (PassengerTypeValue)DictHelper.getEnumPredifinedValue(dictRef, (Enum[])PassengerTypeValue.values());
    }

    public static PassengerTypeCategoryValue getPassengerTypeCategoryValue(DictionaryReference<PassengerTypeCategory> dictRef) {
        return (PassengerTypeCategoryValue)DictHelper.getEnumPredifinedValue(dictRef, (Enum[])PassengerTypeCategoryValue.values());
    }

    @SafeVarargs
    public static <D extends BaseDictionary> boolean isEqualsPredifinedValue(DictionaryReference<D> dictRef, DictPredifinedValueProvider<D> ... valueProviders) {
        if (dictRef == null) {
            return false;
        }
        for (DictPredifinedValueProvider<D> pv : valueProviders) {
            if (!pv.name().equals(dictRef.getCode())) continue;
            return true;
        }
        return false;
    }

    public static DictionaryReference<PassengerType> getAdultPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.ADULT);
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getPromoPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.PROMO);
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getChildPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.CHILD);
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getYouthPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.YOUTH);
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getSeniorPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.SENIOR);
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getChildPassengerType(int age) {
        if (age < 2) {
            throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)"CHILD_NEEDS_AT_LEAST_TWO_YEARS", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.valueOf((String)String.format("CHILD_%02d", age)));
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getInfantPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.INFANT);
        return pt != null ? pt.toReference() : null;
    }

    public static DictionaryReference<PassengerType> getInfantWithSeatPassengerType() {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue(PassengerTypeValue.INFANT_WITH_SITE);
        return pt != null ? pt.toReference() : null;
    }

    public static boolean isAdultPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.ADULT});
    }

    public static boolean isChildPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD});
    }

    public static boolean isChildrenPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_02}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_03}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_04}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_05}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_06}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_07}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_08}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_09}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_10}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_11}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_12}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_13}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.CHILD_UNACCOMPANIED}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.FAMILY_CHILD});
    }

    public static boolean isInfantsPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT_WITH_SITE}) || DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.FAMILY_INFANT});
    }

    public static boolean isInfantPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT});
    }

    public static boolean isYouthPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.YOUTH});
    }

    public static boolean isSeniorPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.SENIOR});
    }

    public static boolean isPromoPassengerType(DictionaryReference<PassengerType> passengerType) {
        return DictHelper.isEqualsPredifinedValue(passengerType, new DictPredifinedValueProvider[]{PassengerTypeValue.PROMO});
    }

    public static DictionaryReference<PassengerType> getPassengerTypeByCodeVariant(String codeVariant, CodeSystem codeSystem) {
        Set passengerTypes = DictionaryCache.get().lookup(PassengerType.class, codeVariant, new String[]{codeSystem.name()});
        return passengerTypes.isEmpty() ? null : ((PassengerType)passengerTypes.iterator().next()).toReference();
    }

    public static DictionaryReference<PassengerType> getPassengerTypeByIATA(String passType) {
        Set set;
        String code = passType;
        if (passType != null && passType.matches("[cC][\\d]{2}")) {
            code = "CNN";
        }
        return (set = DictionaryCache.get().lookup(PassengerType.class, code, new String[]{CodeSystem.IATA.name()})).isEmpty() ? null : ((PassengerType)set.iterator().next()).toReference();
    }

    public static String getPassengerTypeIATA(DictionaryReference<PassengerType> passengerType) {
        PassengerType pt = (PassengerType)DictionaryCache.get().resolveReference(passengerType);
        return pt == null ? null : (String)pt.getCodeVariants().get(CodeSystem.IATA.name());
    }

    public static DictionaryReference<PassengerTypeCategory> getAdultPassengerCategory() {
        PassengerTypeCategory ptc = (PassengerTypeCategory)DictHelper.getPredifinedValue(PassengerTypeCategoryValue.ADULT);
        return ptc != null ? ptc.toReference() : null;
    }

    public static DictionaryReference<PassengerTypeCategory> getChildPassengerCategory() {
        PassengerTypeCategory ptc = (PassengerTypeCategory)DictHelper.getPredifinedValue(PassengerTypeCategoryValue.CHILD);
        return ptc != null ? ptc.toReference() : null;
    }

    public static DictionaryReference<PassengerTypeCategory> getInfantPassengerCategory() {
        PassengerTypeCategory ptc = (PassengerTypeCategory)DictHelper.getPredifinedValue(PassengerTypeCategoryValue.INFANT);
        return ptc != null ? ptc.toReference() : null;
    }

    public static List<DictionaryReference<PassengerType>> getAllChildTypes() {
        return Arrays.asList(DictHelper.getChildPassengerType(), DictHelper.getChildPassengerType(2), DictHelper.getChildPassengerType(3), DictHelper.getChildPassengerType(4), DictHelper.getChildPassengerType(5), DictHelper.getChildPassengerType(6), DictHelper.getChildPassengerType(7), DictHelper.getChildPassengerType(8), DictHelper.getChildPassengerType(9), DictHelper.getChildPassengerType(10), DictHelper.getChildPassengerType(11), DictHelper.getChildPassengerType(12), DictHelper.getChildPassengerType(13));
    }

    public static boolean isAdultPassengerCategory(DictionaryReference<PassengerTypeCategory> passengerCategory) {
        return DictHelper.isEqualsPredifinedValue(passengerCategory, new DictPredifinedValueProvider[]{PassengerTypeCategoryValue.ADULT});
    }

    public static boolean isChildPassengerCategory(DictionaryReference<PassengerTypeCategory> passengerCategory) {
        return DictHelper.isEqualsPredifinedValue(passengerCategory, new DictPredifinedValueProvider[]{PassengerTypeCategoryValue.CHILD});
    }

    public static boolean isInfantPassengerCategory(DictionaryReference<PassengerTypeCategory> passengerCategory) {
        return DictHelper.isEqualsPredifinedValue(passengerCategory, new DictPredifinedValueProvider[]{PassengerTypeCategoryValue.INFANT});
    }

    public static boolean isAdultPassengerTypeCategory(DictionaryReference<PassengerType> passengerType) {
        DictionaryReference<PassengerTypeCategory> passengerCategory = DictHelper.findPrimaryCategory(passengerType);
        return DictHelper.isAdultPassengerCategory(passengerCategory);
    }

    public static boolean isChildPassengerTypeCategory(DictionaryReference<PassengerType> passengerType) {
        DictionaryReference<PassengerTypeCategory> passengerCategory = DictHelper.findPrimaryCategory(passengerType);
        return DictHelper.isChildPassengerCategory(passengerCategory);
    }

    public static boolean isInfantPassengerTypeCategory(DictionaryReference<PassengerType> passengerType) {
        DictionaryReference<PassengerTypeCategory> passengerCategory = DictHelper.findPrimaryCategory(passengerType);
        return DictHelper.isInfantPassengerCategory(passengerCategory);
    }

    public static List<DictionaryReference<PassengerType>> getAllPassengerTypes() {
        return Arrays.stream(PassengerTypeValue.values()).map(DictHelper::getPredifinedValue).filter(Objects::nonNull).map(PassengerType::toReference).collect(Collectors.toList());
    }

    public static DictionaryReference<BlankType> getBlankType(EntityReference<Organization> blankOwner, String name, ProductCategory productCategory, BlankCategory blankCategory) {
        Collection<DictionaryReference<BlankType>> blankTypes = DictHelper.getBlankTypes(blankOwner, name, productCategory, blankCategory);
        return blankTypes.size() > 0 ? blankTypes.iterator().next() : null;
    }

    public static Collection<DictionaryReference<BlankType>> getBlankTypes(EntityReference<Organization> blankOwner, String name, ProductCategory productCategory, BlankCategory blankCategory) {
        ArrayList<DictionaryReference<BlankType>> blankTypes = new ArrayList<DictionaryReference<BlankType>>();
        for (BlankType blankType : DictionaryCache.get().getAll(BlankType.class).values()) {
            if (blankOwner != null && !MiscUtil.equals((Object)blankType.getBlankOwner(), blankOwner) || name != null && !MiscUtil.equals((Object)blankType.getName(), (Object)name) || productCategory != null && !MiscUtil.equals((Object)blankType.getProductCategory(), (Object)productCategory) || blankCategory != null && !MiscUtil.equals((Object)blankType.getBlankCategory(), (Object)blankCategory)) continue;
            blankTypes.add((DictionaryReference<BlankType>)blankType.toReference());
        }
        return blankTypes;
    }

    public static <D extends BaseDictionary> DictionaryReference<D> toReference(D d) {
        if (d == null) {
            return null;
        }
        return d.toReference();
    }

    public static LuggageUnit findLuggageUnitBySpellVariant(String spellVariant) {
        for (LuggageUnit lu : DictionaryCache.get().getAll(LuggageUnit.class).values()) {
            for (String sv : lu.getSpellVariants()) {
                if (!spellVariant.equalsIgnoreCase(sv)) continue;
                return lu;
            }
        }
        return null;
    }

    public static boolean isNil(LuggageUnit luggageUnit) {
        return LUGGAGE_UNIT_NIL.equals(luggageUnit.getCode());
    }

    public static LuggageUnit getNilLuggageUnit() {
        return (LuggageUnit)DictionaryCache.get().findByCode(LuggageUnit.class, LUGGAGE_UNIT_NIL);
    }

    public static LuggageUnit getKgLuggageUnit() {
        return (LuggageUnit)DictionaryCache.get().findByCode(LuggageUnit.class, LUGGAGE_UNIT_KG);
    }

    public static LuggageUnit getLbLuggageUnit() {
        return (LuggageUnit)DictionaryCache.get().findByCode(LuggageUnit.class, LUGGAGE_UNIT_LB);
    }

    public static LuggageUnit getPcLuggageUnit() {
        return (LuggageUnit)DictionaryCache.get().findByCode(LuggageUnit.class, LUGGAGE_UNIT_PC);
    }

    public static boolean isDomesticCountry(DictionaryReference<Country> countryRef) {
        Country country = countryRef != null ? (Country)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(countryRef) : null;
        return country != null && country.isDomestic();
    }

    public static Integer getGeoDistanceInMiles(DictionaryReference<GeoLocation> geoLocRef1, DictionaryReference<GeoLocation> geoLocRef2) {
        GeoLocation geoLoc1 = (GeoLocation)DictionaryCache.get().resolveReference(geoLocRef1);
        if (geoLoc1 == null) {
            return null;
        }
        if (geoLoc1.getLatitude() == 0.0 || geoLoc1.getLongitude() == 0.0) {
            return null;
        }
        GeoLocation geoLoc2 = (GeoLocation)DictionaryCache.get().resolveReference(geoLocRef2);
        if (geoLoc2 == null) {
            return null;
        }
        if (geoLoc2.getLatitude() == 0.0 || geoLoc2.getLongitude() == 0.0) {
            return null;
        }
        return (int)GeoDistanceUtil.distance((double)geoLoc1.getLatitude(), (double)geoLoc1.getLongitude(), (double)geoLoc2.getLatitude(), (double)geoLoc2.getLongitude(), (char)'M');
    }

    public static String codeOf(DictionaryReference<Country> countryRef) {
        return countryRef == null ? null : countryRef.getCode();
    }

    public static ZoneId getZoneId(DictionaryReference<GeoLocation> geoRef) {
        if (geoRef == null) {
            return null;
        }
        HashSet<DictionaryReference> seen = new HashSet<DictionaryReference>();
        DictionaryReference curRef = geoRef;
        String code = geoRef.getCode();
        while (curRef != null && !seen.contains(curRef)) {
            seen.add(curRef);
            GeoLocation geo = (GeoLocation)DictionaryCache.get().resolveReference(curRef);
            if (geo == null) {
                log.error("no geolocation for " + DictHelper.getCode(curRef));
                break;
            }
            code = geo.getCode();
            String timeZoneId = geo.getTimeZoneId();
            if (!StringUtils.isBlank((String)timeZoneId)) {
                return ZoneId.of(timeZoneId);
            }
            if (geo.getType() == LocationType.CITY) break;
            curRef = geo.getParent();
        }
        IncidentsLog.reportAdminStackTrace((String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 \u0434\u043b\u044f \u0433\u0435\u043e\u043b\u043e\u043a\u0430\u0446\u0438\u0438 \u0441 \u043a\u043e\u0434\u043e\u043c " + code));
        return null;
    }

    public static ZonedDateTime getZonedDateTime(Date date, DictionaryReference<GeoLocation> geo, boolean isNullResponcePossible) {
        ZonedDateTime zonedDateTime = DictHelper.getZonedDateTime(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), geo);
        if (!isNullResponcePossible && zonedDateTime == null) {
            throw Xeption.forDeveloper((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 \u0434\u043b\u044f {0}", (Object[])new Object[]{geo.getCode()});
        }
        return zonedDateTime;
    }

    public static ZonedDateTime getZonedDateTime(LocalDateTime dateTime, DictionaryReference<GeoLocation> geo) {
        ZoneId zoneId = DictHelper.getZoneId(geo);
        if (zoneId == null) {
            return null;
        }
        return ZonedDateTime.of(dateTime, zoneId);
    }

    public static <D extends BaseDictionary> String getCode(D d) {
        return d == null ? null : d.getCode();
    }

    public static <D extends BaseDictionary> String getCode(DictionaryReference<D> reference) {
        return reference == null ? null : reference.getCode();
    }

    public static CountryReference getRuRef() {
        return ruRef;
    }

    public static CountryReference getByRef() {
        return byRef;
    }

    public static CountryReference getKzRef() {
        return kzRef;
    }

    public static CountryReference getUaRef() {
        return uaRef;
    }

    public static CountryReference getUzRef() {
        return uzRef;
    }

    public static CountryReference getMdRef() {
        return mdRef;
    }

    public static CountryReference getTjRef() {
        return tjRef;
    }

    public static AircraftSeatInfo findAircraftSeatInfo(String gdsSeatCharacteristic, GdsName gdsName) {
        Set searchResults = DictionaryCache.get().search(AircraftSeatInfo.class, DictSearchCriterion.eq((String)AircraftSeatInfo.Property.seatCharacteristicName.name(), (Object)gdsSeatCharacteristic));
        if (searchResults.size() == 1) {
            AircraftSeatInfo info2 = (AircraftSeatInfo)searchResults.iterator().next();
            return info2.getGds() == gdsName ? info2 : null;
        }
        return searchResults.stream().filter(info -> info.getGds() == gdsName).findFirst().orElse(null);
    }

    public static AircraftSeatInfo getNonNullAircraftSeatInfo(String gdsSeatCharacteristic, GdsName gdsName) {
        AircraftSeatInfo seatInfo = DictHelper.findAircraftSeatInfo(gdsSeatCharacteristic, gdsName);
        if (seatInfo != null) {
            return seatInfo;
        }
        seatInfo = new AircraftSeatInfo();
        seatInfo.setCode(gdsSeatCharacteristic);
        return seatInfo;
    }

    public static List<DictionaryReference<AircraftSeatInfo>> getSeatCharacteristicsWithUniqueTranslation(Collection<String> characteristics, GdsName gdsName) {
        ArrayList<DictionaryReference<AircraftSeatInfo>> seatCharacteristics = new ArrayList<DictionaryReference<AircraftSeatInfo>>();
        HashSet<String> translations = new HashSet<String>();
        for (String prop : characteristics) {
            AircraftSeatInfo seatInfo = DictHelper.getNonNullAircraftSeatInfo(prop, gdsName);
            String translation = DictHelper.getTranslation((BaseDictionary)seatInfo, LocaleHelper.getCurrentLocale(), false);
            if (translation != null && translations.contains(translation)) continue;
            translations.add(translation);
            seatCharacteristics.add((DictionaryReference<AircraftSeatInfo>)seatInfo.toReference());
        }
        return seatCharacteristics;
    }

    public static List<ValidationMessageDict> findValidationMessagesByErrorCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<ValidationMessageDict> result = new ArrayList<ValidationMessageDict>();
        for (ValidationMessageDict messageDict : DictionaryCache.get().getAll(ValidationMessageDict.class).values()) {
            if (messageDict == null || !code.equalsIgnoreCase(messageDict.getErrorCode())) continue;
            result.add(messageDict);
        }
        return result;
    }

    public static TrainType findTrainType(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        return DictionaryCache.get().getAll(TrainType.class).values().stream().filter(tt -> TextUtil.equals((String)tt.getCode(), (String)code, (boolean)false)).findFirst().orElse(null);
    }

    public static TrainName findTrainName(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        return DictionaryCache.get().getAll(TrainName.class).values().stream().filter(tn -> TextUtil.isSame((String)tn.getCode(), (String)code, (boolean)true, (boolean)true)).findFirst().orElse(null);
    }

    public static ProfileGroup findProfileGroupByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        DictionaryCache cache = DictionaryCache.get();
        for (ProfileGroup profileGroup : cache.getAll(ProfileGroup.class).values()) {
            for (Locale locale : profileGroup.getTranslations().keySet()) {
                if (!name.equalsIgnoreCase((String)profileGroup.getTranslations().get(locale))) continue;
                return profileGroup;
            }
        }
        return null;
    }

    public static boolean isWithinSameCity(DictionaryReference<GeoLocation> loc1Ref, DictionaryReference<GeoLocation> loc2Ref) {
        if (loc1Ref.equals(loc2Ref)) {
            return true;
        }
        return DictHelper.getCity(loc1Ref).equals(DictHelper.getCity(loc2Ref));
    }

    static {
        remoteDictionaries.add(Hotel.class);
        remoteDictionaries.add(HotelRating.class);
        remoteDictionaries.add(HotelStar.class);
        remoteDictionaries.add(HotelType.class);
        remoteDictionaries.add(HotelCCType.class);
        remoteDictionaries.add(RelatedLocation.class);
        remoteDictionaries.add(RelatedLocationSubType.class);
        remoteDictionaries.add(RelatedLocationType.class);
        CODE_SYSTEMS_IATA_CRT = new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()};
        percent = new CurrencyInfo();
        percent.setCode("%");
        percent.getTranslations().put(Locale.ENGLISH, "%");
        defaultCardCodes = new HashMap<CardVendor, String>();
        defaultCardCodes.put(CardVendor.VISA, "VI");
        defaultCardCodes.put(CardVendor.MASTERCARD, "CA");
        defaultCardCodes.put(CardVendor.AMEX, "AX");
        defaultCardCodes.put(CardVendor.DINERS_CLUB, "DC");
        defaultCardCodes.put(CardVendor.JCB, "JB");
        defaultCardCodes.put(CardVendor.AIR_TRAVEL_CARD, "TP");
        defaultCardCodes.put(CardVendor.MIR, "MR");
        sabreCardCodes = new HashMap<CardVendor, String>();
        sabreCardCodes.put(CardVendor.VISA, "VI");
        sabreCardCodes.put(CardVendor.MASTERCARD, "CA");
        sabreCardCodes.put(CardVendor.AMEX, "AX");
        sabreCardCodes.put(CardVendor.DINERS_CLUB, "DC");
        sabreCardCodes.put(CardVendor.JCB, "JC");
        sabreCardCodes.put(CardVendor.AIR_TRAVEL_CARD, "TP");
        sabreCardCodes.put(CardVendor.MIR, "MR");
    }
}

