/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BasePenalty;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommissionPropertiesType;
import com.gridnine.xtrip.common.model.booking.ContractRelationAdditionalServicesDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationContractData;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.ContractRelationPenaltiesDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.Penalty;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatCalculationData;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.VendorAdditionalService;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescriptionIndex;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescriptionIndex;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.profile.SalesChainDescriptionIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.vat.VatRulesHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.system.model.PaymentCode;
import com.gridnine.xtrip.common.system.model.PaymentCodeSettings;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GeneralProductHelper {
    public static String HOTEL_PRODUCT_FEE_PROPERTY_UID = "hotel-product-fee-property-uid";
    public static final String CONTRACT_RELATIONS_PROPERTY_NAME = "contractRelations";
    public static final Set<ValidationMessageSeverity> errorSeverities = Collections.unmodifiableSet(EnumSet.of(ValidationMessageSeverity.ERROR, ValidationMessageSeverity.USER_ERROR, ValidationMessageSeverity.SOURCE_DATA_ERROR));
    public static final Set<Class<? extends BaseCommissionProperties>> commissionPropertyTypes = Collections.singleton(CommissionProperties.class);
    public static final Set<Class<? extends BaseCommissionProperties>> commissionCommissionPropertyTypes = Collections.singleton(CommissionProperties.class);
    public static final Set<Class<? extends BaseCommissionProperties>> feePropertyTypes = Collections.unmodifiableSet(Stream.of(FeeProperties.class, PaymentFeeProperties.class).collect(Collectors.toSet()));
    public static final Set<Class<? extends BaseCommissionProperties>> serviceFeePropertyTypes = Collections.singleton(FeeProperties.class);
    public static final Set<Class<? extends BaseCommissionProperties>> paymentFeePropertyTypes = Collections.singleton(PaymentFeeProperties.class);
    public static final Set<Class<? extends BaseCommissionProperties>> discountPropertyTypes = Collections.singleton(DiscountProperties.class);
    public static final Set<Class<? extends BaseCommissionProperties>> discountDiscountPropertyTypes = Collections.singleton(DiscountProperties.class);
    public static final Set<CommissionType> standardCommissionTypes = Collections.singleton(CommissionType.STANDARD);
    public static final Set<CommissionType> subagentCommissionTypes = Collections.singleton(CommissionType.SUBAGENT);
    public static final Set<CommissionType> bspCommissionTypes = Collections.singleton(CommissionType.BSP);
    public static final Set<CommissionType> bonusCommissionTypes = Collections.singleton(CommissionType.BONUS);
    public static final Set<CommissionType> nonBspCommissionTypes = Collections.unmodifiableSet(Stream.of(CommissionType.STANDARD, CommissionType.SUBAGENT, CommissionType.BONUS).collect(Collectors.toSet()));
    public static final Set<CommissionCategory> standardCommissionCategories = Collections.singleton(CommissionCategory.STANDARD);
    public static final Set<CommissionCategory> hiddenCommissionCategories = Collections.singleton(CommissionCategory.HIDDEN);
    public static final Set<FopType> productFopTypes = Collections.singleton(FopType.PRODUCT);
    public static final Set<FopType> feeFopTypes = Collections.unmodifiableSet(EnumSet.of(FopType.SERVICE, FopType.PAYMENT));
    public static final Set<FopType> serviceFeeFopTypes = Collections.singleton(FopType.SERVICE);
    public static final Set<FopType> paymentFeeFopTypes = Collections.singleton(FopType.PAYMENT);
    public static final Set<FopType> discountFopTypes = Collections.singleton(FopType.DISCOUNT);
    public static final Set<ContractType> vendorContractTypes = Collections.singleton(ContractType.VENDOR);
    public static final Set<ContractType> subagencyContractTypes = Collections.singleton(ContractType.SUBAGENCY);
    public static final Set<ContractType> clientContractTypes = Collections.singleton(ContractType.CLIENT);
    public static final Map<String, String[]> taxesBlank = new HashMap<String, String[]>(){
        private static final long serialVersionUID = -4919553586969741816L;
        {
            this.put("SU", new String[]{"RU", "\u0420\u0423"});
            this.put("S7", new String[]{"RU", "\u0420\u0423"});
            this.put("UN", new String[]{"RU"});
            this.put("\u04281", new String[]{"ZZ"});
            this.put(null, new String[]{"RU", "\u0420\u0423", "ZZ"});
        }
    };
    private static final Map<Class<?>, Boolean> HAS_OLD_FIELDS = new ConcurrentHashMap();
    public static final boolean DELIVERY_DISABLED = "true".equals(System.getProperty("midoffice.delivery-disabled"));

    public static DictionaryReference<CurrencyInfo> getCurrency(BaseContractRelationData relation) {
        if (relation == null) {
            return null;
        }
        DictionaryReference currency = relation.getGeneralData().getCurrency();
        if (currency == null) {
            currency = new CurrencyInfoReference(DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB"));
        }
        return currency;
    }

    public static <T extends BaseCommission> boolean isClientCommissionTranslatedFromAgency(T clientCommission, DictionaryReference<CurrencyInfo> clientCurrency, T agencyCommission, DictionaryReference<CurrencyInfo> agencyCurrency) {
        if (clientCommission.getEquivalentAmount() == null || clientCommission.getCommissionProperties() == null || agencyCommission.getEquivalentAmount() == null || agencyCommission.getCommissionProperties() == null) {
            return false;
        }
        if (!agencyCommission.getCommissionProperties().equals((Object)clientCommission.getCommissionProperties())) {
            return false;
        }
        BigDecimal clientEquivAmount = clientCommission.getEquivalentAmount();
        if (clientCommission.getVatRate() != null) {
            VatAmount vatAmount = VatAmount.of((BigDecimal)clientEquivAmount, (double)clientCommission.getVatRate());
            clientEquivAmount = MiscUtil.sub((BigDecimal)clientEquivAmount, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
        }
        BigDecimal agencyEquivAmount = agencyCommission.getEquivalentAmount();
        if (agencyCommission.getVatRate() != null) {
            VatAmount vatAmount = VatAmount.of((BigDecimal)agencyEquivAmount, (double)agencyCommission.getVatRate());
            agencyEquivAmount = MiscUtil.sub((BigDecimal)agencyEquivAmount, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
        }
        if (MiscUtil.equals(clientCurrency, agencyCurrency)) {
            return MiscUtil.isSame((BigDecimal[])new BigDecimal[]{clientEquivAmount, agencyEquivAmount});
        }
        Money clientAmount = clientCommission.getAmount();
        if (clientAmount != null && agencyCurrency != null && MiscUtil.equals((Object)clientAmount.getCurrency(), (Object)agencyCurrency.getCode())) {
            BigDecimal clientAmountValue = clientAmount.getValue();
            if (clientCommission.getVatRate() != null) {
                VatAmount vatAmount = VatAmount.of((BigDecimal)clientAmountValue, (double)clientCommission.getVatRate());
                clientAmountValue = MiscUtil.sub((BigDecimal)clientAmountValue, (BigDecimal[])new BigDecimal[]{vatAmount.getVatAmount()});
            }
            return MiscUtil.isSame((BigDecimal[])new BigDecimal[]{clientAmountValue, agencyEquivAmount});
        }
        return false;
    }

    public static <T extends BaseCommission> List<T> retainCommissions(List<T> originalCommissions, DictionaryReference<CurrencyInfo> originalCurrency, List<T> commissionsToSubtract, DictionaryReference<CurrencyInfo> substractCurrency) {
        ArrayList<BaseCommission> result = new ArrayList<BaseCommission>();
        block0: for (BaseCommission clientCommission : originalCommissions) {
            if (clientCommission.getCommissionProperties() == null || clientCommission.getEquivalentAmount() == null) continue;
            for (BaseCommission agencyCommission : commissionsToSubtract) {
                if (!GeneralProductHelper.isClientCommissionTranslatedFromAgency(clientCommission, originalCurrency, agencyCommission, substractCurrency)) continue;
                continue block0;
            }
            result.add(clientCommission);
        }
        return result;
    }

    public static Collection<ValidationMessage> filterValidationMessages(Collection<ValidationMessage> messages, Set<ValidationMessageCategory> categories, Set<ValidationMessageSeverity> severities) {
        return GeneralProductHelper.filterValidationByCategories(GeneralProductHelper.filterValidationBySeverity(messages, severities), categories);
    }

    private static Collection<ValidationMessage> filterValidationByCategories(Collection<ValidationMessage> messages, Set<ValidationMessageCategory> categories) {
        if (messages == null) {
            return Collections.emptyList();
        }
        if (categories == null) {
            return new ArrayList<ValidationMessage>(messages);
        }
        ArrayList<ValidationMessage> filteredMessages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : messages) {
            if (message.getCategory() == null || !categories.contains(message.getCategory())) continue;
            filteredMessages.add(message);
        }
        return filteredMessages;
    }

    private static Collection<ValidationMessage> filterValidationBySeverity(Collection<ValidationMessage> messages, Set<ValidationMessageSeverity> severities) {
        if (messages == null) {
            return Collections.emptyList();
        }
        if (severities == null) {
            return new ArrayList<ValidationMessage>(messages);
        }
        ArrayList<ValidationMessage> filteredMessages = new ArrayList<ValidationMessage>();
        for (ValidationMessage message : messages) {
            if (message.getSeverity() == null || !severities.contains(message.getSeverity())) continue;
            filteredMessages.add(message);
        }
        return filteredMessages;
    }

    public static Double findCommissionRate(Collection<GeneralProductCommission> coll, ContractType ctype, Class<? extends BaseCommissionProperties> cls, boolean bonus) throws Exception {
        for (GeneralProductCommission cm : coll) {
            if (cm.getRate() == null || !GeneralProductHelper.isAppropriated(cm, ctype, cls, bonus)) continue;
            return cm.getRate();
        }
        return null;
    }

    private static boolean isAppropriated(GeneralProductCommission cm, ContractType ctype, Class<? extends BaseCommissionProperties> cls, boolean bonus) {
        if (ctype != cm.getContractType()) {
            return false;
        }
        if (cls != null) {
            if (cm.getCommissionProperties() == null && !CommissionProperties.class.equals(cls)) {
                return false;
            }
            if (cm.getCommissionProperties() != null && !cls.equals(cm.getCommissionProperties().getType())) {
                return false;
            }
        }
        EntityContainer prop = EntityStorage.get().resolve(cm.getCommissionProperties());
        if (bonus) {
            if (prop == null || !(prop.getEntity() instanceof CommissionProperties)) {
                return false;
            }
            CommissionProperties cprop = (CommissionProperties)prop.getEntity();
            if (!cprop.isBonus()) {
                return false;
            }
        }
        return true;
    }

    public static BigDecimal getCommissionValue(Collection<GeneralProductCommission> coll, ContractType ctype, Class<? extends BaseCommissionProperties> cls, boolean bonus) throws Exception {
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductCommission cm : coll) {
            if (cm.getEquivalentAmount() == null || BigDecimal.ZERO.compareTo(cm.getEquivalentAmount()) == 0 || !GeneralProductHelper.isAppropriated(cm, ctype, cls, bonus)) continue;
            result = result.add(cm.getEquivalentAmount());
        }
        return result;
    }

    public static BigDecimal getEquivalentTaxAmount(Collection<GeneralProductTax> taxes) {
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductTax tax : taxes) {
            if (tax.getEquivalentAmount() == null) continue;
            result = result.add(tax.getEquivalentAmount());
        }
        return result;
    }

    public static BigDecimal getEquivalentTaxAmount(Collection<GeneralProductTax> taxes, boolean include, String ... codes) {
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductTax tax : taxes) {
            if (tax.getEquivalentAmount() == null) continue;
            boolean found = false;
            for (String taxCode : codes) {
                if (!taxCode.equalsIgnoreCase(tax.getCode())) continue;
                found = true;
                break;
            }
            if (include != found) continue;
            result = result.add(tax.getEquivalentAmount());
        }
        return result;
    }

    public static String getNonNullString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            String val = (String)value;
            if (TextUtil.isBlank((String)val)) {
                return "";
            }
            return val.trim();
        }
        return value.toString();
    }

    public static Fop findFop(FopProduct product) {
        Fop result = GeneralProductHelper.findFop(product.getClientFops());
        if (result == null) {
            result = GeneralProductHelper.findFop(product.getSubagentFops());
        }
        if (result == null) {
            result = GeneralProductHelper.findFop(product.getVendorFops());
        }
        return result;
    }

    public static Fop findFop(List<? extends GeneralProductFop> fops) {
        for (GeneralProductFop generalProductFop : fops) {
            if (generalProductFop.getType() == null || !GeneralProductHelper.isServiceFop(generalProductFop)) continue;
            return generalProductFop;
        }
        return null;
    }

    public static Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<FinanceCapableProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        boolean hasFees = false;
        boolean hasRefundFees = false;
        PaymentType ptype = null;
        boolean isRefund = false;
        block0: for (FinanceCapableProduct prod : products) {
            if (prod.getStatus() == ProductStatus.REFUND) {
                isRefund = true;
            }
            if (ptype == null) {
                if (!prod.getClientFops().isEmpty()) {
                    for (GeneralProductFop generalProductFop : prod.getClientFops()) {
                        if (generalProductFop.getType() == null || !GeneralProductHelper.isServiceFop(generalProductFop)) continue;
                        ptype = generalProductFop.getType();
                        break;
                    }
                } else {
                    for (GeneralProductFop generalProductFop : prod.getVendorFops()) {
                        if (generalProductFop.getType() == null) continue;
                        ptype = generalProductFop.getType();
                        break;
                    }
                }
            }
            if (hasFees && hasRefundFees) continue;
            for (GeneralProductCommission generalProductCommission : GeneralProductHelper.filterCommissions(prod.getCommissions(), feePropertyTypes, null, standardCommissionCategories)) {
                hasFees = true;
                if (!BookingHelper.isFeeForRefund((EntityReference<? extends BaseCommissionProperties>)generalProductCommission.getCommissionProperties())) continue;
                hasRefundFees = true;
                continue block0;
            }
        }
        if (ptype == null) {
            block4: for (FinanceCapableProduct prod : products) {
                for (GeneralProductFop generalProductFop : prod.getClientFops()) {
                    if (generalProductFop.getType() == null || GeneralProductHelper.isServiceFop(generalProductFop)) continue;
                    ptype = generalProductFop.getType();
                    break block4;
                }
            }
        }
        HashSet<FinanceDocument> documents = new HashSet<FinanceDocument>();
        for (FinanceDocument finDoc : availableDocuments) {
            FinanceDocumentType financeDocumentType = finDoc.getType();
            if (financeDocumentType == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && (!hasFees || isRefund && !hasRefundFees) || financeDocumentType == FinanceDocumentType.CASH_ORDER && (!isRefund || ptype != PaymentType.CASH)) continue;
            documents.add(finDoc);
        }
        return documents;
    }

    public static Collection<BillingItem> getBillingItems(List<FinanceCapableProduct> prods, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        HashMap tickets = new HashMap();
        HashMap penalties = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        ArrayList<BillingItem> billingItems = new ArrayList<BillingItem>();
        for (FinanceCapableProduct product : prods) {
            BigDecimal penalty;
            CommissionData cData;
            EntityContainer ctr;
            String key = GeneralProductHelper.getKey(product);
            FinanceDocumentsHelper.updateMap(tickets, key, product);
            Collection<GeneralProductCommission> commissions = GeneralProductHelper.filterCommissions(product.getCommissions(), null, null, standardCommissionCategories);
            for (GeneralProductCommission comm : commissions) {
                ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (ctr == null) continue;
                if (FeeProperties.class.equals((Object)ctr.getEntityType()) || PaymentFeeProperties.class.equals((Object)ctr.getEntityType())) {
                    cData = new CommissionData(comm, product);
                    FinanceDocumentsHelper.updateMap(fees, GeneralProductHelper.getKey((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
                    continue;
                }
                if (!DiscountProperties.class.getName().equals(ctr.getEntityType().getName())) continue;
                cData = new CommissionData(comm, product);
                FinanceDocumentsHelper.updateMap(discounts, GeneralProductHelper.getKey((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
            }
            if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                for (GeneralProductCommission comm : product.getPreviousProduct().getCommissions()) {
                    ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
                    if (ctr == null) continue;
                    if (ctr.getEntity() instanceof FeeProperties) {
                        FeeProperties prop = (FeeProperties)ctr.getEntity();
                        if (comm.getContractType() != ContractType.CLIENT && !prop.isChargeToClientForAllContractTypes()) continue;
                    }
                    if (!FeeProperties.class.getName().equals(ctr.getEntityType().getName()) || ((FeeProperties)ctr.getEntity()).getOperation() != Operation.EXCHANGE) continue;
                    cData = new CommissionData(comm, product.getPreviousProduct());
                    FinanceDocumentsHelper.updateMap(fees, GeneralProductHelper.getKey((EntityContainer<? extends BaseCommissionProperties>)ctr, cData, noVat), cData);
                }
            }
            if (product.getStatus() != ProductStatus.REFUND && (product.getStatus() != ProductStatus.SELL || product.getPreviousProduct() == null || product.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) || (penalty = product.getPenalty()) == null || BigDecimal.ZERO.compareTo(penalty) == 0) continue;
            FinanceDocumentsHelper.updateMap(penalties, GeneralProductHelper.getKey(penalty), product);
        }
        GeneralProductHelper.updateProductItems(billingItems, tickets.values(), noVat);
        GeneralProductHelper.updateCommissions(billingItems, fees.values(), false, noVat);
        GeneralProductHelper.updateCommissions(billingItems, discounts.values(), true, noVat);
        GeneralProductHelper.updatePenalties(billingItems, penalties.values(), noVat);
        return billingItems;
    }

    private static void updateCommissions(List<BillingItem> billingItems, Collection<List<CommissionData>> values, boolean discount, boolean noVat) {
        for (List<CommissionData> lst : values) {
            FeeProperties prop;
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (CommissionData data : lst) {
                item.getProductUids().add(data.product.getProductUid());
            }
            item.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            item.setCommissionType(lst.get((int)0).commission.getCommissionProperties());
            EntityContainer ctr = EntityStorage.get().resolve(lst.get((int)0).commission.getCommissionProperties());
            BigDecimal coef = BigDecimal.ONE;
            if (ctr.getEntityType().getName().equals(FeeProperties.class.getName())) {
                prop = (FeeProperties)ctr.getEntity();
                item.setName(prop.getFinanceName());
                if (lst.get((int)0).product.getStatus() == ProductStatus.EXCHANGE && prop.getOperation() == Operation.EXCHANGE) {
                    coef = coef.negate();
                }
            } else if (ctr.getEntityType().equals(PaymentFeeProperties.class)) {
                prop = (PaymentFeeProperties)ctr.getEntity();
                item.setName(prop.getFinanceName());
            } else {
                item.setName(((DiscountProperties)ctr.getEntity()).getFinanceName());
            }
            if (lst.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coef = coef.negate();
            }
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<FinanceCapableProduct> products = new ArrayList<FinanceCapableProduct>();
            for (CommissionData cdata : lst) {
                BigDecimal ec = cdata.commission.getEquivalentAmount();
                if (ec != null) {
                    BigDecimal bigDecimal = total = discount ? total.subtract(ec) : total.add(ec);
                }
                if (cdata.product == null || products.contains(cdata.product)) continue;
                products.add(cdata.product);
            }
            if (!TextUtil.isBlank((String)item.getName())) {
                item.setName(item.getName().replace("${air_tickets_info}", GeneralProductHelper.getGroupInfo(products)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVat(coef.multiply(total), noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(lst.get((int)0).product.getIssueDate())).doubleValue());
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static void updatePenalties(List<BillingItem> billingItems, Collection<List<FinanceCapableProduct>> values, boolean noVat) {
        for (List<FinanceCapableProduct> lst : values) {
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            BigDecimal penalty = BigDecimal.ZERO;
            for (FinanceCapableProduct product : lst) {
                item.getProductUids().add(product.getProductUid());
                if (product.getPenalty() == null) continue;
                penalty = penalty.add(product.getPenalty());
            }
            if (BigDecimal.ZERO.compareTo(penalty) == 0) continue;
            item.setServiceType(ServiceType.PENALTY);
            item.setName(String.format("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 (%s)", GeneralProductHelper.getGroupInfo(lst)));
            VatAmount amount = new VatAmount();
            amount.setTotalVat(penalty, noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static void updateProductItems(List<BillingItem> billingItems, Collection<List<FinanceCapableProduct>> values, boolean noVat) {
        for (List<FinanceCapableProduct> lst : values) {
            if (lst.isEmpty()) continue;
            BillingItem item = new BillingItem();
            for (FinanceCapableProduct product : lst) {
                item.getProductUids().add(product.getProductUid());
            }
            item.setServiceType(ServiceType.TICKET);
            item.setName(lst.get(0).getCommonPart().replace("$group_info", GeneralProductHelper.getGroupInfo(lst)));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (FinanceCapableProduct product : lst) {
                VatAmount price = GeneralProductHelper.calculateProductPrice(product, false);
                total = total.add(price.getTotal());
                vat = vat.add(price.getVatAmount());
            }
            ProductStatus status = lst.get(0).getStatus();
            if (status == ProductStatus.REFUND) {
                total = total.negate();
                vat = vat.negate();
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private static String getGroupInfo(List<FinanceCapableProduct> lst) {
        StringBuilder sb = new StringBuilder();
        for (FinanceCapableProduct product : lst) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String travellerName = product.getTravellerName();
            if (TextUtil.isBlank((String)product.getTravellerName()) && product.getTraveller() != null) {
                travellerName = product.getTraveller().getName();
            }
            if (!TextUtil.isBlank((String)product.getTravellerName())) {
                sb.append(travellerName);
                GeneralProductHelper.appendTicketNumber(sb, product, ": \u2116");
                continue;
            }
            GeneralProductHelper.appendTicketNumber(sb, product, "\u2116");
        }
        return sb.toString();
    }

    private static void appendTicketNumber(StringBuilder sb, FinanceCapableProduct product, String prefix) {
        if (product.getStatus() != ProductStatus.BOOKING && !TextUtil.isBlank((String)product.getTicketNumber())) {
            sb.append(prefix).append(product.getTicketNumber());
        }
    }

    private static String getKey(FinanceCapableProduct product) {
        VatAmount price = GeneralProductHelper.calculateProductPrice(product, false);
        return String.format("%s_%s_%s", product.getCommonPart(), price.getTotal().doubleValue(), price.getVatAmount().doubleValue());
    }

    private static String getKey(BigDecimal value) {
        return value == null ? "???" : Double.toString(value.doubleValue());
    }

    private static String getKey(EntityContainer<? extends BaseCommissionProperties> ctr, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        return FinanceDocumentsHelper.getDescription(ctr.getUid(), amount);
    }

    public static VatAmount calculateProductPrice(FinanceCapableProduct prod, boolean ignoreExchange) {
        BigDecimal value = BigDecimal.ZERO;
        if (prod.getStatus() == ProductStatus.BOOKING) {
            return prod.calculateProductPrice();
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus())) {
            if (!prod.getClientFops().isEmpty()) {
                for (GeneralProductFop generalProductFop : prod.getClientFops()) {
                    if (generalProductFop.getType() == PaymentType.TICKET || generalProductFop.getType() == PaymentType.PTA || generalProductFop.getEquivalentAmount() == null || !GeneralProductHelper.isServiceFop(generalProductFop)) continue;
                    value = value.add(generalProductFop.getEquivalentAmount());
                }
            } else {
                for (GeneralProductFop generalProductFop : prod.getVendorFops()) {
                    if (generalProductFop.getType() == PaymentType.TICKET || generalProductFop.getType() == PaymentType.PTA || generalProductFop.getEquivalentAmount() == null) continue;
                    value = value.add(generalProductFop.getEquivalentAmount());
                }
            }
            VatAmount result = new VatAmount();
            result.setTotalVat(value, prod.isHasVat() ? MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue() : 0.0);
            if (ignoreExchange) {
                return result;
            }
            if (prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                VatAmount vatAmount = GeneralProductHelper.calculateProductPrice(prod.getPreviousProduct(), true);
                result.setTotalVatAmount(result.getTotal().subtract(vatAmount.getTotal()), result.getVatAmount().subtract(vatAmount.getVatAmount()));
            }
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    public static CardVendor getCreditCardVendor(Collection<GeneralProductFop> fops) {
        for (GeneralProductFop fop : fops) {
            if (fop.getCard() == null || fop.getCard().getVendor() == null) continue;
            return fop.getCard().getVendor();
        }
        return null;
    }

    public static FopType getFopType(GeneralProductFop fop) {
        FopType fopType = null;
        if (GeneralProductHelper.isServiceFop(fop)) {
            fopType = FopType.PRODUCT;
        } else {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (fopType == null && commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && serviceFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.SERVICE;
                }
                if (commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.PAYMENT;
                    break;
                }
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                fopType = FopType.DISCOUNT;
                break;
            }
        }
        return fopType;
    }

    public static <T extends BaseProduct> BigDecimal calculateFee(T product, ContractType contractType) {
        ProductStatus status = GeneralProductHelper.getHandler(product).getStatus(product);
        BigDecimal result = BigDecimal.ZERO;
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return result;
        }
        for (GeneralProductCommission commission : GeneralProductHelper.getUnmodifiableCommissions(product, null)) {
            if (commission.getEquivalentAmount() == null || Math.abs(commission.getEquivalentAmount().doubleValue()) < 0.001) continue;
            if (commission.getCommissionProperties() != null && (FeeProperties.class.equals((Object)commission.getCommissionProperties().getType()) || PaymentFeeProperties.class.equals((Object)commission.getCommissionProperties().getType())) && commission.getContractType() == contractType) {
                result = result.add(commission.getEquivalentAmount());
            }
            if (commission.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)commission.getCommissionProperties().getType()) || commission.getContractType() != contractType) continue;
            result = result.subtract(commission.getEquivalentAmount());
        }
        return ProductStatusHelper.get().negatesPrice(status) ? result.negate() : result;
    }

    public static <T extends BaseCommission> Collection<T> filterCommissions(Collection<T> commissions, Set<Class<? extends BaseCommissionProperties>> properties, Set<CommissionType> commissionTypes, Set<CommissionCategory> commissionCategories) {
        return GeneralProductHelper.filterCommissionsByCommissionProperties(GeneralProductHelper.filterCommissionsByCommissionTypes(GeneralProductHelper.filterCommissionsByCommissionCategories(commissions, commissionCategories), commissionTypes), properties);
    }

    private static <T extends BaseCommission> Collection<T> filterCommissionsByCommissionProperties(Collection<T> commissions, Set<Class<? extends BaseCommissionProperties>> properties) {
        if (commissions == null) {
            return Collections.emptyList();
        }
        if (properties == null) {
            return new ArrayList<T>(commissions);
        }
        ArrayList<BaseCommission> filteredCommissions = new ArrayList<BaseCommission>();
        for (BaseCommission commission : commissions) {
            if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !properties.contains(commission.getCommissionProperties().getType())) continue;
            filteredCommissions.add(commission);
        }
        return filteredCommissions;
    }

    private static <T extends BaseCommission> Collection<T> filterCommissionsByCommissionTypes(Collection<T> commissions, Set<CommissionType> commissionTypes) {
        if (commissions == null) {
            return Collections.emptyList();
        }
        if (commissionTypes == null) {
            return new ArrayList<T>(commissions);
        }
        ArrayList<BaseCommission> filteredCommissions = new ArrayList<BaseCommission>();
        block0: for (BaseCommission commission : commissions) {
            if (commission.getCommissionProperties() == null || !CommissionProperties.class.equals((Object)commission.getCommissionProperties().getType())) continue;
            EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
            for (CommissionType commissionType : commissionTypes) {
                if (commissionType == CommissionType.STANDARD && commissionPropertiesContainer != null && (((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() || ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus() || ((CommissionProperties)commissionPropertiesContainer.getEntity()).isSubagencyCommission()) || commissionType == CommissionType.BSP && (commissionPropertiesContainer == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission() || ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) || commissionType == CommissionType.BONUS && (commissionPropertiesContainer == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isBonus()) || commissionType == CommissionType.SUBAGENT && (commissionPropertiesContainer == null || !((CommissionProperties)commissionPropertiesContainer.getEntity()).isSubagencyCommission())) continue;
                filteredCommissions.add(commission);
                continue block0;
            }
        }
        return filteredCommissions;
    }

    private static <T extends BaseCommission> Collection<T> filterCommissionsByCommissionCategories(Collection<T> commissions, Set<CommissionCategory> commissionCategories) {
        if (commissions == null) {
            return Collections.emptyList();
        }
        if (commissionCategories == null) {
            return new ArrayList<T>(commissions);
        }
        ArrayList<BaseCommission> filteredCommissions = new ArrayList<BaseCommission>();
        block0: for (BaseCommission commission : commissions) {
            if (commission.getCommissionProperties() != null && FeeProperties.class.equals((Object)commission.getCommissionProperties().getType())) {
                EntityContainer commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                for (CommissionCategory commissionCategory : commissionCategories) {
                    if (commissionCategory == CommissionCategory.STANDARD && commissionPropertiesContainer != null && ((FeeProperties)commissionPropertiesContainer.getEntity()).isHidden() || commissionCategory == CommissionCategory.HIDDEN && commissionPropertiesContainer != null && !((FeeProperties)commissionPropertiesContainer.getEntity()).isHidden()) continue;
                    filteredCommissions.add(commission);
                    continue block0;
                }
                continue;
            }
            if (!commissionCategories.contains((Object)CommissionCategory.STANDARD)) continue;
            filteredCommissions.add(commission);
        }
        return filteredCommissions;
    }

    public static Collection<GeneralProductCommission> filterCommissions(Collection<GeneralProductCommission> commissions, Set<ContractType> contractTypes) {
        return GeneralProductHelper.filterCommissionsByContractTypes(commissions, contractTypes);
    }

    private static Collection<GeneralProductCommission> filterCommissionsByContractTypes(Collection<GeneralProductCommission> commissions, Set<ContractType> contractTypes) {
        if (commissions == null) {
            return Collections.emptyList();
        }
        if (contractTypes == null) {
            return new ArrayList<GeneralProductCommission>(commissions);
        }
        ArrayList<GeneralProductCommission> filteredCommissions = new ArrayList<GeneralProductCommission>();
        for (GeneralProductCommission commission : commissions) {
            if (!contractTypes.contains(commission.getContractType())) continue;
            filteredCommissions.add(commission);
        }
        return filteredCommissions;
    }

    public static <T extends BaseCommission> Double calculateCommissionsRateAsDouble(Collection<T> commissions, boolean max) {
        BigDecimal result = GeneralProductHelper.calculateCommissionsRate(commissions, max);
        return result == null ? null : Double.valueOf(result.doubleValue());
    }

    public static <T extends BaseCommission> BigDecimal calculateCommissionsRate(Collection<T> commissions, boolean max) {
        BigDecimal rate = null;
        for (BaseCommission commission : commissions) {
            if (commission.getRate() == null) continue;
            BigDecimal value = BigDecimal.valueOf(commission.getRate());
            rate = rate != null ? (max ? rate.max(value) : rate.add(value)) : value;
        }
        return rate;
    }

    public static BigDecimal calculateCommissionsBaseValue(Collection<GeneralProductCommission> commissions) {
        BigDecimal value = null;
        for (GeneralProductCommission commission : commissions) {
            if (commission.getAmount() == null || commission.getAmount().getValue() == null) continue;
            value = value != null ? value.add(commission.getAmount().getValue()) : commission.getAmount().getValue();
        }
        return value;
    }

    public static <T extends BaseCommission> BigDecimal calculateCommissionsEquivalentValue(Collection<T> commissions) {
        BigDecimal value = BigDecimal.ZERO;
        for (BaseCommission commission : commissions) {
            if (commission.getEquivalentAmount() == null) continue;
            value = value.add(commission.getEquivalentAmount());
        }
        return value;
    }

    public static Collection<GeneralProductFop> filterFops(Collection<GeneralProductFop> fops, Set<FopType> fopTypes, Set<PaymentType> paymentTypes, Set<Class<? extends BaseCommissionProperties>> properties) {
        return GeneralProductHelper.filterFopsByFopTypes(GeneralProductHelper.filterFopsByPaymentTypes(GeneralProductHelper.filterFopsByCommissionProperties(fops, properties), paymentTypes), fopTypes);
    }

    private static Collection<GeneralProductFop> filterFopsByFopTypes(Collection<GeneralProductFop> fops, Set<FopType> fopTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (fopTypes == null) {
            return new ArrayList<GeneralProductFop>(fops);
        }
        ArrayList<GeneralProductFop> filteredFops = new ArrayList<GeneralProductFop>();
        for (GeneralProductFop fop : fops) {
            FopType fopType = GeneralProductHelper.getFopType(fop);
            if (!fopTypes.contains(fopType)) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<GeneralProductFop> filterFopsByPaymentTypes(Collection<GeneralProductFop> fops, Set<PaymentType> paymentTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (paymentTypes == null) {
            return new ArrayList<GeneralProductFop>(fops);
        }
        ArrayList<GeneralProductFop> filteredFops = new ArrayList<GeneralProductFop>();
        for (GeneralProductFop fop : fops) {
            if (fop.getType() == null || !paymentTypes.contains(fop.getType())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<GeneralProductFop> filterFopsByCommissionProperties(Collection<GeneralProductFop> fops, Set<Class<? extends BaseCommissionProperties>> properties) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (properties == null) {
            return new ArrayList<GeneralProductFop>(fops);
        }
        ArrayList<GeneralProductFop> filteredFops = new ArrayList<GeneralProductFop>();
        block0: for (GeneralProductFop fop : fops) {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !properties.contains(commission.getCommissionProperties().getType())) continue;
                filteredFops.add(fop);
                continue block0;
            }
        }
        return filteredFops;
    }

    public static BigDecimal calculateFopsEquivalentValue(Collection<GeneralProductFop> fops) {
        BigDecimal value = null;
        for (GeneralProductFop fop : fops) {
            value = MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, fop.getEquivalentAmount()});
        }
        return value;
    }

    public static Collection<GeneralProductTax> filterTaxes(Collection<GeneralProductTax> taxes, Set<String> codes) {
        if (taxes == null) {
            return Collections.emptyList();
        }
        if (codes == null) {
            return new ArrayList<GeneralProductTax>(taxes);
        }
        ArrayList<GeneralProductTax> filteredTaxes = new ArrayList<GeneralProductTax>();
        for (GeneralProductTax tax : taxes) {
            for (String code : codes) {
                if (!TextUtil.isSame((String)code, (String)tax.getCode(), (boolean)true)) continue;
                filteredTaxes.add(tax);
            }
        }
        return filteredTaxes;
    }

    public static BigDecimal calculateTaxesEquivalentValue(Collection<GeneralProductTax> taxes) {
        BigDecimal value = null;
        for (GeneralProductTax tax : taxes) {
            if (tax.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(tax.getEquivalentAmount()) : tax.getEquivalentAmount();
        }
        return value;
    }

    public static Set<BaseProduct> getRelatedProducts(BaseProduct product) {
        HashSet<BaseProduct> result = new HashSet<BaseProduct>();
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        GeneralProductHelper.traverseLinkedProducts(product, result);
        GeneralProductHelper.extractRelatedProducts(product, result);
        List<BaseProduct> relproducts = productHandler.getRelatedProducts(product);
        for (BaseProduct relProd : relproducts) {
            GeneralProductHelper.traverseLinkedProducts(relProd, result);
            GeneralProductHelper.extractRelatedProducts(relProd, result);
        }
        result.addAll(relproducts);
        return result;
    }

    private static void traverseLinkedProducts(BaseProduct product, Set<BaseProduct> linkedProducts) {
        ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(product.getClass());
        BaseProduct currentProduct = product;
        while (productHandler.getNextProduct(currentProduct) != null) {
            currentProduct = productHandler.getNextProduct(currentProduct);
            GeneralProductHelper.extractRelatedProducts(currentProduct, linkedProducts);
            linkedProducts.add(currentProduct);
        }
        currentProduct = product;
        while (productHandler.getPreviousProduct(currentProduct) != null) {
            currentProduct = productHandler.getPreviousProduct(currentProduct);
            GeneralProductHelper.extractRelatedProducts(currentProduct, linkedProducts);
            linkedProducts.add(currentProduct);
        }
    }

    private static void extractRelatedProducts(BaseProduct product, Collection<BaseProduct> relProducts) {
        Collection<BaseProduct> mcoProducts = GeneralProductHelper.getMcoByRelatedProduct(product);
        for (BaseProduct mco : mcoProducts) {
            GeneralProductHelper.extractRelatedProducts(mco, relProducts);
        }
        relProducts.addAll(mcoProducts);
        if (product instanceof Product) {
            Product airProduct = (Product)product;
            Collection<Product> dplProducts = AirProductHelper.getDuplicateByRelatedProduct(airProduct);
            for (Product duplicate : dplProducts) {
                GeneralProductHelper.extractRelatedProducts((BaseProduct)duplicate, relProducts);
            }
            relProducts.addAll(dplProducts);
        }
    }

    public static Collection<BaseProduct> getMcoByRelatedProduct(BaseProduct product) {
        if (product == null) {
            return Collections.emptySet();
        }
        Reservation reservation = product.getReservation();
        if (reservation == null) {
            return Collections.emptySet();
        }
        BookingFile bookingFile = reservation.getBookingFile();
        if (bookingFile == null) {
            return Collections.emptySet();
        }
        String uid = product.getUid();
        HashSet<BaseProduct> result = new HashSet<BaseProduct>();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (prod.getUid().equals(uid)) continue;
                ProductHandler<?> productHandler = HandlersRegistry.get().findProductHandler(prod.getClass());
                for (BaseProduct prod2 : productHandler.getRelatedProducts(prod)) {
                    if (!uid.equals(prod2.getUid())) continue;
                    result.add(prod);
                }
            }
        }
        return result;
    }

    public static <P extends BaseProduct> String getMilitaryClaimNumber(P product) {
        return GeneralProductHelper.getHandler(product).getUnmodifiableContractRelations(product).stream().flatMap(data -> data.getFops().stream()).filter(fop -> fop.getType() == PaymentType.MTD || fop.getType() == PaymentType.CREDIT || fop.getType() == PaymentType.MTD_AGENCY).map(GeneralProductFop::getRelatedTicketNumber).filter(TextUtil::nonBlank).findFirst().orElse(null);
    }

    public static <P extends BaseProduct> void updateFops(P product) {
        GeneralProductHelper.updateProductFops(product);
        GeneralProductHelper.updateFeeFops(product);
        GeneralProductHelper.updateDiscountFops(product);
    }

    public static <P extends BaseProduct> void updateProductFops(P product) {
        ProductHandler<P> ph = GeneralProductHelper.getHandler(product);
        if (null == ph) {
            return;
        }
        boolean isFareFopsRelevant = ph.isFareFopsRelevant(product);
        RelationData last = new RelationData(product);
        List<GeneralProductContractRelationData> contractRelations = ph.getUnmodifiableContractRelations(product);
        for (GeneralProductContractRelationData relation : contractRelations) {
            boolean exchange;
            GeneralProductHelper.updateServiceData(product, (BaseContractRelationData)relation, last);
            last = new RelationData((BaseContractRelationData)relation, last);
            if (!isFareFopsRelevant) {
                relation.getFops().removeIf(f -> productFopTypes.contains(GeneralProductHelper.getFopType(f)));
                continue;
            }
            BigDecimal totalEquivalentFare = relation.getServiceData().getPaymentPrice();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            for (GeneralProductFop fop : GeneralProductHelper.filterFopsByFopTypes(fops, productFopTypes)) {
                if (fop.getEquivalentAmount() != null) continue;
                fop.setEquivalentAmount(BigDecimal.ZERO);
            }
            Collection<GeneralProductFop> ticketPaymentTypeFops = GeneralProductHelper.filterFops(fops, productFopTypes, Collections.singleton(PaymentType.TICKET), null);
            fops.removeAll(ticketPaymentTypeFops);
            HashSet<PaymentType> allPaymentTypesExceptTicket = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
            allPaymentTypesExceptTicket.remove(PaymentType.TICKET);
            boolean bl = exchange = ph.getPreviousProduct(product) != null && ph.getStatus(ph.getPreviousProduct(product)) == ProductStatus.EXCHANGE;
            if (exchange) {
                GeneralProductFop ticketPaymentTypeVendorFop;
                GeneralProductContractRelationData prevRelation = GeneralProductHelper.findContractRelation(GeneralProductHelper.getContractRelationsByReflection(ph.getPreviousProduct(product)), (EntityReference<ContractRelationDescription>)relation.getDescription());
                Collection<GeneralProductFop> filteredVendorFops = GeneralProductHelper.filterFops(prevRelation != null ? prevRelation.getFops() : null, productFopTypes, null, null);
                Iterator<GeneralProductFop> filteredVendorTotalEquivalentFop = MiscUtil.minimum((BigDecimal[])new BigDecimal[]{GeneralProductHelper.calculateFopsEquivalentValue(filteredVendorFops), totalEquivalentFare});
                if (ticketPaymentTypeFops.isEmpty()) {
                    ticketPaymentTypeVendorFop = GeneralProductHelper.createFop(product, PaymentType.TICKET, filteredVendorTotalEquivalentFop, contractType);
                } else {
                    ticketPaymentTypeVendorFop = ticketPaymentTypeFops.iterator().next();
                    ticketPaymentTypeVendorFop.setEquivalentAmount(filteredVendorTotalEquivalentFop);
                }
                fops.add(ticketPaymentTypeVendorFop);
            }
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), feePropertyTypes, null, hiddenCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (GeneralProductFop productFop : GeneralProductHelper.filterFops(fops, productFopTypes, null, null)) {
                ArrayList<GeneralProductCommission> productCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : productFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission productCommission = (GeneralProductCommission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (productCommission == null) continue;
                    productFop.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getEquivalentAmount(), MiscUtil.negate((BigDecimal)productCommission.getEquivalentAmount())}));
                    if (productFop.getEquivalentAmount() != null && productFop.getEquivalentAmount().compareTo(BigDecimal.ZERO) < 0) {
                        productFop.setEquivalentAmount(BigDecimal.ZERO);
                    }
                    productCommissions.add(productCommission);
                }
                productFop.getCommissions().clear();
                productFop.getCommissions().addAll(productCommissions);
            }
            GeneralProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, serviceFeePropertyTypes, productFopTypes, contractType, null);
            for (GeneralProductFop productFop : GeneralProductHelper.filterFops(fops, productFopTypes, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(productFop.getCommissions());
                productFop.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getEquivalentAmount(), commissionsEquivalentValue}));
            }
            BigDecimal difference = totalEquivalentFare;
            Collection<GeneralProductFop> productFops = GeneralProductHelper.filterFops(fops, productFopTypes, null, null);
            BigDecimal totalEquivalentFopValue = GeneralProductHelper.calculateFopsEquivalentValue(productFops);
            if ((difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{difference, MiscUtil.negate((BigDecimal)(totalEquivalentFopValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFopValue, MiscUtil.negate((BigDecimal)GeneralProductHelper.calculateFopsHiddenFeesEquivalentValue(productFops))})))})).compareTo(BigDecimal.ZERO) == 0 && !GeneralProductHelper.filterFopsByPaymentTypes(productFops, allPaymentTypesExceptTicket).isEmpty()) continue;
            Collection<GeneralProductFop> cashPaymentTypeFops = GeneralProductHelper.filterFops(fops, productFopTypes, Collections.singleton(PaymentType.CASH), null);
            if (!cashPaymentTypeFops.isEmpty()) {
                GeneralProductFop cashPaymentTypeFop = cashPaymentTypeFops.iterator().next();
                cashPaymentTypeFop.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{cashPaymentTypeFop.getEquivalentAmount(), difference}));
                continue;
            }
            Collection<GeneralProductFop> invoicePaymentTypeFops = GeneralProductHelper.filterFops(fops, productFopTypes, Collections.singleton(PaymentType.INVOICE), null);
            if (!invoicePaymentTypeFops.isEmpty()) {
                GeneralProductFop invoicePaymentTypeFop = invoicePaymentTypeFops.iterator().next();
                invoicePaymentTypeFop.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{invoicePaymentTypeFop.getEquivalentAmount(), difference}));
                continue;
            }
            Collection<GeneralProductFop> anyPaymentTypeFops = GeneralProductHelper.filterFops(fops, productFopTypes, allPaymentTypesExceptTicket, null);
            if (!anyPaymentTypeFops.isEmpty()) {
                GeneralProductFop anyPaymentTypeFop = anyPaymentTypeFops.iterator().next();
                anyPaymentTypeFop.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{anyPaymentTypeFop.getEquivalentAmount(), difference}));
                continue;
            }
            fops.add(GeneralProductHelper.createFop(product, PaymentType.CASH, difference, contractType));
        }
        ph.updateContractRelations(product, contractRelations);
    }

    public static <P extends BaseProduct> void updateFeeFops(P product) {
        ProductHandler<P> ph = GeneralProductHelper.getHandler(product);
        if (null == ph) {
            return;
        }
        boolean separateSupplierFees = false;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            EntityContainer customerCtr = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            separateSupplierFees = customerCtr != null && ((Organization)customerCtr.getEntity()).isSeparateSupplierFees();
        }
        GeneralProductContractRelationData prevRelation = null;
        List<GeneralProductContractRelationData> contractRelations = ph.getUnmodifiableContractRelations(product);
        for (GeneralProductContractRelationData relation : contractRelations) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), feePropertyTypes, null, standardCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (GeneralProductFop feeFop : GeneralProductHelper.filterFops(fops, feeFopTypes, null, null)) {
                ArrayList<GeneralProductCommission> feeCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : feeFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission feeCommission = (GeneralProductCommission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (feeCommission == null) continue;
                    feeCommissions.add(feeCommission);
                }
                if (feeCommissions.isEmpty()) {
                    fops.remove(feeFop);
                    continue;
                }
                feeFop.getCommissions().clear();
                feeFop.getCommissions().addAll(feeCommissions);
            }
            if (separateSupplierFees && prevRelation != null && !unusedCommissions.isEmpty()) {
                List prevCommissions = prevRelation.getCommissions();
                List<GeneralProductCommission> addUnusedCommissions = unusedCommissions.stream().filter(c -> GeneralProductHelper.isSupplierFee(c, prevCommissions)).collect(Collectors.toList());
                unusedCommissions.removeAll(addUnusedCommissions);
                GeneralProductHelper.distributeCommissionsToFops(product, fops, addUnusedCommissions, serviceFeePropertyTypes, serviceFeeFopTypes, contractType, prevRelation.getCommissions());
            }
            GeneralProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, serviceFeePropertyTypes, serviceFeeFopTypes, contractType, separateSupplierFees && prevRelation != null ? prevRelation.getCommissions() : null);
            prevRelation = relation;
            GeneralProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, paymentFeePropertyTypes, paymentFeeFopTypes, contractType, null);
            for (GeneralProductFop feeFop : GeneralProductHelper.filterFops(fops, feeFopTypes, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(feeFop.getCommissions());
                feeFop.setEquivalentAmount(commissionsEquivalentValue);
            }
        }
        ph.updateContractRelations(product, contractRelations);
    }

    public static boolean isSupplierFee(GeneralProductCommission c, Collection<GeneralProductCommission> prevCommissions) {
        EntityReference propRef = c.getCommissionProperties();
        EntityContainer commPropCtr = EntityStorage.get().resolve(propRef);
        if (null == commPropCtr || !FeeProperties.class.isAssignableFrom(commPropCtr.getEntityType())) {
            return false;
        }
        FeeProperties commProp = (FeeProperties)commPropCtr.getEntity();
        if (!commProp.isTechFee() && !commProp.isChargeToClientForAllContractTypes()) {
            return false;
        }
        return prevCommissions.stream().anyMatch(p -> propRef.equals((Object)p.getCommissionProperties()));
    }

    public static <P extends BaseProduct> void updateDiscountFops(P product) {
        ProductHandler<P> ph = GeneralProductHelper.getHandler(product);
        if (null == ph) {
            return;
        }
        List<GeneralProductContractRelationData> contractRelations = ph.getUnmodifiableContractRelations(product);
        for (GeneralProductContractRelationData relation : contractRelations) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions(relation.getCommissions(), discountPropertyTypes, null, null);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (GeneralProductFop discountFop : GeneralProductHelper.filterFops(fops, discountFopTypes, null, null)) {
                ArrayList<GeneralProductCommission> discountCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : discountFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission discountCommission = (GeneralProductCommission)CollectionUtil.find(commissions, (String)fopCommission.getUid());
                    if (discountCommission == null) continue;
                    discountCommissions.add(discountCommission);
                }
                if (discountCommissions.isEmpty()) {
                    fops.remove(discountFop);
                    continue;
                }
                discountFop.getCommissions().clear();
                discountFop.getCommissions().addAll(discountCommissions);
            }
            GeneralProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, discountDiscountPropertyTypes, discountFopTypes, contractType, null);
            for (GeneralProductFop discountFop : GeneralProductHelper.filterFops(fops, discountFopTypes, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue(discountFop.getCommissions());
                commissionsEquivalentValue = MiscUtil.negate((BigDecimal)commissionsEquivalentValue);
                discountFop.setEquivalentAmount(commissionsEquivalentValue);
            }
        }
        ph.updateContractRelations(product, contractRelations);
    }

    private static void distributeCommissionsToFops(BaseProduct product, Collection<GeneralProductFop> fops, Collection<GeneralProductCommission> commissions, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, ContractType contractType, Collection<GeneralProductCommission> prevCommissions) {
        Collection<GeneralProductCommission> filteredCommissions = GeneralProductHelper.filterCommissions(commissions, commissionProperties, null, null);
        if (filteredCommissions.isEmpty()) {
            return;
        }
        boolean done = GeneralProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.CASH), commissionProperties, fopTypes, prevCommissions);
        if (!done) {
            done = GeneralProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.INVOICE), commissionProperties, fopTypes, prevCommissions);
        }
        if (!done) {
            done = GeneralProductHelper.distributeCommissionsToFops(fops, filteredCommissions, null, commissionProperties, fopTypes, prevCommissions);
        }
        if (!done) {
            GeneralProductFop cashPaymentTypeFop = GeneralProductHelper.createFop(product, PaymentType.CASH, BigDecimal.ZERO, contractType);
            cashPaymentTypeFop.getCommissions().addAll(filteredCommissions);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static boolean distributeCommissionsToFops(Collection<GeneralProductFop> fops, Collection<GeneralProductCommission> commissions, Set<PaymentType> paymentTypes, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, Collection<GeneralProductCommission> prevCommissions) {
        Collection<GeneralProductFop> filteredFops = GeneralProductHelper.filterFops(fops, fopTypes, paymentTypes, null);
        if (!filteredFops.isEmpty()) {
            GeneralProductFop filteredFop;
            if (null == prevCommissions) {
                filteredFop = filteredFops.iterator().next();
            } else {
                boolean supplierFee = !commissions.isEmpty() && GeneralProductHelper.isSupplierFee(commissions.iterator().next(), prevCommissions);
                filteredFop = filteredFops.stream().filter(f -> (!f.getCommissions().isEmpty() && GeneralProductHelper.isSupplierFee((GeneralProductCommission)f.getCommissions().get(0), prevCommissions)) == supplierFee).findFirst().orElse(null);
                if (null == filteredFop) {
                    return false;
                }
            }
            filteredFop.getCommissions().addAll(commissions);
            return true;
        }
        return false;
    }

    private static GeneralProductFop createFop(BaseProduct product, PaymentType paymentType, BigDecimal amount, ContractType contractType) {
        GeneralProductFop fop = new GeneralProductFop();
        fop.setType(paymentType);
        fop.setEquivalentAmount(amount);
        OnCreateFopListener.fire(product, (Fop)fop, contractType);
        return fop;
    }

    public static BigDecimal calculateFopsHiddenFeesEquivalentValue(Collection<GeneralProductFop> fops) {
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductFop fop : fops) {
            result = result.add(GeneralProductHelper.calculateHiddenFeesEquivalentValue(fop.getCommissions()));
        }
        return result;
    }

    public static <T extends BaseCommission> BigDecimal calculateHiddenFeesEquivalentValue(Collection<T> commissions) {
        return GeneralProductHelper.calculateHiddenFeesEquivalentValue(commissions, true);
    }

    public static <T extends BaseCommission> BigDecimal calculateHiddenFeesEquivalentValue(Collection<T> commissions, boolean includeCorrection) {
        BigDecimal result = BigDecimal.ZERO;
        for (BaseCommission comm : commissions) {
            FeeProperties feeProp;
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof FeeProperties) || !(feeProp = (FeeProperties)ctr.getEntity()).isHidden() || !includeCorrection && ctr.getUid().equals(HOTEL_PRODUCT_FEE_PROPERTY_UID)) continue;
            BigDecimal amount = comm.getEquivalentAmount();
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, amount});
        }
        return result;
    }

    public static List<GeneralProductFop> getFops(List<GeneralProductContractRelationData> contractRelations, ContractType contractType) {
        GeneralProductContractRelationData item = GeneralProductHelper.getContractRelation(contractRelations, contractType);
        return item == null ? null : item.getFops();
    }

    public static GeneralProductFop toGeneralProductFop(GeneralProductFop fop) {
        GeneralProductFop generalProductFop = new GeneralProductFop();
        try {
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)generalProductFop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generalProductFop;
    }

    public static GeneralProductCommission toGeneralProductCommission(GeneralProductCommission commission) {
        GeneralProductCommission generalProductCommission = new GeneralProductCommission();
        try {
            XCloneModelHelper.copy((BaseEntity)commission, (BaseEntity)generalProductCommission);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generalProductCommission;
    }

    public static GeneralProductTax toGeneralProductTax(GeneralProductTax tax) {
        GeneralProductTax generalProductTax = new GeneralProductTax();
        try {
            XCloneModelHelper.copy((BaseEntity)tax, (BaseEntity)generalProductTax);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generalProductTax;
    }

    public static void updateFop(List<GeneralProductFop> fops, List<GeneralProductCommission> commissions, GeneralProductFop generalProductFop, int n) {
        GeneralProductFop fop = BookingHelper.findEntityByUid(fops, generalProductFop.getUid());
        if (fop == null) {
            fop = new GeneralProductFop();
            fops.add(n < fops.size() ? n : (fops.size() > 0 ? fops.size() - 1 : 0), fop);
        }
        try {
            XCloneModelHelper.copy((BaseEntity)generalProductFop, (BaseEntity)fop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        fop.getCommissions().clear();
        for (GeneralProductCommission generalProductCommission : generalProductFop.getCommissions()) {
            GeneralProductHelper.updateCommission(commissions, generalProductCommission);
            GeneralProductCommission commission = BookingHelper.findEntityByUid(commissions, generalProductCommission.getUid());
            if (commission == null) continue;
            fop.getCommissions().add(commission);
        }
    }

    public static void updateCommission(List<GeneralProductCommission> commissions, GeneralProductCommission generalProductCommission) {
        GeneralProductCommission commission = BookingHelper.findEntityByUid(commissions, generalProductCommission.getUid());
        if (commission == null) {
            commission = new GeneralProductCommission();
            commissions.add(commission);
        }
        try {
            XCloneModelHelper.copy((BaseEntity)generalProductCommission, (BaseEntity)commission);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateTax(List<GeneralProductTax> taxes, GeneralProductTax generalProductTax) {
        GeneralProductTax tax = BookingHelper.findEntityByUid(taxes, generalProductTax.getUid());
        if (tax == null) {
            tax = new GeneralProductTax();
            taxes.add(tax);
        }
        try {
            XCloneModelHelper.copy((BaseEntity)generalProductTax, (BaseEntity)tax);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Date getFirstRefuseDate(List<GeneralProductFop> fops) {
        Date refuseDate = null;
        for (GeneralProductFop fop : fops) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        return refuseDate;
    }

    public static BigDecimal getTaxesForBlankEquivalentAmount(BaseProduct product) {
        String blankOwnerCode = GeneralProductHelper.getBlankOwnerCode(product);
        if (!taxesBlank.containsKey(blankOwnerCode) || taxesBlank.get(blankOwnerCode) == null) {
            return BigDecimal.ZERO;
        }
        return GeneralProductHelper.getEquivalentTaxAmount(GeneralProductHelper.getTaxes(product), true, taxesBlank.get(blankOwnerCode));
    }

    private static String getBlankOwnerCode(BaseProduct product) {
        EntityReference<Organization> blankOwnerRef = GeneralProductHelper.getBlankOwner(product);
        if (blankOwnerRef == null) {
            return null;
        }
        try {
            EntityContainer ctr = EntityStorage.get().resolve(blankOwnerRef);
            return ctr != null && ((Organization)ctr.getEntity()).getAirline() != null ? ((Organization)ctr.getEntity()).getAirline().getCode() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <P extends BaseProduct> List<GeneralProductCommission> getUnmodifiableCommissions(P prod, ContractType contractType) {
        ArrayList<GeneralProductCommission> filteredCommissions = new ArrayList<GeneralProductCommission>();
        ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(prod.getClass());
        List<GeneralProductContractRelationData> relations = handler.getUnmodifiableContractRelations(prod);
        for (GeneralProductContractRelationData relation : relations) {
            if (contractType != null && GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != contractType) continue;
            filteredCommissions.addAll(relation.getCommissions());
        }
        return filteredCommissions;
    }

    public static EntityReference<Organization> getContractor(SalesChain chain, EntityReference<ContractorDescription> descr) {
        if (descr == null) {
            return null;
        }
        for (Contractor item : chain.getContractors()) {
            if (!descr.equals((Object)item.getDescription())) continue;
            return item.getContractor();
        }
        return null;
    }

    public static EntityReference<Organization> getContractor(SalesChain chain, PredefinedContractorType type) {
        return GeneralProductHelper.getContractor(chain, type, false);
    }

    public static EntityReference<Organization> getContractor(SalesChain chain, PredefinedContractorType type, boolean strict) {
        PredefinedSalesChainType predefinedType;
        if (chain == null || chain.getDescription() == null) {
            return null;
        }
        for (Contractor item : chain.getContractors()) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getDescription());
            if (ctr == null || ((ContractorDescription)ctr.getEntity()).getPredefinedType() != type) continue;
            return item.getContractor();
        }
        if (!strict && type == PredefinedContractorType.SUBAGENCY && GeneralProductHelper.isOwnPredefinedSalesChainType(predefinedType = ((SalesChainDescription)EntityStorage.get().resolve(chain.getDescription()).getEntity()).getPredefinedType())) {
            return GeneralProductHelper.getContractor(chain, PredefinedContractorType.AGENCY);
        }
        return null;
    }

    public static boolean isOwnPredefinedSalesChainType(PredefinedSalesChainType predefinedType) {
        return predefinedType == PredefinedSalesChainType.OWN || predefinedType == PredefinedSalesChainType.OWN_TECHNICAL_PROVIDER;
    }

    public static void setContractor(SalesChain salesChain, PredefinedContractorType type, EntityReference<Organization> organization, int level) {
        if (salesChain == null) {
            throw new IllegalArgumentException("sales chain can't be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can't be null");
        }
        if (level < 0) {
            throw new IllegalArgumentException("level should be greater or equals 0");
        }
        SalesChainHandler handler = SalesChainHandler.of((EntityReference<SalesChainDescription>)salesChain.getDescription());
        boolean supplierSupported = handler.isSupplierSupported();
        boolean technicalProviderSupported = handler.isTechnicalProviderSupported();
        boolean agencySupported = handler.isAgencySupported();
        boolean subagencySupported = handler.isSubagencySupported();
        Contractor supplierContractor = handler.getSupplierContractor(salesChain.getContractors());
        Contractor technicalProviderContractor = handler.getTechnicalProviderContractor(salesChain.getContractors());
        Contractor agencyContractor = handler.getAgencyContractor(salesChain.getContractors());
        List<Contractor> subagencyContractors = handler.getSubagencyContractors(salesChain.getContractors());
        if (type == PredefinedContractorType.SUPPLIER) {
            if (!supplierSupported) {
                throw new IllegalStateException("supplier is not supported");
            }
            if (organization != null) {
                if (supplierContractor == null) {
                    supplierContractor = new Contractor();
                    supplierContractor.setDescription(handler.getSupplierContractorDescription());
                }
                supplierContractor.setContractor(organization);
            } else {
                supplierContractor = null;
            }
        } else if (type == PredefinedContractorType.TECHNICAL_PROVIDER) {
            if (!technicalProviderSupported) {
                throw new IllegalStateException("technical provider is not supported");
            }
            if (organization != null) {
                if (technicalProviderContractor == null) {
                    technicalProviderContractor = new Contractor();
                    technicalProviderContractor.setDescription(handler.getTechnicalProviderContractorDescription());
                }
                technicalProviderContractor.setContractor(organization);
            } else {
                technicalProviderContractor = null;
            }
        } else if (type == PredefinedContractorType.AGENCY) {
            if (!agencySupported) {
                throw new IllegalStateException("agency is not supported");
            }
            if (organization != null) {
                if (agencyContractor == null) {
                    agencyContractor = new Contractor();
                    agencyContractor.setDescription(handler.getAgencyContractorDescription());
                }
                agencyContractor.setContractor(organization);
            } else {
                agencyContractor = null;
            }
        } else if (type == PredefinedContractorType.SUBAGENCY) {
            if (!subagencySupported) {
                throw new IllegalStateException("subagency is not supported");
            }
            if (level >= subagencyContractors.size()) {
                throw new IllegalStateException("level is greater than supported subagency count");
            }
            if (organization != null) {
                Contractor subagencyContractor = subagencyContractors.get(level);
                if (subagencyContractor == null) {
                    subagencyContractor = new Contractor();
                    subagencyContractor.setDescription(handler.getSubagencyContractorDescriptions().get(level));
                    subagencyContractors.set(level, subagencyContractor);
                }
                subagencyContractor.setContractor(organization);
            } else {
                subagencyContractors.set(level, null);
            }
        }
        HashSet<EntityReference> organizations = new HashSet<EntityReference>();
        ArrayList<Contractor> contractors = new ArrayList<Contractor>();
        if (supplierSupported && supplierContractor != null && !organizations.contains(supplierContractor.getContractor())) {
            contractors.add(supplierContractor);
            organizations.add(supplierContractor.getContractor());
        }
        if (technicalProviderSupported && technicalProviderContractor != null && !organizations.contains(technicalProviderContractor.getContractor())) {
            contractors.add(technicalProviderContractor);
            organizations.add(technicalProviderContractor.getContractor());
        }
        if (agencySupported && agencyContractor != null && !organizations.contains(agencyContractor.getContractor())) {
            contractors.add(agencyContractor);
            organizations.add(agencyContractor.getContractor());
        }
        if (subagencySupported) {
            for (Contractor subagencyContractor : subagencyContractors.stream().filter(item -> item != null).collect(Collectors.toList())) {
                if (organizations.contains(subagencyContractor.getContractor())) continue;
                contractors.add(subagencyContractor);
                organizations.add(subagencyContractor.getContractor());
            }
        }
        salesChain.getContractors().clear();
        salesChain.getContractors().addAll(contractors);
    }

    public static void setContractor(SalesChain chain, PredefinedContractorType type, EntityReference<Organization> value) {
        Contractor contractor;
        PredefinedContractorType predefinedType;
        EntityContainer ctr;
        if (chain.getDescription() == null) {
            return;
        }
        Contractor agency = null;
        Contractor subagency = null;
        Contractor supplier = null;
        Contractor technicalProvider = null;
        for (Contractor item : chain.getContractors()) {
            ctr = EntityStorage.get().resolve(item.getDescription());
            predefinedType = ((ContractorDescription)ctr.getEntity()).getPredefinedType();
            if (predefinedType == PredefinedContractorType.AGENCY) {
                agency = item;
            }
            if (predefinedType == PredefinedContractorType.SUBAGENCY) {
                subagency = item;
            }
            if (predefinedType == PredefinedContractorType.SUPPLIER) {
                supplier = item;
            }
            if (predefinedType != PredefinedContractorType.TECHNICAL_PROVIDER) continue;
            technicalProvider = item;
        }
        if (type == PredefinedContractorType.SUPPLIER) {
            if (supplier == null) {
                supplier = new Contractor();
                supplier.setDescription(GeneralProductHelper.findPredefinedContractorDescription(type));
                chain.getContractors().add(supplier);
            }
            supplier.setContractor(value);
            return;
        }
        if (type == PredefinedContractorType.SUBAGENCY) {
            if (agency != null && agency.getContractor() != null && agency.getContractor().equals(value) || value == null) {
                GeneralProductHelper.checkType(chain, PredefinedSalesChainType.OWN);
                if (subagency != null) {
                    chain.getContractors().remove(subagency);
                }
                return;
            }
            if (subagency == null) {
                GeneralProductHelper.checkType(chain, PredefinedSalesChainType.SUBAGENT);
                contractor = new Contractor();
                contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(type));
                contractor.setContractor(value);
                chain.getContractors().add(contractor);
                return;
            }
            subagency.setContractor(value);
            return;
        }
        if (type == PredefinedContractorType.AGENCY) {
            if (subagency != null && subagency.getContractor() != null && subagency.getContractor().equals(value)) {
                GeneralProductHelper.checkType(chain, PredefinedSalesChainType.OWN);
                chain.getContractors().remove(subagency);
                if (agency == null) {
                    contractor = new Contractor();
                    contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(type));
                    contractor.setContractor(value);
                    chain.getContractors().add(contractor);
                    return;
                }
                agency.setContractor(value);
                return;
            }
            if (agency == null) {
                GeneralProductHelper.checkType(chain, PredefinedSalesChainType.SUBAGENT);
                contractor = new Contractor();
                contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(type));
                contractor.setContractor(value);
                chain.getContractors().add(contractor);
                return;
            }
            agency.setContractor(value);
            return;
        }
        if (type == PredefinedContractorType.TECHNICAL_PROVIDER) {
            if (value != null) {
                GeneralProductHelper.checkType(chain, subagency == null ? PredefinedSalesChainType.OWN_TECHNICAL_PROVIDER : PredefinedSalesChainType.SUBAGENT_TECHNICAL_PROVIDER);
                if (technicalProvider == null) {
                    technicalProvider = new Contractor();
                    technicalProvider.setDescription(GeneralProductHelper.findPredefinedContractorDescription(type));
                    chain.getContractors().add(technicalProvider);
                }
                technicalProvider.setContractor(value);
            }
            return;
        }
        for (Contractor item : chain.getContractors()) {
            ctr = EntityStorage.get().resolve(item.getDescription());
            predefinedType = ((ContractorDescription)ctr.getEntity()).getPredefinedType();
            if (predefinedType != type) continue;
            item.setContractor(value);
            return;
        }
        if (type == PredefinedContractorType.SUBAGENCY) {
            GeneralProductHelper.checkType(chain, PredefinedSalesChainType.SUBAGENT);
            contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(type));
            contractor.setContractor(value);
            chain.getContractors().add(contractor);
        }
    }

    private static void checkType(SalesChain chain, PredefinedSalesChainType type) {
        if (((SalesChainDescription)EntityStorage.get().resolve(chain.getDescription()).getEntity()).getPredefinedType() != null) {
            chain.setDescription(GeneralProductHelper.getPredefinedDescription(type, (EntityReference<SalesChainDescription>)chain.getDescription()));
        }
    }

    public static ContractType getContractType(EntityReference<ContractRelationDescription> description) {
        EntityContainer relationDescr = EntityStorage.get().resolve(description);
        EntityContainer customerDescr = EntityStorage.get().resolve(((ContractRelationDescription)relationDescr.getEntity()).getCustomer());
        EntityContainer supplierDescr = EntityStorage.get().resolve(((ContractRelationDescription)relationDescr.getEntity()).getSupplier());
        if (((ContractorDescription)supplierDescr.getEntity()).getPredefinedType() == PredefinedContractorType.TECHNICAL_PROVIDER) {
            return ContractType.TECHNICAL_PROVIDER;
        }
        if (((ContractorDescription)supplierDescr.getEntity()).getPredefinedType() == PredefinedContractorType.SUPER_SUPPLIER) {
            return ContractType.VENDOR;
        }
        if (((ContractorDescription)supplierDescr.getEntity()).getPredefinedType() == PredefinedContractorType.SUPPLIER) {
            return ContractType.VENDOR;
        }
        if (((ContractorDescription)customerDescr.getEntity()).getPredefinedType() == PredefinedContractorType.CLIENT) {
            return ContractType.CLIENT;
        }
        return ContractType.SUBAGENCY;
    }

    public static AgreementType getAgreementType(BaseContractRelationData contractRelation) {
        if (contractRelation == null) {
            return null;
        }
        EntityReference contractReference = contractRelation.getGeneralData().getContractData().getContract();
        if (contractReference == null) {
            return null;
        }
        EntityContainer contract = EntityStorage.get().resolve(contractReference);
        if (contract == null) {
            return null;
        }
        return ((Contract)contract.getEntity()).getAgreementType();
    }

    public static EntityReference<Organization> getContractRelationSupplier(EntityReference<ContractRelationDescription> description, SalesChain salesChain) {
        EntityContainer contractRelationDescriptionContainer = EntityStorage.get().resolve(description);
        if (contractRelationDescriptionContainer != null) {
            EntityReference supplierContractorDescription = ((ContractRelationDescription)contractRelationDescriptionContainer.getEntity()).getSupplier();
            for (Contractor contractor : salesChain.getContractors()) {
                if (contractor.getDescription() == null || !contractor.getDescription().equals((Object)supplierContractorDescription)) continue;
                return contractor.getContractor();
            }
        }
        return null;
    }

    public static EntityReference<Organization> getContractRelationCustomer(EntityReference<ContractRelationDescription> description, SalesChain salesChain) {
        if (salesChain == null) {
            return null;
        }
        EntityContainer contractRelationDescriptionContainer = EntityStorage.get().resolve(description);
        if (contractRelationDescriptionContainer != null) {
            EntityReference customerContractorDescription = ((ContractRelationDescription)contractRelationDescriptionContainer.getEntity()).getCustomer();
            for (Contractor contractor : salesChain.getContractors()) {
                if (contractor.getDescription() == null || !contractor.getDescription().equals((Object)customerContractorDescription)) continue;
                return contractor.getContractor();
            }
        }
        return null;
    }

    public static void ensureContractRelationsExists() {
        GeneralProductHelper.ensureContractor(PredefinedContractorType.SUPPLIER);
        GeneralProductHelper.ensureContractor(PredefinedContractorType.AGENCY);
        GeneralProductHelper.ensureContractor(PredefinedContractorType.SUBAGENCY);
        GeneralProductHelper.ensureContractor(PredefinedContractorType.CLIENT);
        GeneralProductHelper.ensureContractor(PredefinedContractorType.TECHNICAL_PROVIDER);
        GeneralProductHelper.ensureContractRelation(PredefinedContractRelationType.SUPPLIER_TO_AGENCY, PredefinedContractorType.SUPPLIER, PredefinedContractorType.AGENCY);
        GeneralProductHelper.ensureContractRelation(PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, PredefinedContractorType.AGENCY, PredefinedContractorType.SUBAGENCY);
        GeneralProductHelper.ensureContractRelation(PredefinedContractRelationType.SUBAGENCY_TO_CLIENT, PredefinedContractorType.SUBAGENCY, PredefinedContractorType.CLIENT);
        GeneralProductHelper.ensureContractRelation(PredefinedContractRelationType.AGENCY_TO_CLIENT, PredefinedContractorType.AGENCY, PredefinedContractorType.CLIENT);
        GeneralProductHelper.ensureContractRelation(PredefinedContractRelationType.TECHNICAL_PROVIDER_TO_AGENCY, PredefinedContractorType.TECHNICAL_PROVIDER, PredefinedContractorType.AGENCY);
        GeneralProductHelper.ensureSalesChain(PredefinedSalesChainType.OWN, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, PredefinedContractRelationType.AGENCY_TO_CLIENT);
        GeneralProductHelper.ensureSalesChain(PredefinedSalesChainType.SUBAGENT, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, PredefinedContractRelationType.SUBAGENCY_TO_CLIENT);
        GeneralProductHelper.ensureSalesChain(PredefinedSalesChainType.OWN_TECHNICAL_PROVIDER, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, PredefinedContractRelationType.TECHNICAL_PROVIDER_TO_AGENCY, PredefinedContractRelationType.AGENCY_TO_CLIENT);
        GeneralProductHelper.ensureSalesChain(PredefinedSalesChainType.SUBAGENT_TECHNICAL_PROVIDER, PredefinedContractRelationType.SUPPLIER_TO_AGENCY, PredefinedContractRelationType.TECHNICAL_PROVIDER_TO_AGENCY, PredefinedContractRelationType.AGENCY_TO_SUBAGENCY, PredefinedContractRelationType.SUBAGENCY_TO_CLIENT);
    }

    private static void ensureSalesChain(PredefinedSalesChainType type, PredefinedContractRelationType ... relations) {
        EntityContainer ctr = EntityStorage.get().find(SalesChainDescriptionIndex.class, SalesChainDescriptionIndex.Property.predefinedType.name(), (Object)type);
        if (ctr != null) {
            return;
        }
        ctr = new EntityContainer(SalesChainDescription.class, String.format("sales-chain-%s", type.name()));
        EnumItem enumItem = (EnumItem)((EnumType)MetaRegistry.get().getEnums().get(PredefinedSalesChainType.class.getName())).getItems().get(type.name());
        ((SalesChainDescription)ctr.getEntity()).setPredefinedType(type);
        for (LocaleData item : LocaleManager.get().getSupportedLocales()) {
            String displayName = enumItem.getDisplayName(item.getLocale());
            if (TextUtil.isBlank((String)displayName)) continue;
            ((SalesChainDescription)ctr.getEntity()).getName().getValues().put(item.getLocale(), enumItem.getDisplayName(item.getLocale()));
        }
        for (PredefinedContractRelationType relation : relations) {
            ((SalesChainDescription)ctr.getEntity()).getContractRelations().add(GeneralProductHelper.findContractRelationRef(relation));
        }
        EntityStorage.get().save(ctr, true);
    }

    public static EntityReference<ContractRelationDescription> findContractRelationRef(PredefinedContractRelationType relation) {
        return EntityStorage.get().find(ContractRelationDescriptionIndex.class, ContractRelationDescriptionIndex.Property.predefinedType.name(), (Object)relation).toReference();
    }

    public static EntityReference<ContractorDescription> findPredefinedContractorDescription(PredefinedContractorType type) {
        return EntityStorage.get().find(ContractorDescriptionIndex.class, ContractorDescriptionIndex.Property.predefinedType.name(), (Object)type).toReference();
    }

    private static void ensureContractRelation(PredefinedContractRelationType relation, PredefinedContractorType supplier, PredefinedContractorType customer) {
        EntityContainer ctr = EntityStorage.get().find(ContractRelationDescriptionIndex.class, ContractRelationDescriptionIndex.Property.predefinedType.name(), (Object)relation);
        if (ctr != null) {
            return;
        }
        ctr = new EntityContainer(ContractRelationDescription.class, String.format("relation-%s", relation.name()));
        EnumItem enumItem = (EnumItem)((EnumType)MetaRegistry.get().getEnums().get(PredefinedContractRelationType.class.getName())).getItems().get(relation.name());
        ((ContractRelationDescription)ctr.getEntity()).setPredefinedType(relation);
        for (LocaleData item : LocaleManager.get().getSupportedLocales()) {
            String displayName = enumItem.getDisplayName(item.getLocale());
            if (TextUtil.isBlank((String)displayName)) continue;
            ((ContractRelationDescription)ctr.getEntity()).getName().getValues().put(item.getLocale(), enumItem.getDisplayName(item.getLocale()));
        }
        ((ContractRelationDescription)ctr.getEntity()).setCustomer(GeneralProductHelper.findContractorDescriptionRef(customer));
        ((ContractRelationDescription)ctr.getEntity()).setSupplier(GeneralProductHelper.findContractorDescriptionRef(supplier));
        ((ContractRelationDescription)ctr.getEntity()).setPredefinedType(relation);
        EntityStorage.get().save(ctr, true);
    }

    public static EntityReference<ContractorDescription> findContractorDescriptionRef(PredefinedContractorType type) {
        EntityContainer ctr = EntityStorage.get().find(ContractorDescriptionIndex.class, ContractorDescriptionIndex.Property.predefinedType.name(), (Object)type);
        if (ctr == null) {
            throw new RuntimeException("failed to find ContractorDescription with predefinedType=" + type.name());
        }
        return ctr.toReference();
    }

    private static void ensureContractor(PredefinedContractorType type) {
        EntityContainer ctr = EntityStorage.get().find(ContractorDescriptionIndex.class, ContractorDescriptionIndex.Property.predefinedType.name(), (Object)type);
        if (ctr != null) {
            return;
        }
        ctr = new EntityContainer(ContractorDescription.class, String.format("contractor-%s", type.name()));
        EnumItem enumItem = (EnumItem)((EnumType)MetaRegistry.get().getEnums().get(PredefinedContractorType.class.getName())).getItems().get(type.name());
        ((ContractorDescription)ctr.getEntity()).setPredefinedType(type);
        for (LocaleData item : LocaleManager.get().getSupportedLocales()) {
            String displayName = enumItem.getDisplayName(item.getLocale());
            if (TextUtil.isBlank((String)displayName)) continue;
            ((ContractorDescription)ctr.getEntity()).getName().getValues().put(item.getLocale(), enumItem.getDisplayName(item.getLocale()));
        }
        EntityStorage.get().save(ctr, true);
    }

    public static SalesChain getSalesChainByReflection(BaseProduct prod) {
        boolean ownSales;
        SalesChain salesChain = (SalesChain)prod.getValue("salesChain");
        if (salesChain != null) {
            return salesChain;
        }
        salesChain = new SalesChain();
        prod.setValue("salesChain", (Object)salesChain);
        EntityReference<Organization> supplier = GeneralProductHelper.getOrganization(prod, "supplier");
        EntityReference<Organization> technicalProvider = GeneralProductHelper.getOrganization(prod, "technicalProvider");
        EntityReference<Organization> agency = GeneralProductHelper.getOrganization(prod, "agency");
        EntityReference<Organization> subagency = GeneralProductHelper.getOrganization(prod, "subagency");
        boolean bl = ownSales = subagency == null || subagency.equals(agency);
        if (technicalProvider != null) {
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(ownSales ? PredefinedSalesChainType.OWN_TECHNICAL_PROVIDER : PredefinedSalesChainType.SUBAGENT_TECHNICAL_PROVIDER, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
        } else {
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(ownSales ? PredefinedSalesChainType.OWN : PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
        }
        ArrayList<Contractor> contractors = new ArrayList<Contractor>();
        contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.SUPPLIER, supplier));
        if (technicalProvider != null) {
            contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.TECHNICAL_PROVIDER, technicalProvider));
        }
        contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.AGENCY, agency));
        if (!ownSales) {
            contractors.add(GeneralProductHelper.getContractor(salesChain.getContractors(), PredefinedContractorType.SUBAGENCY, subagency));
        }
        salesChain.getContractors().clear();
        salesChain.getContractors().addAll(contractors);
        return salesChain;
    }

    public static EntityReference<Organization> getOrganization(BaseProduct prod, String propertyName) {
        return (EntityReference)prod.getValue(propertyName);
    }

    public static EntityReference<SalesChainDescription> getPredefinedDescription(PredefinedSalesChainType predefinedSalesChainType, EntityReference<SalesChainDescription> description) {
        EntityContainer ctr = EntityStorage.get().resolve(description);
        if (ctr != null && ((SalesChainDescription)ctr.getEntity()).getPredefinedType() == predefinedSalesChainType) {
            return description;
        }
        ctr = EntityStorage.get().find(SalesChainDescriptionIndex.class, SalesChainDescriptionIndex.Property.predefinedType.name(), (Object)predefinedSalesChainType);
        return ctr == null ? null : ctr.toReference();
    }

    public static EntityReference<Organization> getOrganization(Product prod, String propertyName) {
        return (EntityReference)prod.getValue(propertyName);
    }

    public static Contractor getContractor(List<Contractor> contractors, PredefinedContractorType supplier, EntityReference<Organization> org) {
        for (Contractor contractor : contractors) {
            EntityContainer ctr = EntityStorage.get().resolve(contractor.getDescription());
            if (ctr == null || ((ContractorDescription)ctr.getEntity()).getPredefinedType() != supplier) continue;
            contractor.setContractor(org);
            return contractor;
        }
        Contractor result = new Contractor();
        EntityContainer ctr = EntityStorage.get().find(ContractorDescriptionIndex.class, ContractorDescriptionIndex.Property.predefinedType.name(), (Object)supplier);
        result.setDescription(ctr == null ? null : ctr.toReference());
        result.setContractor(org);
        return result;
    }

    public static List<GeneralProductContractRelationData> getContractRelationsByReflection(BaseProduct prod) {
        List originalRelations = (List)prod.getValue(CONTRACT_RELATIONS_PROPERTY_NAME);
        SalesChain salesChain = GeneralProductHelper.getSalesChainByReflection(prod);
        ArrayList<GeneralProductContractRelationData> subresult = new ArrayList<GeneralProductContractRelationData>();
        ArrayList toDelete = new ArrayList(originalRelations);
        boolean modified = false;
        boolean hasOldFields = false;
        boolean hasOldFieldsInit = false;
        for (EntityReference item : ((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getContractRelations()) {
            GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(originalRelations, (EntityReference<ContractRelationDescription>)item);
            if (relation != null) {
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            PredefinedContractRelationType predefinedType = ((ContractRelationDescription)EntityStorage.get().resolve(item).getEntity()).getPredefinedType();
            if ((predefinedType == PredefinedContractRelationType.AGENCY_TO_CLIENT || predefinedType == PredefinedContractRelationType.SUBAGENCY_TO_CLIENT) && (relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation(originalRelations, ContractType.CLIENT)) != null) {
                relation.setDescription(item);
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            relation = new GeneralProductContractRelationData();
            relation.setDescription(item);
            if (!hasOldFieldsInit) {
                hasOldFields = Boolean.TRUE.equals(HAS_OLD_FIELDS.computeIfAbsent(prod.getClass(), k -> {
                    try {
                        GeneralProductHelper.getCommissionsFromOldSourceByReflection(prod);
                        return true;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }));
                hasOldFieldsInit = true;
            }
            if (hasOldFields) {
                GeneralProductHelper.updateRelationFromOldFields(prod, relation);
            }
            subresult.add(relation);
            modified = true;
        }
        if (modified || !toDelete.isEmpty()) {
            originalRelations.clear();
            originalRelations.addAll(subresult);
            if (hasOldFields) {
                GeneralProductHelper.getCommissionsFromOldSourceByReflection(prod).clear();
                GeneralProductHelper.getFopsFromOldSourceByReflection(prod, ContractType.VENDOR).clear();
                GeneralProductHelper.getFopsFromOldSourceByReflection(prod, ContractType.SUBAGENCY).clear();
                GeneralProductHelper.getFopsFromOldSourceByReflection(prod, ContractType.CLIENT).clear();
            }
        }
        return originalRelations;
    }

    public static <R extends BaseContractRelationData> R findContractRelation(List<R> relations, EntityReference<ContractRelationDescription> descr) {
        for (BaseContractRelationData relation : relations) {
            if (!descr.equals((Object)relation.getDescription())) continue;
            return (R)relation;
        }
        return null;
    }

    public static <R extends BaseContractRelationData> R findContractRelation(List<R> relations, ContractType type) {
        for (BaseContractRelationData relation : relations) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != type) continue;
            return (R)relation;
        }
        return null;
    }

    private static void updateRelationFromOldFields(BaseProduct prod, GeneralProductContractRelationData relation) {
        relation.getCommissions().clear();
        relation.getFops().clear();
        switch (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription())) {
            case VENDOR: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection(prod, ContractType.VENDOR));
                relation.getFops().addAll(GeneralProductHelper.getFopsFromOldSourceByReflection(prod, ContractType.VENDOR));
                break;
            }
            case SUBAGENCY: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection(prod, ContractType.SUBAGENCY));
                relation.getFops().addAll(GeneralProductHelper.getFopsFromOldSourceByReflection(prod, ContractType.SUBAGENCY));
                break;
            }
            case CLIENT: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection(prod, ContractType.CLIENT));
                relation.getFops().addAll(GeneralProductHelper.getFopsFromOldSourceByReflection(prod, ContractType.CLIENT));
            }
        }
    }

    public static List<GeneralProductCommission> getCommissionsFromOldSourceByReflection(BaseProduct prod) {
        return (List)prod.getValue("commissions");
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissionsFromOldSourceByReflection(BaseProduct prod, ContractType type) {
        ArrayList<GeneralProductCommission> result = new ArrayList<GeneralProductCommission>();
        for (GeneralProductCommission comm : GeneralProductHelper.getCommissionsFromOldSourceByReflection(prod)) {
            if (comm.getContractType() != type && type != null) continue;
            result.add(comm);
        }
        return result;
    }

    private static List<GeneralProductFop> getFopsFromOldSourceByReflection(BaseProduct prod, ContractType contractType) {
        String propertyName = null;
        switch (contractType) {
            case VENDOR: {
                propertyName = "vendorFops";
                break;
            }
            case SUBAGENCY: {
                propertyName = "subagentFops";
                break;
            }
            case CLIENT: {
                propertyName = "clientFops";
            }
        }
        return (List)prod.getValue(propertyName);
    }

    public static void updateFopsByReflection(BaseProduct product, List<GeneralProductFop> fops, ContractType vendor) {
        if (vendor == ContractType.SUBAGENCY) {
            SalesChain salesChain = GeneralProductHelper.getSalesChainByReflection(product);
            if (((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getPredefinedType() == PredefinedSalesChainType.OWN) {
                salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
            }
        }
        List<GeneralProductContractRelationData> relations = GeneralProductHelper.getContractRelationsByReflection(product);
        for (int n = 0; n < fops.size(); ++n) {
            GeneralProductFop fop = fops.get(n);
            for (GeneralProductContractRelationData item : relations) {
                if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) != vendor) continue;
                GeneralProductHelper.updateFop(item.getFops(), item.getCommissions(), fop, n);
            }
        }
    }

    public static GeneralProductContractRelationData getClientContractRelationByReflection(BaseProduct prod) {
        return GeneralProductHelper.getContractRelation(GeneralProductHelper.getContractRelationsByReflection(prod), ContractType.CLIENT);
    }

    public static GeneralProductContractRelationData getVendorContractRelationByReflection(BaseProduct prod) {
        return GeneralProductHelper.getContractRelation(GeneralProductHelper.getContractRelationsByReflection(prod), ContractType.VENDOR);
    }

    public static GeneralProductContractRelationData getSubagentContractRelationByReflection(BaseProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = GeneralProductHelper.getContractRelation(GeneralProductHelper.getContractRelationsByReflection(prod), ContractType.SUBAGENCY);
        if (relation != null) {
            return relation;
        }
        SalesChain salesChain = GeneralProductHelper.getSalesChainByReflection(prod);
        if (GeneralProductHelper.isOwnPredefinedSalesChainType(((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getPredefinedType())) {
            if (!autoUpdateSalesChain) {
                return null;
            }
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription(PredefinedSalesChainType.SUBAGENT, (EntityReference<SalesChainDescription>)salesChain.getDescription()));
            Contractor contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription(PredefinedContractorType.SUBAGENCY));
            contractor.setContractor(GeneralProductHelper.getContractor(salesChain, PredefinedContractorType.AGENCY));
            List lst = salesChain.getContractors();
            lst.add(lst.size() - 1, contractor);
            relation = GeneralProductHelper.getContractRelation(GeneralProductHelper.getContractRelationsByReflection(prod), ContractType.SUBAGENCY);
            if (relation != null) {
                return relation;
            }
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissionsByReflection(BaseProduct product, ContractType contractType) {
        ArrayList<GeneralProductCommission> filteredCommissions = new ArrayList<GeneralProductCommission>();
        for (GeneralProductContractRelationData relation : GeneralProductHelper.getContractRelationsByReflection(product)) {
            if (contractType != null && GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != contractType) continue;
            filteredCommissions.addAll(relation.getCommissions());
        }
        return filteredCommissions;
    }

    public static void updateAllFOPsByReflection(BaseProduct product, PaymentType pt) {
        BigDecimal totalProductPrice = BigDecimal.ZERO;
        VatAmount price = BookingHelper.calculateProductPrice(product, ContractType.VENDOR);
        if (price != null) {
            totalProductPrice = price.getTotal();
        }
        for (GeneralProductContractRelationData item : GeneralProductHelper.getContractRelationsByReflection(product)) {
            item.getFops().clear();
            GeneralProductFop fop = new GeneralProductFop();
            fop.setEquivalentAmount(totalProductPrice);
            fop.setOperationDate(new Date());
            fop.setType(pt);
            item.getFops().clear();
            item.getFops().add(fop);
        }
    }

    public static EntityReference<Organization> getAgency(BaseProduct prod) {
        return GeneralProductHelper.getContractor(GeneralProductHelper.getHandler(prod).getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static EntityReference<Organization> getSubagency(BaseProduct prod) {
        return GeneralProductHelper.getContractor(GeneralProductHelper.getHandler(prod).getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static EntityReference<Organization> getTechnicalProvider(BaseProduct prod) {
        return GeneralProductHelper.getContractor(GeneralProductHelper.getHandler(prod).getSalesChain(prod), PredefinedContractorType.TECHNICAL_PROVIDER);
    }

    public static EntityReference<Organization> getSupplier(BaseProduct prod) {
        return GeneralProductHelper.getContractor(GeneralProductHelper.getHandler(prod).getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static <T extends BaseProduct> ProductHandler<T> getHandler(T prod) {
        return prod != null ? HandlersRegistry.get().findProductHandler(prod.getClass()) : null;
    }

    public static EntityReference<Organization> getSubagencyOfLastLevel(BaseProduct prod) {
        SalesChain chain = GeneralProductHelper.getHandler(prod).getSalesChain(prod);
        if (chain == null || chain.getDescription() == null) {
            return null;
        }
        EntityReference supplierRef = null;
        EntityContainer ctr = EntityStorage.get().resolve(chain.getDescription());
        for (EntityReference relationDescRef : ((SalesChainDescription)ctr.getEntity()).getContractRelations()) {
            EntityContainer contractorDescCtr;
            EntityContainer relationDescCtr = EntityStorage.get().resolve(relationDescRef);
            if (relationDescCtr == null || ((ContractRelationDescription)relationDescCtr.getEntity()).getCustomer() == null || ((ContractorDescription)(contractorDescCtr = EntityStorage.get().resolve(((ContractRelationDescription)relationDescCtr.getEntity()).getCustomer())).getEntity()).getPredefinedType() != PredefinedContractorType.CLIENT) continue;
            supplierRef = ((ContractRelationDescription)relationDescCtr.getEntity()).getSupplier();
            break;
        }
        return GeneralProductHelper.getContractor(chain, supplierRef);
    }

    public static EntityReference<Person> findFOPAgent(BaseProduct prod) {
        EntityReference vendorAgent = null;
        EntityReference clientAgent = null;
        for (GeneralProductContractRelationData relation : GeneralProductHelper.getHandler(prod).getUnmodifiableContractRelations(prod)) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription());
            for (GeneralProductFop fop : relation.getFops()) {
                if (!GeneralProductHelper.isServiceFop(fop) || fop.getAgent() == null) continue;
                if (contractType == ContractType.VENDOR && vendorAgent == null) {
                    vendorAgent = fop.getAgent();
                }
                if (contractType != ContractType.CLIENT || clientAgent != null) continue;
                clientAgent = fop.getAgent();
            }
        }
        return clientAgent == null ? vendorAgent : clientAgent;
    }

    public static <T extends BaseProduct> void updateAllFOPs(T product, PaymentType pt) {
        BigDecimal totalProductPrice = BigDecimal.ZERO;
        VatAmount price = BookingHelper.calculateProductPrice(product, ContractType.VENDOR);
        if (price != null) {
            totalProductPrice = price.getTotal();
        }
        TicketType ticketType = GeneralProductHelper.getHandler(product).getTicketType(product);
        List<GeneralProductContractRelationData> copy = GeneralProductHelper.copyContractRelations(product);
        for (GeneralProductContractRelationData item : copy) {
            item.getFops().clear();
            if (TicketType.REFERRAL == ticketType) continue;
            GeneralProductFop fop = new GeneralProductFop();
            fop.setEquivalentAmount(totalProductPrice);
            fop.setOperationDate(new Date());
            fop.setType(pt);
            item.getFops().add(fop);
        }
        GeneralProductHelper.getHandler(product).updateContractRelations(product, copy);
    }

    public static <T extends BaseProduct> List<GeneralProductContractRelationData> copyContractRelations(T product) {
        ArrayList<GeneralProductContractRelationData> result = new ArrayList<GeneralProductContractRelationData>();
        for (GeneralProductContractRelationData item : GeneralProductHelper.getHandler(product).getUnmodifiableContractRelations(product)) {
            try {
                result.add((GeneralProductContractRelationData)XCloneHelper.clone((XCloneable)item, (boolean)false));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static <T extends BaseProduct> List<GeneralProductFop> getUnmodifiableFops(T product, ContractType ct) {
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        for (GeneralProductContractRelationData relation : GeneralProductHelper.getHandler(product).getUnmodifiableContractRelations(product)) {
            if (ct != null && GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) != ct) continue;
            result.addAll(relation.getFops());
        }
        return result;
    }

    public static <T extends BaseProduct> void updateFops(T product, ContractType ct, List<GeneralProductFop> fops) {
        List<GeneralProductContractRelationData> relations = GeneralProductHelper.copyContractRelations(product);
        for (GeneralProductContractRelationData item : relations) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) != ct) continue;
            for (int n = 0; n < fops.size(); ++n) {
                GeneralProductFop fop = fops.get(n);
                GeneralProductHelper.updateFop(item.getFops(), item.getCommissions(), fop, n);
            }
        }
        GeneralProductHelper.getHandler(product).updateContractRelations(product, relations);
    }

    public static BigDecimal calculateCommissions(BaseProduct baseProduct, ContractType contractType, Set<Class<? extends BaseCommissionProperties>> props) {
        return GeneralProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissionsByCommissionProperties(GeneralProductHelper.getUnmodifiableCommissions(baseProduct, contractType), props));
    }

    public static Fop findFop(BaseProduct bp) {
        Fop result = GeneralProductHelper.findFop(GeneralProductHelper.getUnmodifiableFops(bp, ContractType.CLIENT));
        if (result == null) {
            result = GeneralProductHelper.findFop(GeneralProductHelper.getUnmodifiableFops(bp, ContractType.SUBAGENCY));
        }
        if (result == null) {
            result = GeneralProductHelper.findFop(GeneralProductHelper.getUnmodifiableFops(bp, ContractType.VENDOR));
        }
        return result;
    }

    public static void updateCommissions(List<GeneralProductCommission> sourceCommissions, List<GeneralProductCommission> targetCommissions) {
        ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
        boolean updateCommissions = sourceCommissions.size() != targetCommissions.size();
        for (GeneralProductCommission generalProductCommission : sourceCommissions) {
            GeneralProductCommission commission = (GeneralProductCommission)CollectionUtil.find(targetCommissions, (String)generalProductCommission.getUid());
            if (commission == null) {
                commission = new GeneralProductCommission();
                updateCommissions = true;
            }
            commissions.add(commission);
            try {
                XCloneModelHelper.copy((BaseEntity)generalProductCommission, (BaseEntity)commission);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
        }
        if (updateCommissions) {
            targetCommissions.clear();
            targetCommissions.addAll(commissions);
        }
    }

    public static void updateContractRelationsByReflection(BaseProduct product, List<GeneralProductContractRelationData> relations) {
        List<GeneralProductContractRelationData> originalRelations = GeneralProductHelper.getContractRelationsByReflection(product);
        if (originalRelations == relations) {
            return;
        }
        GeneralProductHelper.updateContractRelations(originalRelations, relations);
    }

    public static void updateContractRelations(List<GeneralProductContractRelationData> originalRelations, List<GeneralProductContractRelationData> relations) {
        ArrayList<GeneralProductContractRelationData> result = new ArrayList<GeneralProductContractRelationData>();
        boolean updateRelations = originalRelations.size() != relations.size();
        for (GeneralProductContractRelationData generalProductRelation : relations) {
            GeneralProductContractRelationData relation = (GeneralProductContractRelationData)CollectionUtil.find(originalRelations, (String)generalProductRelation.getUid());
            if (relation == null) {
                relation = new GeneralProductContractRelationData();
                relation.setUid(generalProductRelation.getUid());
                relation.setDescription(generalProductRelation.getDescription());
                updateRelations = true;
            }
            result.add(relation);
            try {
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getGeneralData(), (BaseEntity)relation.getGeneralData());
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getServiceData(), (BaseEntity)relation.getServiceData());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"unable to xcopy object", (Throwable)e, (Object[])new Object[0]);
            }
            GeneralProductHelper.updateCommissions(generalProductRelation.getCommissions(), relation.getCommissions());
            ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
            boolean updateFops = generalProductRelation.getFops().size() != relation.getFops().size();
            for (GeneralProductFop generalProductFop : generalProductRelation.getFops()) {
                GeneralProductFop fop = (GeneralProductFop)CollectionUtil.find((Iterable)relation.getFops(), (String)generalProductFop.getUid());
                if (fop == null) {
                    fop = new GeneralProductFop();
                    updateFops = true;
                }
                fops.add(fop);
                try {
                    XCloneModelHelper.copy((BaseEntity)generalProductFop, (BaseEntity)fop);
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to clone entity ", e);
                }
                fop.getCommissions().clear();
                for (GeneralProductCommission generalProductCommission : generalProductFop.getCommissions()) {
                    GeneralProductCommission commission = (GeneralProductCommission)BookingHelper.findEntityByUid(relation.getCommissions(), generalProductCommission.getUid());
                    if (commission == null) continue;
                    fop.getCommissions().add(commission);
                }
            }
            if (!updateFops) continue;
            relation.getFops().clear();
            relation.getFops().addAll(fops);
        }
        if (updateRelations) {
            originalRelations.clear();
            originalRelations.addAll(result);
        }
    }

    public static boolean isHiddenFee(GeneralProductCommission comm) {
        EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
        return ctr != null && ctr.getEntity() instanceof FeeProperties && ((FeeProperties)ctr.getEntity()).isHidden();
    }

    public static boolean isServiceFop(GeneralProductFop fop) {
        boolean hasNotHiddenFee = false;
        for (GeneralProductCommission comm : fop.getCommissions()) {
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof FeeProperties)) {
                hasNotHiddenFee = true;
                break;
            }
            FeeProperties feeProp = (FeeProperties)ctr.getEntity();
            if (feeProp.isHidden()) continue;
            hasNotHiddenFee = true;
        }
        return !hasNotHiddenFee;
    }

    public static boolean isPaymentFop(GeneralProductFop fop) {
        return fop.getCommissions().stream().anyMatch(c -> c.getCommissionProperties() != null && PaymentFeeProperties.class.isAssignableFrom(c.getCommissionProperties().getType())) || fop.getCommissions().stream().allMatch(c -> c.getCommissionProperties() == null);
    }

    public static boolean isHiddenFee(EntityReference<? extends BaseCommissionProperties> prop) {
        EntityContainer ctr = EntityStorage.get().resolve(prop);
        if (ctr == null || !(ctr.getEntity() instanceof FeeProperties)) {
            return false;
        }
        FeeProperties feeProp = (FeeProperties)ctr.getEntity();
        return feeProp.isHidden();
    }

    public static boolean isStandartFee(EntityReference<? extends BaseCommissionProperties> prop) {
        EntityContainer ctr = EntityStorage.get().resolve(prop);
        if (ctr == null || !(ctr.getEntity() instanceof FeeProperties)) {
            return false;
        }
        FeeProperties feeProp = (FeeProperties)ctr.getEntity();
        return !feeProp.isHidden();
    }

    public static boolean isTechFee(EntityReference<? extends BaseCommissionProperties> prop) {
        if (prop == null || !FeeProperties.class.isAssignableFrom(prop.getType())) {
            return false;
        }
        EntityContainer ctr = EntityStorage.get().resolve(prop);
        if (ctr == null) {
            return false;
        }
        FeeProperties feeProp = (FeeProperties)ctr.getEntity();
        return feeProp.getCategory() != null && "TECHNICAL_FEE".equals(feeProp.getCategory().getCode());
    }

    public static List<GeneralProductCommission> getVendorCommissions(BaseProduct product) {
        return GeneralProductHelper.getCommissions(product, ContractType.VENDOR);
    }

    public static List<GeneralProductCommission> getSubagentCommissions(BaseProduct product) {
        return GeneralProductHelper.getCommissions(product, ContractType.SUBAGENCY);
    }

    public static List<GeneralProductCommission> getClientCommissions(BaseProduct product) {
        return GeneralProductHelper.getCommissions(product, ContractType.CLIENT);
    }

    public static List<GeneralProductCommission> getCommissions(BaseProduct product, ContractType contractType) {
        GeneralProductContractRelationData relation = GeneralProductHelper.getContractRelation(product, contractType);
        return relation != null ? relation.getCommissions() : Collections.emptyList();
    }

    public static List<GeneralProductFop> getVendorFops(BaseProduct product) {
        return GeneralProductHelper.getFops(product, ContractType.VENDOR);
    }

    public static List<GeneralProductFop> getSubagentFops(BaseProduct product) {
        return GeneralProductHelper.getFops(product, ContractType.SUBAGENCY);
    }

    public static List<GeneralProductFop> getClientFops(BaseProduct product) {
        return GeneralProductHelper.getFops(product, ContractType.CLIENT);
    }

    public static List<GeneralProductFop> getFops(BaseProduct product, ContractType contractType) {
        GeneralProductContractRelationData relation = GeneralProductHelper.getContractRelation(product, contractType);
        return relation != null ? relation.getFops() : Collections.emptyList();
    }

    public static GeneralProductContractRelationData getVendorContractRelation(BaseProduct product) {
        return GeneralProductHelper.getContractRelation(product, ContractType.VENDOR);
    }

    public static GeneralProductContractRelationData getTechnicalProviderContractRelation(BaseProduct product) {
        return GeneralProductHelper.getContractRelation(product, ContractType.TECHNICAL_PROVIDER);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(BaseProduct product) {
        return GeneralProductHelper.getContractRelation(product, ContractType.SUBAGENCY);
    }

    public static GeneralProductContractRelationData getClientContractRelation(BaseProduct product) {
        return GeneralProductHelper.getContractRelation(product, ContractType.CLIENT);
    }

    public static GeneralProductContractRelationData getContractRelation(BaseProduct product, ContractType contractType) {
        ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(product);
        return handler == null ? null : GeneralProductHelper.getContractRelation(handler.getUnmodifiableContractRelations(product), contractType);
    }

    public static GeneralProductContractRelationData getContractRelation(List<GeneralProductContractRelationData> contractRelations, ContractType contractType) {
        return contractRelations.stream().filter(relation -> GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)relation.getDescription()) == contractType).findFirst().orElse(null);
    }

    public static Optional<Contract> getContract(BaseProduct product, ContractType contractType) {
        return GeneralProductHelper.getContract(product, contractType, null);
    }

    public static Optional<Contract> getContract(BaseProduct product, ContractType contractType, EntityStorageContext entityStorageContext) {
        return GeneralProductHelper.getContract((BaseContractRelationData)GeneralProductHelper.getContractRelation(product, contractType), entityStorageContext);
    }

    public static Optional<Contract> getContract(BaseContractRelationData contractRelationData) {
        return GeneralProductHelper.getContract(contractRelationData, null);
    }

    public static Optional<Contract> getContract(BaseContractRelationData contractRelationData, EntityStorageContext entityStorageContext) {
        return Optional.ofNullable(contractRelationData).map(BaseContractRelationData::getGeneralData).map(ContractRelationGeneralData::getContractData).map(ContractRelationContractData::getContract).map(item -> entityStorageContext == null ? EntityStorage.get().resolve(item) : EntityStorageHelper.resolve((EntityReference)item, (EntityStorageContext)entityStorageContext)).map(EntityContainer::getEntity);
    }

    public static Collection<MiscUtil.Pair<FopType, BigDecimal>> getFopTypeAmounts(GeneralProductFop fop, boolean strict) {
        ArrayList<MiscUtil.Pair<FopType, BigDecimal>> fopTypeAmounts = new ArrayList<MiscUtil.Pair<FopType, BigDecimal>>();
        FopType fopType = GeneralProductHelper.getFopType(fop);
        if (fopType == FopType.PRODUCT) {
            if (strict) {
                BigDecimal hiddenFeeAmount = GeneralProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(fop.getCommissions(), serviceFeePropertyTypes, null, hiddenCommissionCategories));
                if (hiddenFeeAmount != null && hiddenFeeAmount.compareTo(BigDecimal.ZERO) != 0) {
                    fopTypeAmounts.add((MiscUtil.Pair<FopType, BigDecimal>)new MiscUtil.Pair((Object)FopType.PRODUCT, (Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{fop.getEquivalentAmount(), MiscUtil.negate((BigDecimal)hiddenFeeAmount)})));
                    fopTypeAmounts.add((MiscUtil.Pair<FopType, BigDecimal>)new MiscUtil.Pair((Object)FopType.SERVICE, (Object)hiddenFeeAmount));
                } else {
                    fopTypeAmounts.add((MiscUtil.Pair<FopType, BigDecimal>)new MiscUtil.Pair((Object)FopType.PRODUCT, (Object)fop.getEquivalentAmount()));
                }
            } else {
                fopTypeAmounts.add(new MiscUtil.Pair((Object)FopType.PRODUCT, (Object)fop.getEquivalentAmount()));
            }
        } else {
            fopTypeAmounts.add(new MiscUtil.Pair((Object)fopType, (Object)fop.getEquivalentAmount()));
        }
        return fopTypeAmounts;
    }

    public static ProductStatus getStatus(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getStatus(product);
    }

    public static void setStatus(BaseProduct product, ProductStatus status) {
        GeneralProductHelper.getHandler(product).setStatus(product, status);
    }

    public static BigDecimal getEquivalentFare(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getEquivalentFare(product);
    }

    public static List<GeneralProductTax> getTaxes(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getTaxes(product);
    }

    public static VatAmount calculateProductPrice(BaseProduct product, ContractType contractType) {
        return GeneralProductHelper.getHandler(product).calculateProductPrice(product, contractType);
    }

    public static BigDecimal getAddCollect(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getAddCollect(product);
    }

    public static List<GeneralProductContractRelationData> getUnmodifiableContractRelations(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getUnmodifiableContractRelations(product);
    }

    public static String getSystemNumber(BaseProduct product) {
        List<String> numbers = GeneralProductHelper.getHandler(product).getProductNumbers(product);
        return numbers.isEmpty() ? null : (String)numbers.iterator().next();
    }

    public static boolean isChecked(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).isChecked(product);
    }

    public static List<ValidationMessage> getValidationMessages(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getValidationMessages(product);
    }

    public static EntityReference<Organization> getBlankOwner(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getBlankOwner(product);
    }

    public static EntityReference<SalesPoint> getSalesPoint(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).findSalesPoint(product);
    }

    public static Traveller getTraveller(BaseProduct product) {
        Collection<Traveller> travellers = GeneralProductHelper.getTravellers(product);
        return travellers.isEmpty() ? null : travellers.iterator().next();
    }

    public static Collection<Traveller> getTravellers(BaseProduct product) {
        return GeneralProductHelper.getHandler(product).getTravellers(product);
    }

    public static BigDecimal getEquivalentTaxesAmountByCodes(Collection<SimpleTax> taxes, boolean include, String ... taxCodes) {
        return GeneralProductHelper.getEquivalentTaxesAmount(GeneralProductHelper.getTaxesByCodes(taxes, include, taxCodes));
    }

    public static BigDecimal getEquivalentTaxesAmount(Collection<SimpleTax> taxes) {
        BigDecimal tx = BigDecimal.ZERO;
        for (SimpleTax tax : taxes) {
            BigDecimal value = tax.getAmount();
            if (value == null) continue;
            tx = tx.add(value);
        }
        return tx;
    }

    public static Collection<SimpleTax> getTaxesByCodes(Collection<SimpleTax> taxes, boolean include, String ... taxCodes) {
        if (taxes == null) {
            return Collections.emptyList();
        }
        if (taxCodes == null || taxCodes.length == 0) {
            return include ? Collections.emptyList() : taxes;
        }
        ArrayList<SimpleTax> result = new ArrayList<SimpleTax>();
        HashSet<String> codes = new HashSet<String>();
        for (String taxCode : taxCodes) {
            if (taxCode == null) continue;
            codes.add(taxCode.toUpperCase());
        }
        for (SimpleTax tax : taxes) {
            String taxCode = tax.getCode();
            if (TextUtil.isBlank((String)taxCode)) {
                taxCode = "FAKE_TAX_CODE";
            }
            if (codes.contains(taxCode.toUpperCase())) {
                if (!include) continue;
                result.add(tax);
                continue;
            }
            if (include) continue;
            result.add(tax);
        }
        return result;
    }

    public static <T extends BaseProduct> Date getOperationDate(T product) {
        T operationProduct = null;
        ProductHandler<T> ph = GeneralProductHelper.getHandler(product);
        ProductStatus productStatus = ph.getStatus(product);
        if (ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus) {
            operationProduct = ph.getPreviousProduct(product);
        }
        if (null == operationProduct) {
            operationProduct = product;
        }
        return GeneralProductHelper.getProductDate(operationProduct);
    }

    public static <T extends BaseProduct> Date getProductDate(T product) {
        ProductHandler<T> ph = GeneralProductHelper.getHandler(product);
        Date operationDate = ph.findIssueDate(product);
        if (operationDate != null) {
            return operationDate;
        }
        if (product.getReservation() != null && (operationDate = product.getReservation().getResDate()) != null) {
            return operationDate;
        }
        return new Date();
    }

    public static <T extends BaseProduct> void updateServiceData(T product, BaseContractRelationData contractRelation, RelationData last) {
        Map<SimpleTax, SimpleTax> t2t;
        ContractRelationServiceDataDetalization prevSellDetalization;
        RelationData prevSellLast;
        ExchangeRateData prevSellRateData;
        GeneralProductContractRelationData prevSellRelation;
        ContractRelationGeneralData generalData = contractRelation.getGeneralData();
        ContractRelationServiceData serviceData = contractRelation.getServiceData();
        ContractRelationServiceDataDetalization detalization = serviceData.getDetalization();
        generalData.setCalculationDate(new Date());
        ProductHandler<T> ph = GeneralProductHelper.getHandler(product);
        ProductStatus productStatus = ph.getStatus(product);
        boolean refundOrExchange = ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus || ProductStatus.REJECT == productStatus;
        T previousProduct = ph.getPreviousProduct(product);
        boolean isFareFopsRelevant = last.isFareFopsRelevant();
        String currency = generalData.getCurrency() != null ? generalData.getCurrency().getCode() : DictHelper.getLocalCurrency();
        boolean tariffRate = !isFareFopsRelevant && !last.getFareCurrency().equals(last.getCurrency());
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRelation.getDescription());
        ExchangeRateData rateData = tariffRate ? MulticurrencyHelper.buildExchangeRateData(last.getFareCurrency(), currency, MulticurrencyHelper.buildExchangeRateCondition(generalData.getRate()), GeneralProductHelper.getProductDate(product), GeneralProductHelper.getSupplier(product), false) : (product.getPaymentCurrencies().containsKey(contractType) ? (ExchangeRateData)product.getPaymentCurrencies().get(GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRelation.getDescription())) : generalData.getRate());
        BaseProduct previousSellProduct = previousProduct != null && ph.getStatus(previousProduct) == ProductStatus.EXCHANGE && rateData != null ? (BaseProduct)ph.getPreviousProduct(previousProduct) : null;
        GeneralProductContractRelationData generalProductContractRelationData = prevSellRelation = previousSellProduct != null ? GeneralProductHelper.findContractRelation(ph.getUnmodifiableContractRelations(previousSellProduct), (EntityReference<ContractRelationDescription>)contractRelation.getDescription()) : null;
        ExchangeRateData exchangeRateData = prevSellRelation != null ? (tariffRate ? MulticurrencyHelper.buildExchangeRateData(last.getFareCurrency(), currency, MulticurrencyHelper.buildExchangeRateCondition(prevSellRelation.getGeneralData().getRate()), GeneralProductHelper.getProductDate(previousSellProduct), GeneralProductHelper.getSupplier(previousSellProduct), false) : prevSellRelation.getGeneralData().getRate()) : (prevSellRateData = null);
        if (null == prevSellRateData) {
            previousSellProduct = previousProduct;
            GeneralProductContractRelationData generalProductContractRelationData2 = prevSellRelation = refundOrExchange && previousSellProduct != null ? GeneralProductHelper.findContractRelation(ph.getUnmodifiableContractRelations(previousSellProduct), (EntityReference<ContractRelationDescription>)contractRelation.getDescription()) : null;
            ExchangeRateData exchangeRateData2 = prevSellRelation != null ? (tariffRate ? MulticurrencyHelper.buildExchangeRateData(last.getFareCurrency(), currency, MulticurrencyHelper.buildExchangeRateCondition(prevSellRelation.getGeneralData().getRate()), GeneralProductHelper.getProductDate(previousSellProduct), GeneralProductHelper.getSupplier(previousSellProduct), false) : prevSellRelation.getGeneralData().getRate()) : (prevSellRateData = null);
            if (null == prevSellRateData) {
                detalization.setFare(MulticurrencyHelper.convert(last.getFare(), rateData));
                detalization.getTaxes().clear();
                for (SimpleTax tax : last.getTaxes()) {
                    SimpleTax newTax = new SimpleTax();
                    newTax.setCode(tax.getCode());
                    newTax.setAmount(MulticurrencyHelper.convert(tax.getAmount(), rateData));
                    newTax.setSource(tax.getSource());
                    detalization.getTaxes().add(newTax);
                }
                detalization.setAdditionalFee(MulticurrencyHelper.convert(last.getAdditionalFee(), rateData));
                detalization.setObFees(MulticurrencyHelper.convert(last.getObFees(), rateData));
            } else {
                prevSellLast = GeneralProductHelper.getPrevLast(ph, contractRelation, previousSellProduct);
                prevSellDetalization = prevSellRelation.getServiceData().getDetalization();
                detalization.setFare(GeneralProductHelper.calculateRefundSum(prevSellLast.getFare(), prevSellRateData, last.getFare(), prevSellDetalization.getFare()));
                detalization.getTaxes().clear();
                if (!last.getTaxes().isEmpty()) {
                    t2t = GeneralProductHelper.getTax2PrevTax(product, prevSellLast, last);
                    Map<String, List<SimpleTax>> lastTaxes = last.getTaxes().stream().collect(Collectors.groupingBy(SimpleTax::getCode));
                    for (Map.Entry<String, List<SimpleTax>> entry : lastTaxes.entrySet()) {
                        List<SimpleTax> taxes = entry.getValue();
                        if (taxes.size() == 1) {
                            SimpleTax tax = taxes.get(0);
                            SimpleTax newTax = new SimpleTax();
                            newTax.setCode(tax.getCode());
                            SimpleTax prevTax = t2t.get(tax);
                            if (prevTax != null) {
                                BigDecimal prevTaxAmount = prevTax.getSource() != null ? (BigDecimal)prevSellDetalization.getTaxes().stream().filter(t -> prevTax.getSource().equals(t.getSource())).map(SimpleTax::getAmount).findFirst().orElse(null) : null;
                                newTax.setAmount(GeneralProductHelper.calculateRefundSum(prevTax.getAmount(), prevSellRateData, tax.getAmount(), prevTaxAmount));
                            } else {
                                newTax.setAmount(MulticurrencyHelper.convert(tax.getAmount(), prevSellRateData));
                            }
                            newTax.setSource(tax.getSource());
                            detalization.getTaxes().add(newTax);
                            continue;
                        }
                        for (SimpleTax tax : taxes) {
                            SimpleTax newTax = new SimpleTax();
                            newTax.setCode(tax.getCode());
                            newTax.setAmount(MulticurrencyHelper.convert(tax.getAmount(), prevSellRateData));
                            newTax.setSource(tax.getSource());
                            detalization.getTaxes().add(newTax);
                        }
                    }
                }
                detalization.setAdditionalFee(GeneralProductHelper.calculateRefundSum(prevSellLast.getAdditionalFee(), prevSellRateData, last.getAdditionalFee(), prevSellDetalization.getAdditionalFee()));
                detalization.setObFees(GeneralProductHelper.calculateRefundSum(prevSellLast.getObFees(), prevSellRateData, last.getObFees(), prevSellDetalization.getObFees()));
            }
        } else {
            prevSellLast = GeneralProductHelper.getPrevLast(ph, contractRelation, previousSellProduct);
            prevSellDetalization = prevSellRelation.getServiceData().getDetalization();
            detalization.setFare(GeneralProductHelper.calculateExchangeSum(prevSellLast.getFare(), prevSellRateData, last.getFare(), rateData, prevSellDetalization.getFare()));
            detalization.getTaxes().clear();
            if (!last.getTaxes().isEmpty()) {
                t2t = GeneralProductHelper.getTax2PrevTax(product, prevSellLast, last);
                Map<String, List<SimpleTax>> lastTaxes = last.getTaxes().stream().collect(Collectors.groupingBy(SimpleTax::getCode));
                for (Map.Entry<String, List<SimpleTax>> entry : lastTaxes.entrySet()) {
                    List<SimpleTax> taxes = entry.getValue();
                    if (taxes.size() == 1) {
                        SimpleTax tax = taxes.get(0);
                        SimpleTax newTax = new SimpleTax();
                        newTax.setCode(tax.getCode());
                        SimpleTax prevTax = t2t.get(tax);
                        if (prevTax != null) {
                            BigDecimal prevTaxAmount = prevTax.getSource() != null ? (BigDecimal)prevSellDetalization.getTaxes().stream().filter(t -> prevTax.getSource().equals(t.getSource())).map(SimpleTax::getAmount).findFirst().orElse(null) : null;
                            newTax.setAmount(GeneralProductHelper.calculateExchangeSum(prevTax.getAmount(), prevSellRateData, tax.getAmount(), rateData, prevTaxAmount));
                        } else {
                            newTax.setAmount(MulticurrencyHelper.convert(tax.getAmount(), rateData));
                        }
                        newTax.setSource(tax.getSource());
                        detalization.getTaxes().add(newTax);
                        continue;
                    }
                    for (SimpleTax tax : taxes) {
                        SimpleTax newTax = new SimpleTax();
                        newTax.setCode(tax.getCode());
                        newTax.setAmount(MulticurrencyHelper.convert(tax.getAmount(), rateData));
                        newTax.setSource(tax.getSource());
                        detalization.getTaxes().add(newTax);
                    }
                }
            }
            detalization.setAdditionalFee(GeneralProductHelper.calculateExchangeSum(prevSellLast.getAdditionalFee(), prevSellRateData, last.getAdditionalFee(), rateData, prevSellDetalization.getAdditionalFee()));
            detalization.setObFees(GeneralProductHelper.calculateExchangeSum(prevSellLast.getObFees(), prevSellRateData, last.getObFees(), rateData, prevSellDetalization.getObFees()));
        }
        detalization.setPenalty(MulticurrencyHelper.convert(last.getPenalty(), rateData));
        detalization.setPenaltyWithMcoValue(MulticurrencyHelper.convert(last.getPenaltyWithMcoValue(), rateData));
        detalization.setDeduction(MulticurrencyHelper.convert(last.getDeduction(), rateData));
        if (!last.getPenalties().isEmpty() || !last.getCancellationPenalties().isEmpty()) {
            ContractRelationPenaltiesDetalization penalties = detalization.getPenalties();
            if (null == penalties) {
                penalties = new ContractRelationPenaltiesDetalization();
                detalization.setPenalties(penalties);
            } else {
                penalties.getPenalties().clear();
                penalties.getCancellationPenalties().clear();
            }
            UnaryOperator convert = p -> {
                Penalty info = new Penalty();
                BigDecimal amount = MulticurrencyHelper.convert(p.getAmount(), rateData);
                info.setAmount(amount);
                if (currency.equals(last.getCurrency())) {
                    info.setVatAmount(p.getVatAmount());
                } else if (p.getVatRate() != null) {
                    VatAmount vatAmount = VatAmount.of((BigDecimal)amount, (double)p.getVatRate());
                    info.setVatAmount(vatAmount.getVatAmount());
                }
                info.setVatRate(p.getVatRate());
                info.setSource(p.getSource());
                return info;
            };
            last.getPenalties().stream().filter(Objects::nonNull).map(convert).forEach(penalties.getPenalties()::add);
            last.getCancellationPenalties().stream().filter(Objects::nonNull).map(convert).forEach(penalties.getCancellationPenalties()::add);
        } else {
            detalization.setPenalties(null);
        }
        if (!last.getAdditionalServices().isEmpty()) {
            ContractRelationAdditionalServicesDetalization additionalServices = detalization.getAdditionalServices();
            if (null == additionalServices) {
                additionalServices = new ContractRelationAdditionalServicesDetalization();
                detalization.setAdditionalServices(additionalServices);
            } else {
                additionalServices.getAdditionalServices().clear();
            }
            last.getAdditionalServices().stream().map(as -> {
                AdditionalService info = new AdditionalService();
                BigDecimal amount = MulticurrencyHelper.convert(as.getAmount(), rateData);
                info.setAmount(amount);
                if (currency.equals(last.getCurrency())) {
                    info.setVatAmount(as.getVatAmount());
                } else if (as.getVatRate() != null) {
                    VatAmount vatAmount = VatAmount.of((BigDecimal)amount, (double)as.getVatRate());
                    info.setVatAmount(vatAmount.getVatAmount());
                }
                info.setVatRate(as.getVatRate());
                info.setSource(as.getSource());
                return info;
            }).forEach(additionalServices.getAdditionalServices()::add);
        } else {
            detalization.setAdditionalServices(null);
        }
        GeneralProductHelper.processVat(product, contractRelation, last);
        BigDecimal taxSum = detalization.getTaxes().stream().map(SimpleTax::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal subtotal = detalization.getFare().add(detalization.getAdditionalFee()).add(taxSum).add(detalization.getObFees());
        BigDecimal paymentPrice = last.isFareFopsRelevant() ? detalization.getFare().add(detalization.getAdditionalFee()).add(taxSum).add(detalization.getObFees()) : BigDecimal.ZERO;
        subtotal = refundOrExchange ? subtotal.subtract(detalization.getPenalty()) : subtotal.add(detalization.getPenalty());
        BigDecimal bigDecimal = paymentPrice = refundOrExchange ? paymentPrice.subtract(detalization.getPenalty()) : paymentPrice.add(detalization.getPenalty());
        if (detalization.getDeduction() != null) {
            subtotal = refundOrExchange ? subtotal.subtract(detalization.getDeduction()) : subtotal.add(detalization.getDeduction());
            paymentPrice = refundOrExchange ? paymentPrice.subtract(detalization.getDeduction()) : paymentPrice.add(detalization.getDeduction());
        }
        serviceData.setTotalPrice(subtotal);
        serviceData.setPaymentPrice(paymentPrice);
    }

    private static <T extends BaseProduct> RelationData getPrevLast(ProductHandler<T> ph, BaseContractRelationData contractRelation, T previousSellProduct) {
        RelationData prevSellLast = new RelationData(previousSellProduct);
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRelation.getDescription());
        if (contractType != ContractType.VENDOR) {
            for (GeneralProductContractRelationData prevRelation : ph.getUnmodifiableContractRelations(previousSellProduct)) {
                if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)prevRelation.getDescription()) == contractType) break;
                prevSellLast = new RelationData((BaseContractRelationData)prevRelation, prevSellLast);
            }
        }
        return prevSellLast;
    }

    private static <T extends BaseProduct> boolean isPenaltyTax(T product, String taxCode) {
        if (!(product instanceof Product)) {
            return false;
        }
        return AirProductHelper.isPenaltyTax((DictionaryReference<Airline>)((Product)product).getCarrier(), taxCode);
    }

    private static <T extends BaseProduct> Map<SimpleTax, SimpleTax> getTax2PrevTax(T product, RelationData prevSellLast, RelationData last) {
        HashMap<SimpleTax, SimpleTax> t2t = new HashMap<SimpleTax, SimpleTax>();
        ArrayList<SimpleTax> pool = new ArrayList<SimpleTax>(prevSellLast.getTaxes());
        ArrayList<SimpleTax> toProcess = new ArrayList<SimpleTax>();
        last.getTaxes().stream().filter(t -> t.getCode() != null && t.getAmount() != null && !GeneralProductHelper.isPenaltyTax(product, t.getCode())).forEach(toProcess::add);
        toProcess.removeIf(tax -> {
            BigDecimal taxAmount = MiscUtil.guarded((BigDecimal)tax.getAmount());
            SimpleTax prevLastTax = pool.stream().filter(t -> tax.getCode().equals(t.getCode()) && taxAmount.compareTo(MiscUtil.guarded((BigDecimal)t.getAmount())) == 0).findFirst().orElse(null);
            if (prevLastTax != null) {
                t2t.put((SimpleTax)tax, prevLastTax);
                pool.remove(prevLastTax);
                return true;
            }
            return false;
        });
        for (SimpleTax tax2 : toProcess) {
            BigDecimal taxAmount = MiscUtil.guarded((BigDecimal)tax2.getAmount());
            SimpleTax prevLastTax = pool.stream().filter(t -> tax2.getCode().equals(t.getCode()) && taxAmount.compareTo(MiscUtil.guarded((BigDecimal)t.getAmount())) > 0).findFirst().orElse(null);
            if (null == prevLastTax) {
                prevLastTax = pool.stream().filter(t -> tax2.getCode().equals(t.getCode())).findFirst().orElse(null);
            }
            if (prevLastTax == null) continue;
            t2t.put(tax2, prevLastTax);
            pool.remove(prevLastTax);
        }
        return t2t;
    }

    private static BigDecimal calculateExchangeSum(BigDecimal prevLastAmount, ExchangeRateData prevRateData, BigDecimal lastAmount, ExchangeRateData rateData, BigDecimal prevConvertedAmount) {
        BigDecimal safePrevLastAmount = MiscUtil.guarded((BigDecimal)prevLastAmount);
        BigDecimal safeLastAmount = MiscUtil.guarded((BigDecimal)lastAmount);
        BigDecimal pay = safeLastAmount.subtract(safePrevLastAmount);
        if (pay.compareTo(BigDecimal.ZERO) > 0) {
            return (prevConvertedAmount != null ? prevConvertedAmount : MulticurrencyHelper.convert(safePrevLastAmount, prevRateData)).add(MulticurrencyHelper.convert(pay, rateData));
        }
        return prevConvertedAmount != null ? prevConvertedAmount : MulticurrencyHelper.convert(safePrevLastAmount, prevRateData);
    }

    private static BigDecimal calculateRefundSum(BigDecimal prevLastAmount, ExchangeRateData prevRateData, BigDecimal lastAmount, BigDecimal prevConvertedAmount) {
        BigDecimal safePrevLastAmount = MiscUtil.guarded((BigDecimal)prevLastAmount);
        BigDecimal safeLastAmount = MiscUtil.guarded((BigDecimal)lastAmount);
        if (prevConvertedAmount != null && safePrevLastAmount.compareTo(safeLastAmount) == 0) {
            return prevConvertedAmount;
        }
        BigDecimal toReturn = MulticurrencyHelper.convert(safePrevLastAmount.min(safeLastAmount), prevRateData);
        return prevConvertedAmount != null ? prevConvertedAmount.min(toReturn) : toReturn;
    }

    private static <T extends BaseProduct> void processVat(T product, BaseContractRelationData contractRelation, RelationData last) {
        ContractRelationAdditionalServicesDetalization additionalServices;
        ContractRelationPenaltiesDetalization penalties;
        boolean refundOrExchange;
        Organization customer;
        ContractRelationServiceDataDetalization detalization = contractRelation.getServiceData().getDetalization();
        detalization.setCorrectVat(null);
        ContractRelationVatDetalization vat = detalization.getVat();
        if (null == vat) {
            vat = new ContractRelationVatDetalization();
        } else {
            vat.getComponents().clear();
        }
        detalization.setVat(null);
        ContractRelationGeneralData generalData = contractRelation.getGeneralData();
        EntityContainer lastContractCtr = EntityStorage.get().resolve(last.getContract());
        EntityReference description = contractRelation.getDescription();
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)description);
        EntityReference contractRef = generalData.getContractData().getContract();
        EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
        boolean transfer = null == lastContractCtr || ((Contract)lastContractCtr.getEntity()).getAgreementType() == null || ((Contract)lastContractCtr.getEntity()).getAgreementType() == AgreementType.AGENCY_CONTRACT || null == contractCtr || ((Contract)contractCtr.getEntity()).getAgreementType() == null || ((Contract)contractCtr.getEntity()).getAgreementType() == AgreementType.AGENCY_CONTRACT;
        ContractRelationVatDetalization lastVat = last.getVat();
        List<VatCalculationData> vatCalculationData = VatRulesHelper.applyVatCalculationRules(product, (EntityContainer<Contract>)contractCtr);
        if (vatCalculationData != null && !vatCalculationData.isEmpty() && lastVat != null && !lastVat.getComponents().isEmpty()) {
            VatComponent penaltyComponent;
            Double penaltyVatRate;
            Double serviceVatRate;
            GeneralProductHelper.copyVatComponents(lastVat.getComponents(), vat.getComponents(), last, contractRelation, vatCalculationData);
            detalization.setVat(vat);
            VatComponent serviceComponent = vat.getComponents().stream().filter(c -> c.getBasisTypes().contains(VatBasisType.SERVICE)).findFirst().orElse(null);
            Double d = serviceVatRate = serviceComponent != null ? serviceComponent.getRate() : null;
            if (detalization.getAdditionalServices() != null) {
                detalization.getAdditionalServices().getAdditionalServices().forEach(as -> {
                    as.setVatRate(serviceVatRate);
                    if (serviceVatRate == null) {
                        as.setVatAmount(null);
                    } else {
                        VatAmount vatAmount = VatAmount.of((BigDecimal)as.getAmount(), (double)serviceVatRate);
                        as.setVatAmount(vatAmount.getVatAmount());
                    }
                });
            }
            Double d2 = penaltyVatRate = (penaltyComponent = (VatComponent)vat.getComponents().stream().filter(c -> c.getBasisTypes().contains(VatBasisType.PENALTY)).findFirst().orElse(null)) != null ? penaltyComponent.getRate() : null;
            if (detalization.getPenalties() != null) {
                detalization.getPenalties().getPenalties().forEach(penalty -> {
                    penalty.setVatRate(penaltyVatRate);
                    if (penaltyVatRate == null) {
                        penalty.setVatAmount(null);
                    } else {
                        VatAmount vatAmount = VatAmount.of((BigDecimal)penalty.getAmount(), (double)penaltyVatRate);
                        penalty.setVatAmount(vatAmount.getVatAmount());
                    }
                });
            }
            return;
        }
        boolean clearVat = false;
        ProductHandler<T> ph = GeneralProductHelper.getHandler(product);
        SalesChain salesChain = ph.getSalesChain(product);
        if (!transfer) {
            EntityReference<Organization> supplierRef = GeneralProductHelper.getContractRelationSupplier((EntityReference<ContractRelationDescription>)description, salesChain);
            EntityContainer supplierCtr = EntityStorage.get().resolve(supplierRef);
            if (supplierCtr != null) {
                clearVat = ((Organization)supplierCtr.getEntity()).isSimpleTaxed();
            }
        }
        if (clearVat) {
            ContractRelationAdditionalServicesDetalization additionalServices2;
            ContractRelationPenaltiesDetalization penalties2 = detalization.getPenalties();
            if (penalties2 != null) {
                Consumer<Penalty> func = p -> {
                    p.setVatAmount(null);
                    p.setVatRate(null);
                };
                penalties2.getPenalties().forEach(func);
                penalties2.getCancellationPenalties().forEach(func);
            }
            if ((additionalServices2 = detalization.getAdditionalServices()) != null) {
                additionalServices2.getAdditionalServices().forEach(as -> {
                    as.setVatAmount(null);
                    as.setVatRate(null);
                });
            }
            return;
        }
        EntityReference customerRef = ContractType.CLIENT == contractType ? (product.getReservation() != null && product.getReservation().getBookingFile() != null ? product.getReservation().getBookingFile().getCustomerProfile() : null) : GeneralProductHelper.getContractRelationCustomer((EntityReference<ContractRelationDescription>)description, salesChain);
        boolean customerHasVat = true;
        boolean customerHasVatExemption = false;
        EntityContainer customerCtr = EntityStorage.get().resolve(customerRef);
        if (!(customerCtr == null || ProfileHelper.isRetailProfile((EntityContainer<Organization>)customerCtr) || !(customerHasVatExemption = (customer = (Organization)customerCtr.getEntity()).isVATExemption()) || null != contractCtr && ((Contract)contractCtr.getEntity()).isVATExemption())) {
            transfer = true;
        }
        if (transfer) {
            if (lastVat != null && !lastVat.getComponents().isEmpty()) {
                GeneralProductHelper.copyVatComponents(lastVat.getComponents(), vat.getComponents(), last, contractRelation);
                detalization.setVat(vat);
            }
            return;
        }
        boolean customerPenaltyUnderVat = customerCtr != null && ((Organization)customerCtr.getEntity()).isPenaltyUnderVAT();
        ProductStatus productStatus = ph.getStatus(product);
        boolean bl = refundOrExchange = ProductStatus.REFUND == productStatus || ProductStatus.EXCHANGE == productStatus;
        if (!customerHasVatExemption) {
            ContractRelationAdditionalServicesDetalization additionalServices3;
            ContractRelationPenaltiesDetalization penalties3;
            BigDecimal af;
            BigDecimal deduction;
            BigDecimal penalty2;
            BigDecimal fare;
            if (lastVat != null) {
                GeneralProductHelper.copyVatComponents(lastVat.getComponents(), vat.getComponents(), last, contractRelation);
            }
            BigDecimal correct = BigDecimal.ZERO;
            double defaultRate = MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(GeneralProductHelper.getProductDate(product))).doubleValue();
            BigDecimal rate = BigDecimal.valueOf(defaultRate);
            BigDecimal hundred = new BigDecimal(100);
            if (vat.getComponents().stream().noneMatch(c -> c.getBasisTypes().contains(VatBasisType.FARE)) && BigDecimal.ZERO.compareTo(fare = detalization.getFare()) != 0) {
                BigDecimal fareVat = fare.multiply(hundred.add(rate)).divide(hundred, 2, RoundingMode.HALF_UP).subtract(fare);
                fare = fare.add(fareVat);
                correct = correct.add(fareVat);
                detalization.setFare(fare);
                vat.getComponents().add(GeneralProductHelper.createVatComponent(VatBasisType.FARE, fare, defaultRate, fareVat));
            }
            if (customerPenaltyUnderVat && vat.getComponents().stream().noneMatch(c -> c.getBasisTypes().contains(VatBasisType.PENALTY)) && BigDecimal.ZERO.compareTo(penalty2 = detalization.getPenalty()) != 0) {
                BigDecimal penaltyVat = penalty2.multiply(hundred.add(rate)).divide(hundred, 2, RoundingMode.HALF_UP).subtract(penalty2);
                penalty2 = penalty2.add(penaltyVat);
                correct = refundOrExchange ? correct.subtract(penaltyVat) : correct.add(penaltyVat);
                detalization.setPenalty(penalty2);
                detalization.setPenaltyWithMcoValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{detalization.getPenaltyWithMcoValue(), penaltyVat}));
                vat.getComponents().add(GeneralProductHelper.createVatComponent(VatBasisType.PENALTY, penalty2, defaultRate, penaltyVat));
            }
            if (vat.getComponents().stream().noneMatch(c -> c.getBasisTypes().contains(VatBasisType.DEDUCTION)) && (deduction = detalization.getDeduction()) != null && BigDecimal.ZERO.compareTo(deduction) != 0) {
                BigDecimal deductionVat = ph.getDeductionVat(product);
                deduction = deduction.add(deductionVat);
                correct = refundOrExchange ? correct.subtract(deductionVat) : correct.add(deductionVat);
                detalization.setDeduction(deduction);
                vat.getComponents().add(GeneralProductHelper.createVatComponent(VatBasisType.DEDUCTION, deduction, defaultRate, deductionVat));
            }
            if (vat.getComponents().stream().noneMatch(c -> c.getBasisTypes().contains(VatBasisType.SERVICE)) && BigDecimal.ZERO.compareTo(af = detalization.getAdditionalFee()) != 0) {
                BigDecimal afVat = af.multiply(hundred.add(rate)).divide(hundred, 2, RoundingMode.HALF_UP).subtract(af);
                af = af.add(afVat);
                correct = correct.add(afVat);
                detalization.setAdditionalFee(af);
                vat.getComponents().add(GeneralProductHelper.createVatComponent(VatBasisType.SERVICE, af, defaultRate, afVat));
            }
            BigDecimal taxBasis = BigDecimal.ZERO;
            BigDecimal taxVat = BigDecimal.ZERO;
            ArrayList<String> taxes = new ArrayList<String>();
            for (SimpleTax tax : detalization.getTaxes()) {
                if (vat.getComponents().stream().anyMatch(c -> c.getBasisTypes().contains(VatBasisType.TAXES) && c.getTaxesUids().contains(tax.getUid()))) continue;
                BigDecimal amount = MiscUtil.guarded((BigDecimal)tax.getAmount());
                BigDecimal vatAmount = amount.multiply(hundred.add(rate)).divide(hundred, 2, RoundingMode.HALF_UP).subtract(amount);
                amount = amount.add(vatAmount);
                tax.setAmount(amount);
                correct = correct.add(vatAmount);
                taxBasis = taxBasis.add(amount);
                taxVat = taxVat.add(vatAmount);
                taxes.add(tax.getUid());
            }
            if (!taxes.isEmpty()) {
                vat.getComponents().add(GeneralProductHelper.createVatComponent(taxBasis, defaultRate, taxVat, taxes));
            }
            if (BigDecimal.ZERO.compareTo(correct) != 0) {
                detalization.setCorrectVat(correct);
            }
            detalization.setVat(vat);
            if (customerPenaltyUnderVat && (penalties3 = detalization.getPenalties()) != null) {
                boolean hasVat = true;
                UnaryOperator func = p -> {
                    if (p.getVatAmount() != null) {
                        return p;
                    }
                    Penalty info = new Penalty();
                    BigDecimal amount = p.getAmount();
                    if (BigDecimal.ZERO.compareTo(amount) != 0) {
                        BigDecimal vatAmount = amount.multiply(hundred.add(rate)).divide(hundred, 2, RoundingMode.HALF_UP).subtract(amount);
                        info.setAmount(amount.add(vatAmount));
                        info.setVatAmount(vatAmount);
                        info.setVatRate(Double.valueOf(defaultRate));
                    } else {
                        info.setAmount(amount);
                        info.setVatAmount(null);
                        info.setVatRate(null);
                    }
                    info.setSource(p.getSource());
                    return info;
                };
                penalties3.getPenalties().replaceAll(func);
                penalties3.getCancellationPenalties().replaceAll(func);
            }
            if ((additionalServices3 = detalization.getAdditionalServices()) != null) {
                boolean hasVat = true;
                additionalServices3.getAdditionalServices().replaceAll(as -> {
                    if (as.getVatAmount() != null) {
                        return as;
                    }
                    AdditionalService info = new AdditionalService();
                    BigDecimal amount = as.getAmount();
                    if (BigDecimal.ZERO.compareTo(amount) != 0) {
                        BigDecimal vatAmount = amount.multiply(hundred.add(rate)).divide(hundred, 2, RoundingMode.HALF_UP).subtract(amount);
                        info.setAmount(amount.add(vatAmount));
                        info.setVatAmount(vatAmount);
                        info.setVatRate(Double.valueOf(defaultRate));
                    } else {
                        info.setAmount(amount);
                        info.setVatAmount(null);
                        info.setVatRate(null);
                    }
                    info.setSource(as.getSource());
                    return info;
                });
            }
            return;
        }
        if (lastVat != null && !lastVat.getComponents().isEmpty()) {
            BigDecimal deductionVat;
            BigDecimal penaltyVat;
            BigDecimal afVat;
            BigDecimal amount;
            ArrayList<VatComponent> fakeVatComponents = new ArrayList<VatComponent>();
            GeneralProductHelper.copyVatComponents(lastVat.getComponents(), fakeVatComponents, last, contractRelation);
            HashMap<VatBasisType, BigDecimal> calculatedVats = new HashMap<VatBasisType, BigDecimal>();
            HashSet<VatComponent> vatComponents = new HashSet<VatComponent>();
            HashMap<String, BigDecimal> calculatedTaxVats = new HashMap<String, BigDecimal>();
            GeneralProductHelper.calculateVat(fakeVatComponents, VatBasisType.FARE, detalization.getFare(), calculatedVats, vatComponents);
            GeneralProductHelper.calculateVat(fakeVatComponents, VatBasisType.SERVICE, detalization.getAdditionalFee(), calculatedVats, vatComponents);
            GeneralProductHelper.calculateVat(fakeVatComponents, VatBasisType.PENALTY, detalization.getPenalty(), calculatedVats, vatComponents);
            if (detalization.getDeduction() != null) {
                GeneralProductHelper.calculateVat(fakeVatComponents, VatBasisType.DEDUCTION, detalization.getDeduction(), calculatedVats, vatComponents);
            }
            for (SimpleTax tax : detalization.getTaxes()) {
                GeneralProductHelper.calculateTaxVat(fakeVatComponents, tax, calculatedTaxVats, vatComponents);
            }
            for (VatComponent vatComponent : vatComponents) {
                String taxUid2;
                BigDecimal vatComponentSum;
                if (vatComponent.getBasisTypes().size() == 1 && (vatComponent.getBasisTypes().iterator().next() != VatBasisType.TAXES || vatComponent.getTaxesUids().size() == 1)) continue;
                BigDecimal vatSum = vatComponent.getBasisTypes().stream().map(calculatedVats::get).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (vatComponent.getBasisTypes().contains(VatBasisType.TAXES)) {
                    vatSum = vatSum.add(calculatedTaxVats.entrySet().stream().filter(e -> vatComponent.getTaxesUids().contains(e.getKey())).map(Map.Entry::getValue).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
                if (vatSum.compareTo(vatComponentSum = vatComponent.getSum()) == 0) continue;
                BigDecimal toAdd = vatComponentSum.subtract(vatSum).divide(BigDecimal.valueOf(vatComponent.getBasisTypes().size() + vatComponent.getTaxesUids().size()), 2, RoundingMode.HALF_UP);
                if (BigDecimal.ZERO.compareTo(toAdd) != 0) {
                    for (VatBasisType type : vatComponent.getBasisTypes()) {
                        amount = (BigDecimal)calculatedVats.get(type);
                        amount = amount != null ? amount.add(toAdd) : toAdd;
                        calculatedVats.put(type, amount);
                    }
                    if (vatComponent.getBasisTypes().contains(VatBasisType.TAXES)) {
                        for (String taxUid2 : vatComponent.getTaxesUids()) {
                            amount = (BigDecimal)calculatedTaxVats.get(taxUid2);
                            amount = amount != null ? amount.add(toAdd) : toAdd;
                            calculatedTaxVats.put(taxUid2, amount);
                        }
                    }
                    vatSum = vatComponent.getBasisTypes().stream().map(calculatedVats::get).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (vatComponent.getBasisTypes().contains(VatBasisType.TAXES)) {
                        vatSum = vatSum.add(calculatedTaxVats.entrySet().stream().filter(e -> vatComponent.getTaxesUids().contains(e.getKey())).map(Map.Entry::getValue).reduce(BigDecimal.ZERO, BigDecimal::add));
                    }
                }
                if (vatSum.compareTo(vatComponentSum) == 0) continue;
                toAdd = vatComponentSum.subtract(vatSum);
                VatBasisType type = (VatBasisType)vatComponent.getBasisTypes().iterator().next();
                if (type != VatBasisType.TAXES) {
                    BigDecimal amount2 = (BigDecimal)calculatedVats.get(type);
                    amount2 = amount2 != null ? amount2.add(toAdd) : toAdd;
                    calculatedVats.put(type, amount2);
                    continue;
                }
                taxUid2 = (String)vatComponent.getTaxesUids().iterator().next();
                amount = (BigDecimal)calculatedTaxVats.get(taxUid2);
                amount = amount != null ? amount.add(toAdd) : toAdd;
                calculatedTaxVats.put(taxUid2, amount);
            }
            BigDecimal correct = BigDecimal.ZERO;
            BigDecimal fareVat = (BigDecimal)calculatedVats.get(VatBasisType.FARE);
            if (fareVat != null) {
                detalization.setFare(detalization.getFare().subtract(fareVat));
                correct = correct.subtract(fareVat);
            }
            if ((afVat = (BigDecimal)calculatedVats.get(VatBasisType.SERVICE)) != null) {
                detalization.setAdditionalFee(detalization.getAdditionalFee().subtract(afVat));
                correct = correct.subtract(afVat);
            }
            if ((penaltyVat = (BigDecimal)calculatedVats.get(VatBasisType.PENALTY)) != null) {
                detalization.setPenalty(detalization.getPenalty().subtract(penaltyVat));
                detalization.setPenaltyWithMcoValue(detalization.getPenaltyWithMcoValue().subtract(penaltyVat));
                BigDecimal bigDecimal = correct = refundOrExchange ? correct.add(penaltyVat) : correct.subtract(penaltyVat);
            }
            if ((deductionVat = (BigDecimal)calculatedVats.get(VatBasisType.DEDUCTION)) != null) {
                detalization.setDeduction(detalization.getDeduction().subtract(deductionVat));
                correct = refundOrExchange ? correct.add(deductionVat) : correct.subtract(deductionVat);
            }
            for (SimpleTax tax : detalization.getTaxes()) {
                amount = (BigDecimal)calculatedTaxVats.get(tax.getUid());
                if (null == amount) continue;
                tax.setAmount(tax.getAmount().subtract(amount));
                correct = correct.subtract(amount);
            }
            if (BigDecimal.ZERO.compareTo(correct) != 0) {
                detalization.setCorrectVat(correct);
            }
            VatComponent vatComponent = new VatComponent();
            BigDecimal basis = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(detalization.getFare()) != 0) {
                vatComponent.getBasisTypes().add(VatBasisType.FARE);
                basis = basis.add(detalization.getFare());
            }
            if (customerPenaltyUnderVat && BigDecimal.ZERO.compareTo(detalization.getPenalty()) != 0) {
                vatComponent.getBasisTypes().add(VatBasisType.PENALTY);
                basis = basis.add(detalization.getPenalty());
            }
            if (detalization.getDeduction() != null && BigDecimal.ZERO.compareTo(detalization.getDeduction()) != 0) {
                vatComponent.getBasisTypes().add(VatBasisType.DEDUCTION);
                basis = basis.add(detalization.getDeduction());
            }
            if (BigDecimal.ZERO.compareTo(detalization.getAdditionalFee()) != 0) {
                vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                basis = basis.add(detalization.getAdditionalFee());
            }
            if (!detalization.getTaxes().isEmpty()) {
                vatComponent.getBasisTypes().add(VatBasisType.TAXES);
                for (SimpleTax tax : detalization.getTaxes()) {
                    vatComponent.getTaxesUids().add(tax.getUid());
                    basis = basis.add(tax.getAmount());
                }
            }
            if (!vatComponent.getBasisTypes().isEmpty()) {
                vatComponent.setRate(Double.valueOf(0.0));
                vatComponent.setSum(BigDecimal.ZERO);
                vatComponent.setBasis(basis);
                vat.getComponents().add(vatComponent);
            }
            detalization.setVat(vat);
        }
        if (customerPenaltyUnderVat && (penalties = detalization.getPenalties()) != null) {
            UnaryOperator func = p -> {
                Penalty info = new Penalty();
                BigDecimal amount = p.getAmount();
                if (BigDecimal.ZERO.compareTo(amount) != 0) {
                    BigDecimal vatAmount = p.getVatAmount();
                    info.setAmount(vatAmount != null ? amount.subtract(vatAmount) : amount);
                    info.setVatAmount(BigDecimal.ZERO);
                    info.setVatRate(Double.valueOf(0.0));
                } else {
                    info.setAmount(amount);
                    info.setVatAmount(null);
                    info.setVatRate(null);
                }
                info.setSource(p.getSource());
                return info;
            };
            penalties.getPenalties().replaceAll(func);
            penalties.getCancellationPenalties().replaceAll(func);
        }
        if ((additionalServices = detalization.getAdditionalServices()) != null) {
            additionalServices.getAdditionalServices().replaceAll(as -> {
                AdditionalService info = new AdditionalService();
                BigDecimal amount = as.getAmount();
                if (BigDecimal.ZERO.compareTo(amount) != 0) {
                    BigDecimal vatAmount = as.getVatAmount();
                    info.setAmount(vatAmount != null ? amount.subtract(vatAmount) : amount);
                    info.setVatAmount(BigDecimal.ZERO);
                    info.setVatRate(Double.valueOf(0.0));
                } else {
                    info.setAmount(amount);
                    info.setVatAmount(null);
                    info.setVatRate(null);
                }
                info.setSource(as.getSource());
                return info;
            });
        }
    }

    private static void calculateVat(List<VatComponent> components, VatBasisType type, BigDecimal basis, Map<VatBasisType, BigDecimal> calculatedVats, Set<VatComponent> vatComponents) {
        VatComponent vatComponent = components.stream().filter(Objects::nonNull).filter(c -> c.getBasisTypes().contains(type) && c.getRate() != null).findFirst().orElse(null);
        if (vatComponent != null) {
            vatComponents.add(vatComponent);
            if (vatComponent.getBasisTypes().size() == 1) {
                BigDecimal fareVat = vatComponent.getSum();
                calculatedVats.put(type, fareVat);
            } else {
                BigDecimal rate = BigDecimal.valueOf(vatComponent.getRate());
                BigDecimal hundred = new BigDecimal(100);
                BigDecimal fareVat = basis.multiply(rate).divide(hundred, 2, RoundingMode.HALF_UP);
                calculatedVats.put(type, fareVat);
            }
        }
    }

    private static void calculateTaxVat(List<VatComponent> components, SimpleTax tax, Map<String, BigDecimal> calculatedTaxVats, Set<VatComponent> vatComponents) {
        VatComponent vatComponent = components.stream().filter(Objects::nonNull).filter(c -> c.getBasisTypes().contains(VatBasisType.TAXES) && c.getRate() != null && c.getTaxesUids().contains(tax.getUid())).findFirst().orElse(null);
        if (vatComponent != null) {
            vatComponents.add(vatComponent);
            if (vatComponent.getBasisTypes().size() == 1) {
                BigDecimal fareVat = vatComponent.getSum();
                calculatedTaxVats.put(tax.getUid(), fareVat);
            } else {
                BigDecimal rate = BigDecimal.valueOf(vatComponent.getRate());
                BigDecimal hundred = new BigDecimal(100);
                BigDecimal fareVat = tax.getAmount().multiply(rate).divide(hundred, 2, RoundingMode.HALF_UP);
                calculatedTaxVats.put(tax.getUid(), fareVat);
            }
        }
    }

    private static void copyVatComponents(List<VatComponent> from, List<VatComponent> to, RelationData last, BaseContractRelationData contractRelation) {
        GeneralProductHelper.copyVatComponents(from, to, last, contractRelation, null);
    }

    private static void copyVatComponents(List<VatComponent> from, List<VatComponent> to, RelationData last, BaseContractRelationData contractRelation, List<VatCalculationData> vatCalculationData) {
        ContractRelationServiceDataDetalization detalization = contractRelation.getServiceData().getDetalization();
        String currency = contractRelation.getGeneralData().getCurrency() != null ? contractRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
        for (VatComponent comp : from) {
            SimpleTax tax;
            VatComponent result = new VatComponent();
            result.getBasisTypes().addAll(comp.getBasisTypes());
            Double vatRate = comp.getRate();
            if (vatCalculationData != null) {
                block1: for (VatCalculationData data : vatCalculationData) {
                    if (!comp.getBasisTypes().contains(data.getBasisType())) continue;
                    for (String uid : comp.getTaxesUids()) {
                        tax = last.getTaxes().stream().filter(t -> MiscUtil.equals((Object)uid, (Object)t.getUid())).findFirst().orElse(null);
                        if (tax == null || data.getTaxesCodes().isEmpty() || !data.getTaxesCodes().stream().noneMatch(t -> t.equalsIgnoreCase(tax.getCode()))) continue;
                        continue block1;
                    }
                    vatRate = data.getVatRate();
                }
            }
            result.setRate(vatRate);
            if (currency.equals(last.getCurrency())) {
                result.setBasis(comp.getBasis());
                if (MiscUtil.equals((Object)vatRate, (Object)comp.getRate())) {
                    result.setSum(comp.getSum());
                } else if (vatRate != null) {
                    VatAmount vatAmount = VatAmount.of((BigDecimal)comp.getBasis(), (double)vatRate);
                    result.setSum(vatAmount.getVatAmount());
                }
            } else {
                BigDecimal basis = MulticurrencyHelper.convert(comp.getBasis(), contractRelation.getGeneralData().getRate());
                if (vatRate != null) {
                    VatAmount vatAmount = VatAmount.of((BigDecimal)basis, (double)vatRate);
                    result.setSum(vatAmount.getVatAmount());
                }
                result.setBasis(basis);
                result.setRate(vatRate);
            }
            for (String uid : comp.getTaxesUids()) {
                if (null == uid) continue;
                SimpleTax lastTax = last.getTaxes().stream().filter(t -> Objects.equals(uid, t.getUid())).findFirst().orElse(null);
                if (null == lastTax) {
                    result.getTaxesUids().add(uid);
                    continue;
                }
                String source = lastTax.getSource();
                if (null == source) {
                    throw new IllegalStateException("tax " + uid + " has empty source");
                }
                tax = detalization.getTaxes().stream().filter(t -> source.equals(t.getSource())).findFirst().orElse(null);
                if (null == tax) {
                    throw new IllegalStateException("no tax " + uid + " found with source " + source);
                }
                result.getTaxesUids().add(tax.getUid());
            }
            to.add(result);
        }
    }

    private static VatComponent createVatComponent(VatBasisType basisType, BigDecimal basis, double rate, BigDecimal amount) {
        VatComponent result = new VatComponent();
        result.getBasisTypes().add(basisType);
        result.setBasis(basis);
        result.setRate(Double.valueOf(rate));
        result.setSum(amount);
        return result;
    }

    private static VatComponent createVatComponent(BigDecimal basis, double rate, BigDecimal amount, List<String> taxes) {
        VatComponent result = new VatComponent();
        result.getBasisTypes().add(VatBasisType.TAXES);
        result.setBasis(basis);
        result.setRate(Double.valueOf(rate));
        result.setSum(amount);
        result.getTaxesUids().addAll(taxes);
        return result;
    }

    public static BigDecimal getVatSum(BaseContractRelationData contractRelation) {
        if (null == contractRelation) {
            return null;
        }
        ContractRelationVatDetalization vat = contractRelation.getServiceData().getDetalization().getVat();
        if (null == vat || vat.getComponents().isEmpty()) {
            return null;
        }
        return vat.getComponents().stream().map(VatComponent::getSum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static List<VatComponent> getVatComponents(BaseContractRelationData contractRelation) {
        ContractRelationVatDetalization vat = contractRelation.getServiceData().getDetalization().getVat();
        return vat != null && !vat.getComponents().isEmpty() ? vat.getComponents() : null;
    }

    public static <T extends BaseProduct> double[] getFeeVatRate(T product, EntityReference<ContractRelationDescription> description, ContractRelationVatDetalization vatDetalization, EntityReference<Organization> payerRef) {
        T prevProduct;
        Double vat;
        EntityContainer customerCtr;
        boolean supplierHasNoVat;
        ContractType contractType = GeneralProductHelper.getContractType(description);
        ProductHandler<T> ph = GeneralProductHelper.getHandler(product);
        SalesChain salesChain = ph.getSalesChain(product);
        EntityReference<Organization> supplierRef = GeneralProductHelper.getContractRelationSupplier(description, salesChain);
        EntityReference customerRef = ContractType.CLIENT == contractType ? (product.getReservation() != null && product.getReservation().getBookingFile() != null ? product.getReservation().getBookingFile().getCustomerProfile() : null) : GeneralProductHelper.getContractRelationCustomer(description, salesChain);
        Date issueDate = GeneralProductHelper.getProductDate(product);
        EntityContainer supplierCtr = EntityStorage.get().resolve(supplierRef);
        if (supplierCtr != null) {
            Organization supplier = (Organization)supplierCtr.getEntity();
            supplierHasNoVat = supplier.isForeign() || supplier.isSimpleTaxed() && HistoricalValueHelper.getValue((List)supplier.getVatRateHistory(), (Date)issueDate, (boolean)true) == null;
        } else {
            boolean bl = supplierHasNoVat = vatDetalization == null || vatDetalization.getComponents().isEmpty();
        }
        if (supplierHasNoVat) {
            return null;
        }
        if (!ProfileHelper.isRetailProfile(payerRef) && (customerCtr = EntityStorage.get().resolve(customerRef)) != null && !ProfileHelper.isRetailProfile((EntityContainer<Organization>)customerCtr)) {
            boolean customerHasNoVat;
            Organization customer = (Organization)customerCtr.getEntity();
            boolean bl = customerHasNoVat = customer.isForeign() || customer.isSimpleTaxed() && HistoricalValueHelper.getValue((List)customer.getVatRateHistory(), (Date)issueDate, (boolean)true) == null;
            if (customerHasNoVat) {
                return null;
            }
            if (customer.isVATExemption()) {
                return new double[]{0.0, 0.0};
            }
        }
        if ((vat = GeneralProductHelper.getOrganizationVatRate((EntityContainer<Organization>)supplierCtr, issueDate)) == null) {
            return null;
        }
        ProductStatus status = ph.getStatus(product);
        if ((ProductStatus.REFUND == status || ProductStatus.EXCHANGE == status) && (prevProduct = ph.getPreviousProduct(product)) != null) {
            Date firstIssueDate = GeneralProductHelper.getProductDate(prevProduct);
            return new double[]{vat, MiscUtil.guarded((Double)GeneralProductHelper.getOrganizationVatRate((EntityContainer<Organization>)supplierCtr, firstIssueDate))};
        }
        return new double[]{vat, vat};
    }

    public static Double getFeeVatRate(double[] feeVatRates, FeeProperties properties, ProductStatus status) {
        if (feeVatRates == null) {
            return null;
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            return properties.getOperation() == Operation.SELL ? Double.valueOf(feeVatRates[1]) : Double.valueOf(feeVatRates[0]);
        }
        return feeVatRates[0];
    }

    public static Double getOrganizationVatRate(EntityContainer<Organization> ctr, Date date) {
        if (ctr != null && ((Organization)ctr.getEntity()).isSimpleTaxed()) {
            return (Double)HistoricalValueHelper.getValue((List)((Organization)ctr.getEntity()).getVatRateHistory(), (Date)date, (boolean)true);
        }
        BigDecimal vatRate = DictHelper.getDefaultVat(date);
        if (vatRate != null) {
            return vatRate.doubleValue();
        }
        return null;
    }

    public static <P extends BaseProduct> VatAmount calculateProductPrice(GeneralProductContractRelationData relation, ProductHandler<P> handler, P product) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = handler.getStatus(product);
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return result;
        }
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            BigDecimal vatSum = MiscUtil.guarded((BigDecimal)GeneralProductHelper.getVatSum((BaseContractRelationData)relation));
            if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
                vatSum = vatSum.negate();
            }
            result.setTotalVatAmount(totalPrice, vatSum);
            return result;
        }
        BigDecimal total = handler.getEquivalentFare(product);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        if (handler.getPenalty(product) != null) {
            total = total.subtract(handler.getPenalty(product));
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            total = total.abs().negate();
        }
        result.setTotalVat(total, 0.0);
        return result;
    }

    public static void addVatComponent(List<VatComponent> components, BigDecimal totalAmount, VatValue vatValue, VatBasisType vatBasisType) {
        if (BigDecimal.ZERO.compareTo(MiscUtil.guarded((BigDecimal)totalAmount)) == 0 || vatValue == null) {
            return;
        }
        VatComponent component = new VatComponent();
        component.setBasis(totalAmount);
        if (vatValue.getRate() != null && vatValue.getAmount() != null) {
            component.setRate(vatValue.getRate());
            component.setSum(vatValue.getAmount());
        }
        component.getBasisTypes().add(vatBasisType);
        components.add(component);
    }

    public static List<EmployeeCategory> getEmployeeCategories(EntityReference<Organization> clientRef, Collection<EntityReference<Person>> persons) {
        ArrayList<EmployeeCategory> result = new ArrayList<EmployeeCategory>();
        for (EntityReference<Person> personRef : persons) {
            EmployeeCategory category;
            EntityContainer person = EntityStorage.get().resolve(personRef);
            if (person == null || (category = GeneralProductHelper.getEmployeeCategory(clientRef, (Person)person.getEntity())) == null) continue;
            result.add(category);
        }
        return result;
    }

    public static EmployeeCategory getEmployeeCategory(EntityReference<Organization> clientRef, Person person) {
        for (PersonEmployment employment : person.getEmployments()) {
            EntityContainer org;
            EmployeeCategory category = employment.getEmployeeCategory();
            if (!clientRef.equals((Object)employment.getOrganization()) || null == category || (org = EntityStorage.get().resolve(employment.getOrganization())) == null || !((Organization)org.getEntity()).getEmployeeCategories().stream().anyMatch(c -> GeneralProductHelper.isEmployeeCategoriesEquals(c, category))) continue;
            return category;
        }
        return null;
    }

    public static <P extends BaseProduct> List<EmployeeCategory> getEmployeeCategories(P product) {
        ProductHandler<P> handler = GeneralProductHelper.getHandler(product);
        ArrayList<EmployeeCategory> result = new ArrayList<EmployeeCategory>();
        if (product == null || product.getReservation() == null || product.getReservation().getBookingFile() == null || product.getReservation().getBookingFile().getCustomerProfile() == null) {
            return result;
        }
        return GeneralProductHelper.getEmployeeCategories((EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), handler.getTravellers(product).stream().map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static boolean isEmployeeCategoriesEquals(EmployeeCategory o1, EmployeeCategory o2) {
        if (null == o1 || null == o2) {
            return o1 == o2;
        }
        return o1.getName().equals((Object)o2.getName());
    }

    public static <P extends BaseProduct> String getProductTitle(P product) {
        if (product == null) {
            return null;
        }
        ProductHandler<P> handler = GeneralProductHelper.getHandler(product);
        List<String> productNumbers = handler.getProductNumbers(product);
        if (!productNumbers.isEmpty() && !TextUtil.isBlank((String)productNumbers.get(0))) {
            return productNumbers.get(0);
        }
        Collection<Traveller> travs = handler.getTravellers(product);
        if (travs.isEmpty()) {
            return "?";
        }
        Traveller trav = travs.iterator().next();
        if (trav == null) {
            return "?";
        }
        return trav.getName();
    }

    public static void changeFopsPaymentTypes(List<GeneralProductFop> fops, PaymentType newPaymentType, boolean updateOnlyFeeFops) {
        if (updateOnlyFeeFops) {
            fops.stream().filter(fop -> !GeneralProductHelper.isServiceFop(fop)).forEach(fop -> fop.setType(newPaymentType));
        } else {
            fops.stream().filter(GeneralProductHelper::isServiceFop).forEach(fop -> fop.setType(newPaymentType));
        }
    }

    public static boolean isVendorVatDetalizationComplete(VatDetalization detalization) {
        return detalization != null && detalization.isDetalized();
    }

    public static EntityReference<Organization> getClientRelationMediator(BaseProduct bp) {
        if (bp == null) {
            return null;
        }
        GeneralProductContractRelationData relation = GeneralProductHelper.getClientContractRelation(bp);
        if (relation == null) {
            return null;
        }
        return relation.getGeneralData().getMediator();
    }

    public static boolean isSupplierFop(BaseProduct baseProduct, GeneralProductFop productFop) {
        GeneralProductContractRelationData subagentContractRelation = GeneralProductHelper.getSubagentContractRelation(baseProduct);
        List commissions = productFop.getCommissions();
        if (Objects.isNull(subagentContractRelation) || commissions.isEmpty()) {
            return false;
        }
        GeneralProductCommission firstCommission = (GeneralProductCommission)CollectionUtil.head((Iterable)commissions);
        return GeneralProductHelper.isSupplierFee(firstCommission, subagentContractRelation.getCommissions());
    }

    public static boolean isNotManualNotRefundableCommission(BaseCommission commission) {
        if (commission == null) {
            return false;
        }
        EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
        if (ctr == null) {
            return false;
        }
        BaseCommissionProperties baseProp = (BaseCommissionProperties)ctr.getEntity();
        if (baseProp instanceof FeeProperties) {
            FeeProperties feeProp = (FeeProperties)baseProp;
            return feeProp.getType() != FeeType.MANUALLY_CALCULATED && !feeProp.getReturnCases().contains(ReturnCase.VOID);
        }
        if (baseProp instanceof CommissionProperties) {
            CommissionProperties commProp = (CommissionProperties)baseProp;
            return !commProp.isManuallyCalculated();
        }
        if (baseProp instanceof DiscountProperties) {
            DiscountProperties discountProp = (DiscountProperties)baseProp;
            return discountProp.getType() != DiscountType.MANUALLY_CALCULATED;
        }
        return false;
    }

    public static <T extends BaseCommission> CommissionPropertiesType getCommissionProperiesType(T commission) {
        Class type = Optional.ofNullable(commission).map(BaseCommission::getCommissionProperties).map(EntityReference::getType).orElse(null);
        if (commissionCommissionPropertyTypes.contains(type)) {
            return CommissionPropertiesType.COMMISSION;
        }
        if (discountDiscountPropertyTypes.contains(type)) {
            return CommissionPropertiesType.DISCOUNT;
        }
        if (serviceFeePropertyTypes.contains(type)) {
            return CommissionPropertiesType.FEE;
        }
        if (paymentFeePropertyTypes.contains(type)) {
            return CommissionPropertiesType.PAYMENT_FEE;
        }
        return null;
    }

    public static ProductFopCategory getProductFopCategory(GeneralProductFop fop) {
        if (!GeneralProductHelper.isServiceFop(fop)) {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() == null) continue;
                Class type = commission.getCommissionProperties().getType();
                if (paymentFeePropertyTypes.contains(type)) {
                    return ProductFopCategory.PAYMENT_FEE;
                }
                if (!discountPropertyTypes.contains(type)) continue;
                return ProductFopCategory.DISCOUNT;
            }
            return ProductFopCategory.SERVICE_FEE;
        }
        return ProductFopCategory.PRODUCT;
    }

    public static <P extends BaseProduct> String getPaymentCode(P product) {
        String paymentCode = null;
        ProductHandler<P> productHandler = ProductHandler.of(product);
        ProductType productType = productHandler.getProductType(product);
        EntityReference<UniversalProductDescription> description = productHandler.getUniversalProductDescription(product);
        PaymentCodeSettings paymentCodeSettings = SystemHelper.searchSystemSettings(PaymentCodeSettings.class).stream().findFirst().orElse(null);
        if (paymentCodeSettings != null && productType != null) {
            paymentCode = paymentCodeSettings.getPaymentCodes().stream().filter(code -> code.getProductType() == productType).filter(code -> {
                if (description != null) {
                    return code.getUniversalProductDescription() != null && code.getUniversalProductDescription().equals((Object)description);
                }
                return true;
            }).map(PaymentCode::getCode).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return paymentCode;
    }

    public static String getContractCurrency(BaseProduct product, ContractType type) {
        GeneralProductContractRelationData relation = GeneralProductHelper.getContractRelation(product, type);
        return relation != null && relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getEquivCurrency();
    }

    public static String getContractCurrency(GeneralProductContractRelationData relation) {
        return relation != null && relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getEquivCurrency();
    }

    public static BigDecimal getClientFopAmount(BaseProduct product) {
        return GeneralProductHelper.getFopAmount(product, ContractType.CLIENT);
    }

    public static BigDecimal getSubagentFopAmount(BaseProduct product) {
        return GeneralProductHelper.getFopAmount(product, ContractType.SUBAGENCY);
    }

    public static BigDecimal getVendorFopAmount(BaseProduct product) {
        return GeneralProductHelper.getFopAmount(product, ContractType.VENDOR);
    }

    public static BigDecimal getFopAmount(BaseProduct product, ContractType type) {
        BigDecimal fopAmount = null;
        List<GeneralProductFop> fops = GeneralProductHelper.getFops(product, type);
        for (GeneralProductFop fop : fops) {
            if (fop.getEquivalentAmount() == null) continue;
            fopAmount = fopAmount != null ? fopAmount.add(fop.getEquivalentAmount()) : fop.getEquivalentAmount();
        }
        if (fopAmount != null) {
            boolean refund = ProductStatusHelper.get().negatesPrice(GeneralProductHelper.getStatus(product));
            fopAmount = refund ? fopAmount.negate() : fopAmount;
        }
        return fopAmount;
    }

    public static <P extends BaseProduct> P getLastProduct(P product, ProductHandler<P> handler) {
        P lastProduct = product;
        HashSet<P> seen = new HashSet<P>();
        seen.add(lastProduct);
        P nextProduct = product;
        while ((nextProduct = handler.getNextProduct(nextProduct)) != null) {
            if (!seen.add(nextProduct)) {
                throw new IllegalStateException(String.format("product %s in booking file %s has an infinite loop in nextProduct chain", product.getUid(), TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile())));
            }
            lastProduct = nextProduct;
        }
        return lastProduct;
    }

    public static <P extends BaseProduct> P getFirstProduct(P product, ProductHandler<P> handler) {
        P firstProduct = product;
        HashSet<P> seen = new HashSet<P>();
        seen.add(firstProduct);
        while ((firstProduct = handler.getPreviousProduct(firstProduct)) != null) {
            if (seen.add(firstProduct)) continue;
            throw new IllegalStateException(String.format("product %s in booking file %s has an infinite loop in previousProduct chain", product.getUid(), TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile())));
        }
        return firstProduct;
    }

    public static Integer getDecimalPlaces(String currencyCode, Integer defaultValue) {
        if ("RUB".equals(currencyCode)) {
            return 2;
        }
        CurrencyInfo curInfo = (CurrencyInfo)DictionaryCache.get().resolveReference((DictionaryReference)new CurrencyInfoReference(currencyCode));
        if (curInfo != null && curInfo.getIataDecimalPlaces() != null) {
            return curInfo.getIataDecimalPlaces();
        }
        return defaultValue;
    }

    public static void fillCommonCostCodes(BookingFile bookingFile, BaseProduct product) {
        ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(product);
        if (!handler.isStatisticalDataAvailable(product)) {
            return;
        }
        HashSet costCodes = new HashSet();
        BookingStreamHelper.getBaseProductsStream(bookingFile).filter(p -> !MiscUtil.equals((Object)p, (Object)product)).map(p -> GeneralProductHelper.getHandler(p).getStatisticalData((BaseProduct)p)).filter(Objects::nonNull).map(StatisticsHelper::getAllCostCodes).flatMap(Collection::stream).filter(cc -> cc.getCostCodeProperties() != null && cc.getCostCodeProperties().isCommon() && (TextUtil.nonBlank((String)cc.getValue()) || TextUtil.nonBlank((String)cc.getLocalValue()) || TextUtil.nonBlank((String)cc.getEnglishValue()))).collect(Collectors.groupingBy(CostCode::getCostCodeProperties, Collectors.toList())).entrySet().stream().filter(e -> {
            boolean result;
            boolean bl = result = ((List)e.getValue()).size() == 1;
            if (result) {
                return true;
            }
            ArrayList codes = new ArrayList();
            ((List)e.getValue()).forEach(cc -> {
                if (codes.stream().noneMatch(c -> StatisticsHelper.equalsCostCodeValues(c, cc, 1))) {
                    codes.add(cc);
                }
            });
            return codes.size() == 1;
        }).forEach(e -> {
            CostCode fulfilledCostCode = StatisticsHelper.getFulfilledCostCode((Collection)e.getValue());
            CostCode code = new CostCode();
            code.setCostCodeProperties((CostCodeProperties)e.getKey());
            code.setValue(fulfilledCostCode.getValue());
            code.setLocalValue(fulfilledCostCode.getLocalValue());
            code.setEnglishValue(fulfilledCostCode.getEnglishValue());
            costCodes.add(code);
        });
        if (costCodes.isEmpty()) {
            return;
        }
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (statisticalData == null) {
            handler.newStatisticalData(product);
            statisticalData = handler.getStatisticalData(product);
            if (statisticalData == null) {
                return;
            }
        }
        TravellerCostCodes travellerCostCodes = new TravellerCostCodes();
        travellerCostCodes.getCostCodes().addAll(costCodes);
        statisticalData.getTravellerCostCodes().add(travellerCostCodes);
    }

    public static class RelationData {
        private String currency;
        private String fareCurrency;
        private BigDecimal fare;
        private List<SimpleTax> taxes;
        private BigDecimal penalty;
        private BigDecimal penaltyWithMcoValue;
        private BigDecimal deduction;
        private BigDecimal obFees;
        private BigDecimal additionalFee;
        private EntityReference<Contract> contract;
        private ContractRelationVatDetalization vat;
        private boolean shouldUpdateFops;
        private boolean fareFopsRelevant;
        private Collection<Penalty> penalties;
        private Collection<Penalty> cancellationPenalties;
        private Collection<AdditionalService> additionalServices;

        public <T extends BaseProduct> RelationData(T product) {
            this.updateFromEquivalentSums(product);
        }

        public <T extends BaseProduct> void updateFromEquivalentSums(T product) {
            Collection<BasePenalty> vendorCancellationPenalties;
            Collection<BasePenalty> vendorPenalties;
            Money af;
            ProductHandler<T> ph = GeneralProductHelper.getHandler(product);
            this.fareFopsRelevant = ph.isFareFopsRelevant(product);
            Money source = this.fareFopsRelevant ? ph.getProductEquivalentFare(product) : ph.getProductBaseFare(product);
            this.currency = source != null && source.getCurrency() != null ? source.getCurrency() : DictHelper.getLocalCurrency();
            Money productFare = this.fareFopsRelevant ? ph.getProductBaseFare(product) : source;
            this.fareCurrency = productFare != null && productFare.getCurrency() != null ? productFare.getCurrency() : DictHelper.getLocalCurrency();
            this.deduction = ph.getDeduction(product);
            this.fare = source != null && source.getValue() != null ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{source.getValue(), this.deduction}) : BigDecimal.ZERO;
            this.taxes = ph.getTaxes(product).stream().map(tax -> {
                SimpleTax st = new SimpleTax();
                st.setUid(tax.getUid());
                if (this.fareFopsRelevant) {
                    st.setAmount(tax.getEquivalentAmount());
                } else {
                    Money t = tax.getAmount();
                    st.setAmount(t != null ? MiscUtil.guarded((BigDecimal)t.getValue()) : BigDecimal.ZERO);
                }
                st.setCode(tax.getCode());
                st.setSource(tax.getUid());
                return st;
            }).collect(Collectors.toList());
            Money penaltySource = this.fareFopsRelevant ? ph.getProductEquivalentPenalty(product) : ph.getProductBasePenalty(product);
            this.penaltyWithMcoValue = this.penalty = penaltySource != null && penaltySource.getValue() != null ? penaltySource.getValue() : BigDecimal.ZERO;
            this.obFees = MiscUtil.guarded((BigDecimal)ph.getObFees(product));
            this.additionalFee = this.fareFopsRelevant ? MiscUtil.guarded((BigDecimal)ph.getAdditionalFeeEquivalentAmount(product)) : ((af = ph.getAdditionalFee(product)) != null ? MiscUtil.guarded((BigDecimal)af.getValue()) : BigDecimal.ZERO);
            this.contract = null;
            VatDetalization vatDetalization = ph.getVendorVatDetalization(product);
            if (vatDetalization != null) {
                ContractRelationVatDetalization vat = new ContractRelationVatDetalization();
                vatDetalization.getComponents().stream().filter(c -> c.getSum() != null && c.getRate() != null).map(c -> {
                    if (c.getSum().compareTo(BigDecimal.ZERO) >= 0) {
                        return c;
                    }
                    VatComponent result = new VatComponent();
                    result.setSum(c.getSum().abs());
                    result.setRate(c.getRate());
                    result.setBasis(c.getBasis() != null ? c.getBasis().abs() : null);
                    result.getBasisTypes().addAll(c.getBasisTypes());
                    result.getTaxesUids().addAll(c.getTaxesUids());
                    return result;
                }).forEach(vat.getComponents()::add);
                this.vat = vat;
            } else {
                this.vat = null;
            }
            this.shouldUpdateFops = false;
            if (this.fareFopsRelevant) {
                vendorPenalties = ph.getProductEquivalentPenalties(product);
                vendorCancellationPenalties = ph.getProductEquivalentCancellationPenalties(product);
            } else {
                vendorPenalties = ph.getProductBasePenalties(product);
                vendorCancellationPenalties = ph.getProductBaseCancellationPenalties(product);
            }
            Function<BasePenalty, Penalty> penaltyFunc = p -> {
                if (null == p || p.getAmount() == null || p.getAmount().getValue() == null) {
                    return null;
                }
                Penalty info = new Penalty();
                info.setAmount(p.getAmount().getValue());
                info.setVatAmount(p.getVatAmount());
                info.setVatRate(p.getVatRate());
                info.setSource(p.getSource());
                return info;
            };
            this.penalties = vendorPenalties != null ? (Collection)vendorPenalties.stream().map(penaltyFunc).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
            this.cancellationPenalties = vendorCancellationPenalties != null ? (Collection)vendorCancellationPenalties.stream().map(penaltyFunc).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
            Collection<VendorAdditionalService> vendorAdditionalServices = this.fareFopsRelevant ? ph.getProductEquivalentAdditionalServices(product) : ph.getProductBaseAdditionalServices(product);
            this.additionalServices = vendorAdditionalServices != null ? (Collection)vendorAdditionalServices.stream().map(p -> {
                if (null == p || p.getAmount() == null || p.getAmount().getValue() == null) {
                    return null;
                }
                AdditionalService info = new AdditionalService();
                info.setAmount(p.getAmount().getValue());
                info.setVatAmount(p.getVatAmount());
                info.setVatRate(p.getVatRate());
                info.setSource(p.getSource());
                return info;
            }).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        }

        public RelationData(BaseContractRelationData contractRelation, RelationData last) {
            EntityReference<Contract> contract = contractRelation.getGeneralData().getContractData().getContract();
            this.contract = contract != null ? contract : last.getContract();
            this.fareFopsRelevant = last.isFareFopsRelevant();
            ContractRelationServiceDataDetalization detalization = contractRelation.getServiceData().getDetalization();
            if (this.fareFopsRelevant) {
                this.currency = contractRelation.getGeneralData().getCurrency() != null ? contractRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
                this.fareCurrency = last.fareCurrency;
                this.fare = detalization.getFare();
                this.taxes = detalization.getTaxes();
                this.penalty = detalization.getPenalty();
                this.deduction = detalization.getDeduction();
                this.penaltyWithMcoValue = detalization.getPenaltyWithMcoValue();
                this.obFees = detalization.getObFees();
                this.additionalFee = detalization.getAdditionalFee();
                boolean bl = this.shouldUpdateFops = last.shouldUpdateFops() || !this.currency.equals(last.getCurrency());
                if (detalization.getPenalties() != null) {
                    this.penalties = detalization.getPenalties().getPenalties();
                    this.cancellationPenalties = detalization.getPenalties().getCancellationPenalties();
                } else {
                    this.penalties = Collections.emptyList();
                    this.cancellationPenalties = Collections.emptyList();
                }
                this.additionalServices = detalization.getAdditionalServices() != null ? detalization.getAdditionalServices().getAdditionalServices() : Collections.emptyList();
                this.vat = detalization.getVat();
            } else {
                this.currency = contractRelation.getGeneralData().getCurrency() != null ? contractRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
                this.fareCurrency = last.fareCurrency;
                this.fare = last.fare;
                this.taxes = last.taxes;
                this.penalty = last.penalty;
                this.deduction = last.deduction;
                this.penaltyWithMcoValue = last.penaltyWithMcoValue;
                this.obFees = last.obFees;
                this.additionalFee = last.additionalFee;
                this.shouldUpdateFops = last.shouldUpdateFops;
                this.penalties = last.getPenalties();
                this.cancellationPenalties = last.getCancellationPenalties();
                this.additionalServices = last.getAdditionalServices();
                this.vat = last.getVat();
            }
        }

        public String getCurrency() {
            return this.currency;
        }

        public String getFareCurrency() {
            return this.fareCurrency;
        }

        public BigDecimal getFare() {
            return this.fare;
        }

        public List<SimpleTax> getTaxes() {
            return this.taxes;
        }

        public BigDecimal getPenalty() {
            return this.penalty;
        }

        public BigDecimal getPenaltyWithMcoValue() {
            return this.penaltyWithMcoValue;
        }

        public BigDecimal getDeduction() {
            return this.deduction;
        }

        public BigDecimal getObFees() {
            return this.obFees;
        }

        public BigDecimal getAdditionalFee() {
            return this.additionalFee;
        }

        public EntityReference<Contract> getContract() {
            return this.contract;
        }

        public ContractRelationVatDetalization getVat() {
            return this.vat;
        }

        public boolean shouldUpdateFops() {
            return this.shouldUpdateFops;
        }

        public void setUpdateFops(boolean value) {
            this.shouldUpdateFops = this.shouldUpdateFops || value;
        }

        public boolean isFareFopsRelevant() {
            return this.fareFopsRelevant;
        }

        public Collection<Penalty> getPenalties() {
            return this.penalties;
        }

        public Collection<Penalty> getCancellationPenalties() {
            return this.cancellationPenalties;
        }

        public Collection<AdditionalService> getAdditionalServices() {
            return this.additionalServices;
        }
    }

    public static class SalesChainHandler {
        private final Map<PredefinedContractorType, List<EntityReference<ContractorDescription>>> contractorDescriptions = new HashMap<PredefinedContractorType, List<EntityReference<ContractorDescription>>>();

        public static SalesChainHandler of(EntityReference<SalesChainDescription> salesChainDescription) {
            return new SalesChainHandler(salesChainDescription);
        }

        private SalesChainHandler(EntityReference<SalesChainDescription> salesChainDescription) {
            this.contractorDescriptions.clear();
            this.contractorDescriptions.putAll(Optional.ofNullable(EntityStorage.get().resolve(salesChainDescription)).map(item -> ((SalesChainDescription)item.getEntity()).getContractRelations()).orElse(Collections.emptyList()).stream().map(item -> EntityStorage.get().resolve(item)).filter(item -> item != null).map(item -> EntityStorage.get().resolve(((ContractRelationDescription)item.getEntity()).getSupplier())).filter(item -> item != null).map(item -> new MiscUtil.Pair((Object)((ContractorDescription)item.getEntity()).getPredefinedType(), (Object)item.toReference())).collect(Collectors.groupingBy(item -> (PredefinedContractorType)item.getFirst(), () -> new LinkedHashMap(), MiscUtil.getListCollector(item -> (EntityReference)item.getSecond()))));
        }

        public boolean isSupplierSupported() {
            return this.contractorDescriptions.containsKey(PredefinedContractorType.SUPPLIER);
        }

        public EntityReference<ContractorDescription> getSupplierContractorDescription() {
            return Optional.ofNullable(this.contractorDescriptions.get(PredefinedContractorType.SUPPLIER)).map(item -> (EntityReference)item.get(0)).orElse(null);
        }

        public Contractor getSupplierContractor(Collection<? extends Contractor> contractors) {
            EntityReference<ContractorDescription> supplierContractorDescription = this.getSupplierContractorDescription();
            if (supplierContractorDescription == null) {
                return null;
            }
            return contractors.stream().filter(item -> MiscUtil.equals((Object)item.getDescription(), (Object)supplierContractorDescription)).findFirst().orElse(null);
        }

        public boolean isTechnicalProviderSupported() {
            return this.contractorDescriptions.containsKey(PredefinedContractorType.TECHNICAL_PROVIDER);
        }

        public EntityReference<ContractorDescription> getTechnicalProviderContractorDescription() {
            return Optional.ofNullable(this.contractorDescriptions.get(PredefinedContractorType.TECHNICAL_PROVIDER)).map(item -> (EntityReference)item.get(0)).orElse(null);
        }

        public Contractor getTechnicalProviderContractor(Collection<? extends Contractor> contractors) {
            EntityReference<ContractorDescription> technicalProviderContractorDescription = this.getTechnicalProviderContractorDescription();
            if (technicalProviderContractorDescription == null) {
                return null;
            }
            return contractors.stream().filter(item -> MiscUtil.equals((Object)item.getDescription(), (Object)technicalProviderContractorDescription)).findFirst().orElse(null);
        }

        public boolean isAgencySupported() {
            return this.contractorDescriptions.containsKey(PredefinedContractorType.AGENCY);
        }

        public EntityReference<ContractorDescription> getAgencyContractorDescription() {
            return Optional.ofNullable(this.contractorDescriptions.get(PredefinedContractorType.AGENCY)).map(item -> (EntityReference)item.get(0)).orElse(null);
        }

        public Contractor getAgencyContractor(Collection<? extends Contractor> contractors) {
            EntityReference<ContractorDescription> agencyContractorDescription = this.getAgencyContractorDescription();
            if (agencyContractorDescription == null) {
                return null;
            }
            return contractors.stream().filter(item -> MiscUtil.equals((Object)item.getDescription(), (Object)agencyContractorDescription)).findFirst().orElse(null);
        }

        public boolean isSubagencySupported() {
            return this.contractorDescriptions.containsKey(PredefinedContractorType.SUBAGENCY);
        }

        public List<EntityReference<ContractorDescription>> getSubagencyContractorDescriptions() {
            return Optional.ofNullable(this.contractorDescriptions.get(PredefinedContractorType.SUBAGENCY)).orElse(Collections.emptyList());
        }

        public List<Contractor> getSubagencyContractors(Collection<? extends Contractor> contractors) {
            List<EntityReference<ContractorDescription>> subagencyContractorDescriptions = this.getSubagencyContractorDescriptions();
            return subagencyContractorDescriptions.stream().map(item -> contractors.stream().filter(contractor -> MiscUtil.equals((Object)contractor.getDescription(), (Object)item)).findFirst().orElse(null)).collect(Collectors.toList());
        }
    }

    static final class CommissionData {
        public FinanceCapableProduct product;
        public GeneralProductCommission commission;

        public CommissionData(GeneralProductCommission aCommission, FinanceCapableProduct aProduct) {
            this.commission = aCommission;
            this.product = aProduct;
        }
    }

    public static interface FinanceCapableProduct
    extends FopProduct {
        public Date getIssueDate();

        public ProductStatus getStatus();

        public List<GeneralProductCommission> getCommissions();

        public FinanceCapableProduct getPreviousProduct();

        public VatAmount calculateProductPrice();

        public boolean isHasVat();

        public String getCommonPart();

        public BigDecimal getPenalty();

        public String getProductUid();

        public Traveller getTraveller();

        default public String getTravellerName() {
            return null;
        }

        public String getTicketNumber();
    }

    public static interface FopProduct {
        public List<? extends GeneralProductFop> getClientFops();

        public List<? extends GeneralProductFop> getSubagentFops();

        public List<? extends GeneralProductFop> getVendorFops();
    }

    public static enum CommissionCategory {
        STANDARD,
        HIDDEN;

    }

    public static enum CommissionType {
        STANDARD,
        BSP,
        BONUS,
        SUBAGENT;

    }
}

