/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.MCOFeesType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class MCOFeesHelper {
    public static Set<String> getRelatedProductUids(MCOFees product) {
        return product.getSources().stream().map(item -> item.getProductUid()).filter(item -> item != null).collect(Collectors.toSet());
    }

    public static List<BaseProduct> getRelatedProducts(MCOFees product) {
        ArrayList<BaseProduct> relatedProducts = new ArrayList<BaseProduct>();
        for (String uid : MCOFeesHelper.getRelatedProductUids(product)) {
            Object relatedProduct;
            if (uid == null || (relatedProduct = BookingHelper.findProductByUid(uid, product.getReservation().getBookingFile())) == null) continue;
            relatedProducts.add((BaseProduct)relatedProduct);
        }
        return relatedProducts;
    }

    public static void removeProduct(MCOFees product, boolean removeEmptyReservations) {
        ArrayList<MCOFees> productsToDelete = new ArrayList<MCOFees>();
        productsToDelete.add(product);
        if (product.getStatus() == ProductStatus.SELL && product.getNextMCO() != null) {
            productsToDelete.add(product.getNextMCO());
        }
        for (MCOFees todelete : productsToDelete) {
            for (Reservation res : new ArrayList(todelete.getReservation().getBookingFile().getReservations())) {
                if (res.getProducts().contains(todelete)) {
                    res.getProducts().remove(todelete);
                }
                for (BaseProduct bp : res.getProducts()) {
                    if (!(bp instanceof MCOFees)) continue;
                    MCOFees prod = (MCOFees)bp;
                    if (todelete.equals((Object)prod.getPreviousMCO())) {
                        prod.setPreviousMCO(null);
                    }
                    if (!todelete.equals((Object)prod.getNextMCO())) continue;
                    prod.setNextMCO(null);
                }
                if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
                todelete.getReservation().getBookingFile().getReservations().remove(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MCOFees createRefund(MCOFees model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            MCOFees refund = (MCOFees)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            refund.setReservation(res);
            res.getProducts().add(refund);
            refund.setPreviousMCO(model);
            model.setNextMCO(refund);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            MCOFees mCOFees = refund;
            return mCOFees;
        }
        finally {
            model.setReservation(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(MCOFees source, MCOFees target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        MCOFees sourcePrev = source.getPreviousMCO();
        source.setPreviousMCO(null);
        MCOFees sourceNext = source.getNextMCO();
        source.setNextMCO(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        MCOFees targetPrev = target.getPreviousMCO();
        target.setPreviousMCO(null);
        MCOFees targetNext = target.getNextMCO();
        target.setNextMCO(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousMCO(sourcePrev);
            source.setNextMCO(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousMCO(targetPrev);
            target.setNextMCO(targetNext);
        }
    }

    @Deprecated
    public static void recalculate(MCOFees product) {
        RecalcData data = MCOFeesHelper.calculateVisibleFields(product);
        product.setQuantity(data.getQuantity());
        product.setFare(data.getFare());
        product.setTotal(data.getTotal());
        product.setPaymentType(data.getPaymentType());
        product.setPaymentOrderNumber(data.getOrderNumber());
        product.setClientName(data.getClientName());
        product.setPurpose(data.getPurpose());
        product.setRemarks(data.getRemarks());
    }

    @Deprecated
    public static RecalcData calculateVisibleFields(MCOFees product) {
        RecalcData result = new RecalcData();
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal fare = BigDecimal.ZERO;
        PaymentType paymentType = null;
        ArrayList<String> productNumbers = new ArrayList<String>();
        for (Object source : product.getSources()) {
            Fop fop;
            BigDecimal fee;
            BaseProduct bp = BookingHelper.findProduct(product.getReservation().getBookingFile(), source.getProductUid());
            if (bp == null) continue;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            BigDecimal bigDecimal = fee = source.getFare() != null && source.isActive() ? source.getFare().getValue() : null;
            if (fee != null && product.getType() == MCOFeesType.FEES) {
                total = total.add(fee);
                fare = fee;
            }
            if (paymentType == null && (fop = GeneralProductHelper.findFop(bp)) != null) {
                paymentType = fop.getType();
            }
            if (product.getType() != MCOFeesType.OTHER && (fee == null || BigDecimal.ZERO.compareTo(fee) == 0) || source.getTicketNumber() == null || productNumbers.contains(source.getTicketNumber())) continue;
            productNumbers.add(source.getTicketNumber());
        }
        result.setFare(total);
        result.setTotal(total);
        result.setQuantity(product.getRelatedProductsUids().size());
        result.setPaymentType(paymentType);
        Collections.sort(productNumbers);
        StringBuilder sb = new StringBuilder();
        for (String number : productNumbers) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(number);
        }
        result.setRemarks(sb.toString());
        Traveller traveller = BookingHelper.findTraveller(product.getReservation().getBookingFile(), product.getTravellerUid());
        if (traveller != null) {
            PersonalName name = new PersonalName(){
                private String lastName;
                private String firstName;
                private String middleName;

                public void setMiddleName(String value) {
                    this.middleName = value;
                }

                public void setLastName(String value) {
                    this.lastName = value;
                }

                public void setFirstName(String value) {
                    this.firstName = value;
                }

                public String getMiddleName() {
                    return this.middleName;
                }

                public String getLastName() {
                    return this.lastName;
                }

                public String getFirstName() {
                    return this.firstName;
                }
            };
            TextUtil.splitFullName((String)traveller.getName(), (PersonalName)name);
            result.setClientName(TextUtil.buildFullName((PersonalName)name, (boolean)true));
        }
        if (product.getType() == MCOFeesType.FEES) {
            result.setPurpose("\u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0441\u0431\u043e\u0440");
        }
        return result;
    }

    public static Comparator<MCOFeesSource> getMCOFeesSourcesComparator() {
        return (o1, o2) -> {
            int res = TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)false);
            if (res == 0) {
                res = TextUtil.compare((String)o1.getDescription(), (String)o2.getDescription(), (boolean)false, (boolean)false);
            }
            return res;
        };
    }

    public static boolean equals(MCOFeesSource s1, MCOFeesSource s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.getFare() != null && s1.getFare().getValue() != null && s2.getFare() != null && s1.getFare().getValue().equals(s2.getFare().getValue()) && TextUtil.isSame((String)s1.getProductUid(), (String)s2.getProductUid());
    }

    public static boolean contains(List<MCOFeesSource> list, MCOFeesSource s) {
        for (MCOFeesSource src : list) {
            if (!MCOFeesHelper.equals(src, s)) continue;
            return true;
        }
        return false;
    }

    public static boolean removeProduct(MCOFees product) {
        product.getReservation().getProducts().remove(product);
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(MCOFees product, BaseProduct relatedProduct) {
        Iterator iterator = product.getSources().iterator();
        while (iterator.hasNext()) {
            MCOFeesSource source = (MCOFeesSource)iterator.next();
            if (!TextUtil.isSame((String)source.getProductUid(), (String)relatedProduct.getUid())) continue;
            iterator.remove();
        }
        return true;
    }

    public static class RecalcData {
        private int quantity;
        private BigDecimal fare;
        private BigDecimal total;
        private PaymentType paymentType;
        private String orderNumber;
        private String clientName;
        private String purpose;
        private String remarks;

        public int getQuantity() {
            return this.quantity;
        }

        public void setQuantity(int value) {
            this.quantity = value;
        }

        public BigDecimal getFare() {
            return this.fare;
        }

        public void setFare(BigDecimal value) {
            this.fare = value;
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public void setTotal(BigDecimal value) {
            this.total = value;
        }

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public void setPaymentType(PaymentType value) {
            this.paymentType = value;
        }

        public String getOrderNumber() {
            return this.orderNumber;
        }

        public void setOrderNumber(String value) {
            this.orderNumber = value;
        }

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String value) {
            this.clientName = value;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public void setPurpose(String value) {
            this.purpose = value;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String value) {
            this.remarks = value;
        }
    }
}

