/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.test.TestBase;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class PersonalLocalizableNameFormatterTest
extends TestBase {
    @Test
    public void testFormatter() throws Exception {
        Person person = new Person();
        L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)"Ivan", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)person.getLastName(), (String)"Ivanon", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)"Ivanovich", (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"Ivanon Ivan Ivanovich", (Object)new PersonalLocalizableNameFormatter("L F M").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Ivanon Ivan I.", (Object)new PersonalLocalizableNameFormatter("L F m").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Ivanon I. I.", (Object)new PersonalLocalizableNameFormatter("L f m").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"I. I. I.", (Object)new PersonalLocalizableNameFormatter("l f m").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Ivan Ivanon Ivanovich", (Object)new PersonalLocalizableNameFormatter("F L M").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Ivan Ivanon", (Object)new PersonalLocalizableNameFormatter("F L").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Ivan-Ivanon-Ivanovich", (Object)new PersonalLocalizableNameFormatter("F-L-M").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Ivanovich/Ivan/Ivan", (Object)new PersonalLocalizableNameFormatter("M/F/F").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        person = new Person();
        L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)"Petr", (Locale)Locale.ENGLISH);
        L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)"Petrovich", (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"Petr Petrovich", (Object)new PersonalLocalizableNameFormatter("F L M").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"Petr>Petrovich", (Object)new PersonalLocalizableNameFormatter("F<L>M").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"<Petr>", (Object)new PersonalLocalizableNameFormatter("<L===F>").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"<Petr>", (Object)new PersonalLocalizableNameFormatter("<F===L>").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"<PetrPetrovich>", (Object)new PersonalLocalizableNameFormatter("<FLM>").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"<<<>>>", (Object)new PersonalLocalizableNameFormatter("<<<L>>>").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
        Assert.assertEquals((Object)"<<<Petrovich<-Petr>>>", (Object)new PersonalLocalizableNameFormatter("<<<M->L<-F>>>").format((PersonalLocalizableName)person, Locale.ENGLISH, false));
    }
}

