/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.PassengerPassportIndex;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PersonPosition;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FilterPersonPasports;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.PersonName;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProjectionQueryHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.util.G9Logger;
import com.gridnine.xtrip.common.model.helpers.util.LogUtil;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRestrictedEntityDataIndex;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.BranchIndex;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashIndex;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterIndex;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplaceIndex;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeDesignatorType;
import com.gridnine.xtrip.common.model.profile.CostCodeDisplayType;
import com.gridnine.xtrip.common.model.profile.CostCodeFillingPoint;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Manager;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.ResponsiblePerson;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.text.MaskFormatter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileHelper {
    public static final String SEPARATOR_COMMA_SPACE = ", ";
    public static final List<OrganizationType> FINANCE_ORG_TYPES = Arrays.asList(OrganizationType.CORPORATE_CLIENT, OrganizationType.AGENCY);
    public static final String SABRE_TECHNICAL_PROVIDER_PROFILE_UID = "sabre_technical_provider_profile";
    public static final String SABRE_TECHNICAL_PROVIDER_CONTRACT_UID = "sabre_technical_provider_contract";
    public static final String TECHNICAL_FEE_MODEL_CONTRACT_UID = "technical_fee_model_contract";
    public static final String TECHNICAL_FEE_SYSTEM_MODEL_CONTRACT_UID = "technical_fee_system_model_contract";
    public static final String TECHNICAL_FEE_FEE_PROPERTIES_UID = "technical_fee_fee_properties";
    public static final String TECHNICAL_FEE_COMMISSION_CATEGORY_CODE = "TECHNICAL_FEE";
    public static final String AGENCY_BONUS_COMMISSION_PROPERTIES_UID = "agency_bonus_commission_properties";
    public static final String TECHNICAL_FEE_RULES_SYNCHRONIZATION_TASK_JOB_CLASS = "com.gridnine.xtrip.server.model.synchronization.technicalFee.RulesSynchronizationTask";
    public static final String SUPPLIER_COMMISSION_PROPERTIES_UID = "SUPPLIER_COMMISSION_PROPERTIES";
    private static final EntityReference<CommissionProperties> SUPPLIER_COMMISSION_PROPERTIES_REF = new EntityReference("SUPPLIER_COMMISSION_PROPERTIES", CommissionProperties.class, "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 (\u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f)");
    public static final String SUPPLIER_COMMISSION_CATEGORY_UID = "SUPPLIER_COMMISSION";
    public static final Pattern SABRE_LOGIN_PATTERN = Pattern.compile("sabre_(.{4})_(.{2})");
    public static final String SABRE_LOGIN_FORMAT = "sabre_%s_%s";
    private static final Logger log = LoggerFactory.getLogger(ProfileHelper.class);
    private static final Map<String, String> CITY_PREFIX = new HashMap<String, String>();
    private static final FilterPersonPasports FILTER_PERSON_PASPORTS;
    private static final Pattern SPACE_PATTERN;
    private static final String PCC_AND_UNIQUE_IDS_DELIMITER = ":";
    public static final String CONTRACTOR_SUPPLIER_CONTAINER_UID = "contractor-SUPPLIER";
    public static final String CONTRACTOR_TECHNICAL_PROVIDER_CONTAINER_UID = "contractor-TECHNICAL_PROVIDER";
    public static final String CONTRACTOR_AGENCY_CONTAINER_UID = "contractor-AGENCY";
    public static final String CONTRACTOR_SUBAGENCY_CONTAINER_UID = "contractor-SUBAGENCY";
    public static final String CONTRACTOR_CLIENT_CONTAINER_UID = "contractor-CLIENT";

    public static String getCityPrefix(Locale locale) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        return language != null ? CITY_PREFIX.get(language.toUpperCase()) : null;
    }

    public static EntityContainer<Person> getPersonCtr(String login) {
        Objects.requireNonNull(login);
        return EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)login);
    }

    public static String getFullName(SalesPoint salesPoint) {
        if (salesPoint == null) {
            return null;
        }
        return ProfileHelper.getFullName(salesPoint.getCode(), salesPoint.getShortName(), salesPoint.getFullName(), null);
    }

    public static String getFullName(Branch branch, Locale locale, boolean strict) {
        if (branch == null) {
            return null;
        }
        return ProfileHelper.getFullName(branch.getCode(), branch.getShortName(), branch.getFullName(), null, locale, strict);
    }

    public static String getFullName(Holding holding, Locale locale, boolean strict) {
        if (holding == null) {
            return null;
        }
        return ProfileHelper.getFullName(holding.getCode(), holding.getShortName(), holding.getFullName(), (DictionaryReference<LegalForm>)holding.getLegalForm(), locale, strict);
    }

    public static String getFullName(Organization organization, Locale locale, boolean strict) {
        if (organization == null) {
            return null;
        }
        return ProfileHelper.getFullName(organization.getCode(), organization.getShortName(), organization.getFullName(), (DictionaryReference<LegalForm>)organization.getLegalForm(), locale, strict);
    }

    public static String getFullName(String code, L10nString shortLocalizationName, L10nString fullLocalizationName, DictionaryReference<LegalForm> legalFormRef, Locale locale, boolean strict) {
        return ProfileHelper.getFullName(code, shortLocalizationName, fullLocalizationName, legalFormRef, locale, strict, true);
    }

    public static String getFullName(String code, L10nString shortLocalizationName, L10nString fullLocalizationName, DictionaryReference<LegalForm> legalFormRef, Locale locale, boolean strict, boolean quotes) {
        String shortName = L10nStringHelper.getValue((L10nString)shortLocalizationName, (Locale)locale, (boolean)strict);
        String fullName = L10nStringHelper.getValue((L10nString)fullLocalizationName, (Locale)locale, (boolean)strict);
        return ProfileHelper.getFullName(code, shortName, fullName, legalFormRef, locale, quotes);
    }

    public static String getFullName(String code, String shortName, String fullName, DictionaryReference<LegalForm> legalFormRef, Locale locale, boolean quotes) {
        if (TextUtil.isBlank((String)fullName)) {
            if (TextUtil.isBlank((String)shortName)) {
                return code;
            }
            return shortName;
        }
        String legalForm = DictHelper.getShortLegalForm(legalFormRef, locale);
        if (legalFormRef != null && legalForm == null) {
            legalForm = legalFormRef.getCode();
        }
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank((String)legalForm)) {
            boolean ip = legalForm.equalsIgnoreCase("\u0418\u041f");
            result.append(legalForm).append(" ");
            if (!ip && quotes) {
                result.append("\"");
            }
            result.append(fullName);
            if (!ip && quotes) {
                result.append("\"");
            }
        } else {
            result.append(fullName);
        }
        return result.toString();
    }

    public static String getFullName(String code, String shortName, String fullName, DictionaryReference<LegalForm> legalFormRef) {
        return ProfileHelper.getFullName(code, shortName, fullName, legalFormRef, LocaleHelper.getCurrentLocale(), true);
    }

    public static String getFullName(Person person, Locale locale, boolean strict, boolean useInitials) {
        if (person == null) {
            return null;
        }
        String code = person.getCode();
        String lastName = L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale, (boolean)strict);
        String firstName = L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale, (boolean)strict);
        String middleName = L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)locale, (boolean)strict);
        if (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) && TextUtil.isBlank((String)middleName)) {
            return code;
        }
        return PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)useInitials, (Locale)locale, (boolean)strict);
    }

    public static String getFullName(Person person, Locale locale, boolean strict) {
        return ProfileHelper.getFullName(person, locale, strict, false);
    }

    public static String buildFullPhoneNumber(Communication phone) {
        StringBuilder fullPhoneNumber = new StringBuilder();
        if (!TextUtil.isBlank((String)phone.getCountryCode())) {
            fullPhoneNumber.append(String.format("+%s", phone.getCountryCode().trim()));
        }
        if (!TextUtil.isBlank((String)phone.getCityCode())) {
            if (fullPhoneNumber.length() > 0) {
                fullPhoneNumber.append(" ");
            }
            fullPhoneNumber.append(String.format("(%s)", phone.getCityCode().trim()));
        }
        if (!TextUtil.isBlank((String)phone.getSense())) {
            if (fullPhoneNumber.length() > 0) {
                fullPhoneNumber.append(" ");
            }
            fullPhoneNumber.append(String.format("%s", phone.getSense().trim()));
        }
        if (!TextUtil.isBlank((String)phone.getInternalNumber())) {
            if (fullPhoneNumber.length() > 0) {
                fullPhoneNumber.append(" ");
            }
            fullPhoneNumber.append(String.format("#%s", phone.getInternalNumber().trim()));
        }
        return fullPhoneNumber.toString();
    }

    public static String buildFullAddress(Address address, Locale locale, boolean strict) {
        return ProfileHelper.buildFullAddress(address, SEPARATOR_COMMA_SPACE, locale, strict);
    }

    public static String buildFullAddress(Address address, String separator, Locale locale, boolean strict) {
        return ProfileHelper.buildFullAddress(address, separator, locale, strict, true);
    }

    public static String buildFullAddress(Address address, String separator, Locale locale, boolean strict, boolean includeCountry) {
        return ProfileHelper.buildFullAddress(address, separator, locale, strict, includeCountry, true);
    }

    public static String buildFullAddress(Address address, String separator, Locale locale, boolean strict, boolean includeCountry, boolean includeZip) {
        String city;
        String region;
        if (address == null) {
            return null;
        }
        if (separator == null) {
            separator = SEPARATOR_COMMA_SPACE;
        }
        StringBuilder result = new StringBuilder();
        if (includeZip) {
            ProfileHelper.appendAddress(result, address.getZip(), separator);
        }
        if (includeCountry && address.getCountry() != null) {
            ProfileHelper.appendAddress(result, address.getCountry().toString(locale), separator);
        }
        String string = region = address.getRegion() != null ? address.getRegion().toString(locale) : null;
        if (TextUtil.nonBlank((String)region)) {
            ProfileHelper.appendAddress(result, region, separator);
        }
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getDistrict(), (Locale)locale, (boolean)strict), separator);
        String string2 = city = address.getCity() != null ? address.getCity().toString(locale) : null;
        if (!TextUtil.isBlank((String)city)) {
            String prefix = ProfileHelper.getCityPrefix(locale);
            ProfileHelper.appendAddress(result, prefix != null ? prefix + city : city, separator);
        }
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getTown(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getAddress(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getHouse(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getHousing(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getBuilding(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getPavilion(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getFlat(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getOffice(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, address.getPoBox(), separator);
        return result.toString();
    }

    public static List<String> buildFullAddressList(Address address, String separator, int maxLength, boolean isUpperCase, Locale locale, boolean strict) {
        if (address == null) {
            return null;
        }
        if (separator == null) {
            separator = SEPARATOR_COMMA_SPACE;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(L10nStringHelper.getValue((L10nString)address.getAddress(), (Locale)locale, (boolean)strict));
        values.add(L10nStringHelper.getValue((L10nString)address.getHouse(), (Locale)locale, (boolean)strict));
        values.add(L10nStringHelper.getValue((L10nString)address.getHousing(), (Locale)locale, (boolean)strict));
        values.add(L10nStringHelper.getValue((L10nString)address.getBuilding(), (Locale)locale, (boolean)strict));
        values.add(L10nStringHelper.getValue((L10nString)address.getPavilion(), (Locale)locale, (boolean)strict));
        values.add(L10nStringHelper.getValue((L10nString)address.getFlat(), (Locale)locale, (boolean)strict));
        values.add(L10nStringHelper.getValue((L10nString)address.getOffice(), (Locale)locale, (boolean)strict));
        values.add(address.getPoBox());
        values.add(L10nStringHelper.getValue((L10nString)address.getTown(), (Locale)locale, (boolean)strict));
        values.add(address.getCity() != null ? address.getCity().toString(locale) : null);
        values.add(L10nStringHelper.getValue((L10nString)address.getDistrict(), (Locale)locale, (boolean)strict));
        values.add(address.getRegion() != null ? address.getRegion().toString(locale) : null);
        values.add(address.getZip());
        if (address.getCountry() != null) {
            values.add(address.getCountry().toString(locale));
        }
        return ProfileHelper.createAddressList(values, separator, maxLength, isUpperCase);
    }

    public static String buildShortAddress(Address address, Locale locale, boolean strict) {
        return ProfileHelper.buildShortAddress(address, SEPARATOR_COMMA_SPACE, locale, strict);
    }

    public static String buildShortAddress(Address address, String separator, Locale locale, boolean strict) {
        if (address == null) {
            return null;
        }
        if (separator == null) {
            separator = SEPARATOR_COMMA_SPACE;
        }
        StringBuilder result = new StringBuilder();
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getAddress(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getHouse(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getHousing(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getBuilding(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getPavilion(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getFlat(), (Locale)locale, (boolean)strict), separator);
        ProfileHelper.appendAddress(result, L10nStringHelper.getValue((L10nString)address.getOffice(), (Locale)locale, (boolean)strict), separator);
        return result.toString();
    }

    public static List<Address> getOrganizationAddresses(Organization organization) {
        return ProfileHelper.getOrganizationAddresses(organization, new Date());
    }

    public static List<Address> getOrganizationAddresses(Organization organization, Date date) {
        return organization.getAddresses().stream().filter(address -> MiscUtil.isBetween((Date)address.getStartDate(), (Date)address.getEndDate(), (Date)(date != null ? date : new Date()))).collect(Collectors.toList());
    }

    private static void appendAddress(StringBuilder result, String newPart, String separator) {
        if (!TextUtil.isBlank((String)newPart)) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(newPart);
        }
    }

    private static StringBuilder appendList(List<String> list, StringBuilder result, String newPart, String separator, int maxLength, boolean putInList, boolean isUpperCase) {
        String prevLine = result.toString();
        ProfileHelper.appendAddress(result, newPart, separator);
        if (result.length() > maxLength) {
            list.add(isUpperCase ? prevLine.toUpperCase() : prevLine);
            while (newPart.length() > maxLength) {
                result = new StringBuilder();
                ProfileHelper.appendAddress(result, newPart.substring(0, maxLength), separator);
                list.add(isUpperCase ? result.toString().toUpperCase() : result.toString());
                newPart = newPart.substring(maxLength);
            }
            result = new StringBuilder();
            ProfileHelper.appendAddress(result, newPart, separator);
        } else if (putInList) {
            list.add(isUpperCase ? result.toString().toUpperCase() : result.toString());
        }
        return result;
    }

    public static List<String> createAddressList(List<String> values, String separator, int maxLength, boolean isUpperCase) {
        StringBuilder resultString = new StringBuilder();
        ArrayList<String> resultList = new ArrayList<String>();
        for (String value : values) {
            if (TextUtil.isBlank((String)value)) continue;
            resultString = ProfileHelper.appendList(resultList, resultString, value, separator, maxLength, false, isUpperCase);
        }
        ProfileHelper.appendList(resultList, resultString, "", separator, maxLength, true, isUpperCase);
        return resultList;
    }

    public static <E extends BaseEntity> E resolveReference(EntityReference<E> ref) {
        EntityContainer res = EntityStorageHelper.resolve(ref);
        return (E)(res == null ? null : res.getEntity());
    }

    private static <E extends BaseEntity> E safeResolveReference(EntityReference<E> ref) {
        try {
            return ProfileHelper.resolveReference(ref);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DictionaryReference<Airline> findAirline(EntityReference<Organization> ref) {
        try {
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (ctr == null) {
                return null;
            }
            if (((Organization)ctr.getEntity()).getAirline() != null) {
                return ((Organization)ctr.getEntity()).getAirline();
            }
            if (!TextUtil.isBlank((String)((Organization)ctr.getEntity()).getCode())) {
                return new AirlineReference(((Organization)ctr.getEntity()).getCode());
            }
            return null;
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + ref, (Throwable)e);
            return null;
        }
    }

    public static EntityReference<Contract> findTechnicalProviderContract() {
        EntityReference result = new EntityReference(SABRE_TECHNICAL_PROVIDER_CONTRACT_UID, Contract.class, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 Sabre");
        EntityStorage.get().actualize(result);
        return result;
    }

    public static EntityReference<SalesPoint> findSalesPointRef(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().find(SalesPointIndex.class, SalesPointIndex.Property.code.name(), (Object)code);
        if (ctr == null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)SalesPointIndex.Property.code.name(), (String)code));
            query.setResultMode(ResultMode.DATA_ONLY);
            query.getPreferredProperties().add(SalesPointIndex.Property.code.name());
            List data = EntityStorage.get().search(SalesPointIndex.class, query).getData();
            if (data.size() > 1) {
                throw Xeption.forAdmin((String)("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0442\u043e\u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c " + code), (Object[])new Object[0]);
            }
            return data.isEmpty() ? null : ((SalesPointIndex)data.get(0)).getSource();
        }
        return ctr.toReference();
    }

    public static EntityReference<Organization> findOrganizationRef(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        EntityContainer ctr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)code);
        if (ctr == null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)OrganizationIndex.Property.code.name(), (String)code));
            query.setResultMode(ResultMode.DATA_ONLY);
            query.getPreferredProperties().add(OrganizationIndex.Property.code.name());
            List data = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (data.size() > 1) {
                throw Xeption.forAdmin((String)("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439 \u0441 \u043a\u043e\u0434\u043e\u043c " + code), (Object[])new Object[0]);
            }
            return data.isEmpty() ? null : ((OrganizationIndex)data.get(0)).getSource();
        }
        return ctr.toReference();
    }

    public static String findOrganizationCode(EntityReference<Organization> ref) {
        try {
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            return ctr != null ? ((Organization)ctr.getEntity()).getCode() : null;
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + ref, (Throwable)e);
            return null;
        }
    }

    public static boolean isDomesticOrganization(Organization organization) {
        return ProfileHelper.isDomesticOrganization(organization, new Date());
    }

    public static boolean isDomesticOrganization(Organization organization, Date date) {
        for (Address address : ProfileHelper.getOrganizationAddresses(organization, date)) {
            Country country;
            if (address.getAddressType() != AddressType.LEGAL || address.getCountry() == null || (country = (Country)DictionaryCache.get().resolveReference(address.getCountry())) == null) continue;
            return country.isDomestic();
        }
        return true;
    }

    public static DictionaryReference<Country> getOrganizationCountry(Organization organization) {
        return ProfileHelper.getOrganizationCountry(organization, new Date());
    }

    public static DictionaryReference<Country> getOrganizationCountry(Organization organization, Date date) {
        for (Address address : ProfileHelper.getOrganizationAddresses(organization, date)) {
            if (address.getAddressType() != AddressType.LEGAL || address.getCountry() == null) continue;
            return address.getCountry();
        }
        return null;
    }

    public static boolean isOrganizationCode(EntityReference<Organization> organizationReference, String code) {
        if (organizationReference == null || TextUtil.isBlank((String)code)) {
            return false;
        }
        try {
            EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
            if (organizationContainer == null) {
                return false;
            }
            return ProfileHelper.isOrganizationCode((Organization)organizationContainer.getEntity(), code);
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + organizationReference, (Throwable)e);
            return false;
        }
    }

    public static boolean isOrganizationCode(Organization organization, String code) {
        if (organization == null || TextUtil.isBlank((String)code)) {
            return false;
        }
        String organizationCode = organization.getCode();
        return TextUtil.isSame((String)organizationCode, (String)code);
    }

    public static boolean isOrganizationType(EntityReference<Organization> organizationReference, OrganizationType type) {
        if (organizationReference == null || type == null) {
            return false;
        }
        try {
            EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
            if (organizationContainer == null) {
                return false;
            }
            return ProfileHelper.isOrganizationType((Organization)organizationContainer.getEntity(), type);
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + organizationReference, (Throwable)e);
            return false;
        }
    }

    public static boolean isOrganizationType(Organization organization, OrganizationType type) {
        if (organization == null || type == null) {
            return false;
        }
        return organization.getTypes().contains(type);
    }

    public static BigDecimal getCreditAmount(CreditLimitInfo creditLimitInfo) {
        BigDecimal creditAmount = BigDecimal.ZERO;
        if (creditLimitInfo == null) {
            return creditAmount;
        }
        if (creditLimitInfo.getCreditLimit() != null) {
            creditAmount = creditAmount.add(creditLimitInfo.getCreditLimit());
        }
        if (creditLimitInfo.getTerminalCreditLimit() != null && MiscUtil.isBetween((Date)creditLimitInfo.getTerminalCreditDateStart(), (Date)creditLimitInfo.getTerminalCreditDateEnd(), (Date)new Date())) {
            creditAmount = creditAmount.add(creditLimitInfo.getTerminalCreditLimit());
        }
        return creditAmount;
    }

    public static BigDecimal getOrganizationCreditAmount(EntityReference<Organization> clientReference, EntityReference<Organization> agencyReference) {
        CreditLimitInfo clientCreditLimitInfo = ProfileHelper.getOrganizationCreditLimit(clientReference, agencyReference);
        return ProfileHelper.getCreditAmount(clientCreditLimitInfo);
    }

    public static CreditLimitInfo getOrganizationCreditLimit(EntityReference<Organization> clientReference, EntityReference<Organization> agencyReference) {
        if (clientReference == null || agencyReference == null) {
            return null;
        }
        return ProfileHelper.getOrganizationCreditLimit((EntityContainer<Organization>)EntityStorage.get().resolve(clientReference), agencyReference);
    }

    public static CreditLimitInfo getOrganizationCreditLimit(EntityContainer<Organization> clientCtr, EntityReference<Organization> agencyReference) {
        if (clientCtr == null || agencyReference == null) {
            return null;
        }
        try {
            if (clientCtr.getEntity() != null) {
                Organization client = (Organization)clientCtr.getEntity();
                for (CreditLimitInfo clientCreditLimitInfo : client.getFinanceRestrictions().getCreditLimits()) {
                    if (clientCreditLimitInfo.getCreditor() == null || !clientCreditLimitInfo.getCreditor().getUid().equals(agencyReference.getUid())) continue;
                    return clientCreditLimitInfo;
                }
            }
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + clientCtr, (Throwable)e);
        }
        return null;
    }

    public static BigDecimal getPersonCreditAmount(EntityReference<Person> agentReference, EntityReference<Organization> clientReference) {
        CreditLimitInfo agentCreditLimitInfo = ProfileHelper.getPersonCreditLimit(agentReference, clientReference);
        return ProfileHelper.getCreditAmount(agentCreditLimitInfo);
    }

    public static CreditLimitInfo getPersonCreditLimit(EntityReference<Person> agentReference, EntityReference<Organization> clientReference) {
        G9Logger logger = LogUtil.newBalanceLog();
        logger.debug("execute ", ProfileHelper.class.getName(), ".getPersonCreditLimit(", agentReference, SEPARATOR_COMMA_SPACE, clientReference, ")");
        if (agentReference == null) {
            logger.debug("no agentReference => no credit limit");
            return null;
        }
        if (clientReference == null) {
            logger.debug("no clientReference => no credit limit");
            return null;
        }
        try {
            EntityContainer agentContainer = EntityStorage.get().resolve(agentReference);
            return ProfileHelper.getPersonCreditLimit((EntityContainer<Person>)agentContainer, clientReference);
        }
        catch (Exception e) {
            logger.error((Object)("unable to resolve reference " + agentReference), e);
            return null;
        }
    }

    public static CreditLimitInfo getPersonCreditLimit(EntityContainer<Person> agentContainer, EntityReference<Organization> clientReference) {
        CreditLimitInfo result = null;
        G9Logger logger = LogUtil.newBalanceLog();
        logger.debug("execute ", ProfileHelper.class.getName(), ".getPersonCreditLimit(", agentContainer, SEPARATOR_COMMA_SPACE, clientReference, ")");
        if (clientReference == null) {
            logger.debug("no clientReference => no credit limit");
        } else if (agentContainer == null || agentContainer.getEntity() == null) {
            logger.debug("no agentContainer => no credit limit");
        } else {
            String clientUid = clientReference.getUid();
            Person agent = (Person)agentContainer.getEntity();
            for (CreditLimitInfo agentCreditLimitInfo : agent.getFinanceRestrictions().getCreditLimits()) {
                EntityReference creditor = agentCreditLimitInfo.getCreditor();
                if (creditor == null || !creditor.getUid().equals(clientUid)) continue;
                result = agentCreditLimitInfo;
                break;
            }
            if (logger.isDebugEnabled()) {
                if (result != null) {
                    logger.debug("agent finance restrictions contain credit info for the client: ", result);
                } else {
                    logger.debug("agent finance restrictions don't contain credit info for the client UID=", clientUid);
                }
            }
        }
        return result;
    }

    public static Set<ManagerType> getStandardPositions(List<PersonEmployment> employments, EntityReference<Organization> organization) {
        HashSet<ManagerType> standardPositions = new HashSet<ManagerType>();
        for (PersonEmployment employment : employments) {
            ManagerType standardPosition;
            if (employment.getOrganization() == null || !employment.getOrganization().equals(organization) || employment.getPosition() == null || (standardPosition = DictHelper.getDictionaryStandardValueType(employment.getPosition(), ManagerType.class)) == null) continue;
            standardPositions.add(standardPosition);
        }
        return standardPositions;
    }

    public static Set<PersonPosition> getPositions(List<PersonEmployment> employments, EntityReference<Organization> organization) {
        HashSet<PersonPosition> positions = new HashSet<PersonPosition>();
        for (PersonEmployment employment : employments) {
            PersonPosition position;
            if (employment.getOrganization() == null || !employment.getOrganization().equals(organization) || employment.getPosition() == null || (position = (PersonPosition)DictionaryCache.get().resolveReference(employment.getPosition())) == null) continue;
            positions.add(position);
        }
        return positions;
    }

    public static String getManagerString(Manager manager) {
        StringBuilder stringBuilder = new StringBuilder();
        if (manager != null) {
            if (manager.getName() != null) {
                stringBuilder.append(manager.getName());
            }
            if (manager.getType() != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" - ");
                }
                stringBuilder.append(manager.getType());
            }
        }
        return stringBuilder.toString();
    }

    public static EntityReference<Person> getManager(EntityReference<Organization> organizationReference, ManagerType managerType, Date date) {
        if (organizationReference == null) {
            return null;
        }
        try {
            EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
            if (organizationContainer != null) {
                Organization organization = (Organization)organizationContainer.getEntity();
                for (ResponsiblePerson responsiblePerson : organization.getResponsiblePersons()) {
                    EntityContainer personContainer = EntityStorage.get().resolve(responsiblePerson.getPerson());
                    Person person = (Person)personContainer.getEntity();
                    if (!ProfileHelper.getOpendStandardPositions(person.getEmployments(), organizationReference, date).contains(managerType)) continue;
                    return responsiblePerson.getPerson();
                }
            }
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + organizationReference, (Throwable)e);
        }
        return null;
    }

    public static Set<ManagerType> getOpendStandardPositions(List<PersonEmployment> employments, EntityReference<Organization> organization, Date date) {
        HashSet<ManagerType> standardPositions = new HashSet<ManagerType>();
        for (PersonEmployment employment : employments) {
            ManagerType standardPosition;
            if (employment.getOrganization() == null || !employment.getOrganization().equals(organization) || employment.getPosition() == null || !MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)date) || (standardPosition = DictHelper.getDictionaryStandardValueType(employment.getPosition(), ManagerType.class)) == null) continue;
            standardPositions.add(standardPosition);
        }
        return standardPositions;
    }

    public static String getBankAccountString(BankAccount bankAcount) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bankAcount != null) {
            if (bankAcount.getBankName() != null) {
                stringBuilder.append(bankAcount.getBankName());
            }
            if (bankAcount.getSettlementAccount() != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" - ");
                }
                stringBuilder.append(bankAcount.getSettlementAccount());
            }
        }
        return stringBuilder.toString();
    }

    public static List<String> getBankNames(EntityReference<Organization> organizationReference) {
        if (organizationReference == null) {
            return Collections.emptyList();
        }
        try {
            EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
            if (organizationContainer != null) {
                Organization organization = (Organization)organizationContainer.getEntity();
                HashMap<String, String> bankNames = new HashMap<String, String>();
                for (BankAccount bankAccount : organization.getBankAccounts()) {
                    String bik = bankAccount.getBik();
                    String bankName = bankAccount.getBankName();
                    if (TextUtil.isBlank((String)bik) || TextUtil.isBlank((String)bankName)) continue;
                    bankNames.put(bik, bankName);
                }
                return new ArrayList<String>(bankNames.values());
            }
        }
        catch (Exception e) {
            log.error("unable to resolve reference " + organizationReference, (Throwable)e);
        }
        return Collections.emptyList();
    }

    public static String findAccountingCode(EntityReference<Organization> client) {
        EntityContainer ctr = EntityStorage.get().resolve(client);
        if (ctr == null) {
            return null;
        }
        String res = SystemHelper.findMetadataAsString(((Organization)ctr.getEntity()).getMetadata(), MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
        if (res != null) {
            return res;
        }
        return ((Organization)ctr.getEntity()).getCode();
    }

    public static List<EntityContainer<? extends BaseRulesContainer>> getRuleContainers(EntityContainer<Contract> contractCtr, Date date) {
        return ProfileHelper.getRuleContainers(contractCtr, date, Collections.emptySet());
    }

    public static List<EntityContainer<? extends BaseRulesContainer>> getRuleContainers(EntityContainer<Contract> contractCtr, Date date, Set<String> targets) {
        if (contractCtr == null) {
            return Collections.emptyList();
        }
        Contract contract = (Contract)contractCtr.getEntity();
        if (contract.isNewModel()) {
            return ProfileHelper.getRuleContainersData(contractCtr, date, targets).stream().map(RuleContainerData::getContainer).collect(Collectors.toList());
        }
        return contract.getRuleSet() != null ? Collections.singletonList(contractCtr) : Collections.emptyList();
    }

    public static EntityContainer<Contract> getDefaultContract(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), supplierRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customerRef));
        Date date = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        List contractIndexes = EntityStorage.get().search(ContractIndex.class, query).getData();
        return ProfileHelper.getDefaultContract(contractIndexes);
    }

    public static boolean checkPersonParametersForGetThere(List<PersonEmployment> employments) {
        if (employments == null || employments.isEmpty()) {
            log.debug("Employments not found");
            return false;
        }
        for (PersonEmployment pemp : employments) {
            if (pemp == null) {
                log.debug("Person employment is null");
                return false;
            }
            if (pemp.getOrganization() == null) {
                log.debug("Person employment organization is null");
                return false;
            }
            EntityContainer eco = EntityStorage.get().resolve(pemp.getOrganization());
            if (eco == null) {
                log.debug("Employment organization not found in entity storage");
                return false;
            }
            Organization organization = (Organization)eco.getEntity();
            if (organization == null) {
                log.debug("Employment organization is null");
                return false;
            }
            for (Metadata metadata : organization.getMetadata()) {
                if (!ProfileHelper.checkMetadata(metadata)) continue;
                log.debug("checkPersonParametersForGetThere is true");
                return true;
            }
        }
        return false;
    }

    private static boolean checkMetadata(Metadata metadata) {
        return metadata != null && metadata.getKey() != null && metadata.getKey().getCode() != null && metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_GET_THERE_SYNC.name()) && metadata.getValue() != null && (Boolean)metadata.getValue() != false;
    }

    public static List<RuleContainerData> getRuleContainersData(EntityContainer<Contract> contractCtr, Date date) {
        return ProfileHelper.getRuleContainersData(contractCtr, date, Collections.emptySet());
    }

    public static List<RuleContainerData> getRuleContainersData(EntityContainer<Contract> contractCtr, Date date, Set<String> targets) {
        ArrayList<EntityReference> agencies;
        List<EntityContainer> mccl;
        if (contractCtr == null) {
            return Collections.emptyList();
        }
        Contract contract = (Contract)contractCtr.getEntity();
        Date dateDayBegin = MiscUtil.clearTime((Date)date);
        Date dateDayEnd = MiscUtil.setDayEndTime((Date)date);
        HashMap data = new HashMap();
        Consumer<RuleContainerData> add = item -> data.merge(item.getContainer(), item, (o, n) -> o.isTranslateSupplierFees() != null ? o : n);
        contract.getModelContracts().stream().filter(c2mc -> null == date || (c2mc.getStartDate() == null || !dateDayEnd.before(c2mc.getStartDate())) && (c2mc.getEndDate() == null || !dateDayBegin.after(c2mc.getEndDate()))).forEach(c2mc -> {
            EntityContainer mcCtr = EntityStorage.get().resolve(c2mc.getModelContract());
            if (null == mcCtr || ((ModelContract)mcCtr.getEntity()).getRuleSet() == null) {
                return;
            }
            add.accept(new RuleContainerData((EntityContainer<ModelContract>)mcCtr, c2mc.isTranslateSupplierFees()));
        });
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        ContractType contractType = contract.getContractType();
        if (contractType != null) {
            criterions.add(SearchCriterion.eq((String)ModelContractIndex.Property.contractType.name(), (Object)contractType));
        }
        if (contract.getSupplier() != null) {
            criterions.add(SearchCriterion.contains((String)ModelContractIndex.Property.suppliers.name(), (Object)contract.getSupplier()));
        }
        if (contract.getCustomer() != null) {
            criterions.add(SearchCriterion.contains((String)ModelContractIndex.Property.customers.name(), (Object)contract.getCustomer()));
        }
        if (!targets.isEmpty()) {
            criterions.add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])targets.stream().map(target -> SearchCriterion.contains((String)ModelContractIndex.Property.targetNames.name(), (Object)target)).toArray(SearchCriterion[]::new))));
        }
        if ((mccl = SearchHelper.searchEntity(ModelContractIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0]))}).stream().map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).filter(mcc -> ((ModelContract)mcc.getEntity()).getRuleSet() != null).collect(Collectors.toList())).stream().anyMatch(mcc -> !((ModelContract)mcc.getEntity()).getAgencies().isEmpty())) {
            EntityContainer orgCtr;
            agencies = new ArrayList<EntityReference>();
            HashSet<EntityReference> refList = new HashSet<EntityReference>();
            EntityReference ref = contract.getSupplier();
            while (ref != null && !refList.contains(ref) && null != (orgCtr = EntityStorage.get().resolve(ref))) {
                refList.add(ref);
                Organization org = (Organization)orgCtr.getEntity();
                if (org.getTypes().contains(OrganizationType.AGENCY)) {
                    agencies.add(ref);
                }
                ref = org.getParent();
            }
        } else {
            agencies = null;
        }
        mccl.forEach(mcc -> {
            ModelContract mc = (ModelContract)mcc.getEntity();
            if (!mc.getAgencies().isEmpty() && agencies != null && mc.getAgencies().stream().noneMatch(mc2o -> !(mc2o.getOrganization() == null || !agencies.contains(mc2o.getOrganization()) || null != date && (mc2o.getStartDate() != null && dateDayEnd.before(mc2o.getStartDate()) || mc2o.getEndDate() != null && dateDayBegin.after(mc2o.getEndDate()))))) {
                return;
            }
            if (contractType != null && mc.getContractType() == contractType) {
                add.accept(new RuleContainerData((EntityContainer<ModelContract>)mcc, null));
                return;
            }
            mc.getSuppliers().stream().filter(mc2o -> !(mc2o.getOrganization() == null || !mc2o.getOrganization().equals((Object)contract.getSupplier()) || null != date && (mc2o.getStartDate() != null && dateDayEnd.before(mc2o.getStartDate()) || mc2o.getEndDate() != null && dateDayBegin.after(mc2o.getEndDate())))).forEach(mc2o -> add.accept(new RuleContainerData((EntityContainer<ModelContract>)mcc, null)));
            mc.getCustomers().stream().filter(mc2o -> !(mc2o.getOrganization() == null || !mc2o.getOrganization().equals((Object)contract.getCustomer()) || null != date && (mc2o.getStartDate() != null && dateDayEnd.before(mc2o.getStartDate()) || mc2o.getEndDate() != null && dateDayBegin.after(mc2o.getEndDate())))).forEach(mc2o -> add.accept(new RuleContainerData((EntityContainer<ModelContract>)mcc, null)));
        });
        return data.values().stream().sorted((o1, o2) -> {
            double p2;
            ModelContract mc1 = (ModelContract)o1.getContainer().getEntity();
            ModelContract mc2 = (ModelContract)o2.getContainer().getEntity();
            double p1 = mc1.getPriority();
            if (p1 != (p2 = mc2.getPriority())) {
                return p1 > p2 ? -1 : 1;
            }
            Function<ModelContract, Integer> weight = mc -> {
                int i;
                int n = i = contractType != null && mc.getContractType() == contractType || mc.getCustomers().stream().anyMatch(mc2o -> Objects.equals(contract.getCustomer(), mc2o.getOrganization())) ? 4 : 0;
                if (contractType != null && mc.getContractType() == contractType || mc.getSuppliers().stream().anyMatch(mc2o -> Objects.equals(contract.getCustomer(), mc2o.getOrganization()))) {
                    i += contractType != ContractType.CLIENT ? 2 : 1;
                }
                return i;
            };
            return Integer.compare(weight.apply(mc1), weight.apply(mc2));
        }).collect(Collectors.toList());
    }

    public static RuleSet getRuleSet(EntityContainer<? extends BaseRulesContainer> container) {
        Contract.class.isAssignableFrom(container.getEntityType());
        return ((BaseRulesContainer)container.getEntity()).getRuleSet();
    }

    public static EntityContainer<Contract> getDefaultContract(Collection<ContractIndex> contractIndexes) {
        List contracts = contractIndexes.stream().sorted((o1, o2) -> {
            if (o1.isDefaultContract() != o2.isDefaultContract()) {
                return o1.isDefaultContract() ? -1 : 1;
            }
            return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
        }).map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
        if (!contracts.isEmpty()) {
            EntityContainer contract = (EntityContainer)contracts.get(0);
            if (contracts.size() == 1 || ((Contract)contract.getEntity()).isDefaultContract() && !((Contract)((EntityContainer)contracts.get(1)).getEntity()).isDefaultContract()) {
                return contract;
            }
        }
        return null;
    }

    public static EntityContainer<Contract> getDefaultContract(List<EntityContainer<Contract>> contracts) {
        List result = contracts.stream().sorted((o1, o2) -> {
            if (((Contract)o1.getEntity()).isDefaultContract() != ((Contract)o2.getEntity()).isDefaultContract()) {
                return ((Contract)o1.getEntity()).isDefaultContract() ? -1 : 1;
            }
            return -MiscUtil.compare((Date)((Contract)o1.getEntity()).getIssueDate(), (Date)((Contract)o2.getEntity()).getIssueDate(), (boolean)true);
        }).collect(Collectors.toList());
        if (!result.isEmpty()) {
            EntityContainer contract = (EntityContainer)result.get(0);
            if (result.size() == 1 || ((Contract)contract.getEntity()).isDefaultContract() && !((Contract)((EntityContainer)result.get(1)).getEntity()).isDefaultContract()) {
                return contract;
            }
        }
        return null;
    }

    public static List<MiscUtil.Pair<String, String>> getAllCostCodes(CostCodeProperties ccp, EntityReference<Organization> orgRef, EntityReference<Person> travelerRef, boolean useLocalValues) {
        ArrayList<MiscUtil.Pair<String, String>> res = new ArrayList<MiscUtil.Pair<String, String>>(ProfileHelper.getAllCostCodesForOrganization(ccp, orgRef, useLocalValues));
        Person traveler = null;
        try {
            traveler = ProfileHelper.resolveReference(travelerRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (traveler != null) {
            traveler.getCostCodes().stream().filter(cc -> cc.getCostCodeProperties().equals((Object)ccp) && !TextUtil.isBlank((String)cc.getValue())).map(cc -> new MiscUtil.Pair((Object)cc.getValue(), (Object)(useLocalValues && !TextUtil.isBlank((String)cc.getLocalValue()) ? cc.getLocalValue() : cc.getValue()))).forEach(res::add);
        }
        return res;
    }

    public static Set<String> getCostCodes(CostCodeProperties ccp, EntityReference<Organization> orgRef, EntityReference<Person> travelerRef, boolean useLocalValues) {
        return ProfileHelper.getAllCostCodes(ccp, orgRef, travelerRef, useLocalValues).stream().map(MiscUtil.Pair::getSecond).collect(Collectors.toSet());
    }

    public static Set<String> getCostCodes(CostCodeProperties ccp, EntityReference<Organization> orgRef, EntityReference<Organization> subagencyRef, EntityReference<Person> travelerRef) {
        CostCodeDisplayType subagencyCostCodeDisplayType = null;
        try {
            Organization subagency = ProfileHelper.safeResolveReference(subagencyRef);
            if (subagency != null) {
                subagencyCostCodeDisplayType = subagency.getCostCodeDefaultDisplayType();
            }
        }
        catch (Exception subagency) {
            // empty catch block
        }
        HashSet<String> res = new HashSet<String>(ProfileHelper.getCostCodesForOrganization(ccp, orgRef, subagencyCostCodeDisplayType));
        Person traveler = null;
        try {
            traveler = ProfileHelper.resolveReference(travelerRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (traveler != null) {
            for (CostCode cc : traveler.getCostCodes()) {
                if (!cc.getCostCodeProperties().equals((Object)ccp)) continue;
                res.add(ProfileHelper.getCostCodeValue(cc, ccp.getDisplayType() != null ? ccp.getDisplayType() : subagencyCostCodeDisplayType));
            }
        }
        return res;
    }

    public static List<String> getCostCodesForOrganization(CostCodeProperties ccp, EntityReference<Organization> orgRef, boolean useLocalValues) {
        return ProfileHelper.getAllCostCodesForOrganization(ccp, orgRef, useLocalValues).stream().map(MiscUtil.Pair::getSecond).collect(Collectors.toList());
    }

    public static List<MiscUtil.Pair<String, String>> getAllCostCodesForOrganization(CostCodeProperties ccp, EntityReference<Organization> orgRef, boolean useLocalValues) {
        Organization org = ProfileHelper.safeResolveReference(orgRef);
        if (null == org) {
            return Collections.emptyList();
        }
        return org.getCostCodes().stream().filter(cc -> cc.getCostCodeProperties().equals((Object)ccp) && !TextUtil.isBlank((String)cc.getValue())).map(cc -> new MiscUtil.Pair((Object)cc.getValue(), (Object)(useLocalValues && !TextUtil.isBlank((String)cc.getLocalValue()) ? cc.getLocalValue() : cc.getValue()))).collect(Collectors.toList());
    }

    public static Set<String> getCostCodesForOrganization(CostCodeProperties ccp, EntityReference<Organization> orgRef, CostCodeDisplayType subagencyCostCodeDisplayType) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        Organization org = ProfileHelper.safeResolveReference(orgRef);
        if (org != null) {
            for (CostCode cc : org.getCostCodes()) {
                if (!cc.getCostCodeProperties().equals((Object)ccp)) continue;
                res.add(ProfileHelper.getCostCodeValue(cc, ccp.getDisplayType() != null ? ccp.getDisplayType() : subagencyCostCodeDisplayType));
            }
        }
        return res;
    }

    public static String getCostCodeValue(CostCode cc, CostCodeDisplayType displayType) {
        if (cc == null) {
            return null;
        }
        if (displayType == CostCodeDisplayType.LOCAL_VALUE) {
            return !TextUtil.isBlank((String)cc.getLocalValue()) ? cc.getLocalValue() : cc.getValue();
        }
        if (displayType == CostCodeDisplayType.ENGLISH_VALUE) {
            return !TextUtil.isBlank((String)cc.getEnglishValue()) ? cc.getEnglishValue() : cc.getValue();
        }
        return cc.getValue();
    }

    public static void setCostCodeValue(CostCode cc, CostCodeDisplayType displayType, String value) {
        if (cc == null) {
            return;
        }
        if (displayType == CostCodeDisplayType.LOCAL_VALUE) {
            cc.setLocalValue(value);
            return;
        }
        if (displayType == CostCodeDisplayType.ENGLISH_VALUE) {
            cc.setEnglishValue(value);
            return;
        }
        cc.setValue(value);
    }

    public static List<CostCodeProperties> getCostCodePropertiesForOrganization(EntityReference<Organization> orgRef, CostCodeType type, String shortName, String value, Function<CostCodeCategory, String> shortNameGetter) {
        Organization org = ProfileHelper.safeResolveReference(orgRef);
        return org == null ? Collections.emptyList() : ProfileHelper.getCostCodePropertiesForOrganization(org, org.getCostCodeProperties(), type, shortName, value, shortNameGetter);
    }

    public static List<CostCodeProperties> getCostCodePropertiesForOrganization(Organization organization, Collection<CostCodeProperties> costCodeProperties, CostCodeType type, String shortName, String value, Function<CostCodeCategory, String> shortNameGetter) {
        if (organization == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<CostCodeProperties> res = new LinkedHashSet<CostCodeProperties>();
        if (shortName != null) {
            shortName = shortName.replace(".", "").trim().toUpperCase();
        }
        boolean hasValuesForThatUdidType = false;
        boolean hasPropertiesWithoutCostCodes = false;
        HashMap<DictionaryReference<CostCodeCategory>, String> cat2Name = new HashMap<DictionaryReference<CostCodeCategory>, String>();
        LinkedHashMap propertiesToCostCodes = new LinkedHashMap();
        costCodeProperties.forEach(properties -> {
            List costCodes = organization.getCostCodes().stream().filter(costCode -> properties.equals((Object)costCode.getCostCodeProperties())).collect(Collectors.toList());
            propertiesToCostCodes.computeIfAbsent(properties, k -> new ArrayList()).addAll(costCodes);
        });
        for (Map.Entry entry : propertiesToCostCodes.entrySet()) {
            CostCodeProperties ccp = (CostCodeProperties)entry.getKey();
            List codes = (List)entry.getValue();
            if (ProfileHelper.isSameType(ccp, type) || !ProfileHelper.sameCatName((DictionaryReference<CostCodeCategory>)ccp.getCategory(), shortName, cat2Name, shortNameGetter) || !ProfileHelper.fitsMask(value, ccp.getMask())) continue;
            hasValuesForThatUdidType = true;
            if (codes.isEmpty()) {
                hasPropertiesWithoutCostCodes = true;
                continue;
            }
            if (!codes.stream().anyMatch(code -> code != null && code.getValue() != null && (code.getValue().length() > 30 ? code.getValue().startsWith(value) || code.getLocalValue() != null && code.getLocalValue().startsWith(value) || code.getEnglishValue() != null && code.getEnglishValue().startsWith(value) : TextUtil.isSame((String)code.getValue(), (String)value, (boolean)true) || TextUtil.isSame((String)code.getLocalValue(), (String)value, (boolean)true) || TextUtil.isSame((String)code.getEnglishValue(), (String)value, (boolean)true)))) continue;
            res.add(ccp);
        }
        if (!res.isEmpty()) {
            if (type != null || TextUtil.nonBlank((String)shortName)) {
                return new ArrayList<CostCodeProperties>(res);
            }
        } else if (!organization.getCostCodes().isEmpty() && hasValuesForThatUdidType && !hasPropertiesWithoutCostCodes) {
            return Collections.emptyList();
        }
        for (CostCodeProperties ccp : propertiesToCostCodes.keySet()) {
            if (ProfileHelper.isSameType(ccp, type) || !ProfileHelper.sameCatName((DictionaryReference<CostCodeCategory>)ccp.getCategory(), shortName, cat2Name, shortNameGetter) || !ProfileHelper.fitsMask(value, ccp.getMask())) continue;
            res.add(ccp);
        }
        return new ArrayList<CostCodeProperties>(res);
    }

    private static boolean isSameType(CostCodeProperties ccp, CostCodeType type) {
        return ccp != null && ccp.getType() != null && type != null && ccp.getType() != type;
    }

    private static boolean fitsMask(String value, String mask) {
        boolean isStringValid = true;
        if (!TextUtil.isBlank((String)mask)) {
            try {
                MaskFormatter formatter = new MaskFormatter(mask);
                formatter.stringToValue(value);
            }
            catch (ParseException e) {
                isStringValid = false;
            }
        }
        return isStringValid;
    }

    private static boolean sameCatName(DictionaryReference<CostCodeCategory> category, String catName, Map<DictionaryReference<CostCodeCategory>, String> cat2Name, Function<CostCodeCategory, String> shortNameGetter) {
        String thisCatName;
        if (catName == null) {
            return true;
        }
        if (cat2Name.containsKey(category)) {
            thisCatName = cat2Name.get(category);
        } else {
            CostCodeCategory cat = (CostCodeCategory)DictionaryCache.get().resolveReference(category);
            thisCatName = cat != null && shortNameGetter.apply(cat) != null ? shortNameGetter.apply(cat).replace(".", "").trim().toUpperCase() : "";
            cat2Name.put(category, thisCatName);
        }
        if (catName.length() <= 15 && thisCatName.length() > 15) {
            thisCatName = thisCatName.substring(0, 15);
        }
        return TextUtil.isSame((String)catName, (String)thisCatName);
    }

    public static CostCodeType getCostCodeTypeByNumber(int number) {
        CostCodeType result = null;
        for (CostCodeType costCodeType : CostCodeType.values()) {
            if (costCodeType.ordinal() != number) continue;
            result = costCodeType;
            break;
        }
        return result;
    }

    public static boolean isCostCodePropertiesExists(CostCodeProperties ccp, EntityReference<Organization> orgRef) {
        boolean result = false;
        if (ccp == null || orgRef == null) {
            return false;
        }
        Organization organization = ProfileHelper.safeResolveReference(orgRef);
        if (organization != null) {
            for (CostCodeProperties ccpInOrg : organization.getCostCodeProperties()) {
                if (!ProfileHelper.areCostCodePropertiesEqual(ccpInOrg, ccp)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean areCostCodePropertiesEqual(CostCodeProperties ccp1, CostCodeProperties ccp2) {
        if (ccp1 == null || ccp2 == null) {
            return false;
        }
        boolean isTypeEqual = ccp1.getType() != null && ccp1.getType().equals((Object)ccp2.getType()) || ccp1.getType() == null && ccp2.getType() == null;
        boolean isCategoryEqual = ccp1.getCategory() != null && ccp1.getCategory().equals((Object)ccp2.getCategory()) || ccp1.getCategory() == null && ccp2.getCategory() == null;
        return isTypeEqual && isCategoryEqual && TextUtil.isSame((String)ccp1.getName(), (String)ccp2.getName(), (boolean)true) && TextUtil.isSame((String)ccp1.getMask(), (String)ccp2.getMask(), (boolean)true);
    }

    public static boolean isCostCodeExists(CostCodeProperties ccp, EntityReference<Organization> orgRef, String costCodeValue) {
        boolean result = false;
        if (ccp == null || orgRef == null || costCodeValue == null) {
            return false;
        }
        Set<String> costCodes = ProfileHelper.getCostCodes(ccp, orgRef, null, false);
        if (!costCodes.isEmpty() && costCodes.contains(costCodeValue)) {
            result = true;
        }
        return result;
    }

    public static List<ReasonCode> getReasonCodes(EntityReference<Organization> orgRef, ReasonCodeType reasonCodeType) {
        ArrayList<ReasonCode> result = new ArrayList<ReasonCode>();
        Organization organization = ProfileHelper.safeResolveReference(orgRef);
        if (organization != null) {
            for (ReasonCode reasonCode : organization.getReasonCodes()) {
                if (reasonCode.getType() != reasonCodeType) continue;
                result.add(reasonCode);
            }
        }
        return result;
    }

    public static List<CostCodeProperties> getCostCodesProperties(EntityReference<Organization> orgRef) {
        ArrayList<CostCodeProperties> result = new ArrayList<CostCodeProperties>();
        Organization organization = ProfileHelper.safeResolveReference(orgRef);
        if (organization != null) {
            result.addAll(organization.getCostCodeProperties());
        }
        return result;
    }

    public static ReasonCode getReasonCode(EntityReference<Organization> orgRef, ReasonCodeType reasonCodeType, String reasonCodeName) {
        ReasonCode result = null;
        Organization organization = ProfileHelper.safeResolveReference(orgRef);
        if (organization != null) {
            for (ReasonCode reasonCode : organization.getReasonCodes()) {
                if (reasonCode.getType() != reasonCodeType || !reasonCode.getName().equals(reasonCodeName)) continue;
                result = reasonCode;
                break;
            }
        }
        return result;
    }

    public static boolean isReasonCodeExists(EntityReference<Organization> orgRef, ReasonCodeType reasonCodeType, String reasonCodeName) {
        boolean result = false;
        Organization organization = ProfileHelper.safeResolveReference(orgRef);
        if (organization != null) {
            for (ReasonCode reasonCode : organization.getReasonCodes()) {
                if (reasonCode.getType() != reasonCodeType || !reasonCode.getName().equals(reasonCodeName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isIndividualCashRemains(EntityReference<SalesPoint> salesPoint) {
        EntityContainer agencyContainer;
        EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPoint);
        if (salesPointContainer != null && (agencyContainer = EntityStorage.get().resolve(((SalesPoint)salesPointContainer.getEntity()).getAgency())) != null) {
            return ((Organization)agencyContainer.getEntity()).isIndividualCashRemains();
        }
        return false;
    }

    public static boolean isOrganizationIndividualCashRemains(EntityReference<Organization> organization) {
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        if (organizationContainer != null) {
            return ((Organization)organizationContainer.getEntity()).isIndividualCashRemains();
        }
        return false;
    }

    public static FopPaymentInfo getFopPaymentInfo(EntityReference<SalesPoint> salesPointReference, PaymentType paymentType) {
        return ProfileHelper.getFopPaymentInfo(salesPointReference, paymentType, true);
    }

    public static FopPaymentInfo getFopPaymentInfo(EntityReference<SalesPoint> salesPointReference, PaymentType paymentType, boolean strict) {
        EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
        if (salesPointContainer != null) {
            SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
            for (FopPaymentInfo fopPaymentInfo : salesPoint.getFopPaymentInfos()) {
                if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                return fopPaymentInfo;
            }
            EntityContainer branchContainer = EntityStorage.get().resolve(salesPoint.getBranch());
            if (branchContainer != null) {
                Branch branch = (Branch)branchContainer.getEntity();
                for (FopPaymentInfo fopPaymentInfo : branch.getFopPaymentInfos()) {
                    if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                    return fopPaymentInfo;
                }
            }
            return FinanceHelper.getFopPaymentInfo((EntityReference<Organization>)salesPoint.getAgency(), paymentType, strict);
        }
        return null;
    }

    public static FopPaymentInfo getFopPaymentInfo(EntityReference<Organization> subagencyReference, EntityReference<Branch> branchReference, EntityReference<SalesPoint> salesPointReference, PaymentType paymentType) {
        EntityContainer subagencyContainer;
        EntityContainer branchContainer;
        EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
        if (salesPointContainer != null) {
            SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
            for (FopPaymentInfo fopPaymentInfo : salesPoint.getFopPaymentInfos()) {
                if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                return fopPaymentInfo;
            }
        }
        if ((branchContainer = EntityStorage.get().resolve(branchReference)) != null) {
            Branch branch = (Branch)branchContainer.getEntity();
            for (FopPaymentInfo fopPaymentInfo : branch.getFopPaymentInfos()) {
                if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                return fopPaymentInfo;
            }
        }
        if ((subagencyContainer = EntityStorage.get().resolve(subagencyReference)) != null) {
            Organization organization = (Organization)subagencyContainer.getEntity();
            for (FopPaymentInfo fopPaymentInfo : organization.getFopPaymentInfos()) {
                if (fopPaymentInfo.getPaymentType() != paymentType) continue;
                return fopPaymentInfo;
            }
        }
        return null;
    }

    public static Collection<Communication> getPersonCommunications(EntityReference<Person> ref) {
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        if (ctr == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Communication>(((Person)ctr.getEntity()).getCommunications());
    }

    public static Date getPersonBirthday(Person person) {
        if (person.getBirthday() != null) {
            return person.getBirthday();
        }
        for (Passport p : person.getPassports()) {
            if (p.getBirthday() == null) continue;
            return p.getBirthday();
        }
        return null;
    }

    public static Date getPersonBirthday(Passport passport) {
        if (passport.getBirthday() != null) {
            return passport.getBirthday();
        }
        return null;
    }

    public static Date getPersonBirthday(EntityReference<Person> persRef) {
        EntityContainer p;
        try {
            p = EntityStorage.get().resolve(persRef);
        }
        catch (Exception e) {
            p = null;
        }
        if (p != null && p.getEntity() != null) {
            return ProfileHelper.getPersonBirthday((Person)p.getEntity());
        }
        return null;
    }

    private static double getDifferenceInYears(Date from, Date to) {
        Calendar birthDate = Calendar.getInstance();
        Calendar nowDate = Calendar.getInstance();
        birthDate.setTime(from);
        nowDate.setTime(to);
        long millisInYear = 31536000000L;
        return (double)(nowDate.getTimeInMillis() - birthDate.getTimeInMillis()) / (double)millisInYear;
    }

    public static Integer getFullAge(Date birthday) {
        if (birthday == null) {
            return null;
        }
        return (int)ProfileHelper.getDifferenceInYears(birthday, new Date());
    }

    public static double getPersonYears(Person p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        if (birthday == null) {
            return 0.0;
        }
        return ProfileHelper.getDifferenceInYears(birthday, new Date());
    }

    public static double getPersonYears(Passport p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        if (birthday == null) {
            return 0.0;
        }
        return ProfileHelper.getDifferenceInYears(birthday, new Date());
    }

    public static boolean isPersonAdult(Person p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        if (birthday == null) {
            return true;
        }
        return ProfileHelper.isDateAdult(birthday);
    }

    public static boolean isPersonAdult(Passport p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        if (birthday == null) {
            return true;
        }
        return ProfileHelper.isDateAdult(birthday);
    }

    public static boolean isPersonChild(Person p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        return ProfileHelper.isDateChild(birthday);
    }

    public static boolean isPersonChild(Passport p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        return ProfileHelper.isDateChild(birthday);
    }

    public static boolean isPersonInfant(Person p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        return ProfileHelper.isDateInfant(birthday);
    }

    public static boolean isPersonInfant(Passport p) {
        Date birthday = ProfileHelper.getPersonBirthday(p);
        return ProfileHelper.isDateInfant(birthday);
    }

    private static boolean isDateAdult(Date birthday) {
        if (birthday == null) {
            return false;
        }
        GregorianCalendar cal12years = (GregorianCalendar)Calendar.getInstance();
        cal12years.add(1, -12);
        return birthday.before(cal12years.getTime());
    }

    public static boolean isDateChild(Date birthday) {
        if (birthday == null) {
            return false;
        }
        GregorianCalendar cal12years = (GregorianCalendar)Calendar.getInstance();
        cal12years.add(1, -12);
        GregorianCalendar cal2years = (GregorianCalendar)Calendar.getInstance();
        cal2years.add(1, -2);
        return (birthday.after(cal12years.getTime()) || birthday.equals(cal12years.getTime())) && birthday.before(cal2years.getTime());
    }

    public static boolean isDateInfant(Date birthday) {
        if (birthday == null) {
            return false;
        }
        GregorianCalendar cal2years = (GregorianCalendar)Calendar.getInstance();
        cal2years.add(1, -2);
        return birthday.after(cal2years.getTime()) || birthday.equals(cal2years.getTime());
    }

    public static List<Metadata> getMetadatas(Collection<Metadata> metadatas, DictionaryReference<MetadataKeyDescriptor> metadataKeyDescriptor) {
        if (metadatas == null || metadataKeyDescriptor == null) {
            return Collections.emptyList();
        }
        ArrayList<Metadata> metas = new ArrayList<Metadata>();
        for (Metadata metadata : metadatas) {
            if (!metadata.getKey().equals(metadataKeyDescriptor)) continue;
            metas.add(metadata);
        }
        return metas;
    }

    public static List<PersonMetadata> getMetadatas(Collection<PersonMetadata> metadatas, DictionaryReference<MetadataKeyDescriptor> metadataKeyDescriptor, EntityReference<Organization> organization) {
        if (metadatas == null || metadataKeyDescriptor == null) {
            return Collections.emptyList();
        }
        ArrayList<PersonMetadata> metas = new ArrayList<PersonMetadata>();
        for (PersonMetadata metadata : metadatas) {
            if (organization != null && !organization.equals((Object)metadata.getOrganization()) || !metadata.getKey().equals(metadataKeyDescriptor)) continue;
            metas.add(metadata);
        }
        return metas;
    }

    public static boolean isContainsMetadata(Metadata metadata, Collection<Metadata> metadatas) {
        if (metadata == null || metadatas == null) {
            return false;
        }
        for (Metadata meta : metadatas) {
            if (!meta.getKey().equals((Object)metadata.getKey()) || !meta.getValue().equals(metadata.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsMetadata(PersonMetadata metadata, Collection<PersonMetadata> metadatas, boolean ignoreOrganization) {
        if (metadata == null || metadatas == null) {
            return false;
        }
        for (PersonMetadata meta : metadatas) {
            if (!ignoreOrganization && !meta.getOrganization().equals((Object)metadata.getOrganization()) || !meta.getKey().equals((Object)metadata.getKey()) || !meta.getValue().equals(metadata.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMainSalesPoint(SalesPoint salesPoint) {
        if (salesPoint == null) {
            return false;
        }
        for (Metadata metadata : salesPoint.getMetadata()) {
            if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_MAIN_SALES_POINT.name()) || metadata.getValue() == null || !(metadata.getValue() instanceof Boolean)) continue;
            return (Boolean)metadata.getValue();
        }
        return false;
    }

    public static List<EntityReference<BookingFile>> getPersonsBookingFiles(List<EntityReference<Person>> personReferences) {
        ArrayList<EntityReference<BookingFile>> bookingFileReferences = new ArrayList<EntityReference<BookingFile>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criteria = new ArrayList<SearchCriterion>();
        for (EntityReference<Person> person : personReferences) {
            criteria.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agent.name(), person)}));
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criteria.toArray(new SearchCriterion[0])));
        List bookingFileIndexes = EntityStorage.get().search(BookingFileIndex.class, searchQuery).getData();
        for (BookingFileIndex bookingFileIndex : bookingFileIndexes) {
            bookingFileReferences.add((EntityReference<BookingFile>)bookingFileIndex.getSource());
        }
        return bookingFileReferences;
    }

    public static List<EntityReference<BookingFile>> getOrganizationsBookingFiles(List<EntityReference<Organization>> organizationReferences) {
        ArrayList<EntityReference<BookingFile>> bookingFileReferences = new ArrayList<EntityReference<BookingFile>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criteria = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> org : organizationReferences) {
            criteria.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.agency.name(), org), SearchCriterion.eq((String)BookingFileIndex.Property.subagency.name(), org), SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), org)}));
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criteria.toArray(new SearchCriterion[0])));
        List bookingFileIndexes = EntityStorage.get().search(BookingFileIndex.class, searchQuery).getData();
        for (BookingFileIndex bookingFileIndex : bookingFileIndexes) {
            bookingFileReferences.add((EntityReference<BookingFile>)bookingFileIndex.getSource());
        }
        return bookingFileReferences;
    }

    public static List<EntityReference<ArchivedBooking>> getPersonsArchivedProducts(List<EntityReference<Person>> personReferences) {
        ArrayList<EntityReference<ArchivedBooking>> archivedBookings = new ArrayList<EntityReference<ArchivedBooking>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criteria = new ArrayList<SearchCriterion>();
        for (EntityReference<Person> person : personReferences) {
            criteria.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ArchivedProductIndex.Property.agent.name(), person)}));
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criteria.toArray(new SearchCriterion[0])));
        List archivedProductIndexes = EntityStorage.get().search(ArchivedProductIndex.class, searchQuery).getData();
        for (ArchivedProductIndex archivedProductIndex : archivedProductIndexes) {
            archivedBookings.add((EntityReference<ArchivedBooking>)archivedProductIndex.getSource());
        }
        return archivedBookings;
    }

    public static List<EntityReference<ArchivedBooking>> getOrganizationsArchivedProducts(List<EntityReference<Organization>> organizationReferences) {
        ArrayList<EntityReference<ArchivedBooking>> archivedBookings = new ArrayList<EntityReference<ArchivedBooking>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criteria = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> org : organizationReferences) {
            criteria.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ArchivedProductIndex.Property.agency.name(), org), SearchCriterion.eq((String)ArchivedProductIndex.Property.subagency.name(), org), SearchCriterion.eq((String)ArchivedProductIndex.Property.client.name(), org)}));
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criteria.toArray(new SearchCriterion[0])));
        List archivedProductIndexes = EntityStorage.get().search(ArchivedProductIndex.class, searchQuery).getData();
        for (ArchivedProductIndex archivedProductIndex : archivedProductIndexes) {
            archivedBookings.add((EntityReference<ArchivedBooking>)archivedProductIndex.getSource());
        }
        return archivedBookings;
    }

    public static List<EntityReference<Organization>> getPersonOrganizations(Collection<EntityReference<Person>> personRefs, Collection<OrganizationType> organizationTypes, Date date) {
        if (CollectionUtil.isEmpty(personRefs)) {
            return Collections.emptyList();
        }
        Set<EntityContainer<Person>> personCtrs = personRefs.stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
        return ProfileHelper.getPersonOrganizationByContainers(personCtrs, organizationTypes, date);
    }

    public static List<EntityReference<Organization>> getPersonsOrganizationsCustomers(EntityContainer<Person> person) {
        ArrayList<Object> organizations = new ArrayList<EntityReference<Organization>>(ProfileHelper.getPersonOrganizations(Collections.singletonList(person.toReference()), null, new Date()));
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference entityReference : organizations) {
            criterions.add(SearchCriterion.contains((String)OrganizationIndex.Property.supplierUids.name(), (Object)entityReference.getUid()));
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List organizationIndexes = EntityStorage.get().search(OrganizationIndex.class, searchQuery).getData();
        organizations = new ArrayList();
        for (OrganizationIndex organizationIndex : organizationIndexes) {
            organizations.add((EntityReference<Organization>)organizationIndex.getSource());
        }
        return organizations;
    }

    public static List<EntityReference<Person>> getPersonsOrganizationsCustomersPersons(EntityContainer<Person> person) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>(ProfileHelper.getPersonOrganizations(Collections.singletonList(person.toReference()), null, new Date()));
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference entityReference : organizations) {
            criterions.add(SearchCriterion.contains((String)PersonIndex.Property.supplierOrganizationUids.name(), (Object)entityReference.getUid()));
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List personIndexes = EntityStorage.get().search(PersonIndex.class, searchQuery).getData();
        ArrayList<EntityReference<Person>> arrayList = new ArrayList<EntityReference<Person>>();
        for (PersonIndex personIndex : personIndexes) {
            arrayList.add((EntityReference<Person>)personIndex.getSource());
        }
        return arrayList;
    }

    public static Function<EntityContainer<Person>, Stream<PersonEmployment>> employments(Date date) {
        return personCtr -> {
            Person person = (Person)personCtr.getEntity();
            return person.getEmployments().stream().filter(Objects::nonNull).filter(personEmployment -> Objects.nonNull(personEmployment.getOrganization()) && (Objects.isNull(date) || MiscUtil.isBetween((Date)personEmployment.getOpened(), (Date)personEmployment.getClosed(), (Date)date)));
        };
    }

    public static List<EntityReference<Organization>> getPersonOrganizationByContainers(Collection<EntityContainer<Person>> personCtrs, Collection<OrganizationType> organizationTypes, Date date) {
        if (CollectionUtil.isEmpty(personCtrs)) {
            return Collections.emptyList();
        }
        List<EntityReference<Organization>> personEmployments = personCtrs.stream().filter(Objects::nonNull).flatMap(ProfileHelper.employments(date)).map(PersonEmployment::getOrganization).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(organizationTypes)) {
            return personEmployments;
        }
        return personEmployments.stream().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).filter(organizationCtr -> CollectionUtil.isIntersect((Collection)organizationTypes).test(((Organization)organizationCtr.getEntity()).getTypes())).map(EntityContainer::toReference).collect(Collectors.toList());
    }

    public static List<EntityReference<SalesPoint>> getPersonSalesPoints(List<EntityReference<Person>> personReferences, Date date) {
        ArrayList<EntityReference<SalesPoint>> salesPointReferences = new ArrayList<EntityReference<SalesPoint>>();
        ArrayList<Person> persons = new ArrayList<Person>();
        for (EntityReference<Person> personReference : personReferences) {
            Person person;
            EntityContainer personContainer = EntityStorage.get().resolve(personReference);
            if (personContainer == null || persons.contains(person = (Person)personContainer.getEntity())) continue;
            persons.add(person);
        }
        for (Person person : persons) {
            for (PlaceOfSales placeOfSale : person.getSalesPoints()) {
                EntityReference salesPointReference;
                if (placeOfSale.getSalesPoint() == null || !SalesPoint.class.equals((Object)placeOfSale.getSalesPoint().getType()) || !MiscUtil.isBetween((Date)placeOfSale.getOpened(), (Date)placeOfSale.getClosed(), (Date)date) || salesPointReferences.contains(salesPointReference = placeOfSale.getSalesPoint())) continue;
                salesPointReferences.add((EntityReference<SalesPoint>)salesPointReference);
            }
        }
        return salesPointReferences;
    }

    public static Collection<DictionaryReference<ProfileGroup>> getPersonProfileGroups(Collection<EntityReference<Person>> personReferences) {
        return personReferences.stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static List<EntityReference<Organization>> getHoldingOrganizations(Collection<EntityReference<Holding>> holdingReferences) {
        ArrayList<EntityReference<Organization>> organizationReferences = new ArrayList<EntityReference<Organization>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<Holding> holdingReference : holdingReferences) {
            criterions.add(SearchCriterion.eq((String)OrganizationIndex.Property.holding.name(), holdingReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List organizationIndexes = EntityStorage.get().search(OrganizationIndex.class, searchQuery).getData();
        for (OrganizationIndex organizationIndex : organizationIndexes) {
            organizationReferences.add((EntityReference<Organization>)organizationIndex.getSource());
        }
        return organizationReferences;
    }

    public static Collection<EntityReference<Holding>> getOrganizationHoldings(Collection<EntityReference<Organization>> organizationReferences) {
        return organizationReferences.stream().map(EntityStorageHelper::resolve).map(EntityStorageHelper::entity).filter(Objects::nonNull).map(Organization::getHolding).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Collection<EntityReference<Organization>> getOrganizationChildren(Collection<EntityReference<Organization>> organizationReferences) {
        SearchCriterion[] searchCriterions = (SearchCriterion[])organizationReferences.stream().map(EntityReference::getUid).map(uid -> SearchCriterion.contains((String)OrganizationIndex.Property.parentUids.name(), (Object)uid)).toArray(SearchCriterion[]::new);
        if (searchCriterions.length == 0) {
            return Collections.emptyList();
        }
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])searchCriterions));
        searchQuery.getPreferredProperties().add("uid");
        return EntityStorage.get().search(OrganizationIndex.class, searchQuery).getData().stream().map(OrganizationIndex::getSource).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<EntityReference<Organization>> getOrganizationParents(Collection<EntityReference<Organization>> organizationReferences) {
        HashSet<EntityReference<Organization>> parentReferences = new HashSet<EntityReference<Organization>>();
        block0: for (EntityReference<Organization> entityReference : organizationReferences) {
            void var3_3;
            boolean include = false;
            while (var3_3 != null) {
                EntityReference entityReference2;
                if (include) {
                    parentReferences.add((EntityReference<Organization>)var3_3);
                }
                include = true;
                EntityContainer organizationContainer = EntityStorage.get().resolve((EntityReference)var3_3);
                if (organizationContainer != null && (entityReference2 = ((Organization)organizationContainer.getEntity()).getParent()) != null && !parentReferences.contains(entityReference2)) continue;
                continue block0;
            }
        }
        return parentReferences;
    }

    public static EntityReference<Organization> getOrganizationParent(EntityReference<Organization> orgRef) {
        EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
        if (orgCtr != null && ((Organization)orgCtr.getEntity()).getParent() != null && !orgCtr.toReference().equals((Object)((Organization)orgCtr.getEntity()).getParent())) {
            return ((Organization)orgCtr.getEntity()).getParent();
        }
        return null;
    }

    public static List<EntityReference<Branch>> getOrganizationBranches(List<EntityReference<Organization>> organizationReferences) {
        ArrayList<EntityReference<Branch>> branchesReferences = new ArrayList<EntityReference<Branch>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            criterions.add(SearchCriterion.eq((String)BranchIndex.Property.agency.name(), organizationReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List branchIndexes = EntityStorage.get().search(BranchIndex.class, searchQuery).getData();
        for (BranchIndex branchIndex : branchIndexes) {
            branchesReferences.add((EntityReference<Branch>)branchIndex.getSource());
        }
        return branchesReferences;
    }

    public static List<EntityReference<SalesPoint>> getOrganizationSalesPoints(List<EntityReference<Organization>> organizationReferences) {
        ArrayList<EntityReference<SalesPoint>> salesPointReferences = new ArrayList<EntityReference<SalesPoint>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            criterions.add(SearchCriterion.eq((String)SalesPointIndex.Property.agency.name(), organizationReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List salesPointIndexes = EntityStorage.get().search(SalesPointIndex.class, searchQuery).getData();
        for (SalesPointIndex salesPointIndex : salesPointIndexes) {
            salesPointReferences.add((EntityReference<SalesPoint>)salesPointIndex.getSource());
        }
        return salesPointReferences;
    }

    public static List<EntityReference<Cash>> getOrganizationCashes(List<EntityReference<Organization>> organizationReferences) {
        ArrayList<EntityReference<Cash>> cashReferences = new ArrayList<EntityReference<Cash>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            criterions.add(SearchCriterion.eq((String)CashIndex.Property.owner.name(), organizationReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List cashIndexes = EntityStorage.get().search(CashIndex.class, searchQuery).getData();
        for (CashIndex cashIndex : cashIndexes) {
            cashReferences.add((EntityReference<Cash>)cashIndex.getSource());
        }
        return cashReferences;
    }

    public static List<EntityReference<Person>> getOrganizationPersons(List<EntityReference<Organization>> organizationReferences, List<PersonType> personTypes) {
        ArrayList<EntityReference<Person>> personsReferences = new ArrayList<EntityReference<Person>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            criterions.add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)organizationReference.getUid()));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        if (personTypes != null) {
            criterions = new ArrayList();
            for (PersonType personType : personTypes) {
                criterions.add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)personType));
            }
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        }
        List personIndexes = EntityStorage.get().search(PersonIndex.class, searchQuery).getData();
        for (PersonIndex personIndex : personIndexes) {
            personsReferences.add((EntityReference<Person>)personIndex.getSource());
        }
        return personsReferences;
    }

    public static Collection<EntityReference<Organization>> getOrganizationSuppliers(EntityReference<Organization> organization, Set<ContractType> contractTypes, Date date) {
        HashSet<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), organization));
        EntityReference<Organization> allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference<Organization> allClientsProfile = ProfileDao.findAllClientsProfile();
        if (allAgenciesProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.supplier.name(), allAgenciesProfile));
        }
        if (allClientsProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.supplier.name(), allClientsProfile));
        }
        if (contractTypes != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (ContractType contractType : contractTypes) {
                criterions.add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        }
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)date)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)date)}));
        }
        query.getPreferredProperties().add(ContractCustomerIndex.Property.supplier.name());
        List indexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        for (ContractCustomerIndex index : indexes) {
            suppliers.add((EntityReference<Organization>)index.getSupplier());
        }
        return suppliers;
    }

    public static Collection<EntityReference<Organization>> getOrganizationCustomers(EntityReference<Organization> organization, Set<ContractType> contractTypes, Date date) {
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), organization));
        EntityReference<Organization> allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference<Organization> allClientsProfile = ProfileDao.findAllClientsProfile();
        if (allAgenciesProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.customer.name(), allAgenciesProfile));
        }
        if (allClientsProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.customer.name(), allClientsProfile));
        }
        if (contractTypes != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (ContractType contractType : contractTypes) {
                criterions.add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        }
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)date)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)date)}));
        }
        query.getPreferredProperties().add(ContractCustomerIndex.Property.customer.name());
        List indexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        for (ContractCustomerIndex index : indexes) {
            customers.add((EntityReference<Organization>)index.getCustomer());
        }
        return customers;
    }

    public static Collection<DictionaryReference<ProfileGroup>> getOrganizationProfileGroups(Collection<EntityReference<Organization>> organizationReferences) {
        return organizationReferences.stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).flatMap(item -> ((Organization)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static ProjectionQueryHelper.GroupValues<ContractCustomerIndex.Property> getContractValues(EntityReference<Organization> supplier, EntityReference<Organization> customer, Set<ContractType> contractTypes, Date date, Set<ContractCustomerIndex.Property> groups) {
        ProjectionQuery query = new ProjectionQuery();
        if (supplier != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), supplier));
        }
        if (customer != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), customer));
        }
        EntityReference<Organization> allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference<Organization> allClientsProfile = ProfileDao.findAllClientsProfile();
        if (allAgenciesProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.supplier.name(), allAgenciesProfile));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.customer.name(), allAgenciesProfile));
        }
        if (allClientsProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.supplier.name(), allClientsProfile));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractCustomerIndex.Property.customer.name(), allClientsProfile));
        }
        if (contractTypes != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (ContractType contractType : contractTypes) {
                criterions.add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        }
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)date)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)date)}));
        }
        for (ContractCustomerIndex.Property group : groups) {
            query.getProjections().add(Projection.group((String)group.name(), (String)group.name()));
        }
        return ProjectionQueryHelper.GroupValues.of(Enum::name, EntityStorage.get().search(ContractCustomerIndex.class, query).getData());
    }

    public static List<ContractIndex> getOrganizationContractIndexes(List<EntityReference<Organization>> organizationReferences, List<ContractType> contractTypes) {
        if (CollectionUtil.isEmpty(organizationReferences)) {
            return Collections.emptyList();
        }
        SearchQuery searchQuery = new SearchQuery();
        List searchCriterions = searchQuery.getCriteria().getCriterions();
        SearchCriterion[] organizationCriterions = (SearchCriterion[])organizationReferences.stream().flatMap(organizationRef -> Stream.of(SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)organizationRef), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)organizationRef), SearchCriterion.contains((String)ContractIndex.Property.customerUids.name(), (Object)organizationRef.getUid()))).toArray(SearchCriterion[]::new);
        searchCriterions.add(SearchCriterion.or((SearchCriterion[])organizationCriterions));
        if (CollectionUtil.isNotEmpty(contractTypes)) {
            SearchCriterion[] contractTypeCriterions = (SearchCriterion[])contractTypes.stream().map(contractType -> SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType)).toArray(SearchCriterion[]::new);
            searchCriterions.add(SearchCriterion.or((SearchCriterion[])contractTypeCriterions));
        }
        return EntityStorage.get().search(ContractIndex.class, searchQuery).getData();
    }

    public static List<EntityReference<Contract>> getOrganizationContracts(List<EntityReference<Organization>> organizationReferences, List<ContractType> contractTypes) {
        return ProfileHelper.getOrganizationContractIndexes(organizationReferences, contractTypes).stream().map(ContractIndex::getSource).collect(Collectors.toList());
    }

    public static List<EntityReference<Branch>> getSalesPointBranches(List<EntityReference<SalesPoint>> salesPointReferences) {
        ArrayList<EntityReference<Branch>> branchReferences = new ArrayList<EntityReference<Branch>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<SalesPoint> salesPointReference : salesPointReferences) {
            criterions.add(SearchCriterion.eq((String)"containerUid", (Object)salesPointReference.getUid()));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List salesPointIndexes = EntityStorage.get().search(SalesPointIndex.class, searchQuery).getData();
        for (SalesPointIndex salesPointIndex : salesPointIndexes) {
            if (salesPointIndex.getBranch() == null || branchReferences.contains(salesPointIndex.getBranch())) continue;
            branchReferences.add((EntityReference<Branch>)salesPointIndex.getBranch());
        }
        return branchReferences;
    }

    public static List<EntityReference<Cash>> getSalesPointCashes(List<EntityReference<SalesPoint>> salesPointReferences) {
        ArrayList<EntityReference<Cash>> cashReferences = new ArrayList<EntityReference<Cash>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<SalesPoint> salesPointReference : salesPointReferences) {
            criterions.add(SearchCriterion.eq((String)CashIndex.Property.owner.name(), salesPointReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List cashIndexes = EntityStorage.get().search(CashIndex.class, searchQuery).getData();
        for (CashIndex cashIndex : cashIndexes) {
            cashReferences.add((EntityReference<Cash>)cashIndex.getSource());
        }
        return cashReferences;
    }

    public static List<EntityReference<CashRegister>> getSalesPointCashRegisters(List<EntityReference<SalesPoint>> salesPointReferences) {
        ArrayList<EntityReference<CashRegister>> cashRegisterReferences = new ArrayList<EntityReference<CashRegister>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<SalesPoint> salesPointReference : salesPointReferences) {
            criterions.add(SearchCriterion.eq((String)CashRegisterIndex.Property.salesPoint.name(), salesPointReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List cashRegisterIndexes = EntityStorage.get().search(CashRegisterIndex.class, searchQuery).getData();
        for (CashRegisterIndex cashRegisterIndex : cashRegisterIndexes) {
            cashRegisterReferences.add((EntityReference<CashRegister>)cashRegisterIndex.getSource());
        }
        return cashRegisterReferences;
    }

    public static List<EntityReference<CashRegisterWorkplace>> getSalesPointCashRegisterWorkplaces(List<EntityReference<SalesPoint>> salesPointReferences) {
        ArrayList<EntityReference<CashRegisterWorkplace>> cashRegisterWorkplaceReferences = new ArrayList<EntityReference<CashRegisterWorkplace>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<SalesPoint> salesPointReference : salesPointReferences) {
            criterions.add(SearchCriterion.eq((String)CashRegisterWorkplaceIndex.Property.salesPoint.name(), salesPointReference));
        }
        if (criterions.isEmpty()) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0])));
        List cashRegisterWorkplaceIndexes = EntityStorage.get().search(CashRegisterWorkplaceIndex.class, searchQuery).getData();
        for (CashRegisterWorkplaceIndex cashRegisterWorkplaceIndex : cashRegisterWorkplaceIndexes) {
            cashRegisterWorkplaceReferences.add((EntityReference<CashRegisterWorkplace>)cashRegisterWorkplaceIndex.getSource());
        }
        return cashRegisterWorkplaceReferences;
    }

    public static boolean isRetailProfile(EntityReference<Organization> organizationReference) {
        EntityContainer orgCtr = EntityStorageHelper.resolve(organizationReference);
        return Objects.nonNull(orgCtr) && ProfileHelper.isRetailProfile((EntityContainer<Organization>)orgCtr);
    }

    public static boolean isRetailProfile(EntityContainer<Organization> organizationContainer) {
        return ProfileHelper.isRetailProfile((Organization)organizationContainer.getEntity());
    }

    public static boolean isRetailProfile(Organization organization) {
        return MiscUtil.equals((Object)organization.getCode(), (Object)DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null));
    }

    public static boolean isRetailProfile(OrganizationIndex orgIndex) {
        return MiscUtil.equals((Object)orgIndex.getCode(), (Object)DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null));
    }

    public static EntityContainer<Organization> getRetailProfileContainer() {
        try {
            return EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null));
        }
        catch (Throwable e) {
            log.error("unable to find retail profile", e);
            return null;
        }
    }

    public static EntityReference<Organization> findRetailProfileReference() {
        String code = DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null);
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        return EntityStorage.get().findReference(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)code, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS);
    }

    public static EntityContainer<Organization> findRetailProfileStrict() {
        String preferenceValue = DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null);
        if (TextUtil.isBlank((String)preferenceValue)) {
            throw Xeption.forAdmin((String)"PROFILE_HELPER_NO_RETAIL_PROFILE_CODE_IN_PREFERENCES", (Object[])new Object[0]);
        }
        EntityContainer retailProfileCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)preferenceValue, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS);
        if (EntityStorageHelper.isEmpty((EntityContainer)retailProfileCtr)) {
            throw Xeption.forAdmin((String)"PROFILE_HELPER_NO_FIND_RETAIL_PROFILE_BY_CODE", (Object[])new Object[]{preferenceValue});
        }
        return retailProfileCtr;
    }

    public static void setPersonMainEmployment(Person profile, EntityReference<Organization> cc) {
        profile.getEmployments().clear();
        if (cc != null) {
            PersonEmployment pe = new PersonEmployment();
            pe.setOrganization(cc);
            pe.setMainEmployment(true);
            profile.getEmployments().add(pe);
        }
    }

    public static <C extends Communication> Collection<C> filterCommunications(Collection<C> communications, Set<CommunicationType> communicationTypes) {
        if (communications == null) {
            return Collections.emptyList();
        }
        if (communicationTypes == null) {
            return new ArrayList<C>(communications);
        }
        ArrayList<Communication> filteredCommunications = new ArrayList<Communication>();
        for (Communication communication : communications) {
            if (communication.getType() == null || !communicationTypes.contains(communication.getType())) continue;
            filteredCommunications.add(communication);
        }
        return filteredCommunications;
    }

    public static <C extends Communication> C filterCommunications(Collection<C> communications, CommunicationType communicationType) {
        if (communicationType == null) {
            return null;
        }
        Collection<C> filterCommunications = ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType));
        return (C)(filterCommunications.size() > 0 ? (Communication)filterCommunications.iterator().next() : null);
    }

    public static Collection<PersonCommunication> filterPersonCommunications(Collection<PersonCommunication> communications, Set<CommunicationType> communicationTypes, EntityReference<Organization> organization) {
        if (communications == null) {
            return Collections.emptyList();
        }
        if (communicationTypes == null) {
            return new ArrayList<PersonCommunication>(communications);
        }
        ArrayList<PersonCommunication> filteredCommunications = new ArrayList<PersonCommunication>();
        for (PersonCommunication communication : communications) {
            if (communication.getType() == null || !communicationTypes.contains(communication.getType()) || organization != null && !organization.equals((Object)communication.getOrganization())) continue;
            filteredCommunications.add(communication);
        }
        return filteredCommunications;
    }

    public static PersonCommunication filterPersonCommunications(Collection<PersonCommunication> communications, CommunicationType communicationType, EntityReference<Organization> organization) {
        if (communicationType == null) {
            return null;
        }
        Collection<PersonCommunication> filterCommunications = ProfileHelper.filterPersonCommunications(communications, Collections.singleton(communicationType), organization);
        return filterCommunications.size() > 0 ? filterCommunications.iterator().next() : null;
    }

    public static <A extends Address> Collection<A> filterAddresses(Collection<A> addresses, Set<AddressType> addressTypes) {
        if (addresses == null) {
            return Collections.emptyList();
        }
        if (addressTypes == null) {
            return new ArrayList<A>(addresses);
        }
        ArrayList<Address> filteredAddresses = new ArrayList<Address>();
        for (Address address : addresses) {
            if (address.getAddressType() == null || !addressTypes.contains(address.getAddressType())) continue;
            filteredAddresses.add(address);
        }
        return filteredAddresses;
    }

    public static <A extends Address> A filterAddresses(Collection<A> addresses, AddressType addressType) {
        if (addressType == null) {
            return null;
        }
        Collection<A> filterAddresses = ProfileHelper.filterAddresses(addresses, Collections.singleton(addressType));
        return (A)(filterAddresses.size() > 0 ? (Address)filterAddresses.iterator().next() : null);
    }

    public static Collection<Pcc> filterPcc(Collection<Pcc> pccs, Set<GdsName> gdsNames, Set<String> codes, Set<EntityReference<Organization>> agencies, Date date) {
        ArrayList<Pcc> filteredPccs = new ArrayList<Pcc>();
        for (Pcc pcc : pccs) {
            if (gdsNames != null && !gdsNames.contains(pcc.getGdsName()) || codes != null && !CollectionUtil.contains(codes, (Object)pcc.getCode(), String::equalsIgnoreCase) || agencies != null && !agencies.contains(pcc.getAgency()) || date != null && !MiscUtil.isBetween((Date)pcc.getOpened(), (Date)pcc.getClosed(), (Date)date)) continue;
            filteredPccs.add(pcc);
        }
        return filteredPccs;
    }

    public static EntityReference<Person> findPerson(Traveller traveller, EntityReference<Organization> clientRef) {
        EntityReference<Person> res;
        Set persons;
        String logId = "findPerson: " + (traveller != null ? traveller.getName() : "") + "-" + (clientRef != null ? clientRef.getCaption() : "") + ": ";
        log.debug(logId + " Searching Person profile for given traveller started");
        if (traveller == null) {
            log.warn(logId + " Given traveller parameter is null. Cannot find Person profile.");
            return null;
        }
        Passport passport = traveller.getPassport();
        SearchQuery searchQuery = new SearchQuery();
        List criterion = searchQuery.getCriteria().getCriterions();
        boolean foundByPassport = false;
        ArrayList<Object> passports = new ArrayList<PassengerPassportIndex>();
        if (passport != null) {
            if (!TextUtil.isBlank((String)passport.getNumber())) {
                criterion.add(SearchCriterion.eq((String)PassengerPassportIndex.Property.passportNumber.name(), (Object)passport.getNumber()));
                if (passport.getType() != null) {
                    criterion.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PassengerPassportIndex.Property.passportType.name(), (Object)passport.getType()), SearchCriterion.eq((String)PassengerPassportIndex.Property.passportType.name(), null)}));
                }
                if (passport.getBirthday() != null) {
                    criterion.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), (Object)passport.getBirthday()), SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), null)}));
                }
                foundByPassport = passport.getType() != null && passport.getBirthday() != null;
            } else if (passport.getBirthday() != null) {
                criterion.add(SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), (Object)passport.getBirthday()));
            }
        } else if (traveller.getBirthday() != null) {
            log.warn(logId + " Given traveller has no passport.");
            criterion.add(SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), (Object)traveller.getBirthday()));
        }
        if (criterion.size() > 0) {
            log.debug(logId + " Query used for PassengerPassportIndex: " + searchQuery);
            passports = new ArrayList(EntityStorage.get().search(PassengerPassportIndex.class, searchQuery).getData());
            log.debug(logId + " Amount of passports found: " + passports.size());
            persons = passports.stream().map(PassengerPassportIndex::getSource).collect(Collectors.toSet());
            if (persons.size() > 1 || persons.size() == 1 && !foundByPassport) {
                ProfileHelper.filterByName(passports, traveller);
            }
        }
        if (clientRef != null && !ProfileHelper.isRetailProfile(clientRef)) {
            ProfileHelper.filterPersonPassportsByEmploymentOrganization(passports, clientRef);
            log.debug(logId + " After filtering by organization, amount of passports found: " + passports.size());
        }
        ProfileHelper.filterDuplicates(passports);
        log.debug(logId + " After filtering passports of the same person, amount of passports found: " + passports.size());
        persons = passports.stream().map(PassengerPassportIndex::getSource).collect(Collectors.toSet());
        EntityReference<Person> entityReference = res = persons.size() == 1 && passports.size() >= 1 ? ((PassengerPassportIndex)passports.get(0)).getSource() : null;
        if (res == null) {
            log.debug(logId + " search by traveller code: " + traveller.getCode());
            res = ProfileHelper.findByTravellerCode(traveller);
        }
        log.debug(logId + " Searching Person profile for given traveller finished. Returned result: " + res);
        return res;
    }

    public static EntityReference<Person> findPerson2(Traveller traveller, EntityReference<Organization> clientRef) {
        if (traveller == null) {
            log.warn("given traveller is null");
            return null;
        }
        log.debug("search for traveller " + traveller.getName() + " in " + (clientRef != null ? clientRef.getCaption() : ""));
        List<PassengerPassportIndex> passports = ProfileHelper.findByBirthdate(traveller);
        if (passports.size() > 0) {
            ProfileHelper.filterByName(passports, traveller);
        }
        if (passports.size() > 1 && clientRef != null) {
            ProfileHelper.filterPersonPassportsByEmploymentOrganization(passports, clientRef);
            log.debug("After filtering by organization, amount of passports found: " + passports.size());
        }
        ProfileHelper.filterDuplicates(passports);
        log.debug("After filtering passports of the same person, amount of passports found: " + passports.size());
        Set persons = passports.stream().map(PassengerPassportIndex::getSource).collect(Collectors.toSet());
        EntityReference result = persons.size() == 1 && passports.size() >= 1 ? passports.get(0).getSource() : null;
        result = result != null ? result : ProfileHelper.findByTravellerCode(traveller);
        return result;
    }

    private static List<PassengerPassportIndex> findByBirthdate(Traveller traveller) {
        SearchQuery searchQuery = new SearchQuery();
        List criterions = searchQuery.getCriteria().getCriterions();
        Passport passport = traveller.getPassport();
        if (passport != null) {
            if (!TextUtil.isBlank((String)passport.getNumber())) {
                criterions.add(SearchCriterion.eq((String)PassengerPassportIndex.Property.passportNumber.name(), (Object)passport.getNumber()));
                if (passport.getType() != null) {
                    criterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PassengerPassportIndex.Property.passportType.name(), (Object)passport.getType()), SearchCriterion.eq((String)PassengerPassportIndex.Property.passportType.name(), null)}));
                }
                if (passport.getBirthday() != null) {
                    criterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), (Object)passport.getBirthday()), SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), null)}));
                }
            } else if (passport.getBirthday() != null) {
                criterions.add(SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), (Object)passport.getBirthday()));
            }
        } else if (traveller.getBirthday() != null) {
            log.warn("Given traveller has no passport.");
            criterions.add(SearchCriterion.eq((String)PassengerPassportIndex.Property.birthDay.name(), (Object)traveller.getBirthday()));
        }
        List result = null;
        if (criterions.size() > 0) {
            log.debug("Query on PassengerPassportIndex: " + searchQuery);
            result = EntityStorage.get().search(PassengerPassportIndex.class, searchQuery).getData();
            log.debug("Amount of passports found: " + result.size());
        }
        return result != null ? result : Collections.emptyList();
    }

    public static PersonName personName(Traveller traveller) {
        String[] split = traveller.getName().split("\\s+");
        Passport passport = traveller.getPassport();
        PersonName result = ProfileHelper.personName(passport);
        if (TextUtil.isBlank((String)result.getLastName())) {
            result.setLastName(split.length > 0 ? split[0] : null);
        }
        if (TextUtil.isBlank((String)result.getFirstName())) {
            result.setFirstName(split.length > 1 ? split[1] : null);
        }
        return result;
    }

    public static PersonName personName(Passport passport) {
        PersonName result = new PersonName();
        result.setLastName(passport != null ? passport.getLastName() : null);
        result.setFirstName(passport != null ? passport.getFirstName() : null);
        return result;
    }

    private static EntityReference<Person> findByTravellerCode(Traveller traveller) {
        EntityReference result = null;
        if (!TextUtil.isBlank((String)traveller.getCode())) {
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.code.name(), (Object)traveller.getCode()));
            List personIndices = EntityStorage.get().search(PersonIndex.class, searchQuery).getData();
            if (personIndices.size() == 1) {
                result = ((PersonIndex)personIndices.get(0)).getSource();
            }
        }
        return result;
    }

    private static void filterDuplicates(List<PassengerPassportIndex> passports) {
        HashSet<String> exsistUID = new HashSet<String>();
        Iterator<PassengerPassportIndex> iterator = passports.iterator();
        while (iterator.hasNext()) {
            String uid = iterator.next().getSource().getUid();
            if (exsistUID.contains(uid)) {
                iterator.remove();
                continue;
            }
            exsistUID.add(uid);
        }
    }

    private static void filterByName(List<PassengerPassportIndex> passports, Traveller traveller) {
        Passport passport = traveller.getPassport();
        if (passport != null && passport.getLastName() != null && passport.getFirstName() != null) {
            ProfileHelper.filterPersonPassportsByMainNamesAndPassportNames(passports, passport.getLastName(), passport.getFirstName());
            log.debug("After filtering by passport names, amount of passports found: " + passports.size());
        } else if (traveller.getName() != null) {
            String[] travellerNames = traveller.getName().split("\\s+");
            if (travellerNames.length > 1) {
                ProfileHelper.filterPersonPassportsByMainNamesAndPassportNames(passports, travellerNames[0], travellerNames[1]);
            } else if (travellerNames.length > 0) {
                ProfileHelper.filterPersonPassportsByMainNamesAndPassportNames(passports, travellerNames[0], null);
            }
            log.debug("After filtering by traveller names, amount of passports found: " + passports.size());
        }
    }

    private static void filterPersonPassportsByEmploymentOrganization(List<PassengerPassportIndex> list, EntityReference<Organization> clientRef) {
        Iterator<PassengerPassportIndex> iterator = list.iterator();
        while (iterator.hasNext()) {
            Person person = (Person)StorageUtil.getEntity((EntityReference)iterator.next().getSource());
            if (person != null && ProfileHelper.isEmployed(person, clientRef)) continue;
            iterator.remove();
        }
    }

    private static boolean isEmployed(Person person, EntityReference<Organization> organization) {
        PersonEmployment pe;
        boolean result = false;
        Iterator iterator = person.getEmployments().iterator();
        while (iterator.hasNext() && !(result = organization.equals((Object)(pe = (PersonEmployment)iterator.next()).getOrganization()))) {
        }
        return result;
    }

    private static void filterPersonPassportsByMainNamesAndPassportNames(List<PassengerPassportIndex> list, String lastName, String originFirstName) {
        String firstName;
        if (lastName != null) {
            lastName = SPACE_PATTERN.matcher(lastName).replaceAll("");
        }
        String string = firstName = originFirstName == null ? null : SPACE_PATTERN.matcher(originFirstName).replaceAll("");
        if (FILTER_PERSON_PASPORTS != null) {
            FILTER_PERSON_PASPORTS.filterPersonPassportsByMainNamesAndPassportNames(list, lastName, firstName);
            return;
        }
        Iterator<PassengerPassportIndex> iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityReference perRef = iterator.next().getSource();
            EntityContainer perCont = EntityStorage.get().resolve(perRef);
            boolean nameFound = false;
            if (perCont != null && perCont.getEntity() != null) {
                for (Map.Entry namesEntry : ((Person)perCont.getEntity()).getLastName().getValues().entrySet()) {
                    String[] splitNameInPerson;
                    String originFirstNameInPerson;
                    String firstNameInPerson;
                    String lastNameInPerson = (String)namesEntry.getValue();
                    if (lastNameInPerson != null) {
                        lastNameInPerson = SPACE_PATTERN.matcher(lastNameInPerson).replaceAll("");
                    }
                    if ((firstNameInPerson = (originFirstNameInPerson = (String)((Person)perCont.getEntity()).getFirstName().getValues().get(namesEntry.getKey()))) != null) {
                        firstNameInPerson = SPACE_PATTERN.matcher(firstNameInPerson).replaceAll("");
                    }
                    if (!TextUtil.isSame((String)lastNameInPerson, (String)lastName, (boolean)true)) continue;
                    if (TextUtil.isSame((String)firstNameInPerson, (String)firstName, (boolean)true)) {
                        nameFound = true;
                        break;
                    }
                    if (!TextUtil.nonBlank((String)originFirstName)) continue;
                    String firstNameSplitted = originFirstName;
                    String[] splitName = originFirstName.split(" ");
                    if (splitName.length > 1) {
                        firstNameSplitted = splitName[0];
                    }
                    String firstNameInPersonSplitted = originFirstNameInPerson;
                    if (originFirstNameInPerson != null && (splitNameInPerson = originFirstNameInPerson.split(" ")).length > 1) {
                        firstNameInPersonSplitted = splitNameInPerson[0];
                    }
                    if (!TextUtil.isSame((String)firstNameInPersonSplitted, (String)firstNameSplitted, (boolean)true)) continue;
                    nameFound = true;
                    break;
                }
                if (!nameFound) {
                    for (Passport p : ((Person)perCont.getEntity()).getPassports()) {
                        if (TextUtil.isSame((String)p.getLastName(), (String)lastName, (boolean)true) && TextUtil.isSame((String)p.getFirstName(), (String)firstName, (boolean)true)) {
                            nameFound = true;
                            break;
                        }
                        if (p.getSecondName() == null || !TextUtil.isSame((String)p.getLastName(), (String)lastName, (boolean)true) || !TextUtil.isSame((String)TextUtil.concat((String)p.getFirstName(), (String)p.getSecondName()), (String)firstName, (boolean)true)) continue;
                        nameFound = true;
                        break;
                    }
                }
            }
            if (nameFound) continue;
            iterator.remove();
        }
    }

    public static ContractCustomerInfo getContractCustomerInfo(EntityReference<Contract> contract, EntityReference<Organization> customer) {
        if (contract == null || customer == null) {
            return null;
        }
        EntityContainer contractContainer = EntityStorage.get().resolve(contract);
        if (contractContainer != null) {
            for (ContractCustomerInfo info : ((Contract)contractContainer.getEntity()).getCustomers()) {
                if (!info.getCustomer().equals(customer)) continue;
                return info;
            }
        }
        return null;
    }

    public static List<EntityReference<Contract>> getContracts(EntityReference<Organization> vendor, EntityReference<Organization> supplier, EntityReference<Organization> customer, ContractType contractType, Date startDate, Date endDate) {
        ArrayList<EntityReference<Contract>> contracts = new ArrayList<EntityReference<Contract>>();
        if (supplier != null && customer != null) {
            SearchQuery query = new SearchQuery();
            if (vendor != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), vendor));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), supplier));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), customer));
            if (contractType != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
            }
            if (startDate != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)startDate)}));
            }
            if (endDate != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)endDate)}));
            }
            for (ContractCustomerIndex index : EntityStorage.get().search(ContractCustomerIndex.class, query).getData()) {
                EntityReference contract = index.getSource();
                if (contracts.contains(contract)) continue;
                contracts.add((EntityReference<Contract>)contract);
            }
        }
        return contracts;
    }

    public static List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> getContracts(EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, ContractType contractType, Date date, boolean strict) {
        List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> result = ProfileHelper.getNewContracts(blankOwner, supplier, customer, contractType, date);
        if (!result.isEmpty()) {
            return result;
        }
        return ProfileHelper.getOldContracts(blankOwner, supplier, customer, contractType, date, strict);
    }

    public static List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> getNewContracts(EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, ContractType contractType, Date date) {
        ArrayList indexes;
        List contracts;
        if (customer == null || blankOwner == null && contractType == ContractType.VENDOR) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), blankOwner)}));
        }
        if (supplier != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), supplier));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customer));
        if (contractType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType));
        }
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        if (!(contracts = (indexes = new ArrayList(EntityStorage.get().search(ContractIndex.class, query).getData())).stream().sorted((o1, o2) -> {
            if (o1.isDefaultContract() != o2.isDefaultContract()) {
                return o1.isDefaultContract() ? -1 : 1;
            }
            return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
        }).map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            EntityContainer contract = (EntityContainer)contracts.get(0);
            if (contracts.size() == 1 || ((Contract)contract.getEntity()).isDefaultContract() && !((Contract)((EntityContainer)contracts.get(1)).getEntity()).isDefaultContract()) {
                if (((Contract)contract.getEntity()).getCustomers().isEmpty()) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(new MiscUtil.Pair((Object)contract, ((Contract)contract.getEntity()).getCustomers().get(0)));
            }
        }
        return Collections.emptyList();
    }

    public static List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> getOldContracts(EntityReference<Organization> blankOwner, EntityReference<Organization> supplier, EntityReference<Organization> customer, ContractType contractType, Date date, boolean strict) {
        if (customer == null || supplier == null || blankOwner == null && contractType == ContractType.VENDOR) {
            return Collections.emptyList();
        }
        HashSet<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        suppliers.add(supplier);
        customers.add(customer);
        final EntityReference<Organization> allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        final EntityReference<Organization> allClientsProfile = ProfileDao.findAllClientsProfile();
        if (!strict) {
            if (contractType == ContractType.VENDOR) {
                if (allAgenciesProfile != null) {
                    customers.add(allAgenciesProfile);
                }
            } else if (contractType == ContractType.SUBAGENCY) {
                if (allAgenciesProfile != null) {
                    customers.add(allAgenciesProfile);
                    suppliers.add(allAgenciesProfile);
                }
            } else if (contractType == ContractType.CLIENT) {
                if (allAgenciesProfile != null) {
                    suppliers.add(allAgenciesProfile);
                }
                if (allClientsProfile != null) {
                    customers.add(allClientsProfile);
                }
            }
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        if (blankOwner != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), blankOwner)}));
        }
        query.getCriteria().getCriterions().add(ProfileHelper.toCriterion(ContractCustomerIndex.Property.supplier.name(), suppliers));
        query.getCriteria().getCriterions().add(ProfileHelper.toCriterion(ContractCustomerIndex.Property.customer.name(), customers));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        ArrayList<ContractCustomerIndex> indexes = new ArrayList<ContractCustomerIndex>(EntityStorage.get().search(ContractCustomerIndex.class, query).getData());
        final HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            ContractCustomerIndex item2 = (ContractCustomerIndex)iterator.next();
            EntityContainer ctr = EntityStorage.get().resolve(item2.getSource());
            if (ctr != null) {
                contractsMap.put(item2.getSource(), ctr);
                continue;
            }
            iterator.remove();
        }
        indexes.sort(new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                int index2;
                EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
                EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
                if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                    return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
                }
                int index1 = this.getGeneralityIndex(o1);
                if (index1 != (index2 = this.getGeneralityIndex(o2))) {
                    return index1 > index2 ? 1 : -1;
                }
                if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                    return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
                }
                return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }

            private int getGeneralityIndex(ContractCustomerIndex o1) {
                return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o1.getCustomer()) ? 1 : 0);
            }
        });
        ArrayList<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> contracts = new ArrayList<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>>();
        for (ContractCustomerIndex index : indexes) {
            EntityContainer contract = (EntityContainer)contractsMap.get(index.getSource());
            ContractCustomerInfo customerInfo = ((Contract)contract.getEntity()).getCustomers().stream().filter(item -> item.getUid().equals(index.getNavigationKey())).findFirst().orElse(null);
            contracts.add((MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>)new MiscUtil.Pair((Object)contract, (Object)customerInfo));
        }
        return contracts;
    }

    public static PaymentType getDefaultPaymentType(List<ContractCustomerInfo> customerInfos) {
        return customerInfos.stream().filter(Objects::nonNull).map(ProfileHelper::getDefaultPaymentType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static PaymentType getDefaultPaymentType(ContractCustomerInfo customerInfo) {
        return customerInfo.getPaymentConditions().getPaymentItems().stream().filter(Objects::nonNull).filter(PaymentConditionItem::isPaymentTypeByDefault).map(PaymentConditionItem::getServicePaymentType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static SearchCriterion toCriterion(String propertyName, Set<EntityReference<Organization>> suppliers) {
        if (suppliers.size() == 1) {
            return SearchCriterion.eq((String)propertyName, suppliers.iterator().next());
        }
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> item : suppliers) {
            criterions.add(SearchCriterion.eq((String)propertyName, item));
        }
        return SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[0]));
    }

    public static <T extends Communication> T getPreferredCommunication(Collection<T> cmms, CommunicationType ... preferences) {
        for (CommunicationType type : preferences) {
            T cm = ProfileHelper.filterCommunications(cmms, type);
            if (cm == null) continue;
            return cm;
        }
        return (T)(cmms.size() > 0 ? (Communication)cmms.iterator().next() : null);
    }

    public static <T extends Communication> Collection<T> getPhoneCommunications(List<T> communications) {
        Collection<T> res = ProfileHelper.filterCommunications(communications, EnumSet.of(CommunicationType.HOME_PHONE, new CommunicationType[]{CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.FAX, CommunicationType.AGENCY, CommunicationType.CELL, CommunicationType.HOTEL}));
        for (Communication pc : communications) {
            if (pc.getType() != null || TextUtil.isBlank((String)pc.getSense())) continue;
            pc.setType(CommunicationType.WORK_PHONE);
            res.add(pc);
        }
        return res;
    }

    public static <T extends Communication> Collection<T> getWebCommunications(List<T> communications) {
        return ProfileHelper.filterCommunications(communications, EnumSet.of(CommunicationType.EMAIL, CommunicationType.WEB));
    }

    public static String getCommunicationEmail(Communication communication) {
        if (communication == null) {
            return "";
        }
        return communication.getSense();
    }

    public static String getCommunicationEmail(List<? extends Communication> communications) {
        Communication cmm = ProfileHelper.getEmailCommunication(communications);
        return ProfileHelper.getCommunicationEmail(cmm);
    }

    public static Communication getPhoneCommunication(List<? extends Communication> cmms) {
        Collection<? extends Communication> phones = ProfileHelper.getPhoneCommunications(cmms);
        if (phones.isEmpty()) {
            return null;
        }
        for (Communication communication : phones) {
            if (communication.getType() != CommunicationType.MOBILE) continue;
            return communication;
        }
        return phones.iterator().next();
    }

    public static Communication getEmailCommunication(List<? extends Communication> cmms) {
        return ProfileHelper.filterCommunications(cmms, CommunicationType.EMAIL);
    }

    public static String getCommunicationPhone(List<? extends Communication> cmms) {
        Communication cmm = ProfileHelper.getPhoneCommunication(cmms);
        if (cmm == null) {
            return "";
        }
        return ProfileHelper.getCommunicationPhone(cmm);
    }

    public static String getCommunicationPhone(Communication cmm) {
        String result = "";
        if (cmm == null) {
            return result;
        }
        if (!TextUtil.isBlank((String)cmm.getCountryCode()) && !TextUtil.isBlank((String)cmm.getCityCode())) {
            result = cmm.getCountryCode() + cmm.getCityCode();
        }
        result = result + TextUtil.nonNullStr((String)cmm.getSense());
        return result;
    }

    public static String findMetadataStringByCode(List<Metadata> metadatas, String key) {
        for (Metadata meta : metadatas) {
            if (meta.getKey() == null || !TextUtil.isSame((String)key, (String)meta.getKey().getCode()) || !(meta.getValue() instanceof String)) continue;
            return (String)meta.getValue();
        }
        return null;
    }

    public static String getAnybodyWithEqualGetThereLogin(String gtLogin, String currentID) {
        String foundName = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.resourceIdForGetThere.name(), (Object)gtLogin));
        List data = EntityStorage.get().search(PersonIndex.class, query).getData();
        for (PersonIndex perInd : data) {
            String foundID = perInd.getSource().getUid();
            if (TextUtil.isSame((String)foundID, (String)currentID)) continue;
            foundName = perInd.getName() != null ? perInd.getName() : "some profile";
            break;
        }
        return foundName;
    }

    public static String getAirlineNumber(Organization org) {
        Airline airline = (Airline)DictionaryCache.get().resolveReference(org.getAirline());
        return airline != null ? airline.getAirlineNumber() : null;
    }

    public static EntityContainer<Organization> getMainEmployment(Person person) {
        EntityReference<Organization> result = ProfileHelper.getMainEmploymentRef(person);
        return EntityStorageHelper.resolve(result);
    }

    public static EntityReference<Organization> getMainEmploymentRef(Person person) {
        if (person == null) {
            return null;
        }
        Date now = new Date();
        for (PersonEmployment pe : person.getEmployments()) {
            if (pe.getOrganization() == null || !pe.isMainEmployment() || pe.getOpened() != null && !pe.getOpened().before(now) || pe.getClosed() != null && !pe.getClosed().after(now)) continue;
            return pe.getOrganization();
        }
        return null;
    }

    public static List<EntityContainer<Organization>> getEmployments(Person person) {
        return ProfileHelper.getEmployments(person, false);
    }

    public static List<EntityContainer<Organization>> getEmployments(Person person, boolean onlyMainEmployments) {
        return ProfileHelper.getEmploymentsRefs(person, onlyMainEmployments).stream().map(it -> EntityStorage.get().resolve(it)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<EntityReference<Organization>> getEmploymentsRefs(Person person, boolean onlyMainEmployments) {
        return ProfileHelper.getEmploymentsRefs(person, onlyMainEmployments, new Date());
    }

    public static List<EntityReference<Organization>> getEmploymentsRefs(Person person, boolean onlyMainEmployments, Date date) {
        ArrayList<EntityReference<Organization>> res = new ArrayList<EntityReference<Organization>>();
        if (person == null) {
            return res;
        }
        for (PersonEmployment pe : person.getEmployments()) {
            if (pe.getOrganization() == null || date != null && !MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)date) || onlyMainEmployments && !pe.isMainEmployment()) continue;
            res.add((EntityReference<Organization>)pe.getOrganization());
        }
        return res;
    }

    public static List<PersonEmployment> getPersonEmployments(Person person) {
        ArrayList<PersonEmployment> res = new ArrayList<PersonEmployment>();
        Date date = new Date();
        if (person == null) {
            return res;
        }
        for (PersonEmployment pe : person.getEmployments()) {
            if (pe.getOrganization() == null || !MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)date)) continue;
            res.add(pe);
        }
        return res;
    }

    public static String getEmployeeCategory(Person person, Date date) {
        if (person == null) {
            return "";
        }
        return person.getEmployments().stream().filter(PersonEmployment::isMainEmployment).filter(pe -> pe.getEmployeeCategory() != null).filter(pe -> date == null || MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)date)).map(PersonEmployment::getEmployeeCategory).map(category -> category.getName().toString()).filter(Objects::nonNull).findFirst().orElse(person.getEmployments().stream().filter(pe -> pe.getEmployeeCategory() != null).filter(pe -> date == null || MiscUtil.isBetween((Date)pe.getOpened(), (Date)pe.getClosed(), (Date)date)).map(PersonEmployment::getEmployeeCategory).map(category -> category.getName().toString()).filter(Objects::nonNull).findFirst().orElse(""));
    }

    public static int getDiffYears(Date first, Date last) {
        if (first == null || last == null) {
            return 0;
        }
        Calendar a = ProfileHelper.getCalendar(first.before(last) ? first : last);
        Calendar b = ProfileHelper.getCalendar(first.before(last) ? last : first);
        int diff = b.get(1) - a.get(1);
        if (a.get(2) > b.get(2) || a.get(2) == b.get(2) && a.get(5) > b.get(5)) {
            --diff;
        }
        return diff;
    }

    public static Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String getLogin() {
        String result = UserData.get().getCurrentUser();
        if (StringUtils.isBlank((String)result)) {
            throw Xeption.forAdmin((String)"\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", (Object[])new Object[0]);
        }
        return result;
    }

    public static EntityReference<Person> getCurrentUser() {
        String userLogin = UserData.get().getCurrentUser();
        if (userLogin != null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)userLogin));
            List personIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
            if (personIndexes.size() > 0) {
                return ((PersonIndex)personIndexes.get(0)).getSource();
            }
        }
        return null;
    }

    public static EntityContainer<Person> getCurrentUserCtr() {
        String userLogin = ProfileHelper.getLogin();
        if (userLogin != null) {
            try {
                return EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userLogin, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS);
            }
            catch (IllegalStateException e) {
                throw Xeption.forAdmin((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static EntityContainer<Organization> getCurrentOrganizationCtr() {
        EntityContainer<Person> person = ProfileHelper.getCurrentUserCtr();
        if (person == null) {
            throw Xeption.forAdmin((String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0444\u0438\u0437. \u043b\u0438\u0446\u0430 \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {0}", (Object[])new Object[]{ProfileHelper.getLogin()});
        }
        return ProfileHelper.getUserOrganizationCtr(person);
    }

    public static EntityContainer<Organization> getUserOrganizationCtr(EntityContainer<Person> person) {
        for (PersonEmployment emp : ((Person)person.getEntity()).getEmployments()) {
            if (!emp.isMainEmployment()) continue;
            return EntityStorage.get().resolve(emp.getOrganization());
        }
        throw Xeption.forAdmin((String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u0437. \u043b\u0438\u0446\u0430 {0}, {1}", (Object[])new Object[]{person.getEntity(), person});
    }

    public static String translitUdid(String value) {
        return TextUtil.translit((String)value, (boolean)true);
    }

    public static String getPredefinedUdidLocalValue(CostCodeProperties costCodeProp, List<CostCode> costCodes) {
        CostCode costCode = ProfileHelper.getPredefinedCostCode(costCodeProp, costCodes);
        return costCode == null ? null : costCode.getLocalValue();
    }

    public static CostCode getPredefinedCostCode(CostCodeProperties costCodeProp, List<CostCode> costCodes) {
        CostCode result = null;
        for (CostCode costCode : costCodes) {
            if (costCode.getCostCodeProperties() == null || !costCode.getCostCodeProperties().equals((Object)costCodeProp)) continue;
            if (result != null) {
                return null;
            }
            result = costCode;
        }
        return result;
    }

    public static boolean isPredefinedCostCode(CostCodeProperties costCodeProp, List<CostCode> costCodes) {
        return ProfileHelper.getPredefinedCostCode(costCodeProp, costCodes) != null;
    }

    public static String getPredefinedUdidValue(CostCodeProperties costCodeProp, List<CostCode> costCodes) {
        CostCode costCode = ProfileHelper.getPredefinedCostCode(costCodeProp, costCodes);
        return costCode == null ? null : costCode.getValue();
    }

    public static void updateCostCodeLocalAndEnglishValue(CostCode costCode, EntityReference<Organization> clientRef) {
        if (costCode.getCostCodeProperties() == null) {
            return;
        }
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr != null) {
            for (CostCode cc : ((Organization)clientCtr.getEntity()).getCostCodes()) {
                if (!costCode.getCostCodeProperties().equals((Object)cc.getCostCodeProperties()) || !ProfileHelper.isSameCostCodeValues(costCode.getValue(), cc.getValue())) continue;
                costCode.setValue(cc.getValue());
                if (!TextUtil.isBlank((String)cc.getLocalValue())) {
                    costCode.setLocalValue(cc.getLocalValue());
                }
                if (!TextUtil.isBlank((String)cc.getEnglishValue())) {
                    costCode.setEnglishValue(cc.getEnglishValue());
                }
                return;
            }
        }
        costCode.setLocalValue(costCode.getValue());
        costCode.setEnglishValue(costCode.getValue());
    }

    private static boolean isSameCostCodeValues(String value, String orgValue) {
        if (value == null) {
            return orgValue == null;
        }
        if (orgValue == null) {
            return false;
        }
        if (orgValue.length() > 30) {
            return TextUtil.isSame((String)value, (String)orgValue.substring(0, 30), (boolean)true);
        }
        return TextUtil.isSame((String)value, (String)orgValue, (boolean)true);
    }

    public static List<EntityReference<Organization>> getOrganizationForPersonNoTimeCheck(Person per) {
        if (per == null || per.getEmployments().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference<Organization>> res = new ArrayList<EntityReference<Organization>>();
        for (PersonEmployment pe : per.getEmployments()) {
            if (pe.getOrganization() == null) continue;
            if (pe.isMainEmployment()) {
                res.add(0, (EntityReference<Organization>)pe.getOrganization());
                continue;
            }
            res.add((EntityReference<Organization>)pe.getOrganization());
        }
        return res;
    }

    public static List<EntityReference<Organization>> getOrganizationForPerson(Person per) {
        if (per == null || per.getEmployments().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference<Organization>> res = new ArrayList<EntityReference<Organization>>();
        for (PersonEmployment pe : per.getEmployments()) {
            if (pe.getOrganization() == null || pe.getOpened() != null && !new Date().after(pe.getOpened()) || pe.getClosed() != null && !new Date().before(pe.getClosed())) continue;
            if (pe.isMainEmployment()) {
                res.add(0, (EntityReference<Organization>)pe.getOrganization());
                continue;
            }
            res.add((EntityReference<Organization>)pe.getOrganization());
        }
        return res;
    }

    public static String createPccAndUniqueIdIndexItem(String pcc, String uniqueId) {
        TextUtil.requireNonBlank((String)pcc, (String)"PCC is blank");
        TextUtil.requireNonBlank((String)uniqueId, (String)"Unique ID is blank");
        return pcc + PCC_AND_UNIQUE_IDS_DELIMITER + uniqueId;
    }

    public static String getPccBySabreProfilesPccUniqueIds(String sabreProfilesPccUniqueIds) {
        TextUtil.requireNonBlank((String)sabreProfilesPccUniqueIds, (String)"sabreProfilesPccUniqueIds is blank");
        return sabreProfilesPccUniqueIds.split(PCC_AND_UNIQUE_IDS_DELIMITER)[0];
    }

    public static List<CostCodeProperties> getNonFilledCostCodeProperties(Collection<CostCodeProperties> orgCostCodeProperties, Collection<CostCode> orgCostCodes, Collection<CostCode> filledCostCodes, BaseProduct product) {
        Reservation reservation = product.getReservation();
        ProductHandler<BaseProduct> handler = ProductHandler.of(product);
        Date issueDate = handler.findIssueDate(product);
        LazyValueHolder designator = new LazyValueHolder(() -> BookingHelper.isCreatedByClient(reservation) ? CostCodeDesignatorType.CLIENT : CostCodeDesignatorType.AGENT);
        Stream<CostCodeProperties> propertiesStream = orgCostCodeProperties.stream().filter(properties -> {
            if (ProfileHelper.isSelectedNonNull(properties, filledCostCodes)) {
                return false;
            }
            List costCodesWithRelation = orgCostCodes.stream().filter(costCode -> costCode.getRelatedCostCodeProperties().contains(properties)).collect(Collectors.toList());
            return costCodesWithRelation.isEmpty() || costCodesWithRelation.stream().anyMatch(costCodeWithRelation -> ProfileHelper.isSelected(costCodeWithRelation, filledCostCodes));
        }).filter(costCodeProperties -> costCodeProperties.getDesignatorType() == null || costCodeProperties.getDesignatorType() == designator.get());
        if (issueDate == null) {
            return propertiesStream.collect(Collectors.toList());
        }
        Date date = MiscUtil.clearTime((Date)issueDate);
        return propertiesStream.filter(item -> MiscUtil.isBetween((Date)item.getStartDate(), (Date)item.getEndDate(), (Date)date)).collect(Collectors.toList());
    }

    public static boolean isSelected(CostCodeProperties costCodeProperties, Collection<CostCode> filledCostCodes) {
        return filledCostCodes.stream().anyMatch(filledCostCode -> StatisticsHelper.equalsCostCodeProperties(costCodeProperties, filledCostCode.getCostCodeProperties()));
    }

    public static boolean isSelectedNonNull(CostCodeProperties costCodeProperties, Collection<CostCode> filledCostCodes) {
        return filledCostCodes.stream().anyMatch(filledCostCode -> (filledCostCode.getValue() != null || filledCostCode.getLocalValue() != null || filledCostCode.getEnglishValue() != null) && StatisticsHelper.equalsCostCodeProperties(costCodeProperties, filledCostCode.getCostCodeProperties()));
    }

    private static boolean isSelected(CostCode costCode, Collection<CostCode> filledCostCodes) {
        if (costCode.getCostCodeProperties() == null) {
            return false;
        }
        String costCodeLocalValue = ProfileHelper.getCostCodeValue(costCode, CostCodeDisplayType.LOCAL_VALUE);
        String costCodeDefaultValue = ProfileHelper.getCostCodeValue(costCode, CostCodeDisplayType.SABRE_VALUE);
        return filledCostCodes.stream().anyMatch(filledCostCode -> StatisticsHelper.equalsCostCodeProperties(costCode.getCostCodeProperties(), filledCostCode.getCostCodeProperties()) && TextUtil.nonBlank((String)filledCostCode.getValue()) && (TextUtil.isSame((String)filledCostCode.getValue(), (String)costCodeLocalValue) || TextUtil.isSame((String)filledCostCode.getValue(), (String)costCodeDefaultValue)));
    }

    public static CostCode findCostCodeByValue(CostCodeProperties costCodeProperties, Collection<CostCode> costCodes, String value) {
        if (TextUtil.isBlank((String)value)) {
            return null;
        }
        return costCodes.stream().filter(cc -> StatisticsHelper.equalsCostCodeProperties(costCodeProperties, cc.getCostCodeProperties())).filter(cc -> Stream.of(cc.getValue(), cc.getLocalValue(), cc.getEnglishValue()).filter(TextUtil::nonBlank).anyMatch(val -> MiscUtil.equals((Object)val, (Object)value))).findFirst().orElse(null);
    }

    public static List<PersonCostCode> getCostCodesToFillInTravellerProfile(EntityContainer<Organization> organization) {
        return ((Organization)organization.getEntity()).getCostCodeProperties().stream().filter(properties -> properties.getFillingPoint() == CostCodeFillingPoint.TRAVELLER_PROFILE).map(properties -> {
            PersonCostCode costCode = new PersonCostCode();
            costCode.setCostCodeProperties(properties);
            costCode.setOrganization(organization.toReference());
            return costCode;
        }).collect(Collectors.toList());
    }

    public static boolean isRestricted(String containerUid) {
        EntityContainer ctr = EntityStorage.get().load(Person.class, containerUid);
        if (ctr == null) {
            return false;
        }
        return ProfileHelper.isRestricted((EntityContainer<Person>)ctr);
    }

    public static boolean isRestricted(EntityContainer<Person> etc) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonalDataRestrictedEntityDataIndex.Property.origin.name(), (Object)new NestedEntityReference(etc, etc.getEntity())));
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.setLimit(1);
        return EntityStorage.get().search(PersonalDataRestrictedEntityDataIndex.class, query).getTotalCount() > 0;
    }

    public static synchronized EntityContainer<CommissionProperties> getSupplierCommissionProperties() {
        EntityContainer result = EntityStorage.get().resolve(SUPPLIER_COMMISSION_PROPERTIES_REF);
        if (result == null) {
            result = new EntityContainer(CommissionProperties.class, SUPPLIER_COMMISSION_PROPERTIES_REF.getUid());
            ((CommissionProperties)result.getEntity()).setDisplayName(SUPPLIER_COMMISSION_PROPERTIES_REF.getCaption());
            ((CommissionProperties)result.getEntity()).setCategory((DictionaryReference)ProfileHelper.getSupplierCommissionCategory());
            ((CommissionProperties)result.getEntity()).setManuallyCalculated(true);
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(result, false);
        }
        return result;
    }

    public static CommissionCategoryReference getSupplierCommissionCategory() {
        Map commissionCategories = DictionaryCache.get().getAll(CommissionCategory.class);
        for (Map.Entry entry : commissionCategories.entrySet()) {
            if (!SUPPLIER_COMMISSION_CATEGORY_UID.equals(entry.getKey())) continue;
            return ((CommissionCategory)entry.getValue()).toReference();
        }
        return null;
    }

    public static List<Message> checkDuplicatePassports(EntityReference<Person> person, List<MiscUtil.Pair<String, Date>> passports) {
        if ("true".equals(System.getProperty("ignore-duplicate-passports"))) {
            return Collections.emptyList();
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        LinkedHashSet<String> adultPassportNumbers = new LinkedHashSet<String>();
        LinkedHashSet<String> childPassportNumbers = new LinkedHashSet<String>();
        for (MiscUtil.Pair<String, Date> passport : passports) {
            String passportNumber = (String)passport.getFirst();
            Date birthday = (Date)passport.getSecond();
            if (!TextUtil.nonBlank((String)passportNumber)) continue;
            if (!adultPassportNumbers.contains(passportNumber) && !childPassportNumbers.contains(passportNumber)) {
                if (ProfileHelper.isInfantOrChild(birthday)) {
                    childPassportNumbers.add(passportNumber);
                    continue;
                }
                adultPassportNumbers.add(passportNumber);
                continue;
            }
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"PROFILE_ALREADY_HAS_PASSPORT", (Object[])new Object[]{passportNumber}));
        }
        messages.addAll(ProfileHelper.checkDuplicatePassports(person, adultPassportNumbers, true));
        messages.addAll(ProfileHelper.checkDuplicatePassports(person, childPassportNumbers, false));
        return messages;
    }

    private static List<Message> checkDuplicatePassports(EntityReference<Person> person, Collection<String> passportNumbers, boolean adult) {
        if (passportNumbers.isEmpty()) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrContainsStringCriterion((String)PersonIndex.Property.passportNumbers.name(), passportNumbers));
        if (person != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)person.getUid()));
        }
        List personsWithSamePassportNumbers = EntityStorage.get().search(PersonIndex.class, query).getData();
        ArrayList<Message> result = new ArrayList<Message>();
        for (PersonIndex personIndex : personsWithSamePassportNumbers) {
            if (ProfileHelper.isPersonEmploymentsClosed(personIndex)) continue;
            MessageType messageType = adult && !ProfileHelper.isInfantOrChild(personIndex.getBirthday()) ? MessageType.ERROR : MessageType.WARNING;
            String samePassportNumbers = passportNumbers.stream().filter(personIndex.getPassportNumbers()::contains).collect(Collectors.joining(SEPARATOR_COMMA_SPACE));
            result.add(MessagesHelper.createMessage((MessageType)messageType, (String)"PROFILE_WITH_SAME_PASSPORT_WAS_FOUND", (Object[])new Object[]{samePassportNumbers, personIndex.getName()}));
        }
        return result;
    }

    private static boolean isPersonEmploymentsClosed(PersonIndex personIndex) {
        EntityContainer personCtr;
        EntityReference personRef = personIndex.getSource();
        if (personRef != null && (personCtr = EntityStorage.get().resolve(personRef)) != null) {
            return !((Person)personCtr.getEntity()).getEmployments().isEmpty() && ((Person)personCtr.getEntity()).getEmployments().stream().map(PersonEmployment::getClosed).allMatch(item -> item != null && item.before(new Date()));
        }
        return false;
    }

    private static boolean isInfantOrChild(Date birthday) {
        return ProfileHelper.isDateInfant(birthday) || ProfileHelper.isDateChild(birthday);
    }

    public static String normalizeCommunicationPart(String part) {
        return part == null ? null : (part.indexOf(32) < 0 ? part : part.replaceAll(" ", ""));
    }

    static {
        SPACE_PATTERN = Pattern.compile("\\s+");
        String filterPersonPassportsClassName = System.getProperty("filterPersonPassports.className");
        FILTER_PERSON_PASPORTS = filterPersonPassportsClassName != null ? (FilterPersonPasports)XHelper.getInstance((String)filterPersonPassportsClassName, (Object[])new Object[0]) : null;
        CITY_PREFIX.put("RU", "\u0433. ");
    }

    public static class RuleContainerData {
        private final EntityContainer<ModelContract> container;
        private final Boolean translateSupplierFees;

        public RuleContainerData(EntityContainer<ModelContract> container, Boolean translateSupplierFees) {
            this.container = container;
            this.translateSupplierFees = translateSupplierFees;
        }

        public EntityContainer<ModelContract> getContainer() {
            return this.container;
        }

        public Boolean isTranslateSupplierFees() {
            return this.translateSupplierFees;
        }
    }
}

