/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ProjectionQueryHelper {

    public static class GroupValues<E> {
        private static final GroupValues<?> EMPTY = new GroupValues<Object>(group -> null, Collections.emptyList());
        private final Function<E, String> aliasConverter;
        private final List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();

        public static <E> GroupValues<E> empty() {
            return EMPTY;
        }

        public static <E> GroupValues<E> of(Function<E, String> aliasConverter, List<Map<String, Object>> groups) {
            return new GroupValues<E>(aliasConverter, groups);
        }

        private GroupValues(Function<E, String> aliasConverter, List<Map<String, Object>> data) {
            this.aliasConverter = aliasConverter;
            this.data.clear();
            this.data.addAll(data);
        }

        public List<Map<String, Object>> getData() {
            return Collections.unmodifiableList(this.data);
        }

        public Set<Object> values(E group) {
            return this.values(group, true);
        }

        public Set<Object> values(E group, boolean strict) {
            String allias = this.aliasConverter.apply(group);
            Set<Object> values = this.data.stream().filter(item -> item.containsKey(allias)).map(item -> item.get(allias)).collect(Collectors.toSet());
            if (!strict && values.size() == 0) {
                values.add(null);
            }
            return values;
        }

        public GroupValues<E> groupBy(E group, Object value) {
            return this.groupBy(group, value, true);
        }

        public GroupValues<E> groupBy(E group, Object value, boolean strict) {
            String allias = this.aliasConverter.apply(group);
            List<Map<String, Object>> values = this.data.stream().filter(item -> strict || value != null || item.containsKey(allias) ? MiscUtil.equals(item.get(allias), (Object)value) : true).collect(Collectors.toList());
            return GroupValues.of(this.aliasConverter, values);
        }
    }
}

