/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeDisplayType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCodeMarker;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;

public class StatisticsHelper {
    private static final Set<AFSType> NON_INPUTABLE_AFS_TYPES = new HashSet<AFSType>(Arrays.asList(AFSType.AFSBKG, AFSType.AFSTKT, AFSType.CORPFR));

    public static AFSType getAfsType(String afsType) {
        for (AFSType type : AFSType.values()) {
            if (!TextUtil.isSame((String)afsType, (String)type.name())) continue;
            return type;
        }
        return null;
    }

    public static CostCodeType getCostCodeType(String costCodeType) {
        for (CostCodeType type : CostCodeType.values()) {
            if (!TextUtil.isSame((String)costCodeType, (String)type.name())) continue;
            return type;
        }
        return null;
    }

    public static CostCodeType getCostCodeType(int costCodeType) {
        if (costCodeType > 0 && costCodeType <= 36) {
            return CostCodeType.values()[costCodeType - 1];
        }
        return null;
    }

    public static ReasonCodeType getReasonCodeType(String reasonCodeType) {
        for (ReasonCodeType type : ReasonCodeType.values()) {
            if (!TextUtil.isSame((String)reasonCodeType, (String)type.name())) continue;
            return type;
        }
        return null;
    }

    public static int getCostCodeTypeId(CostCodeType cct) {
        switch (cct) {
            case COST_CODE_1: {
                return 1;
            }
            case COST_CODE_2: {
                return 2;
            }
            case COST_CODE_3: {
                return 3;
            }
            case COST_CODE_4: {
                return 4;
            }
            case COST_CODE_5: {
                return 5;
            }
            case COST_CODE_6: {
                return 6;
            }
            case COST_CODE_7: {
                return 7;
            }
            case COST_CODE_8: {
                return 8;
            }
            case COST_CODE_9: {
                return 9;
            }
            case COST_CODE_10: {
                return 10;
            }
            case COST_CODE_11: {
                return 11;
            }
            case COST_CODE_12: {
                return 12;
            }
            case COST_CODE_13: {
                return 13;
            }
            case COST_CODE_14: {
                return 14;
            }
            case COST_CODE_15: {
                return 15;
            }
        }
        throw new IllegalArgumentException("fix the code: getCostCodeTypeId does not support " + cct.name());
    }

    public static CostCode parseStringToCostCode(String string) {
        String[] splitString = string.split("\\*");
        if (splitString.length != 4) {
            throw new IllegalArgumentException("");
        }
        if (splitString[0] != ".X") {
            throw new IllegalArgumentException("");
        }
        if (!splitString[1].startsWith("U0") || splitString[1].length() != 3) {
            throw new IllegalArgumentException("");
        }
        CostCode cc = new CostCode();
        CostCodeProperties ccp = cc.getCostCodeProperties();
        ccp.setType(StatisticsHelper.getCostCodeType("COST_CODE_" + splitString[1].charAt(2)));
        return cc;
    }

    public static String costCodeToString(CostCode costCode) {
        StringBuilder sb = new StringBuilder(40);
        sb.append(".X*U0");
        sb.append(StatisticsHelper.getCostCodeTypeId(costCode.getCostCodeProperties().getType()));
        sb.append('*');
        String costCodeName = costCode.getCostCodeProperties().getName();
        if (costCodeName.length() > 15) {
            sb.append(costCodeName, 0, 15);
        } else {
            sb.append(costCodeName);
            for (int i = costCodeName.length(); i < 15; ++i) {
                sb.append('.');
            }
        }
        sb.append('*');
        sb.append(costCode.getValue());
        sb.append('*');
        return sb.toString();
    }

    private static List<AFSType> getInputableAfsTypes() {
        ArrayList<AFSType> result = new ArrayList<AFSType>();
        result.addAll(Arrays.asList(AFSType.values()));
        result.removeAll(NON_INPUTABLE_AFS_TYPES);
        result.remove(AFSType.CO2_EMISSIONS);
        return result;
    }

    public static List<AFSType> getInputableAfsTypesFromString(String afsSettings) {
        if (afsSettings != null) {
            String[] afsIncomingData = afsSettings.split("\\|");
            ArrayList<AFSType> afsTypes = new ArrayList<AFSType>(afsIncomingData.length);
            for (String afsIncomingDatum : afsIncomingData) {
                AFSType afsType = StatisticsHelper.getAfsType(afsIncomingDatum);
                if (afsType == null || NON_INPUTABLE_AFS_TYPES.contains(afsType)) continue;
                afsTypes.add(afsType);
            }
            return afsTypes;
        }
        return Collections.emptyList();
    }

    public static List<AFSType> getAfsTypesFromString(String afsSettings, boolean isTicketing) {
        if (afsSettings != null) {
            String[] afsIncomingData = afsSettings.split("\\|");
            ArrayList<AFSType> afsTypes = new ArrayList<AFSType>(afsIncomingData.length);
            boolean writeAfs = false;
            for (String afsIncomingDatum : afsIncomingData) {
                AFSType afsType = StatisticsHelper.getAfsType(afsIncomingDatum);
                if (afsType == null) continue;
                if (afsType.equals((Object)AFSType.AFSBKG)) {
                    if (isTicketing) continue;
                    writeAfs = true;
                    continue;
                }
                if (afsType.equals((Object)AFSType.AFSTKT)) {
                    if (!isTicketing) continue;
                    writeAfs = true;
                    continue;
                }
                afsTypes.add(afsType);
            }
            if (writeAfs) {
                return afsTypes;
            }
        }
        return Collections.emptyList();
    }

    public static List<AFSType> getInputableAfsTypesFromString(String afsSettings, boolean isTicketing) {
        List<AFSType> result = StatisticsHelper.getAfsTypesFromString(afsSettings, isTicketing);
        result.removeAll(NON_INPUTABLE_AFS_TYPES);
        return result;
    }

    public static List<AFSType> getAfsTypesFromString(String afsSettings) {
        return afsSettings != null ? Arrays.stream(afsSettings.split("\\|")).map(StatisticsHelper::getAfsType).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static String getUdidName(CostCodeProperties aCostCodeProperties) {
        if (aCostCodeProperties == null) {
            return "";
        }
        String udidName = aCostCodeProperties.getSabreShortName();
        if (udidName == null && (udidName = aCostCodeProperties.getName()) == null) {
            DictionaryReference cccRef = aCostCodeProperties.getCategory();
            udidName = cccRef.getCode();
        }
        return udidName != null ? udidName : "";
    }

    public static String getUdidShortName(CostCodeProperties costCodeProperties) {
        if (costCodeProperties == null || costCodeProperties.getCategory() == null) {
            return "";
        }
        DictionaryReference costCodeCategoryReference = costCodeProperties.getCategory();
        CostCodeCategory costCodeCategory = (CostCodeCategory)DictHelper.resolve(costCodeCategoryReference);
        return costCodeCategory == null ? "" : (costCodeCategory.getShortName() == null ? "" : costCodeCategory.getShortName());
    }

    public static Double getPricingAfsValue(Product product, AFSType type, boolean isTicketing) {
        if (product.getStatisticalData() == null) {
            return null;
        }
        StatisticalData sd = product.getStatisticalData();
        switch (type) {
            case HBF1: {
                return isTicketing ? sd.getHbf1Tkt() : sd.getHbf1Bkg();
            }
            case HBF2: {
                return isTicketing ? sd.getHbf2Tkt() : sd.getHbf2Bkg();
            }
            case LAF1: {
                return isTicketing ? sd.getLaf1Tkt() : sd.getLaf1Bkg();
            }
            case LAF2: {
                return isTicketing ? sd.getLaf2Tkt() : sd.getLaf2Bkg();
            }
            case LAF3: {
                return isTicketing ? sd.getLaf3Tkt() : sd.getLaf3Bkg();
            }
            case ATF1: {
                return isTicketing ? sd.getAtf1Tkt() : sd.getAtf1Bkg();
            }
            case ATF2: {
                return isTicketing ? sd.getAtf2Tkt() : sd.getAtf2Bkg();
            }
            case LPF1: {
                return isTicketing ? sd.getLpf1Tkt() : sd.getLpf1Bkg();
            }
            case LPF2: {
                return isTicketing ? sd.getLpf2Tkt() : sd.getLpf2Bkg();
            }
            case LPF3: {
                return isTicketing ? sd.getLpf3Tkt() : sd.getLpf3Bkg();
            }
            case P3D: {
                return isTicketing ? sd.getP3dTkt() : sd.getP3dBkg();
            }
            case CTF: {
                return isTicketing ? sd.getCtfTkt() : sd.getCtfBkg();
            }
        }
        return null;
    }

    public static Object getNonPricingAfsValue(Product product, AFSType type) {
        if (product.getStatisticalData() == null) {
            return null;
        }
        StatisticalData sd = product.getStatisticalData();
        switch (type) {
            case DEST: {
                return sd.getOverallDestination();
            }
            case OCCL: {
                return sd.getOverallClassService();
            }
            case VALC: {
                return sd.getValidatingCarrier();
            }
        }
        return null;
    }

    public static void smartSetPricingAfsValue(Product product, AFSType type, boolean isTicketing, Double calcValue) {
        if (product.getStatisticalData() == null) {
            product.setStatisticalData(new StatisticalData());
        }
        StatisticalData sd = product.getStatisticalData();
        BigDecimal fare = AirProductHelper.getTotalEquivalentFare(product);
        Double minValue = new BigDecimal(calcValue.toString()).compareTo(fare) > 0 ? Double.valueOf(fare.doubleValue()) : calcValue;
        boolean direct = AirProductHelper.isDirect(product);
        switch (type) {
            case HBF1: {
                if (isTicketing) {
                    sd.setHbf1Tkt(calcValue);
                }
                sd.setHbf1Bkg(calcValue);
                break;
            }
            case HBF2: {
                if (isTicketing) {
                    sd.setHbf2Tkt(calcValue);
                }
                sd.setHbf2Bkg(calcValue);
                break;
            }
            case LAF1: {
                if (isTicketing) {
                    sd.setLaf1Tkt(minValue);
                }
                sd.setLaf1Bkg(minValue);
                break;
            }
            case LAF2: {
                if (isTicketing) {
                    sd.setLaf2Tkt(minValue);
                }
                sd.setLaf2Bkg(minValue);
                break;
            }
            case LAF3: {
                if (direct) {
                    if (isTicketing) {
                        sd.setLaf3Tkt(minValue);
                    }
                    sd.setLaf3Bkg(minValue);
                    break;
                }
                if (isTicketing) {
                    sd.setLaf3Tkt(calcValue);
                }
                sd.setLaf3Bkg(calcValue);
                break;
            }
            case LPF1: {
                if (isTicketing) {
                    sd.setLpf1Tkt(calcValue);
                }
                sd.setLpf1Bkg(calcValue);
                break;
            }
            case LPF2: {
                if (isTicketing) {
                    sd.setLpf2Tkt(calcValue);
                }
                sd.setLpf2Bkg(calcValue);
                break;
            }
            case LPF3: {
                if (isTicketing) {
                    sd.setLpf3Tkt(calcValue);
                }
                sd.setLpf3Bkg(calcValue);
                break;
            }
            case P3D: {
                if (isTicketing) {
                    sd.setP3dTkt(calcValue);
                }
                sd.setP3dBkg(calcValue);
                break;
            }
        }
    }

    private static boolean hasAfsValue(AFSType type, StatisticalData sd) {
        switch (type) {
            case ATF1: {
                return sd.getAtf1Bkg() != null || sd.getAtf1Tkt() != null;
            }
            case ATF2: {
                return sd.getAtf2Bkg() != null || sd.getAtf2Tkt() != null;
            }
            case CTF: {
                return sd.getCtfBkg() != null || sd.getCtfTkt() != null;
            }
            case DEST: {
                return sd.getOverallDestination() != null;
            }
            case HBF1: {
                return sd.getHbf1Bkg() != null || sd.getHbf1Tkt() != null;
            }
            case HBF2: {
                return sd.getHbf2Bkg() != null || sd.getHbf2Tkt() != null;
            }
            case LAF1: {
                return sd.getLaf1Bkg() != null || sd.getLaf1Tkt() != null;
            }
            case LAF2: {
                return sd.getLaf2Bkg() != null || sd.getLaf2Tkt() != null;
            }
            case LAF3: {
                return sd.getLaf3Bkg() != null || sd.getLaf3Tkt() != null;
            }
            case LPF1: {
                return sd.getLpf1Bkg() != null || sd.getLpf1Tkt() != null;
            }
            case LPF2: {
                return sd.getLpf2Bkg() != null || sd.getLpf2Tkt() != null;
            }
            case LPF3: {
                return sd.getLpf3Bkg() != null || sd.getLpf3Tkt() != null;
            }
            case OCCL: {
                return sd.getOverallClassService() != null;
            }
            case P3D: {
                return sd.getP3dBkg() != null || sd.getP3dTkt() != null;
            }
            case VALC: {
                return sd.getValidatingCarrier() != null;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected type {0}", (Object[])new Object[]{type});
    }

    public static List<AFSType> getRequiredAndEmptyAfsTypes(String afsSettings, boolean isTicketing, Reservation reservation) {
        return StatisticsHelper.getRequiredAndEmptyAfsTypes(afsSettings, isTicketing, AirProductHelper.getProducts(reservation));
    }

    public static List<AFSType> getRequiredAndEmptyAfsTypes(String afsSettings, boolean isTicketing, List<Product> products) {
        List<AFSType> result = StatisticsHelper.getInputableAfsTypesFromString(afsSettings, isTicketing);
        Iterator<AFSType> iter = result.iterator();
        block0: while (iter.hasNext()) {
            AFSType type = iter.next();
            for (Product prod : products) {
                if (StatisticsHelper.getPricingAfsValue(prod, type, isTicketing) != null) continue;
                continue block0;
            }
            iter.remove();
        }
        return result;
    }

    public static Collection<CostCodeProperties> getRelevantCostCodeProperties(Organization client, BaseProduct bp, Traveller traveller) {
        ProductHandler<?> ph = ((HandlersRegistry)Environment.getPublished(HandlersRegistry.class)).findProductHandler(bp.getClass());
        StatisticalData sd = ph.getStatisticalData(bp);
        return Stream.concat(client.getCostCodeProperties().stream(), sd.getTravellerCostCodes().stream().filter(tcc -> tcc.getTraveller() == traveller).flatMap(tcc -> tcc.getCostCodes().stream()).map(CostCode::getCostCodeProperties)).filter(ccp -> Objects.nonNull(ccp.getCategory())).collect(Collectors.groupingBy(CostCodeProperties::getCategory)).values().stream().map(l -> (CostCodeProperties)l.get(0)).collect(Collectors.toList());
    }

    public static boolean equalsCostCodeProperties(CostCodeProperties ccp1, CostCodeProperties ccp2) {
        if (ccp1 == null && ccp2 == null) {
            return true;
        }
        if (ccp1 == null || ccp2 == null) {
            return false;
        }
        return MiscUtil.equals((Object)ccp1.getCategory(), (Object)ccp2.getCategory());
    }

    public static boolean equalsCostCodeValues(CostCode cc1, CostCode cc2) {
        return StatisticsHelper.equalsCostCodeValues(cc1, cc2, 0, true);
    }

    public static boolean equalsCostCodeValues(CostCode cc1, CostCode cc2, int strictness) {
        return StatisticsHelper.equalsCostCodeValues(cc1, cc2, strictness, false);
    }

    public static boolean equalsCostCodeValues(CostCode cc1, CostCode cc2, int strictness, boolean nullTrue) {
        if (cc1 == null && cc2 == null && nullTrue) {
            return true;
        }
        if (cc1 == null || cc2 == null) {
            return false;
        }
        boolean vb1 = TextUtil.isBlank((String)cc1.getValue());
        boolean lb1 = TextUtil.isBlank((String)cc1.getLocalValue());
        boolean eb1 = TextUtil.isBlank((String)cc1.getEnglishValue());
        boolean vb2 = TextUtil.isBlank((String)cc2.getValue());
        boolean lb2 = TextUtil.isBlank((String)cc2.getLocalValue());
        boolean eb2 = TextUtil.isBlank((String)cc2.getEnglishValue());
        boolean v = TextUtil.isSame((String)cc1.getValue(), (String)cc2.getValue());
        boolean l = TextUtil.isSame((String)cc1.getLocalValue(), (String)cc2.getLocalValue());
        boolean e = TextUtil.isSame((String)cc1.getEnglishValue(), (String)cc2.getEnglishValue());
        switch (strictness) {
            case 0: {
                return v || l || e;
            }
            case 1: {
                return !(!v && !vb1 && !vb2 || !l && !lb1 && !lb2 || !e && !eb1 && !eb2 || !(v && !vb1 && !vb2 || l && !lb1 && !lb2) && (!e || eb1 || eb2));
            }
            case 2: {
                return v && l && e;
            }
        }
        throw new IllegalArgumentException("unknown strictness level");
    }

    public static CostCode preferableCostCode(Collection<CostCode> costCodes) throws IllegalArgumentException {
        CostCode result = null;
        for (CostCode costCode : costCodes) {
            if (result == null) {
                result = costCode;
                continue;
            }
            result = StatisticsHelper.preferableCostCode(result, costCode);
        }
        return result;
    }

    public static CostCode preferableCostCode(CostCode costCode1, CostCode costCode2) throws IllegalArgumentException {
        int count2;
        if (!StatisticsHelper.equalsCostCodeValues(costCode1, costCode2, 1)) {
            throw new IllegalArgumentException("StatisticsHelper.equalsCostCodeValues(costCode1, costCode2, 1) must return true on the given cost codes");
        }
        int count1 = BooleanUtils.toInteger((boolean)TextUtil.nonBlank((String)costCode1.getValue())) + BooleanUtils.toInteger((boolean)TextUtil.nonBlank((String)costCode1.getLocalValue())) + BooleanUtils.toInteger((boolean)TextUtil.nonBlank((String)costCode1.getEnglishValue()));
        return count1 > (count2 = BooleanUtils.toInteger((boolean)TextUtil.nonBlank((String)costCode2.getValue())) + BooleanUtils.toInteger((boolean)TextUtil.nonBlank((String)costCode2.getLocalValue())) + BooleanUtils.toInteger((boolean)TextUtil.nonBlank((String)costCode2.getEnglishValue()))) ? costCode1 : (count1 < count2 ? costCode2 : (TextUtil.nonBlank((String)costCode1.getValue()) ? costCode1 : costCode2));
    }

    public static CostCode getFulfilledCostCode(Collection<CostCode> costCodes) {
        CostCode result = null;
        for (CostCode costCode : costCodes) {
            if (result == null) {
                result = costCode;
                continue;
            }
            result = StatisticsHelper.getFulfilledCostCode(result, costCode);
        }
        return result;
    }

    public static CostCode getFulfilledCostCode(CostCode costCode1, CostCode costCode2) {
        CostCode result = new CostCode();
        if (!StatisticsHelper.equalsCostCodeValues(costCode1, costCode2, 1)) {
            throw new IllegalArgumentException("StatisticsHelper.equalsCostCodeValues(costCode1, costCode2, 1) must return true on the given cost codes");
        }
        result.setCostCodeProperties(costCode1.getCostCodeProperties());
        result.setValue(TextUtil.nonNullStr((String)TextUtil.firstNonBlank((String[])new String[]{costCode1.getValue(), costCode2.getValue()})));
        result.setLocalValue(TextUtil.nonNullStr((String)TextUtil.firstNonBlank((String[])new String[]{costCode1.getLocalValue(), costCode2.getLocalValue()})));
        result.setEnglishValue(TextUtil.nonNullStr((String)TextUtil.firstNonBlank((String[])new String[]{costCode1.getEnglishValue(), costCode2.getEnglishValue()})));
        return result;
    }

    public static List<CostCode> getAllCostCodes(StatisticalData statisticalData) {
        if (statisticalData == null) {
            return Collections.emptyList();
        }
        return statisticalData.getTravellerCostCodes().stream().filter(Objects::nonNull).map(TravellerCostCodes::getCostCodes).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<CostCode> getFirstCostCodes(StatisticalData statisticalData) {
        if (statisticalData == null || statisticalData.getTravellerCostCodes().isEmpty()) {
            return Collections.emptyList();
        }
        return ((TravellerCostCodes)statisticalData.getTravellerCostCodes().get(0)).getCostCodes();
    }

    public static TravellerCostCodes getTravellerCostCodes(StatisticalData statisticalData, Traveller traveller) {
        if (traveller == null) {
            return null;
        }
        return statisticalData.getTravellerCostCodes().stream().filter(tcc -> traveller.equals((Object)tcc.getTraveller())).findFirst().orElse(null);
    }

    public static List<CostCode> getProductCostCodes(BaseProduct bp, Traveller traveller) {
        ProductHandler<BaseProduct> ph = GeneralProductHelper.getHandler(bp);
        StatisticalData sd = ph.getStatisticalData(bp);
        if (sd == null) {
            return Collections.emptyList();
        }
        return sd.getTravellerCostCodes().stream().filter(tcc -> traveller == null || traveller.equals((Object)tcc.getTraveller())).flatMap(tcc -> tcc.getCostCodes().stream()).collect(Collectors.toList());
    }

    public static List<CostCode> findCostCenterCostCodes(StatisticalData statisticalData, EntityReference<Organization> clientRef) {
        ArrayList<CostCode> result = new ArrayList<CostCode>();
        List<CostCode> costCodes = StatisticsHelper.getAllCostCodes(statisticalData);
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr != null) {
            for (CostCodeProperties properties : ((Organization)clientCtr.getEntity()).getCostCodeProperties()) {
                CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(properties.getCategory());
                if (costCodeCategory == null || !costCodeCategory.isCostCenter()) continue;
                costCodes.stream().filter(cc -> cc.getCostCodeProperties() != null && MiscUtil.equals((Object)properties.getCategory(), (Object)cc.getCostCodeProperties().getCategory())).findFirst().ifPresent(result::add);
            }
        } else {
            for (CostCode costCode : costCodes) {
                CostCodeCategory costCodeCategory;
                if (costCode.getCostCodeProperties() == null || costCode.getCostCodeProperties().getCategory() == null || (costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCode.getCostCodeProperties().getCategory())) == null || !costCodeCategory.isCostCenter()) continue;
                result.add(costCode);
            }
        }
        return result;
    }

    public static Collection<AFSType> getRelevantAFSTypes(Organization client, StatisticalData statisticalData) {
        return Stream.concat(StatisticsHelper.getInputableAfsTypesFromString(client.getAfsSettings()).stream(), StatisticsHelper.getInputableAfsTypes().stream().filter(t -> StatisticsHelper.hasAfsValue(t, statisticalData))).distinct().collect(Collectors.toSet());
    }

    public static String getCostCodeValue(CostCode costCode) {
        CostCodeDisplayType displayType;
        CostCodeDisplayType costCodeDisplayType = displayType = costCode.getCostCodeProperties() != null ? costCode.getCostCodeProperties().getDisplayType() : null;
        if (displayType == null) {
            return costCode.getValue();
        }
        switch (displayType) {
            case ENGLISH_VALUE: {
                return costCode.getEnglishValue();
            }
            case LOCAL_VALUE: {
                return costCode.getLocalValue();
            }
            case SABRE_VALUE: {
                return costCode.getValue();
            }
        }
        throw Xeption.forDeveloper((String)"unexpected displayType {0}", (Object[])new Object[]{displayType});
    }

    public static void setCostCodeValue(CostCode costCode, String value) {
        CostCodeDisplayType displayType = costCode.getCostCodeProperties().getDisplayType();
        if (displayType == null) {
            costCode.setValue(value);
            return;
        }
        switch (displayType) {
            case ENGLISH_VALUE: {
                costCode.setEnglishValue(value);
                return;
            }
            case LOCAL_VALUE: {
                costCode.setLocalValue(value);
                return;
            }
            case SABRE_VALUE: {
                costCode.setValue(value);
                return;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected displayType {0}", (Object[])new Object[]{displayType});
    }

    public static <PCC extends PersonCostCodeMarker> boolean testCostCodeProperties(CostCodeProperties ccp, List<CostCode> orgCostCodes, List<PCC> personCostCodes, Date date, BiPredicate<CostCode, PCC> pccBiPredicate, BiPredicate<CostCode, PCC> sameCostCode) {
        if (ccp.getStartDate() != null && ccp.getStartDate().after(date)) {
            return false;
        }
        if (ccp.getEndDate() != null && ccp.getEndDate().before(date)) {
            return false;
        }
        if (!ccp.isDependant()) {
            return true;
        }
        if (CollectionUtil.isEmpty(personCostCodes)) {
            return false;
        }
        for (CostCode orgCostCode : orgCostCodes) {
            boolean needCostCode;
            if (!orgCostCode.getRelatedCostCodeProperties().contains(ccp) || !(needCostCode = personCostCodes.stream().filter(pcc -> pccBiPredicate.test(orgCostCode, pcc)).anyMatch(pcc -> sameCostCode.test(orgCostCode, pcc)))) continue;
            return true;
        }
        return false;
    }
}

