/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.util.TextUtil;

public class SubProviderHelper {
    public static boolean subproviderIsHotelstar(DictionaryReference<HotelSubProvider> subProviderRef) {
        GdsName vendor = SubProviderHelper.getVendor(subProviderRef);
        boolean result = vendor == GdsName.HOTELSTAR;
        return result;
    }

    public static boolean subproviderIsSabre(DictionaryReference<HotelSubProvider> subProviderRef) {
        GdsName vendor = SubProviderHelper.getVendor(subProviderRef);
        boolean result = vendor == GdsName.SABRE;
        return result;
    }

    public static GdsName getVendor(DictionaryReference<HotelSubProvider> subProviderRef) {
        HotelSubProvider subprovider = subProviderRef != null ? (HotelSubProvider)DictionaryCache.get().resolveReference(subProviderRef) : null;
        GdsName result = subprovider != null ? SubProviderHelper.getVendor(subprovider) : null;
        return result;
    }

    public static GdsName getVendor(HotelSubProvider subProvider) {
        return subProvider.getGds();
    }

    public static String getOldVendorCode(GdsName vendor) {
        return vendor == null ? null : vendor.name().toLowerCase();
    }

    public static String buildSubProviderCode(HotelProvider provider, String displayVendor) {
        if (provider == null || TextUtil.isBlank((String)displayVendor)) {
            return null;
        }
        return provider.name().concat("_").concat(displayVendor);
    }
}

