/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameter;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterRole;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class UniversalProductHelper {
    private static final ConcurrentMap<EntityReference<UniversalProductDescription>, String> RULE_TARGET_ID_CACHE = new ConcurrentHashMap<EntityReference<UniversalProductDescription>, String>();

    public static void removeProduct(UniversalProduct product, boolean removeEmptyReservations) {
        for (Reservation res : new ArrayList(product.getReservation().getBookingFile().getReservations())) {
            res.getProducts().remove(product);
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof UniversalProduct)) continue;
                UniversalProduct prod = (UniversalProduct)bp;
                if (product.equals((Object)prod.getPreviousProduct())) {
                    prod.setPreviousProduct(null);
                }
                if (!product.equals((Object)prod.getNextProduct())) continue;
                prod.setNextProduct(null);
            }
            if (!removeEmptyReservations || !res.getProducts().isEmpty()) continue;
            product.getReservation().getBookingFile().getReservations().remove(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniversalProduct createRefund(UniversalProduct model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            UniversalProduct refund = (UniversalProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            refund.setReservation(res);
            res.getProducts().add(refund);
            refund.setPreviousProduct(model);
            model.setNextProduct(refund);
            refund.setCancellationDetails(null);
            refund.setContractRulesApplied(false);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            refund.getShipments().clear();
            refund.getPrepaymentDocuments().clear();
            refund.getFopDetalizations().clear();
            UniversalProduct universalProduct = refund;
            return universalProduct;
        }
        finally {
            model.setReservation(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniversalProduct createExchange(UniversalProduct model) throws Exception {
        HashSet excludedUids = new HashSet();
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            UniversalProduct exchange = (UniversalProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            exchange.setReservation(res);
            res.getProducts().add(exchange);
            exchange.setCancellationDetails(null);
            exchange.setContractRulesApplied(false);
            exchange.setStatus(ProductStatus.EXCHANGE);
            exchange.setIssueDate(new Date());
            UniversalProduct sell2 = (UniversalProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            sell2.setReservation(res);
            res.getProducts().add(sell2);
            model.setNextProduct(exchange);
            exchange.setPreviousProduct(model);
            sell2.setPreviousProduct(exchange);
            exchange.setNextProduct(sell2);
            sell2.setCancellationDetails(null);
            sell2.setContractRulesApplied(false);
            sell2.setStatus(ProductStatus.SELL);
            sell2.setIssueDate(new Date());
            sell2.setSystemNumber(null);
            sell2.setScn(null);
            sell2.getShipments().clear();
            sell2.getPrepaymentDocuments().clear();
            sell2.getFopDetalizations().clear();
            exchange.setCompleted(false);
            sell2.setCompleted(false);
            UniversalProduct universalProduct = sell2;
            return universalProduct;
        }
        finally {
            model.setReservation(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(UniversalProduct source, UniversalProduct target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        UniversalProduct sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        UniversalProduct sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        Reservation targetRes = target.getReservation();
        target.setReservation(null);
        UniversalProduct targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        UniversalProduct targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            target.setReservation(targetRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.getShipments().clear();
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
        }
    }

    public static Date getFirstTravelDate(UniversalProduct universalProduct) {
        List<Date> values = UniversalProductHelper.getCustomValues(universalProduct, UniversalProductCustomParameterRole.TRAVEL_DATE, Date.class);
        Date result = null;
        for (Date item : values) {
            if (result != null && !result.after(item)) continue;
            result = item;
        }
        return result;
    }

    public static Date getLastTravelDate(UniversalProduct universalProduct) {
        List<Date> values = UniversalProductHelper.getCustomValues(universalProduct, UniversalProductCustomParameterRole.TRAVEL_DATE, Date.class);
        Date result = null;
        for (Date item : values) {
            if (result != null && !result.before(item)) continue;
            result = item;
        }
        return result;
    }

    public static String getRouteLine(UniversalProduct product) {
        ArrayList<String> routeLines = new ArrayList<String>();
        for (Class type : Arrays.asList(GeoLocationReference.class, CountryReference.class, GeoRegionReference.class)) {
            String routeLine = UniversalProductHelper.getRouteLine(product, type);
            if (routeLine == null) continue;
            routeLines.add(routeLine);
        }
        String routeLine = UniversalProductHelper.getRouteLine(product, String.class);
        if (routeLine != null) {
            routeLines.add(routeLine);
        }
        return routeLines.size() > 0 ? TextUtil.join((String)", ", routeLines) : null;
    }

    public static <T> String getRouteLine(UniversalProduct universalProduct, Class<T> cls) {
        List<T> values = UniversalProductHelper.getCustomValues(universalProduct, UniversalProductCustomParameterRole.ROUTE_LINE, cls);
        return values.isEmpty() ? null : TextUtil.join((String)", ", values);
    }

    public static String getServiceDetailsLine(UniversalProduct universalProduct) {
        String yes = L10nResourcesManager.getStr((String)"BOOLEAN_YES", (Object[])new Object[0]);
        String no = L10nResourcesManager.getStr((String)"BOOLEAN_NO", (Object[])new Object[0]);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        LinkedList<String> result = new LinkedList<String>();
        EntityContainer ctr = null;
        try {
            ctr = EntityStorage.get().resolve(universalProduct.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ctr == null) {
            return null;
        }
        for (UniversalProductCustomParameter param : universalProduct.getCustomParameters()) {
            if (param.getValue() == null) continue;
            block8: for (UniversalProductCustomParameterDescription item : ((UniversalProductDescription)ctr.getEntity()).getCustomParameters()) {
                Object val;
                UniversalProductCustomParameterType type = item.getType();
                if (item.getRole() != UniversalProductCustomParameterRole.SERVICE_DETAILS || !item.getId().equals(param.getId()) || (val = param.getValue()) == null) continue;
                switch (type) {
                    case BOOLEAN: {
                        if (!(val instanceof Boolean)) continue block8;
                        result.add(item.getDisplayName() + "=" + (val.equals(Boolean.TRUE) ? yes : no));
                        continue block8;
                    }
                    case DATE_TIME: {
                        if (!(val instanceof Date)) continue block8;
                        result.add(dateTimeFormat.format((Date)val));
                        continue block8;
                    }
                    case DATE: {
                        if (!(val instanceof Date)) continue block8;
                        result.add(dateFormat.format((Date)val));
                        continue block8;
                    }
                }
                result.add(val.toString());
            }
        }
        return result.isEmpty() ? null : TextUtil.join((String)", ", result);
    }

    public static <T> T findCustomValue(UniversalProduct universalProduct, UniversalProductCustomParameterRole role, Class<T> cls) {
        List<T> values = UniversalProductHelper.getCustomValues(universalProduct, role, cls);
        return values.isEmpty() ? null : (T)values.get(0);
    }

    public static <T> List<T> getCustomValues(UniversalProduct universalProduct, UniversalProductCustomParameterRole role, Class<T> cls) {
        LinkedList<Object> result = new LinkedList<Object>();
        EntityContainer ctr = null;
        try {
            ctr = EntityStorage.get().resolve(universalProduct.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ctr == null) {
            return result;
        }
        for (UniversalProductCustomParameter param : universalProduct.getCustomParameters()) {
            if (param.getValue() == null) continue;
            for (UniversalProductCustomParameterDescription item : ((UniversalProductDescription)ctr.getEntity()).getCustomParameters()) {
                Object val;
                if (item.getRole() != role || !item.getId().equals(param.getId()) || (val = param.getValue()) == null || !val.getClass().equals(cls)) continue;
                result.add(val);
            }
        }
        return result;
    }

    public static List<Object> getCustomValues(UniversalProduct universalProduct, UniversalProductCustomParameterRole role) {
        LinkedList<Object> result = new LinkedList<Object>();
        EntityContainer ctr = null;
        try {
            ctr = EntityStorage.get().resolve(universalProduct.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ctr == null) {
            return result;
        }
        for (UniversalProductCustomParameter param : universalProduct.getCustomParameters()) {
            if (param.getValue() == null) continue;
            for (UniversalProductCustomParameterDescription item : ((UniversalProductDescription)ctr.getEntity()).getCustomParameters()) {
                Object val;
                if (item.getRole() != role || !item.getId().equals(param.getId()) || (val = param.getValue()) == null) continue;
                result.add(val);
            }
        }
        return result;
    }

    public static String getCities(UniversalProduct product, Locale locale) {
        String departureCity = UniversalProductHelper.getCity(product, UniversalProductCustomParameterRole.LOCATION_START, locale);
        String arriveCity = UniversalProductHelper.getCity(product, UniversalProductCustomParameterRole.LOCATION_END, locale);
        if (departureCity == null && arriveCity == null) {
            arriveCity = departureCity = UniversalProductHelper.getCity(product, UniversalProductCustomParameterRole.ROUTE_LINE, locale);
        }
        RouteHelper.AddressData departureAddressData = RouteHelper.AddressDataBuilder.get().city(departureCity).build();
        RouteHelper.AddressData arriveAddressData = RouteHelper.AddressDataBuilder.get().city(arriveCity).build();
        return RouteHelper.getRoute(Arrays.asList(departureAddressData, arriveAddressData));
    }

    public static String getCity(UniversalProduct product, UniversalProductCustomParameterRole role, Locale locale) {
        return Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)((DictionaryReference)UniversalProductHelper.getCustomValues(product, role, GeoLocationReference.class).stream().findFirst().orElse(null))))).map(item -> item.toString(locale)).orElse(UniversalProductHelper.getCustomValues(product, role, String.class).stream().findFirst().orElse(null));
    }

    public static String getCountries(UniversalProduct product, Locale locale) {
        String departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference((DictionaryReference)UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_START, CountryReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, CountryReference.class).stream().findFirst().orElse(null)))).map(item -> item.toString(locale)).orElse(null);
        String arriveCountry = Optional.ofNullable(DictionaryCache.get().resolveReference((DictionaryReference)UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_END, CountryReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, CountryReference.class).stream().findFirst().orElse(null)))).map(item -> item.toString(locale)).orElse(null);
        RouteHelper.AddressData departureAddressData = RouteHelper.AddressDataBuilder.get().country(departureCountry).build();
        RouteHelper.AddressData arriveAddressData = RouteHelper.AddressDataBuilder.get().country(arriveCountry).build();
        return RouteHelper.getRoute(Arrays.asList(departureAddressData, arriveAddressData));
    }

    public static List<RouteHelper.AddressData> getAddressesData(UniversalProduct product, Locale locale) {
        return UniversalProductHelper.getAddressesData(product, locale, null);
    }

    public static List<RouteHelper.AddressData> getAddressesData(UniversalProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        String departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference((DictionaryReference)UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_START, CountryReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, CountryReference.class).stream().findFirst().orElse(null)))).map(item -> item.toString(locale)).orElse(null);
        String departureCity = Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)((DictionaryReference)UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_START, GeoLocationReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, GeoLocationReference.class).stream().findFirst().orElse(null)))))).map(item -> item.toString(locale)).orElse(null);
        String departureStreet = UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_START, String.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, String.class).stream().findFirst().orElse(null));
        if (MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null)) && translitRules != null) {
            departureStreet = TranslitUtil.cyr2lat((String)departureStreet, (TranslitUtil.TranslitRules)translitRules);
        }
        String arriveCountry = Optional.ofNullable(DictionaryCache.get().resolveReference((DictionaryReference)UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_END, CountryReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, CountryReference.class).stream().findFirst().orElse(null)))).map(item -> item.toString(locale)).orElse(null);
        String arriveCity = Optional.ofNullable(DictionaryCache.get().resolveReference(DictHelper.getCity((DictionaryReference<GeoLocation>)((DictionaryReference)UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_END, GeoLocationReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, GeoLocationReference.class).stream().findFirst().orElse(null)))))).map(item -> item.toString(locale)).orElse(null);
        String arriveStreet = UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.LOCATION_END, String.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.ROUTE_LINE, String.class).stream().findFirst().orElse(null));
        if (MiscUtil.equals((Object)LocaleHelper.EN_LOCALE.getLanguage(), Optional.ofNullable(locale).map(Locale::getLanguage).orElse(null)) && translitRules != null) {
            arriveStreet = TranslitUtil.cyr2lat((String)arriveStreet, (TranslitUtil.TranslitRules)translitRules);
        }
        RouteHelper.AddressData departureAddressData = RouteHelper.AddressDataBuilder.get().country(departureCountry).city(departureCity).street(departureStreet).build();
        RouteHelper.AddressData arriveAddressData = RouteHelper.AddressDataBuilder.get().country(arriveCountry).city(arriveCity).street(arriveStreet).build();
        return Arrays.asList(departureAddressData, arriveAddressData);
    }

    public static String getAddresses(UniversalProduct product, Locale locale, TranslitUtil.TranslitRules translitRules) {
        return RouteHelper.getRoute(UniversalProductHelper.getAddressesData(product, locale, translitRules));
    }

    public static Date getFirstStartDate(UniversalProduct product) {
        return UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.DATE_START, Date.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.TRAVEL_DATE, Date.class).stream().findFirst().orElse(null));
    }

    public static Date getLastStartDate(UniversalProduct product) {
        return UniversalProductHelper.getFirstStartDate(product);
    }

    public static Date getFirstEndDate(UniversalProduct product) {
        return UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.DATE_END, Date.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.TRAVEL_DATE, Date.class).stream().findFirst().orElse(null));
    }

    public static Date getLastEndDate(UniversalProduct product) {
        return UniversalProductHelper.getFirstEndDate(product);
    }

    public static String getDescription(UniversalProduct product) {
        return UniversalProductHelper.getCustomValues(product, UniversalProductCustomParameterRole.DESCRIPTION, String.class).stream().findFirst().orElse(null);
    }

    public static String generateProductName(UniversalProduct product) {
        String productName = L10nResourcesManager.getStr((String)"UNIVERSAL_PRODUCT_NAME", (Object[])new Object[0]);
        String routeLine = UniversalProductHelper.getRouteLine(product);
        return String.format("%s %s %s %s", product.getDescription() == null ? productName : product.getDescription().getCaption(), GeneralProductHelper.getNonNullString(product.getStatus()), GeneralProductHelper.getNonNullString(product.getSystemNumber()), routeLine == null ? "" : routeLine);
    }

    public static String getRuleTargetId(EntityReference<UniversalProductDescription> description) {
        return RULE_TARGET_ID_CACHE.computeIfAbsent(description, d -> "UNIVERSAL_PRODUCT_".concat(d.toString().trim()));
    }

    public static SalesChain getSalesChain(UniversalProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(UniversalProduct item) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)item);
    }

    public static GeneralProductContractRelationData getClientContractRelation(UniversalProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(UniversalProduct product, ContractType ctype) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, ctype);
    }

    public static EntityReference<Organization> getSupplier(UniversalProduct prod) {
        return GeneralProductHelper.getContractor(UniversalProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(UniversalProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor(UniversalProductHelper.getSalesChain(prod), PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(UniversalProduct prod) {
        return GeneralProductHelper.getContractor(UniversalProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY);
    }

    public static void setAgency(UniversalProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor(UniversalProductHelper.getSalesChain(prod), PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(UniversalProduct prod) {
        return GeneralProductHelper.getContractor(UniversalProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(UniversalProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor(UniversalProductHelper.getSalesChain(prod), PredefinedContractorType.SUBAGENCY, value);
    }

    public static GeneralProductContractRelationData getVendorContractRelation(UniversalProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(UniversalProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, autoUpdateSalesChain);
    }

    public static List<GeneralProductFop> getVendorFops(UniversalProduct prod) {
        return UniversalProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(UniversalProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = UniversalProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(UniversalProduct prod) {
        return UniversalProductHelper.getClientContractRelation(prod).getFops();
    }

    public static void updateVat(UniversalProduct ticket) {
        if (ticket.isChecked() || ticket.isDontRecalcVat()) {
            return;
        }
        VatDetalization vatDetalization = UniversalProductHelper.createVatDetalization(ticket);
        BigDecimal rate = null;
        if (ticket.isHasVat()) {
            rate = MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(ticket.getIssueDate()));
        }
        BigDecimal vatAmount = vatDetalization.getComponents().stream().map(VatComponent::getSum).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
        BigDecimal priceComponentVatAmount = null;
        if (rate != null) {
            priceComponentVatAmount = UniversalProductHelper.calculatePriceComponentCost(ticket).multiply(rate).divide(BigDecimal.valueOf(100L).add(rate), 2, RoundingMode.HALF_UP);
        }
        ticket.setVendorVatDetalization(vatDetalization);
        ticket.setTotalVat(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vatAmount, priceComponentVatAmount}));
    }

    public static VatDetalization createVatDetalization(UniversalProduct product) {
        BigDecimal penalty;
        VatDetalization detalization = new VatDetalization();
        BigDecimal rate = null;
        if (product.isHasVat()) {
            rate = MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat(product.getIssueDate()));
        }
        detalization.getComponents().add(UniversalProductHelper.createVatComponent(MiscUtil.guarded((BigDecimal)product.getEquivalentFare()), rate, Collections.emptySet(), VatBasisType.FARE));
        Set<String> taxesUids = product.getTaxes().stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        BigDecimal equivalentTaxAmount = GeneralProductHelper.getEquivalentTaxAmount(product.getTaxes());
        if (BigDecimal.ZERO.compareTo(equivalentTaxAmount) != 0) {
            detalization.getComponents().add(UniversalProductHelper.createVatComponent(equivalentTaxAmount, rate, taxesUids, VatBasisType.TAXES));
        }
        if ((penalty = product.getPenalty()) != null && BigDecimal.ZERO.compareTo(penalty) != 0) {
            detalization.getComponents().add(UniversalProductHelper.createVatComponent(product.getStatus() == ProductStatus.SELL ? penalty : penalty.negate(), rate, Collections.emptySet(), VatBasisType.PENALTY));
        }
        detalization.setDetalized(true);
        return detalization;
    }

    private static VatComponent createVatComponent(BigDecimal basis, BigDecimal rate, Set<String> taxesUids, VatBasisType type) {
        VatComponent vatComponent = new VatComponent();
        vatComponent.getBasisTypes().add(type);
        vatComponent.getTaxesUids().addAll(taxesUids);
        vatComponent.setBasis(basis);
        if (rate != null && basis != null) {
            BigDecimal vatAmount = basis.multiply(rate).divide(BigDecimal.valueOf(100L).add(rate), 2, RoundingMode.HALF_UP);
            vatComponent.setSum(vatAmount);
            vatComponent.setRate(Double.valueOf(rate.doubleValue()));
        }
        return vatComponent;
    }

    private static BigDecimal getVat(UniversalProduct ticket) {
        if (!ticket.isHasVat()) {
            return BigDecimal.ZERO;
        }
        return MiscUtil.guarded((BigDecimal)GeneralProductHelper.getHandler(ticket).calculateProductPrice(null, ticket).getVatAmount());
    }

    public static boolean removeProduct(UniversalProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler<BaseProduct> handler = GeneralProductHelper.getHandler(connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(UniversalProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static BigDecimal calculateTotalCost(UniversalProduct product) {
        BigDecimal total = product.getEquivalentFare();
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        total = total.add(GeneralProductHelper.getEquivalentTaxAmount(product.getTaxes()));
        if (product.getPenalty() != null) {
            total = product.getStatus() == ProductStatus.SELL ? total.add(product.getPenalty()) : total.subtract(product.getPenalty());
        }
        total = total.add(UniversalProductHelper.calculatePriceComponentCost(product));
        return total;
    }

    private static BigDecimal calculatePriceComponentCost(UniversalProduct product) {
        BigDecimal result = BigDecimal.ZERO;
        EntityContainer descrCtr = EntityStorage.get().resolve(product.getDescription());
        if (descrCtr != null) {
            for (UniversalProductCustomParameter item : product.getCustomParameters()) {
                Object val;
                String id = item.getId();
                if (id == null) continue;
                boolean priceComp = false;
                for (UniversalProductCustomParameterDescription param : ((UniversalProductDescription)descrCtr.getEntity()).getCustomParameters()) {
                    if (!id.equals(param.getId())) continue;
                    priceComp = param.getRole() == UniversalProductCustomParameterRole.PRICE_COMPONENT;
                    break;
                }
                if (!priceComp || !((val = item.getValue()) instanceof BigDecimal)) continue;
                BigDecimal value = (BigDecimal)val;
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, value});
            }
        }
        return result;
    }

    public static boolean hasSameSystemNumbers(UniversalProduct product) {
        Date issueDate;
        ProductHandler<UniversalProduct> handler = ProductHandler.of(product);
        List<String> systemNumbers = handler.getProductNumbers(product);
        if (CollectionUtil.isEmpty(systemNumbers)) {
            return false;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"navigationKey", (Object)product.getUid()));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)UniversalProductIndex.Property.ticketNumber.name(), systemNumbers));
        ProductStatus status = handler.getStatus(product);
        if (status == ProductStatus.SELL || status == ProductStatus.VOID) {
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)UniversalProductIndex.Property.status.name(), EnumSet.of(ProductStatus.SELL, ProductStatus.VOID)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UniversalProductIndex.Property.status.name(), (Object)status));
        }
        TicketType ticketType = handler.getTicketType(product);
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)UniversalProductIndex.Property.ticketType.name(), Arrays.asList(ticketType, null)));
        DictionaryReference<BlankType> blankType = handler.getBlankType(product);
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)UniversalProductIndex.Property.blankType.name(), blankType), SearchCriterion.eq((String)UniversalProductIndex.Property.blankType.name(), null)}));
        }
        if ((issueDate = handler.findIssueDate(product)) != null) {
            Date issueDateStart = MiscUtil.addYearsToDate((Date)issueDate, (int)-1);
            Date issueDateEnd = MiscUtil.addYearsToDate((Date)issueDate, (int)1);
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)UniversalProductIndex.Property.issueDate.name(), (Object)issueDateStart));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)UniversalProductIndex.Property.issueDate.name(), (Object)issueDateEnd));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UniversalProductIndex.Property.description.name(), (Object)product.getDescription()));
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(UniversalProductIndex.class, query).getTotalCount() > 0;
    }

    public static BigDecimal calculateVatComponentsSum(UniversalProduct product, VatBasisType type) {
        if (product.getTotalVat() == null) {
            return null;
        }
        if (product.getVendorVatDetalization() == null) {
            return null;
        }
        if (!GeneralProductHelper.isVendorVatDetalizationComplete(product.getVendorVatDetalization())) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        for (VatComponent comp : product.getVendorVatDetalization().getComponents()) {
            if (!comp.getBasisTypes().contains(type)) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, comp.getSum()});
        }
        return result;
    }
}

