/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import java.util.List;

public class UnlimitedCreditLimitSetter {
    public void setUnlimitedCredit(Person person) {
        List employments = person.getEmployments();
        if (employments.size() < 1) {
            return;
        }
        PersonEmployment emp = (PersonEmployment)employments.get(0);
        EntityReference clientReference = emp.getOrganization();
        CreditLimitInfo clientCreditLimit = this.findCreditLimitInfo(person.getFinanceRestrictions().getCreditLimits(), (EntityReference<Organization>)clientReference);
        if (clientCreditLimit == null) {
            clientCreditLimit = new CreditLimitInfo();
            clientCreditLimit.setCreditor(clientReference);
            person.getFinanceRestrictions().getCreditLimits().add(clientCreditLimit);
        }
        clientCreditLimit.setUnlimited(true);
    }

    protected CreditLimitInfo findCreditLimitInfo(List<CreditLimitInfo> creditLimits, EntityReference<Organization> clientReference) {
        if (creditLimits == null) {
            return null;
        }
        CreditLimitInfo result = null;
        for (int i = 0; i < creditLimits.size() && result == null; ++i) {
            CreditLimitInfo curLimit = creditLimits.get(i);
            if (curLimit.getCreditor() == null || !curLimit.getCreditor().getUid().equals(clientReference.getUid())) continue;
            result = curLimit;
        }
        return result;
    }
}

