/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;

public final class ValidationUtil {
    private static final Pattern PORTBILET_LOGIN_PATTERN = Pattern.compile("([0-9a-z-_]+\\.)*[0-9a-z-_]+@((([0-9a-z-_]+\\.)+[a-z]+)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}))");
    private static final Pattern BIRTHDAY_NOTIFICATION_PATTER = Pattern.compile("^[MDCLXVImdclxvi]+[\u0430-\u044f\u0410-\u042f]{2}[0-9]{6}$");
    private static final Pattern BIRTHDAY_NOTIFICATION_PATTER_SABRE = Pattern.compile("^[MDCLXVImdclxvi]+[a-zA-Z]{2,8}[0-9]{6}$");
    private static final Pattern MILITARYCERTIFICATE_PATTER = Pattern.compile("^[\u0430-\u044f\u0410-\u042f]{2}[0-9]{6,7}+$");
    public static final Pattern MILITARYCERTIFICATE_PATTER_LATIN = Pattern.compile("^[a-zA-Z]{2}[0-9]{6,7}+$");
    private static final Pattern MIXED_CHARACTERS_PATTERN = Pattern.compile("^.*([\u0430-\u044f\u0410-\u042f\u0451\u0401]+[a-zA-Z]+|[a-zA-Z]+[\u0430-\u044f\u0410-\u042f\u0451\u0401]+).*$");
    private static final Pattern ALPHA_NUMERIC_PATTERN = Pattern.compile("([0-9A-Za-z])*");
    private static final Pattern PHONE_PATTERN = Pattern.compile("^[0-9]{11,}+$");
    private static final Pattern PHONE_PATTERN_PLUS = Pattern.compile("^\\+[0-9]{11,}+$");
    private static final Pattern PHONE_MASK_PATTERN = Pattern.compile("^\\+[0-9]{1}\\([0-9]{3}\\)[0-9]{3}-[0-9]{2}-[0-9]{2}$");
    private static final Pattern SPACE_SPEC_PATTER = Pattern.compile(".*[\\s-].*+");
    private static final Pattern CYRILLIC_LATIN_PATTER = Pattern.compile("^[\u0430-\u044f\u0410-\u042fa-zA-Z]+$");
    private static final Pattern CYRILLIC_LATIN_SYMBOLS_PATTER = Pattern.compile("^[\u0430-\u044f\u0410-\u042fa-zA-Z-]+$");
    private static final Pattern CYRILLIC_SYMBOLS_PATTER = Pattern.compile("^[\u0430-\u044f\u0410-\u042f-]+$");
    private static final Pattern CYRILLIC_SYMBOLS_PATTERN_PLUS = Pattern.compile("^[\u0430-\u044f\u0410-\u042f\u0451\u0401]+$");
    private static final Pattern LATIN_SYMBOLS_PATTER = Pattern.compile("^[a-zA-Z-]+$");
    private static final Pattern DIGITS_LETTERS = Pattern.compile("^[0-9a-zA-Z-]+$");
    private static final Pattern DIGITS_LETTERS_ONLY = Pattern.compile("^[0-9a-zA-Z]+$");
    public static final Pattern DIGITS_ONLY = Pattern.compile("^[0-9]+$");
    private static final Pattern SIRENA_FORBIDDEN_NAME_SYMBOLS_PATTERN = Pattern.compile("^[\u044c\u042c]|[\u0451\u0401\u044a\u042a]");
    public static final Set<String> CIS_IATA_AGREEMENT = new TreeSet<String>();
    public static final Set<String> CIS_IATA = new TreeSet<String>();
    public static final Set<String> CIS_SPECIAL = new TreeSet<String>();
    public static final Set<String> ABKHAZIA_SPECIAL = new TreeSet<String>();
    public static final Set<String> OSETIYA_SPECIAL = new TreeSet<String>();

    private ValidationUtil() {
        throw new RuntimeException("don't do this");
    }

    public static boolean isMixedCharacters(String str) {
        return MIXED_CHARACTERS_PATTERN.matcher(str).matches();
    }

    public static boolean containsNonCyrillicLetters(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !CYRILLIC_SYMBOLS_PATTER.matcher(str).matches();
    }

    public static boolean containsNonCyrillicLettersPlus(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !CYRILLIC_SYMBOLS_PATTERN_PLUS.matcher(str).matches();
    }

    public static boolean containsNonLatinLetters(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !LATIN_SYMBOLS_PATTER.matcher(str).matches();
    }

    public static boolean containsOnlyLatinLetters(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return LATIN_SYMBOLS_PATTER.matcher(str).matches();
    }

    public static boolean containsOnlyCyrillicLetters(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return CYRILLIC_SYMBOLS_PATTER.matcher(str).matches();
    }

    public static boolean containsNonAlphaNumeric(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !ALPHA_NUMERIC_PATTERN.matcher(str).matches();
    }

    public static boolean containsNonLatinLettersOrNumbers(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !DIGITS_LETTERS.matcher(str).matches();
    }

    public static boolean containsNonOnlyLatinLettersOrNumbers(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !DIGITS_LETTERS_ONLY.matcher(str).matches();
    }

    public static boolean containsOnlyDigits(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return DIGITS_ONLY.matcher(str).matches();
    }

    public static boolean containsNonCyrillicLatinLetters(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !CYRILLIC_LATIN_PATTER.matcher(str).matches();
    }

    public static boolean containsOnlyCyrillicLatinLetters(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return CYRILLIC_LATIN_PATTER.matcher(str).matches();
    }

    public static boolean containsNonCyrillicLatinLettersSymbols(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return !CYRILLIC_LATIN_SYMBOLS_PATTER.matcher(str).matches();
    }

    public static boolean containsSpace(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return SPACE_SPEC_PATTER.matcher(str).matches();
    }

    public static boolean isValidPhoneNumber(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return PHONE_PATTERN.matcher(str).matches();
    }

    public static boolean isValidPhoneNumberWithPlus(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return PHONE_PATTERN_PLUS.matcher(str).matches();
    }

    public static boolean isValidMaskedPhoneNumber(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return PHONE_MASK_PATTERN.matcher(str).matches();
    }

    public static boolean isNumber(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidPortbiletLogin(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        return PORTBILET_LOGIN_PATTERN.matcher(str).matches();
    }

    public static boolean isValidPassportNumber(String passportNumber, int len) {
        return TextUtil.nonBlank((String)passportNumber) && NumberUtils.isDigits((String)passportNumber) && passportNumber.length() == len;
    }

    public static boolean isValidBirthDayNotification(String value) {
        if (TextUtil.isBlank((String)value)) {
            return false;
        }
        return BIRTHDAY_NOTIFICATION_PATTER.matcher(value).matches();
    }

    public static boolean isValidBirthDayNotificationSabre(String value) {
        if (TextUtil.isBlank((String)value)) {
            return false;
        }
        return BIRTHDAY_NOTIFICATION_PATTER_SABRE.matcher(value).matches();
    }

    public static boolean isValidMilitaryCertificate(String value) {
        if (TextUtil.isBlank((String)value)) {
            return false;
        }
        return MILITARYCERTIFICATE_PATTER.matcher(value.trim().replace(" ", "")).matches();
    }

    public static boolean isValidMilitaryCertificateLatin(String value) {
        if (TextUtil.isBlank((String)value)) {
            return false;
        }
        return MILITARYCERTIFICATE_PATTER_LATIN.matcher(value.trim().replace(" ", "")).matches();
    }

    public static boolean isValidSirenaName(String str) {
        if (TextUtil.isBlank((String)str)) {
            return true;
        }
        return !SIRENA_FORBIDDEN_NAME_SYMBOLS_PATTERN.matcher(str).find();
    }

    public static boolean containsDigits(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        for (char character : str.toCharArray()) {
            if (!Character.isDigit(character)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasErrors(Iterable<Message> messages) {
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonLatinChars(String str) {
        if (TextUtil.isBlank((String)str)) {
            return false;
        }
        for (char ch : str.toCharArray()) {
            if (Character.isWhitespace(ch) || ch <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static boolean isCISFlight(DictionaryReference<GeoLocation> arriveLocation, DictionaryReference<GeoLocation> departureLocation, boolean agreement) {
        String arrive = arriveLocation != null ? arriveLocation.getCode() : null;
        String depart = departureLocation != null ? departureLocation.getCode() : null;
        Country arriveCountry = DictHelper.findCountry(arrive);
        Country departCountry = DictHelper.findCountry(depart);
        if (arriveCountry == null || departCountry == null) {
            return true;
        }
        return (agreement ? CIS_IATA_AGREEMENT : CIS_IATA).contains(arriveCountry.getCode()) && (agreement ? CIS_IATA_AGREEMENT : CIS_IATA).contains(departCountry.getCode());
    }

    public static boolean isCISSpecialFlight(DictionaryReference<GeoLocation> arriveLocation, DictionaryReference<GeoLocation> departureLocation) {
        String arrive = arriveLocation != null ? arriveLocation.getCode() : null;
        String depart = departureLocation != null ? departureLocation.getCode() : null;
        Country arriveCountry = DictHelper.findCountry(arrive);
        Country departCountry = DictHelper.findCountry(depart);
        return arriveCountry != null && departCountry != null && CIS_SPECIAL.contains(arriveCountry.getCode()) && CIS_SPECIAL.contains(departCountry.getCode());
    }

    static {
        CIS_IATA_AGREEMENT.add("RU");
        CIS_IATA_AGREEMENT.add("UA");
        CIS_IATA_AGREEMENT.add("BY");
        CIS_IATA_AGREEMENT.add("TJ");
        CIS_IATA_AGREEMENT.add("KG");
        CIS_IATA_AGREEMENT.add("KZ");
        CIS_IATA.add("RU");
        CIS_IATA.add("AM");
        CIS_IATA.add("AZ");
        CIS_IATA.add("BY");
        CIS_IATA.add("KG");
        CIS_IATA.add("KZ");
        CIS_IATA.add("MD");
        CIS_IATA.add("TJ");
        CIS_IATA.add("TM");
        CIS_IATA.add("UA");
        CIS_IATA.add("UZ");
        CIS_SPECIAL.add("TJ");
        CIS_SPECIAL.add("KG");
        ABKHAZIA_SPECIAL.add("AZ");
        ABKHAZIA_SPECIAL.add("AM");
        ABKHAZIA_SPECIAL.add("BY");
        ABKHAZIA_SPECIAL.add("VU");
        ABKHAZIA_SPECIAL.add("VE");
        ABKHAZIA_SPECIAL.add("KZ");
        ABKHAZIA_SPECIAL.add("KG");
        ABKHAZIA_SPECIAL.add("MD");
        ABKHAZIA_SPECIAL.add("NR");
        ABKHAZIA_SPECIAL.add("NI");
        ABKHAZIA_SPECIAL.add("RU");
        ABKHAZIA_SPECIAL.add("TJ");
        ABKHAZIA_SPECIAL.add("TM");
        ABKHAZIA_SPECIAL.add("UA");
        ABKHAZIA_SPECIAL.add("UZ");
        ABKHAZIA_SPECIAL.add("\u042e\u041e");
        OSETIYA_SPECIAL.add("\u042e\u041e");
        OSETIYA_SPECIAL.add("RU");
    }
}

