/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.DebugUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class WorklogHelper {
    public static EntityReference<Worklog> getWorklog(EntityReference<Person> employee, Date date) {
        if (employee == null || date == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.employee.name(), employee));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
        List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return worklogIndexes.size() > 0 ? ((WorklogIndex)worklogIndexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getWorklog(EntityReference<Person> employee, PersonType type, Date date) {
        if (employee == null || date == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.employee.name(), employee));
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)type));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
        List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return worklogIndexes.size() > 0 ? ((WorklogIndex)worklogIndexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getAgentWorklog(EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, Date date) {
        if (cashRegisterWorkplace == null || date == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegisterWorkplace.name(), cashRegisterWorkplace));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.AGENT));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
        List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return worklogIndexes.size() > 0 ? ((WorklogIndex)worklogIndexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getCashierClerkWorklog(EntityReference<CashRegister> cashRegister, Date date) {
        if (cashRegister == null || date == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegister.name(), cashRegister));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.CASHIER_CLERK));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
        List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return worklogIndexes.size() > 0 ? ((WorklogIndex)worklogIndexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getCashierAccountantWorklog(EntityReference<Cash> cash, Date date) {
        if (cash == null || date == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cash.name(), cash));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.CASHIER_ACCOUNTANT));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
        List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return worklogIndexes.size() > 0 ? ((WorklogIndex)worklogIndexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getRecentAgentWorklog(EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, Date date) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegisterWorkplace.name(), cashRegisterWorkplace));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)WorklogIndex.Property.endDate.name(), (Object)date));
        query.getCriteria().getOrders().put(WorklogIndex.Property.endDate.name(), SortOrder.DESC);
        List indexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return indexes.size() > 0 ? ((WorklogIndex)indexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getRecentCashierAccountantWorklog(EntityReference<Cash> cash, Date date) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cash.name(), cash));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)WorklogIndex.Property.endDate.name(), (Object)date));
        query.getCriteria().getOrders().put(WorklogIndex.Property.endDate.name(), SortOrder.DESC);
        List indexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return indexes.size() > 0 ? ((WorklogIndex)indexes.get(0)).getSource() : null;
    }

    public static EntityReference<Worklog> getRecentEmployeeWorklog(EntityReference<Person> employee, Date date) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.employee.name(), employee));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)WorklogIndex.Property.endDate.name(), (Object)date));
        query.getCriteria().getOrders().put(WorklogIndex.Property.endDate.name(), SortOrder.DESC);
        List indexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return indexes.size() > 0 ? ((WorklogIndex)indexes.get(0)).getSource() : null;
    }

    public static String toString(Worklog worklog) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("employee -> " + worklog.getEmployee());
        stringBuilder.append("\n");
        stringBuilder.append("types -> " + worklog.getTypes().stream().map(item -> item.name()).collect(Collectors.joining(", ")));
        stringBuilder.append("\n");
        stringBuilder.append("agency -> " + worklog.getAgency());
        stringBuilder.append("\n");
        stringBuilder.append("salesPoint -> " + worklog.getSalesPoint());
        stringBuilder.append("\n");
        stringBuilder.append("cash -> " + worklog.getCash());
        stringBuilder.append("\n");
        stringBuilder.append("cashRegister -> " + worklog.getCashRegister());
        stringBuilder.append("\n");
        stringBuilder.append("cashRegisterWorkplace -> " + worklog.getCashRegisterWorkplace());
        stringBuilder.append("\n");
        stringBuilder.append("startDate -> " + DebugUtil.toString((Date)worklog.getStartDate()));
        stringBuilder.append("\n");
        stringBuilder.append("endDate -> " + DebugUtil.toString((Date)worklog.getEndDate()));
        return stringBuilder.toString();
    }
}

