/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.model.helpers.util.CachingShaper;
import org.junit.Assert;
import org.junit.Test;

public class CachingShaperTest {
    @Test
    public void testInit() {
        long ttl = 5000L;
        CachingShaper t = new CachingShaper(2, ttl);
        Assert.assertTrue((boolean)t.init("key1"));
        CachingShaper.E entry1 = t.map.get("key1");
        Assert.assertEquals((Object)((Object)CachingShaper.S.IN_PROGRESS), (Object)((Object)entry1.state));
        Assert.assertEquals((long)1L, (long)entry1.getScore());
        ttl = 5000L;
        t = new CachingShaper(2, ttl);
        t.map.put("key1", this.newEntry(t.newEntry(), "value1", CachingShaper.S.EXPIRED, 1000));
        Assert.assertTrue((boolean)t.init("key1"));
        entry1 = t.map.get("key1");
        Assert.assertEquals((Object)((Object)CachingShaper.S.IN_PROGRESS), (Object)((Object)entry1.state));
        Assert.assertEquals((long)1001L, (long)entry1.getScore());
        ttl = 5000L;
        t = new CachingShaper(2, ttl);
        t.map.put("key1", this.newEntry(t.newEntry(), "value1", CachingShaper.S.IN_PROGRESS, 10));
        Assert.assertFalse((boolean)t.init("key1"));
        entry1 = t.map.get("key1");
        Assert.assertEquals((Object)((Object)CachingShaper.S.IN_PROGRESS), (Object)((Object)entry1.state));
        Assert.assertEquals((long)11L, (long)entry1.getScore());
    }

    @Test
    public void testWaitFor() {
        long ttl = 5000L;
        final CachingShaper t = new CachingShaper(2, ttl);
        String value1 = (String)t.get("key1", 0L);
        Assert.assertNull((Object)value1);
        CachingShaper.E entry1 = t.map.get("key1");
        Assert.assertEquals((Object)((Object)CachingShaper.S.IN_PROGRESS), (Object)((Object)entry1.state));
        Assert.assertEquals((long)1L, (long)entry1.getScore());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                t.put("key1", "value1");
            }
        }).start();
        String value = (String)t.get("key1", 5000L);
        Assert.assertEquals((Object)"value1", (Object)value);
        ttl = 5000L;
        t = new CachingShaper(2, ttl);
        value1 = (String)t.get("key1", 0L);
        Assert.assertNull((Object)value1);
        entry1 = t.map.get("key1");
        Assert.assertEquals((Object)((Object)CachingShaper.S.IN_PROGRESS), (Object)((Object)entry1.state));
        Assert.assertEquals((long)1L, (long)entry1.getScore());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                t.put("key1", "value1");
            }
        });
        thread.start();
        String value2 = (String)t.get("key1", 500L);
        Assert.assertNull((Object)value2);
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testPut() {
        long ttl = 5000L;
        CachingShaper<String, String> t = new CachingShaper<String, String>(2, ttl);
        t.put("key1", "value1");
        Assert.assertEquals((long)1L, (long)t.map.size());
        CachingShaper.E entry1 = t.map.get("key1");
        Assert.assertEquals((Object)"value1", entry1.value);
        Assert.assertEquals((Object)((Object)CachingShaper.S.ACTUAL), (Object)((Object)entry1.state));
        t.put("key2", "value2");
        Assert.assertEquals((long)2L, (long)t.map.size());
        entry1.state = CachingShaper.S.EXPIRED;
        t.put("key3", "value3");
        Assert.assertEquals((long)2L, (long)t.map.size());
        CachingShaper.E entry2 = t.map.get("key2");
        Assert.assertEquals((Object)((Object)CachingShaper.S.ACTUAL), (Object)((Object)entry2.state));
        CachingShaper.E entry3 = t.map.get("key3");
        Assert.assertEquals((Object)((Object)CachingShaper.S.ACTUAL), (Object)((Object)entry3.state));
    }

    @Test
    public void testFreeSpace() {
        long ttl = 5000L;
        CachingShaper t = new CachingShaper(3, ttl);
        t.map.put("key1", this.newEntry(t.newEntry(), "value1", CachingShaper.S.EXPIRED, 1000));
        t.map.put("key2", this.newEntry(t.newEntry(), "value2", CachingShaper.S.EXPIRED, 1000));
        t.map.put("key3", this.newEntry(t.newEntry(), "value3", CachingShaper.S.ACTUAL, 30));
        t.map.put("key4", this.newEntry(t.newEntry(), "value4", CachingShaper.S.ACTUAL, 20));
        t.map.put("key5", this.newEntry(t.newEntry(), "value5", CachingShaper.S.ACTUAL, 10));
        t.map.put("key6", this.newEntry(t.newEntry(), "value6", CachingShaper.S.IN_PROGRESS, 0));
        t.freeSpace();
        Assert.assertEquals((long)2L, (long)t.map.size());
        Assert.assertNotNull((Object)t.map.get("key3"));
        Assert.assertNotNull((Object)t.map.get("key6"));
    }

    private CachingShaper.E newEntry(CachingShaper.E result, String value, CachingShaper.S state, int score) {
        result.state = state;
        result.value = value;
        result.expiration = 0L;
        result.score.set(score);
        return result;
    }
}

