/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.model.helpers.util.CardVendorUtils;
import com.gridnine.xtrip.common.model.system.CardVendor;
import org.junit.Assert;
import org.junit.Test;

public class CardVendorUtilsTest {
    @Test
    public void determineVisaCard() {
        String cardNumber = "410293******0293";
        CardVendor determinedVendor = CardVendorUtils.determineCardIssuer(cardNumber);
        Assert.assertEquals((Object)CardVendor.VISA, (Object)determinedVendor);
    }

    @Test
    public void determineMirCard() {
        String cardNumber = "220220******2815";
        CardVendor determinedVendor = CardVendorUtils.determineCardIssuer(cardNumber);
        Assert.assertEquals((Object)CardVendor.MIR, (Object)determinedVendor);
    }

    @Test
    public void determineMastercardCard() {
        String cardNumberBankingCategory = "5287********4319";
        String cardNumberAirlinesCategory = "224912******6538";
        CardVendor determinedVendorBanking = CardVendorUtils.determineCardIssuer(cardNumberBankingCategory);
        CardVendor determinedVendorAirlines = CardVendorUtils.determineCardIssuer(cardNumberAirlinesCategory);
        Assert.assertEquals((Object)CardVendor.MASTERCARD, (Object)determinedVendorBanking);
        Assert.assertEquals((Object)CardVendor.MASTERCARD, (Object)determinedVendorAirlines);
    }

    @Test
    public void determineUnknownCard() {
        String cardNumberZeroCategory = "920220******2815";
        String cardNumberExistingCategory = "591234******0123";
        CardVendor determinedVendorZeroCategory = CardVendorUtils.determineCardIssuer(cardNumberZeroCategory);
        CardVendor determinedVendorExistingCategory = CardVendorUtils.determineCardIssuer(cardNumberExistingCategory);
        Assert.assertNull((Object)determinedVendorZeroCategory);
        Assert.assertNull((Object)determinedVendorExistingCategory);
    }

    @Test
    public void isDinersClubCard() {
        String cardNumber = "3612******8014";
        String cardNumberWrong = "1234********5678";
        int digitsIIN = Integer.parseInt(cardNumber.substring(0, 4));
        int digitsWrongIIN = Integer.parseInt(cardNumberWrong.substring(0, 4));
        boolean isDinersClub = CardVendorUtils.isDinersClub(digitsIIN);
        boolean isDinersClubWrong = CardVendorUtils.isDinersClub(digitsWrongIIN);
        Assert.assertTrue((boolean)isDinersClub);
        Assert.assertFalse((boolean)isDinersClubWrong);
    }

    @Test
    public void isAmexCard() {
        String cardNumber = "348796*****1501";
        String cardNumberWrong = "1234********5678";
        int digitsIIN = Integer.parseInt(cardNumber.substring(0, 4));
        int digitsWrongIIN = Integer.parseInt(cardNumberWrong.substring(0, 4));
        boolean isAmex = CardVendorUtils.isAmex(digitsIIN);
        boolean isAmexWrong = CardVendorUtils.isAmex(digitsWrongIIN);
        Assert.assertTrue((boolean)isAmex);
        Assert.assertFalse((boolean)isAmexWrong);
    }

    @Test
    public void isJcbCard() {
        String cardNumber = "3541********3651";
        String cardNumberWrong = "1234********5678";
        int digitsIIN = Integer.parseInt(cardNumber.substring(0, 4));
        int digitsWrongIIN = Integer.parseInt(cardNumberWrong.substring(0, 4));
        boolean isJcb = CardVendorUtils.isJcb(digitsIIN);
        boolean isJcbWrong = CardVendorUtils.isJcb(digitsWrongIIN);
        Assert.assertTrue((boolean)isJcb);
        Assert.assertFalse((boolean)isJcbWrong);
    }
}

